/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.cabrillo.tracker.OffsetOrigin;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;

public class OffsetOriginStep
extends Step {
    private OffsetOrigin offset;
    private Position p;
    protected double worldX;
    protected double worldY;

    public OffsetOriginStep(OffsetOrigin track, int n, double x, double y) {
        super(track, n);
        this.offset = track;
        this.screenPoints = new Point[OffsetOriginStep.getLength()];
        this.points = new TPoint[OffsetOriginStep.getLength()];
        this.p = new Position(x, y);
        this.points[0] = this.p;
    }

    public Position getPosition() {
        return this.p;
    }

    public void setWorldXY(double x, double y) {
        if (this.getTrack().isLocked()) {
            return;
        }
        if (this.offset.isFixedCoordinates()) {
            OffsetOriginStep step = (OffsetOriginStep)this.offset.steps.getStep(0);
            step.worldX = x;
            step.worldY = y;
            step.erase();
            this.offset.refreshStep(this);
        } else {
            this.worldX = x;
            this.worldY = y;
            this.offset.keyFrames.add(this.n);
        }
        if (this.offset.tp == null) {
            return;
        }
        ImageCoordSystem coords = this.offset.tp.getCoords();
        int n = this.offset.tp.getFrameNumber();
        double x0 = coords.getOriginX(n);
        double y0 = coords.getOriginY(n);
        double x1 = coords.worldToImageX(n, x, y);
        double y1 = coords.worldToImageY(n, x, y);
        coords.setOriginXY(n, x0 + this.p.x - x1, y0 + this.p.y - y1);
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = (Mark)this.panelMarks.get(trackerPanel.getID());
        TPoint selection = null;
        if (mark == null) {
            MultiShape shape;
            ImageCoordSystem coords = trackerPanel.getCoords();
            int n = trackerPanel.getFrameNumber();
            double x = coords.worldToImageX(n, this.worldX, this.worldY);
            double y = coords.worldToImageY(n, this.worldX, this.worldY);
            this.p.setLocation(x, y);
            selection = trackerPanel.getSelectedPoint();
            Point pt = this.points[0].getScreenPosition(trackerPanel);
            if (selection == this.points[0]) {
                transform.setToTranslation(pt.x, pt.y);
                int scale = FontSizer.getIntegerFactor();
                if (scale > 1) {
                    transform.scale(scale, scale);
                }
                shape = new MultiShape(transform.createTransformedShape(selectionShape)).andStroke(selectionStroke);
            } else {
                shape = this.footprint.getShape(new Point[]{pt}, FontSizer.getIntegerFactor());
            }
            final Color color = this.footprint.getColor();
            mark = new Mark(){

                @Override
                public void draw(Graphics2D g, boolean highlighted) {
                    Paint gpaint = g.getPaint();
                    if (OSPRuntime.setRenderingHints) {
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    }
                    g.setPaint(color);
                    shape.draw(g);
                    g.setPaint(gpaint);
                }
            };
            this.panelMarks.put(trackerPanel.getID(), mark);
        }
        return mark;
    }

    @Override
    public Object clone() {
        OffsetOriginStep step = (OffsetOriginStep)super.clone();
        TPoint[] tPointArray = step.points;
        OffsetOriginStep offsetOriginStep = step;
        offsetOriginStep.getClass();
        step.p = offsetOriginStep.new Position(this.p.x, this.p.y);
        tPointArray[0] = step.p;
        return step;
    }

    @Override
    public String toString() {
        String s = "Offset Origin Step " + this.n + " [" + format.format(this.worldX) + ", " + format.format(this.worldY) + "]";
        return s;
    }

    public class Position
    extends TPoint {
        public Position(double x, double y) {
            super.setXY(x, y);
            this.setCoordsEditTrigger(true);
            if (((OffsetOriginStep)OffsetOriginStep.this).offset.tp == null) {
                return;
            }
            ImageCoordSystem coords = ((OffsetOriginStep)OffsetOriginStep.this).offset.tp.getCoords();
            int n = ((OffsetOriginStep)OffsetOriginStep.this).offset.tp.getFrameNumber();
            OffsetOriginStep.this.worldX = coords.imageToWorldX(n, x, y);
            OffsetOriginStep.this.worldY = coords.imageToWorldY(n, x, y);
        }

        @Override
        public void setXY(double x, double y) {
            if (OffsetOriginStep.this.getTrack().isLocked()) {
                return;
            }
            if (this.isAdjusting()) {
                this.prevX = x;
                this.prevY = y;
            }
            double dx = x - this.getX();
            double dy = y - this.getY();
            super.setXY(x, y);
            if (((OffsetOriginStep)OffsetOriginStep.this).offset.tp == null) {
                return;
            }
            ImageCoordSystem coords = ((OffsetOriginStep)OffsetOriginStep.this).offset.tp.getCoords();
            coords.setAdjusting(this.isAdjusting());
            int n = ((OffsetOriginStep)OffsetOriginStep.this).offset.tp.getFrameNumber();
            double x0 = coords.getOriginX(n);
            double y0 = coords.getOriginY(n);
            coords.setOriginXY(n, x0 + dx, y0 + dy);
            if (this.isAdjusting()) {
                OffsetOriginStep.this.repaint();
            }
        }

        @Override
        public void setAdjusting(boolean adjusting, MouseEvent e) {
            boolean wasAdjusting = this.isAdjusting();
            super.setAdjusting(adjusting, e);
            if (wasAdjusting && !adjusting && !Double.isNaN(this.prevX)) {
                this.setXY(this.prevX, this.prevY);
                OffsetOriginStep.this.getTrack().firePropertyChange("step", null, OffsetOriginStep.this.n);
            }
        }

        @Override
        public void showCoordinates(VideoPanel vidPanel) {
            ((OffsetOriginStep)OffsetOriginStep.this).offset.xField.setValue(OffsetOriginStep.this.worldX);
            ((OffsetOriginStep)OffsetOriginStep.this).offset.yField.setValue(OffsetOriginStep.this.worldY);
            super.showCoordinates(vidPanel);
        }
    }
}

