/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Shape;
import org.opensourcephysics.cabrillo.tracker.LineFootprint;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.cabrillo.tracker.ShapeIcon;
import org.opensourcephysics.display.ResizableIcon;

public class OutlineFootprint
extends LineFootprint {
    private int spread;

    public OutlineFootprint(String name) {
        super(name);
        this.setStroke(this.baseStroke);
    }

    public void setSpread(int spread) {
        this.spread = spread;
    }

    public int getSpread() {
        return this.spread;
    }

    @Override
    public ResizableIcon getIcon(int w, int h) {
        Point[] points = new Point[]{new Point(), new Point(w - 2, 2 - h)};
        int prevSpread = this.spread;
        this.spread = 1;
        MultiShape shape = this.getShape(points, 1);
        ShapeIcon icon = new ShapeIcon(shape, w, h);
        icon.setColor(this.color);
        this.spread = prevSpread;
        return new ResizableIcon(icon);
    }

    @Override
    public void setStroke(BasicStroke stroke) {
        super.setStroke(stroke);
    }

    @Override
    public MultiShape getShape(Point[] points, int scale) {
        Point p1 = points[0];
        Point p2 = points[1];
        double theta = Math.atan2(p1.y - p2.y, p1.x - p2.x);
        this.transform.setToRotation(theta, p2.x, p2.y);
        this.transform.translate(p2.x, p2.y);
        float d = (float)p1.distance(p2);
        this.path.reset();
        this.path.moveTo(0.0f, -1 - this.spread);
        this.path.lineTo(0.0f, 1 + this.spread);
        this.path.lineTo(d, 1 + this.spread);
        this.path.lineTo(d, -1 - this.spread);
        this.path.closePath();
        int w = Math.min(this.spread + 1, 4);
        this.path.moveTo(d / 2.0f, w);
        this.path.lineTo(d / 2.0f, -w);
        if (this.getSpread() > 4 + 2 * scale) {
            this.path.moveTo(0.0f, 0.0f);
            this.path.lineTo(d, 0.0f);
        }
        Shape outline = this.transform.createTransformedShape(this.path);
        float lineWidth = Math.min((float)scale * this.baseStroke.getLineWidth(), (float)(this.spread + 1));
        lineWidth = Math.max(lineWidth, this.baseStroke.getLineWidth());
        if (this.stroke == null || this.stroke.getLineWidth() != lineWidth) {
            this.stroke = new BasicStroke(lineWidth);
        }
        this.path.reset();
        this.path.moveTo(d, -1 - this.spread);
        this.path.lineTo(d, 1 + this.spread);
        this.hitShapes[0] = this.transform.createTransformedShape(this.path);
        this.path.reset();
        this.path.moveTo(0.0f, -1 - this.spread);
        this.path.lineTo(0.0f, 1 + this.spread);
        this.hitShapes[1] = this.transform.createTransformedShape(this.path);
        float f = 0.45f;
        this.path.reset();
        this.path.moveTo(d * (0.5f + f), 0.0f);
        this.path.lineTo(d * (0.5f - f), 0.0f);
        this.hitShapes[2] = this.transform.createTransformedShape(this.path);
        return new MultiShape(outline).andStroke(this.stroke);
    }
}

