/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javajs.async.AsyncFileChooser;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.LaunchBuilder;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class PageTView
extends TView {
    protected static final Icon PAGEVIEW_ICON = Tracker.getResourceIcon("html.gif", true);
    protected ArrayList<TabView> tabs = new ArrayList();
    protected JTabbedPane tabbedPane;
    protected JButton pageButton;
    protected JDialog nameDialog;
    protected JTextField nameField;
    protected JPanel noTab;
    protected JLabel noTabLabel;
    protected JLabel tabTitleLabel;
    protected Box.Filler filler = (Box.Filler)Box.createHorizontalGlue();
    protected Border titleBorder;
    protected boolean locked;

    static {
        XML.setLoader(TabView.class, new TabLoader());
    }

    protected PageTView(TrackerPanel panel) {
        super(panel);
        this.setBackground(panel.getBackground());
        this.createGUI();
        this.refresh();
    }

    @Override
    public void refresh() {
        this.refreshTabs();
        this.removeAll();
        this.pageButton.setText(TrackerRes.getString("PageTView.Button.Page"));
        if (this.tabs.isEmpty()) {
            this.noTabLabel.setText(TrackerRes.getString("TextTView.Label.NoTab"));
            this.add((Component)this.noTab, "Center");
        } else if (this.tabs.size() == 1) {
            this.add((Component)this.tabs.get(0), "Center");
        } else {
            this.add((Component)this.tabbedPane, "Center");
        }
        FontSizer.setFonts(this);
        this.validate();
        TFrame.repaintT(this);
    }

    @Override
    public void init() {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void dispose() {
        for (TabView tab : this.tabs) {
            tab.data.panelID = null;
            tab.data.frame = null;
        }
        if (this.tabbedPane == null) {
            return;
        }
        this.tabbedPane.removeAll();
        this.frame = null;
        this.panelID = null;
    }

    @Override
    public TrackerPanel getTrackerPanel() {
        return this.frame.getTrackerPanelForID(this.panelID);
    }

    @Override
    public String getViewName() {
        return TrackerRes.getString("TFrame.View.Text");
    }

    @Override
    public Icon getViewIcon() {
        return PAGEVIEW_ICON;
    }

    @Override
    public int getViewType() {
        return 3;
    }

    @Override
    public boolean isCustomState() {
        return this.tabs.size() > 0;
    }

    public void addTab(TabView tab) {
        this.tabs.add(tab);
        if (this.panelID != null) {
            this.frame.getTrackerPanelForID((Integer)this.panelID).changed = true;
        }
        this.refresh();
    }

    public void removeTab(TabView tab) {
        this.tabs.remove(tab);
        if (this.panelID != null) {
            this.frame.getTrackerPanelForID((Integer)this.panelID).changed = true;
        }
        this.refresh();
    }

    public void renameTab(TabView tab) {
        this.nameDialog = this.getNameDialog();
        this.nameDialog.setTitle(TrackerRes.getString("TextTView.Dialog.TabTitle.Title"));
        this.nameField.setText(tab.data.title);
        this.nameField.setBackground(Color.white);
        this.nameField.selectAll();
        this.nameDialog.pack();
        Point p = this.getLocationOnScreen();
        p.x += (this.getWidth() - this.nameDialog.getWidth()) / 2;
        p.y -= this.pageButton.getHeight();
        this.nameDialog.setLocation(p);
        this.nameDialog.setVisible(true);
    }

    public TabView getSelectedTab() {
        TabView tab = (TabView)this.tabbedPane.getSelectedComponent();
        if (tab == null && !this.tabs.isEmpty()) {
            tab = this.tabs.get(0);
        }
        return tab;
    }

    public void setSelectedTab(TabView tab) {
        if (this.tabs.size() > 1) {
            this.tabbedPane.setSelectedComponent(tab);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
    }

    protected void createGUI() {
        this.setPreferredSize(new Dimension(400, 200));
        this.setLayout(new BorderLayout());
        final TrackerPanel panel = this.frame.getTrackerPanelForID(this.panelID);
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setBackground(panel.getBackground());
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PageTView.this.refreshTitle();
            }
        });
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PageTView.this.tabbedPane.requestFocusInWindow();
                if (OSPRuntime.isPopupTrigger(e)) {
                    JPopupMenu popup = PageTView.this.getPopup(PageTView.this.getSelectedTab());
                    popup.show(PageTView.this.tabbedPane, e.getX(), e.getY());
                } else if (e.getClickCount() == 2 && !PageTView.this.locked && panel.isEnabled("pageView.edit")) {
                    PageTView.this.renameTab(PageTView.this.getSelectedTab());
                }
            }
        });
        this.pageButton = new TButton(){

            @Override
            public Dimension getMaximumSize() {
                return TViewChooser.getButtonMaxSize(this, super.getMaximumSize(), this.getMinimumSize().height);
            }

            @Override
            public JPopupMenu getPopup() {
                JPopupMenu popup = new JPopupMenu();
                if (!panel.isEnabled("pageView.edit")) {
                    JMenuItem item = new JMenuItem(TrackerRes.getString("TTrack.MenuItem.Locked"));
                    item.setEnabled(false);
                    popup.add(item);
                    FontSizer.setFonts(popup, FontSizer.getLevel());
                    return popup;
                }
                JMenuItem item = new JMenuItem(TrackerRes.getString("TextTView.Button.NewTab"));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TabView tab = new TabView(new TabData());
                        int n = (this).PageTView.this.tabs.size() + 1;
                        if (n > 1) {
                            tab.data.title = String.valueOf(tab.data.title) + " " + n;
                        }
                        PageTView.this.addTab(tab);
                        PageTView.this.setSelectedTab(tab);
                    }
                });
                item.setEnabled(!PageTView.this.locked);
                popup.add(item);
                item = new JMenuItem(TrackerRes.getString("TextTView.MenuItem.OpenHTML"));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        final AsyncFileChooser chooser = OSPRuntime.getChooser();
                        chooser.setFileFilter(LaunchBuilder.getHTMLFilter());
                        chooser.showOpenDialog(panel, new Runnable(){

                            @Override
                            public void run() {
                                File file = chooser.getSelectedFile();
                                TabView tab = PageTView.this.getSelectedTab();
                                if (tab == null) {
                                    tab = new TabView(new TabData());
                                    PageTView.this.addTab(tab);
                                }
                                tab.setUndoableText(XML.getAbsolutePath(file));
                                PageTView.this.refresh();
                                OSPRuntime.chooserDir = XML.getDirectoryPath(file.getPath());
                            }
                        }, null);
                    }
                });
                item.setEnabled(!PageTView.this.locked);
                popup.add(item);
                popup.addSeparator();
                item = new JRadioButtonMenuItem(TrackerRes.getString("TTrack.MenuItem.Locked"));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JMenuItem item = (JMenuItem)e.getSource();
                        (this).PageTView.this.locked = item.isSelected();
                    }
                });
                item.setSelected(PageTView.this.locked);
                popup.add(item);
                FontSizer.setFonts(popup, FontSizer.getLevel());
                return popup;
            }
        };
        this.pageButton.setIcon(TViewChooser.DOWN_ARROW_ICON);
        this.pageButton.setHorizontalTextPosition(10);
        this.tabTitleLabel = new JLabel();
        this.tabTitleLabel.setOpaque(false);
        this.tabTitleLabel.setForeground(Color.BLUE.darker());
        this.tabTitleLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if ("".equals(PageTView.this.tabTitleLabel.getText())) {
                    return;
                }
                PageTView.this.tabTitleLabel.requestFocusInWindow();
                if (OSPRuntime.isPopupTrigger(e)) {
                    JPopupMenu popup = PageTView.this.getPopup(PageTView.this.getSelectedTab());
                    popup.show(PageTView.this.tabTitleLabel, e.getX(), e.getY());
                } else if (e.getClickCount() == 2 && !PageTView.this.locked && panel.isEnabled("pageView.edit")) {
                    PageTView.this.renameTab(PageTView.this.getSelectedTab());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!PageTView.this.locked && panel.isEnabled("pageView.edit")) {
                    PageTView.this.tabTitleLabel.setBorder(PageTView.this.titleBorder);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PageTView.this.tabTitleLabel.setBorder(null);
            }
        });
        Border empty = BorderFactory.createEmptyBorder(0, 2, 1, 2);
        Border line = BorderFactory.createLineBorder(this.tabTitleLabel.getForeground());
        this.titleBorder = BorderFactory.createCompoundBorder(line, empty);
        this.toolbarComponents.add(this.pageButton);
        this.toolbarComponents.add(this.filler);
        this.toolbarComponents.add(this.tabTitleLabel);
        this.noTab = new JPanel(new BorderLayout());
        this.noTabLabel = new JLabel();
        this.noTabLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 0));
        Font font = new JTextField().getFont();
        this.noTabLabel.setFont(font);
        this.noTab.add((Component)this.noTabLabel, "North");
        this.noTab.setBackground(this.getBackground());
        this.noTab.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (OSPRuntime.isPopupTrigger(e)) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem helpItem = new JMenuItem(String.valueOf(TrackerRes.getString("Dialog.Button.Help")) + "...");
                    helpItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            (this).PageTView.this.frame.showHelp("pageview", 0);
                        }
                    });
                    popup.add(helpItem);
                    FontSizer.setFonts(popup, FontSizer.getLevel());
                    popup.show(PageTView.this.noTab, e.getX(), e.getY());
                }
            }
        });
    }

    protected void refreshTabs() {
        TabView prev = this.getSelectedTab();
        this.tabbedPane.removeAll();
        boolean refreshToolbar = false;
        for (TabView tab : this.tabs) {
            tab.pageView = this;
            tab.data.frame = this.frame;
            tab.data.panelID = this.panelID;
            tab.refreshView(false);
            this.tabbedPane.addTab(tab.data.title, tab);
            boolean bl = refreshToolbar = refreshToolbar || tab.data.url != null;
        }
        if (prev != null && this.tabbedPane.indexOfComponent(prev) > -1) {
            this.tabbedPane.setSelectedComponent(prev);
        }
        this.refreshTitle();
        if (this.panelID != null && refreshToolbar) {
            this.frame.getToolBar(this.panelID, true).refresh("PageTView.tabs");
        }
    }

    protected void refreshTitle() {
        TabView tab = this.getSelectedTab();
        this.tabTitleLabel.setText(tab == null ? null : tab.data.title);
    }

    protected JPopupMenu getPopup(final TabView tab) {
        JPopupMenu popup = new JPopupMenu();
        String s = null;
        final TrackerPanel panel = this.frame.getTrackerPanelForID(this.panelID);
        if (panel.isEnabled("pageView.edit")) {
            int keyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            JMenuItem renameItem = new JMenuItem(TrackerRes.getString("TextTView.MenuItem.SetTitle"));
            renameItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PageTView.this.renameTab(tab);
                }
            });
            renameItem.setEnabled(!this.locked);
            popup.add(renameItem);
            JMenuItem openItem = new JMenuItem(TrackerRes.getString("TextTView.MenuItem.OpenHTML"));
            openItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final AsyncFileChooser chooser = OSPRuntime.getChooser();
                    chooser.setFileFilter(LaunchBuilder.getHTMLFilter());
                    chooser.showOpenDialog(panel, new Runnable(){

                        @Override
                        public void run() {
                            File file = chooser.getSelectedFile();
                            tab.setUndoableText(XML.getAbsolutePath(file));
                            PageTView.this.refresh();
                            OSPRuntime.chooserDir = XML.getDirectoryPath(file.getPath());
                        }
                    }, null);
                }
            });
            openItem.setEnabled(!this.locked);
            popup.add(openItem);
            popup.addSeparator();
            s = String.valueOf(TrackerRes.getString("PageTView.MenuItem.ClosePage")) + " \"";
            s = String.valueOf(s) + tab.data.title + "\"";
            JMenuItem closeItem = new JMenuItem(s);
            closeItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PageTView.this.removeTab(tab);
                }
            });
            closeItem.setEnabled(!this.locked);
            popup.add(closeItem);
            if (tab.data.url != null) {
                s = TrackerRes.getString("PageTView.MenuItem.OpenInBrowser");
                JMenuItem item = new JMenuItem(s);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        OSPDesktop.displayURL(tab.data.url.toExternalForm());
                    }
                });
                popup.add(item);
            }
            if (tab.undoManager.canUndoOrRedo()) {
                popup.addSeparator();
                if (tab.undoManager.canUndo()) {
                    s = String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.Undo")) + " ";
                    s = String.valueOf(s) + TrackerRes.getString("TextTView.TextEdit.Description");
                    JMenuItem undoItem = new JMenuItem(s);
                    undoItem.setAccelerator(KeyStroke.getKeyStroke(90, keyMask));
                    undoItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            tab.undoManager.undo();
                        }
                    });
                    undoItem.setEnabled(!this.locked);
                    popup.add(undoItem);
                }
                if (tab.undoManager.canRedo()) {
                    s = String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.Redo")) + " ";
                    s = String.valueOf(s) + TrackerRes.getString("TextTView.TextEdit.Description");
                    JMenuItem redoItem = new JMenuItem(s);
                    redoItem.setAccelerator(KeyStroke.getKeyStroke(89, keyMask));
                    redoItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            tab.undoManager.redo();
                        }
                    });
                    redoItem.setEnabled(!this.locked);
                    popup.add(redoItem);
                }
            }
            popup.addSeparator();
        }
        s = String.valueOf(TrackerRes.getString("Dialog.Button.Help")) + "...";
        JMenuItem helpItem = new JMenuItem(s);
        helpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PageTView.this.frame.showHelp("pageview", 0);
            }
        });
        popup.add(helpItem);
        FontSizer.setFonts(popup, FontSizer.getLevel());
        return popup;
    }

    protected JDialog getNameDialog() {
        if (this.nameDialog == null) {
            this.nameField = new JTextField(20);
            this.nameField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabView tab = PageTView.this.getSelectedTab();
                    tab.data.setTitle(PageTView.this.nameField.getText());
                    PageTView.this.refresh();
                    PageTView.this.nameDialog.setVisible(false);
                }
            });
            this.nameField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    PageTView.this.nameField.setBackground(Color.yellow);
                }
            });
            JToolBar bar = new JToolBar();
            bar.setFloatable(false);
            bar.add(this.nameField);
            JPanel contentPane = new JPanel(new BorderLayout());
            contentPane.add((Component)bar, "Center");
            this.nameDialog = new JDialog(JOptionPane.getFrameForComponent(this), true);
            this.nameDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    TabView tab = PageTView.this.getSelectedTab();
                    tab.data.setTitle(PageTView.this.nameField.getText());
                    PageTView.this.refresh();
                }
            });
            this.nameDialog.setContentPane(contentPane);
            this.nameDialog.pack();
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - this.nameDialog.getBounds().width) / 2;
            int y = (dim.height - this.nameDialog.getBounds().height) / 2;
            this.nameDialog.setLocation(x, y);
        }
        FontSizer.setFonts(this.nameDialog, FontSizer.getLevel());
        return this.nameDialog;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            PageTView view = (PageTView)obj;
            control.setValue("tabs", view.tabs);
            control.setValue("locked", view.locked);
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            PageTView view = (PageTView)obj;
            view.locked = control.getBoolean("locked");
            ArrayList tabs = (ArrayList)ArrayList.class.cast(control.getObject("tabs"));
            if (tabs != null) {
                Iterator it = tabs.iterator();
                while (it.hasNext()) {
                    view.addTab((TabView)it.next());
                }
            }
            return obj;
        }
    }

    public static class TabData {
        public Integer panelID;
        public TFrame frame;
        String title;
        boolean hyperlinksEnabled = true;
        String text;
        URL url;

        TabData() {
            this.text = TrackerRes.getString("TextTView.NewTab.Text1");
            this.text = String.valueOf(this.text) + XML.NEW_LINE + XML.NEW_LINE;
            this.text = String.valueOf(this.text) + TrackerRes.getString("TextTView.NewTab.Text2");
            this.title = TrackerRes.getString("TextTView.NewTab.Title");
        }

        TabData(String title, String text) {
            this.title = title;
            this.setText(text);
        }

        public void setTitle(String title) {
            if (title == null) {
                return;
            }
            this.title = title;
            if (this.panelID != null) {
                TrackerPanel panel = this.frame.getTrackerPanelForID(this.panelID);
                panel.changed = true;
                panel.getToolBar(true).refresh("PageTView.title");
            }
        }

        public void setText(String text) {
            if (text == null) {
                return;
            }
            this.text = text;
            this.setURL(text);
        }

        public URL getURL() {
            if (this.url == null) {
                this.setURL(this.text);
            }
            return this.url;
        }

        private void setURL(String path) {
            this.url = null;
            Resource res = ResourceLoader.getResource(path);
            if (res != null && res.getURL() != null) {
                this.url = res.getURL();
                try {
                    InputStream in = ResourceLoader.openStream(this.url);
                    in.close();
                }
                catch (Exception ex) {
                    this.url = null;
                }
            }
            if (this.panelID != null) {
                TrackerPanel panel = this.frame.getTrackerPanelForID(this.panelID);
                panel.changed = true;
                panel.getToolBar(true).refresh("PageTView.url");
            }
        }
    }

    static class TabLoader
    implements XML.ObjectLoader {
        TabLoader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            TabView tab = (TabView)obj;
            TabData data = tab.data;
            control.setValue("title", data.title);
            if (data.url == null) {
                control.setValue("text", data.text);
            } else if (data.url.getProtocol().equals("file")) {
                File file = data.frame.getTrackerPanelForID(data.panelID).getDataFile();
                if (file != null) {
                    String path = data.url.getFile();
                    while (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    String base = XML.getDirectoryPath(XML.getAbsolutePath(file));
                    control.setValue("text", XML.getPathRelativeTo(path, base));
                } else {
                    control.setValue("text", data.url.toExternalForm());
                }
            } else {
                control.setValue("text", data.url.toExternalForm());
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            String title = control.getString("title");
            String text = control.getString("text");
            return new TabView(new TabData(title, text));
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            return obj;
        }
    }

    public static class TabView
    extends JPanel {
        protected TabData data;
        protected JEditorPane displayPane;
        protected JEditorPane editorPane;
        protected JScrollPane scroller;
        protected PageTView pageView;
        protected UndoableEditSupport undoSupport;
        protected UndoManager undoManager;
        protected HyperlinkListener hyperlinkListener;

        TabView(TabData tab) {
            super(new BorderLayout());
            this.data = tab;
            class TextView
            extends JTextPane {
                TextView() {
                }

                @Override
                public void paintComponent(Graphics g) {
                    if (OSPRuntime.antiAliasText) {
                        Graphics2D g2 = (Graphics2D)g;
                        RenderingHints rh = g2.getRenderingHints();
                        rh.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        rh.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    }
                    super.paintComponent(g);
                }
            }
            this.displayPane = new TextView();
            this.displayPane.setEditable(false);
            this.hyperlinkListener = new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (data.hyperlinksEnabled && e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        OSPDesktop.displayURL(e.getURL().toString());
                    }
                }
            };
            this.displayPane.addHyperlinkListener(this.hyperlinkListener);
            this.displayPane.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 90 && e.isControlDown()) {
                        if (undoManager.canUndo()) {
                            undoManager.undo();
                        }
                    } else if (e.getKeyCode() == 89 && e.isControlDown() && undoManager.canRedo()) {
                        undoManager.redo();
                    }
                }
            });
            this.displayPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (OSPRuntime.isPopupTrigger(e)) {
                        JPopupMenu popup = pageView.getPopup(pageView.getSelectedTab());
                        popup.show(displayPane, e.getX(), e.getY());
                    } else if (e.getClickCount() == 2 && !pageView.locked && pageView.frame.getTrackerPanelForID(pageView.panelID).isEnabled("pageView.edit")) {
                        editorPane.setBackground(Color.white);
                        this.refreshView(true);
                        editorPane.selectAll();
                    }
                }
            });
            this.editorPane = new TextView();
            this.editorPane.setContentType("text/plain");
            this.editorPane.setEditable(true);
            this.editorPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (OSPRuntime.isPopupTrigger(e)) {
                        JPopupMenu popup = pageView.getPopup(pageView.getSelectedTab());
                        popup.show(editorPane, e.getX(), e.getY());
                    }
                }
            });
            this.editorPane.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (editorPane.getBackground().equals(Color.yellow)) {
                        this.setUndoableText(editorPane.getText());
                    }
                    this.refreshView(false);
                }
            });
            this.editorPane.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 90 && e.isControlDown()) {
                        this.setUndoableText(editorPane.getText());
                        this.refreshView(false);
                        if (undoManager.canUndo()) {
                            undoManager.undo();
                        }
                    } else if (e.getKeyCode() == 10 && e.isShiftDown()) {
                        this.setUndoableText(editorPane.getText());
                        this.refreshView(false);
                    } else {
                        editorPane.setBackground(Color.yellow);
                    }
                }
            });
            this.scroller = new JScrollPane(this.displayPane);
            this.add((Component)this.scroller, "Center");
            this.refreshView(false);
            this.undoManager = new UndoManager();
            this.undoSupport = new UndoableEditSupport();
            this.undoSupport.addUndoableEditListener(this.undoManager);
        }

        void refreshView(boolean editing) {
            if (editing) {
                this.scroller.setViewportView(this.editorPane);
                this.editorPane.setText(this.data.text);
                this.editorPane.requestFocusInWindow();
            } else {
                this.editorPane.setBackground(Color.white);
                this.scroller.setViewportView(this.displayPane);
                if (this.data.getURL() != null) {
                    try {
                        this.displayPane.setContentType("text/html");
                        this.displayPane.setPage(this.data.url);
                        if (this.data.url.getRef() != null) {
                            this.displayPane.scrollToReference(this.data.url.getRef());
                        }
                    }
                    catch (IOException e) {
                        this.displayPane.setContentType("text/plain");
                        this.displayPane.setText(this.data.text);
                    }
                } else {
                    this.displayPane.setContentType("text/plain");
                    this.displayPane.setText(this.data.text);
                }
                this.displayPane.requestFocusInWindow();
            }
            this.revalidate();
            TFrame.repaintT(this);
        }

        void setUndoableText(String text) {
            if (text == null || text.equals(this.data.text)) {
                return;
            }
            TextEdit edit = new TextEdit(this, text, this.data.text);
            this.undoSupport.postEdit(edit);
            this.data.setText(text);
        }
    }

    protected static class TextEdit
    extends AbstractUndoableEdit {
        TabView tab;
        String text;
        String prev;

        public TextEdit(TabView tab, String newText, String prevText) {
            this.tab = tab;
            this.text = newText;
            this.prev = prevText;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.tab.data.setText(this.prev);
            this.tab.refreshView(false);
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            this.tab.data.setText(this.text);
            this.tab.refreshView(false);
        }

        @Override
        public String getPresentationName() {
            return TrackerRes.getString("TextTView.TextEdit.Description");
        }
    }
}

