/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.opensourcephysics.cabrillo.tracker.CircleFootprint;
import org.opensourcephysics.cabrillo.tracker.ClipboardListener;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.MultiLineFootprint;
import org.opensourcephysics.cabrillo.tracker.MultiPositionStep;
import org.opensourcephysics.cabrillo.tracker.ParticleDataTrackFunctionPanel;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.ReferenceFrame;
import org.opensourcephysics.cabrillo.tracker.ShapeIcon;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackProperties;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DataClip;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.DataTrack;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ResourceLoader;

public class ParticleDataTrack
extends ParticleModel
implements DataTrack {
    private static final int DATA_CHECK_ONLY = 0;
    private static final int DATA_COPY = 1;
    public static final String PROPERTY_PARTICLEDATATRACK_DATACLIP = "dataclip";
    private static String startupFootprint = "CircleFootprint.FilledCircle#5 outline";
    private DataClip dataClip;
    private DatasetManager sourceData;
    private double[] xData = new double[]{0.0};
    private double[] yData = new double[]{0.0};
    private double[] tData = new double[]{0.0};
    private int stepCounter;
    private Object dataSource;
    private boolean useDataTime;
    protected String pointName = "";
    protected String modelName = "";
    protected ArrayList<ParticleDataTrack> morePoints = new ArrayList();
    private JMenu pointsMenu;
    private JMenu linesMenu;
    private JMenu allFootprintsMenu;
    private JButton reloadButton;
    private JMenuItem allColorItem;
    private JMenuItem lineColorItem;
    protected String pendingDataString;
    protected String prevDataString;
    protected Footprint modelFootprint;
    protected Footprint[] modelFootprints = new Footprint[0];
    protected boolean modelFootprintVisible = false;
    private JCheckBoxMenuItem linesVisibleCheckbox;
    private JCheckBoxMenuItem linesClosedCheckbox;
    private JCheckBoxMenuItem linesBoldCheckbox;
    private JCheckBox autoPasteCheckbox;
    private ActionListener allFootprintsListener;
    private ActionListener allCircleFootprintsListener;
    private boolean autoPasteEnabled = false;
    private int startStep = -1;
    private int startFrameTemp = -1;
    private boolean requiresConversion;

    public ParticleDataTrack(DatasetManager data, Object source) throws Exception {
        this(source);
        this.getDataClip().addPropertyChangeListener(this);
        String name = data.getName();
        if (name == null || name.trim().equals("")) {
            name = TrackerRes.getString("ParticleDataTrack.New.Name");
        }
        name = name.replaceAll("_", " ");
        this.setName(name);
        this.setData(data);
    }

    private ParticleDataTrack(Object source) {
        this.dataSource = source;
        this.points = new Point2D.Double[]{new Point2D.Double()};
        tracePtsPerStep = 1;
        this.autoPasteEnabled = !OSPRuntime.isJS;
        this.setFootprint(startupFootprint);
        this.defaultFootprint = this.getFootprint();
        if (!(source instanceof ParticleDataTrack)) {
            this.modelFootprints = new Footprint[]{MultiLineFootprint.getFootprint("Footprint.MultiLine"), MultiLineFootprint.getFootprint("Footprint.BoldMultiLine")};
            this.modelFootprint = this.modelFootprints[0];
        }
        this.pointsMenu = new JMenu();
        this.linesMenu = new JMenu();
        this.allFootprintsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParticleDataTrack.this.doAllFoot(e.getActionCommand());
            }
        };
        this.allCircleFootprintsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParticleDataTrack.this.doAllCircle(e.getActionCommand());
            }
        };
        this.allColorItem = new JMenuItem();
        this.allColorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent de) {
                ParticleDataTrack.this.doAllColor();
            }
        });
        this.lineColorItem = new JMenuItem();
        this.lineColorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = ParticleDataTrack.this.getColor();
                OSPRuntime.chooseColor(color, TrackerRes.getString("TTrack.Dialog.Color.Title"), newColor -> {
                    if (newColor != color) {
                        XMLControlElement control = new XMLControlElement(new TrackProperties(ParticleDataTrack.this));
                        ParticleDataTrack.this.getLeader().setLineColor((Color)newColor);
                        Undo.postTrackDisplayEdit(ParticleDataTrack.this, control);
                    }
                });
            }
        });
        this.linesVisibleCheckbox = new JCheckBoxMenuItem();
        this.linesVisibleCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ParticleDataTrack.this.refreshing) {
                    return;
                }
                ParticleDataTrack.this.modelFootprintVisible = ParticleDataTrack.this.linesVisibleCheckbox.isSelected();
                ParticleDataTrack.this.erase();
                TFrame.repaintT(ParticleDataTrack.this.tp);
            }
        });
        this.linesClosedCheckbox = new JCheckBoxMenuItem();
        this.linesClosedCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ParticleDataTrack.this.refreshing) {
                    return;
                }
                Footprint f = ParticleDataTrack.this.getModelFootprint();
                if (f instanceof MultiLineFootprint) {
                    ((MultiLineFootprint)f).setClosed(ParticleDataTrack.this.linesClosedCheckbox.isSelected());
                    ParticleDataTrack.this.erase();
                    TFrame.repaintT(ParticleDataTrack.this.tp);
                }
            }
        });
        this.linesBoldCheckbox = new JCheckBoxMenuItem();
        this.linesBoldCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ParticleDataTrack.this.refreshing) {
                    return;
                }
                MultiLineFootprint mlf = (MultiLineFootprint)ParticleDataTrack.this.getModelFootprint();
                Color c = mlf.getColor();
                boolean closed = mlf.isClosed();
                if (ParticleDataTrack.this.linesBoldCheckbox.isSelected()) {
                    ParticleDataTrack.this.getLeader().setModelFootprint("Footprint.BoldMultiLine#" + closed);
                } else {
                    ParticleDataTrack.this.getLeader().setModelFootprint("Footprint.MultiLine#" + closed);
                }
                ParticleDataTrack.this.getModelFootprint().setColor(c);
                ParticleDataTrack.this.erase();
                TFrame.repaintT(ParticleDataTrack.this.tp);
            }
        });
        this.allFootprintsMenu = new JMenu();
    }

    private ParticleDataTrack(Object[] data, ParticleDataTrack parent) {
        this(parent);
        parent.morePoints.add(this);
        this.dataClip = parent.getDataClip();
        this.getDataClip().addPropertyChangeListener(this);
        this.setPointName(data[0].toString());
        this.setColor(parent.getColor());
        Footprint f = parent.getFootprint();
        String fname = f.getName();
        this.setFootprint(fname);
        if (f instanceof CircleFootprint) {
            CircleFootprint cf = (CircleFootprint)f;
            CircleFootprint cfnew = (CircleFootprint)this.getFootprint();
            cfnew.setProperties(cf.getProperties());
        }
        double[][] xyData = (double[][])data[1];
        this.setCoreData(xyData, true);
    }

    private ParticleDataTrack(double[][] coreData, ArrayList<Object[]> pointData) {
        this(null);
        this.getDataClip().addPropertyChangeListener(this);
        try {
            this.setCoreData(coreData, true);
            this.setMoreData(pointData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setMoreData(ArrayList<Object[]> pointData) {
        boolean empty = this.morePoints.isEmpty();
        int i = 0;
        while (i < pointData.size()) {
            Object[] next = pointData.get(i);
            String name = (String)next[0];
            double[][] xyArray = (double[][])next[1];
            ParticleDataTrack target = null;
            if (empty) {
                target = new ParticleDataTrack(next, this);
                target.setTrackerPanel(this.tp);
                if (this.tp != null) {
                    this.tp.addTrack(target);
                }
                target.setCoreData(xyArray, true);
            } else {
                int j = 0;
                while (j < this.morePoints.size()) {
                    ParticleDataTrack p = this.morePoints.get(j);
                    if (p != null && p.getName(null) != null && p.getName(null).equals(name)) {
                        target = p;
                        target.setCoreData(xyArray, true);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected void doAllColor() {
        Color color = this.getColor();
        OSPRuntime.chooseColor(color, TrackerRes.getString("TTrack.Dialog.Color.Title"), newColor -> {
            if (newColor != color) {
                XMLControlElement control = new XMLControlElement(new TrackProperties(this));
                this.setColor((Color)newColor);
                for (ParticleDataTrack next : this.morePoints) {
                    next.setColor((Color)newColor);
                }
                this.getLeader().setLineColor((Color)newColor);
                Undo.postTrackDisplayEdit(this, control);
            }
        });
    }

    protected void doAllCircle(String footprintName) {
        XMLControlElement control = new XMLControlElement(new TrackProperties(this));
        this.setFootprint(footprintName);
        for (ParticleDataTrack next : this.morePoints) {
            next.setFootprint(footprintName);
        }
        CircleFootprint cfp = (CircleFootprint)this.getFootprint();
        cfp.showProperties(this);
        this.erase();
        for (ParticleDataTrack next : this.morePoints) {
            CircleFootprint cf = (CircleFootprint)next.getFootprint();
            cf.setProperties(cfp.getProperties());
            next.erase();
        }
        Undo.postTrackDisplayEdit(this, control);
        TFrame.repaintT(this.tp);
    }

    protected void doAllFoot(String footprintName) {
        if (this.getFootprint().getName().equals(footprintName)) {
            return;
        }
        XMLControlElement control = new XMLControlElement(new TrackProperties(this));
        this.setFootprint(footprintName);
        this.erase();
        for (ParticleDataTrack next : this.morePoints) {
            next.setFootprint(footprintName);
            next.erase();
        }
        Undo.postTrackDisplayEdit(this, control);
        TFrame.repaintT(this.tp);
    }

    @Override
    protected void delete(boolean postEdit) {
        if (this.isLocked() && !this.isDependent()) {
            return;
        }
        if (this.tp != null) {
            this.tp.setSelectedPoint(null);
            this.tp.selectedSteps.clear();
            this.tframe.removePropertyChangeListener("windowfocus", this);
            ImageCoordSystem imageCoordSystem = this.tp.getCoords();
            if (imageCoordSystem instanceof ReferenceFrame && ((ReferenceFrame)imageCoordSystem).getOriginTrack() == this) {
                ImageCoordSystem imageCoordSystem2 = ((ReferenceFrame)imageCoordSystem).getCoords();
                this.tp.setCoords(imageCoordSystem2);
            }
        }
        if (postEdit) {
            Undo.postTrackDelete(this);
        }
        for (TTrack tTrack : this.morePoints) {
            tTrack.delete(false);
        }
        this.morePoints.clear();
        super.delete(false);
    }

    protected void setModelFootprint(String name) {
        if (this != this.getLeader()) {
            this.getLeader().setModelFootprint(name);
            return;
        }
        String props = null;
        int n = name.indexOf("#");
        if (n > -1) {
            props = name.substring(n + 1);
            name = name.substring(0, n);
        }
        int i = 0;
        while (i < this.modelFootprints.length) {
            if (name.equals(this.modelFootprints[i].getName())) {
                this.modelFootprint = this.modelFootprints[i];
                if (props == null || !(this.modelFootprint instanceof MultiLineFootprint)) break;
                MultiLineFootprint mlf = (MultiLineFootprint)this.modelFootprint;
                try {
                    boolean closed = Boolean.parseBoolean(props);
                    mlf.setClosed(closed);
                }
                catch (Exception exception) {}
                break;
            }
            ++i;
        }
    }

    protected Footprint getModelFootprint() {
        return this.getLeader().modelFootprint;
    }

    protected String getModelFootprintName() {
        String s = this.getModelFootprint().getName();
        if (this.getModelFootprint() instanceof MultiLineFootprint) {
            MultiLineFootprint mlf = (MultiLineFootprint)this.getModelFootprint();
            s = String.valueOf(s) + "#" + mlf.isClosed();
        }
        return s;
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel, JMenu menu0) {
        if (this.getLeader() != this) {
            return this.getPointMenu(trackerPanel);
        }
        JMenu menu = super.getMenu(trackerPanel, menu0);
        menu.setIcon(this.getIcon(21, 16, "model"));
        menu.removeAll();
        this.pointsMenu.setText(TrackerRes.getString("ParticleDataTrack.Menu.Points"));
        this.pointsMenu.removeAll();
        this.pointsMenu.add(this.getPointMenu(trackerPanel));
        for (ParticleDataTrack next : this.morePoints) {
            this.pointsMenu.add(next.getPointMenu(trackerPanel));
        }
        this.refreshing = true;
        if (this.morePoints.size() > 0) {
            this.lineColorItem.setText(TrackerRes.getString("TTrack.MenuItem.Color"));
            this.linesVisibleCheckbox.setText(this.visibleItem.getText());
            this.linesVisibleCheckbox.setSelected(this.modelFootprintVisible);
            this.linesClosedCheckbox.setText(TrackerRes.getString("ParticleDataTrack.Checkbox.Closed"));
            this.linesClosedCheckbox.setSelected(this.getModelFootprint() instanceof MultiLineFootprint && ((MultiLineFootprint)this.getModelFootprint()).isClosed());
            this.linesMenu.setText(TrackerRes.getString("ParticleDataTrack.Menu.Lines"));
            this.linesBoldCheckbox.setText(TrackerRes.getString("CircleFootprint.Dialog.Checkbox.Bold"));
            this.linesBoldCheckbox.setSelected(this.getModelFootprint().getName().indexOf("Bold") > -1);
            this.linesMenu.removeAll();
            this.linesMenu.add(this.lineColorItem);
            this.linesMenu.addSeparator();
            this.linesMenu.add(this.linesVisibleCheckbox);
            this.linesMenu.add(this.linesBoldCheckbox);
            if (this.morePoints.size() > 1) {
                this.linesMenu.add(this.linesClosedCheckbox);
            }
        }
        this.refreshing = false;
        this.allFootprintsMenu.setText(TrackerRes.getString("TTrack.MenuItem.Footprint"));
        this.allFootprintsMenu.removeAll();
        Footprint[] fp = this.getFootprints();
        int i = 0;
        while (i < fp.length) {
            JMenuItem item = new JMenuItem(fp[i].getDisplayName(), fp[i].getIcon(21, 16));
            item.setActionCommand(fp[i].getName());
            if (fp[i] instanceof CircleFootprint) {
                item.setText(String.valueOf(fp[i].getDisplayName()) + "...");
                item.addActionListener(this.allCircleFootprintsListener);
            } else {
                item.addActionListener(this.allFootprintsListener);
            }
            if (fp[i] == this.footprint) {
                item.setBorder(BorderFactory.createLineBorder(item.getBackground().darker()));
            }
            this.allFootprintsMenu.add(item);
            ++i;
        }
        this.allColorItem.setText(TrackerRes.getString("TTrack.MenuItem.Color"));
        menu.add(this.modelBuilderItem);
        menu.addSeparator();
        menu.add(this.descriptionItem);
        menu.addSeparator();
        menu.add(this.allColorItem);
        menu.add(this.allFootprintsMenu);
        menu.addSeparator();
        menu.add(this.pointsMenu);
        if (this.morePoints.size() > 0) {
            menu.add(this.linesMenu);
        }
        menu.addSeparator();
        menu.add(this.visibleItem);
        menu.addSeparator();
        menu.add(this.deleteTrackItem);
        return menu;
    }

    protected JMenu getPointMenu(TrackerPanel trackerPanel) {
        this.createMenuIfNecessary();
        JMenu menu = new JMenu();
        if (this.getLeader() != this) {
            super.getMenu(trackerPanel, menu);
        }
        if (this.colorItem == null) {
            this.getMenuItems();
        }
        this.colorItem.setText(TrackerRes.getString("TTrack.MenuItem.Color"));
        this.footprintMenu.setText(TrackerRes.getString("TTrack.MenuItem.Footprint"));
        this.velocityMenu.setText(TrackerRes.getString("PointMass.MenuItem.Velocity"));
        this.accelerationMenu.setText(TrackerRes.getString("PointMass.MenuItem.Acceleration"));
        menu.setText(this.getPointName());
        menu.setIcon(this.getFootprint().getIcon(21, 16));
        menu.removeAll();
        menu.add(this.colorItem);
        menu.add(this.footprintMenu);
        menu.addSeparator();
        menu.add(this.velocityMenu);
        menu.add(this.accelerationMenu);
        if (trackerPanel.isEnabled("model.stamp")) {
            menu.addSeparator();
            menu.add(this.stampItem);
        }
        return menu;
    }

    @Override
    public ResizableIcon getIcon(int w, int h, String context) {
        if (context.contains("point")) {
            return this.getFootprint().getIcon(w, h);
        }
        ArrayList<ShapeIcon> shapeIcons = new ArrayList<ShapeIcon>();
        ParticleDataTrack l = this.getLeader();
        this.addShapeIcons(l, shapeIcons, w, h);
        for (TTrack tTrack : l.morePoints) {
            this.addShapeIcons(tTrack, shapeIcons, w, h);
        }
        return new ResizableIcon(new ComboIcon(shapeIcons));
    }

    private void addShapeIcons(TTrack track, ArrayList<ShapeIcon> shapeIcons, int w, int h) {
        shapeIcons.add((ShapeIcon)track.getFootprint().getIcon(w, h).getBaseIcon());
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        if (this.getLeader().reloadButton == null) {
            this.tframe.checkClipboardListener();
            final int h = trackerPanel.getTrackBar((boolean)true).toolbarComponentHeight;
            this.getLeader().reloadButton = new JButton(){

                @Override
                public Dimension getMaximumSize() {
                    Dimension dim = super.getMaximumSize();
                    dim.height = h;
                    return dim;
                }
            };
            this.tframe.addPropertyChangeListener("windowfocus", this.getLeader());
        }
        if (this.autoPasteCheckbox == null && OSPRuntime.allowAutopaste) {
            this.autoPasteCheckbox = new JCheckBox();
            this.autoPasteCheckbox.setOpaque(false);
            this.autoPasteCheckbox.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            this.autoPasteCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParticleDataTrack.this.doAutoPaste(ParticleDataTrack.this.autoPasteCheckbox.isSelected());
                }
            });
        }
        ArrayList<Component> list = super.getToolbarTrackComponents(trackerPanel);
        if (trackerPanel.getSelectedPoint() == null) {
            boolean autoloadable;
            list.remove(this.massLabel);
            list.remove(this.massField);
            boolean bl = autoloadable = this.getSource() == null || this.getSource() instanceof String;
            if (autoloadable && OSPRuntime.allowAutopaste) {
                this.autoPasteCheckbox.setText(this.getSource() == null ? TrackerRes.getString("TMenuBar.MenuItem.AutoPasteData.Text") : TrackerRes.getString("ParticleDataTrack.Checkbox.Autoload.Text"));
                this.autoPasteCheckbox.setSelected(this.isAutoPasteEnabled());
                list.add(this.autoPasteCheckbox);
                list.add(this.mSeparator);
            }
        }
        this.massField.setEnabled(true);
        return list;
    }

    protected void doAutoPaste(boolean tf) {
        this.setAutoPasteEnabled(tf);
        if (this.tp == null) {
            return;
        }
        if (this.tframe == null) {
            return;
        }
        if (this.isAutoPasteEnabled()) {
            if (this.getSource() == null) {
                ClipboardListener clipboardListener = this.tframe.getClipboardListener();
                String s = OSPRuntime.paste(null);
                if (s != null && ParticleDataTrack.getImportableDataName(s) != null) {
                    try {
                        clipboardListener.processContents(s);
                    }
                    catch (Exception exception) {}
                }
            } else if (this.getSource() instanceof String) {
                this.tp.importDataAsync(this.getSource().toString(), null, null);
            }
        }
        if (this.tp.getSelectedTrack() == this) {
            this.tp.refreshTrackBar();
        }
        this.tframe.checkClipboardListener();
    }

    @Override
    public boolean isAutoPasteEnabled() {
        return this.autoPasteEnabled;
    }

    protected void setAutoPasteEnabled(boolean enable) {
        this.getLeader().autoPasteEnabled = enable;
    }

    protected String getPointName() {
        int i;
        if (this.pointName == null || this.pointName.length() == 0) {
            this.pointName = this.getLeader().getPointChar(this);
        }
        ParticleDataTrack l = this.getLeader();
        int count = this.pointName.equals(l.pointName) ? 1 : 0;
        int n = i = count == 1 && l == this ? 1 : 0;
        if (l.morePoints != null) {
            for (ParticleDataTrack next : l.morePoints) {
                if (!this.pointName.equals(next.pointName) || ++count <= 0 || next != this) continue;
                i = count;
            }
        }
        return count > 1 ? String.valueOf(this.pointName) + " " + i : this.pointName;
    }

    protected void setPointName(String newName) {
        int n;
        if (newName == null) {
            newName = "";
        }
        if ((n = newName.indexOf("(")) > -1) {
            newName = newName.substring(0, n).trim();
        } else {
            n = newName.indexOf("[");
            if (n > -1) {
                newName = newName.substring(0, n).trim();
            }
        }
        this.pointName = newName;
        ParticleDataTrack l = this.getLeader();
        String fullName = l.getFullName();
        boolean changed = !fullName.equals(l.name);
        l.name = fullName;
        for (ParticleDataTrack next : l.morePoints) {
            fullName = next.getFullName();
            changed |= !fullName.equals(next.name);
            next.name = fullName;
        }
        if (changed) {
            this.firePropertyChange("name", null, null);
        }
    }

    private String getPointChar(ParticleDataTrack track) {
        return track == this ? "A" : String.valueOf((char)(66 + this.morePoints.indexOf(track)));
    }

    protected void setAllColors(Color[] colors) {
        int len = Math.min(this.morePoints.size() + 1, colors.length - 1);
        this.setColor(colors[0]);
        int i = 0;
        while (i < len) {
            this.morePoints.get(i).setColor(colors[i + 1]);
            ++i;
        }
        Color c = colors[colors.length - 1];
        int i2 = 0;
        while (i2 < this.modelFootprints.length) {
            this.modelFootprints[i2].setColor(c);
            ++i2;
        }
        this.erase();
        TFrame.repaintT(this.tp);
    }

    protected void setAllFootprints(String[] footprints) {
        int len = Math.min(this.morePoints.size() + 1, footprints.length - 1);
        this.setFootprint(footprints[0]);
        int i = 0;
        while (i < len) {
            this.morePoints.get(i).setFootprint(footprints[i + 1]);
            ++i;
        }
        this.setModelFootprint(footprints[footprints.length - 1]);
        this.erase();
        TFrame.repaintT(this.tp);
    }

    public String getFullName() {
        return String.valueOf(this.getLeader().modelName) + " " + this.getPointName();
    }

    @Override
    public String getName(String context) {
        if (context == null) {
            String mod = this.getLeader().modelName;
            String fullName = this.getName();
            if (fullName.startsWith(mod)) {
                return fullName.substring(mod.length(), fullName.length()).trim();
            }
        } else if (context.contains("point")) {
            return this.getName();
        }
        return this.getLeader().modelName;
    }

    @Override
    public void setName(String newName) {
        if (this.morePoints == null) {
            return;
        }
        if (this.getLeader() == this) {
            if (this.getFullName().equals(newName)) {
                return;
            }
            this.modelName = newName;
            this.name = this.getFullName();
            for (ParticleDataTrack next : this.morePoints) {
                next.name = next.getFullName();
            }
        }
    }

    @Override
    public void setColor(Color color) {
        super.setColor(color);
        if (this.getLeader() != this) {
            this.getLeader().firePropertyChange("color", null, color);
        }
    }

    public void setLineColor(Color color) {
        if (this.getLeader() == this) {
            this.modelFootprint.setColor(color);
            this.firePropertyChange("color", null, color);
            this.erase();
            if (this.tp != null) {
                TFrame.repaintT(this.tp);
            }
        }
    }

    @Override
    public void setFootprint(String name) {
        super.setFootprint(name);
        if (this.getLeader() != this) {
            this.getLeader().firePropertyChange("footprint", null, this.getLeader().footprint);
        }
    }

    public ParticleDataTrack getLeader() {
        return this.dataSource != null && this.dataSource instanceof ParticleDataTrack ? (ParticleDataTrack)this.dataSource : this;
    }

    public void setData(DatasetManager manager) throws Exception {
        ArrayList<Object[]> pointData = ParticleDataTrack.getPointData(manager, 1);
        this.sourceData = manager;
        double[] tPrev = this.tData;
        Object[] nextPointData = pointData.get(0);
        this.setPointName((String)nextPointData[0]);
        double[][] xyData = (double[][])nextPointData[1];
        double[] xData = xyData[0];
        double[] yData = xyData[1];
        double[] timeArray = ParticleDataTrack.getTimeData(manager);
        if (timeArray != null && xData.length != timeArray.length) {
            throw new Exception("Time data has incorrect array length");
        }
        this.setCoreData(new double[][]{xData, yData, timeArray}, true);
        int i = 1;
        while (i < pointData.size()) {
            ParticleDataTrack target;
            nextPointData = pointData.get(i);
            xyData = (double[][])nextPointData[1];
            xData = xyData[0];
            yData = xyData[1];
            if (i > this.morePoints.size()) {
                target = new ParticleDataTrack(nextPointData, this);
                target.setTrackerPanel(this.tp);
                if (this.tp != null) {
                    this.tp.addTrack(target);
                }
            } else {
                target = this.morePoints.get(i - 1);
                target.setCoreData(new double[][]{xData, yData}, true);
                target.setPointName((String)nextPointData[0]);
            }
            ++i;
        }
        i = this.morePoints.size() - 1;
        while (i >= pointData.size() - 1) {
            ParticleDataTrack next = this.morePoints.remove(i);
            next.delete(false);
            --i;
        }
        this.setPointName(this.pointName);
        for (ParticleDataTrack next : this.morePoints) {
            next.setPointName(next.pointName);
        }
        if (this.tData != null && this.tData.length > 1 && tPrev != null && tPrev.length > 1 && this.getVideoPanel() != null) {
            boolean isDataTime;
            boolean changed = this.tData[0] != tPrev[0] || this.tData[1] - this.tData[0] != tPrev[1] - tPrev[0];
            VideoPlayer player = this.getVideoPanel().getPlayer();
            boolean bl = isDataTime = player.getClipControl().getTimeSource() == this;
            if (changed && isDataTime && this.functionPanel != null) {
                ParticleDataTrackFunctionPanel dtPanel = (ParticleDataTrackFunctionPanel)this.functionPanel;
                dtPanel.refreshTimeSource();
            }
        }
    }

    @Override
    public Data getData() {
        return this.sourceData;
    }

    @Override
    public Object getSource() {
        return this.dataSource;
    }

    public void setSource(Object source) {
        this.dataSource = source;
    }

    @Override
    public DataClip getDataClip() {
        if (this.dataClip == null) {
            this.dataClip = new DataClip();
        }
        return this.dataClip;
    }

    @Override
    public void invalidateData(Object newValue) {
        this.dataValid = false;
        if (this.getLeader() == this) {
            int i = 0;
            while (i < this.morePoints.size()) {
                this.morePoints.get(i).invalidateData(newValue);
                ++i;
            }
            if (newValue != Boolean.FALSE) {
                this.firePropertyChange("data", null, newValue == Boolean.TRUE ? null : newValue);
            }
        }
    }

    public VideoClip getVideoClip() {
        if (this.tp == null) {
            return null;
        }
        return this.tp.getPlayer().getVideoClip();
    }

    @Override
    public boolean isVisible() {
        if (this.getLeader() != this) {
            return this.getLeader().isVisible();
        }
        return super.isVisible();
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (this.getLeader() != this && vis != this.getLeader().isVisible()) {
            this.getLeader().setVisible(vis);
        }
        for (TTrack tTrack : this.morePoints) {
            tTrack.setVisible(vis);
        }
    }

    public int getEndIndex() {
        int stepCount = this.getEndFrame() - this.getStartFrame();
        int index = this.dataClip.getStartIndex() + stepCount * this.dataClip.getStride();
        return Math.min(index, this.dataClip.getDataLength() - 1);
    }

    public double getStepTime(int step) {
        if (this.tData == null) {
            return Double.NaN;
        }
        int index = this.getDataClip().stepToIndex(step);
        if (index < this.tData.length) {
            return this.tData[index];
        }
        return Double.NaN;
    }

    @Override
    public boolean isTimeDataAvailable() {
        if (this.dataClip == null || this.getVideoClip() == null) {
            return false;
        }
        int n = Math.max(this.dataClip.getStride(), this.dataClip.getStartIndex());
        return this.tData != null && this.tData.length > n;
    }

    @Override
    public double getVideoStartTime() {
        if (!this.isTimeDataAvailable()) {
            return Double.NaN;
        }
        double t0 = this.tData[this.getDataClip().getStartIndex()];
        double duration = this.getFrameDuration();
        return t0 - duration * (double)(this.getStartFrame() - this.getVideoClip().getStartFrameNumber());
    }

    @Override
    public double getFrameDuration() {
        if (!this.isTimeDataAvailable()) {
            return Double.NaN;
        }
        return this.tData[this.getDataClip().getStride()] - this.tData[0];
    }

    @Override
    public void setStartFrame(int n) {
        if (n == this.getStartFrame()) {
            return;
        }
        n = Math.max(n, 0);
        VideoClip clip = this.tp.getPlayer().getVideoClip();
        int end = clip.getLastFrameNumber();
        this.startFrame = n = Math.min(n, end);
        this.startStep = clip.frameToStep(this.startFrame);
        this.refreshInitialTime();
        this.adjustVideoClip();
        this.setLastValidFrame(-1);
        for (ParticleDataTrack next : this.morePoints) {
            next.setLastValidFrame(-1);
        }
        TFrame.repaintT(this.tp);
        this.firePropertyChange("startframe", null, this.getStartFrame());
        if (this.tp != null && !this.requiresConversion) {
            this.tp.getModelBuilder().refreshSpinners();
            int stepNum = clip.frameToStep(this.startFrame);
            this.tp.getPlayer().setStepNumber(stepNum);
        }
    }

    @Override
    public void setStartStep(int start) {
        VideoClip clip = this.tp.getPlayer().getVideoClip();
        int frame = clip.stepToFrame(start);
        this.setStartFrame(frame);
    }

    @Override
    public int getStartStep() {
        if (this.getLeader() != this) {
            return this.getLeader().getStartStep();
        }
        if (this.startStep < 0 && this.tp != null) {
            VideoClip clip = this.tp.getPlayer().getVideoClip();
            this.startStep = clip.frameToStep(this.startFrame);
        }
        return this.startStep;
    }

    @Override
    public void setEndFrame(int n) {
        this.tp.getModelBuilder().refreshSpinners();
    }

    @Override
    protected void refreshInitialTime() {
        if (this.tp == null || this.tp.getPlayer() == null) {
            super.refreshInitialTime();
            return;
        }
        if (!ClipControl.isTimeSource(this) || !this.isTimeDataAvailable()) {
            super.refreshInitialTime();
            return;
        }
        ClipControl clipControl = this.tp.getPlayer().getClipControl();
        clipControl.setTimeSource(this);
        Parameter param = (Parameter)this.getInitEditor().getObject("t");
        double tZero = this.tData[this.getDataClip().getStartIndex()];
        String t = timeFormat.format(tZero);
        if (!timeFormat.format(param.getValue()).equals(t)) {
            boolean prev = this.refreshing;
            this.refreshing = true;
            this.getInitEditor().setExpression("t", t, false);
            this.refreshing = prev;
        }
    }

    @Override
    public int getStartFrame() {
        if (this.getLeader() != this) {
            return this.getLeader().getStartFrame();
        }
        VideoClip clip = this.tp.getPlayer().getVideoClip();
        return clip.stepToFrame(this.getStartStep());
    }

    @Override
    public int getEndFrame() {
        int stepSize = this.tp.getPlayer().getVideoClip().getStepSize();
        int finalStep = this.getDataClip().getClipLength() - 1;
        int clipEnd = this.getStartFrame() + stepSize * finalStep;
        int videoEnd = this.tp.getPlayer().getVideoClip().getLastFrameNumber();
        while (videoEnd < clipEnd) {
            clipEnd -= stepSize;
        }
        return clipEnd;
    }

    @Override
    boolean getNextTracePositions() {
        ++this.stepCounter;
        int index = this.getDataIndexAtVideoStepNumber(this.stepCounter);
        if (index < 0 || index >= this.xData.length || index >= this.yData.length) {
            return false;
        }
        this.points[this.myPoint].setLocation(this.xData[index], this.yData[index]);
        return true;
    }

    protected int getDataIndexAtVideoStepNumber(int videoStepNumber) {
        DataClip dataClip = this.getDataClip();
        int len = dataClip.getAvailableClipLength();
        int dataStepNumber = videoStepNumber - this.getStartStep();
        boolean validData = dataStepNumber >= 0 && dataStepNumber < len;
        int index = this.getDataClip().stepToIndex(dataStepNumber);
        return validData ? index : -1;
    }

    @Override
    public void setColorToDefault(int index) {
        super.setColorToDefault(index);
        for (TTrack tTrack : this.morePoints) {
            tTrack.setColor(this.getColor());
        }
        this.getModelFootprint().setColor(this.getColor());
    }

    @Override
    public void setTrackerPanel(TrackerPanel panel) {
        if (this.tp != null) {
            this.tp.removePropertyChangeListener("video", this);
            if (panel == null) {
                this.tframe.checkClipboardListener();
            }
        }
        super.setTrackerPanel(panel);
        for (TTrack tTrack : this.morePoints) {
            tTrack.setTrackerPanel(panel);
        }
        if (this.tp != null) {
            this.tp.addPropertyChangeListener("video", this);
            if (this.requiresConversion) {
                this.convertFrameToStepParameters();
            }
            if (panel != null) {
                VideoClip videoClip = panel.getPlayer().getVideoClip();
                int length = videoClip.getLastFrameNumber() - videoClip.getFirstFrameNumber() + 1;
                this.dataClip.setClipLength(Math.min(length, this.dataClip.getClipLength()));
                this.firePropertyChange("videoclip", null, null);
                if (this.useDataTime) {
                    panel.getPlayer().getClipControl().setTimeSource(this);
                    this.firePropertyChange("timedata", null, null);
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        switch (e.getPropertyName()) {
            case "startframe": 
            case "clip_length": 
            case "stepcount": 
            case "clip_stride": 
            case "stepsize": 
            case "clip_adjusting": 
            case "clip_start": {
                this.refreshInitialTime();
                this.adjustVideoClip();
                this.firePropertyChange(PROPERTY_PARTICLEDATATRACK_DATACLIP, null, null);
                break;
            }
            case "video": {
                this.firePropertyChange("videoclip", null, null);
                break;
            }
            case "windowfocus": {
                if (!OSPRuntime.allowAutopaste || !this.isAutoPasteEnabled()) {
                    return;
                }
                if (this.tp != null && this.tp == this.tframe.getSelectedPanel() && this == this.getLeader()) {
                    String dataString = null;
                    if (this.dataSource == null) {
                        dataString = OSPRuntime.paste(null);
                    } else if (this.dataSource instanceof String) {
                        dataString = ResourceLoader.getString(this.dataSource.toString());
                    }
                    if (dataString != null) {
                        try {
                            DatasetManager[] datasetManager = DataTool.parseData(dataString, null);
                            if (datasetManager != null) {
                                String dataName = datasetManager[0].getName().replaceAll("_", " ");
                                String trackName = this.getName("model");
                                if (trackName.equals(dataName) || "".equals(dataName) && trackName.equals(TrackerRes.getString("ParticleDataTrack.New.Name"))) {
                                    this.setData(datasetManager[0]);
                                    this.prevDataString = dataString;
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                return;
            }
            case "tab": {
                if (this.tframe.getState() == 0 && this.tp != null && this.tframe != null && this.tp == e.getNewValue()) {
                    this.tframe.getClipboardListener().processContents(this.tp);
                }
                return;
            }
            default: {
                return;
            }
        }
        this.setLastValidFrame(-1);
        this.repaint();
    }

    @Override
    protected void initializeFunctionPanel() {
        this.functionPanel = new ParticleDataTrackFunctionPanel(this);
        this.createTimeParameter();
    }

    @Override
    protected void reset() {
        int i = 0;
        while (i < this.steps.array.length) {
            Step step = this.steps.getStep(i);
            if (step != null) {
                step.erase();
            }
            this.steps.setStep(i, null);
            ++i;
        }
        ImageCoordSystem coords = this.tp.getCoords();
        boolean useDefault = this.isUseDefaultReferenceFrame();
        while (useDefault && coords instanceof ReferenceFrame) {
            coords = ((ReferenceFrame)coords).getCoords();
        }
        Point2D.Double point = this.points[this.myPoint];
        VideoClip vidClip = this.getVideoClip();
        int firstFrameInVideoClip = vidClip.getStartFrameNumber();
        int index = this.getDataIndexAtVideoStepNumber(0);
        if (index > -1) {
            point.setLocation(this.xData[index], this.yData[index]);
            AffineTransform transform = coords.getToImageTransform(firstFrameInVideoClip);
            transform.transform(point, point);
        }
        this.steps.setLength(firstFrameInVideoClip + 1);
        int i2 = 0;
        while (i2 < this.steps.array.length) {
            if (i2 < firstFrameInVideoClip || index == -1) {
                this.steps.setStep(i2, null);
            } else {
                PositionStep step = this.createPositionStep(this, i2, point.x, point.y);
                step.setFootprint(this.getFootprint());
                this.steps.setStep(i2, step);
                this.refreshData(this.datasetManager, this.tp, firstFrameInVideoClip, 1);
            }
            ++i2;
        }
        this.getVArray(this.tp.getID()).setLength(0);
        this.getAArray(this.tp.getID()).setLength(0);
        this.traceX = new double[]{point.x};
        this.traceY = new double[]{point.y};
        this.setLastValidFrame(firstFrameInVideoClip);
        this.stepCounter = 0;
    }

    @Override
    public void setData(Data data, Object source) throws Exception {
        this.setData((DatasetManager)data);
        this.setSource(source);
    }

    @Override
    public VideoPanel getVideoPanel() {
        return this.tp;
    }

    @Override
    protected PositionStep createPositionStep(PointMass track, int n, double x, double y) {
        ParticleDataTrack dt = (ParticleDataTrack)track;
        PositionStep newStep = track == this.getLeader() ? new MultiPositionStep(dt, n, x, y) : new PositionStep(dt, n, x, y);
        newStep.valid = !Double.isNaN(x) && !Double.isNaN(y);
        return newStep;
    }

    public double[][] getDataArray() {
        return new double[][]{this.xData, this.yData, this.tData};
    }

    public void appendData(DatasetManager manager) throws Exception {
        this.sourceData = manager;
        ArrayList<Object[]> pointData = ParticleDataTrack.getPointData(manager, 1);
        Object[] nextPointData = pointData.get(0);
        double[][] xyData = (double[][])nextPointData[1];
        double[] x = xyData[0];
        double[] y = xyData[1];
        double[][] oldData = this.getDataArray();
        int n = oldData[0].length;
        if (x.length <= n) {
            JOptionPane.showMessageDialog(this.tframe, TrackerRes.getString("ParticleDataTrack.Dialog.NoNewData.Message"), TrackerRes.getString("ParticleDataTrack.Dialog.NoNewData.Title"), 2);
            return;
        }
        double[] timeArray = ParticleDataTrack.getTimeData(manager);
        double[][] newData = new double[][]{x, y, timeArray};
        int i = 0;
        while (i < 3) {
            if (newData[i] != null && oldData[i] != null) {
                System.arraycopy(oldData[i], 0, newData[i], 0, n);
            }
            ++i;
        }
        this.setCoreData(newData, false);
        int len = Math.min(pointData.size() - 1, this.morePoints.size());
        int i2 = 0;
        while (i2 < len) {
            nextPointData = pointData.get(i2 + 1);
            this.morePoints.get(i2).setCoreData(new double[][]{(double[])nextPointData[1], (double[])nextPointData[2]}, true);
            ++i2;
        }
    }

    private static double[] getTimeData(DatasetManager data) {
        ArrayList<Dataset> datasets = data.getDatasetsRaw();
        for (Dataset dataset : datasets) {
            String s = dataset.getXColumnName().toLowerCase();
            int n = s.indexOf("(");
            if (n > -1) {
                s = s.substring(0, n).trim();
            } else {
                n = s.indexOf("[");
                if (n > -1) {
                    s = s.substring(0, n).trim();
                }
            }
            if (s.equals("t") || s.equals("time")) {
                return dataset.getXPoints();
            }
            s = dataset.getYColumnName().toLowerCase();
            n = s.indexOf("(");
            if (n > -1) {
                s = s.substring(0, n).trim();
            } else {
                n = s.indexOf("[");
                if (n > -1) {
                    s = s.substring(0, n).trim();
                }
            }
            if (!s.equals("t") && !s.equals("time")) continue;
            return dataset.getYPoints();
        }
        return null;
    }

    protected static String getImportableDataName(String s) {
        DatasetManager[] manager = DataTool.parseData(s, null);
        if (manager == null) {
            return null;
        }
        try {
            if (ParticleDataTrack.getPointData(manager[0], 0) != null) {
                String name = manager[0].getName();
                if (name.trim().equals("")) {
                    name = TrackerRes.getString("ParticleDataTrack.New.Name");
                }
                name = name.replaceAll("_", " ");
                return name;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected static ParticleDataTrack getTrackForDataString(String dataString, TrackerPanel trackerPanel) {
        if (dataString == null) {
            return null;
        }
        ArrayList<ParticleDataTrack> list = trackerPanel.getDrawablesTemp(ParticleDataTrack.class);
        ParticleDataTrack ret = null;
        int m = 0;
        int n = list.size();
        while (m < n) {
            ParticleDataTrack track = list.get(m);
            if (dataString.equals(track.prevDataString)) {
                ret = track;
                break;
            }
            ++m;
        }
        list.clear();
        return ret;
    }

    protected static ParticleDataTrack getTrackForData(DatasetManager data, TrackerPanel trackerPanel) {
        String name = data.getName();
        if (name == null || name.trim().equals("")) {
            name = TrackerRes.getString("ParticleDataTrack.New.Name");
        }
        name = name.replaceAll("_", " ");
        ArrayList<TTrack> tracks = trackerPanel.getTracksTemp();
        TTrack track = trackerPanel.getTrack(name, tracks);
        int i = 1;
        while (track != null && track.getClass() != ParticleDataTrack.class) {
            String nextName;
            if ((track = trackerPanel.getTrack(nextName = ParticleDataTrack.getNextName(name, i++), tracks)) != null && track.getClass() != ParticleDataTrack.class) continue;
            Class<?> type = data.getClass();
            try {
                Method method = type.getMethod("setName", String.class);
                method.invoke((Object)data, nextName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        tracks.clear();
        if (track == null) {
            int id = data.getID();
            ArrayList<ParticleDataTrack> list = trackerPanel.getDrawablesTemp(ParticleDataTrack.class);
            int m = 0;
            int n = list.size();
            while (m < n) {
                ParticleDataTrack model = list.get(m);
                Data existingData = model.getData();
                if (existingData != null && id == existingData.getID()) {
                    track = model;
                    break;
                }
                ++m;
            }
            list.clear();
        }
        return (ParticleDataTrack)track;
    }

    protected static String getNextName(String original, int increment) {
        if (original.lastIndexOf(" ") == original.length() - 2) {
            String core = original.substring(0, original.length() - 2);
            int coreChar = original.charAt(original.length() - 1);
            int c = 48;
            while (c <= 57) {
                if (c == coreChar) {
                    char newChar = (char)(c + increment);
                    return String.valueOf(core) + " " + newChar;
                }
                c = (char)(c + '\u0001');
            }
            c = 97;
            while (c <= 122) {
                if (c == coreChar) {
                    char newChar = (char)(c + increment);
                    return String.valueOf(core) + " " + newChar;
                }
                c = (char)(c + 1);
            }
            c = 65;
            while (c <= 90) {
                if (c == coreChar) {
                    char newChar = (char)(c + increment);
                    return String.valueOf(core) + " " + newChar;
                }
                c = (char)(c + 1);
            }
        }
        return String.valueOf(original) + increment;
    }

    private static ArrayList<Object[]> getPointData(DatasetManager data, int mode) throws Exception {
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        if (data == null) {
            if (mode == 0) {
                return null;
            }
            throw new Exception("Data is null");
        }
        ArrayList<Dataset> datasets = data.getDatasetsRaw();
        if (datasets == null) {
            if (mode == 0) {
                return null;
            }
            throw new Exception("Data contains no datasets");
        }
        boolean xIsX = true;
        boolean yIsY = true;
        String colName = null;
        Dataset xset = null;
        Dataset yset = null;
        int x = 120;
        int y = 121;
        for (Dataset dataset : datasets) {
            String xname = dataset.getXColumnName();
            String yname = dataset.getYColumnName();
            String xlc = xname.toLowerCase();
            String ylc = yname.toLowerCase();
            String yColName = null;
            String xColName = null;
            if (xlc.startsWith("x")) {
                xColName = xname.substring(1).trim();
            } else if (ylc.startsWith("x")) {
                xColName = yname.substring(1).trim();
                xIsX = false;
            } else if (xlc.endsWith("x")) {
                xColName = xname.substring(0, xname.length() - 1).trim();
            } else if (ylc.endsWith("x")) {
                xColName = yname.substring(0, yname.length() - 1).trim();
                xIsX = false;
            }
            if (xlc.startsWith("y")) {
                yColName = xname.substring(1).trim();
                yIsY = false;
            } else if (ylc.startsWith("y")) {
                yColName = yname.substring(1).trim();
            } else if (xlc.endsWith("y")) {
                yColName = xname.substring(0, xname.length() - 1).trim();
                yIsY = false;
            } else if (ylc.endsWith("y") && xIsX) {
                yColName = yname.substring(0, yname.length() - 1).trim();
            }
            if (xColName == null && yColName == null) continue;
            if (colName == null) {
                if (xColName != null) {
                    if (yColName == null) {
                        colName = xColName;
                        xset = dataset;
                        x = xIsX ? 120 : 121;
                    } else if (xColName.equals(yColName)) {
                        colName = xColName;
                        xset = dataset;
                        yset = dataset;
                        x = xIsX ? 120 : 121;
                        y = yIsY ? 121 : 120;
                    } else {
                        colName = yColName;
                        yset = dataset;
                        y = yIsY ? 121 : 120;
                    }
                } else if (yColName != null) {
                    colName = yColName;
                    yset = dataset;
                    y = yIsY ? 121 : 120;
                }
            } else if (xset == null && colName.equals(xColName)) {
                xset = dataset;
                x = xIsX ? 120 : 121;
            } else if (yset == null && colName.equals(yColName)) {
                yset = dataset;
                y = yIsY ? 121 : 120;
            } else {
                yset = null;
                xset = null;
                if (xColName != null) {
                    colName = xColName;
                    xset = dataset;
                    x = xIsX ? 120 : 121;
                } else {
                    colName = yColName;
                    yset = dataset;
                    int n = y = yIsY ? 121 : 120;
                }
            }
            if (xset == null || yset == null || colName == null) continue;
            colName = colName.replace('_', ' ').trim();
            if (xset.getIndex() != yset.getIndex()) {
                if (mode == 0) {
                    return null;
                }
                throw new Exception("X and Y data have different array lengths");
            }
            if (mode == 0) {
                return results;
            }
            double[][] xyData = new double[][]{x == 120 ? xset.getXPoints() : xset.getYPoints(), y == 120 ? yset.getXPoints() : yset.getYPoints()};
            results.add(new Object[]{colName, xyData});
            yset = null;
            xset = null;
            colName = null;
        }
        if (results.isEmpty()) {
            yset = null;
            xset = null;
            for (Dataset dataset : datasets) {
                if (!dataset.getYColumnName().equals("?")) continue;
                if (xset == null) {
                    xset = dataset;
                    continue;
                }
                yset = dataset;
                break;
            }
            if (xset != null && yset != null) {
                if (xset.getIndex() != yset.getIndex()) {
                    if (mode == 0) {
                        return null;
                    }
                    throw new Exception("X and Y data have different array lengths");
                }
                if (mode == 0) {
                    return results;
                }
                double[][] xyData = new double[][]{xset.getYPoints(), yset.getYPoints()};
                results.add(new Object[]{colName, xyData});
            }
        }
        if (results.isEmpty()) {
            if (mode == 0) {
                return null;
            }
            throw new Exception("Position data (x, y) not defined");
        }
        return results;
    }

    private void createTimeParameter() {
        this.functionPanel.getInitEditor().addObject(ParticleDataTrack.newTimeParam(), false);
        this.getInitEditor().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (ParticleDataTrack.this.refreshing) {
                    return;
                }
                if ("t".equals(e.getOldValue()) && ParticleDataTrack.this.tp != null) {
                    Parameter param = (Parameter)ParticleDataTrack.this.getInitEditor().getObject("t");
                    VideoClip clip = ParticleDataTrack.this.tp.getPlayer().getVideoClip();
                    double timeOffset = param.getValue() * 1000.0 - clip.getStartTime();
                    double dt = ParticleDataTrack.this.tp.getPlayer().getMeanStepDuration();
                    int n = clip.getStartFrameNumber();
                    boolean mustRound = timeOffset % dt > 0.0;
                    ParticleDataTrack.this.setStartStep(n += clip.getStepSize() * (int)Math.round(timeOffset / dt));
                    if (ParticleDataTrack.this.getStartFrame() != n || mustRound) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
        });
    }

    private void setCoreData(double[][] data, boolean reset) {
        this.xData = data[0];
        this.yData = data[1];
        this.tData = data.length > 2 ? data[2] : null;
        this.getDataClip().setDataLength(data[0].length);
        this.firePropertyChange(PROPERTY_PARTICLEDATATRACK_DATACLIP, null, this.dataClip);
        this.adjustVideoClip();
        if (reset) {
            this.setLastValidFrame(-1);
            this.refreshSteps("ParticleDataTrack");
            this.fireStepsChanged();
        }
        this.invalidWarningShown = true;
        this.repaint();
    }

    private void adjustVideoClip() {
        if (this.tp == null) {
            return;
        }
        VideoClip vidClip = this.tp.getPlayer().getVideoClip();
        int videoEndFrame = vidClip.getEndFrameNumber();
        boolean isLast = videoEndFrame == vidClip.getLastFrameNumber();
        int dataEndFrame = this.getStartFrame() + this.getDataClip().getAvailableClipLength() - 1;
        if (isLast && dataEndFrame > videoEndFrame) {
            vidClip.extendEndFrameNumber(dataEndFrame);
        } else if (dataEndFrame < videoEndFrame && vidClip.getExtraFrames() > 0) {
            int needed = vidClip.getExtraFrames() - (videoEndFrame - dataEndFrame);
            vidClip.setExtraFrames(needed);
        }
    }

    private void convertFrameToStepParameters() {
        if (this.tp == null) {
            return;
        }
        int dataStartStep = -1;
        int dataStepCount = -1;
        int dataStartFrame = this.startFrameTemp >= 0 ? this.startFrameTemp : this.getStartFrame();
        VideoClip vidClip = this.tp.getPlayer().getVideoClip();
        int clipStepSize = vidClip.getStepSize();
        int clipStepCount = vidClip.getStepCount();
        DataClip data = this.getDataClip();
        int dataFrameCount = data.getClipLength();
        int frameCount = Math.min(dataFrameCount, clipStepCount * clipStepSize);
        int i = 0;
        while (i < frameCount) {
            if (vidClip.includesFrame(dataStartFrame + i)) {
                dataStartStep = vidClip.frameToStep(dataStartFrame + i);
                dataStartFrame += i;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < frameCount) {
            int frame = dataStartFrame + dataFrameCount - i - 1;
            if (vidClip.includesFrame(frame)) {
                int dataEndStep = vidClip.frameToStep(frame);
                dataStepCount = dataEndStep - dataStartStep + 1;
                break;
            }
            ++i;
        }
        if (dataStartStep == -1 || dataStepCount == -1) {
            this.requiresConversion = false;
            return;
        }
        int dataStartIndex = data.stepToIndex(dataStartFrame - Math.max(0, this.startFrameTemp));
        data.setStride(data.getStride() * clipStepSize);
        data.setClipLength(dataStepCount);
        data.setStartIndex(dataStartIndex);
        this.setStartStep(dataStartStep);
        int stepNum = this.tp.getPlayer().getClipControl().loadedStepNumber;
        if (stepNum > -1) {
            this.tp.getPlayer().setStepNumber(stepNum);
        }
        this.requiresConversion = false;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    /* synthetic */ ParticleDataTrack(double[][] dArray, ArrayList arrayList, ParticleDataTrack particleDataTrack) {
        this(dArray, arrayList);
    }

    class ComboIcon
    implements Icon {
        ArrayList<ShapeIcon> shapeIcons;

        ComboIcon(ArrayList<ShapeIcon> icons) {
            this.shapeIcons = icons;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.shapeIcons.size() == 1) {
                this.shapeIcons.get(0).paintIcon(c, g, x, y);
            } else {
                Graphics2D g2 = (Graphics2D)g;
                AffineTransform restoreTransform = g2.getTransform();
                int w = this.getIconWidth();
                int h = this.getIconHeight();
                g2.scale(0.7, 0.7);
                int n = this.shapeIcons.size();
                int i = 0;
                while (i < n) {
                    if (i % 2 == 0) {
                        this.shapeIcons.get(i).paintIcon(c, g, x + i * w / n, y);
                    } else {
                        this.shapeIcons.get(i).paintIcon(c, g, x + i * w / n, y + h / 2);
                    }
                    ++i;
                }
                g2.setTransform(restoreTransform);
            }
        }

        @Override
        public int getIconWidth() {
            return this.shapeIcons.get(0).getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.shapeIcons.get(0).getIconHeight();
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            ParticleDataTrack dataTrack = (ParticleDataTrack)obj;
            control.setValue("mass", dataTrack.getMass());
            XML.getLoader(TTrack.class).saveObject(control, obj);
            control.setValue("name", dataTrack.modelName);
            control.setValue("x", dataTrack.xData);
            control.setValue("y", dataTrack.yData);
            control.setValue("t", dataTrack.tData);
            control.setValue("pointname", dataTrack.pointName);
            int i = 0;
            while (i < dataTrack.morePoints.size()) {
                ParticleDataTrack pointTrack = dataTrack.morePoints.get(i);
                control.setValue("x" + i, pointTrack.xData);
                control.setValue("y" + i, pointTrack.yData);
                control.setValue("mass" + i, pointTrack.getMass());
                control.setValue("pointname" + i, pointTrack.pointName);
                control.setValue("color" + i, pointTrack.getColor());
                control.setValue("footprint" + i, pointTrack.getFootprintName());
                ++i;
            }
            control.setValue(ParticleDataTrack.PROPERTY_PARTICLEDATATRACK_DATACLIP, dataTrack.getDataClip());
            if (dataTrack.getStartFrame() > 0) {
                control.setValue("start_frame", dataTrack.getStartFrame());
            }
            control.setValue("use_data_time", ClipControl.isTimeSource(dataTrack));
            control.setValue("model_footprint", dataTrack.getModelFootprintName());
            control.setValue("model_footprint_color", dataTrack.getModelFootprint().getColor());
            if (dataTrack.modelFootprintVisible) {
                control.setValue("model_footprint_visible", true);
            }
            if (dataTrack.modelBuilder != null && dataTrack.tp != null && dataTrack.tframe != null) {
                TFrame frame = dataTrack.tframe;
                int x = dataTrack.modelBuilder.getLocation().x - frame.getLocation().x;
                int y = dataTrack.modelBuilder.getLocation().y - frame.getLocation().y;
                control.setValue("inspector_x", x);
                control.setValue("inspector_y", y);
                control.setValue("inspector_h", dataTrack.modelBuilder.getHeight());
                control.setValue("inspector_visible", dataTrack.modelBuilder.isVisible());
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            double[][] coreData = this.getCoreData(control);
            ArrayList<Object[]> pointData = this.getMoreData(control);
            return new ParticleDataTrack(coreData, pointData, null);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            ParticleDataTrack dataTrack = (ParticleDataTrack)obj;
            if (dataTrack.getPointName().equals(control.getString("pointname"))) {
                dataTrack.setCoreData(this.getCoreData(control), true);
                dataTrack.setMoreData(this.getMoreData(control));
            }
            XML.getLoader(TTrack.class).loadObject(control, obj);
            dataTrack.mass = control.getDouble("mass");
            dataTrack.setPointName(control.getString("pointname"));
            XMLControl dataClipControl = control.getChildControl(ParticleDataTrack.PROPERTY_PARTICLEDATATRACK_DATACLIP);
            if (dataClipControl != null) {
                dataClipControl.loadObject(dataTrack.getDataClip());
                String fileVersion = control.getString("semantic_version");
                XMLProperty parent = control;
                while (fileVersion == null && parent.getParentProperty() != null) {
                    if (!((parent = parent.getParentProperty()) instanceof XMLControl)) continue;
                    fileVersion = parent.getString("semantic_version");
                }
                if (fileVersion != null && !OSPRuntime.isJS) {
                    int result = 0;
                    try {
                        result = Tracker.compareVersions(fileVersion, "6.0.9");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (result < 0) {
                        dataTrack.requiresConversion = true;
                    }
                }
            }
            int i = 0;
            while (i < dataTrack.morePoints.size()) {
                ParticleDataTrack child = dataTrack.morePoints.get(i);
                child.setMass(control.getDouble("mass" + i));
                child.setColor((Color)control.getObject("color" + i));
                child.setFootprint(control.getString("footprint" + i));
                ++i;
            }
            dataTrack.useDataTime = control.getBoolean("use_data_time");
            int n = control.getInt("start_frame");
            if (n != Integer.MIN_VALUE) {
                int n2 = n;
                dataTrack.startFrameTemp = n2;
                dataTrack.startFrame = n2;
            } else {
                dataTrack.startFrameUndefined = true;
            }
            if (control.getPropertyNamesRaw().contains("model_footprint")) {
                dataTrack.setModelFootprint(control.getString("model_footprint"));
                dataTrack.modelFootprintVisible = control.getBoolean("model_footprint_visible");
                dataTrack.modelFootprint.setColor((Color)control.getObject("model_footprint_color"));
            } else {
                dataTrack.modelFootprint.setColor(dataTrack.getColor());
            }
            if (dataTrack.inspectorX == Integer.MIN_VALUE) {
                dataTrack.inspectorX = control.getInt("inspector_x");
                dataTrack.inspectorY = control.getInt("inspector_y");
                dataTrack.inspectorH = control.getInt("inspector_h");
                dataTrack.showModelBuilder = control.getBoolean("inspector_visible");
            }
            return dataTrack;
        }

        private double[][] getCoreData(XMLControl control) {
            double[][] coreData = new double[][]{(double[])control.getObject("x"), (double[])control.getObject("y"), (double[])control.getObject("t")};
            return coreData;
        }

        private ArrayList<Object[]> getMoreData(XMLControl control) {
            int i = 0;
            ArrayList<Object[]> pointData = new ArrayList<Object[]>();
            double[][] next = new double[2][];
            next[0] = (double[])control.getObject("x" + i);
            while (next[0] != null) {
                next[1] = (double[])control.getObject("y" + i);
                String name = control.getString("pointname" + i);
                pointData.add(new Object[]{name, next});
                next = new double[2][];
                next[0] = (double[])control.getObject("x" + ++i);
            }
            return pointData;
        }
    }
}

