/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.opensourcephysics.cabrillo.tracker.DataTrackClipControl;
import org.opensourcephysics.cabrillo.tracker.DataTrackTimeControl;
import org.opensourcephysics.cabrillo.tracker.ModelFunctionPanel;
import org.opensourcephysics.cabrillo.tracker.ParticleDataTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.UserFunctionEditor;

public class ParticleDataTrackFunctionPanel
extends ModelFunctionPanel {
    private DataTrackClipControl clipControl;
    private DataTrackTimeControl timeControl;
    private JPanel customControl;
    private JPanel customTitle;

    public ParticleDataTrackFunctionPanel(ParticleDataTrack track) {
        super(new UserFunctionEditor(), track);
        this.model = track;
        this.setName(track.getName());
        MouseAdapter listener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ParticleDataTrackFunctionPanel.this.clearSelection();
            }
        };
        this.clipControl = new DataTrackClipControl(track);
        this.clipControl.addMouseListenerToAll(listener);
        this.timeControl = new DataTrackTimeControl(track);
        this.timeControl.addMouseListener(listener);
    }

    @Override
    protected void createGUI() {
        super.createGUI();
        this.box.remove(this.paramEditor);
        this.box.remove(this.functionEditor);
        this.box.add((Component)this.clipControl, 1);
        this.box.add((Component)this.timeControl, 2);
    }

    @Override
    protected void refreshGUI() {
        ParticleDataTrack dataTrack;
        Object dataSource;
        super.refreshGUI();
        if (this.model != null && (dataSource = (dataTrack = (ParticleDataTrack)this.model).getSource()) != null && dataSource instanceof JPanel) {
            this.setCustomControl((JPanel)dataSource);
        }
        if (this.customControl != null) {
            String title = TrackerRes.getString("ParticleDataTrackFunctionPanel.Border.Title");
            this.customTitle.setBorder(BorderFactory.createTitledBorder(title));
        }
        this.timeControl.refreshGUI();
    }

    public void setCustomControl(JPanel panel) {
        if (panel == this.customControl) {
            return;
        }
        if (this.customControl != null) {
            this.customTitle.remove(this.customControl);
            this.box.remove(this.customTitle);
        }
        this.customControl = panel;
        if (this.customControl != null) {
            if (this.customTitle == null) {
                this.customTitle = new JPanel(new BorderLayout());
            }
            this.customTitle.add((Component)this.customControl, "Center");
            this.box.add((Component)this.customTitle, 3);
            this.refreshGUI();
        }
    }

    protected void refreshTimeSource() {
        this.timeControl.setTimeSourceToDataTrack(this.timeControl.isTimeSourceDataTrack());
    }

    @Override
    protected String getCustomInstructions(FunctionEditor source, int selectedColumn) {
        return TrackerRes.getString("ParticleDataTrackFunctionPanel.Instructions.General");
    }

    @Override
    protected void tabToNext(FunctionEditor editor) {
        this.clipControl.requestFocusInWindow();
    }
}

