/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.opensourcephysics.cabrillo.tracker.CircleFootprint;
import org.opensourcephysics.cabrillo.tracker.DynamicSystem;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.ModelBuilder;
import org.opensourcephysics.cabrillo.tracker.ModelFunctionPanel;
import org.opensourcephysics.cabrillo.tracker.ParticleDataTrack;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.ReferenceFrame;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.InitialValueEditor;
import org.opensourcephysics.tools.ParamEditor;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public abstract class ParticleModel
extends PointMass {
    protected static int tracePtsPerStep = 10;
    protected static boolean loading = false;
    protected static Point2D.Double nan = new Point2D.Double(Double.NaN, Double.NaN);
    protected static double xLimit = 8000.0;
    protected static double yLimit = 6000.0;
    protected static NumberFormat timeFormat = NumberFormat.getNumberInstance();
    protected ModelBuilder modelBuilder;
    protected ModelFunctionPanel functionPanel;
    protected UserFunctionEditor functionEditor;
    protected int inspectorX = Integer.MIN_VALUE;
    protected int inspectorY;
    protected int inspectorH = Integer.MIN_VALUE;
    protected boolean showModelBuilder;
    protected boolean refreshing = false;
    protected double[] traceX = new double[0];
    protected double[] traceY = new double[0];
    protected double[] prevX;
    protected double[] prevY;
    protected TPoint tracePt = new TPoint();
    private int lastValidFrame = -1;
    protected double t0;
    protected double dt = 0.1;
    protected double time;
    protected boolean refreshDerivsLater;
    protected boolean refreshStepsLater;
    protected boolean invalidWarningShown;
    protected boolean startFrameUndefined;
    protected int startFrame;
    protected int endFrame = Integer.MAX_VALUE;
    protected boolean useDefaultReferenceFrame;
    protected JMenuItem modelBuilderItem;
    protected JMenuItem useDefaultRefFrameItem;
    protected JMenuItem stampItem;
    protected PropertyChangeListener massParamListener;
    protected PropertyChangeListener timeParamListener;
    private static final String[] panelEventsParticleModel;
    protected Point2D.Double[] points;
    protected int myPoint = 0;
    private ParticleModel[] me = new ParticleModel[]{this};
    protected static int nCalc;

    static {
        timeFormat.setMinimumIntegerDigits(1);
        timeFormat.setMaximumFractionDigits(3);
        timeFormat.setMinimumFractionDigits(3);
        timeFormat.setGroupingUsed(false);
        panelEventsParticleModel = new String[]{"frameduration", "function", "starttime", "startframe", "stepcount", "selectedtrack", "units"};
        nCalc = 0;
    }

    protected abstract void initializeFunctionPanel();

    protected void setLastValidFrame(int i) {
        this.lastValidFrame = i;
    }

    protected int getLastValidFrame() {
        return this.lastValidFrame;
    }

    public ParticleModel() {
        this.drawsTrace = true;
        Footprint[] footprints = super.getFootprints();
        Footprint[] newprints = new Footprint[footprints.length + 1];
        newprints[0] = CircleFootprint.getFootprint("CircleFootprint.FilledCircle");
        int i = 0;
        while (i < footprints.length) {
            newprints[i + 1] = footprints[i];
            ++i;
        }
        this.setFootprints(newprints);
        this.defaultFootprint = newprints[0];
        this.setFootprint(this.defaultFootprint.getName());
        this.setName(TrackerRes.getString("ParticleModel.New.Name"));
        this.initializeFunctionPanel();
        this.hint = TrackerRes.getString("ParticleModel.Hint");
    }

    @Override
    public void draw(DrawingPanel panel, Graphics _g) {
        if (!(panel instanceof TrackerPanel) || this.tp == null) {
            return;
        }
        if (this.isVisible() && this.tp.getFrameNumber() > this.lastValidFrame) {
            this.refreshSteps("draw");
        }
        this.drawMe(panel, _g);
    }

    public void drawMe(DrawingPanel panel, Graphics _g) {
        if (this.inspectorX != Integer.MIN_VALUE && this.tp != null && this.tframe != null && this.showModelBuilder) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ParticleModel.this.positionModelBuilder();
                    ParticleModel.this.showModelBuilder = false;
                    ParticleModel.this.modelBuilder.setVisible(true);
                }
            });
        }
        if (this.isVisible() && this.isTraceVisible()) {
            boolean fixed;
            TrackerPanel tPanel = (TrackerPanel)panel;
            ImageCoordSystem coords = tPanel.getCoords();
            boolean isRefFrame = coords instanceof ReferenceFrame;
            if (isRefFrame) {
                coords = ((ReferenceFrame)coords).getCoords();
            }
            boolean bl = fixed = coords.isFixedAngle() && coords.isFixedOrigin() && coords.isFixedScale();
            if (!(!fixed || tPanel.isWorldPanel() && isRefFrame)) {
                this.trace.reset();
                int i = 0;
                while (i < this.traceX.length) {
                    if (!Double.isNaN(this.traceX[i])) {
                        this.tracePt.setLocation(this.traceX[i], this.traceY[i]);
                        Point p = this.tracePt.getScreenPosition(tPanel);
                        if (this.trace.getCurrentPoint() == null) {
                            this.trace.moveTo((float)p.getX(), (float)p.getY());
                        } else {
                            this.trace.lineTo((float)p.getX(), (float)p.getY());
                        }
                    }
                    ++i;
                }
                Graphics2D g2 = (Graphics2D)_g;
                Color color = g2.getColor();
                Stroke stroke = g2.getStroke();
                g2.setColor(this.getFootprint().getColor());
                g2.setStroke(this.traceStroke);
                if (OSPRuntime.setRenderingHints) {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                g2.draw(this.trace);
                g2.setColor(color);
                g2.setStroke(stroke);
            }
        }
        super.draw(panel, _g);
    }

    @Override
    public void delete() {
        ModelBuilder modelBuilder = null;
        if (this.tp != null && this.tp.modelBuilder != null) {
            ArrayList<ParticleModel> list = this.tp.getDrawablesTemp(ParticleModel.class);
            if (list.size() == 1) {
                modelBuilder = this.tp.modelBuilder;
            }
            list.clear();
        }
        super.delete();
        if (modelBuilder != null) {
            modelBuilder.setVisible(false);
        }
    }

    @Override
    public void setTrackerPanel(TrackerPanel panel) {
        if (this.tp != null) {
            this.removePanelEvents(panelEventsParticleModel);
            if (this.tframe != null) {
                this.tframe.removePropertyChangeListener("tab", this);
            }
        }
        super.setTrackerPanel(panel);
        if (this.tp != null) {
            this.addPanelEvents(panelEventsParticleModel);
            if (this.startFrameUndefined) {
                int n = panel.getPlayer().getVideoClip().getStartFrameNumber();
                this.setStartFrame(n);
                this.startFrameUndefined = false;
            }
            if (this.tframe != null) {
                boolean radians = this.tframe.isAnglesInRadians();
                this.functionPanel.initEditor.setAnglesInDegrees(!radians);
            }
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (this.tp == null) {
            return;
        }
        boolean dorefresh = !this.refreshing && this.isModelsVisible();
        String resetMe = null;
        switch (e.getPropertyName()) {
            default: {
                return;
            }
            case "tab": {
                if (this.modelBuilder == null) return;
                if (this.tframe.isRemovingAll()) return;
                if (this.tp != null && e.getNewValue() == this.tp && this.tp.isModelBuilderVisible) {
                    this.modelBuilder.setVisible(true);
                    return;
                }
                if (!this.modelBuilder.isVisible()) return;
                if (e.getNewValue() == null) return;
                this.modelBuilder.setVisible(false);
                this.tp.isModelBuilderVisible = true;
                return;
            }
            case "selectedtrack": {
                if (e.getNewValue() != this) return;
                if (this.modelBuilder == null) return;
                if (this.modelBuilder.getSelectedName().equals(this.getName())) return;
                this.modelBuilder.setSelectedPanel(this.getName());
                return;
            }
            case "stepcount": {
                if (!dorefresh) return;
                this.refreshInitialTime();
                this.refreshSteps(this.name);
                return;
            }
            case "adjusting": {
                if (!dorefresh) return;
                this.refreshStepsLater = (Boolean)e.getNewValue();
                if (this.refreshStepsLater) return;
                this.refreshSteps(this.name);
                return;
            }
            case "units": {
                this.setAnglesInRadians(this.tp.getTFrame().isAnglesInRadians());
                return;
            }
            case "function": {
                if (!loading) {
                    this.tp.changed = true;
                }
                resetMe = "repaint";
                break;
            }
            case "starttime": 
            case "startframe": 
            case "frameduration": {
                resetMe = "time";
                break;
            }
            case "stepsize": {
                resetMe = "refresh";
                break;
            }
            case "transform": {
                ImageCoordSystem coords = this.tp.getCoords();
                if (coords instanceof ReferenceFrame && ((ReferenceFrame)coords).getOriginTrack() == this) {
                    return;
                }
                resetMe = "refresh";
            }
        }
        this.setLastValidFrame(-1);
        if (!dorefresh) return;
        switch (resetMe) {
            case "repaint": {
                this.repaint();
                return;
            }
            case "refresh": {
                this.refreshSteps(this.name);
                return;
            }
            case "time": {
                this.refreshInitialTime();
                this.refreshSteps(this.name);
                return;
            }
        }
    }

    @Override
    public double getMass() {
        Parameter massParam = (Parameter)this.getParamEditor().getObject("m");
        if (massParam != null) {
            return massParam.getValue();
        }
        return super.getMass();
    }

    @Override
    public void setMass(double mass) {
        super.setMass(mass);
        mass = super.getMass();
        this.massField.setValue(mass);
        Parameter massParam = (Parameter)this.getParamEditor().getObject("m");
        if (massParam != null && massParam.getValue() != mass) {
            this.functionPanel.getParamEditor().setExpression("m", String.valueOf(mass), false);
            this.refreshSteps("setMass");
        }
    }

    @Override
    public void setName(String name) {
        String prevName = this.getName();
        super.setName(name);
        if (this.modelBuilder != null) {
            this.modelBuilder.renamePanel(prevName, name);
        }
    }

    public String getDisplayName() {
        return this.getName("model");
    }

    @Override
    protected boolean isAutoTrackable() {
        return false;
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        Interactive ia = super.findInteractive(panel, xpix, ypix);
        if (ia instanceof PositionStep.Position) {
            this.hint = TrackerRes.getString("PointMass.Position.Locked.Hint");
        } else if (ia == null) {
            this.hint = TrackerRes.getString("ParticleModel.Hint");
        }
        return ia;
    }

    @Override
    public void setLocked(boolean locked) {
    }

    @Override
    public boolean isDependent() {
        return true;
    }

    @Override
    public boolean isStepComplete(int n) {
        return true;
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel, JMenu menu0) {
        if (this.modelBuilderItem == null) {
            this.modelBuilderItem = new JMenuItem();
            this.modelBuilderItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParticleModel.this.positionModelBuilder();
                    ParticleModel.this.getModelBuilder().setVisible(true);
                    ParticleModel.this.getModelBuilder().setSelectedPanel(ParticleModel.this.getName());
                }
            });
            this.useDefaultRefFrameItem = new JCheckBoxMenuItem();
            this.useDefaultRefFrameItem.setSelected(!this.useDefaultReferenceFrame);
            this.useDefaultRefFrameItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParticleModel.this.setUseDefaultReferenceFrame(!ParticleModel.this.useDefaultRefFrameItem.isSelected());
                    if (ParticleModel.this.tp.getCoords() instanceof ReferenceFrame) {
                        ParticleModel.this.setLastValidFrame(-1);
                        ParticleModel.this.refreshSteps("useDefRefFrameItem action");
                    }
                }
            });
            this.stampItem = new JMenuItem();
            this.stampItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParticleModel.this.doStamp();
                }
            });
        }
        this.modelBuilderItem.setText(TrackerRes.getString("ParticleModel.MenuItem.InspectModel"));
        this.useDefaultRefFrameItem.setText(TrackerRes.getString("ParticleModel.MenuItem.UseDefaultReferenceFrame"));
        String stamp = TrackerRes.getString("ParticleModel.MenuItem.Stamp");
        String pm = TrackerRes.getString("PointMass.Name");
        this.stampItem.setText(String.valueOf(stamp) + " " + pm);
        this.stampItem.setToolTipText(TrackerRes.getString("ParticleModel.MenuItem.Stamp.Tooltip"));
        JMenu menu = super.getMenu(trackerPanel, menu0);
        menu.remove(this.autotrackItem);
        menu.remove(this.deleteStepItem);
        menu.remove(this.clearStepsItem);
        if (trackerPanel.isEnabled("model.stamp")) {
            int i = menu.getItemCount();
            while (--i >= 0) {
                if (menu.getMenuComponent(i) != this.accelerationMenu) continue;
                menu.insert(this.stampItem, ++i);
                menu.insertSeparator(i);
                break;
            }
        }
        return this.assembleMenu(menu, this.modelBuilderItem);
    }

    protected void doStamp() {
        this.refreshSteps("stampItem action");
        PointMass pm = new PointMass();
        String proposed = String.valueOf(this.getName()) + " " + TrackerRes.getString("ParticleModel.Stamp.Name") + "1";
        for (TTrack track : this.tp.getTracksTemp()) {
            if (!proposed.equals(track.getName())) continue;
            try {
                int n = Integer.parseInt(proposed.substring(proposed.length() - 1));
                proposed = String.valueOf(proposed.substring(0, proposed.length() - 1)) + (n + 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.tp.clearTemp();
        pm.setName(proposed);
        pm.setColor(this.getColor().darker());
        this.tp.addTrack(pm);
        Step[] stepArray = this.getSteps();
        int n = stepArray.length;
        int n2 = 0;
        while (n2 < n) {
            Step step = stepArray[n2];
            if (step != null) {
                TPoint pt = step.getPoints()[0];
                int n3 = pt.getFrameNumber(this.tp);
                pm.createStep(n3, pt.x, pt.y);
            }
            ++n2;
        }
        TFrame.repaintT(this.tp);
    }

    @Override
    public ArrayList<Component> getToolbarPointComponents(TrackerPanel trackerPanel, TPoint point) {
        ArrayList<Component> list = super.getToolbarPointComponents(trackerPanel, point);
        this.xField.setEnabled(false);
        this.yField.setEnabled(false);
        this.magField.setEnabled(false);
        this.angleField.setEnabled(false);
        return list;
    }

    public void setStartFrame(int n) {
        VideoClip clip = this.tp.getPlayer().getVideoClip();
        n = Math.max(n, clip.getFirstFrameNumber());
        int end = clip.getLastFrameNumber();
        n = Math.min(n, end);
        if ((n = Math.min(n, this.getEndFrame())) == this.startFrame) {
            return;
        }
        this.startFrame = n;
        this.refreshInitialTime();
        this.setLastValidFrame(-1);
        this.refreshSteps("setStartFrame " + n);
        TFrame.repaintT(this.tp);
        this.firePropertyChange("model_start", null, this.getStartFrame());
    }

    public int getStartFrame() {
        return this.startFrame;
    }

    public void setEndFrame(int n) {
        VideoClip clip = this.tp.getPlayer().getVideoClip();
        int end = clip.getLastFrameNumber();
        n = Math.max(n, 0);
        if ((n = Math.max(n, this.getStartFrame())) == this.getEndFrame()) {
            return;
        }
        int n2 = this.endFrame = n < end ? n : Integer.MAX_VALUE;
        if (n < this.lastValidFrame) {
            this.trimSteps();
        } else {
            this.refreshSteps("setEndFrame " + this.endFrame);
        }
        TFrame.repaintT(this.tp);
        this.firePropertyChange("model_end", null, this.getEndFrame());
    }

    public int getEndFrame() {
        return this.endFrame;
    }

    @Override
    protected void setAnglesInRadians(boolean radians) {
        super.setAnglesInRadians(radians);
        this.functionPanel.initEditor.setAnglesInDegrees(!radians);
        String units = radians ? TrackerRes.getString("TableTrackView.Radians.Tooltip") : TrackerRes.getString("TableTrackView.Degrees.Tooltip");
        String s = TrackerRes.getString("DynamicParticle.Parameter.InitialTheta.Description");
        s = String.valueOf(s) + " " + units;
        this.functionPanel.initEditor.setDescription(FunctionEditor.THETA, s);
        s = TrackerRes.getString("DynamicParticle.Parameter.InitialOmega.Description");
        s = String.valueOf(s) + " " + units + "/" + this.tp.getTimeUnit();
        this.functionPanel.initEditor.setDescription(FunctionEditor.OMEGA, s);
    }

    abstract boolean getNextTracePositions();

    protected abstract void reset();

    protected ParticleModel[] getModels() {
        return this.me;
    }

    protected boolean isModelsVisible() {
        ParticleModel[] particleModelArray = this.getModels();
        int n = particleModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParticleModel model = particleModelArray[n2];
            if (model.isTraceVisible() || model.isVisible() && (model.isPositionVisible() || model.isVVisible() || model.isAVisible())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void refreshInitialTime() {
        if (this.tp == null) {
            return;
        }
        double t0 = this.tp.getPlayer().getFrameTime(this.getStartFrame()) / 1000.0;
        String t = timeFormat.format(t0);
        Parameter param = (Parameter)this.getInitEditor().getObject("t");
        if (param.getValue() != t0) {
            boolean prev = this.refreshing;
            this.refreshing = true;
            this.getInitEditor().setExpression("t", t, false);
            this.refreshing = prev;
        }
    }

    protected void refreshSteps(String why) {
        this.locked = true;
        if (this.refreshStepsLater || this.tp == null || this instanceof DynamicSystem && ((DynamicSystem)this).particles.length == 0) {
            return;
        }
        this.refreshDerivsLater = this.tp.getPlayer().getClipControl().isPlaying();
        int n = this.tp.getFrameNumber();
        VideoClip clip = this.tp.getPlayer().getVideoClip();
        int end = Math.min(this.getEndFrame(), n);
        int start = this.getStartFrame();
        while (end > start && !clip.includesFrame(end)) {
            --end;
        }
        if (end <= this.lastValidFrame) {
            return;
        }
        if (this.lastValidFrame == -1) {
            this.reset();
            if (this.lastValidFrame == -1 || end <= this.lastValidFrame) {
                return;
            }
        }
        this.holdPainting(true);
        start = this.lastValidFrame;
        if (Tracker.timeLogEnabled) {
            Tracker.logTime(String.valueOf(this.getClass().getSimpleName()) + this.hashCode() + " refreshing steps " + start + " to " + end);
        }
        boolean singleStep = end - start == 1;
        ImageCoordSystem coords = this.tp.getCoords();
        boolean useDefault = this.isUseDefaultReferenceFrame();
        while (useDefault && coords instanceof ReferenceFrame) {
            coords = ((ReferenceFrame)coords).getCoords();
        }
        double startTime = this.t0 + this.dt * (double)tracePtsPerStep * (double)(start - this.getStartFrame()) / (double)clip.getStepSize();
        double stepSize = 1.0 * (double)clip.getStepSize() / (double)tracePtsPerStep;
        int stepCount = tracePtsPerStep * (end - start) / clip.getStepSize();
        ParticleModel[] models = this.getModels();
        int nmodels = models.length;
        int i = 0;
        while (i < nmodels) {
            ParticleModel model = models[i];
            model.locked = false;
            int traceLength = model.traceX.length + stepCount;
            model.prevX = model.traceX;
            model.prevY = model.traceY;
            model.traceX = Arrays.copyOf(model.prevX, traceLength);
            model.traceY = Arrays.copyOf(model.prevY, traceLength);
            ++i;
        }
        i = 0;
        while (i < stepCount) {
            int stepNumber = i + 1;
            int frameNumber = start + (int)((double)stepNumber * stepSize);
            this.time = startTime + (double)stepNumber * this.dt;
            if (this.getNextTracePositions()) {
                AffineTransform transform = coords.getToImageTransform(frameNumber);
                int j = 0;
                while (j < nmodels) {
                    boolean valid;
                    transform.transform(this.points[j], this.points[j]);
                    boolean bl = valid = Math.abs(this.points[j].x) < xLimit && Math.abs(this.points[j].y) < yLimit;
                    if (!valid && !this.invalidWarningShown) {
                        this.invalidWarningShown = true;
                        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.tp, String.valueOf(TrackerRes.getString("ParticleModel.Dialog.Offscreen.Message1")) + XML.NEW_LINE + TrackerRes.getString("ParticleModel.Dialog.Offscreen.Message2"), TrackerRes.getString("ParticleModel.Dialog.Offscreen.Title"), 2));
                    }
                    models[j].traceX[models[j].prevX.length + i] = valid ? this.points[j].x : Double.NaN;
                    double d = models[j].traceY[models[j].prevY.length + i] = valid ? this.points[j].y : Double.NaN;
                    if (stepNumber % tracePtsPerStep == 0) {
                        this.saveState(frameNumber);
                        PositionStep step = (PositionStep)models[j].getStep(frameNumber);
                        if (step == null) {
                            step = this.createPositionStep(models[j], frameNumber, 0.0, 0.0);
                            step.setFootprint(models[j].getFootprint());
                            models[j].steps.setStep(frameNumber, step);
                        }
                        step.getPosition().setPosition(valid ? this.points[j] : nan);
                    }
                    ++j;
                }
            }
            ++i;
        }
        int count = 4 + (end - start);
        int startUpdate = start;
        if (startUpdate > clip.getStepSize()) {
            startUpdate -= clip.getStepSize();
        }
        if (startUpdate > clip.getStepSize()) {
            startUpdate -= clip.getStepSize();
        }
        this.setLastValidFrame(end);
        int m = 0;
        while (m < nmodels) {
            ParticleModel model = models[m];
            model.steps.setLength(end + 1);
            coords = this.tp.getCoords();
            if (coords instanceof ReferenceFrame && ((ReferenceFrame)coords).getOriginTrack() == model) {
                boolean prev = model.refreshing;
                model.refreshing = true;
                ((ReferenceFrame)coords).setOrigins();
                int i2 = 0;
                int ns = clip.getStepCount();
                while (i2 < ns) {
                    int frameNumber = clip.stepToFrame(i2);
                    PositionStep step = (PositionStep)model.getStep(frameNumber);
                    if (step != null) {
                        AffineTransform transform = coords.getToImageTransform(frameNumber);
                        Point2D.Double point = model.points[model.myPoint];
                        point.setLocation(0.0, 0.0);
                        transform.transform(point, point);
                        step.getPosition().setPosition(point);
                    }
                    ++i2;
                }
                model.refreshing = prev;
            }
            if (!this.refreshDerivsLater) {
                model.updateDerivatives(startUpdate, count);
            }
            if (model.vAtOrigin) {
                model.vTailsToOriginItem.doClick();
            }
            if (model.aAtOrigin) {
                model.aTailsToOriginItem.doClick();
            }
            if (!this.refreshDerivsLater && singleStep) {
                this.holdPainting(false);
                model.firePropertyChange("step", null, new Integer(n));
            }
            int i3 = start + 1;
            while (i3 <= end) {
                Step step = model.getStep(i3);
                if (step != null) {
                    step.erase();
                }
                ++i3;
            }
            model.locked = true;
            ++m;
        }
        this.holdPainting(false);
        if (!this.refreshDerivsLater && !singleStep) {
            this.fireStepsChanged();
        }
        TFrame.repaintT(this.tp);
    }

    protected void holdPainting(boolean b) {
        this.tframe.holdPainting(b);
    }

    @Override
    public void fireStepsChanged() {
        ParticleModel[] models = this.getModels();
        int m = 0;
        int n = models.length - 1;
        while (m < n) {
            models[m].fireStepsChanged();
            ++m;
        }
        super.fireStepsChanged();
    }

    protected PositionStep createPositionStep(PointMass track, int n, double x, double y) {
        PositionStep newStep = new PositionStep(track, n, x, y);
        newStep.valid = !Double.isNaN(x) && !Double.isNaN(y);
        return newStep;
    }

    protected void refreshDerivsIfNeeded() {
        if (!this.refreshDerivsLater) {
            return;
        }
        this.refreshDerivsLater = false;
        ParticleModel[] particleModelArray = this.getModels();
        int n = particleModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParticleModel part = particleModelArray[n2];
            part.updateDerivatives();
            ++n2;
        }
        this.fireStepsChanged();
    }

    protected void trimSteps() {
        ParticleModel[] models;
        VideoClip clip = this.tp.getPlayer().getVideoClip();
        int n = clip.getFrameCount() - 1;
        int end = this.getEndFrame() == Integer.MAX_VALUE ? n : this.getEndFrame();
        while (end > this.getStartFrame() && !clip.includesFrame(end)) {
            --end;
        }
        if (end >= this.lastValidFrame) {
            return;
        }
        int trimCount = tracePtsPerStep * (this.lastValidFrame - end) / clip.getStepSize();
        ParticleModel[] particleModelArray = models = this.getModels();
        int n2 = models.length;
        int n3 = 0;
        while (n3 < n2) {
            ParticleModel next = particleModelArray[n3];
            next.locked = false;
            int traceLength = next.traceX.length - trimCount;
            if (traceLength < 0) {
                return;
            }
            next.prevX = next.traceX;
            next.prevY = next.traceY;
            next.traceX = new double[traceLength];
            next.traceY = new double[traceLength];
            System.arraycopy(next.prevX, 0, next.traceX, 0, traceLength);
            System.arraycopy(next.prevY, 0, next.traceY, 0, traceLength);
            next.steps.setLength(end + 1);
            next.updateDerivatives(end - 2, this.lastValidFrame - end + 2);
            this.restoreState(end);
            next.locked = true;
            ++n3;
        }
        this.fireStepsChanged();
        this.setLastValidFrame(end);
        this.repaint();
    }

    protected void saveState(int frameNumber) {
    }

    protected boolean restoreState(int frameNumber) {
        return false;
    }

    protected boolean isUseDefaultReferenceFrame() {
        ImageCoordSystem coords = this.tp.getCoords();
        if (coords instanceof ReferenceFrame && ((ReferenceFrame)coords).getOriginTrack() == this) {
            return true;
        }
        return this.useDefaultReferenceFrame;
    }

    public void setUseDefaultReferenceFrame(boolean useDefault) {
        this.useDefaultReferenceFrame = useDefault;
    }

    public ModelBuilder getModelBuilder() {
        boolean newBuilder;
        if (this.tp == null) {
            return null;
        }
        boolean bl = newBuilder = this.tp.modelBuilder == null;
        if (this.modelBuilder == null) {
            this.modelBuilder = this.tp.getModelBuilder();
            this.modelBuilder.addPanel(this.getName(), this.functionPanel);
            this.modelBuilder.addPropertyChangeListener(this);
            if (this.tframe != null) {
                this.tframe.addPropertyChangeListener("tab", this);
            }
            if (this.getInitEditor().getValues()[0] == 0.0) {
                this.refreshInitialTime();
                this.getInitEditor().getTable().clearSelection();
            }
        }
        if (newBuilder) {
            ArrayList<ParticleModel> models = this.tp.getDrawables(ParticleModel.class);
            int i = 0;
            while (i < models.size()) {
                if (models.get(i) instanceof ParticleDataTrack) {
                    ParticleDataTrack model = (ParticleDataTrack)models.get(i);
                    model = model.getLeader();
                    model.getModelBuilder();
                } else {
                    models.get(i).getModelBuilder();
                }
                ++i;
            }
        }
        return this.modelBuilder;
    }

    protected void createMassAndTimeParameters() {
        Parameter param = new Parameter("m", String.valueOf(this.getMass()));
        param.setNameEditable(false);
        param.setDescription(TrackerRes.getString("ParticleModel.Parameter.Mass.Description"));
        this.getParamEditor().addObject(param, false);
        this.functionPanel.getInitEditor().addObject(ParticleModel.newTimeParam(), false);
        this.massParamListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                double m;
                if ("m".equals(e.getOldValue()) && ParticleModel.this.mass != (m = ((Parameter)ParticleModel.this.getParamEditor().getObject("m")).getValue())) {
                    ParticleModel.this.setMass(m);
                }
            }
        };
        this.getParamEditor().addPropertyChangeListener(this.massParamListener);
        this.timeParamListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (ParticleModel.this.refreshing) {
                    return;
                }
                if ("t".equals(e.getOldValue()) && ParticleModel.this.tp != null) {
                    VideoClip clip = ParticleModel.this.tp.getPlayer().getVideoClip();
                    double timeOffset = ((Parameter)ParticleModel.this.getInitEditor().getObject("t")).getValue() * 1000.0 - clip.getStartTime();
                    double dt = ParticleModel.this.tp.getPlayer().getMeanStepDuration();
                    int n = clip.getStartFrameNumber();
                    boolean mustRound = timeOffset % dt > 0.0;
                    ParticleModel.this.setStartFrame(n += clip.getStepSize() * (int)Math.round(timeOffset / dt));
                    if (ParticleModel.this.getStartFrame() != n || mustRound) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
        };
        this.getInitEditor().addPropertyChangeListener(this.timeParamListener);
    }

    public double[] getInitialValues() {
        return this.functionPanel.getInitEditor().getValues();
    }

    public ParamEditor getParamEditor() {
        return this.functionPanel.getParamEditor();
    }

    public InitialValueEditor getInitEditor() {
        return this.functionPanel.getInitEditor();
    }

    public UserFunctionEditor getFunctionEditor() {
        return this.functionPanel.getUserFunctionEditor();
    }

    private void positionModelBuilder() {
        if (this.inspectorX != Integer.MIN_VALUE && this.inspectorX != Integer.MAX_VALUE) {
            this.refreshing = !this.showModelBuilder;
            loading = true;
            this.getModelBuilder();
            loading = false;
            this.refreshing = false;
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            if (this.inspectorH != Integer.MIN_VALUE) {
                this.modelBuilder.setSize(this.modelBuilder.getWidth(), Math.min(this.inspectorH, dim.height));
            }
            int x = Math.max(this.tframe.getLocation().x + this.inspectorX, 0);
            x = Math.min(x, dim.width - this.modelBuilder.getWidth());
            int y = Math.max(this.tframe.getLocation().y + this.inspectorY, 0);
            y = Math.min(y, dim.height - this.modelBuilder.getHeight());
            this.modelBuilder.setLocation(x, y);
            this.inspectorX = Integer.MAX_VALUE;
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    @Override
    public void dispose() {
        if (this.modelBuilder != null) {
            this.getParamEditor().removePropertyChangeListener(this.massParamListener);
            this.getInitEditor().removePropertyChangeListener(this.timeParamListener);
            this.functionPanel.dispose();
            this.massParamListener = null;
            this.timeParamListener = null;
            this.modelBuilder.removePanel(this.getName());
            this.modelBuilder.removePropertyChangeListener(this);
            if (this.modelBuilder.isEmpty()) {
                this.modelBuilder.setVisible(false);
            }
            this.modelBuilder = null;
        }
        this.functionPanel = null;
        this.functionEditor = null;
        if (this.tframe != null) {
            this.tframe.removePropertyChangeListener("tab", this);
        }
        super.dispose();
    }

    public static FunctionEditor.FObject newTimeParam() {
        Parameter param = new Parameter("t", "0");
        param.setNameEditable(false);
        param.setDescription(TrackerRes.getString("ParticleModel.Parameter.InitialTime.Description"));
        return param;
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            ParticleModel p = (ParticleModel)obj;
            control.setValue("mass", p.getMass());
            XML.getLoader(TTrack.class).saveObject(control, obj);
            Footprint fp = p.getVelocityFootprint();
            if (!fp.getColor().equals(p.getColor())) {
                control.setValue("velocity_color", fp.getColor());
            }
            if (!fp.getName().equals(p.getVelocityFootprints()[0].getName())) {
                control.setValue("velocity_footprint", fp.getName());
            }
            if (!(fp = p.getAccelerationFootprint()).getColor().equals(p.getColor())) {
                control.setValue("acceleration_color", fp.getColor());
            }
            if (!fp.getName().equals(p.getAccelerationFootprints()[0].getName())) {
                control.setValue("acceleration_footprint", fp.getName());
            }
            Parameter[] params = p.getParamEditor().getParameters();
            control.setValue("user_parameters", params);
            Parameter[] inits = p.getInitEditor().getParameters();
            control.setValue("initial_values", inits);
            UserFunction[] functions = p.getFunctionEditor().getMainFunctions();
            control.setValue("main_functions", functions);
            functions = p.getFunctionEditor().getSupportFunctions();
            if (functions.length > 0) {
                control.setValue("support_functions", functions);
            }
            if (p.startFrame > 0) {
                control.setValue("start_frame", p.startFrame);
            }
            if (p.endFrame < Integer.MAX_VALUE) {
                control.setValue("end_frame", p.endFrame);
            }
            if (p.modelBuilder != null && p.tp != null && p.tframe != null) {
                int x = p.modelBuilder.getLocation().x - p.tframe.getLocation().x;
                int y = p.modelBuilder.getLocation().y - p.tframe.getLocation().y;
                control.setValue("inspector_x", x);
                control.setValue("inspector_y", y);
                control.setValue("inspector_h", p.modelBuilder.getHeight());
                control.setValue("inspector_visible", p.modelBuilder.isVisible());
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            Color c;
            XML.getLoader(TTrack.class).loadObject(control, obj);
            ParticleModel p = (ParticleModel)obj;
            double m = control.getDouble("mass");
            if (m != Double.NaN) {
                p.mass = m;
            }
            if ((c = (Color)control.getObject("velocity_color")) != null) {
                p.setVelocityColor(c);
            } else {
                p.setVelocityColor(p.getColor());
            }
            String s = control.getString("velocity_footprint");
            if (s != null) {
                p.setVelocityFootprint(s);
            } else {
                p.setVelocityFootprint(p.getVelocityFootprints()[0].getName());
            }
            c = (Color)control.getObject("acceleration_color");
            if (c != null) {
                p.setAccelerationColor(c);
            } else {
                p.setAccelerationColor(p.getColor());
            }
            s = control.getString("acceleration_footprint");
            if (s != null) {
                p.setAccelerationFootprint(s);
            } else {
                p.setAccelerationFootprint(p.getAccelerationFootprints()[0].getName());
            }
            if (p.inspectorX == Integer.MIN_VALUE) {
                p.inspectorX = control.getInt("inspector_x");
                p.inspectorY = control.getInt("inspector_y");
                p.inspectorH = control.getInt("inspector_h");
            }
            p.showModelBuilder = control.getBoolean("inspector_visible");
            Parameter[] params = (Parameter[])control.getObject("user_parameters");
            p.getParamEditor().setParameters(params);
            params = (Parameter[])control.getObject("initial_values");
            int i = 0;
            while (i < params.length) {
                Parameter param = params[i];
                String name = param.getName();
                int n = name.lastIndexOf("0");
                if (n > -1) {
                    name = name.substring(0, n);
                    Parameter newParam = new Parameter(name, param.getExpression());
                    newParam.setDescription(param.getDescription());
                    newParam.setNameEditable(false);
                    params[i] = newParam;
                }
                ++i;
            }
            p.getInitEditor().setParameters(params);
            UserFunction[] functions = (UserFunction[])control.getObject("main_functions");
            p.getFunctionEditor().setMainFunctions(functions);
            UserFunction[] funcs = p.getFunctionEditor().getSupportFunctions();
            int k = 0;
            while (k < funcs.length) {
                p.getFunctionEditor().removeObject(funcs[k], false);
                ++k;
            }
            functions = (UserFunction[])control.getObject("support_functions");
            if (functions != null) {
                int i2 = 0;
                while (i2 < functions.length) {
                    p.getFunctionEditor().addObject(functions[i2], false);
                    ++i2;
                }
            }
            p.functionPanel.refreshFunctions();
            int n = control.getInt("start_frame");
            if (n != Integer.MIN_VALUE) {
                p.startFrame = n;
            } else {
                p.startFrameUndefined = true;
            }
            n = control.getInt("end_frame");
            if (n != Integer.MIN_VALUE) {
                p.endFrame = n;
            }
            return obj;
        }
    }
}

