/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.tools.FontSizer;

public class PasteDataDialog
extends JDialog {
    protected TFrame frame;
    protected Integer panelID;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JTextArea messageArea;
    protected JTextArea textArea;
    protected JLabel label;

    public PasteDataDialog(TrackerPanel panel) {
        super((Frame)panel.getTFrame(), true);
        this.frame = panel.getTFrame();
        this.panelID = panel.getID();
        this.createGUI();
        this.setFontLevel(FontSizer.getLevel());
        this.pack();
        this.setLocationRelativeTo(panel);
        this.okButton.requestFocusInWindow();
    }

    public void setFontLevel(int level) {
        FontSizer.setFonts(this, level);
    }

    private void createGUI() {
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        this.messageArea = new JTextArea();
        this.messageArea.setEditable(false);
        Border empty = BorderFactory.createEmptyBorder(2, 4, 2, 4);
        Border etched = BorderFactory.createEtchedBorder();
        this.messageArea.setBorder(BorderFactory.createCompoundBorder(etched, empty));
        this.messageArea.setBackground(contentPane.getBackground());
        this.messageArea.setForeground(Color.black);
        contentPane.add((Component)this.messageArea, "North");
        this.textArea = new JTextArea(15, 30);
        this.textArea.setBorder(empty);
        this.textArea.setFont(new Font("monospaced", 0, this.textArea.getFont().getSize()));
        JScrollPane scroller = new JScrollPane(this.textArea);
        contentPane.add((Component)scroller, "Center");
        this.okButton = new JButton();
        this.okButton.setForeground(new Color(0, 0, 102));
        this.okButton.addActionListener(e -> {
            String data = this.textArea.getText();
            this.frame.getTrackerPanelForID(this.panelID).doPaste(data);
        });
        this.cancelButton = new JButton();
        this.cancelButton.setForeground(new Color(0, 0, 102));
        this.cancelButton.addActionListener(e -> this.setVisible(false));
        JPanel buttonbar = new JPanel();
        buttonbar.setBorder(BorderFactory.createEmptyBorder(1, 0, 3, 0));
        buttonbar.add(this.okButton);
        buttonbar.add(this.cancelButton);
        contentPane.add((Component)buttonbar, "South");
        this.refreshGUI();
    }

    protected void refreshGUI() {
        this.setTitle(TrackerRes.getString("PasteDataDialog.Title"));
        this.okButton.setText(TrackerRes.getString("Dialog.Button.Apply"));
        this.cancelButton.setText(TrackerRes.getString("Dialog.Button.Close"));
        String s = TrackerRes.getString("PasteDataDialog.Message1");
        s = String.valueOf(s) + "\n" + TrackerRes.getString("PasteDataDialog.Message2");
        this.messageArea.setText(s);
    }
}

