/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import org.opensourcephysics.cabrillo.tracker.PencilDrawer;
import org.opensourcephysics.cabrillo.tracker.PencilScene;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractiveTextLine;

public class PencilCaption
extends InteractiveTextLine {
    private static Cursor handCursor;
    static Font baseFont;
    private AffineTransform transform = new AffineTransform();
    private Rectangle2D bounds;
    private double offsetX;
    private double offsetY;
    private boolean isSelected;
    private double xMax;
    private double xMin;
    private double yMax;
    private double yMin;
    private Graphics graphics;

    static {
        baseFont = new Font("SansSerif", 0, 32);
        ImageIcon icon = (ImageIcon)Tracker.getResourceIcon("hand_cursor.gif", false);
        handCursor = GUIUtils.createCustomCursor(icon.getImage(), new Point(5, 0), "Hand", 0);
        XML.setLoader(PencilCaption.class, PencilCaption.getLoader());
    }

    public PencilCaption(String text, double x, double y, Font font) {
        super(text, x, y);
        this.setFont(font);
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        double mag;
        boolean refreshed;
        boolean bl = refreshed = this.graphics == null;
        if (refreshed) {
            this.graphics = g;
            this.refreshBounds(this.graphics);
        }
        if (this.getText() == null || this.getText().trim().equals("")) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        if (panel instanceof TrackerPanel) {
            TrackerPanel trackerPanel = (TrackerPanel)panel;
            if (!trackerPanel.isDrawingInImageSpace()) {
                return;
            }
            if (!refreshed) {
                this.refreshBounds(g);
            }
            mag = trackerPanel.getMagnification();
        } else {
            mag = panel.getXPixPerUnit();
        }
        g2.setColor(this.color);
        this.getPixelPt(panel);
        g2.translate(this.pixelPt.x, this.pixelPt.y);
        g2.scale(mag, mag);
        this.textLine.drawText(g2, 0, 0);
        g2.dispose();
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (!this.isEnabled() || !(panel instanceof TrackerPanel)) {
            return null;
        }
        if ("".equals(this.getText().trim())) {
            return null;
        }
        if (this.bounds == null) {
            return null;
        }
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        if (!PencilDrawer.isDrawing(trackerPanel)) {
            return null;
        }
        double mag = trackerPanel.getMagnification();
        this.transform.setToTranslation(panel.xToPix(this.x - this.bounds.getWidth() / 2.0), panel.yToPix(this.y - this.bounds.getHeight()));
        this.transform.scale(mag, mag);
        Shape s = this.transform.createTransformedShape(this.bounds);
        if (s.contains(xpix, ypix)) {
            return this;
        }
        return null;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.refreshBounds(this.graphics);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.refreshBounds(this.graphics);
    }

    @Override
    public boolean isMeasured() {
        return !"".equals(this.getText());
    }

    @Override
    public double getXMin() {
        return this.xMin;
    }

    @Override
    public double getXMax() {
        return this.xMax;
    }

    @Override
    public double getYMin() {
        return this.yMin;
    }

    @Override
    public double getYMax() {
        return this.yMax;
    }

    protected boolean handleMouseAction(MouseEvent e, TrackerPanel trackerPanel) {
        trackerPanel.setMouseCursor(handCursor);
        switch (trackerPanel.getMouseAction()) {
            case 7: {
                break;
            }
            case 1: {
                this.isSelected = true;
                this.offsetX = trackerPanel.getMouseX() - this.x;
                this.offsetY = trackerPanel.getMouseY() - this.y;
                PencilDrawer drawer = PencilDrawer.getDrawer(trackerPanel);
                PencilScene scene = drawer.getSceneWithCaption(this);
                drawer.drawingControl.setSelectedScene(scene);
                break;
            }
            case 3: {
                if (!this.isSelected) break;
                this.setXY(trackerPanel.getMouseX() - this.offsetX, trackerPanel.getMouseY() - this.offsetY);
                TFrame.repaintT(trackerPanel);
                break;
            }
            case 2: {
                this.isSelected = false;
                return true;
            }
            case 5: {
                this.isSelected = false;
                break;
            }
            case 6: {
                this.isSelected = false;
                break;
            }
            case 4: {
                this.isSelected = false;
            }
        }
        return false;
    }

    private void refreshBounds(Graphics g) {
        if (g == null) {
            return;
        }
        this.bounds = this.textLine.getStringBounds(g);
        this.xMax = this.x + this.bounds.getWidth() / 2.0;
        this.xMin = this.x - this.bounds.getWidth() / 2.0;
        this.yMax = this.y + this.bounds.getHeight() / 2.0;
        this.yMin = this.y - this.bounds.getHeight();
        this.bounds.setRect(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight() * 0.4);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            PencilCaption caption = (PencilCaption)obj;
            control.setValue("text", caption.getText());
            control.setValue("font_size", caption.getFont().getSize());
            control.setValue("colorRGB", caption.color.getRGB());
            double[] loc = new double[]{caption.getX(), caption.getY()};
            control.setValue("position", loc);
        }

        @Override
        public Object createObject(XMLControl control) {
            String text = control.getString("text");
            double[] loc = (double[])control.getObject("position");
            int size = control.getInt("font_size");
            float fontSize = size;
            Font font = baseFont.deriveFont(fontSize);
            return new PencilCaption(text, loc[0], loc[1], font);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            PencilCaption caption = (PencilCaption)obj;
            caption.color = new Color(control.getInt("colorRGB"));
            return caption;
        }
    }
}

