/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import org.opensourcephysics.cabrillo.tracker.MainTView;
import org.opensourcephysics.cabrillo.tracker.PencilCaption;
import org.opensourcephysics.cabrillo.tracker.PencilDrawer;
import org.opensourcephysics.cabrillo.tracker.PencilDrawing;
import org.opensourcephysics.cabrillo.tracker.PencilScene;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.display.ColorIcon;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.tools.FontSizer;

public class PencilControl
extends JDialog {
    static PencilScene dummyScene = new PencilScene();
    static Icon undoIcon;
    static Icon redoIcon;
    static Icon undoDisabledIcon;
    static Icon redoDisabledIcon;
    static Icon trailIcon;
    static Icon trailSelectedIcon;
    static Icon arrowIcon;
    static Icon arrowSelectedIcon;
    static Icon ellipseIcon;
    static Icon ellipseSelectedIcon;
    private static Color lightgrey;
    protected TFrame frame;
    protected Integer panelID;
    private PencilDrawer drawer;
    private PencilScene selectedScene;
    private JComboBox<PencilScene> sceneDropdown;
    private DrawingPanel canvas;
    private JLabel drawingLabel;
    private JLabel captionLabel;
    private JLabel framesLabel;
    private JLabel toLabel;
    private JSpinner startFrameSpinner;
    private JSpinner endFrameSpinner;
    private JTextField captionField;
    private JButton newSceneButton;
    private JButton deleteSceneButton;
    private JButton undoButton;
    private JButton redoButton;
    private JButton clearAllButton;
    private JButton closeButton;
    private JButton helpButton;
    private JButton trailButton;
    private JButton arrowButton;
    private JButton ellipseButton;
    private ColorButton[][] colorButtons;
    private Dimension canvasSize = new Dimension(120, 90);
    private boolean refreshing;
    private PropertyChangeListener stepListener;
    private PropertyChangeListener tabListener;
    private PropertyChangeListener clipListener;
    private int buttonWidth = 14;
    private boolean isVisible;
    private UndoableEditSupport undoSupport;
    private UndoManager undoManager;
    private AbstractAction postCaptionEditAction;
    private String prevCaptionText;
    JSpinner fontSizeSpinner;
    JCheckBox heavyCheckbox;

    static {
        lightgrey = new Color(230, 230, 230);
        undoIcon = Tracker.getResourceIcon("undo.gif", true);
        redoIcon = Tracker.getResourceIcon("redo.gif", true);
        undoDisabledIcon = Tracker.getResourceIcon("undo_disabled.gif", true);
        redoDisabledIcon = Tracker.getResourceIcon("redo_disabled.gif", true);
        trailIcon = Tracker.getResourceIcon("freeform.gif", true);
        trailSelectedIcon = Tracker.getResourceIcon("freeform_selected.gif", true);
        arrowIcon = Tracker.getResourceIcon("arrow.gif", true);
        arrowSelectedIcon = Tracker.getResourceIcon("arrow_selected.gif", true);
        ellipseIcon = Tracker.getResourceIcon("ellipse.gif", true);
        ellipseSelectedIcon = Tracker.getResourceIcon("ellipse_selected.gif", true);
    }

    protected PencilControl(PencilDrawer pencilDrawer) {
        super((Frame)pencilDrawer.frame, false);
        this.drawer = pencilDrawer;
        this.frame = this.drawer.frame;
        this.panelID = this.drawer.panelID;
        this.undoManager = new UndoManager();
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(this.undoManager);
        this.createGUI();
        this.refreshGUI();
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.getBounds().width) / 2;
        int y = (dim.height - this.getBounds().height) / 2;
        this.setLocation(x, y);
        this.stepListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                TrackerPanel trackerPanel = PencilControl.this.frame.getTrackerPanelForID(PencilControl.this.panelID);
                if (PencilControl.this.selectedScene != null && PencilControl.this.selectedScene.includesFrame(trackerPanel.getFrameNumber())) {
                    return;
                }
                if (PencilControl.this.isVisible()) {
                    PencilControl.this.setSelectedScene(PencilControl.this.drawer.getSceneAtFrame(trackerPanel.getFrameNumber()));
                    PencilControl.this.refreshGUI();
                }
            }
        };
        final TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        trackerPanel.addPropertyChangeListener("stepnumber", this.stepListener);
        this.tabListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (!PencilControl.this.frame.isRemovingAll() && e.getNewValue() == trackerPanel) {
                    PencilControl.this.setVisible(PencilControl.this.isVisible);
                } else {
                    boolean vis = PencilControl.this.isVisible;
                    PencilControl.this.setVisible(false);
                    PencilControl.this.isVisible = vis;
                }
            }
        };
        if (this.frame != null) {
            this.frame.addPropertyChangeListener("tab", this.tabListener);
        }
        this.clipListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                PencilControl.this.refreshGUI();
            }
        };
        trackerPanel.addPropertyChangeListener("stepcount", this.clipListener);
    }

    private void createGUI() {
        this.setResizable(false);
        this.drawingLabel = new JLabel();
        this.drawingLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 4));
        this.captionLabel = new JLabel();
        this.captionLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 4));
        this.framesLabel = new JLabel();
        this.framesLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        this.toLabel = new JLabel();
        this.toLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.newSceneButton = new JButton(){

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = super.getMaximumSize();
                dim.height = ((PencilControl)PencilControl.this).captionField.getPreferredSize().height + 4;
                return dim;
            }
        };
        this.newSceneButton.addActionListener(e -> {
            this.drawer.addNewScene();
            this.refreshGUI();
        });
        this.deleteSceneButton = new JButton(){

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = super.getMaximumSize();
                dim.height = ((PencilControl)PencilControl.this).captionField.getPreferredSize().height + 4;
                return dim;
            }
        };
        this.deleteSceneButton.addActionListener(e -> {
            boolean isEmpty = this.selectedScene.getDrawings().isEmpty() && "".equals(this.selectedScene.getCaption().getText());
            this.drawer.removeScene(this.selectedScene);
            if (!isEmpty) {
                this.postDeletionEdit(this.selectedScene);
            }
            TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
            this.setSelectedScene(this.drawer.getSceneAtFrame(trackerPanel.getFrameNumber()));
        });
        this.undoButton = new SideButton(undoIcon);
        this.undoButton.addActionListener(e -> {
            this.undoManager.undo();
            this.refreshGUI();
        });
        this.redoButton = new SideButton(redoIcon);
        this.redoButton.addActionListener(e -> {
            this.undoManager.redo();
            this.refreshGUI();
        });
        this.trailButton = new SideButton(trailIcon);
        this.trailButton.addActionListener(e -> {
            this.drawer.style = 2;
            this.refreshStyleButtons();
        });
        this.arrowButton = new SideButton(arrowIcon);
        this.arrowButton.addActionListener(e -> {
            this.drawer.style = 0;
            this.refreshStyleButtons();
        });
        this.ellipseButton = new SideButton(ellipseIcon);
        this.ellipseButton.addActionListener(e -> {
            this.drawer.style = 1;
            this.refreshStyleButtons();
        });
        this.clearAllButton = new JButton();
        this.clearAllButton.addActionListener(e -> {
            TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
            if (PencilDrawer.hasDrawings(trackerPanel)) {
                this.postClearEdit(this.drawer.scenes);
            }
            this.drawer.clearScenes(true);
            this.setSelectedScene(null);
            this.refreshGUI();
        });
        this.closeButton = new JButton();
        this.closeButton.addActionListener(e -> this.setVisible(false));
        this.helpButton = new JButton();
        this.helpButton.addActionListener(e -> this.frame.showHelp("drawings", 0));
        Box colorBox = Box.createVerticalBox();
        this.colorButtons = new ColorButton[PencilDrawer.colors.length][PencilDrawer.colors[0].length];
        int i = 0;
        while (i < PencilDrawer.colors[0].length) {
            Box b = Box.createHorizontalBox();
            int j = 0;
            while (j < this.colorButtons.length) {
                this.colorButtons[j][i] = new ColorButton(PencilDrawer.colors[j][i]);
                b.add(this.colorButtons[j][i]);
                ++j;
            }
            colorBox.add(b);
            ++i;
        }
        this.heavyCheckbox = new JCheckBox();
        this.heavyCheckbox.addActionListener(e -> {
            if (this.refreshing || this.selectedScene == null) {
                return;
            }
            this.selectedScene.setHeavy(this.heavyCheckbox.isSelected());
            this.repaintPanel();
            this.repaintCanvas();
        });
        this.startFrameSpinner = new JSpinner();
        this.startFrameSpinner.addChangeListener(e -> {
            if (this.selectedScene == null) {
                return;
            }
            this.selectedScene.setStartFrame((Integer)this.startFrameSpinner.getValue());
            Collections.sort(this.drawer.scenes);
            this.repaintPanel();
            this.refreshGUI();
        });
        this.endFrameSpinner = new JSpinner();
        this.endFrameSpinner.addChangeListener(e -> {
            if (this.selectedScene == null) {
                return;
            }
            this.selectedScene.setEndFrame((Integer)this.endFrameSpinner.getValue());
            Collections.sort(this.drawer.scenes);
            this.repaintPanel();
            this.refreshGUI();
        });
        int defaultFontSize = PencilCaption.baseFont.getSize();
        this.fontSizeSpinner = new JSpinner(new SpinnerNumberModel(defaultFontSize, 12, 98, 2));
        ((JSpinner.DefaultEditor)this.fontSizeSpinner.getEditor()).getTextField().setEditable(false);
        this.fontSizeSpinner.addChangeListener(e -> {
            if (this.selectedScene.getCaption() == null) {
                return;
            }
            if (this.refreshing) {
                return;
            }
            Font font = this.selectedScene.getCaption().getFont();
            float size = ((Integer)this.fontSizeSpinner.getValue()).intValue();
            font = font.deriveFont(size);
            this.selectedScene.getCaption().setFont(font);
            this.repaintPanel();
            this.repaintCanvas();
        });
        this.sceneDropdown = new JComboBox<PencilScene>(){

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = super.getMaximumSize();
                dim.height = ((PencilControl)PencilControl.this).deleteSceneButton.getMaximumSize().height;
                return dim;
            }
        };
        this.sceneDropdown.setRenderer(new SceneDropdownRenderer());
        this.sceneDropdown.addActionListener(e -> {
            if (this.refreshing) {
                return;
            }
            PencilScene scene = (PencilScene)this.sceneDropdown.getSelectedItem();
            if (scene == dummyScene) {
                return;
            }
            this.setSelectedScene(scene);
            if (this.selectedScene != null) {
                this.goToScene(this.selectedScene);
            }
            this.captionField.requestFocusInWindow();
        });
        this.captionField = new JTextField(16);
        this.captionField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    return;
                }
                String text = PencilControl.this.captionField.getText();
                if (!((PencilControl)PencilControl.this).selectedScene.isCaptionPositioned && !"".equals(text.trim())) {
                    TrackerPanel trackerPanel = PencilControl.this.frame.getTrackerPanelForID(PencilControl.this.panelID);
                    MainTView mainView = PencilControl.this.frame.getMainView(trackerPanel);
                    Rectangle rect = mainView.scrollPane.getViewport().getViewRect();
                    int xpix = rect.x + rect.width / 2;
                    int ypix = rect.y + rect.height / 2;
                    double x = trackerPanel.pixToX(xpix);
                    double y = trackerPanel.pixToY(ypix);
                    PencilCaption caption = PencilControl.this.selectedScene.getCaption();
                    caption.setXY(x, y);
                    caption.setText(text);
                    caption.color = ((PencilControl)PencilControl.this).drawer.color;
                    ((PencilControl)PencilControl.this).selectedScene.isCaptionPositioned = true;
                } else {
                    PencilControl.this.selectedScene.getCaption().setText(text);
                }
                PencilControl.this.captionField.setBackground(Color.YELLOW);
                PencilControl.this.refreshGUI();
                PencilControl.this.repaintPanel();
            }
        });
        this.postCaptionEditAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = PencilControl.this.selectedScene.getCaption().getText().trim();
                PencilControl.this.selectedScene.getCaption().setText(text);
                PencilControl.this.postCaptionEdit(PencilControl.this.selectedScene, PencilControl.this.prevCaptionText, text);
                PencilControl.this.captionField.setBackground(Color.WHITE);
                PencilControl.this.prevCaptionText = text;
                PencilControl.this.refreshGUI();
            }
        };
        this.captionField.addActionListener(this.postCaptionEditAction);
        this.captionField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (PencilControl.this.captionField.getBackground().equals(Color.YELLOW)) {
                    PencilControl.this.postCaptionEditAction.actionPerformed(null);
                }
            }
        });
        this.canvas = new DrawingPanel();
        this.canvas.setAutoscaleX(false);
        this.canvas.setAutoscaleY(false);
        this.canvas.setSquareAspect(true);
        this.canvas.setShowCoordinates(false);
        this.canvas.setBackground(Color.WHITE);
        this.canvas.setPreferredGutters(6, 6, 6, 6);
        this.canvas.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.canvas.setPreferredSize(this.canvasSize);
        this.canvas.setEnabled(false);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.setContentPane(contentPane);
        JPanel northPanel = new JPanel(new BorderLayout());
        contentPane.add((Component)northPanel, "North");
        northPanel.add((Component)this.canvas, "Center");
        JToolBar drawingBar = new JToolBar();
        northPanel.add((Component)drawingBar, "North");
        drawingBar.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        drawingBar.setFloatable(false);
        drawingBar.setOpaque(false);
        drawingBar.add(this.drawingLabel);
        drawingBar.add(this.sceneDropdown);
        drawingBar.add(Box.createHorizontalStrut(2));
        drawingBar.add(this.newSceneButton);
        drawingBar.add(Box.createHorizontalStrut(2));
        drawingBar.add(this.deleteSceneButton);
        JToolBar captionBar = new JToolBar();
        captionBar.setBorder(BorderFactory.createEmptyBorder(8, 4, 4, 8));
        northPanel.add((Component)captionBar, "South");
        captionBar.setFloatable(false);
        captionBar.setOpaque(false);
        captionBar.add(this.captionLabel);
        captionBar.add(this.captionField);
        captionBar.add(this.fontSizeSpinner);
        northPanel.add((Component)colorBox, "West");
        Box sideBox = Box.createVerticalBox();
        northPanel.add((Component)sideBox, "East");
        sideBox.add(this.arrowButton);
        sideBox.add(this.ellipseButton);
        sideBox.add(this.trailButton);
        sideBox.add(Box.createVerticalGlue());
        sideBox.add(this.undoButton);
        sideBox.add(this.redoButton);
        JPanel centerPanel = new JPanel();
        contentPane.add((Component)centerPanel, "Center");
        JToolBar controlBar = new JToolBar();
        centerPanel.add(controlBar);
        controlBar.setFloatable(false);
        controlBar.setOpaque(false);
        controlBar.setBorderPainted(false);
        controlBar.add(this.framesLabel);
        controlBar.add(this.startFrameSpinner);
        controlBar.add(this.toLabel);
        controlBar.add(this.endFrameSpinner);
        centerPanel.add(Box.createHorizontalStrut(15));
        centerPanel.add(this.heavyCheckbox);
        JPanel southPanel = new JPanel();
        southPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        contentPane.add((Component)southPanel, "South");
        southPanel.add(this.helpButton);
        southPanel.add(this.clearAllButton);
        southPanel.add(this.closeButton);
    }

    private void repaintPanel() {
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        TFrame.repaintT(trackerPanel);
        trackerPanel.changed = true;
    }

    protected void setFontLevel(int level) {
        FontSizer.setFonts(this, level);
        this.pack();
    }

    protected void postDrawingEdit(PencilDrawing drawing, PencilScene scene) {
        DrawingEdit edit = new DrawingEdit(drawing, scene);
        this.undoSupport.postEdit(edit);
    }

    protected void postCaptionEdit(PencilScene scene, String oldText, String newText) {
        CaptionEdit edit = new CaptionEdit(scene, oldText, newText);
        this.undoSupport.postEdit(edit);
    }

    protected void postDeletionEdit(PencilScene scene) {
        DeletionEdit edit = new DeletionEdit(scene);
        this.undoSupport.postEdit(edit);
    }

    protected void postClearEdit(ArrayList<PencilScene> scenes) {
        ClearEdit edit = new ClearEdit(scenes);
        this.undoSupport.postEdit(edit);
    }

    protected void refreshStyleButtons() {
        this.trailButton.setIcon(this.drawer.style == 2 ? trailSelectedIcon : trailIcon);
        this.arrowButton.setIcon(this.drawer.style == 0 ? arrowSelectedIcon : arrowIcon);
        this.ellipseButton.setIcon(this.drawer.style == 1 ? ellipseSelectedIcon : ellipseIcon);
    }

    protected void refreshGUI() {
        this.refreshing = true;
        this.setTitle(TrackerRes.getString("PencilControlDialog.Title"));
        this.drawingLabel.setText(String.valueOf(TrackerRes.getString("PencilControlDialog.Label.Drawing.Text")) + ":");
        this.toLabel.setText(TrackerRes.getString("PencilControlDialog.Label.To.Text"));
        this.captionLabel.setText(String.valueOf(TrackerRes.getString("PencilControlDialog.Label.Caption.Text")) + ":");
        this.framesLabel.setText(TrackerRes.getString("PencilControlDialog.Label.Frames.Text"));
        this.newSceneButton.setText(TrackerRes.getString("PencilControlDialog.Button.NewScene.Text"));
        this.deleteSceneButton.setText(TrackerRes.getString("PencilControlDialog.Button.DeleteScene.Text"));
        this.clearAllButton.setText(TrackerRes.getString("PencilControlDialog.Button.ClearAll.Text"));
        this.closeButton.setText(TrackerRes.getString("Dialog.Button.Close"));
        this.helpButton.setText(TrackerRes.getString("Dialog.Button.Help"));
        this.heavyCheckbox.setText(TrackerRes.getString("PencilControlDialog.Checkbox.Heavy.Text"));
        this.newSceneButton.setToolTipText(TrackerRes.getString("PencilControlDialog.Button.NewScene.Tooltip"));
        this.deleteSceneButton.setToolTipText(TrackerRes.getString("PencilControlDialog.Button.DeleteScene.Tooltip"));
        this.clearAllButton.setToolTipText(TrackerRes.getString("PencilControlDialog.Button.ClearAll.Tooltip"));
        this.heavyCheckbox.setToolTipText(TrackerRes.getString("PencilControlDialog.Checkbox.Heavy.Tooltip"));
        this.captionField.setToolTipText(TrackerRes.getString("PencilControlDialog.Field.Caption.Tooltip"));
        this.sceneDropdown.setToolTipText(TrackerRes.getString("PencilControlDialog.Dropdown.Drawing.Tooltip"));
        this.fontSizeSpinner.setToolTipText(TrackerRes.getString("PencilControlDialog.Spinner.FontSize.Tooltip"));
        this.startFrameSpinner.setToolTipText(TrackerRes.getString("PencilControlDialog.Spinner.FrameRange.Tooltip"));
        this.endFrameSpinner.setToolTipText(TrackerRes.getString("PencilControlDialog.Spinner.FrameRange.Tooltip"));
        this.undoButton.setToolTipText(this.undoManager.getUndoPresentationName());
        this.redoButton.setToolTipText(this.undoManager.getRedoPresentationName());
        boolean enabled = this.selectedScene != null;
        this.drawingLabel.setEnabled(enabled);
        this.toLabel.setEnabled(enabled);
        this.captionLabel.setEnabled(enabled);
        this.framesLabel.setEnabled(enabled);
        this.deleteSceneButton.setEnabled(enabled);
        this.heavyCheckbox.setEnabled(enabled);
        this.fontSizeSpinner.setEnabled(enabled);
        this.startFrameSpinner.setEnabled(enabled);
        this.endFrameSpinner.setEnabled(enabled);
        this.captionField.setEnabled(enabled);
        this.undoButton.setEnabled(this.undoManager.canUndo());
        this.redoButton.setEnabled(this.undoManager.canRedo());
        this.undoButton.setIcon(this.undoManager.canUndo() ? undoIcon : undoDisabledIcon);
        this.redoButton.setIcon(this.undoManager.canRedo() ? redoIcon : redoDisabledIcon);
        this.clearAllButton.setEnabled(!this.drawer.scenes.isEmpty());
        this.sceneDropdown.setEnabled(!this.drawer.scenes.isEmpty());
        this.newSceneButton.setEnabled(this.selectedScene == null || !this.selectedScene.getDrawings().isEmpty());
        if (enabled) {
            this.repaintCanvas();
            TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
            int first = trackerPanel.getPlayer().getVideoClip().getFirstFrameNumber();
            int last = trackerPanel.getPlayer().getVideoClip().getLastFrameNumber();
            this.selectedScene.startframe = Math.max(first, this.selectedScene.startframe);
            this.startFrameSpinner.setModel(new SpinnerNumberModel(this.selectedScene.startframe, first, last, 1));
            int end = this.selectedScene.endframe == Integer.MAX_VALUE ? last : this.selectedScene.endframe;
            this.endFrameSpinner.setModel(new SpinnerNumberModel(end, this.selectedScene.startframe, last, 1));
            this.heavyCheckbox.setSelected(this.selectedScene.isHeavy());
            this.drawer.color = this.selectedScene.getCaption().color;
            this.fontSizeSpinner.setValue(this.selectedScene.getCaption().getFont().getSize());
        } else {
            this.heavyCheckbox.setSelected(false);
        }
        int i = 0;
        while (i < this.colorButtons.length) {
            ColorButton[] colorButtonArray = this.colorButtons[i];
            int n = colorButtonArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColorButton b = colorButtonArray[n2];
                b.setToolTipText(TrackerRes.getString("PencilControlDialog.Button.Color.Tooltip"));
                b.setBorder(b.color == this.drawer.color && enabled ? BorderFactory.createLineBorder(Color.GRAY, 2) : BorderFactory.createLineBorder(lightgrey, 2));
                b.icon.setColor(enabled ? b.color : Color.LIGHT_GRAY);
                b.setEnabled(enabled);
                ++n2;
            }
            ++i;
        }
        this.sceneDropdown.removeAllItems();
        for (PencilScene scene : this.drawer.scenes) {
            this.sceneDropdown.addItem(scene);
        }
        if (this.selectedScene != null) {
            this.refreshing = false;
            this.sceneDropdown.setSelectedItem(this.selectedScene);
        } else if (!this.drawer.scenes.isEmpty()) {
            this.sceneDropdown.addItem(dummyScene);
            this.sceneDropdown.setSelectedItem(dummyScene);
        }
        this.refreshStyleButtons();
        this.refreshing = false;
        this.pack();
        this.repaint();
    }

    protected void repaintCanvas() {
        this.selectedScene.measure();
        this.canvas.setPreferredMinMaxX(this.selectedScene.getXMin(), this.selectedScene.getXMax());
        this.canvas.setPreferredMinMaxY(this.selectedScene.getYMax(), this.selectedScene.getYMin());
        this.canvas.repaint();
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        TToolBar toolbar = trackerPanel.getToolBar(true);
        toolbar.drawingButton.setSelected(vis);
        if (Tracker.showHints) {
            trackerPanel.setMessage(vis ? TrackerRes.getString("PencilDrawer.Hint") : null);
        }
        this.isVisible = vis;
    }

    protected PencilScene getSelectedScene() {
        return this.selectedScene;
    }

    protected void setSelectedScene(PencilScene scene) {
        if (this.selectedScene == scene) {
            return;
        }
        if (this.selectedScene != null) {
            this.canvas.removeDrawable(this.selectedScene);
        }
        this.selectedScene = scene;
        if (this.selectedScene != null) {
            this.canvas.addDrawable(this.selectedScene);
            this.prevCaptionText = this.selectedScene.getCaption().getText();
            this.captionField.setText(this.selectedScene.getCaption().getText());
        } else {
            this.captionField.setText(null);
        }
        this.refreshGUI();
    }

    private void goToScene(PencilScene scene) {
        if (scene == null) {
            return;
        }
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        if (!scene.includesFrame(trackerPanel.getFrameNumber())) {
            int stepNum = trackerPanel.getPlayer().getVideoClip().frameToStep(scene.startframe);
            trackerPanel.getPlayer().setStepNumber(stepNum);
        }
    }

    @Override
    public void dispose() {
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        trackerPanel.removePropertyChangeListener("stepnumber", this.stepListener);
        trackerPanel.removePropertyChangeListener("stepcount", this.clipListener);
        if (this.frame != null) {
            this.frame.removePropertyChangeListener("tab", this.tabListener);
        }
        this.setSelectedScene(null);
        this.panelID = null;
        this.frame = null;
    }

    private class CaptionEdit
    extends AbstractUndoableEdit {
        String undoText;
        String redoText;
        PencilScene scene;

        public CaptionEdit(PencilScene scene, String oldText, String newText) {
            this.scene = scene;
            this.undoText = oldText;
            this.redoText = newText;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.undoRedo(this.undoText);
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            this.undoRedo(this.redoText);
        }

        private void undoRedo(String text) {
            this.scene.getCaption().setText(text);
            PencilControl.this.setSelectedScene(this.scene);
            PencilControl.this.goToScene(this.scene);
            PencilControl.this.captionField.setText(text);
            TrackerPanel trackerPanel = PencilControl.this.frame.getTrackerPanelForID(PencilControl.this.panelID);
            TFrame.repaintT(trackerPanel);
            PencilControl.this.repaintCanvas();
        }

        @Override
        public String getUndoPresentationName() {
            return TrackerRes.getString("PencilControlDialog.CaptionEdit.Undo.Text");
        }

        @Override
        public String getRedoPresentationName() {
            return TrackerRes.getString("PencilControlDialog.CaptionEdit.Redo.Text");
        }
    }

    private class ClearEdit
    extends AbstractUndoableEdit {
        ArrayList<PencilScene> scenes = new ArrayList();

        public ClearEdit(ArrayList<PencilScene> scenes) {
            this.scenes.addAll(scenes);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            PencilControl.this.drawer.setScenes(this.scenes);
            TrackerPanel trackerPanel = PencilControl.this.frame.getTrackerPanelForID(PencilControl.this.panelID);
            PencilScene scene = PencilControl.this.drawer.getSceneAtFrame(trackerPanel.getFrameNumber());
            if (scene != null) {
                PencilControl.this.setSelectedScene(scene);
            } else {
                PencilControl.this.goToScene(this.scenes.get(0));
            }
            TFrame.repaintT(trackerPanel);
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            PencilControl.this.drawer.clearScenes(true);
            PencilControl.this.setSelectedScene(null);
            PencilControl.this.refreshGUI();
        }

        @Override
        public String getUndoPresentationName() {
            return TrackerRes.getString("PencilControlDialog.ClearEdit.Undo.Text");
        }

        @Override
        public String getRedoPresentationName() {
            return TrackerRes.getString("PencilControlDialog.ClearEdit.Redo.Text");
        }
    }

    private class ColorButton
    extends JButton
    implements ActionListener {
        Color color;
        ColorIcon icon;

        private ColorButton(Color c) {
            this.color = c;
            this.setBackground(this.color);
            this.icon = new ColorIcon(this.color, PencilControl.this.buttonWidth - 4, 16);
            this.setIcon(new ResizableIcon(this.icon));
            this.addActionListener(this);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (ColorButton.this.isEnabled()) {
                        ColorButton.this.setBorderPainted(false);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ColorButton.this.setBorderPainted(true);
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((PencilControl)PencilControl.this).drawer.color.equals(this.color)) {
                return;
            }
            ((PencilControl)PencilControl.this).drawer.color = this.color;
            if (PencilControl.this.drawer.getSelectedScene() != null) {
                PencilControl.this.drawer.getSelectedScene().setColor(this.color);
                PencilControl.this.repaintPanel();
            }
            PencilControl.this.refreshGUI();
            TrackerPanel trackerPanel = PencilControl.this.frame.getTrackerPanelForID(PencilControl.this.panelID);
            trackerPanel.setMouseCursor(PencilControl.this.drawer.getPencilCursor());
            this.setBorderPainted(true);
        }
    }

    private class DeletionEdit
    extends AbstractUndoableEdit {
        PencilScene scene;

        public DeletionEdit(PencilScene scene) {
            this.scene = scene;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            PencilControl.this.drawer.addScene(this.scene);
            PencilControl.this.goToScene(this.scene);
            PencilControl.this.setSelectedScene(this.scene);
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            PencilControl.this.drawer.removeScene(this.scene);
            TrackerPanel trackerPanel = PencilControl.this.frame.getTrackerPanelForID(PencilControl.this.panelID);
            PencilControl.this.setSelectedScene(PencilControl.this.drawer.getSceneAtFrame(trackerPanel.getFrameNumber()));
        }

        @Override
        public String getUndoPresentationName() {
            return TrackerRes.getString("PencilControlDialog.DeletionEdit.Undo.Text");
        }

        @Override
        public String getRedoPresentationName() {
            return TrackerRes.getString("PencilControlDialog.DeletionEdit.Redo.Text");
        }
    }

    private class DrawingEdit
    extends AbstractUndoableEdit {
        PencilDrawing drawing;
        PencilScene scene;

        public DrawingEdit(PencilDrawing drawing, PencilScene scene) {
            this.drawing = drawing;
            this.scene = scene;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.scene.getDrawings().remove(this.drawing);
            this.update();
        }

        @Override
        public void redo() throws CannotUndoException {
            super.redo();
            this.scene.getDrawings().add(this.drawing);
            this.update();
        }

        private void update() {
            PencilControl.this.setSelectedScene(this.scene);
            PencilControl.this.goToScene(this.scene);
            TrackerPanel trackerPanel = PencilControl.this.frame.getTrackerPanelForID(PencilControl.this.panelID);
            TFrame.repaintT(trackerPanel);
        }

        @Override
        public String getUndoPresentationName() {
            return TrackerRes.getString("PencilControlDialog.DrawingEdit.Undo.Text");
        }

        @Override
        public String getRedoPresentationName() {
            return TrackerRes.getString("PencilControlDialog.DrawingEdit.Redo.Text");
        }
    }

    private class SceneDropdownRenderer
    extends JLabel
    implements ListCellRenderer<PencilScene> {
        private SceneDropdownRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 0));
        }

        @Override
        public Component getListCellRendererComponent(JList list, PencilScene value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value != null) {
                PencilScene scene = value;
                TrackerPanel trackerPanel = PencilControl.this.frame.getTrackerPanelForID(PencilControl.this.panelID);
                this.setText(scene.getDescription(trackerPanel));
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private class SideButton
    extends JButton {
        public SideButton(Icon icon) {
            super(icon);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.width = (int)((double)(2 * PencilControl.this.buttonWidth) * FontSizer.getFactor());
            return dim;
        }
    }
}

