/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.ImageIcon;
import org.opensourcephysics.cabrillo.tracker.PencilCaption;
import org.opensourcephysics.cabrillo.tracker.PencilControl;
import org.opensourcephysics.cabrillo.tracker.PencilDrawing;
import org.opensourcephysics.cabrillo.tracker.PencilScene;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.tools.FontSizer;

public class PencilDrawer {
    static Color[][] colors;
    static Cursor pencilCursor;
    static BasicStroke lightStroke;
    static BasicStroke heavyStroke;
    private static HashMap<Integer, PencilDrawer> panelDrawers;
    protected TFrame frame;
    protected Integer panelID;
    private PencilDrawing newDrawing;
    private boolean drawingsVisible = true;
    ArrayList<PencilScene> scenes = new ArrayList();
    Color color = colors[0][0];
    PencilControl drawingControl;
    int style;

    static {
        panelDrawers = new HashMap();
        lightStroke = new BasicStroke(2.0f);
        heavyStroke = new BasicStroke(4.0f);
        ImageIcon icon = (ImageIcon)Tracker.getResourceIcon("pencil_cursor.gif", false);
        pencilCursor = GUIUtils.createCustomCursor(icon.getImage(), new Point(1, 15), TrackerRes.getString("PencilDrawer.Cursor.Description"), 13);
        Color[] baseColors = new Color[]{Color.BLACK, Color.RED, Color.GREEN, Color.BLUE, Color.YELLOW, Color.MAGENTA, Color.CYAN, Color.WHITE};
        Color[] moreColors = new Color[]{new Color(150, 150, 150), new Color(170, 0, 0), new Color(0, 140, 0), new Color(60, 0, 160), new Color(255, 180, 0), new Color(160, 0, 160), new Color(0, 160, 160), new Color(180, 180, 255)};
        colors = new Color[][]{baseColors, moreColors};
    }

    private PencilDrawer(TrackerPanel panel) {
        this.frame = panel.getTFrame();
        this.panelID = panel.getID();
    }

    protected static PencilDrawer getDrawer(TrackerPanel panel) {
        Integer panelID = panel.getID();
        PencilDrawer drawer = panelDrawers.get(panelID);
        if (drawer == null) {
            drawer = new PencilDrawer(panel);
            panelDrawers.put(panelID, drawer);
        }
        return drawer;
    }

    public static boolean isDrawing(TrackerPanel panel) {
        PencilDrawer drawer = PencilDrawer.getDrawer(panel);
        return drawer.drawingControl != null && drawer.drawingControl.isVisible();
    }

    public static boolean hasDrawings(TrackerPanel panel) {
        PencilDrawer drawer = panelDrawers.get(panel.getID());
        if (drawer == null || drawer.scenes.isEmpty()) {
            return false;
        }
        for (PencilScene scene : drawer.scenes) {
            if (!scene.getDrawings().isEmpty()) {
                return true;
            }
            if ("".equals(scene.getCaption().getText())) continue;
            return true;
        }
        return false;
    }

    protected static void dispose(TrackerPanel panel) {
        PencilDrawer drawer = panelDrawers.get(panel.getID());
        if (drawer != null) {
            drawer.dispose();
            panelDrawers.remove(panel.getID());
        }
    }

    public boolean areDrawingsVisible() {
        return this.drawingsVisible;
    }

    public void setDrawingsVisible(boolean vis, boolean andRepaint) {
        this.drawingsVisible = vis;
        for (PencilScene scene : this.scenes) {
            scene.setVisible(vis);
        }
        if (andRepaint) {
            TFrame.repaintT(this.panel());
        }
    }

    protected PencilDrawing addNewDrawingtoSelectedScene() {
        PencilScene scene = this.getSelectedScene();
        if (scene == null) {
            scene = this.addNewScene();
        }
        PencilDrawing drawing = new PencilDrawing(this.color);
        drawing.setStroke(scene.isHeavy() ? heavyStroke : lightStroke);
        drawing.setStyle(this.style);
        if (this.style == 0) {
            int w = this.panel().getMatBounds().width;
            drawing.setArrowheadLength(w / 30);
        }
        scene.getDrawings().add(drawing);
        return drawing;
    }

    protected PencilDrawing addDrawingtoSelectedScene(PencilDrawing drawing) {
        PencilScene scene = this.getSelectedScene();
        if (scene == null) {
            scene = this.addNewScene();
        }
        scene.getDrawings().add(drawing);
        this.panel().changed = true;
        return drawing;
    }

    private TrackerPanel panel() {
        return this.frame.getTrackerPanelForID(this.panelID);
    }

    protected PencilDrawing getActiveDrawing() {
        PencilScene scene = this.getSelectedScene();
        if (scene != null && !scene.getDrawings().isEmpty()) {
            return scene.getDrawings().get(scene.getDrawings().size() - 1);
        }
        return null;
    }

    protected void clearScenes(boolean andRepaint) {
        TrackerPanel trackerPanel = this.panel();
        for (PencilScene scene : this.scenes) {
            trackerPanel.removeDrawable(scene);
        }
        this.scenes.clear();
        if (andRepaint) {
            trackerPanel.changed = true;
            TFrame.repaintT(trackerPanel);
        }
    }

    protected void removeScene(PencilScene scene) {
        if (scene == null) {
            return;
        }
        TrackerPanel trackerPanel = this.panel();
        trackerPanel.removeDrawable(scene);
        this.scenes.remove(scene);
        trackerPanel.changed = true;
        TFrame.repaintT(trackerPanel);
    }

    protected void addScene(PencilScene scene) {
        if (scene == null) {
            return;
        }
        TrackerPanel trackerPanel = this.panel();
        trackerPanel.addDrawable(scene);
        this.scenes.add(scene);
        Collections.sort(this.scenes);
        trackerPanel.changed = true;
        TFrame.repaintT(trackerPanel);
    }

    protected PencilScene addNewScene() {
        PencilScene scene = new PencilScene();
        TrackerPanel trackerPanel = this.panel();
        scene.setStartFrame(trackerPanel.getFrameNumber());
        trackerPanel.addDrawable(scene);
        this.scenes.add(scene);
        Collections.sort(this.scenes);
        if (this.drawingControl != null) {
            float size = ((Integer)this.drawingControl.fontSizeSpinner.getValue()).intValue();
            Font font = PencilCaption.baseFont.deriveFont(size);
            scene.getCaption().setFont(font);
            scene.setColor(this.color);
            scene.setHeavy(this.drawingControl.heavyCheckbox.isSelected());
            this.drawingControl.setSelectedScene(scene);
            this.drawingControl.refreshGUI();
        }
        TFrame.repaintT(trackerPanel);
        return scene;
    }

    protected void setScenes(ArrayList<PencilScene> pencilScenes) {
        if (pencilScenes == null || pencilScenes == this.scenes) {
            return;
        }
        this.clearScenes(true);
        this.scenes = new ArrayList<PencilScene>(pencilScenes);
        Collections.sort(this.scenes);
        TrackerPanel trackerPanel = this.panel();
        for (PencilScene scene : this.scenes) {
            trackerPanel.addDrawable(scene);
        }
    }

    public PencilScene getSelectedScene() {
        return this.drawingControl != null ? this.drawingControl.getSelectedScene() : null;
    }

    protected PencilScene getSceneAtFrame(int frame) {
        for (PencilScene scene : this.scenes) {
            if (scene.startframe != frame) continue;
            return scene;
        }
        for (PencilScene scene : this.scenes) {
            if (scene.startframe >= frame || scene.endframe < frame) continue;
            return scene;
        }
        return null;
    }

    protected PencilScene getSceneWithCaption(PencilCaption caption) {
        for (PencilScene scene : this.scenes) {
            if (scene.getCaption() != caption) continue;
            return scene;
        }
        return null;
    }

    protected PencilControl getDrawingControl() {
        if (this.drawingControl == null) {
            this.drawingControl = new PencilControl(this);
        }
        this.drawingControl.setFontLevel(FontSizer.getLevel());
        this.drawingControl.refreshGUI();
        return this.drawingControl;
    }

    protected Cursor getPencilCursor() {
        return pencilCursor;
    }

    protected void handleMouseAction(MouseEvent e) {
        TrackerPanel trackerPanel = this.panel();
        Interactive ia = trackerPanel.getInteractive();
        if (ia instanceof PencilCaption) {
            if (((PencilCaption)ia).handleMouseAction(e, trackerPanel)) {
                this.getDrawingControl().refreshGUI();
            }
            return;
        }
        switch (trackerPanel.getMouseAction()) {
            case 7: {
                trackerPanel.setMouseCursor(this.getPencilCursor());
                if (!Tracker.showHints) break;
                trackerPanel.setMessage(TrackerRes.getString("PencilDrawer.Hint"));
                break;
            }
            case 1: {
                this.newDrawing = this.addNewDrawingtoSelectedScene();
                this.newDrawing.markPoint(trackerPanel.getMouseX(), trackerPanel.getMouseY());
                trackerPanel.setMouseCursor(this.getPencilCursor());
                if (!Tracker.showHints) break;
                trackerPanel.setMessage(TrackerRes.getString("PencilDrawer.Hint"));
                break;
            }
            case 3: {
                if (this.newDrawing == null) break;
                this.newDrawing.markPoint(trackerPanel.getMouseX(), trackerPanel.getMouseY());
                TFrame.repaintT(trackerPanel);
                trackerPanel.setMouseCursor(this.getPencilCursor());
                break;
            }
            case 2: {
                if (this.newDrawing != null) {
                    this.getSelectedScene().getDrawings().remove(this.newDrawing);
                    if (this.newDrawing.getPointCount() <= 1) {
                        TFrame.repaintT(trackerPanel);
                    } else {
                        this.getSelectedScene().getDrawings().add(this.newDrawing);
                        this.drawingControl.postDrawingEdit(this.newDrawing, this.getSelectedScene());
                        trackerPanel.changed = true;
                        this.getDrawingControl().refreshGUI();
                    }
                }
                this.newDrawing = null;
                trackerPanel.setMouseCursor(this.getPencilCursor());
            }
        }
    }

    protected void dispose() {
        this.clearScenes(false);
        if (this.drawingControl != null) {
            this.drawingControl.dispose();
        }
        this.panelID = null;
        this.frame = null;
        this.drawingControl = null;
    }

    protected void refresh() {
        if (this.drawingControl != null) {
            this.drawingControl.refreshGUI();
        }
    }

    public void finalize() {
        OSPLog.finalized(this);
    }
}

