/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import org.opensourcephysics.cabrillo.tracker.PencilDrawer;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;

public class PencilDrawing
implements Drawable,
Measurable {
    protected static final int STYLE_ARROW = 0;
    protected static final int STYLE_ELLIPSE = 1;
    protected static final int STYLE_TRAIL = 2;
    protected static final int MAX_LENGTH = 80;
    protected static final int MIN_LENGTH = 10;
    protected Color color = Color.black;
    private int style;
    private int numpts = 0;
    private ArrayList<double[]> pointArray = new ArrayList();
    private double[] coords = new double[6];
    private double xmin = Double.MAX_VALUE;
    private double xmax = -1.7976931348623157E308;
    private double ymin = Double.MAX_VALUE;
    private double ymax = -1.7976931348623157E308;
    private Stroke drawingStroke;
    private GeneralPath generalPath = new GeneralPath();
    private Ellipse2D ellipse;
    private Line2D[] arrowhead;
    protected int arrowheadLength = 20;

    static {
        XML.setLoader(PencilDrawing.class, PencilDrawing.getLoader());
    }

    private PencilDrawing() {
        this.setStroke(PencilDrawer.lightStroke);
    }

    PencilDrawing(Color c) {
        this();
        this.color = c;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        if (this.numpts == 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Color c = g2.getColor();
        Stroke stroke = g2.getStroke();
        g2.setColor(this.color);
        g2.setStroke(this.drawingStroke);
        switch (this.style) {
            case 0: {
                if (this.arrowhead == null) {
                    this.drawArrow();
                }
                Shape s = panel.transformShape(this.arrowhead[0]);
                g2.draw(s);
                s = panel.transformShape(this.arrowhead[1]);
                g2.draw(s);
            }
            case 2: {
                Shape s = panel.transformPath(this.generalPath);
                g2.draw(s);
                break;
            }
            case 1: {
                Shape s = panel.transformShape(this.ellipse);
                g2.draw(s);
            }
        }
        g2.setStroke(stroke);
        g2.setColor(c);
    }

    public void setStyle(int newStyle) {
        if (newStyle < 0 || newStyle > 2) {
            return;
        }
        this.style = newStyle;
    }

    public void setArrowheadLength(int length) {
        this.arrowheadLength = Math.min(Math.max(length, 10), 80);
    }

    public int getPointCount() {
        return this.numpts;
    }

    public Stroke getStroke() {
        return this.drawingStroke;
    }

    public void setStroke(Stroke stroke) {
        this.drawingStroke = stroke;
    }

    public void clear() {
        this.numpts = 0;
        this.xmax = -1.7976931348623157E308;
        this.ymax = -1.7976931348623157E308;
        this.xmin = Double.MAX_VALUE;
        this.ymin = Double.MAX_VALUE;
        this.generalPath.reset();
    }

    public void markPoint(double x, double y) {
        this.addPoint(x, y);
        switch (this.style) {
            case 2: {
                break;
            }
            case 0: {
                this.drawArrow();
                break;
            }
            case 1: {
                this.drawCircle();
            }
        }
    }

    @Override
    public double getXMin() {
        return this.xmin;
    }

    @Override
    public double getXMax() {
        return this.xmax;
    }

    @Override
    public double getYMin() {
        return this.ymin;
    }

    @Override
    public double getYMax() {
        return this.ymax;
    }

    @Override
    public boolean isMeasured() {
        return this.numpts > 0;
    }

    private void addPoint(double x, double y) {
        if (this.numpts == 0) {
            this.generalPath.moveTo((float)x, (float)y);
        }
        this.generalPath.lineTo((float)x, (float)y);
        this.xmin = Math.min(this.xmin, x);
        this.xmax = Math.max(this.xmax, x);
        this.ymin = Math.min(this.ymin, y);
        this.ymax = Math.max(this.ymax, y);
        ++this.numpts;
    }

    private double[][] getPathPoints() {
        this.pointArray.clear();
        PathIterator pi = this.generalPath.getPathIterator(null);
        while (!pi.isDone()) {
            int type = pi.currentSegment(this.coords);
            if (type == 1) {
                this.pointArray.add(new double[]{this.coords[0], this.coords[1]});
            }
            pi.next();
        }
        return (double[][])this.pointArray.toArray((T[])new double[this.pointArray.size()][3]);
    }

    private double[][] getEnds() {
        double[][] pts = this.getPathPoints();
        double[][] ends = new double[][]{{pts[0][0], pts[0][1]}, {pts[this.numpts - 1][0], pts[this.numpts - 1][1]}};
        this.clear();
        this.addPoint(ends[0][0], ends[0][1]);
        this.addPoint(ends[1][0], ends[1][1]);
        return ends;
    }

    private void drawArrow() {
        if (this.numpts < 2) {
            return;
        }
        if (this.arrowhead == null) {
            this.arrowhead = new Line2D.Double[]{new Line2D.Double(), new Line2D.Double()};
        }
        double[][] ends = this.getEnds();
        double xTip = ends[1][0];
        double yTip = ends[1][1];
        double theta = Math.atan2(ends[0][1] - ends[1][1], ends[0][0] - ends[1][0]);
        double x = xTip + (double)this.arrowheadLength * Math.cos(theta + 0.5);
        double y = yTip + (double)this.arrowheadLength * Math.sin(theta + 0.5);
        this.arrowhead[0].setLine(ends[1][0], ends[1][1], x, y);
        x = xTip + (double)this.arrowheadLength * Math.cos(theta - 0.5);
        y = yTip + (double)this.arrowheadLength * Math.sin(theta - 0.5);
        this.arrowhead[1].setLine(ends[1][0], ends[1][1], x, y);
    }

    private void drawCircle() {
        if (this.numpts < 2) {
            return;
        }
        if (this.ellipse == null) {
            this.ellipse = new Ellipse2D.Double();
        }
        double[][] ends = this.getEnds();
        this.ellipse.setFrameFromDiagonal(ends[0][0], ends[0][1], ends[1][0], ends[1][1]);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    /* synthetic */ PencilDrawing(PencilDrawing pencilDrawing) {
        this();
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            PencilDrawing drawing = (PencilDrawing)obj;
            control.setValue("colorRGB", drawing.color.getRGB());
            control.setValue("points", drawing.getPathPoints());
            control.setValue("style", drawing.style);
            if (drawing.style == 0) {
                control.setValue("arrowhead", drawing.arrowheadLength);
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return new PencilDrawing(null);
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            double[][] points;
            PencilDrawing drawing = (PencilDrawing)obj;
            if (control.getPropertyNamesRaw().contains("style")) {
                drawing.setStyle(control.getInt("style"));
            }
            if (control.getPropertyNamesRaw().contains("arrowhead")) {
                drawing.arrowheadLength = control.getInt("arrowhead");
            }
            drawing.color = new Color(control.getInt("colorRGB"));
            double[][] dArray = points = (double[][])control.getObject("points");
            int n = points.length;
            int n2 = 0;
            while (n2 < n) {
                double[] point = dArray[n2];
                if (point.length == 3) {
                    drawing.markPoint(point[1], point[2]);
                } else {
                    drawing.markPoint(point[0], point[1]);
                }
                ++n2;
            }
            return drawing;
        }
    }
}

