/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import org.opensourcephysics.cabrillo.tracker.PencilCaption;
import org.opensourcephysics.cabrillo.tracker.PencilControl;
import org.opensourcephysics.cabrillo.tracker.PencilDrawer;
import org.opensourcephysics.cabrillo.tracker.PencilDrawing;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.Trackable;

public class PencilScene
implements Interactive,
Trackable,
Comparable<PencilScene> {
    protected TFrame frame;
    protected Integer panelID;
    private PencilCaption caption;
    private ArrayList<PencilDrawing> drawings = new ArrayList();
    private boolean visible = true;
    private boolean heavy;
    private double margin;
    boolean isCaptionPositioned;
    int startframe = 0;
    int endframe = Integer.MAX_VALUE;

    public PencilScene() {
        this.caption = new PencilCaption("", 0.0, 0.0, PencilCaption.baseFont);
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        if (!this.visible) {
            return;
        }
        if (panel instanceof TrackerPanel) {
            TrackerPanel trackerPanel = (TrackerPanel)panel;
            if (!trackerPanel.isDrawingInImageSpace()) {
                return;
            }
            if (this.panelID == null) {
                this.panelID = trackerPanel.getID();
                this.frame = trackerPanel.getTFrame();
            }
            if (!this.includesFrame(trackerPanel.getFrameNumber())) {
                return;
            }
        }
        for (PencilDrawing drawing : this.drawings) {
            drawing.draw(panel, g);
        }
        this.caption.draw(panel, g);
    }

    public ArrayList<PencilDrawing> getDrawings() {
        return this.drawings;
    }

    public PencilCaption getCaption() {
        return this.caption;
    }

    public void setCaption(PencilCaption caption) {
        if (caption != null) {
            this.caption = caption;
            this.isCaptionPositioned = true;
        }
    }

    public void setColor(Color color) {
        for (PencilDrawing drawing : this.drawings) {
            drawing.color = color;
        }
        this.caption.color = color;
    }

    public int setStartFrame(int start) {
        this.startframe = start = Math.max(0, start);
        this.endframe = Math.max(this.startframe, this.endframe);
        return this.startframe;
    }

    public int setEndFrame(int end) {
        this.endframe = end = Math.max(this.startframe, end);
        return this.endframe;
    }

    public String getDescription(TrackerPanel trackerPanel) {
        if (this == PencilControl.dummyScene) {
            return null;
        }
        int last = this.endframe;
        if (trackerPanel.isDisplayable() && Integer.MAX_VALUE == last) {
            last = trackerPanel.getPlayer().getVideoClip().getLastFrameNumber();
        }
        String name = TrackerRes.getString("PencilScene.Description.Default");
        int len = Math.max(10, name.length());
        if (this.getCaption() != null && !"".equals(this.getCaption().getText())) {
            name = this.getCaption().getText();
        }
        if (name.length() > len) {
            name = String.valueOf(name.substring(0, len)) + "...";
        }
        String s = String.valueOf(name) + " (" + this.startframe + "-" + last + ")";
        return s;
    }

    public boolean includesFrame(int frame) {
        return this.startframe <= frame && this.endframe >= frame;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean vis) {
        this.visible = vis;
    }

    public boolean isHeavy() {
        return this.heavy;
    }

    public void setHeavy(boolean heavy) {
        this.heavy = heavy;
        for (PencilDrawing drawing : this.drawings) {
            drawing.setStroke(heavy ? PencilDrawer.heavyStroke : PencilDrawer.lightStroke);
        }
        if (this.getCaption() != null) {
            Font font = this.getCaption().getFont();
            font = font.deriveFont(heavy ? 1 : 0);
            this.getCaption().setFont(font);
        }
    }

    @Override
    public double getXMin() {
        double d = 0.0;
        for (PencilDrawing drawing : this.drawings) {
            double d2 = d = d == 0.0 ? drawing.getXMin() : Math.min(d, drawing.getXMin());
        }
        if (this.caption.isMeasured()) {
            d = d == 0.0 ? this.caption.getXMin() : Math.min(d, this.caption.getXMin());
        }
        return d - this.margin;
    }

    @Override
    public double getXMax() {
        double d = 0.0;
        for (PencilDrawing drawing : this.drawings) {
            double d2 = d = d == 0.0 ? drawing.getXMax() : Math.max(d, drawing.getXMax());
        }
        if (this.caption.isMeasured()) {
            d = d == 0.0 ? this.caption.getXMax() : Math.max(d, this.caption.getXMax());
        }
        return d + this.margin;
    }

    @Override
    public double getYMin() {
        double d = 0.0;
        for (PencilDrawing drawing : this.drawings) {
            double d2 = d = d == 0.0 ? drawing.getYMin() : Math.min(d, drawing.getYMin());
        }
        if (this.caption.isMeasured()) {
            d = d == 0.0 ? this.caption.getYMin() : Math.min(d, this.caption.getYMin());
        }
        return d - this.margin;
    }

    @Override
    public double getYMax() {
        double d = 0.0;
        for (PencilDrawing drawing : this.drawings) {
            double d2 = d = d == 0.0 ? drawing.getYMax() : Math.max(d, drawing.getYMax());
        }
        if (this.caption.isMeasured()) {
            d = d == 0.0 ? this.caption.getYMax() : Math.max(d, this.caption.getYMax());
        }
        return d + this.margin;
    }

    @Override
    public boolean isMeasured() {
        return true;
    }

    @Override
    public int compareTo(PencilScene that) {
        int diff = this.startframe - that.startframe;
        return diff != 0 ? diff : this.endframe - that.endframe;
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        Interactive ia = this.caption.findInteractive(panel, xpix, ypix);
        if (ia != null && Tracker.showHints && this.panelID != null) {
            this.frame.getTrackerPanelForID(this.panelID).setMessage(TrackerRes.getString("PencilCaption.Hint"));
            return ia;
        }
        return ia;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setXY(double x, double y) {
    }

    @Override
    public void setX(double x) {
    }

    @Override
    public void setY(double y) {
    }

    @Override
    public double getX() {
        return 0.0;
    }

    @Override
    public double getY() {
        return 0.0;
    }

    protected void measure() {
        double xmin = 0.0;
        double xmax = 0.0;
        double ymin = 0.0;
        double ymax = 0.0;
        for (PencilDrawing drawing : this.drawings) {
            xmin = xmin == 0.0 ? drawing.getXMin() : Math.min(xmin, drawing.getXMin());
            xmax = xmax == 0.0 ? drawing.getXMax() : Math.max(xmax, drawing.getXMax());
            ymin = ymin == 0.0 ? drawing.getYMin() : Math.min(ymin, drawing.getYMin());
            double d = ymax = ymax == 0.0 ? drawing.getYMax() : Math.max(ymax, drawing.getYMax());
        }
        if (this.caption.isMeasured()) {
            xmin = xmin == 0.0 ? this.caption.getXMin() : Math.min(xmin, this.caption.getXMin());
            xmax = xmax == 0.0 ? this.caption.getXMax() : Math.max(xmax, this.caption.getXMax());
            ymin = ymin == 0.0 ? this.caption.getYMin() : Math.min(ymin, this.caption.getYMin());
            ymax = ymax == 0.0 ? this.caption.getYMax() : Math.max(ymax, this.caption.getYMax());
        }
        double range = Math.max(xmax - xmin, ymax - ymin);
        this.margin = 0.02 * range;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            PencilScene scene = (PencilScene)obj;
            control.setValue("frame_range", new int[]{scene.startframe, scene.endframe});
            if (!scene.getDrawings().isEmpty()) {
                control.setValue("drawings", scene.getDrawings());
            }
            if (scene.getCaption() != null && !"".equals(scene.getCaption().getText())) {
                control.setValue("caption", scene.getCaption());
            }
            if (scene.isHeavy()) {
                control.setValue("heavy", scene.isHeavy());
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            PencilScene scene = new PencilScene();
            return scene;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            ArrayList drawings;
            PencilScene scene = (PencilScene)obj;
            int[] frames = (int[])control.getObject("frame_range");
            if (frames != null) {
                scene.startframe = frames[0];
                scene.endframe = frames[1];
            }
            if ((drawings = (ArrayList)control.getObject("drawings")) != null) {
                scene.drawings = drawings;
            }
            scene.setCaption((PencilCaption)control.getObject("caption"));
            scene.setHeavy(control.getBoolean("heavy"));
            return scene;
        }
    }
}

