/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Point;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.PerspectiveTrack;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.media.core.PerspectiveFilter;
import org.opensourcephysics.media.core.TPoint;

public class PerspectiveStep
extends Step {
    public PerspectiveStep(PerspectiveTrack track, int n, double x, double y) {
        super(track, n);
        this.points = new TPoint[]{new Corner(), new Corner(), new Corner(), new Corner()};
        this.screenPoints = new Point[PerspectiveStep.getLength()];
    }

    @Override
    public int getPointIndex(TPoint p) {
        if (p instanceof PerspectiveFilter.Corner) {
            PerspectiveFilter.Corner corner = (PerspectiveFilter.Corner)p;
            PerspectiveTrack ptrack = (PerspectiveTrack)this.getTrack();
            int i = ptrack.filter.getCornerIndex(corner);
            if (i < 4) {
                return i;
            }
        }
        int i = 0;
        while (i < this.points.length) {
            if (p == this.points[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public TPoint getDefaultPoint() {
        PerspectiveTrack ptrack = (PerspectiveTrack)this.getTrack();
        int index = ptrack.getTargetIndex();
        return ptrack.filter.getCorner(index);
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = (Mark)this.panelMarks.get(trackerPanel.getID());
        if (mark == null) {
            mark = this.footprint.getMark(this.screenPoints);
            this.panelMarks.put(trackerPanel.getID(), mark);
        }
        return mark;
    }

    @Override
    public Object clone() {
        PerspectiveStep step = (PerspectiveStep)super.clone();
        step.points = new TPoint[]{new Corner(), new Corner(), new Corner(), new Corner()};
        return step;
    }

    @Override
    public String toString() {
        return "PerspectiveStep";
    }

    public class Corner
    extends TPoint {
        @Override
        public void setXY(double x, double y) {
            super.setLocation(x, y);
            PerspectiveTrack ptrack = (PerspectiveTrack)PerspectiveStep.this.getTrack();
            if (ptrack.tp != null) {
                int n = ptrack.tp.getFrameNumber();
                ptrack.firePropertyChange("step", null, n);
            }
        }
    }
}

