/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenu;
import org.opensourcephysics.cabrillo.tracker.CircleFootprint;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.PerspectiveStep;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.PerspectiveFilter;
import org.opensourcephysics.media.core.TPoint;

public class PerspectiveTrack
extends TTrack {
    private static final String[] filterProps = new String[]{"filter_color", "filter_visible", "enabled", "tab", "cornerlocation", "fixed"};
    static int n = 0;
    static HashMap<Filter, PerspectiveTrack> filterMap = new HashMap();
    PerspectiveFilter filter;
    String filterState;

    public PerspectiveTrack(PerspectiveFilter filter) {
        super(10);
        this.filter = filter;
        filterMap.put(filter, this);
        this.viewable = false;
        CircleFootprint c = (CircleFootprint)CircleFootprint.getFootprint("CircleFootprint.Circle");
        c.setColor(filter.getColor());
        c.setSpotShown(false);
        c.setAlpha(0);
        this.setFootprints(new Footprint[]{c});
        this.setName(String.valueOf(MediaRes.getString("Filter.Perspective.Title").toLowerCase()) + " " + String.valueOf((char)(65 + n)));
        PerspectiveStep step = new PerspectiveStep(this, 0, 0.0, 0.0);
        step.setFootprint(this.getFootprint());
        this.steps = new TTrack.StepArray(this, step);
        OSPRuntime.Supported.addListeners(filter, filterProps, this);
    }

    @Override
    public void dispose() {
        super.dispose();
        filterMap.remove(this.filter);
        OSPRuntime.Supported.removeListeners(this.filter, filterProps, this);
        this.filter = null;
    }

    @Override
    public void setTrackerPanel(TrackerPanel panel) {
        if (this.tp != null) {
            this.tp.removePropertyChangeListener("selectedpoint", this);
            this.tp.removePropertyChangeListener("selectedtrack", this);
        }
        super.setTrackerPanel(panel);
        if (this.tp != null) {
            this.tp.addPropertyChangeListener("selectedpoint", this);
            this.tp.addPropertyChangeListener("selectedtrack", this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "filter_color": {
                this.setColor((Color)e.getNewValue());
                break;
            }
            case "filter_visible": 
            case "enabled": 
            case "tab": {
                boolean visible;
                if (this.tp.getSelectedTrack() == this) {
                    this.tp.setSelectedPoint(null);
                    this.tp.selectedSteps.clear();
                }
                boolean bl = visible = this.filter.hasInspector() && this.filter.getInspector().isVisible();
                if (visible) {
                    this.tp.setSelectedTrack(this);
                    break;
                }
                this.tp.setSelectedTrack(null);
                break;
            }
            case "fixed": {
                Undo.postFilterEdit(this.tp, this.filter, new XMLControlElement((String)e.getOldValue()));
                break;
            }
            case "cornerlocation": {
                PerspectiveFilter.Corner filtercorner = (PerspectiveFilter.Corner)e.getNewValue();
                int i = this.filter.getCornerIndex(filtercorner);
                int n = this.tp.getFrameNumber();
                if (!this.filter.isInputEnabled() || i >= 4) break;
                this.getStep((int)n).points[i].setXY(filtercorner.getX(), filtercorner.getY());
                break;
            }
            case "selectedtrack": {
                if (e.getNewValue() != this || !this.filter.hasInspector() || this.filter.getInspector().isVisible()) break;
                this.filter.getInspector().setVisible(true);
                break;
            }
            case "selectedpoint": {
                TPoint p;
                if (e.getOldValue() != null && this.filterState != null && (p = (TPoint)e.getOldValue()) instanceof PerspectiveFilter.Corner) {
                    Undo.postFilterEdit(this.tp, this.filter, new XMLControlElement(this.filterState));
                    this.filterState = null;
                }
                if (e.getNewValue() == null || !(e.getNewValue() instanceof PerspectiveFilter.Corner) || this.filterState != null) break;
                this.filterState = new XMLControlElement(this.filter).toXML();
            }
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        this.partName = null;
        this.hint = null;
        return null;
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel, JMenu menu) {
        if (menu == null) {
            menu = new JMenu();
        }
        menu.setText(this.getName("track"));
        menu.setIcon(this.getFootprint().getIcon(21, 16));
        return menu;
    }

    @Override
    public String getMessage() {
        String s = MediaRes.getString("Filter.Perspective.Title").toLowerCase();
        if (this.partName != null) {
            s = String.valueOf(s) + " " + this.partName;
        }
        if (this.isLocked()) {
            this.hint = TrackerRes.getString("TTrack.Locked.Hint");
        }
        if (Tracker.showHints && this.hint != null) {
            s = String.valueOf(s) + " (" + this.hint + ")";
        }
        return s;
    }

    @Override
    public Step getStep(TPoint p, TrackerPanel trackerPanel) {
        PerspectiveFilter.Corner corner;
        int i;
        if (p instanceof PerspectiveFilter.Corner && (i = this.filter.getCornerIndex(corner = (PerspectiveFilter.Corner)p)) > -1) {
            this.partName = this.getTargetDescription(i);
            this.hint = TrackerRes.getString("PerspectiveTrack.Corner.Hint");
            return this.getStep(trackerPanel.getFrameNumber());
        }
        return super.getStep(p, trackerPanel);
    }

    @Override
    public Step deleteStep(int n) {
        if (this.locked) {
            return null;
        }
        TPoint p = this.tp.getSelectedPoint();
        if (p instanceof PerspectiveFilter.Corner) {
            PerspectiveFilter.Corner corner = (PerspectiveFilter.Corner)p;
            this.filter.deleteKeyFrame(n, corner);
            TFrame.repaintT(this.tp);
        }
        Step step = this.getStep(n);
        return step;
    }

    @Override
    public TPoint autoMarkAt(int n, double x, double y) {
        int index = this.getTargetIndex();
        PerspectiveStep step = (PerspectiveStep)this.getStep(n);
        step.points[index].setXY(x, y);
        this.filter.setCornerLocation(n, index, x, y);
        return this.getMarkedPoint(n, index);
    }

    @Override
    public TPoint getMarkedPoint(int n, int index) {
        Step step = this.getStep(n);
        return step.points[index];
    }

    @Override
    protected void setTargetIndex(TPoint p) {
        Step step = this.getStep(p, this.tp);
        if (step != null) {
            this.setTargetIndex(step.getPointIndex(p));
        }
    }

    @Override
    protected String getTargetDescription(int pointIndex) {
        if (pointIndex < 4) {
            return String.valueOf(TrackerRes.getString("PerspectiveTrack.Corner.Input")) + " " + pointIndex;
        }
        return String.valueOf(TrackerRes.getString("PerspectiveTrack.Corner.Output")) + " " + (pointIndex - 4);
    }

    @Override
    protected boolean isAutoTrackable(int pointIndex) {
        return pointIndex < 4;
    }

    @Override
    protected boolean isAutoTrackable() {
        return true;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics _g) {
    }

    @Override
    public int getStepLength() {
        return 4;
    }

    @Override
    public int getFootprintLength() {
        return 1;
    }

    @Override
    public Step createStep(int n, double x, double y) {
        this.autoMarkAt(n, x, y);
        return this.getStep(n);
    }

    @Override
    public void remark(Integer panelID) {
    }

    @Override
    public Map<String, String[]> getFormatMap() {
        return NOMAP;
    }

    @Override
    public Map<String, String> getFormatDescMap() {
        return NOMAPS;
    }

    @Override
    public String[] getFormatVariables() {
        return NOVARS;
    }

    @Override
    public String getVarDimsImpl(String variable) {
        return null;
    }

    @Override
    public String getBaseType() {
        return "PerspectiveTrack";
    }
}

