/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackPlottingPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Vector;
import org.opensourcephysics.tools.FontSizer;

public class PlotGuestDialog
extends JDialog {
    protected TrackPlottingPanel plot;
    protected TFrame frame;
    protected Integer panelID;
    protected JButton okButton;
    protected JButton selectAllButton;
    protected JPanel checkboxPanel;
    protected ActionListener listener;
    protected TitledBorder instructions;
    protected TreeSet<Integer> allTracks = new TreeSet();
    protected boolean allTracksSelected;

    public PlotGuestDialog(TrackerPanel panel) {
        super(JOptionPane.getFrameForComponent(panel), true);
        this.frame = panel.getTFrame();
        this.panelID = panel.getID();
        this.listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem checkbox = (JCheckBoxMenuItem)e.getSource();
                int id = Integer.parseInt(checkbox.getActionCommand());
                TTrack track = TTrack.getTrack(id);
                if (checkbox.isSelected()) {
                    PlotGuestDialog.this.plot.addGuest(track);
                } else {
                    PlotGuestDialog.this.plot.removeGuest(track);
                }
                PlotGuestDialog.this.plot.plotData();
                PlotGuestDialog.this.plot.repaint();
                PlotGuestDialog.this.updateDisplay();
            }
        };
        this.setResizable(false);
        this.createGUI();
        this.pack();
    }

    public void setPlot(TrackPlottingPanel plot) {
        this.plot = plot;
        this.updateDisplay();
    }

    private void createGUI() {
        JPanel inspectorPanel = new JPanel(new BorderLayout());
        this.setContentPane(inspectorPanel);
        this.checkboxPanel = new JPanel(new GridLayout(0, 2));
        Border etched = BorderFactory.createEtchedBorder();
        this.instructions = BorderFactory.createTitledBorder(etched, "");
        this.checkboxPanel.setBorder(this.instructions);
        inspectorPanel.add((Component)this.checkboxPanel, "Center");
        this.okButton = new JButton(TrackerRes.getString("Dialog.Button.OK"));
        this.okButton.setForeground(new Color(0, 0, 102));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotGuestDialog.this.setVisible(false);
            }
        });
        this.selectAllButton = new JButton(TrackerRes.getString("PlotGuestDialog.Button.SelectAll.Text"));
        this.selectAllButton.setForeground(new Color(0, 0, 102));
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Integer id : PlotGuestDialog.this.allTracks) {
                    TTrack track = TTrack.getTrack(id);
                    if (PlotGuestDialog.this.allTracksSelected) {
                        PlotGuestDialog.this.plot.removeGuest(track);
                        continue;
                    }
                    PlotGuestDialog.this.plot.addGuest(track);
                }
                PlotGuestDialog.this.plot.plotData();
                PlotGuestDialog.this.plot.repaint();
                PlotGuestDialog.this.updateDisplay();
            }
        });
        JPanel buttonbar = new JPanel();
        buttonbar.setBorder(BorderFactory.createEmptyBorder(1, 0, 3, 0));
        inspectorPanel.add((Component)buttonbar, "South");
        buttonbar.add(this.selectAllButton);
        buttonbar.add(this.okButton);
    }

    protected void updateDisplay() {
        TTrack track = TTrack.getTrack(this.plot.trackID);
        this.setTitle(track.getName());
        this.instructions.setTitle(TrackerRes.getString("PlotGuestDialog.Instructions"));
        Class<PointMass> type = track.ttype == 5 ? PointMass.class : (track.ttype == 9 ? Vector.class : track.getClass());
        ArrayList<PointMass> tracks = this.frame.getTrackerPanelForID(this.panelID).getDrawablesTemp(type);
        TrackerPanel panel = this.frame.getTrackerPanelForID(this.panelID);
        tracks.removeAll(panel.calibrationTools);
        tracks.remove(track);
        int tracksPerColumn = 8;
        int cols = 1 + (tracks.size() - 1) / tracksPerColumn;
        this.checkboxPanel.setLayout(new GridLayout(0, cols));
        this.checkboxPanel.removeAll();
        int counter = 0;
        int h = 0;
        Box box = Box.createVerticalBox();
        this.allTracks.clear();
        this.allTracksSelected = true;
        for (TTrack tTrack : tracks) {
            this.allTracks.add(tTrack.getID());
            JCheckBoxMenuItem checkbox = new JCheckBoxMenuItem(tTrack.getName(), tTrack.getFootprint().getIcon(21, 16));
            checkbox.setBorderPainted(false);
            checkbox.setSelected(this.plot.guests.contains(tTrack));
            this.allTracksSelected = this.allTracksSelected && checkbox.isSelected();
            checkbox.setActionCommand(String.valueOf(tTrack.getID()));
            checkbox.addActionListener(this.listener);
            box.add(checkbox);
            h = checkbox.getPreferredSize().height;
            if (++counter % tracksPerColumn != 0) continue;
            this.checkboxPanel.add(box);
            counter = 0;
            if (this.checkboxPanel.getComponentCount() >= cols) continue;
            box = Box.createVerticalBox();
        }
        tracks.clear();
        if (this.checkboxPanel.getComponentCount() < cols) {
            if (this.checkboxPanel.getComponentCount() > 0) {
                int n = tracksPerColumn - box.getComponentCount();
                box.add(Box.createVerticalStrut(n * h));
            }
            this.checkboxPanel.add(box);
        }
        this.selectAllButton.setText(this.allTracksSelected ? TrackerRes.getString("PlotGuestDialog.Button.SelectNone.Text") : TrackerRes.getString("PlotGuestDialog.Button.SelectAll.Text"));
        FontSizer.setFonts(this.checkboxPanel, FontSizer.getLevel());
        this.pack();
        TFrame.repaintT(this);
    }
}

