/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import org.opensourcephysics.cabrillo.tracker.PlotTrackView;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackChooserTView;
import org.opensourcephysics.cabrillo.tracker.TrackPlottingPanel;
import org.opensourcephysics.cabrillo.tracker.TrackView;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLProperty;

public class PlotTView
extends TrackChooserTView {
    protected static final Icon PLOTVIEW_ICON = Tracker.getResourceIcon("plot.gif", true);

    public PlotTView(TrackerPanel panel) {
        super(panel);
    }

    @Override
    public String getViewName() {
        return TrackerRes.getString("TFrame.View.Plot");
    }

    @Override
    public Icon getViewIcon() {
        return PLOTVIEW_ICON;
    }

    @Override
    public int getViewType() {
        return 0;
    }

    @Override
    protected TrackView createTrackView(TTrack track) {
        return new PlotTrackView(track, this.getPanel(), this);
    }

    @Override
    protected void refreshMenus() {
        if (this.trackViews == null) {
            return;
        }
        for (TrackView next : this.trackViews.values()) {
            PlotTrackView plots = (PlotTrackView)next;
            TrackPlottingPanel[] trackPlottingPanelArray = plots.plots;
            int n = plots.plots.length;
            int n2 = 0;
            while (n2 < n) {
                TrackPlottingPanel panel = trackPlottingPanelArray[n2];
                panel.clearPopup();
                ++n2;
            }
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public TrackView addTrackView(TTrack track) {
        TrackView v = this.createTrackView(track);
        if (this.trackViews == null) {
            this.trackViews = new HashMap();
        }
        this.trackViews.put(track, v);
        return v;
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            PlotTView view = (PlotTView)obj;
            TTrack track = view.getSelectedTrack();
            if (track != null) {
                control.setValue("selected_track", track.getName());
                ArrayList<TrackView> list = new ArrayList<TrackView>();
                for (TrackView next : view.trackViews.values()) {
                    if (!next.isCustomState()) continue;
                    list.add(next);
                }
                if (!list.isEmpty()) {
                    control.setValue("track_views", list);
                }
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            PlotTView view = (PlotTView)obj;
            TTrack track = view.getTrack(control.getString("selected_track"));
            if (track != null) {
                view.setSelectedTrack(track);
                PlotTrackView trackView = (PlotTrackView)view.getTrackView(track);
                if (trackView != null) {
                    TrackPlottingPanel[] plots = trackView.plots;
                    int i = 0;
                    while (i < plots.length) {
                        XMLControl child = control.getChildControl("plot" + i);
                        if (child == null) {
                            trackView.setPlotCount(Math.max(1, i));
                            break;
                        }
                        child.loadObject(plots[i]);
                        ++i;
                    }
                }
            }
            List<XMLProperty> props = control.getPropsRaw();
            int i = 0;
            int n = props.size();
            while (i < n) {
                XMLProperty prop = props.get(i);
                if (prop.getPropertyName().equals("track_views")) {
                    XMLControl[] controls = prop.getChildControls();
                    int j = 0;
                    while (j < controls.length) {
                        String trackName = controls[j].getString("track");
                        track = view.getTrack(trackName);
                        if (track != null) {
                            TrackView v = view.getTrackView(track);
                            if (v == null) {
                                v = view.addTrackView(track);
                            }
                            controls[j].loadObject(v);
                        }
                        ++j;
                    }
                    break;
                }
                ++i;
            }
            return obj;
        }
    }
}

