/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import org.opensourcephysics.cabrillo.tracker.PlotTView;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.TrackPlottingPanel;
import org.opensourcephysics.cabrillo.tracker.TrackView;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.WorldTView;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.HighlightableDataset;
import org.opensourcephysics.tools.FontSizer;

public class PlotTrackView
extends TrackView {
    protected DatasetManager datasetManager;
    private boolean isCustom;
    protected boolean xAxesLinked;
    private int selectedPlot;
    private JPanel mainView;
    protected TrackPlottingPanel[] plots = new TrackPlottingPanel[3];
    protected JButton plotsButton;
    private JCheckBox linkCheckBox;
    private boolean liveUpdates = true;

    public PlotTrackView(TTrack track, TrackerPanel panel, PlotTView view) {
        super(track, panel, view, 0);
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        this.datasetManager = track.getData(trackerPanel, this.myDatasetIndex);
        this.createGUI();
        this.highlightVisible = !"false".equals(track.getProperty("highlights"));
        int i = 0;
        while (i < this.plots.length) {
            this.plots[i].setXVariable((String)track.getProperty("xVarPlot" + i));
            this.plots[i].setYVariable((String)track.getProperty("yVarPlot" + i));
            boolean lines = !"false".equals(track.getProperty("connectedPlot" + i));
            this.plots[i].dataset.setConnected(lines);
            this.plots[i].linesItemSelected = lines;
            boolean pts = !"false".equals(track.getProperty("pointsPlot" + i));
            this.plots[i].dataset.setMarkerShape(pts ? 2 : 0);
            this.plots[i].pointsItemSelected = pts;
            this.plots[i].dataset.setMarkerColor(track.getColor());
            Double D = (Double)track.getProperty("yMinPlot" + i);
            if (D != null) {
                this.plots[i].setPreferredMinMaxY(D, this.plots[i].getPreferredYMax());
            }
            if ((D = (Double)track.getProperty("yMaxPlot" + i)) != null) {
                this.plots[i].setPreferredMinMaxY(this.plots[i].getPreferredYMin(), D);
            }
            this.plots[i].isCustom = false;
            ++i;
        }
        this.setPlotCount(this.getDefaultPlotCount());
        this.refresh(trackerPanel.getFrameNumber(), 0);
    }

    @Override
    public void refresh(int frameNumber, int mode) {
        TTrack track;
        if (mode == 6400) {
            FontSizer.setFonts(this.plotsButton);
            FontSizer.setFonts(this.linkCheckBox);
        }
        if (!this.liveUpdates && this.isClipAdjusting()) {
            return;
        }
        if (!this.isRefreshEnabled() || !this.viewParent.isViewPaneVisible() || (track = this.getTrack()) == null) {
            return;
        }
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        track.getData(trackerPanel, this.myDatasetIndex);
        boolean haveSelection = trackerPanel.selectedSteps.size() > 0;
        Color trackColor = track.getColor();
        Color mc = trackColor.equals(Color.WHITE) ? Color.GRAY : trackColor;
        Color hc = haveSelection ? trackColor : Color.GRAY;
        this.highlightFrames(frameNumber);
        int i = 0;
        while (i < this.plots.length) {
            HighlightableDataset data = this.plots[i].getDataset();
            data.setMarkerColor(mc);
            data.setHighlightColor(hc);
            this.plots[i].setHighlights(this.highlightFrames);
            this.plots[i].plotData();
            ++i;
        }
        this.mainView.repaint();
    }

    @Override
    protected void dispose() {
        this.datasetManager = null;
        TrackPlottingPanel[] trackPlottingPanelArray = this.plots;
        int n = this.plots.length;
        int n2 = 0;
        while (n2 < n) {
            TrackPlottingPanel next = trackPlottingPanelArray[n2];
            next.dispose();
            ++n2;
        }
        this.plots = null;
        this.mainView.removeAll();
        this.viewParent = null;
        super.dispose();
    }

    @Override
    void refreshGUI() {
        this.linkCheckBox.setText(TrackerRes.getString("PlotTrackView.Checkbox.Synchronize"));
        this.linkCheckBox.setToolTipText(TrackerRes.getString("PlotTrackView.Checkbox.Synchronize.Tooltip"));
        this.plotsButton.setText(TrackerRes.getString("PlotTrackView.Button.PlotCount"));
        this.plotsButton.setToolTipText(TrackerRes.getString("PlotTrackView.Button.PlotCount.ToolTip"));
        this.plotsButton.setVerticalAlignment(0);
        this.plotsButton.setHorizontalTextPosition(10);
        this.plotsButton.setHorizontalAlignment(2);
        TTrack track = this.getTrack();
        track.getData(this.frame.getTrackerPanelForID(this.panelID), this.myDatasetIndex);
        int i = 0;
        while (i < this.plots.length) {
            boolean custom = this.plots[i].isCustom;
            this.plots[i].setVariables();
            this.plots[i].isCustom = custom;
            ++i;
        }
    }

    @Override
    public JButton getViewButton() {
        return this.plotsButton;
    }

    @Override
    public boolean isCustomState() {
        int n = this.mainView.getComponentCount();
        if (this.isCustom || n != this.getDefaultPlotCount()) {
            return true;
        }
        int i = 0;
        while (i < n) {
            if (this.plots[i].isCustom) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int getDefaultPlotCount() {
        TTrack track = this.getTrack();
        switch (track.ttype) {
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                return 1;
            }
        }
        return 2;
    }

    public void setPlotCount(int plotCount) {
        if (plotCount == this.mainView.getComponentCount()) {
            return;
        }
        TTrack track = this.getTrack();
        track.tp.changed = true;
        plotCount = Math.min(plotCount, this.plots.length);
        this.selectedPlot = plotCount - 1;
        this.mainView.removeAll();
        this.mainView.add(this.plots[0]);
        int i = 1;
        while (i < plotCount) {
            this.mainView.add(this.plots[i]);
            ++i;
        }
        this.mainView.validate();
        if (plotCount > 1) {
            this.toolbarComponents.add(this.linkCheckBox);
        } else {
            this.toolbarComponents.remove(this.linkCheckBox);
        }
        Runnable runner = new Runnable(){

            @Override
            public synchronized void run() {
                TViewChooser chooser = PlotTrackView.this.plots[0].getOwner();
                if (chooser != null) {
                    chooser.refreshToolbar();
                }
            }
        };
        SwingUtilities.invokeLater(runner);
    }

    public TrackPlottingPanel[] getPlots() {
        int n = this.mainView.getComponentCount();
        TrackPlottingPanel[] visiblePlots = new TrackPlottingPanel[n];
        int i = 0;
        while (i < n) {
            visiblePlots[i] = this.plots[i];
            ++i;
        }
        return visiblePlots;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "units": {
                TrackPlottingPanel[] trackPlottingPanelArray = this.plots;
                int n = this.plots.length;
                int n2 = 0;
                while (n2 < n) {
                    TrackPlottingPanel plot = trackPlottingPanelArray[n2];
                    plot.plotData();
                    plot.repaint();
                    ++n2;
                }
                return;
            }
            case "track": {
                TrackPlottingPanel plot;
                if (e.getNewValue() instanceof WorldTView.WorldPanel) break;
                TrackPlottingPanel[] trackPlottingPanelArray = this.getPlots();
                int n = trackPlottingPanelArray.length;
                int n3 = 0;
                while (n3 < n) {
                    plot = trackPlottingPanelArray[n3];
                    plot.plotAxes.hideScaleSetter();
                    ++n3;
                }
                trackPlottingPanelArray = this.plots;
                n = this.plots.length;
                n3 = 0;
                while (n3 < n) {
                    plot = trackPlottingPanelArray[n3];
                    plot.clearPopup();
                    ++n3;
                }
                return;
            }
        }
        super.propertyChange(e);
    }

    protected void setXAxesLinked(boolean linked) {
        this.xAxesLinked = linked;
        this.linkCheckBox.setSelected(linked);
        if (linked) {
            this.syncXAxesTo(this.plots[0]);
        }
    }

    protected void syncXAxesTo(TrackPlottingPanel plot) {
        if (!this.xAxesLinked) {
            return;
        }
        this.xAxesLinked = false;
        String var = plot.getXVariable();
        TrackPlottingPanel[] trackPlottingPanelArray = this.plots;
        int n = this.plots.length;
        int n2 = 0;
        while (n2 < n) {
            TrackPlottingPanel next = trackPlottingPanelArray[n2];
            if (next != plot) {
                double xMin = plot.isAutoscaleXMin() ? Double.NaN : plot.getPreferredXMin();
                double xMax = plot.isAutoscaleXMax() ? Double.NaN : plot.getPreferredXMax();
                next.setXVariable(var);
                next.setPreferredMinMaxX(xMin, xMax);
                next.scale();
                next.repaint();
            }
            ++n2;
        }
        this.xAxesLinked = true;
    }

    protected void syncYAxes(TrackPlottingPanel ... plots) {
        TrackPlottingPanel plot;
        double yMin = Double.NaN;
        double yMax = Double.NaN;
        boolean sync = false;
        TrackPlottingPanel[] trackPlottingPanelArray = plots;
        int n = plots.length;
        int n2 = 0;
        while (n2 < n) {
            plot = trackPlottingPanelArray[n2];
            if (!Double.isNaN(yMin)) {
                sync = true;
            }
            yMin = Double.isNaN(yMin) ? plot.getPreferredYMin() : Math.min(plot.getPreferredYMin(), yMin);
            yMax = Double.isNaN(yMax) ? plot.getPreferredYMax() : Math.max(plot.getPreferredYMax(), yMax);
            ++n2;
        }
        if (sync) {
            trackPlottingPanelArray = plots;
            n = plots.length;
            n2 = 0;
            while (n2 < n) {
                plot = trackPlottingPanelArray[n2];
                plot.setPreferredMinMaxY(yMin, yMax);
                plot.scale();
                plot.repaint();
                ++n2;
            }
        }
    }

    private TrackPlottingPanel createPlotPanel() {
        TTrack track = this.getTrack();
        TrackPlottingPanel plotPanel = new TrackPlottingPanel(track, this.datasetManager);
        plotPanel.enableInspector(true);
        plotPanel.setAutoscaleX(true);
        plotPanel.setAutoscaleY(true);
        plotPanel.setPreferredSize(new Dimension(140, 140));
        plotPanel.setMinimumSize(new Dimension(100, 100));
        plotPanel.setPlotTrackView(this);
        return plotPanel;
    }

    private void createGUI() {
        this.mainView = new JPanel();
        this.mainView.setDoubleBuffered(true);
        this.mainView.setLayout(new BoxLayout(this.mainView, 1));
        int i = 0;
        while (i < this.plots.length) {
            if (this.plots[i] == null) {
                this.plots[i] = this.createPlotPanel();
            }
            ++i;
        }
        this.setViewportView(this.mainView);
        this.linkCheckBox = new JCheckBox();
        this.linkCheckBox.setOpaque(false);
        this.linkCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotTrackView.this.setXAxesLinked(PlotTrackView.this.linkCheckBox.isSelected());
            }
        });
        this.plotsButton = new TButton(){

            @Override
            public Dimension getMaximumSize() {
                return TViewChooser.getButtonMaxSize(this, super.getMaximumSize(), this.getMinimumSize().height);
            }

            @Override
            public JPopupMenu getPopup() {
                JPopupMenu plotsPopup = PlotTrackView.this.rebuildPlotsPopup();
                FontSizer.setFonts(plotsPopup, FontSizer.getLevel());
                return plotsPopup;
            }
        };
        this.plotsButton.setIcon(TViewChooser.DOWN_ARROW_ICON);
        this.plotsButton.setHorizontalTextPosition(2);
        this.plotsButton.setHorizontalAlignment(2);
        this.plotsButton.setVerticalTextPosition(0);
        this.plotsButton.setVerticalAlignment(1);
    }

    private JPopupMenu rebuildPlotsPopup() {
        ActionListener plotCountSetter = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                PlotTrackView.this.setPlotCount(Integer.parseInt(item.getText()));
                PlotTrackView.this.refresh(PlotTrackView.this.frame.getTrackerPanelForID(PlotTrackView.this.panelID).getFrameNumber(), 0);
            }
        };
        JRadioButtonMenuItem[] plotCountItems = new JRadioButtonMenuItem[this.plots.length];
        ButtonGroup plotCountGroup = new ButtonGroup();
        JPopupMenu plotsPopup = new JPopupMenu();
        int i = 0;
        while (i < this.plots.length) {
            plotCountItems[i] = new JRadioButtonMenuItem(String.valueOf(i + 1));
            plotCountItems[i].addActionListener(plotCountSetter);
            plotsPopup.add(plotCountItems[i]);
            plotCountGroup.add(plotCountItems[i]);
            ++i;
        }
        plotCountItems[this.selectedPlot].setSelected(true);
        return plotsPopup;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public Dimension getPanelSize() {
        return this.mainView.getSize();
    }

    public BufferedImage exportImage(int w, int h) {
        BufferedImage image = (BufferedImage)this.mainView.createImage(w, h);
        if (image == null) {
            return new BufferedImage(w, h, 2);
        }
        Graphics2D g2 = image.createGraphics();
        this.mainView.paint(g2);
        g2.dispose();
        return image;
    }

    public int getPlotCount() {
        return this.mainView.getComponentCount();
    }

    @Override
    protected boolean isRefreshEnabled() {
        return super.isRefreshEnabled() && Tracker.allowPlotRefresh;
    }

    @Override
    public void finalize() {
        OSPLog.finalized(this);
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            PlotTrackView trackView = (PlotTrackView)obj;
            control.setValue("track", trackView.getTrack().getName());
            TrackPlottingPanel[] plots = trackView.getPlots();
            int i = 0;
            while (i < plots.length) {
                control.setValue("plot" + i, plots[i]);
                ++i;
            }
            control.setValue("linked", trackView.xAxesLinked);
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            PlotTrackView trackView = (PlotTrackView)obj;
            trackView.setXAxesLinked(control.getBoolean("linked"));
            TrackPlottingPanel[] plots = trackView.plots;
            int plotCount = 1;
            int i = 0;
            while (i < plots.length) {
                XMLControl child = control.getChildControl("plot" + i);
                if (child != null) {
                    child.loadObject(plots[i]);
                    plotCount = i + 1;
                }
                ++i;
            }
            trackView.setPlotCount(plotCount);
            trackView.isCustom = true;
            return obj;
        }
    }
}

