/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.cabrillo.tracker.AutoTracker;
import org.opensourcephysics.cabrillo.tracker.BounceDerivatives;
import org.opensourcephysics.cabrillo.tracker.CenterOfMass;
import org.opensourcephysics.cabrillo.tracker.CircleFootprint;
import org.opensourcephysics.cabrillo.tracker.Derivative;
import org.opensourcephysics.cabrillo.tracker.DynamicSystem;
import org.opensourcephysics.cabrillo.tracker.FirstDerivative;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.LineFootprint;
import org.opensourcephysics.cabrillo.tracker.PointShapeFootprint;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.SecondDerivative;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TMenuBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.cabrillo.tracker.VectorStep;
import org.opensourcephysics.cabrillo.tracker.WorldTView;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.media.core.DecimalField;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.FontSizer;

public class PointMass
extends TTrack {
    protected static final int FINITE_DIFF = 0;
    protected static final int BOUNCE_DETECT = 1;
    protected static final int FINITE_DIFF_VSPILL2 = 2;
    protected static final double MINIMUM_MASS = 1.0E-30;
    protected static final Derivative vDeriv = new FirstDerivative();
    protected static final Derivative aDeriv = new SecondDerivative();
    protected static final BounceDerivatives bounceDerivs = new BounceDerivatives();
    protected static final String[] dataVariables = new String[]{"t", "x", "y", "r", String.valueOf(Tracker.THETA) + "_{r}", "v_{x}", "v_{y}", "v", String.valueOf(Tracker.THETA) + "_{v}", "a_{x}", "a_{y}", "a", String.valueOf(Tracker.THETA) + "_{a}", Tracker.THETA, TeXParser.parseTeX("$\\omega$"), TeXParser.parseTeX("$\\alpha$"), "step", "frame", "p_{x}", "p_{y}", "p", String.valueOf(Tracker.THETA) + "_{p}", "pixel_{x}", "pixel_{y}", "L", "K", "m"};
    protected static final String[] fieldVariables = new String[]{dataVariables[26], dataVariables[0], dataVariables[1], dataVariables[2], dataVariables[3], dataVariables[4], dataVariables[5], dataVariables[6], dataVariables[7], dataVariables[8], dataVariables[9], dataVariables[10], dataVariables[11], dataVariables[12], dataVariables[18], dataVariables[19], dataVariables[20], dataVariables[21], "ma_{x}", "ma_{y}", "ma", String.valueOf(Tracker.THETA) + "_{ma}"};
    protected static final String[] formatVariables = new String[]{"m", "t", "xy", "v", "a", "p", "ma", Tracker.THETA, TeXParser.parseTeX("$\\omega$"), TeXParser.parseTeX("$\\alpha$"), "pixel", "K"};
    protected static final Map<String, String[]> formatMap;
    protected static final Map<String, String> formatDescriptionMap;
    protected static final String[] footprintNames;
    protected static final ArrayList<String> allVariables;
    protected static boolean isAutoKeyDown;
    protected double mass;
    protected Footprint[] vFootprints;
    protected Footprint vFootprint = LineFootprint.getFootprint("Footprint.Arrow");
    protected Footprint[] aFootprints;
    protected Footprint aFootprint = LineFootprint.getFootprint("Footprint.Arrow");
    private ArrayList<Integer> tList = new ArrayList();
    private Map<Integer, TTrack.StepArray> panelVMap = new IdentityHashMap<Integer, TTrack.StepArray>();
    private Map<Integer, TTrack.StepArray> panelAMap = new IdentityHashMap<Integer, TTrack.StepArray>();
    boolean xvis = true;
    boolean vvis = false;
    boolean avis = false;
    protected boolean xVisibleOnAll = false;
    protected boolean vVisibleOnAll = false;
    protected boolean aVisibleOnAll = false;
    protected boolean labelsVisible = !Tracker.hideLabels;
    protected int algorithm = 0;
    protected int vDerivSpill = 1;
    protected int aDerivSpill = 2;
    protected int bounceDerivsSpill = 3;
    protected int[] params = new int[4];
    protected double[] xData = new double[5];
    protected double[] yData = new double[5];
    protected boolean[] validData = new boolean[5];
    protected Object[] derivData = new Object[]{this.params, this.xData, this.yData, this.validData};
    protected TreeSet<Integer> skippedSteps = new TreeSet();
    protected boolean isAutofill = false;
    protected boolean showfilledSteps = Tracker.showGaps;
    protected NumberField[][] vectorFields;
    protected JLabel massLabel;
    protected NumberField massField;
    protected Component mSeparator;
    protected JMenu velocityMenu;
    protected JMenu accelerationMenu;
    protected JMenuItem vColorItem;
    protected JMenuItem aColorItem;
    protected JMenu vFootprintMenu;
    protected JMenu aFootprintMenu;
    protected JMenuItem vTailsToOriginItem;
    protected JMenuItem vTailsToPositionItem;
    protected JMenuItem aTailsToOriginItem;
    protected JMenuItem aTailsToPositionItem;
    protected JMenuItem autotrackItem;
    protected JCheckBoxMenuItem vVisibleItem;
    protected JCheckBoxMenuItem aVisibleItem;
    protected boolean vAtOrigin;
    protected boolean aAtOrigin;
    protected boolean traceVisible = false;
    protected GeneralPath trace = new GeneralPath();
    protected Stroke traceStroke = new BasicStroke(1.0f);
    protected boolean drawsTrace;
    protected boolean loading;

    static {
        footprintNames = new String[]{"Footprint.Diamond", "Footprint.Triangle", "CircleFootprint.Circle", "Footprint.VerticalLine", "Footprint.HorizontalLine", "Footprint.PositionVector", "Footprint.Spot", "Footprint.BoldDiamond", "Footprint.BoldTriangle", "Footprint.BoldVerticalLine", "Footprint.BoldHorizontalLine", "Footprint.BoldPositionVector"};
        formatMap = new HashMap<String, String[]>();
        formatMap.put(formatVariables[0], new String[]{dataVariables[26]});
        formatMap.put(formatVariables[1], new String[]{"t"});
        formatMap.put(formatVariables[2], new String[]{dataVariables[1], dataVariables[2], dataVariables[3], dataVariables[24]});
        formatMap.put(formatVariables[3], new String[]{dataVariables[5], dataVariables[6], dataVariables[7]});
        formatMap.put(formatVariables[4], new String[]{dataVariables[9], dataVariables[10], dataVariables[11]});
        formatMap.put(formatVariables[5], new String[]{dataVariables[18], dataVariables[19], dataVariables[20]});
        formatMap.put(formatVariables[6], new String[]{fieldVariables[18], fieldVariables[19], fieldVariables[20]});
        formatMap.put(formatVariables[7], new String[]{dataVariables[4], dataVariables[8], dataVariables[12], dataVariables[13], dataVariables[21], fieldVariables[21]});
        formatMap.put(formatVariables[8], new String[]{dataVariables[14]});
        formatMap.put(formatVariables[9], new String[]{dataVariables[14]});
        formatMap.put(formatVariables[10], new String[]{dataVariables[22], dataVariables[23]});
        formatMap.put(formatVariables[11], new String[]{dataVariables[25]});
        formatDescriptionMap = new HashMap<String, String>();
        formatDescriptionMap.put(formatVariables[0], TrackerRes.getString("PointMass.Description.Mass"));
        formatDescriptionMap.put(formatVariables[1], TrackerRes.getString("PointMass.Data.Description.0"));
        formatDescriptionMap.put(formatVariables[2], TrackerRes.getString("PointMass.Position.Name"));
        formatDescriptionMap.put(formatVariables[3], TrackerRes.getString("PointMass.Velocity.Name"));
        formatDescriptionMap.put(formatVariables[4], TrackerRes.getString("PointMass.Acceleration.Name"));
        formatDescriptionMap.put(formatVariables[5], TrackerRes.getString("PointMass.Description.Momentum"));
        formatDescriptionMap.put(formatVariables[6], TrackerRes.getString("PointMass.Description.NetForce"));
        formatDescriptionMap.put(formatVariables[7], TrackerRes.getString("Vector.Data.Description.4"));
        formatDescriptionMap.put(formatVariables[8], TrackerRes.getString("PointMass.Data.Description.14"));
        formatDescriptionMap.put(formatVariables[9], TrackerRes.getString("PointMass.Data.Description.15"));
        formatDescriptionMap.put(formatVariables[10], TrackerRes.getString("PointMass.Description.Pixel"));
        formatDescriptionMap.put(formatVariables[11], TrackerRes.getString("PointMass.Data.Description.22"));
        allVariables = PointMass.createAllVariables(dataVariables, fieldVariables);
    }

    @Override
    public String[] getFormatVariables() {
        return formatVariables;
    }

    @Override
    public Map<String, String[]> getFormatMap() {
        return formatMap;
    }

    @Override
    public Map<String, String> getFormatDescMap() {
        return formatDescriptionMap;
    }

    @Override
    public String getBaseType() {
        return "PointMass";
    }

    @Override
    public String getVarDimsImpl(String v) {
        String[] vars = dataVariables;
        String[] names = formatVariables;
        if (vars[26].equals(v)) {
            return "M";
        }
        if (vars[1].equals(v) || vars[2].equals(v) || vars[3].equals(v) || vars[24].equals(v) || names[2].equals(v)) {
            return "L";
        }
        if (vars[5].equals(v) || vars[6].equals(v) || vars[7].equals(v)) {
            return "L/T";
        }
        if (vars[9].equals(v) || vars[10].equals(v) || vars[11].equals(v)) {
            return "L/TT";
        }
        if (vars[14].equals(v)) {
            return "A/T";
        }
        if (vars[15].equals(v)) {
            return "A/TT";
        }
        if (vars[16].equals(v) || vars[17].equals(v)) {
            return "I";
        }
        if (vars[18].equals(v) || vars[19].equals(v) || vars[20].equals(v)) {
            return "ML/T";
        }
        if (vars[22].equals(v) || vars[23].equals(v) || names[10].equals(v)) {
            return "P";
        }
        if (vars[25].equals(v)) {
            return "MLL/TT";
        }
        if (names[6].equals(v) || (vars = this.getVariablesFromFormatterDisplayName(names[6]))[0].equals(v) || vars[1].equals(v) || vars[2].equals(v) || names[6].equals(v)) {
            return "ML/TT";
        }
        return null;
    }

    public PointMass() {
        this(1.0);
    }

    public PointMass(double mass) {
        super(5);
        this.defaultColors = new Color[]{Color.red, Color.cyan, Color.magenta, new Color(153, 153, 255)};
        Footprint[] fp = new Footprint[footprintNames.length];
        int i = 0;
        while (i < fp.length) {
            String name = footprintNames[i];
            fp[i] = name.equals("CircleFootprint.Circle") ? CircleFootprint.getFootprint(name) : PointShapeFootprint.getFootprint(name);
            ++i;
        }
        this.setFootprints(fp);
        if (Tracker.preferredPointMassFootprint != null) {
            this.setFootprint(Tracker.preferredPointMassFootprint);
        }
        this.defaultFootprint = this.getFootprint();
        this.setVelocityFootprints(new Footprint[]{LineFootprint.getFootprint("Footprint.Arrow"), LineFootprint.getFootprint("Footprint.BoldArrow"), LineFootprint.getFootprint("Footprint.BigArrow")});
        this.setAccelerationFootprints(new Footprint[]{LineFootprint.getFootprint("Footprint.Arrow"), LineFootprint.getFootprint("Footprint.BoldArrow"), LineFootprint.getFootprint("Footprint.BigArrow")});
        this.setName(TrackerRes.getString("PointMass.New.Name"));
        this.setProperty("xVarPlot0", "t");
        this.setProperty("yVarPlot0", "x");
        this.setProperty("xVarPlot1", "t");
        this.setProperty("yVarPlot1", "y");
        this.mass = Math.abs(mass);
        this.setTrailVisible(true);
        this.setAutoAdvance(true);
        this.hint = String.valueOf(TrackerRes.getString("PointMass.Hint")) + TrackerRes.getString("PointMass.Unmarked.Hint");
        this.createGUI();
    }

    @Override
    public void setColor(Color color) {
        this.setVelocityColor(color);
        this.setAccelerationColor(color);
        super.setColor(color);
    }

    public void setVelocityColor(Color color) {
        int i = 0;
        while (i < this.vFootprints.length) {
            this.vFootprints[i].setColor(color);
            ++i;
        }
    }

    public void setAccelerationColor(Color color) {
        int i = 0;
        while (i < this.aFootprints.length) {
            this.aFootprints[i].setColor(color);
            ++i;
        }
    }

    @Override
    public Step createStep(int n, double x, double y) {
        PositionStep step;
        if (this.isLocked()) {
            return null;
        }
        boolean firstStep = this.steps.isEmpty();
        if (firstStep && this.tp != null) {
            this.stepSizeWhenFirstMarked = this.tp.getPlayer().getVideoClip().getStepSize();
        }
        if ((step = (PositionStep)this.getStep(n)) == null) {
            step = new PositionStep(this, n, x, y);
            this.steps.setStep(n, step);
            step.setFootprint(this.getFootprint());
            if (!this.loading && this.isAutofill()) {
                this.markInterpolatedSteps(step, true);
            }
        } else if (x != step.getPosition().x || y != step.getPosition().y) {
            XMLControlElement state = new XMLControlElement(step);
            step.getPosition().setLocation(x, y);
            if (this.undoEnabled) {
                Undo.postStepEdit(step, state);
            }
            step.erase();
        }
        step.valid = true;
        if (!this.loading) {
            JDialog warning;
            Step prev;
            VideoClip clip;
            int stepNumber;
            if (!this.autoTrackerMarking && this.tp != null && this.tp.isAutoRefresh()) {
                this.updateDerivatives(n);
            }
            this.firePropertyChange("step", HINT_STEP_ADDED_OR_REMOVED, new Integer(n));
            if (Tracker.warnSkippedStep && this.steps.isPreceded(n) && this.tp != null && !this.isDependent() && !AutoTracker.mayLeaveGaps() && (stepNumber = (clip = this.tp.getPlayer().getVideoClip()).frameToStep(n)) > 0 && (prev = this.getStep(clip.stepToFrame(stepNumber - 1))) == null && (warning = this.getSkippedStepWarningDialog()) != null) {
                warning.setVisible(true);
            }
        }
        return step;
    }

    @Override
    public Step deleteStep(int n) {
        Step step = super.deleteStep(n);
        this.keyFrames.remove(n);
        if (step != null) {
            this.updateDerivatives(n);
        }
        this.deleteAutoTrackerStep(n);
        return step;
    }

    protected void deleteAutoTrackerStep(int n) {
        AutoTracker autoTracker = this.tp.getAutoTracker(false);
        if (autoTracker != null && autoTracker.getTrack() == this) {
            autoTracker.delete(n);
        }
    }

    @Override
    public Step getStep(TPoint point, TrackerPanel panel) {
        if (point == null) {
            return null;
        }
        Step[] stepArray = null;
        Integer panelID = panel.getID();
        int n = 0;
        while (n < 3) {
            switch (n) {
                case 0: {
                    stepArray = this.steps.array;
                    break;
                }
                case 1: {
                    stepArray = this.getVelocities(panelID);
                    break;
                }
                default: {
                    stepArray = this.getAccelerations(panelID);
                }
            }
            int j = 0;
            while (j < stepArray.length) {
                if (stepArray[j] != null) {
                    TPoint[] points = stepArray[j].getPoints();
                    int i = 0;
                    while (i < points.length) {
                        if (points[i] == point) {
                            return stepArray[j];
                        }
                        ++i;
                    }
                }
                ++j;
            }
            ++n;
        }
        return null;
    }

    @Override
    public Step getNextVisibleStep(Step step, TrackerPanel panel) {
        Integer panelID = panel.getID();
        Step[] steps = this.getSteps();
        if (this.isVelocity(step)) {
            steps = this.getVelocities(panelID);
        }
        if (this.isAcceleration(step)) {
            steps = this.getAccelerations(panelID);
        }
        boolean found = false;
        int i = 0;
        while (i < steps.length) {
            if (found && steps[i] != null && this.isStepVisible(steps[i], panel)) {
                return steps[i];
            }
            if (steps[i] == step) {
                found = true;
            }
            ++i;
        }
        if (found) {
            i = 0;
            while (i < steps.length) {
                if (steps[i] != null && steps[i] != step && this.isStepVisible(steps[i], panel)) {
                    return steps[i];
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public Step getPreviousVisibleStep(Step step, TrackerPanel panel) {
        Step[] steps = this.getSteps();
        Integer panelID = panel.getID();
        if (this.isVelocity(step)) {
            steps = this.getVelocities(panelID);
        }
        if (this.isAcceleration(step)) {
            steps = this.getAccelerations(panelID);
        }
        boolean found = false;
        int i = steps.length - 1;
        while (i > -1) {
            if (found && steps[i] != null && this.isStepVisible(steps[i], panel)) {
                return steps[i];
            }
            if (steps[i] == step) {
                found = true;
            }
            --i;
        }
        if (found) {
            i = steps.length - 1;
            while (i > -1) {
                if (steps[i] != null && steps[i] != step && this.isStepVisible(steps[i], panel)) {
                    return steps[i];
                }
                --i;
            }
        }
        return null;
    }

    @Override
    public int getStepLength() {
        return PositionStep.getLength();
    }

    @Override
    protected boolean isAutoTrackable() {
        return true;
    }

    @Override
    public TPoint autoMarkAt(int n, double x, double y) {
        TPoint p = super.autoMarkAt(n, x, y);
        this.keyFrames.add(n);
        return p;
    }

    @Override
    public int getFootprintLength() {
        return 1;
    }

    public Footprint[] getVelocityFootprints() {
        return this.vFootprints;
    }

    public void setVelocityFootprints(Footprint[] choices) {
        ArrayList<Footprint> valid = new ArrayList<Footprint>();
        int i = 0;
        while (i < choices.length) {
            if (choices[i] != null && choices[i].getLength() == this.vFootprint.getLength()) {
                choices[i].setColor(this.vFootprint.getColor());
                valid.add(choices[i]);
            }
            ++i;
        }
        if (valid.size() > 0) {
            this.vFootprints = valid.toArray(new Footprint[0]);
            this.setVelocityFootprint(this.vFootprints[0].getName());
        }
    }

    public Footprint getVelocityFootprint() {
        return this.vFootprint;
    }

    public void setVelocityFootprint(String name) {
        int i = 0;
        while (i < this.vFootprints.length) {
            if (name.equals(this.vFootprints[i].getName())) {
                this.vFootprint = this.vFootprints[i];
                if (this.tp == null) {
                    return;
                }
                int j = 0;
                while (j < this.tp.andWorld.size()) {
                    Integer panelID = this.tp.andWorld.get(j);
                    Step[] stepArray = this.getVArray((Integer)panelID).array;
                    int k = 0;
                    while (k < stepArray.length) {
                        if (stepArray[k] != null) {
                            stepArray[k].setFootprint(this.vFootprint);
                        }
                        ++k;
                    }
                    ++j;
                }
                this.firePropertyChange("footprint", null, this.vFootprint);
                this.repaint();
                return;
            }
            ++i;
        }
    }

    public Footprint[] getAccelerationFootprints() {
        return this.aFootprints;
    }

    public void setAccelerationFootprints(Footprint[] choices) {
        ArrayList<Footprint> valid = new ArrayList<Footprint>();
        int i = 0;
        while (i < choices.length) {
            if (choices[i] != null && choices[i].getLength() == this.aFootprint.getLength()) {
                choices[i].setColor(this.aFootprint.getColor());
                valid.add(choices[i]);
            }
            ++i;
        }
        if (valid.size() > 0) {
            this.aFootprints = valid.toArray(new Footprint[0]);
            this.setAccelerationFootprint(this.aFootprints[0].getName());
        }
    }

    public Footprint getAccelerationFootprint() {
        return this.aFootprint;
    }

    public void setAccelerationFootprint(String name) {
        int i = 0;
        while (i < this.aFootprints.length) {
            if (name.equals(this.aFootprints[i].getName())) {
                this.aFootprint = this.aFootprints[i];
                if (this.tp == null) {
                    return;
                }
                int j = 0;
                while (j < this.tp.andWorld.size()) {
                    Integer panelID = this.tp.andWorld.get(j);
                    Step[] stepArray = this.getAArray((Integer)panelID).array;
                    int k = 0;
                    while (k < stepArray.length) {
                        if (stepArray[k] != null) {
                            stepArray[k].setFootprint(this.aFootprint);
                        }
                        ++k;
                    }
                    ++j;
                }
                this.repaint();
                this.firePropertyChange("footprint", null, this.aFootprint);
                return;
            }
            ++i;
        }
    }

    @Override
    public Footprint[] getFootprints(Step step) {
        if (step == null) {
            return this.getFootprints();
        }
        if (this.isVelocity(step)) {
            return this.getVelocityFootprints();
        }
        if (this.isAcceleration(step)) {
            return this.getAccelerationFootprints();
        }
        return this.getFootprints();
    }

    @Override
    public void setFootprint(String name, Step step) {
        if (step == null) {
            this.setFootprint(name);
        } else if (this.isVelocity(step)) {
            this.setVelocityFootprint(name);
        } else if (this.isAcceleration(step)) {
            this.setAccelerationFootprint(name);
        } else {
            this.setFootprint(name);
        }
    }

    @Override
    public Footprint getFootprint(Step step) {
        if (step != null) {
            return step.footprint;
        }
        return this.getFootprint();
    }

    @Override
    protected void setMarking(boolean marking) {
        super.setMarking(marking);
        this.repaint(this.tp.getID());
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double mass) {
        if (mass == this.mass) {
            return;
        }
        mass = Math.abs(mass);
        this.mass = mass = Math.max(mass, 1.0E-30);
        this.firePropertyChange("mass", null, mass);
        this.invalidateData(this);
        if (this.datasetManager != null) {
            Double m = this.getMass();
            String desc = TrackerRes.getString("ParticleModel.Parameter.Mass.Description");
            this.datasetManager.setConstant("m", m, m.toString(), desc);
        }
    }

    @Override
    public void setFontLevel(int level) {
        super.setFontLevel(level);
        FontSizer.setFont(this.massLabel);
        FontSizer.setFont(this.massField);
    }

    public Point2D getWorldPosition(int n, TrackerPanel panel) {
        PositionStep step = (PositionStep)this.getStep(n);
        if (step != null) {
            return step.getPosition().getWorldPosition(panel);
        }
        return null;
    }

    public Point2D getWorldVelocity(int n, TrackerPanel panel) {
        ImageCoordSystem coords = panel.getCoords();
        double dt = panel.getPlayer().getMeanStepDuration() / 1000.0;
        VectorStep veloc = this.getVelocity(n, panel.getID());
        if (veloc != null) {
            double imageX = veloc.getXComponent();
            double imageY = veloc.getYComponent();
            double worldX = coords.imageToWorldXComponent(n, imageX, imageY) / dt;
            double worldY = coords.imageToWorldYComponent(n, imageX, imageY) / dt;
            return new Point2D.Double(worldX, worldY);
        }
        return null;
    }

    public Point2D getWorldAcceleration(int n, Integer panelID) {
        TrackerPanel panel = this.panel(panelID);
        ImageCoordSystem coords = panel.getCoords();
        double dt = panel.getPlayer().getMeanStepDuration() / 1000.0;
        VectorStep accel = this.getAcceleration(n, panelID);
        if (accel != null) {
            double imageX = accel.getXComponent();
            double imageY = accel.getYComponent();
            double worldX = coords.imageToWorldXComponent(n, imageX, imageY) / (dt * dt);
            double worldY = coords.imageToWorldYComponent(n, imageX, imageY) / (dt * dt);
            return new Point2D.Double(worldX, worldY);
        }
        return null;
    }

    public void setAlgorithm(int type) {
        if (type == this.algorithm) {
            return;
        }
        if (type == 0 || type == 1 || type == 2) {
            this.algorithm = type;
            this.refreshDataLater = false;
            this.updateDerivatives();
            this.fireStepsChanged();
        }
    }

    public boolean isAutofill() {
        return Tracker.enableAutofill && this.isAutofill;
    }

    public void setAutoFill(boolean autofill) {
        this.isAutofill = autofill;
        this.markAllInterpolatedSteps();
    }

    public boolean hasGaps() {
        if (this.tp == null) {
            return false;
        }
        VideoClip clip = this.tp.getPlayer().getVideoClip();
        int prev = -1;
        if (this.keyFrames.isEmpty() && !this.steps.isEmpty()) {
            Step[] steps = this.getSteps();
            int i = 0;
            while (i < steps.length) {
                if (steps[i] != null && clip.includesFrame(i)) {
                    if (prev == -1) {
                        prev = i;
                    } else {
                        if (i - prev > clip.getStepSize()) {
                            return true;
                        }
                        prev = i;
                    }
                }
                ++i;
            }
        }
        Iterator iterator = this.keyFrames.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!clip.includesFrame(n)) continue;
            if (prev == -1) {
                prev = n;
                continue;
            }
            if (n - prev > clip.getStepSize()) {
                return true;
            }
            prev = n;
        }
        return false;
    }

    public int getUnfilledGapCount(boolean emptyGapsOnly) {
        int prev = -1;
        int gapCount = 0;
        Iterator iterator = this.keyFrames.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (prev == -1) {
                prev = n;
                continue;
            }
            if (n - prev > 1) {
                boolean filled = true;
                boolean empty = true;
                int i = prev + 1;
                while (i < n) {
                    if (this.skippedSteps.contains(i)) {
                        filled = false;
                    } else {
                        empty = false;
                    }
                    ++i;
                }
                if (!emptyGapsOnly && !filled) {
                    ++gapCount;
                } else if (emptyGapsOnly && empty) {
                    ++gapCount;
                }
            }
            prev = n;
        }
        return gapCount;
    }

    public void markAllInterpolatedSteps() {
        if (this.isLocked()) {
            return;
        }
        XMLControlElement control = new XMLControlElement(this);
        boolean changed = false;
        VideoPlayer player = this.tp.getPlayer();
        VideoClip clip = player.getVideoClip();
        Step[] stepArray = this.getSteps();
        PositionStep curStep = null;
        PositionStep prevNonNullStep = null;
        int n = 0;
        while (n < stepArray.length) {
            boolean inFrame = clip.includesFrame(n);
            if (inFrame && (curStep = (PositionStep)stepArray[n]) != null && this.keyFrames.contains(n)) {
                if (prevNonNullStep != null) {
                    changed = this.markInterpolatedSteps(prevNonNullStep, curStep) || changed;
                }
                prevNonNullStep = curStep;
            }
            ++n;
        }
        this.refreshDataLater = false;
        this.updateDerivatives();
        this.fireStepsChanged();
        if (changed) {
            Undo.postTrackEdit(this, control);
        }
    }

    public void markInterpolatedSteps(PositionStep step, boolean refreshData) {
        PositionStep end;
        PositionStep start;
        int firstStep;
        if (this.isLocked() || this.tp == null) {
            return;
        }
        if (!this.keyFrames.contains(step.n)) {
            return;
        }
        XMLControlElement control = new XMLControlElement(this);
        boolean changed = false;
        VideoClip clip = this.tp.getPlayer().getVideoClip();
        int earlier = -1;
        int later = -1;
        Iterator iterator = this.keyFrames.iterator();
        while (iterator.hasNext()) {
            int keyframe = (Integer)iterator.next();
            boolean inFrame = clip.includesFrame(keyframe);
            if (!inFrame || keyframe == step.n) continue;
            if (keyframe < step.n) {
                earlier = keyframe;
            }
            if (later != -1 || keyframe <= step.n) continue;
            later = keyframe;
        }
        Step[] stepArray = this.getSteps();
        int lastStep = firstStep = clip.frameToStep(step.n);
        if (earlier > -1 && (start = (PositionStep)stepArray[earlier]) != null) {
            changed = this.markInterpolatedSteps(start, step);
            firstStep = clip.frameToStep(earlier);
        }
        if (later > -1 && (end = (PositionStep)stepArray[later]) != null) {
            changed = this.markInterpolatedSteps(step, end) || changed;
            lastStep = clip.frameToStep(later);
        }
        boolean bl = this.refreshDataLater = !refreshData;
        if (refreshData) {
            this.updateDerivatives(firstStep, lastStep - firstStep);
        }
        this.fireStepsChanged();
        if (changed) {
            Undo.postTrackEdit(this, control);
        }
    }

    public boolean markInterpolatedSteps(PositionStep startStep, PositionStep endStep) {
        if (this.isLocked()) {
            return false;
        }
        VideoClip clip = this.tp.getPlayer().getVideoClip();
        int startStepNum = clip.frameToStep(startStep.n);
        int endStepNum = clip.frameToStep(endStep.n);
        int range = endStepNum - startStepNum;
        if (range < 2) {
            return false;
        }
        Step[] stepArray = this.getSteps();
        boolean changed = false;
        int i = startStepNum + 1;
        while (i < endStepNum) {
            double x1 = startStep.getPosition().getX();
            double y1 = startStep.getPosition().getY();
            double x2 = endStep.getPosition().getX();
            double y2 = endStep.getPosition().getY();
            double x = x1 + (x2 - x1) * (double)(i - startStepNum) / (double)range;
            double y = y1 + (y2 - y1) * (double)(i - startStepNum) / (double)range;
            int frameNum = clip.stepToFrame(i);
            PositionStep step = (PositionStep)stepArray[frameNum];
            if (this.isAutofill()) {
                if (step == null) {
                    changed = true;
                    step = new PositionStep(this, frameNum, x, y);
                    this.steps.setStep(frameNum, step);
                    step.setFootprint(this.getFootprint());
                } else {
                    step.getPosition().setLocation(x, y);
                    step.erase();
                }
                step.valid = true;
            } else if (step != null) {
                this.steps.setStep(step.n, null);
                changed = true;
            }
            ++i;
        }
        return changed;
    }

    @Override
    public void dispose() {
        if (this.tp != null) {
            this.tp.removePointMassListeners(this);
        }
        super.dispose();
    }

    @Override
    protected String getTargetDescription(int pointIndex) {
        return TrackerRes.getString("PointMass.Position.Name");
    }

    @Override
    protected void refreshData(DatasetManager data, TrackerPanel panel) {
        if (this.refreshDataLater || panel == null || data == null) {
            return;
        }
        Integer panelID = panel.getID();
        int count = 24;
        if (!this.getClass().equals(CenterOfMass.class) && !this.getClass().equals(DynamicSystem.class)) {
            count = 25;
        }
        if (this.preferredColumnOrder == null) {
            if (count == 24) {
                int[] nArray = new int[19];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                nArray[4] = 4;
                nArray[5] = 5;
                nArray[6] = 6;
                nArray[7] = 7;
                nArray[8] = 8;
                nArray[9] = 9;
                nArray[10] = 10;
                nArray[11] = 11;
                nArray[12] = 17;
                nArray[13] = 18;
                nArray[14] = 19;
                nArray[15] = 20;
                nArray[16] = 12;
                nArray[17] = 13;
                nArray[18] = 14;
                this.preferredColumnOrder = nArray;
            } else {
                int[] nArray = new int[20];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                nArray[4] = 4;
                nArray[5] = 5;
                nArray[6] = 6;
                nArray[7] = 7;
                nArray[8] = 8;
                nArray[9] = 9;
                nArray[10] = 10;
                nArray[11] = 11;
                nArray[12] = 17;
                nArray[13] = 18;
                nArray[14] = 19;
                nArray[15] = 20;
                nArray[16] = 12;
                nArray[17] = 13;
                nArray[18] = 14;
                nArray[19] = 24;
                this.preferredColumnOrder = nArray;
            }
        }
        Object[] rotationData = this.getRotationData();
        double[] theta_data = (double[])rotationData[0];
        double[] omega_data = (double[])rotationData[1];
        double[] alpha_data = (double[])rotationData[2];
        this.dataFrames.clear();
        this.skippedSteps.clear();
        VideoPlayer player = panel.getPlayer();
        VideoClip clip = player.getVideoClip();
        ImageCoordSystem coords = panel.getCoords();
        Step[] stepArray = this.getSteps();
        Step curStep = null;
        Step prevNonNullStep = null;
        int len = stepArray.length;
        double[][] validData = new double[count + 1][len];
        int pt = 0;
        double ke = Double.NaN;
        Point2D prevPt = null;
        double pathlength = 0.0;
        int i = 0;
        while (i < len) {
            curStep = stepArray[i];
            if (curStep == null) {
                this.keyFrames.remove(i);
            } else {
                PositionStep.Position p = ((PositionStep)curStep).getPosition();
                Point2D wp = p.getWorldPosition(panel);
                double x = wp.getX();
                double y = wp.getY();
                if (Double.isNaN(x) || Double.isNaN(y)) {
                    stepArray[i] = null;
                    this.keyFrames.remove(i);
                } else {
                    boolean inFrame = clip.includesFrame(i);
                    if (inFrame) {
                        int curStepNum = clip.frameToStep(i);
                        if (prevNonNullStep != null) {
                            int prevStepNum = clip.frameToStep(prevNonNullStep.n);
                            int j = prevStepNum + 1;
                            while (j < curStepNum) {
                                this.skippedSteps.add(j);
                                ++j;
                            }
                        }
                        prevNonNullStep = curStep;
                        int stepNumber = clip.frameToStep(i);
                        double t = player.getStepTime(stepNumber) / 1000.0;
                        double tf = player.getStepTime(stepNumber + this.vDerivSpill) / 1000.0;
                        double to = player.getStepTime(stepNumber - this.vDerivSpill) / 1000.0;
                        double dt_v = (tf - to) / (double)(2 * this.vDerivSpill);
                        tf = player.getStepTime(stepNumber + this.aDerivSpill) / 1000.0;
                        to = player.getStepTime(stepNumber - this.aDerivSpill) / 1000.0;
                        double dt_a2 = (tf - to) * (tf - to) / (double)(4 * this.aDerivSpill * this.aDerivSpill);
                        validData[0][pt] = x;
                        validData[1][pt] = y;
                        double d = Math.sqrt(x * x + y * y);
                        validData[2][pt] = d;
                        double r = d;
                        double d2 = Math.atan2(y, x);
                        validData[3][pt] = d2;
                        double slope = d2;
                        validData[12][pt] = theta_data[i];
                        validData[13][pt] = omega_data[i] / dt_v;
                        validData[14][pt] = alpha_data[i] / dt_a2;
                        validData[15][pt] = stepNumber;
                        validData[16][pt] = i;
                        VectorStep veloc = this.getVelocity(i, panelID);
                        if (veloc == null) {
                            validData[4][pt] = Double.NaN;
                            validData[5][pt] = Double.NaN;
                            validData[6][pt] = Double.NaN;
                            validData[7][pt] = Double.NaN;
                            validData[17][pt] = Double.NaN;
                            validData[18][pt] = Double.NaN;
                            validData[19][pt] = Double.NaN;
                            validData[20][pt] = Double.NaN;
                            ke = Double.NaN;
                        } else {
                            double imageX = veloc.getXComponent();
                            double imageY = veloc.getYComponent();
                            double d3 = coords.imageToWorldXComponent(i, imageX, imageY) / dt_v;
                            validData[4][pt] = d3;
                            x = d3;
                            double d4 = coords.imageToWorldYComponent(i, imageX, imageY) / dt_v;
                            validData[5][pt] = d4;
                            y = d4;
                            double v2 = x * x + y * y;
                            double d5 = Math.sqrt(v2);
                            validData[6][pt] = d5;
                            r = d5;
                            double d6 = Math.atan2(y, x);
                            validData[7][pt] = d6;
                            slope = d6;
                            double mass = this.getMass();
                            validData[17][pt] = mass * x;
                            validData[18][pt] = mass * y;
                            validData[19][pt] = mass * r;
                            validData[20][pt] = mass * slope;
                            ke = 0.5 * mass * v2;
                        }
                        VectorStep accel = this.getAcceleration(i, panel.getID());
                        if (accel == null) {
                            validData[8][pt] = Double.NaN;
                            validData[9][pt] = Double.NaN;
                            validData[10][pt] = Double.NaN;
                            validData[11][pt] = Double.NaN;
                        } else {
                            double imageX = accel.getXComponent();
                            double imageY = accel.getYComponent();
                            double d7 = coords.imageToWorldXComponent(i, imageX, imageY) / dt_a2;
                            validData[8][pt] = d7;
                            x = d7;
                            double d8 = coords.imageToWorldYComponent(i, imageX, imageY) / dt_a2;
                            validData[9][pt] = d8;
                            y = d8;
                            validData[10][pt] = Math.sqrt(x * x + y * y);
                            validData[11][pt] = Math.atan2(y, x);
                        }
                        validData[21][pt] = p.x;
                        validData[22][pt] = p.y;
                        if (prevPt != null) {
                            pathlength += prevPt.distance(wp);
                        }
                        prevPt = wp;
                        validData[23][pt] = pathlength;
                        if (count == 25) {
                            validData[24][pt] = ke;
                        }
                        validData[count][pt] = t;
                        this.dataFrames.add(i);
                        ++pt;
                    }
                }
            }
            ++i;
        }
        this.clearColumns(data, count, dataVariables, null, validData, pt);
        i = count + 1;
        while (--i >= 0) {
            String s;
            switch (i) {
                default: {
                    s = "PointMass.Data.Description." + i;
                    break;
                }
                case 22: {
                    s = "PointMass.Data.Description.PixelX";
                    break;
                }
                case 23: {
                    s = "PointMass.Data.Description.PixelY";
                    break;
                }
                case 24: {
                    s = "PointMass.Data.Description.PathLength";
                    break;
                }
                case 25: {
                    s = "PointMass.Data.Description.22";
                }
            }
            this.dataDescriptions[i] = TrackerRes.getString(s);
        }
        Double m = this.getMass();
        String desc = TrackerRes.getString("ParticleModel.Parameter.Mass.Description");
        data.setConstant("m", m, m.toString(), desc);
    }

    @Override
    public void draw(DrawingPanel dp, Graphics _g) {
        if (!(dp instanceof TrackerPanel) || !this.visible) {
            return;
        }
        TrackerPanel panel = (TrackerPanel)dp;
        Graphics2D g = (Graphics2D)_g;
        VideoClip clip = panel.getPlayer().getVideoClip();
        int n = panel.getFrameNumber();
        Integer panelID = panel.getID();
        int stepSize = clip.getStepSize();
        if (this.trailVisible) {
            boolean shortTrail = this.getTrailLength() > 0;
            Step[] stepArray = this.steps.array;
            int i0 = shortTrail ? Math.max(n - (this.getTrailLength() - 1) * stepSize, 0) : 0;
            n = shortTrail ? Math.min(n + 1, stepArray.length) : stepArray.length;
            int i = i0;
            while (i < n) {
                if (stepArray[i] != null) {
                    VectorStep a;
                    VectorStep v;
                    if (this.isStepVisible(stepArray[i], panel)) {
                        stepArray[i].draw(panel, g);
                    }
                    if ((v = this.getVelocity(i, panelID)) != null && this.isStepVisible(v, panel)) {
                        ((Step)v).draw(panel, g);
                    }
                    if ((a = this.getAcceleration(i, panelID)) != null && this.isStepVisible(a, panel)) {
                        ((Step)a).draw(panel, g);
                    }
                }
                ++i;
            }
        } else {
            Step step = this.getStep(n);
            if (step != null) {
                VectorStep a;
                VectorStep v;
                if (this.isStepVisible(step, panel)) {
                    step.draw(panel, g);
                }
                if ((v = this.getVelocity(n, panelID)) != null && this.isStepVisible(v, panel)) {
                    ((Step)v).draw(panel, g);
                }
                if ((a = this.getAcceleration(n, panelID)) != null && this.isStepVisible(a, panel)) {
                    ((Step)a).draw(panel, g);
                }
            }
        }
        if (!this.drawsTrace && this.isTraceVisible()) {
            Color c = g.getColor();
            Stroke s = g.getStroke();
            g.setColor(this.getColor());
            g.setStroke(this.traceStroke);
            if (OSPRuntime.setRenderingHints) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            this.trace.reset();
            int startFrame = clip.getStartFrameNumber();
            int endFrame = clip.getEndFrameNumber();
            boolean reset = true;
            int i = startFrame;
            while (i <= endFrame) {
                PositionStep step = (PositionStep)this.getStep(i);
                if (step == null) {
                    g.draw(this.trace);
                    reset = true;
                } else {
                    Point p = step.getPosition().getScreenPosition(panel);
                    if (reset) {
                        this.trace.reset();
                        this.trace.moveTo((float)p.getX(), (float)p.getY());
                        reset = false;
                    } else {
                        this.trace.lineTo((float)p.getX(), (float)p.getY());
                    }
                }
                i += stepSize;
            }
            g.draw(this.trace);
            g.setColor(c);
            g.setStroke(s);
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel dp, int xpix, int ypix) {
        if (!(dp instanceof TrackerPanel) || !this.visible) {
            return null;
        }
        TrackerPanel panel = (TrackerPanel)dp;
        Integer panelID = panel.getID();
        Interactive iad = null;
        int n = panel.getFrameNumber();
        int stepSize = panel.getPlayer().getVideoClip().getStepSize();
        if (this.trailVisible) {
            boolean shortTrail = this.getTrailLength() > 0;
            Step[] stepArray = this.steps.array;
            int i = 0;
            while (i < stepArray.length) {
                if ((!shortTrail || n - i <= (this.getTrailLength() - 1) * stepSize && i <= n) && stepArray[i] != null) {
                    if (this.isStepVisible(stepArray[i], panel) && (iad = stepArray[i].findInteractive(panel, xpix, ypix)) != null) {
                        this.partName = TrackerRes.getString("PointMass.Position.Name");
                        this.hint = TrackerRes.getString("PointMass.Position.Hint");
                        return iad;
                    }
                    VectorStep v = this.getVelocity(i, panelID);
                    if (v != null && this.isStepVisible(v, panel) && (iad = ((Step)v).findInteractive(panel, xpix, ypix)) != null) {
                        this.partName = TrackerRes.getString("PointMass.Velocity.Name");
                        this.hint = TrackerRes.getString("PointMass.Vector.Hint");
                        return iad;
                    }
                    VectorStep a = this.getAcceleration(i, panelID);
                    if (a != null && this.isStepVisible(a, panel) && (iad = ((Step)a).findInteractive(panel, xpix, ypix)) != null) {
                        this.partName = TrackerRes.getString("PointMass.Acceleration.Name");
                        this.hint = TrackerRes.getString("PointMass.Vector.Hint");
                        return iad;
                    }
                }
                ++i;
            }
        } else {
            Step step = this.getStep(n);
            if (step != null) {
                if (this.isStepVisible(step, panel) && (iad = step.findInteractive(panel, xpix, ypix)) != null) {
                    this.partName = TrackerRes.getString("PointMass.Position.Name");
                    this.hint = TrackerRes.getString("PointMass.Position.Hint");
                    return iad;
                }
                VectorStep v = this.getVelocity(n, panelID);
                if (v != null && this.isStepVisible(v, panel) && (iad = ((Step)v).findInteractive(panel, xpix, ypix)) != null) {
                    this.partName = TrackerRes.getString("PointMass.Velocity.Name");
                    this.hint = TrackerRes.getString("PointMass.Vector.Hint");
                    return iad;
                }
                VectorStep a = this.getAcceleration(n, panelID);
                if (a != null && this.isStepVisible(a, panel) && (iad = ((Step)a).findInteractive(panel, xpix, ypix)) != null) {
                    this.partName = TrackerRes.getString("PointMass.Acceleration.Name");
                    this.hint = TrackerRes.getString("PointMass.Vector.Hint");
                    return iad;
                }
            }
        }
        Step selectedStep = panel.getSelectedStep();
        if (selectedStep != null) {
            if (selectedStep instanceof PositionStep) {
                this.partName = TrackerRes.getString("PointMass.Position.Name");
                this.partName = String.valueOf(this.partName) + " " + TrackerRes.getString("TTrack.Selected.Hint");
                this.hint = TrackerRes.getString("PointMass.PositionSelected.Hint");
            } else if (selectedStep instanceof VectorStep) {
                this.partName = this.isVelocity(selectedStep) ? TrackerRes.getString("PointMass.Velocity.Name") : TrackerRes.getString("PointMass.Acceleration.Name");
                this.partName = String.valueOf(this.partName) + " " + TrackerRes.getString("TTrack.Selected.Hint");
                this.hint = TrackerRes.getString("PointMass.VectorSelected.Hint");
            }
        } else {
            this.partName = TrackerRes.getString("TTrack.Selected.Hint");
            this.hint = TrackerRes.getString("PointMass.Hint");
            this.hint = this.getStep(panel.getFrameNumber()) == null ? String.valueOf(this.hint) + TrackerRes.getString("PointMass.Unmarked.Hint") : String.valueOf(this.hint) + TrackerRes.getString("PointMass.Remark.Hint");
        }
        return null;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            Step[] stepArray = this.getSteps();
            int n = stepArray.length;
            int n2 = 0;
            while (n2 < n) {
                Step step = stepArray[n2];
                if (step != null && this.tp != null) {
                    this.tp.selectedSteps.remove(step);
                }
                ++n2;
            }
        }
        super.setVisible(visible);
    }

    @Override
    public boolean isStepVisible(Step step, TrackerPanel panel) {
        if (this.isPosition(step) && !this.isPositionVisible()) {
            return false;
        }
        if (this.isVelocity(step) && !this.isVVisible()) {
            return false;
        }
        if (this.isAcceleration(step) && !this.isAVisible()) {
            return false;
        }
        return super.isStepVisible(step, panel);
    }

    public void setVVisibleOnAll(boolean visible) {
        this.vVisibleOnAll = visible;
    }

    public void setVVisible(TrackerPanel panel, boolean visible) {
        Step step;
        if (visible == this.isVVisible()) {
            return;
        }
        this.vvis = visible;
        if (!visible && (step = panel.getSelectedStep()) != null && this.isVelocity(step)) {
            panel.setSelectedPoint(null);
            panel.selectedSteps.clear();
        }
    }

    public boolean isVVisible() {
        return this.vVisibleOnAll || this.vvis;
    }

    public void setPositionVisibleOnAll(boolean visible) {
        this.xVisibleOnAll = visible;
    }

    public void setTraceVisible(boolean visible) {
        this.traceVisible = visible;
    }

    public boolean isTraceVisible() {
        return this.traceVisible;
    }

    public boolean isPosition(Step step) {
        return step instanceof PositionStep;
    }

    public void setPositionVisible(TrackerPanel panel, boolean visible) {
        Step step;
        this.xvis = visible;
        if (!visible && (step = panel.getSelectedStep()) != null && step == this.getStep(step.getFrameNumber())) {
            panel.setSelectedPoint(null);
            panel.selectedSteps.clear();
        }
    }

    public boolean isPositionVisible() {
        return this.xVisibleOnAll || this.xvis;
    }

    public VectorStep getVelocity(int n, Integer panelID) {
        return (VectorStep)this.getVArray(panelID).getStep(n);
    }

    public Step[] getVelocities(Integer panelID) {
        return this.getVArray((Integer)panelID).array;
    }

    public boolean isVelocity(Step step) {
        return step.type == 1 && step.getTrack() == this;
    }

    public void setAVisibleOnAll(boolean visible) {
        this.aVisibleOnAll = visible;
    }

    public void setAVisible(TrackerPanel panel, boolean visible) {
        Step step;
        if (visible == this.isAVisible()) {
            return;
        }
        this.avis = visible;
        if (!visible && (step = panel.getSelectedStep()) != null && this.isAcceleration(step)) {
            panel.setSelectedPoint(null);
            panel.selectedSteps.clear();
        }
    }

    public boolean isAVisible() {
        if (this.aVisibleOnAll) {
            return true;
        }
        return this.avis;
    }

    public VectorStep getAcceleration(int n, Integer panelID) {
        return (VectorStep)this.getAArray(panelID).getStep(n);
    }

    public Step[] getAccelerations(Integer panelID) {
        return this.getAArray((Integer)panelID).array;
    }

    public boolean isAcceleration(Step step) {
        return step.type == 2 && step.getTrack() == this;
    }

    public void setLabelsVisible(TrackerPanel panel, boolean visible) {
        Step step;
        this.labelsVisible = visible;
        Integer panelID = panel.getID();
        Step[] steps = this.getSteps();
        int i = 0;
        while (i < steps.length) {
            step = (PositionStep)steps[i];
            if (step != null) {
                ((PositionStep)step).setLabelVisible(visible);
                ((PositionStep)step).setRolloverVisible(!visible);
            }
            ++i;
        }
        steps = this.getVelocities(panelID);
        i = 0;
        while (i < steps.length) {
            step = (VectorStep)steps[i];
            if (step != null) {
                ((VectorStep)step).setLabelVisible(visible);
                ((VectorStep)step).setRolloverVisible(!visible);
            }
            ++i;
        }
        steps = this.getAccelerations(panelID);
        i = 0;
        while (i < steps.length) {
            step = (VectorStep)steps[i];
            if (step != null) {
                ((VectorStep)step).setLabelVisible(visible);
                ((VectorStep)step).setRolloverVisible(!visible);
            }
            ++i;
        }
        int j = 0;
        while (j < this.tp.andWorld.size()) {
            WorldTView.WorldPanel view;
            TrackerPanel next = this.panel(this.tp.andWorld.get(j));
            if (next.isWorldPanel() && (view = (WorldTView.WorldPanel)next).getMainPanel() == panel) {
                this.setLabelsVisible(view, visible);
            }
            ++j;
        }
    }

    public boolean isLabelsVisible(TrackerPanel panel) {
        Step[] steps = this.getSteps();
        int i = 0;
        while (i < steps.length) {
            PositionStep step = (PositionStep)steps[i];
            if (step != null) {
                return step.isLabelVisible();
            }
            ++i;
        }
        return false;
    }

    @Override
    protected NumberField[] getNumberFieldsForStep(Step step) {
        String var;
        NumberField[] fields;
        boolean xMass = this.tp.getToolBar((boolean)true).xMassButton.isSelected();
        if (this.isVelocity(step)) {
            fields = xMass ? this.vectorFields[2] : this.vectorFields[0];
            var = xMass ? formatVariables[5] : formatVariables[3];
        } else if (this.isAcceleration(step)) {
            fields = xMass ? this.vectorFields[3] : this.vectorFields[1];
            var = xMass ? formatVariables[6] : formatVariables[4];
        } else {
            fields = super.getNumberFieldsForStep(step);
            var = formatVariables[2];
        }
        int i = 0;
        while (i < 3) {
            fields[i].setUnits(this.tp.getUnits(this, var));
            ++i;
        }
        return fields;
    }

    @Override
    protected void setAnglesInRadians(boolean radians) {
        super.setAnglesInRadians(radians);
        int i = 0;
        while (i < 4) {
            this.vectorFields[i][3].setUnits(radians ? null : "\u00b0");
            ((DecimalField)this.vectorFields[i][3]).setDecimalPlaces(radians ? 3 : 1);
            this.vectorFields[i][3].setConversionFactor(radians ? 1.0 : 57.29577951308232);
            this.vectorFields[i][3].setToolTipText(radians ? TrackerRes.getString("TTrack.AngleField.Radians.Tooltip") : TrackerRes.getString("TTrack.AngleField.Degrees.Tooltip"));
            ++i;
        }
    }

    protected void updateDerivatives() {
        if (this.isEmpty() || this.refreshDataLater) {
            return;
        }
        int i = this.tList.size();
        while (--i >= 0) {
            TrackerPanel tp = this.panel(this.tList.get(i));
            this.updatePanelDerivatives(tp);
        }
    }

    protected void updateDerivatives(int startFrame, int stepCount) {
        if (this.isEmpty() || this.refreshDataLater) {
            return;
        }
        if (Tracker.timeLogEnabled) {
            Tracker.logTime(String.valueOf(this.getClass().getSimpleName()) + this.hashCode() + " update derivatives " + startFrame + " steps " + stepCount);
        }
        int i = this.tList.size();
        while (--i >= 0) {
            TrackerPanel tp = this.panel(this.tList.get(i));
            this.updateDerivatives(tp, startFrame, stepCount);
        }
    }

    protected void updateDerivatives(int frameNumber) {
        if (this.isEmpty() || this.refreshDataLater) {
            return;
        }
        int i = this.tList.size();
        while (--i >= 0) {
            TrackerPanel tp = this.panel(this.tList.get(i));
            this.updateDerivatives(tp, frameNumber);
        }
    }

    protected void updateDerivatives(TrackerPanel panel, int frameNumber) {
        VideoClip clip = panel.getPlayer().getVideoClip();
        int startFrame = Math.max(frameNumber - 2 * clip.getStepSize(), clip.getStartFrameNumber());
        this.updateDerivatives(panel, startFrame, 5);
    }

    private void updatePanelDerivatives(TrackerPanel panel) {
        if (this.refreshDataLater) {
            return;
        }
        VideoClip clip = panel.getPlayer().getVideoClip();
        this.updateDerivatives(panel, clip.getStartFrameNumber(), clip.getStepCount());
    }

    protected void updateDerivatives(TrackerPanel panel, int startFrame, int stepCount) {
        PositionStep.Position p;
        double y;
        double x;
        double[] yDeriv2;
        double[] xDeriv2;
        double[] yDeriv1;
        double[] xDeriv1;
        Object[] result;
        if (panel.isWorldPanel() && !((WorldTView.WorldPanel)panel).isActive()) {
            return;
        }
        VideoClip clip = panel.getPlayer().getVideoClip();
        if (this.derivData[2] == null) {
            this.derivData[2] = this.yData;
        }
        if (this.xData.length < this.steps.array.length) {
            this.xData = new double[this.steps.array.length + 5];
            this.derivData[1] = this.xData;
            this.yData = new double[this.steps.array.length + 5];
            this.derivData[2] = this.yData;
            this.validData = new boolean[this.steps.array.length + 5];
            this.derivData[3] = this.validData;
        }
        this.params[1] = startFrame;
        this.params[2] = clip.getStepSize();
        this.params[3] = stepCount;
        int i = 0;
        while (i < this.validData.length) {
            this.validData[i] = false;
            ++i;
        }
        Step[] stepArray = this.steps.array;
        int n = 0;
        while (n < stepArray.length) {
            if (stepArray[n] != null && clip.includesFrame(n)) {
                PositionStep step = (PositionStep)stepArray[n];
                Point2D p2 = step.getPosition().getWorldPosition(panel);
                this.xData[n] = p2.getX();
                this.yData[n] = p2.getY();
                this.validData[n] = true;
            }
            ++n;
        }
        boolean isLocked = this.locked;
        this.locked = false;
        boolean labelsVisible = this.isLabelsVisible(panel);
        if (this.algorithm == 1) {
            this.params[0] = this.bounceDerivsSpill;
            result = bounceDerivs.evaluate(this.derivData);
            xDeriv1 = (double[])result[0];
            yDeriv1 = (double[])result[1];
            xDeriv2 = (double[])result[2];
            yDeriv2 = (double[])result[3];
        } else {
            this.params[0] = this.algorithm == 2 ? 2 : this.vDerivSpill;
            result = vDeriv.evaluate(this.derivData);
            xDeriv1 = (double[])result[0];
            yDeriv1 = (double[])result[1];
            this.params[0] = this.aDerivSpill;
            result = aDeriv.evaluate(this.derivData);
            xDeriv2 = (double[])result[2];
            yDeriv2 = (double[])result[3];
        }
        TTrack.StepArray array = this.panelVMap.get(panel.getID());
        int endFrame = startFrame + (stepCount - 1) * clip.getStepSize();
        int end = Math.min(endFrame, xDeriv1.length - 1);
        int n2 = startFrame;
        while (n2 <= end) {
            VectorStep v = (VectorStep)array.getStep(n2);
            if (!Double.isNaN(xDeriv1[n2]) && this.validData[n2] || v != null) {
                if (!Double.isNaN(xDeriv1[n2]) && this.validData[n2]) {
                    x = panel.getCoords().worldToImageXComponent(n2, xDeriv1[n2], yDeriv1[n2]);
                    y = panel.getCoords().worldToImageYComponent(n2, xDeriv1[n2], yDeriv1[n2]);
                    if (v == null) {
                        p = ((PositionStep)this.getStep(n2)).getPosition();
                        v = new VectorStep(this, n2, p.getX(), p.getY(), x, y, 1);
                        v.setTipEnabled(false);
                        v.getHandle().setStepEditTrigger(true);
                        v.setDefaultPointIndex(2);
                        v.setFootprint(this.vFootprint);
                        v.setLabelVisible(labelsVisible);
                        v.setRolloverVisible(!labelsVisible);
                        v.attach(p);
                        array.setStep(n2, v);
                        panel.addDirtyRegion(null);
                    } else if ((int)(100.0 * v.getXComponent()) != (int)(100.0 * x) || (int)(100.0 * v.getYComponent()) != (int)(100.0 * y)) {
                        panel.addDirtyRegion(null);
                        v.attach(v.getAttachmentPoint());
                        v.setXYComponents(x, y);
                        panel.addDirtyRegion(null);
                    } else {
                        v.attach(v.getAttachmentPoint());
                    }
                } else {
                    array.setStep(n2, null);
                    panel.addDirtyRegion(null);
                }
            }
            ++n2;
        }
        array = this.panelAMap.get(panel.getID());
        end = Math.min(endFrame, xDeriv2.length - 1);
        n2 = startFrame;
        while (n2 <= end) {
            VectorStep a = (VectorStep)array.getStep(n2);
            if (!Double.isNaN(xDeriv2[n2]) && this.validData[n2] || a != null) {
                if (!Double.isNaN(xDeriv2[n2]) && this.validData[n2]) {
                    x = panel.getCoords().worldToImageXComponent(n2, xDeriv2[n2], yDeriv2[n2]);
                    y = panel.getCoords().worldToImageYComponent(n2, xDeriv2[n2], yDeriv2[n2]);
                    if (a == null) {
                        p = ((PositionStep)this.getStep(n2)).getPosition();
                        a = new VectorStep(this, n2, p.getX(), p.getY(), x, y, 2);
                        a.getHandle().setStepEditTrigger(true);
                        a.setTipEnabled(false);
                        a.setDefaultPointIndex(2);
                        a.setFootprint(this.aFootprint);
                        a.setLabelVisible(labelsVisible);
                        a.setRolloverVisible(!labelsVisible);
                        a.attach(p);
                        array.setStep(n2, a);
                        panel.addDirtyRegion(null);
                    } else if ((int)(100.0 * a.getXComponent()) != (int)(100.0 * x) || (int)(100.0 * a.getYComponent()) != (int)(100.0 * y)) {
                        panel.addDirtyRegion(null);
                        a.attach(a.getAttachmentPoint());
                        a.setXYComponents(x, y);
                        panel.addDirtyRegion(null);
                    } else {
                        a.attach(a.getAttachmentPoint());
                    }
                } else {
                    array.setStep(n2, null);
                    panel.addDirtyRegion(null);
                }
            }
            ++n2;
        }
        this.locked = isLocked;
        panel.repaintDirtyRegion();
    }

    protected Object[] getRotationData() {
        this.derivData[2] = null;
        if (this.xData.length < this.steps.array.length) {
            this.xData = new double[this.steps.array.length + 5];
            this.derivData[1] = this.xData;
            this.yData = new double[this.steps.array.length + 5];
            this.validData = new boolean[this.steps.array.length + 5];
            this.derivData[3] = this.validData;
        }
        int i = 0;
        while (i < this.steps.array.length) {
            this.validData[i] = false;
            ++i;
        }
        VideoClip clip = this.tp.getPlayer().getVideoClip();
        this.params[1] = clip.getStartFrameNumber();
        this.params[2] = clip.getStepSize();
        this.params[3] = clip.getStepCount();
        Step[] stepArray = this.steps.array;
        double rotation = 0.0;
        double prevAngle = 0.0;
        int n = 0;
        while (n < stepArray.length) {
            if (stepArray[n] != null && clip.includesFrame(n)) {
                PositionStep step = (PositionStep)stepArray[n];
                Point2D p = step.getPosition().getWorldPosition(this.tp);
                double angle = Math.atan2(p.getY(), p.getX());
                double delta = angle - prevAngle;
                if (delta < -Math.PI) {
                    delta += Math.PI * 2;
                } else if (delta > Math.PI) {
                    delta -= Math.PI * 2;
                }
                prevAngle = angle;
                this.xData[n] = rotation += delta;
                this.validData[n] = true;
            } else {
                this.xData[n] = Double.NaN;
            }
            ++n;
        }
        boolean isLocked = this.locked;
        this.locked = false;
        this.params[0] = this.vDerivSpill;
        Object[] result = vDeriv.evaluate(this.derivData);
        double[] omega = (double[])result[0];
        this.params[0] = this.aDerivSpill;
        result = aDeriv.evaluate(this.derivData);
        double[] alpha = (double[])result[2];
        this.locked = isLocked;
        return new Object[]{this.xData, omega, alpha};
    }

    protected Object[] getRotationData(int startFrame, int stepCount) {
        if (this.xData.length < this.steps.array.length) {
            this.xData = new double[this.steps.array.length + 5];
            this.derivData[1] = this.xData;
            this.yData = new double[this.steps.array.length + 5];
            this.derivData[2] = this.yData;
            this.validData = new boolean[this.steps.array.length + 5];
            this.derivData[3] = this.validData;
        }
        int i = 0;
        while (i < this.steps.array.length) {
            this.validData[i] = false;
            ++i;
        }
        VideoClip clip = this.tp.getPlayer().getVideoClip();
        this.params[1] = startFrame;
        this.params[2] = clip.getStepSize();
        this.params[3] = stepCount;
        Step[] stepArray = this.steps.array;
        double rotation = 0.0;
        double prevAngle = 0.0;
        int n = 0;
        while (n < stepArray.length) {
            if (stepArray[n] != null && clip.includesFrame(n)) {
                PositionStep step = (PositionStep)stepArray[n];
                Point2D p = step.getPosition().getWorldPosition(this.tp);
                double angle = Math.atan2(p.getY(), p.getX());
                double delta = angle - prevAngle;
                if (delta < -Math.PI) {
                    delta += Math.PI * 2;
                } else if (delta > Math.PI) {
                    delta -= Math.PI * 2;
                }
                prevAngle = angle;
                this.xData[n] = rotation += delta;
                this.validData[n] = true;
            } else {
                this.xData[n] = Double.NaN;
            }
            ++n;
        }
        boolean isLocked = this.locked;
        this.locked = false;
        this.params[0] = this.vDerivSpill;
        Object[] result = vDeriv.evaluate(this.derivData);
        double[] omega = (double[])result[0];
        boolean[] validDeriv = (boolean[])result[2];
        int i2 = 0;
        while (i2 < omega.length) {
            if (!validDeriv[i2]) {
                omega[i2] = Double.NaN;
            }
            ++i2;
        }
        this.params[0] = this.aDerivSpill;
        result = aDeriv.evaluate(this.derivData);
        double[] alpha = (double[])result[2];
        this.locked = isLocked;
        return new Object[]{this.xData, omega, alpha};
    }

    @Override
    public void erase() {
        if (this.tp == null) {
            return;
        }
        super.erase();
        int j = 0;
        while (j < this.tp.andWorld.size()) {
            Integer panelID = this.tp.andWorld.get(j);
            if (this.panelVMap.get(panelID) != null) {
                Step[] stepArray = this.getVelocities(panelID);
                int i = 0;
                while (i < stepArray.length) {
                    if (stepArray[i] != null) {
                        stepArray[i].erase(panelID);
                    }
                    ++i;
                }
                stepArray = this.getAccelerations(panelID);
                i = 0;
                while (i < stepArray.length) {
                    if (stepArray[i] != null) {
                        stepArray[i].erase(panelID);
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    @Override
    public void remark() {
        super.remark();
        int j = 0;
        while (j < this.tp.andWorld.size()) {
            Integer panelID = this.tp.andWorld.get(j);
            Step[] stepArray = this.getVelocities(panelID);
            int i = 0;
            while (i < stepArray.length) {
                if (stepArray[i] != null) {
                    stepArray[i].remark(panelID);
                }
                ++i;
            }
            stepArray = this.getAccelerations(panelID);
            i = 0;
            while (i < stepArray.length) {
                if (stepArray[i] != null) {
                    stepArray[i].remark(panelID);
                }
                ++i;
            }
            ++j;
        }
    }

    @Override
    public void erase(Integer panelID) {
        super.erase(panelID);
        Step[] stepArray = this.getVelocities(panelID);
        int i = 0;
        while (i < stepArray.length) {
            if (stepArray[i] != null) {
                stepArray[i].erase(panelID);
            }
            ++i;
        }
        stepArray = this.getAccelerations(panelID);
        int j = 0;
        while (j < stepArray.length) {
            if (stepArray[j] != null) {
                stepArray[j].erase(panelID);
            }
            ++j;
        }
    }

    @Override
    public void remark(Integer panelID) {
        super.remark(panelID);
        Step[] stepArray = this.getVelocities(panelID);
        int i = 0;
        while (i < stepArray.length) {
            if (stepArray[i] != null) {
                stepArray[i].remark(panelID);
            }
            ++i;
        }
        stepArray = this.getAccelerations(panelID);
        int j = 0;
        while (j < stepArray.length) {
            if (stepArray[j] != null) {
                stepArray[j].remark(panelID);
            }
            ++j;
        }
    }

    @Override
    public void setTrackerPanel(TrackerPanel panel) {
        if (this.tp != null) {
            this.tp.removePropertyChangeListener("stepsize", this);
        }
        super.setTrackerPanel(panel);
        if (this.tp != null) {
            this.tp.addPropertyChangeListener("stepsize", this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        block16: {
            if (!(e.getSource() instanceof TrackerPanel)) break block16;
            switch (e.getPropertyName()) {
                case "coords": {
                    this.invalidateData(Boolean.FALSE);
                    this.updateDerivatives();
                    break;
                }
                case "transform": {
                    this.invalidateData(Boolean.FALSE);
                    break;
                }
                case "stepsize": {
                    JDialog warning;
                    this.updateDerivatives();
                    this.invalidateData(null);
                    int stepSize = this.tp.getPlayer().getVideoClip().getStepSize();
                    if (!Tracker.warnSkippedStep || this.stepSizeWhenFirstMarked <= 1 || stepSize == this.stepSizeWhenFirstMarked || (warning = this.getStepSizeWarningDialog()) == null) break;
                    warning.setVisible(true);
                    break;
                }
                case "adjusting": {
                    this.refreshDataLater = (Boolean)e.getNewValue();
                    if (this.refreshDataLater) break;
                    this.updateDerivatives();
                    this.fireDataButDontInvalidateIt();
                }
            }
            super.propertyChange(e);
        }
    }

    private void fireDataButDontInvalidateIt() {
        this.firePropertyChange("data", null, null);
    }

    @Override
    public JMenu getMenu(TrackerPanel panel, JMenu menu0) {
        JMenuItem item;
        JMenu menu = super.getMenu(panel, menu0);
        if (menu0 == null) {
            return menu;
        }
        this.createMenuIfNecessary();
        this.removeDeleteTrackItem(menu);
        this.vFootprintMenu.setText(TrackerRes.getString("TTrack.MenuItem.Footprint"));
        this.aFootprintMenu.setText(TrackerRes.getString("TTrack.MenuItem.Footprint"));
        this.vFootprintMenu.removeAll();
        ActionListener vFootprintListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String footprintName = e.getActionCommand();
                if (PointMass.this.getVelocityFootprint().getName().equals(footprintName)) {
                    return;
                }
                XMLControlElement control = new XMLControlElement(PointMass.this);
                PointMass.this.setVelocityFootprint(footprintName);
                Undo.postTrackEdit(PointMass.this, control);
            }
        };
        Footprint[] fp = this.getVelocityFootprints();
        int i = 0;
        while (i < fp.length) {
            BasicStroke stroke = fp[i].getStroke();
            fp[i].setStroke(new BasicStroke(stroke.getLineWidth(), 0, 0, 8.0f, null, 0.0f));
            item = new JMenuItem(fp[i].getDisplayName(), fp[i].getIcon(21, 16));
            if (fp[i] == this.vFootprint) {
                item.setBorder(BorderFactory.createLineBorder(item.getBackground().darker()));
            }
            item.setActionCommand(fp[i].getName());
            item.addActionListener(vFootprintListener);
            this.vFootprintMenu.add(item);
            fp[i].setStroke(stroke);
            ++i;
        }
        this.aFootprintMenu.removeAll();
        ActionListener aFootprintListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String footprintName = e.getActionCommand();
                if (PointMass.this.getAccelerationFootprint().getName().equals(footprintName)) {
                    return;
                }
                XMLControlElement control = new XMLControlElement(PointMass.this);
                PointMass.this.setAccelerationFootprint(footprintName);
                Undo.postTrackEdit(PointMass.this, control);
            }
        };
        fp = this.getAccelerationFootprints();
        int i2 = 0;
        while (i2 < fp.length) {
            BasicStroke stroke = fp[i2].getStroke();
            fp[i2].setStroke(new BasicStroke(stroke.getLineWidth(), 0, 0, 8.0f, null, 0.0f));
            item = new JMenuItem(fp[i2].getDisplayName(), fp[i2].getIcon(21, 16));
            if (fp[i2] == this.aFootprint) {
                item.setBorder(BorderFactory.createLineBorder(item.getBackground().darker()));
            }
            item.setActionCommand(fp[i2].getName());
            item.addActionListener(aFootprintListener);
            this.aFootprintMenu.add(item);
            fp[i2].setStroke(stroke);
            ++i2;
        }
        if (panel.isEnabled("track.autotrack")) {
            this.autotrackItem.setText(TrackerRes.getString("PointMass.MenuItem.Autotrack"));
            this.autotrackItem.setEnabled(panel.getVideo() != null);
            boolean added = false;
            int i3 = 0;
            while (i3 < menu.getItemCount()) {
                JMenuItem next = menu.getItem(i3);
                if (next == this.dataBuilderItem) {
                    menu.insert(this.autotrackItem, i3);
                    added = true;
                }
                ++i3;
            }
            if (!added) {
                menu.add(this.autotrackItem);
            }
        }
        if (panel.isEnabled("track.autoAdvance") || panel.isEnabled("track.markByDefault")) {
            TMenuBar.checkAddMenuSep(menu);
            if (panel.isEnabled("track.autoAdvance")) {
                menu.add(this.autoAdvanceItem);
            }
            if (panel.isEnabled("track.markByDefault")) {
                menu.add(this.markByDefaultItem);
            }
        }
        TMenuBar.checkAddMenuSep(menu);
        this.velocityMenu.setText(TrackerRes.getString("PointMass.MenuItem.Velocity"));
        this.accelerationMenu.setText(TrackerRes.getString("PointMass.MenuItem.Acceleration"));
        this.vColorItem.setText(TrackerRes.getString("TTrack.MenuItem.Color"));
        this.aColorItem.setText(TrackerRes.getString("TTrack.MenuItem.Color"));
        this.vTailsToOriginItem.setText(TrackerRes.getString("Vector.MenuItem.ToOrigin"));
        this.aTailsToOriginItem.setText(TrackerRes.getString("Vector.MenuItem.ToOrigin"));
        this.vTailsToPositionItem.setText(TrackerRes.getString("PointMass.MenuItem.VectorsToPosition"));
        this.aTailsToPositionItem.setText(TrackerRes.getString("PointMass.MenuItem.VectorsToPosition"));
        this.vVisibleItem.setText(TrackerRes.getString("TTrack.MenuItem.Visible"));
        this.aVisibleItem.setText(TrackerRes.getString("TTrack.MenuItem.Visible"));
        menu.add(this.velocityMenu);
        menu.add(this.accelerationMenu);
        if (panel.isEnabled("track.delete")) {
            TMenuBar.checkAddMenuSep(menu);
            menu.add(this.deleteStepItem);
            menu.add(this.clearStepsItem);
            menu.add(this.deleteTrackItem);
        }
        return menu;
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel panel) {
        ArrayList<Component> list = super.getToolbarTrackComponents(panel);
        list.add(this.massLabel);
        this.massField.setEnabled(!this.isLocked());
        this.massField.setValue(this.getMass());
        this.massField.setUnits(panel.getUnits(this, dataVariables[26]));
        list.add(this.massField);
        list.add(this.mSeparator);
        return list;
    }

    @Override
    public ArrayList<Component> getToolbarPointComponents(TrackerPanel panel, TPoint point) {
        NumberField[] fields;
        ArrayList<Component> list;
        block8: {
            block6: {
                boolean xMass;
                Step step;
                block7: {
                    step = this.getStep(point, panel);
                    list = super.getToolbarPointComponents(panel, point);
                    if (step == null) {
                        return list;
                    }
                    int n = step.getFrameNumber();
                    n = panel.getPlayer().getVideoClip().frameToStep(n);
                    fields = this.getNumberFieldsForStep(step);
                    if (!(step instanceof VectorStep)) break block6;
                    xMass = panel.getToolBar((boolean)true).xMassButton.isSelected();
                    if (!this.isVelocity(step)) break block7;
                    if (xMass) {
                        this.xLabel.setText(dataVariables[18]);
                        this.yLabel.setText(dataVariables[19]);
                        this.magLabel.setText(dataVariables[20]);
                        this.angleLabel.setText(dataVariables[21]);
                    } else {
                        this.xLabel.setText(dataVariables[5]);
                        this.yLabel.setText(dataVariables[6]);
                        this.magLabel.setText(dataVariables[7]);
                        this.angleLabel.setText(dataVariables[8]);
                    }
                    break block8;
                }
                if (!this.isAcceleration(step)) break block8;
                if (xMass) {
                    this.xLabel.setText(fieldVariables[18]);
                    this.yLabel.setText(fieldVariables[19]);
                    this.magLabel.setText(fieldVariables[20]);
                    this.angleLabel.setText(fieldVariables[21]);
                } else {
                    this.xLabel.setText(dataVariables[9]);
                    this.yLabel.setText(dataVariables[10]);
                    this.magLabel.setText(dataVariables[11]);
                    this.angleLabel.setText(dataVariables[12]);
                }
                break block8;
            }
            this.xLabel.setText(dataVariables[1]);
            this.yLabel.setText(dataVariables[2]);
            this.magLabel.setText(dataVariables[3]);
            this.angleLabel.setText(dataVariables[4]);
            NumberField[] numberFieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                NumberField f = numberFieldArray[n2];
                f.setEnabled(!this.isLocked());
                ++n2;
            }
        }
        list.add(this.stepLabel);
        list.add(this.stepValueLabel);
        list.add(this.tSeparator);
        list.add(this.xLabel);
        list.add(fields[0]);
        list.add(this.xSeparator);
        list.add(this.yLabel);
        list.add(fields[1]);
        list.add(this.ySeparator);
        list.add(this.magLabel);
        list.add(fields[2]);
        list.add(this.magSeparator);
        list.add(this.angleLabel);
        list.add(fields[3]);
        list.add(this.angleSeparator);
        return list;
    }

    @Override
    public Map<String, NumberField[]> getNumberFields() {
        if (this.numberFields.isEmpty()) {
            this.numberFields.put(fieldVariables[0], new NumberField[]{this.massField});
            this.numberFields.put(fieldVariables[1], new NumberField[]{this.tField});
            this.numberFields.put(fieldVariables[2], new NumberField[]{this.xField});
            this.numberFields.put(fieldVariables[3], new NumberField[]{this.yField});
            this.numberFields.put(fieldVariables[4], new NumberField[]{this.magField});
            this.numberFields.put(fieldVariables[5], new NumberField[]{this.angleField});
            this.numberFields.put(fieldVariables[6], new NumberField[]{this.vectorFields[0][0]});
            this.numberFields.put(fieldVariables[7], new NumberField[]{this.vectorFields[0][1]});
            this.numberFields.put(fieldVariables[8], new NumberField[]{this.vectorFields[0][2]});
            this.numberFields.put(fieldVariables[9], new NumberField[]{this.vectorFields[0][3]});
            this.numberFields.put(fieldVariables[10], new NumberField[]{this.vectorFields[1][0]});
            this.numberFields.put(fieldVariables[11], new NumberField[]{this.vectorFields[1][1]});
            this.numberFields.put(fieldVariables[12], new NumberField[]{this.vectorFields[1][2]});
            this.numberFields.put(fieldVariables[13], new NumberField[]{this.vectorFields[1][3]});
            this.numberFields.put(fieldVariables[14], new NumberField[]{this.vectorFields[2][0]});
            this.numberFields.put(fieldVariables[15], new NumberField[]{this.vectorFields[2][1]});
            this.numberFields.put(fieldVariables[16], new NumberField[]{this.vectorFields[2][2]});
            this.numberFields.put(fieldVariables[17], new NumberField[]{this.vectorFields[2][3]});
            this.numberFields.put(fieldVariables[18], new NumberField[]{this.vectorFields[3][0]});
            this.numberFields.put(fieldVariables[19], new NumberField[]{this.vectorFields[3][1]});
            this.numberFields.put(fieldVariables[20], new NumberField[]{this.vectorFields[3][2]});
            this.numberFields.put(fieldVariables[21], new NumberField[]{this.vectorFields[3][3]});
        }
        return this.numberFields;
    }

    public static XML.ObjectLoader getLoader() {
        XML.setLoader(FrameData.class, new FrameDataLoader());
        return new Loader();
    }

    protected void createGUI() {
        this.massLabel = new JLabel(dataVariables[26]);
        this.massLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
        this.massField = new TTrack.TrackNumberField(this);
        this.massField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String rawText = PointMass.this.massField.getText();
                PointMass.this.setMass(PointMass.this.massField.getValue());
                PointMass.this.checkMassUnits(rawText);
                PointMass.this.massField.setValue(PointMass.this.getMass());
                PointMass.this.massField.requestFocusInWindow();
            }
        });
        this.massField.addMouseListener(this.formatMouseListener);
        this.massField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (PointMass.this.massField.getBackground().equals(Color.yellow)) {
                    String rawText = PointMass.this.massField.getText();
                    PointMass.this.setMass(PointMass.this.massField.getValue());
                    PointMass.this.checkMassUnits(rawText);
                    PointMass.this.massField.setValue(PointMass.this.getMass());
                }
            }
        });
        this.massField.setMinValue(1.0E-30);
        this.massField.setBorder(this.xField.getBorder());
        ChangeListener xyListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PointMass.this.setXY();
            }
        };
        this.vectorFields = new NumberField[4][4];
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 3) {
                this.vectorFields[i][j] = new TTrack.TrackNumberField(this);
                this.vectorFields[i][j].setEditable(false);
                this.vectorFields[i][j].setBorder(this.fieldBorder);
                this.vectorFields[i][j].addMouseListener(this.formatMouseListener);
                ++j;
            }
            this.vectorFields[i][3] = new TTrack.TrackDecimalField(this, 1);
            this.vectorFields[i][3].addMouseListener(this.formatAngleMouseListener);
            this.vectorFields[i][3].setEditable(false);
            this.vectorFields[i][3].setBorder(this.fieldBorder);
            ++i;
        }
        this.xSpinner.addChangeListener(xyListener);
        AbstractAction xyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PointMass.this.setXY();
                ((NumberField)e.getSource()).requestFocusInWindow();
            }
        };
        FocusAdapter xyFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PointMass.this.setXY();
            }
        };
        AbstractAction magAngleAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PointMass.this.setMagAngle();
                ((NumberField)e.getSource()).requestFocusInWindow();
            }
        };
        FocusAdapter magAngleFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PointMass.this.setMagAngle();
            }
        };
        this.xField.addActionListener(xyAction);
        this.yField.addActionListener(xyAction);
        this.xField.addFocusListener(xyFocusListener);
        this.yField.addFocusListener(xyFocusListener);
        this.magField.addActionListener(magAngleAction);
        this.angleField.addActionListener(magAngleAction);
        this.magField.addFocusListener(magAngleFocusListener);
        this.angleField.addFocusListener(magAngleFocusListener);
        this.mSeparator = Box.createRigidArea(new Dimension(4, 4));
    }

    protected void createMenuIfNecessary() {
        if (this.vFootprintMenu != null) {
            return;
        }
        this.autotrackItem = new JMenuItem(TrackerRes.getString("PointMass.MenuItem.Autotrack"));
        this.autotrackItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoTracker autotracker = PointMass.this.tp.getAutoTracker(true);
                autotracker.setTrack(PointMass.this);
                autotracker.getWizard().setVisible(true);
                TFrame.repaintT(PointMass.this.tp);
            }
        });
        this.vFootprintMenu = new JMenu();
        this.aFootprintMenu = new JMenu();
        this.velocityMenu = new JMenu();
        this.accelerationMenu = new JMenu();
        this.vColorItem = new JMenuItem();
        this.vColorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = PointMass.this.getVelocityFootprint().getColor();
                OSPRuntime.chooseColor(c, TrackerRes.getString("Velocity.Dialog.Color.Title"), newColor -> {
                    if (newColor != null) {
                        XMLControlElement control = new XMLControlElement(PointMass.this);
                        Footprint[] footprintArray = PointMass.this.getVelocityFootprints();
                        int n = footprintArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Footprint footprint = footprintArray[n2];
                            footprint.setColor((Color)newColor);
                            ++n2;
                        }
                        Undo.postTrackEdit(PointMass.this, control);
                        PointMass.this.repaint();
                    }
                });
            }
        });
        this.aColorItem = new JMenuItem();
        this.aColorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = PointMass.this.getAccelerationFootprint().getColor();
                OSPRuntime.chooseColor(c, TrackerRes.getString("Acceleration.Dialog.Color.Title"), newColor -> {
                    if (newColor != null) {
                        XMLControlElement control = new XMLControlElement(PointMass.this);
                        Footprint[] footprintArray = PointMass.this.getAccelerationFootprints();
                        int n = footprintArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Footprint footprint = footprintArray[n2];
                            footprint.setColor((Color)newColor);
                            ++n2;
                        }
                        Undo.postTrackEdit(PointMass.this, control);
                        PointMass.this.repaint();
                    }
                });
            }
        });
        this.vTailsToOriginItem = new JMenuItem();
        this.aTailsToOriginItem = new JMenuItem();
        this.vTailsToPositionItem = new JMenuItem();
        this.aTailsToPositionItem = new JMenuItem();
        this.vVisibleItem = new JCheckBoxMenuItem();
        this.aVisibleItem = new JCheckBoxMenuItem();
        this.velocityMenu.add(this.vColorItem);
        this.velocityMenu.add(this.vFootprintMenu);
        this.velocityMenu.addSeparator();
        this.velocityMenu.add(this.vTailsToOriginItem);
        this.velocityMenu.add(this.vTailsToPositionItem);
        this.accelerationMenu.add(this.aColorItem);
        this.accelerationMenu.add(this.aFootprintMenu);
        this.accelerationMenu.addSeparator();
        this.accelerationMenu.add(this.aTailsToOriginItem);
        this.accelerationMenu.add(this.aTailsToPositionItem);
        this.vVisibleItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int j = 0;
                while (j < PointMass.this.tp.andWorld.size()) {
                    TrackerPanel panel = PointMass.this.panel(PointMass.this.tp.andWorld.get(j));
                    PointMass.this.setVVisible(panel, PointMass.this.vVisibleItem.isSelected());
                    panel.repaint();
                    ++j;
                }
            }
        });
        this.aVisibleItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int j = 0;
                while (j < PointMass.this.tp.andWorld.size()) {
                    TrackerPanel panel = PointMass.this.panel(PointMass.this.tp.andWorld.get(j));
                    PointMass.this.setAVisible(panel, PointMass.this.aVisibleItem.isSelected());
                    panel.repaint();
                    ++j;
                }
            }
        });
        this.vTailsToOriginItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PointMass.this.snapToOrigin("v");
            }
        });
        this.aTailsToOriginItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PointMass.this.snapToOrigin("a");
            }
        });
        this.vTailsToPositionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PointMass.this.snapToPosition("v");
            }
        });
        this.aTailsToPositionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PointMass.this.snapToPosition("a");
            }
        });
    }

    protected TTrack.StepArray getVArray(Integer panelID) {
        TTrack.StepArray v = this.panelVMap.get(panelID);
        return v == null ? this.createMaps(panelID, 1) : v;
    }

    protected TTrack.StepArray getAArray(Integer panelID) {
        TTrack.StepArray a = this.panelAMap.get(panelID);
        return a == null ? this.createMaps(panelID, 2) : a;
    }

    private TTrack.StepArray createMaps(Integer panelID, int retType) {
        this.tList.add(panelID);
        TTrack.StepArray v = new TTrack.StepArray(this);
        this.panelVMap.put(panelID, v);
        TTrack.StepArray a = new TTrack.StepArray(this);
        this.panelAMap.put(panelID, a);
        this.updatePanelDerivatives(this.panel(panelID));
        return retType == 1 ? v : a;
    }

    private void setXY() {
        double xValue = this.xField.getValue();
        double yValue = this.yField.getValue();
        TPoint p = this.tp.getSelectedPoint();
        Step step = this.getStep(p, this.tp);
        if (step != null) {
            ImageCoordSystem coords = this.tp.getCoords();
            double x = coords.worldToImageX(this.tp.getFrameNumber(), xValue, yValue);
            double y = coords.worldToImageY(this.tp.getFrameNumber(), xValue, yValue);
            p.setXY(x, y);
            Point2D worldPt = p.getWorldPosition(this.tp);
            this.xField.setValue(worldPt.getX());
            this.yField.setValue(worldPt.getY());
            this.magField.setValue(worldPt.distance(0.0, 0.0));
            double theta = Math.atan2(worldPt.getY(), worldPt.getX());
            this.angleField.setValue(theta);
            p.showCoordinates(this.tp);
        }
    }

    private void setMagAngle() {
        double theta = this.angleField.getValue();
        double xval = this.magField.getValue() * Math.cos(theta);
        double yval = this.magField.getValue() * Math.sin(theta);
        TPoint p = this.tp.getSelectedPoint();
        Step step = this.getStep(p, this.tp);
        if (step != null) {
            ImageCoordSystem coords = this.tp.getCoords();
            double x = coords.worldToImageX(this.tp.getFrameNumber(), xval, yval);
            double y = coords.worldToImageY(this.tp.getFrameNumber(), xval, yval);
            p.setXY(x, y);
            Point2D worldPt = p.getWorldPosition(this.tp);
            this.xField.setValue(worldPt.getX());
            this.yField.setValue(worldPt.getY());
            this.magField.setValue(worldPt.distance(0.0, 0.0));
            theta = Math.atan2(worldPt.getY(), worldPt.getX());
            this.angleField.setValue(theta);
            p.showCoordinates(this.tp);
        }
    }

    private void checkMassUnits(String rawText) {
        String[] split = rawText.split(" ");
        if (split.length > 1) {
            int i = 1;
            while (i < split.length) {
                if (!"".equals(split[i])) {
                    if (split[i].equals(this.tp.getMassUnit())) {
                        this.tp.setUnitsVisible(true);
                        break;
                    }
                    int response = JOptionPane.showConfirmDialog(this.tframe, String.valueOf(TrackerRes.getString("PointMass.Dialog.ChangeMassUnit.Message")) + " \"" + split[i] + "\" ?", TrackerRes.getString("PointMass.Dialog.ChangeMassUnit.Title"), 0);
                    if (response != 0) break;
                    this.tp.setMassUnit(split[i]);
                    this.tp.setUnitsVisible(true);
                    break;
                }
                ++i;
            }
        }
    }

    private void snapToOrigin(String type) {
        TPoint p = this.tp.getSnapPoint();
        Step[] steps = null;
        Integer panelID = this.tp.getID();
        steps = type.equals("v") ? this.getVelocities(panelID) : this.getAccelerations(panelID);
        int i = 0;
        while (i < steps.length) {
            if (steps[i] != null) {
                VectorStep a = (VectorStep)steps[i];
                if (a.chain != null) {
                    a.chain.clear();
                }
                a.attach(null);
                a.attach(p);
            }
            ++i;
        }
        this.repaintAll();
        if (type.equals("v")) {
            this.vAtOrigin = true;
        } else {
            this.aAtOrigin = true;
        }
    }

    private void snapToPosition(String type) {
        Step[] steps = null;
        Integer panelID = this.tp.getID();
        steps = type.equals("v") ? this.getVelocities(panelID) : this.getAccelerations(panelID);
        int i = 0;
        while (i < steps.length) {
            if (steps[i] != null) {
                VectorStep v = (VectorStep)steps[i];
                PositionStep p = (PositionStep)this.getStep(v.n);
                if (v.chain != null) {
                    v.chain.clear();
                }
                v.attach(null);
                v.attach(p.getPosition());
            }
            ++i;
        }
        this.repaintAll();
        if (type.equals("v")) {
            this.vAtOrigin = false;
        } else {
            this.aAtOrigin = false;
        }
    }

    public static class FrameData {
        double x;
        double y;

        FrameData() {
        }

        FrameData(PositionStep p) {
            this.x = p.getPosition().getX();
            this.y = p.getPosition().getY();
        }
    }

    private static class FrameDataLoader
    implements XML.ObjectLoader {
        private FrameDataLoader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            FrameData data = (FrameData)obj;
            control.setValue("x", data.x);
            control.setValue("y", data.y);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new FrameData();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            FrameData data = (FrameData)obj;
            data.x = control.getDouble("x");
            data.y = control.getDouble("y");
            return obj;
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            PointMass p = (PointMass)obj;
            control.setValue("mass", p.getMass());
            XML.getLoader(TTrack.class).saveObject(control, obj);
            Footprint fp = p.getVelocityFootprint();
            if (!fp.getColor().equals(p.getColor())) {
                control.setValue("velocity_color", fp.getColor());
            }
            if (!fp.getName().equals(p.getVelocityFootprints()[0].getName())) {
                control.setValue("velocity_footprint", fp.getName());
            }
            if (!(fp = p.getAccelerationFootprint()).getColor().equals(p.getColor())) {
                control.setValue("acceleration_color", fp.getColor());
            }
            if (!fp.getName().equals(p.getAccelerationFootprints()[0].getName())) {
                control.setValue("acceleration_footprint", fp.getName());
            }
            if (!p.isDependent()) {
                Step[] steps = p.getSteps();
                FrameData[] data = new FrameData[steps.length];
                int n = 0;
                while (n < steps.length) {
                    if (steps[n] != null) {
                        data[n] = new FrameData((PositionStep)steps[n]);
                    }
                    ++n;
                }
                control.setValue("framedata", data);
            }
            int[] keys = new int[p.keyFrames.size()];
            int i = 0;
            for (Integer n : p.keyFrames) {
                keys[i] = n;
                ++i;
            }
            control.setValue("keyFrames", keys);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new PointMass();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            Color c;
            PointMass p = (PointMass)obj;
            XML.getLoader(TTrack.class).loadObject(control, obj);
            boolean locked = p.isLocked();
            p.setLocked(false);
            double m = control.getDouble("mass");
            if (m != Double.NaN) {
                p.setMass(m);
            }
            if ((c = (Color)control.getObject("velocity_color")) != null) {
                p.setVelocityColor(c);
            } else {
                p.setVelocityColor(p.getColor());
            }
            String s = control.getString("velocity_footprint");
            if (s != null) {
                p.setVelocityFootprint(s);
            } else {
                p.setVelocityFootprint(p.getVelocityFootprints()[0].getName());
            }
            c = (Color)control.getObject("acceleration_color");
            if (c != null) {
                p.setAccelerationColor(c);
            } else {
                p.setAccelerationColor(p.getColor());
            }
            s = control.getString("acceleration_footprint");
            if (s != null) {
                p.setAccelerationFootprint(s);
            } else {
                p.setAccelerationFootprint(p.getAccelerationFootprints()[0].getName());
            }
            FrameData[] data = (FrameData[])control.getObject("framedata");
            if (data != null) {
                p.loading = true;
                int n = 0;
                while (n < data.length) {
                    if (data[n] == null) {
                        p.steps.setStep(n, null);
                    } else {
                        PositionStep step = (PositionStep)p.getStep(n);
                        if (step != null) {
                            step.getPosition().setLocation(data[n].x, data[n].y);
                            step.erase();
                        } else {
                            p.createStep(n, data[n].x, data[n].y);
                        }
                    }
                    ++n;
                }
                if (!p.isDependent()) {
                    Step[] steps = p.getSteps();
                    int n2 = data.length;
                    while (n2 < steps.length) {
                        p.steps.setStep(n2, null);
                        ++n2;
                    }
                }
                p.updateDerivatives();
                p.fireDataButDontInvalidateIt();
                p.loading = false;
            }
            p.keyFrames.clear();
            int[] keys = (int[])control.getObject("keyFrames");
            if (keys != null && keys.length > 0) {
                int[] nArray = keys;
                int n = keys.length;
                int n3 = 0;
                while (n3 < n) {
                    int i = nArray[n3];
                    p.keyFrames.add(i);
                    ++n3;
                }
            } else {
                Step[] steps = p.getSteps();
                int i = 0;
                while (i < steps.length) {
                    if (steps[i] != null) {
                        p.keyFrames.add(i);
                    }
                    ++i;
                }
            }
            p.setLocked(locked);
            return obj;
        }
    }
}

