/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.RectangularShape;
import java.util.Collection;
import java.util.HashSet;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.cabrillo.tracker.PositionVectorFootprint;
import org.opensourcephysics.cabrillo.tracker.ShapeIcon;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.tools.FontSizer;

public class PointShapeFootprint
implements Footprint,
Cloneable {
    protected String name;
    protected Shape shape;
    protected Shape highlight;
    protected AffineTransform transform = new AffineTransform();
    protected BasicStroke baseStroke = new BasicStroke();
    protected BasicStroke stroke;
    protected BasicStroke highlightStroke = new BasicStroke(2.0f);
    protected Color color = Color.black;
    protected Shape[] hitShapes = new Shape[1];
    protected static Collection<PointShapeFootprint> footprints = new HashSet<PointShapeFootprint>();
    private static final Ellipse2D HIGHLIGHT;
    private static final PointShapeFootprint DIAMOND;
    private static final PointShapeFootprint BOLD_DIAMOND;
    private static final PointShapeFootprint SOLID_DIAMOND;
    private static final PointShapeFootprint TRIANGLE;
    private static final PointShapeFootprint BOLD_TRIANGLE;
    private static final PointShapeFootprint SOLID_TRIANGLE;
    private static final PointShapeFootprint CIRCLE;
    private static final PointShapeFootprint BOLD_CIRCLE;
    private static final PointShapeFootprint SOLID_CIRCLE;
    private static final PointShapeFootprint VERT_LINE;
    private static final PointShapeFootprint BOLD_VERT_LINE;
    private static final PointShapeFootprint HORZ_LINE;
    private static final PointShapeFootprint BOLD_HORZ_LINE;
    private static final PointShapeFootprint CROSSHAIR;
    private static final PointShapeFootprint BOLD_CROSSHAIR;
    private static final PointShapeFootprint SIMPLE_AXES;
    private static final PointShapeFootprint BOLD_SIMPLE_AXES;
    private static final PointShapeFootprint SMALL_SPOT;
    private static final PointShapeFootprint SMALL_CIRCLE;
    private static final PointShapeFootprint SOLID_SQUARE;
    private static final PointShapeFootprint VECTOR;
    private static final PointShapeFootprint BOLD_VECTOR;
    private static final PointShapeFootprint SHAPE;
    private static final PointShapeFootprint BOLD_SHAPE;

    static {
        float w = 3000.0f;
        HIGHLIGHT = new Ellipse2D.Double();
        HIGHLIGHT.setFrame(-6.0, -6.0, 12.0, 12.0);
        GeneralPath diamond = new GeneralPath();
        diamond.moveTo(-5.0f, 0.0f);
        diamond.lineTo(0.0f, 5.0f);
        diamond.lineTo(5.01f, 0.0f);
        diamond.lineTo(0.0f, -5.0f);
        diamond.closePath();
        DIAMOND = new PointShapeFootprint("Footprint.Diamond", diamond);
        footprints.add(DIAMOND);
        BOLD_DIAMOND = new PointShapeFootprint("Footprint.BoldDiamond", diamond);
        BOLD_DIAMOND.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_DIAMOND);
        SOLID_DIAMOND = new PointShapeFootprint("Footprint.SolidDiamond", diamond);
        SOLID_DIAMOND.setStroke(null);
        footprints.add(SOLID_DIAMOND);
        GeneralPath triangle = new GeneralPath();
        triangle.moveTo(0.0f, -5.0f);
        triangle.lineTo(4.0f, 3.0f);
        triangle.lineTo(-4.0f, 3.0f);
        triangle.closePath();
        TRIANGLE = new PointShapeFootprint("Footprint.Triangle", triangle);
        footprints.add(TRIANGLE);
        BOLD_TRIANGLE = new PointShapeFootprint("Footprint.BoldTriangle", triangle);
        BOLD_TRIANGLE.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_TRIANGLE);
        SOLID_TRIANGLE = new PointShapeFootprint("Footprint.SolidTriangle", triangle);
        SOLID_TRIANGLE.setStroke(null);
        footprints.add(SOLID_TRIANGLE);
        Ellipse2D.Double circle = new Ellipse2D.Double();
        ((RectangularShape)circle).setFrame(-5.0, -5.0, 10.0, 10.0);
        CIRCLE = new PointShapeFootprint("Footprint.Circle", circle);
        footprints.add(CIRCLE);
        BOLD_CIRCLE = new PointShapeFootprint("Footprint.BoldCircle", circle);
        BOLD_CIRCLE.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_CIRCLE);
        SOLID_CIRCLE = new PointShapeFootprint("Footprint.SolidCircle", circle);
        SOLID_CIRCLE.setStroke(null);
        footprints.add(SOLID_CIRCLE);
        circle = new Ellipse2D.Double();
        ((RectangularShape)circle).setFrame(-3.0, -3.0, 6.0, 6.0);
        SMALL_CIRCLE = new PointShapeFootprint("Footprint.SmallCircle", circle);
        footprints.add(SMALL_CIRCLE);
        Ellipse2D.Double smallSpot = new Ellipse2D.Double(-2.0, -2.0, 4.0, 4.0);
        SMALL_SPOT = new PointShapeFootprint("Footprint.Spot", smallSpot);
        SMALL_SPOT.setStroke(null);
        footprints.add(SMALL_SPOT);
        GeneralPath vertLine = new GeneralPath();
        vertLine.moveTo(0.0f, -w);
        vertLine.lineTo(0.0f, w);
        vertLine.moveTo(-3.0f, 0.0f);
        vertLine.lineTo(3.0f, 0.0f);
        VERT_LINE = new PointShapeFootprint("Footprint.VerticalLine", vertLine);
        footprints.add(VERT_LINE);
        BOLD_VERT_LINE = new PointShapeFootprint("Footprint.BoldVerticalLine", vertLine);
        BOLD_VERT_LINE.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_VERT_LINE);
        GeneralPath horzLine = new GeneralPath();
        horzLine.moveTo(0.0f, -3.0f);
        horzLine.lineTo(0.0f, 3.0f);
        horzLine.moveTo(-w, 0.0f);
        horzLine.lineTo(w, 0.0f);
        HORZ_LINE = new PointShapeFootprint("Footprint.HorizontalLine", horzLine);
        footprints.add(HORZ_LINE);
        BOLD_HORZ_LINE = new PointShapeFootprint("Footprint.BoldHorizontalLine", horzLine);
        BOLD_HORZ_LINE.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_HORZ_LINE);
        GeneralPath crosshair = new GeneralPath();
        crosshair.moveTo(0.0f, -4.0f);
        crosshair.lineTo(0.0f, 4.0f);
        crosshair.moveTo(-4.0f, 0.0f);
        crosshair.lineTo(4.0f, 0.0f);
        CROSSHAIR = new PointShapeFootprint("Footprint.Crosshair", crosshair);
        footprints.add(CROSSHAIR);
        BOLD_CROSSHAIR = new PointShapeFootprint("Footprint.BoldCrosshair", crosshair);
        BOLD_CROSSHAIR.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_CROSSHAIR);
        GeneralPath axes = new GeneralPath();
        axes.reset();
        axes.moveTo(w, 0.0f);
        axes.lineTo(-w, 0.0f);
        axes.moveTo(0.0f, w);
        axes.lineTo(0.0f, -w);
        axes.moveTo(15.0f, 5.0f);
        axes.lineTo(15.0f, -5.0f);
        SIMPLE_AXES = new PointShapeFootprint("Footprint.SimpleAxes", axes);
        footprints.add(SIMPLE_AXES);
        BOLD_SIMPLE_AXES = new PointShapeFootprint("Footprint.BoldSimpleAxes", axes);
        BOLD_SIMPLE_AXES.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_SIMPLE_AXES);
        Rectangle square = new Rectangle(-3, -3, 6, 6);
        SOLID_SQUARE = new PointShapeFootprint("Footprint.SolidSquare", square);
        SOLID_SQUARE.setStroke(null);
        footprints.add(SOLID_SQUARE);
        VECTOR = new PositionVectorFootprint("Footprint.PositionVector", 1);
        footprints.add(VECTOR);
        BOLD_VECTOR = new PositionVectorFootprint("Footprint.BoldPositionVector", 2);
        footprints.add(BOLD_VECTOR);
        circle = new Ellipse2D.Double();
        ((RectangularShape)circle).setFrame(-5.0, -5.0, 10.0, 10.0);
        SHAPE = new PointShapeFootprint("Footprint.Shape", circle);
        footprints.add(SHAPE);
        BOLD_SHAPE = new PointShapeFootprint("Footprint.BoldShape", circle);
        BOLD_SHAPE.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_SHAPE);
    }

    public PointShapeFootprint(String name, Shape shape) {
        this.name = name;
        this.shape = shape;
    }

    public static PointShapeFootprint getFootprint(String name) {
        for (PointShapeFootprint footprint : footprints) {
            if (name != footprint.getName()) continue;
            try {
                return (PointShapeFootprint)footprint.clone();
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return TrackerRes.getString(this.name);
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public ResizableIcon getIcon(int w, int h) {
        MultiShape shape = this.getShape(new Point[]{new Point()}, 1);
        ShapeIcon icon = new ShapeIcon(shape, w, h);
        icon.setColor(this.color);
        icon.setStroke(this.stroke);
        return new ResizableIcon(icon);
    }

    @Override
    public Mark getMark(Point[] points) {
        final MultiShape shape = this.getShape(points, FontSizer.getIntegerFactor());
        final Shape highlight = this.highlight;
        return new Mark(){

            @Override
            public void draw(Graphics2D g, boolean highlighted) {
                Paint gpaint = g.getPaint();
                Stroke gstroke = g.getStroke();
                if (PointShapeFootprint.this.stroke != null) {
                    g.setStroke(PointShapeFootprint.this.stroke);
                }
                g.setPaint(PointShapeFootprint.this.color);
                if (OSPRuntime.setRenderingHints) {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                shape.draw(g);
                if (highlighted) {
                    g.setStroke(PointShapeFootprint.this.highlightStroke);
                    g.draw(highlight);
                }
                g.setPaint(gpaint);
                g.setStroke(gstroke);
            }
        };
    }

    @Override
    public Shape[] getHitShapes() {
        return this.hitShapes;
    }

    protected void setShape(Shape shape) {
        if (shape != null) {
            this.shape = shape;
        }
    }

    @Override
    public void setStroke(BasicStroke stroke) {
        this.baseStroke = stroke;
    }

    @Override
    public BasicStroke getStroke() {
        return this.baseStroke;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public MultiShape getShape(Point[] points, int scale) {
        Point p = points[0];
        this.transform.setToTranslation(p.x, p.y);
        if (scale > 1) {
            this.transform.scale(scale, scale);
        }
        Shape transformedShape = this.transform.createTransformedShape(this.shape);
        this.highlight = this.transform.createTransformedShape(HIGHLIGHT);
        if (this.baseStroke != null && (this.stroke == null || this.stroke.getLineWidth() != (float)scale * this.baseStroke.getLineWidth())) {
            this.stroke = new BasicStroke((float)scale * this.baseStroke.getLineWidth());
        }
        this.hitShapes[0] = transformedShape;
        return this.stroke != null ? new MultiShape(transformedShape).andStroke(this.stroke) : new MultiShape(transformedShape).andFill(true);
    }
}

