/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.opensourcephysics.cabrillo.tracker.AutoTracker;
import org.opensourcephysics.cabrillo.tracker.CircleFootprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PositionVectorFootprint;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;

public class PositionStep
extends Step {
    private static Point[] twoPoints = new Point[2];
    protected Position p;
    protected boolean labelVisible;
    protected boolean rolloverVisible;
    protected Map<Integer, OSPRuntime.TextLayout> panelTextLayouts = new HashMap<Integer, OSPRuntime.TextLayout>();
    protected Map<Integer, Rectangle> panelLayoutBounds = new HashMap<Integer, Rectangle>();
    protected CircleFootprint innerCircleFootprint = new CircleFootprint("CircleFootprint.Circle", 2);

    public PositionStep(PointMass track, int n, double x, double y) {
        super(track, n);
        this.p = new Position(x, y);
        this.p.setTrackEditTrigger(true);
        this.points = new TPoint[]{this.p};
        this.screenPoints = new Point[PositionStep.getLength()];
        this.setLabelVisible(track.labelsVisible);
        this.setRolloverVisible(!track.labelsVisible);
    }

    public Position getPosition() {
        return this.p;
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelVisible(boolean visible) {
        this.labelVisible = visible;
    }

    public boolean isRolloverVisible() {
        return this.rolloverVisible;
    }

    public void setRolloverVisible(boolean visible) {
        this.rolloverVisible = visible;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics _g) {
        AutoTracker autoTracker;
        TTrack track = this.getTrack();
        if (track.tp == panel && (autoTracker = track.tp.getAutoTracker(false)) != null && autoTracker.isInteracting(track)) {
            return;
        }
        if (panel instanceof TrackerPanel) {
            TrackerPanel trackerPanel = (TrackerPanel)panel;
            super.draw(trackerPanel, _g);
            Graphics2D g = (Graphics2D)_g;
            if (this.isLabelVisible()) {
                OSPRuntime.TextLayout layout = this.panelTextLayouts.get(trackerPanel.getID());
                if (layout == null) {
                    return;
                }
                Point p = this.getLayoutPosition(trackerPanel);
                Paint gpaint = g.getPaint();
                Font gfont = g.getFont();
                g.setPaint(this.footprint.getColor());
                g.setFont(TFrame.textLayoutFont);
                layout.draw(g, p.x, p.y);
                g.setPaint(gpaint);
                g.setFont(gfont);
            }
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        Interactive ia = super.findInteractive(panel, xpix, ypix);
        if (this.rolloverVisible) {
            if (ia != null && !this.labelVisible) {
                this.labelVisible = true;
                this.repaint();
            }
            if (ia == null && this.labelVisible) {
                this.labelVisible = false;
                this.repaint();
            }
        }
        return ia;
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = (Mark)this.panelMarks.get(trackerPanel.getID());
        TPoint selection = null;
        if (mark == null) {
            selection = trackerPanel.getSelectedPoint();
            Point p = null;
            this.valid = true;
            int n = 0;
            while (n < this.points.length) {
                if (this.valid) {
                    this.valid = this.valid && !Double.isNaN(this.points[n].getX()) && !Double.isNaN(this.points[n].getY());
                    this.screenPoints[n] = this.points[n].getScreenPosition(trackerPanel);
                    if (this.valid && (selection == this.points[n] || trackerPanel.selectedSteps.contains(this))) {
                        p = this.screenPoints[n];
                    }
                }
                ++n;
            }
            if (p == null) {
                if (this.footprint instanceof PositionVectorFootprint) {
                    PositionStep.twoPoints[0] = this.screenPoints[0];
                    PositionStep.twoPoints[1] = trackerPanel.getSnapPoint().getScreenPosition(trackerPanel);
                    mark = this.footprint.getMark(twoPoints);
                } else {
                    mark = this.footprint.getMark(this.screenPoints);
                }
            } else {
                transform.setToTranslation(p.x, p.y);
                int scale = FontSizer.getIntegerFactor();
                if (scale > 1) {
                    transform.scale(scale, scale);
                }
                final Color color = this.footprint.getColor();
                final Shape selectedShape = transform.createTransformedShape(selectionShape);
                mark = new Mark(){

                    @Override
                    public void draw(Graphics2D g, boolean highlighted) {
                        if (OSPRuntime.setRenderingHints) {
                            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        }
                        Paint gpaint = g.getPaint();
                        Stroke gstroke = g.getStroke();
                        g.setPaint(color);
                        g.setStroke(selectionStroke);
                        g.draw(selectedShape);
                        g.setPaint(gpaint);
                        g.setStroke(gstroke);
                    }
                };
            }
            if (!this.getTrack().keyFrames.contains(this.n)) {
                this.innerCircleFootprint.setColor(this.footprint.getColor());
                final Mark autofillMark = this.innerCircleFootprint.getMark(this.screenPoints);
                final Mark normalMark = mark;
                final PointMass m = (PointMass)this.getTrack();
                mark = new Mark(){

                    @Override
                    public void draw(Graphics2D g, boolean highlighted) {
                        normalMark.draw(g, highlighted);
                        if (m.showfilledSteps) {
                            autofillMark.draw(g, false);
                        }
                    }
                };
            }
            final Mark theMark = mark;
            mark = new Mark(){

                @Override
                public void draw(Graphics2D g, boolean highlighted) {
                    if (!PositionStep.this.valid) {
                        return;
                    }
                    theMark.draw(g, highlighted);
                }
            };
            this.panelMarks.put(trackerPanel.getID(), mark);
            String s = "";
            VideoClip clip = trackerPanel.getPlayer().getVideoClip();
            if (clip.getStepCount() != 1) {
                s = String.valueOf(s) + clip.frameToStep(this.getFrameNumber());
            }
            if (s.length() == 0) {
                s = " ";
            }
            OSPRuntime.TextLayout layout = new OSPRuntime.TextLayout(s, TFrame.textLayoutFont);
            this.panelTextLayouts.put(trackerPanel.getID(), layout);
            p = this.getLayoutPosition(trackerPanel);
            Rectangle bounds = this.panelLayoutBounds.get(trackerPanel.getID());
            if (bounds == null) {
                bounds = new Rectangle();
                this.panelLayoutBounds.put(trackerPanel.getID(), bounds);
            }
            Rectangle2D rect = layout.getBounds();
            bounds.setRect(p.x, (double)p.y - rect.getHeight(), rect.getWidth(), rect.getHeight());
        }
        return mark;
    }

    @Override
    public Object clone() {
        PositionStep step = (PositionStep)super.clone();
        if (step != null) {
            TPoint[] tPointArray = step.points;
            PositionStep positionStep = step;
            positionStep.getClass();
            step.p = positionStep.new Position(this.p.getX(), this.p.getY());
            tPointArray[0] = step.p;
            step.panelTextLayouts = new HashMap<Integer, OSPRuntime.TextLayout>();
            step.panelLayoutBounds = new HashMap<Integer, Rectangle>();
        }
        return step;
    }

    @Override
    public String toString() {
        return "PositionStep " + this.n + " [" + format.format(this.p.x) + ", " + format.format(this.p.y) + "]";
    }

    protected Point getLayoutPosition(TrackerPanel trackerPanel) {
        Point pt = this.p.getScreenPosition(trackerPanel);
        pt.setLocation(pt.x - 4 - TFrame.textLayoutFont.getSize(), pt.y - 6);
        return pt;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            PositionStep step = (PositionStep)obj;
            control.setValue("x", step.p.x);
            control.setValue("y", step.p.y);
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            PositionStep step = (PositionStep)obj;
            double x = control.getDouble("x");
            double y = control.getDouble("y");
            step.p.setXY(x, y);
            return obj;
        }
    }

    protected class Position
    extends TPoint {
        public Position(double x, double y) {
            super(x, y);
        }

        @Override
        public void setXY(double x, double y) {
            PointMass track = (PointMass)PositionStep.this.getTrack();
            if (track.isLocked()) {
                return;
            }
            super.setXY(x, y);
            PositionStep.this.repaint();
            PositionStep.this.getTrack().keyFrames.add(PositionStep.this.n);
            if (!this.isAdjusting()) {
                if (track.isAutofill()) {
                    track.markInterpolatedSteps(PositionStep.this, true);
                }
                track.updateDerivatives(PositionStep.this.n);
                track.firePropertyChange("step", null, new Integer(PositionStep.this.n));
            }
        }

        @Override
        public void showCoordinates(VideoPanel vidPanel) {
            TTrack track = PositionStep.this.getTrack();
            Point2D p = this.getWorldPosition(vidPanel);
            track.xField.setValue(p.getX());
            track.yField.setValue(p.getY());
            track.magField.setValue(p.distance(0.0, 0.0));
            double theta = Math.atan2(p.getY(), p.getX());
            track.angleField.setValue(theta);
            super.showCoordinates(vidPanel);
        }

        @Override
        public int getFrameNumber(VideoPanel vidPanel) {
            return PositionStep.this.n;
        }

        void setPosition(Point2D.Double point) {
            this.x = point.x;
            this.y = point.y;
        }

        @Override
        public void setAdjusting(boolean adjusting, MouseEvent e) {
            if (!adjusting && !this.isAdjusting()) {
                return;
            }
            super.setAdjusting(adjusting, e);
            PointMass m = (PointMass)PositionStep.this.getTrack();
            if (m.isAutofill()) {
                m.markInterpolatedSteps(PositionStep.this, !adjusting);
            }
            if (!adjusting) {
                m.updateDerivatives(PositionStep.this.n);
                m.firePropertyChange("step", null, new Integer(PositionStep.this.n));
            }
            m.firePropertyChange("adjusting", m, adjusting);
        }
    }
}

