/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.cabrillo.tracker.CircleFootprint;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PointShapeFootprint;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.deploy.TrackerJarFilter;
import org.opensourcephysics.cabrillo.tracker.deploy.TrackerStarter;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.IntegerField;
import org.opensourcephysics.media.mov.MovieFactory;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.JREFinder;
import org.opensourcephysics.tools.ResourceLoader;

public class PrefsDialog
extends JDialog {
    static final Color MEDIUM_RED = new Color(255, 120, 140);
    protected static boolean webStartWarningShown;
    protected static String userHome;
    protected static String javaHome;
    protected static FilenameFilter trackerJarFilter;
    protected static File codeBaseDir;
    protected TFrame frame;
    protected Integer panelID;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JButton allButton;
    protected JButton noneButton;
    protected JButton applyButton;
    protected JButton saveButton;
    protected JButton relaunchButton;
    protected JButton clearRecentButton;
    protected JButton checkForUpgradeButton;
    protected JButton clearHostButton;
    protected JButton browseCacheButton;
    protected JButton clearCacheButton;
    protected JButton setCacheButton;
    protected JButton setRunButton;
    protected JTextField cacheField;
    protected JTextField runField;
    protected JPanel checkPanel;
    protected JPanel mainButtonBar;
    protected JTabbedPane tabbedPane;
    protected JPanel configPanel;
    protected JPanel runtimePanel;
    protected JPanel videoPanel;
    protected JPanel generalPanel;
    protected JPanel actionsPanel;
    protected JPanel displayPanel;
    protected TitledBorder checkPanelBorder;
    protected TitledBorder lfSubPanelBorder;
    protected TitledBorder langSubPanelBorder;
    protected TitledBorder hintsSubPanelBorder;
    protected TitledBorder unitsSubPanelBorder;
    protected TitledBorder versionSubPanelBorder;
    protected TitledBorder jreSubPanelBorder;
    protected TitledBorder memorySubPanelBorder;
    protected TitledBorder runSubPanelBorder;
    protected TitledBorder videoTypeSubPanelBorder;
    protected TitledBorder xuggleSpeedSubPanelBorder;
    protected TitledBorder warningsSubPanelBorder;
    protected TitledBorder recentSubPanelBorder;
    protected TitledBorder cacheSubPanelBorder;
    protected TitledBorder logLevelSubPanelBorder;
    protected TitledBorder upgradeSubPanelBorder;
    protected TitledBorder fontSubPanelBorder;
    protected TitledBorder resetToStep0SubPanelBorder;
    protected TitledBorder decimalSeparatorBorder;
    protected TitledBorder mouseWheelSubPanelBorder;
    protected TitledBorder calibrationStickSubPanelBorder;
    protected TitledBorder dataGapSubPanelBorder;
    protected TitledBorder trailLengthSubPanelBorder;
    protected TitledBorder pointmassFootprintSubPanelBorder;
    protected IntegerField memoryField;
    protected JLabel memoryLabel;
    protected JLabel recentSizeLabel;
    protected JLabel lookFeelLabel;
    protected JLabel cacheLabel;
    protected JLabel versionLabel;
    protected JLabel runLabel;
    protected JCheckBox defaultMemoryCheckbox;
    protected JCheckBox hintsCheckbox;
    protected JCheckBox vidWarningCheckbox;
    protected JCheckBox showGapsCheckbox;
    protected JCheckBox xuggleErrorCheckbox;
    protected JCheckBox variableDurationCheckBox;
    protected JCheckBox resetToStep0Checkbox;
    protected JCheckBox autofillCheckbox;
    protected JCheckBox skippedStepsCheckbox;
    protected int memorySize = Tracker.requestedMemorySize;
    protected JSpinner recentSizeSpinner;
    protected JSpinner runSpinner;
    protected JComboBox<String> lookFeelDropdown;
    protected JComboBox<String> languageDropdown;
    protected JComboBox<String> jreDropdown;
    protected JComboBox<String> trailLengthDropdown;
    protected JComboBox<String> checkForUpgradeDropdown;
    protected JComboBox<String> versionDropdown;
    protected JComboBox<String> logLevelDropdown;
    protected JComboBox<String> fontSizeDropdown;
    protected JComboBox<Footprint> footprintDropdown;
    protected JRadioButton vm32Button;
    protected JRadioButton vm64Button;
    protected JRadioButton movieEngineButton;
    protected JRadioButton noEngineButton;
    protected JRadioButton radiansButton;
    protected JRadioButton degreesButton;
    protected JRadioButton scrubButton;
    protected JRadioButton zoomButton;
    protected JRadioButton markStickEndsButton;
    protected JRadioButton centerStickButton;
    protected JRadioButton xuggleFastButton;
    protected JRadioButton xuggleSlowButton;
    protected JRadioButton defaultDecimalButton;
    protected JRadioButton periodDecimalButton;
    protected JRadioButton commaDecimalButton;
    protected OSPRuntime.Version[] trackerVersions;
    protected boolean relaunching;
    protected boolean refreshing;
    protected Set<String> prevEnabled = new TreeSet<String>();
    protected int prevMemory;
    protected int prevRecentCount;
    protected int prevUpgradeInterval;
    protected int prevFontLevel;
    protected int prevFontLevelPlus;
    protected int prevTrailLengthIndex;
    protected String prevLookFeel;
    protected String prevLocaleName;
    protected String prevJRE;
    protected String prevTrackerJar;
    protected String prevEngine;
    protected String prevDecimalSeparator;
    protected String prevPointmassFootprint;
    protected boolean prevHints;
    protected boolean prevRadians;
    protected boolean prevFastXuggle;
    protected boolean prevCenterCalibrationStick;
    protected boolean prevWarnVariableDuration;
    protected boolean prevWarnNoVideoEngine;
    protected boolean prevWarnXuggleError;
    protected boolean prevWarnXuggleVersion;
    protected boolean prevShowGaps;
    protected boolean prevMarkAtCurrentFrame;
    protected boolean prevClearCacheOnExit;
    protected boolean prevUse32BitVM;
    protected boolean prevWarnCopyFailed;
    protected boolean prevZoomMouseWheel;
    protected boolean prevAutofill;
    protected File prevCache;
    protected String[] prevExecutables;
    protected Level prevLogLevel;

    static {
        trackerJarFilter = new TrackerJarFilter();
        try {
            userHome = OSPRuntime.getUserHome();
            javaHome = System.getProperty("java.home");
            URL url = TrackerStarter.class.getProtectionDomain().getCodeSource().getLocation();
            File jarFile = new File(url.toURI());
            codeBaseDir = jarFile.getParentFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PrefsDialog(TrackerPanel panel, TFrame frame) {
        super((Frame)(panel == null ? null : panel.getTFrame()), false);
        this.panelID = panel == null ? null : panel.getID();
        this.frame = frame;
        this.setTitle(TrackerRes.getString("ConfigInspector.Title"));
        this.findTrackerJars();
        this.createGUI();
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (vis) {
            this.savePrevious();
            this.findTrackerJars();
            this.refreshGUI();
        }
    }

    public void setFontLevel(int level) {
        JComboBox[] dropdowns;
        FontSizer.setFonts(this, level);
        TitledBorder[] borders = new TitledBorder[]{this.checkPanelBorder, this.lfSubPanelBorder, this.langSubPanelBorder, this.hintsSubPanelBorder, this.unitsSubPanelBorder, this.versionSubPanelBorder, this.jreSubPanelBorder, this.memorySubPanelBorder, this.runSubPanelBorder, this.videoTypeSubPanelBorder, this.xuggleSpeedSubPanelBorder, this.warningsSubPanelBorder, this.recentSubPanelBorder, this.cacheSubPanelBorder, this.logLevelSubPanelBorder, this.upgradeSubPanelBorder, this.fontSubPanelBorder, this.resetToStep0SubPanelBorder, this.decimalSeparatorBorder, this.mouseWheelSubPanelBorder, this.calibrationStickSubPanelBorder, this.dataGapSubPanelBorder, this.trailLengthSubPanelBorder, this.pointmassFootprintSubPanelBorder};
        FontSizer.setFonts(borders, level);
        JComboBox[] jComboBoxArray = dropdowns = new JComboBox[]{this.lookFeelDropdown, this.languageDropdown, this.fontSizeDropdown, this.jreDropdown, this.checkForUpgradeDropdown, this.versionDropdown, this.logLevelDropdown};
        int n = dropdowns.length;
        int n2 = 0;
        while (n2 < n) {
            JComboBox next = jComboBoxArray[n2];
            if (next != null) {
                int n3 = next.getSelectedIndex();
                String[] items = new String[next.getItemCount()];
                int i = 0;
                while (i < items.length) {
                    items[i] = (String)next.getItemAt(i);
                    ++i;
                }
                DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(items);
                next.setModel(model);
                next.setSelectedItem(n3);
            }
            ++n2;
        }
        if (this.footprintDropdown != null) {
            int n4 = this.footprintDropdown.getSelectedIndex();
            Footprint[] items = new Footprint[this.footprintDropdown.getItemCount()];
            int i = 0;
            while (i < items.length) {
                items[i] = this.footprintDropdown.getItemAt(i);
                ++i;
            }
            DefaultComboBoxModel<Footprint> model = new DefaultComboBoxModel<Footprint>(items);
            this.footprintDropdown.setModel(model);
            this.footprintDropdown.setSelectedItem(n4);
        }
    }

    private void findTrackerJars() {
        this.trackerVersions = new OSPRuntime.Version[]{new OSPRuntime.Version("0")};
        if (Tracker.trackerHome == null || codeBaseDir == null) {
            return;
        }
        String jarHome = OSPRuntime.isMac() ? codeBaseDir.getAbsolutePath() : Tracker.trackerHome;
        File dir = new File(jarHome);
        String[] fileNames = dir.list(trackerJarFilter);
        if (fileNames != null && fileNames.length > 0) {
            TreeSet<OSPRuntime.Version> versions = new TreeSet<OSPRuntime.Version>();
            int i = 0;
            while (i < fileNames.length) {
                if ("tracker.jar".equals(fileNames[i].toLowerCase())) {
                    versions.add(new OSPRuntime.Version("0"));
                } else {
                    versions.add(new OSPRuntime.Version(fileNames[i].substring(8, fileNames[i].length() - 4)));
                }
                ++i;
            }
            this.trackerVersions = versions.toArray(new OSPRuntime.Version[versions.size()]);
        }
    }

    private void createGUI() {
        this.tabbedPane = new JTabbedPane();
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        contentPane.add((Component)this.tabbedPane, "Center");
        this.okButton = new JButton();
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrefsDialog.this.applyPrefs();
                PrefsDialog.this.setVisible(false);
                if (PrefsDialog.this.frame != null) {
                    PrefsDialog.this.frame.refresh();
                }
            }
        });
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrefsDialog.this.revert();
                PrefsDialog.this.setVisible(false);
                if (PrefsDialog.this.frame != null) {
                    PrefsDialog.this.frame.refresh();
                }
            }
        });
        this.relaunchButton = new JButton();
        this.relaunchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrefsDialog.this.applyPrefs();
                PrefsDialog.this.frame.relaunchCurrentTabs();
            }
        });
        Color color = Color.WHITE;
        if (!OSPRuntime.isJS) {
            this.configPanel = new JPanel(new BorderLayout());
            int n = 1 + Tracker.getFullConfig().size() / 2;
            this.checkPanel = new JPanel(new GridLayout(n, 2));
            this.checkPanel.setBackground(color);
            this.checkPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("ConfigInspector.Border.Title"));
            this.checkPanel.setBorder(this.checkPanelBorder);
            for (String item : Tracker.getFullConfig()) {
                JCheckBoxMenuItem checkbox = new JCheckBoxMenuItem(item);
                checkbox.setOpaque(false);
                this.checkPanel.add(checkbox);
            }
            JScrollPane scroller = new JScrollPane(this.checkPanel);
            scroller.getVerticalScrollBar().setUnitIncrement(16);
            scroller.setPreferredSize(new Dimension(450, 200));
            this.configPanel.add((Component)scroller, "Center");
            this.applyButton = new JButton();
            this.applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrefsDialog.this.updateConfig();
                    PrefsDialog.this.refreshGUI();
                    PrefsDialog.this.frame.refresh();
                }
            });
            this.allButton = new JButton();
            this.allButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Component[] checkboxes = PrefsDialog.this.checkPanel.getComponents();
                    int i = 0;
                    while (i < checkboxes.length) {
                        JCheckBoxMenuItem checkbox = (JCheckBoxMenuItem)checkboxes[i];
                        checkbox.setSelected(true);
                        ++i;
                    }
                }
            });
            this.noneButton = new JButton();
            this.noneButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Component[] checkboxes = PrefsDialog.this.checkPanel.getComponents();
                    int i = 0;
                    while (i < checkboxes.length) {
                        JCheckBoxMenuItem checkbox = (JCheckBoxMenuItem)checkboxes[i];
                        checkbox.setSelected(false);
                        ++i;
                    }
                }
            });
            this.saveButton = new JButton();
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrefsDialog.this.saveConfigAsDefault();
                }
            });
            JPanel configButtonBar = new JPanel();
            configButtonBar.add(this.allButton);
            configButtonBar.add(this.noneButton);
            configButtonBar.add(this.applyButton);
            configButtonBar.add(this.saveButton);
            this.configPanel.add((Component)configButtonBar, "North");
        }
        Border etched = BorderFactory.createEtchedBorder();
        this.displayPanel = new JPanel(new BorderLayout());
        Box box = Box.createVerticalBox();
        this.displayPanel.add((Component)box, "Center");
        Box horz = Box.createHorizontalBox();
        box.add(horz);
        if (!OSPRuntime.isJS) {
            JPanel langSubPanel = new JPanel();
            horz.add(langSubPanel);
            langSubPanel.setBackground(color);
            this.langSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.Language.BorderTitle"));
            langSubPanel.setBorder(BorderFactory.createCompoundBorder(etched, this.langSubPanelBorder));
            this.languageDropdown = new JComboBox();
            this.languageDropdown.addItem(TrackerRes.getString("PrefsDialog.Language.Default"));
            int index = 0;
            int selectedIndex = 0;
            Locale[] localeArray = Tracker.getLocales();
            int n = localeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Locale next = localeArray[n2];
                ++index;
                String s = OSPRuntime.getDisplayLanguage(next);
                if (next.getLanguage().equals("pt")) {
                    s = String.valueOf(s) + " (" + next.getCountry() + ")";
                }
                this.languageDropdown.addItem(s);
                if (next.equals(Locale.getDefault()) && next.toString().equals(Tracker.preferredLocale)) {
                    selectedIndex = index;
                }
                ++n2;
            }
            this.languageDropdown.setSelectedIndex(selectedIndex);
            this.languageDropdown.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    int index = PrefsDialog.this.languageDropdown.getSelectedIndex();
                    if (index == 0) {
                        Tracker.setPreferredLocale(null);
                    } else {
                        Tracker.setPreferredLocale(Tracker.getLocales()[index - 1].toString());
                    }
                }
            });
            langSubPanel.add(this.languageDropdown);
            JPanel fontSubPanel = new JPanel();
            horz.add(fontSubPanel);
            fontSubPanel.setBackground(color);
            this.fontSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.FontSize.BorderTitle"));
            fontSubPanel.setBorder(BorderFactory.createCompoundBorder(etched, this.fontSubPanelBorder));
            this.fontSizeDropdown = new JComboBox();
            String defaultLevel = TrackerRes.getString("TMenuBar.MenuItem.DefaultFontSize");
            this.fontSizeDropdown.addItem(defaultLevel);
            int preferredLevel = Tracker.preferredFontLevel + Tracker.preferredFontLevelPlus;
            int maxLevel = Math.max(preferredLevel, Tracker.maxFontLevel);
            int i = 1;
            while (i <= maxLevel) {
                String s = "+" + i;
                this.fontSizeDropdown.addItem(s);
                ++i;
            }
            this.fontSizeDropdown.setSelectedIndex(preferredLevel);
            this.fontSizeDropdown.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    int preferredLevel = PrefsDialog.this.fontSizeDropdown.getSelectedIndex();
                    Tracker.preferredFontLevel = Math.min(preferredLevel, 3);
                    Tracker.preferredFontLevelPlus = preferredLevel - Tracker.preferredFontLevel;
                }
            });
            fontSubPanel.add(this.fontSizeDropdown);
        }
        horz = Box.createHorizontalBox();
        box.add(horz);
        JPanel unitsSubPanel = new JPanel();
        horz.add(unitsSubPanel);
        unitsSubPanel.setBackground(color);
        this.unitsSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("TMenuBar.Menu.AngleUnits"));
        unitsSubPanel.setBorder(BorderFactory.createCompoundBorder(etched, this.unitsSubPanelBorder));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.radiansButton = new JRadioButton();
        this.radiansButton.setOpaque(false);
        this.radiansButton.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 10));
        this.radiansButton.setSelected(Tracker.isRadians);
        buttonGroup.add(this.radiansButton);
        this.degreesButton = new JRadioButton();
        this.degreesButton.setOpaque(false);
        this.degreesButton.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 10));
        this.degreesButton.setSelected(!Tracker.isRadians);
        buttonGroup.add(this.degreesButton);
        unitsSubPanel.add(this.radiansButton);
        unitsSubPanel.add(this.degreesButton);
        if (!OSPRuntime.isJS) {
            this.hintsCheckbox = new JCheckBox();
            this.hintsCheckbox.setOpaque(false);
            this.hintsCheckbox.setSelected(Tracker.showHintsByDefault);
            this.hintsCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Tracker.showHintsByDefault = PrefsDialog.this.hintsCheckbox.isSelected();
                }
            });
            JPanel hintsSubPanel = new JPanel();
            horz.add(hintsSubPanel);
            hintsSubPanel.setBackground(color);
            this.hintsSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.Hints.BorderTitle"));
            hintsSubPanel.setBorder(BorderFactory.createCompoundBorder(etched, this.hintsSubPanelBorder));
            hintsSubPanel.add(this.hintsCheckbox);
        }
        horz = Box.createHorizontalBox();
        box.add(horz);
        JPanel decimalSubPanel = new JPanel();
        horz.add(decimalSubPanel);
        decimalSubPanel.setBackground(color);
        this.decimalSeparatorBorder = BorderFactory.createTitledBorder(TrackerRes.getString("NumberFormatSetter.TitledBorder.DecimalSeparator.Text"));
        decimalSubPanel.setBorder(BorderFactory.createCompoundBorder(etched, this.decimalSeparatorBorder));
        AbstractAction decimalSeparatorAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Tracker.preferredDecimalSeparator = PrefsDialog.this.periodDecimalButton.isSelected() ? "." : (PrefsDialog.this.commaDecimalButton.isSelected() ? "," : null);
                OSPRuntime.setPreferredDecimalSeparator(Tracker.preferredDecimalSeparator);
            }
        };
        this.defaultDecimalButton = new JRadioButton();
        this.defaultDecimalButton.setOpaque(false);
        this.defaultDecimalButton.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 10));
        this.defaultDecimalButton.addActionListener(decimalSeparatorAction);
        this.periodDecimalButton = new JRadioButton();
        this.periodDecimalButton.setOpaque(false);
        this.periodDecimalButton.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 10));
        this.periodDecimalButton.addActionListener(decimalSeparatorAction);
        this.commaDecimalButton = new JRadioButton();
        this.commaDecimalButton.setOpaque(false);
        this.commaDecimalButton.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 10));
        this.commaDecimalButton.addActionListener(decimalSeparatorAction);
        ButtonGroup group = new ButtonGroup();
        group.add(this.defaultDecimalButton);
        group.add(this.periodDecimalButton);
        group.add(this.commaDecimalButton);
        decimalSubPanel.add(this.defaultDecimalButton);
        decimalSubPanel.add(this.periodDecimalButton);
        decimalSubPanel.add(this.commaDecimalButton);
        Border buttonBorder = BorderFactory.createEtchedBorder();
        Border space = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        buttonBorder = BorderFactory.createCompoundBorder(buttonBorder, space);
        Icon openFileIcon = Tracker.getResourceIcon("open.gif", true);
        if (!OSPRuntime.isJS) {
            this.runtimePanel = new JPanel(new BorderLayout());
            box = Box.createVerticalBox();
            this.runtimePanel.add((Component)box, "Center");
            JPanel versionSubPanel = new JPanel();
            box.add(versionSubPanel);
            versionSubPanel.setBackground(color);
            this.versionSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.Version.BorderTitle"));
            versionSubPanel.setBorder(BorderFactory.createCompoundBorder(etched, this.versionSubPanelBorder));
            int preferred = 0;
            this.versionDropdown = new JComboBox();
            int i = 0;
            while (i < this.trackerVersions.length) {
                String next = this.trackerVersions[i].toString();
                if (next.equals("0")) {
                    String s = TrackerRes.getString("PrefsDialog.Version.Default");
                    this.versionDropdown.addItem(s);
                } else {
                    this.versionDropdown.addItem(next);
                }
                if (Tracker.preferredTrackerJar != null && Tracker.preferredTrackerJar.indexOf("tracker-") > -1 && Tracker.preferredTrackerJar.indexOf(next) > -1) {
                    preferred = i;
                }
                ++i;
            }
            this.versionDropdown.setSelectedIndex(preferred);
            this.versionDropdown.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Object ver = PrefsDialog.this.versionDropdown.getSelectedItem();
                    String jar = null;
                    if (ver != null && !TrackerRes.getString("PrefsDialog.Version.Default").equals(ver)) {
                        jar = "tracker-" + ver + ".jar";
                    }
                    if (jar == null && Tracker.preferredTrackerJar != null) {
                        Tracker.preferredTrackerJar = null;
                    } else if (jar != null && !jar.equals(Tracker.preferredTrackerJar)) {
                        Tracker.preferredTrackerJar = jar;
                    }
                    String jarName = jar == null ? "tracker.jar" : jar;
                    String jarHome = OSPRuntime.isMac() ? codeBaseDir.getAbsolutePath() : Tracker.trackerHome;
                    String jarPath = XML.forwardSlash(new File(jarHome, jarName).getPath());
                    boolean usesServer = TrackerStarter.usesXuggleServer(jarPath);
                    int bitness = usesServer ? 64 : (OSPRuntime.isWindows() ? 32 : 64);
                    PrefsDialog.this.refreshJREDropdown(bitness);
                }
            });
            versionSubPanel.add(this.versionDropdown);
            JPanel jreSubPanel = new JPanel();
            box.add(jreSubPanel);
            jreSubPanel.setBackground(color);
            this.jreSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.JRE.BorderTitle"));
            jreSubPanel.setBorder(BorderFactory.createCompoundBorder(etched, this.jreSubPanelBorder));
            JPanel jreNorthPanel = new JPanel();
            jreNorthPanel.setBackground(color);
            JPanel jreSouthPanel = new JPanel();
            jreSouthPanel.setBackground(color);
            int vmBitness = OSPRuntime.getVMBitness();
            this.vm32Button = new JRadioButton();
            this.vm32Button.setOpaque(false);
            this.vm32Button.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 10));
            this.vm32Button.setSelected(vmBitness == 32);
            this.vm32Button.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!PrefsDialog.this.vm32Button.isSelected()) {
                        return;
                    }
                    if (OSPRuntime.isWindows()) {
                        PrefsDialog.this.refreshJREDropdown(32);
                    }
                }
            });
            jreNorthPanel.add(this.vm32Button);
            this.vm64Button = new JRadioButton();
            this.vm64Button.setOpaque(false);
            this.vm64Button.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 0));
            this.vm64Button.setSelected(vmBitness == 64);
            this.vm64Button.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!PrefsDialog.this.vm64Button.isSelected()) {
                        return;
                    }
                    PrefsDialog.this.refreshJREDropdown(64);
                }
            });
            this.jreDropdown = new JComboBox();
            jreSubPanel.add(this.jreDropdown);
            this.refreshJREDropdown(vmBitness);
            JPanel memorySubPanel = new JPanel();
            box.add(memorySubPanel);
            memorySubPanel.setBackground(color);
            this.memorySubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.Memory.BorderTitle"));
            memorySubPanel.setBorder(BorderFactory.createCompoundBorder(etched, this.memorySubPanelBorder));
            memorySubPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    PrefsDialog.this.requestFocusInWindow();
                }
            });
            this.defaultMemoryCheckbox = new JCheckBox();
            this.defaultMemoryCheckbox.setOpaque(false);
            this.memoryLabel = new JLabel("MB");
            this.memoryField = new IntegerField(4);
            this.memoryField.setMinValue(64.0);
            this.memoryField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (PrefsDialog.this.memorySize != PrefsDialog.this.memoryField.getIntValue()) {
                        PrefsDialog.this.memorySize = PrefsDialog.this.memoryField.getIntValue();
                    }
                }
            });
            this.memoryField.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (PrefsDialog.this.defaultMemoryCheckbox.isSelected()) {
                        PrefsDialog.this.defaultMemoryCheckbox.doClick(0);
                    }
                }
            });
            this.memoryField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrefsDialog.this.memorySize = PrefsDialog.this.memoryField.getIntValue();
                }
            });
            this.defaultMemoryCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean selected = PrefsDialog.this.defaultMemoryCheckbox.isSelected();
                    if (selected) {
                        PrefsDialog.this.memoryField.setEnabled(false);
                        PrefsDialog.this.memoryLabel.setEnabled(false);
                        PrefsDialog.this.memoryField.setText(null);
                    } else {
                        PrefsDialog.this.memoryField.setEnabled(true);
                        PrefsDialog.this.memoryLabel.setEnabled(true);
                        PrefsDialog.this.memoryField.setValue(PrefsDialog.this.memorySize);
                        PrefsDialog.this.memoryField.requestFocusInWindow();
                        PrefsDialog.this.memoryField.selectAll();
                    }
                }
            });
            if (Tracker.preferredMemorySize > -1) {
                this.memoryField.setValue(Tracker.preferredMemorySize);
            } else {
                this.defaultMemoryCheckbox.setSelected(true);
                this.memoryField.setEnabled(false);
                this.memoryLabel.setEnabled(false);
                this.memoryField.setText(null);
            }
            memorySubPanel.add(this.defaultMemoryCheckbox);
            memorySubPanel.add(Box.createRigidArea(new Dimension(40, 1)));
            memorySubPanel.add(this.memoryField);
            memorySubPanel.add(this.memoryLabel);
            JPanel runSubPanel = new JPanel();
            box.add(runSubPanel);
            runSubPanel.setBackground(color);
            this.runSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.Run.BorderTitle"));
            runSubPanel.setBorder(BorderFactory.createCompoundBorder(etched, this.runSubPanelBorder));
            final AbstractAction setRunAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String path = PrefsDialog.this.runField.getText();
                    int n = (Integer)PrefsDialog.this.runSpinner.getValue();
                    ArrayList<String> paths = new ArrayList<String>();
                    if (Tracker.prelaunchExecutables.length > n) {
                        if (path.equals(Tracker.prelaunchExecutables[n])) {
                            return;
                        }
                        if ("".equals(path)) {
                            Tracker.prelaunchExecutables[n] = path;
                            path = null;
                        } else {
                            Tracker.prelaunchExecutables[n] = path;
                            path = null;
                        }
                    }
                    String[] stringArray = Tracker.prelaunchExecutables;
                    int n2 = Tracker.prelaunchExecutables.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        String next = stringArray[n3];
                        if (next != null && !"".equals(next) && !paths.contains(next)) {
                            paths.add(next);
                        }
                        ++n3;
                    }
                    if (path != null && !"".equals(path) && !paths.contains(path)) {
                        paths.add(path);
                    }
                    Tracker.prelaunchExecutables = paths.toArray(new String[0]);
                    int i = 0;
                    while (i < Tracker.prelaunchExecutables.length) {
                        if (Tracker.prelaunchExecutables[i].equals(path)) {
                            PrefsDialog.this.runSpinner.setValue(i);
                            break;
                        }
                        ++i;
                    }
                    PrefsDialog.this.refreshTextFields();
                }
            };
            this.runSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 6, 1));
            JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.runSpinner);
            this.runSpinner.setEditor(editor);
            this.runSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (PrefsDialog.this.runField.getBackground() == Color.yellow) {
                        setRunAction.actionPerformed(null);
                    } else {
                        PrefsDialog.this.refreshTextFields();
                    }
                }
            });
            runSubPanel.add(this.runSpinner);
            this.runField = new JTextField(27);
            runSubPanel.add(this.runField);
            this.runField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    PrefsDialog.this.runField.setBackground(Color.yellow);
                }
            });
            this.runField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (PrefsDialog.this.runField.getBackground() == Color.yellow) {
                        setRunAction.actionPerformed(null);
                    }
                }
            });
            this.runField.addActionListener(setRunAction);
            this.setRunButton = new TButton(openFileIcon);
            this.setRunButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file;
                    int result = 1;
                    File f = Tracker.trackerHome == null ? new File(".") : new File(Tracker.trackerHome);
                    JFileChooser chooser = PrefsDialog.getFileChooser(f, false);
                    chooser.setDialogTitle(TrackerRes.getString("PrefsDialog.FileChooser.Title.Run"));
                    result = chooser.showOpenDialog(PrefsDialog.this);
                    if (result == 0 && (file = chooser.getSelectedFile()) != null) {
                        PrefsDialog.this.runField.setText(file.getPath());
                        setRunAction.actionPerformed(null);
                    }
                }
            });
            this.setRunButton.setBorder(buttonBorder);
            this.setRunButton.setContentAreaFilled(false);
            runSubPanel.add(this.setRunButton);
        }
        this.videoPanel = new JPanel(new BorderLayout());
        box = Box.createVerticalBox();
        this.videoPanel.add((Component)box, "Center");
        boolean movieEngineInstalled = MovieFactory.hasVideoEngine();
        JPanel mouseWheelSubPanel = new JPanel();
        box.add(mouseWheelSubPanel);
        mouseWheelSubPanel.setBackground(color);
        this.mouseWheelSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.Mousewheel.BorderTitle"));
        mouseWheelSubPanel.setBorder(BorderFactory.createCompoundBorder(etched, this.mouseWheelSubPanelBorder));
        this.zoomButton = new JRadioButton();
        this.zoomButton.setOpaque(false);
        this.zoomButton.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 10));
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.zoomButton);
        this.scrubButton = new JRadioButton();
        this.scrubButton.setOpaque(false);
        this.scrubButton.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 10));
        buttonGroup.add(this.scrubButton);
        if (Tracker.scrubMouseWheel) {
            this.scrubButton.setSelected(true);
        } else {
            this.zoomButton.setSelected(true);
        }
        mouseWheelSubPanel.add(this.zoomButton);
        mouseWheelSubPanel.add(this.scrubButton);
        ActionListener mouseWheelAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Tracker.scrubMouseWheel = PrefsDialog.this.scrubButton.isSelected();
            }
        };
        this.zoomButton.addActionListener(mouseWheelAction);
        this.scrubButton.addActionListener(mouseWheelAction);
        this.movieEngineButton = new JRadioButton();
        this.movieEngineButton.setOpaque(false);
        this.movieEngineButton.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 10));
        this.movieEngineButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PrefsDialog.this.xuggleFastButton.setEnabled(PrefsDialog.this.movieEngineButton.isSelected());
                PrefsDialog.this.xuggleSlowButton.setEnabled(PrefsDialog.this.movieEngineButton.isSelected());
                PrefsDialog.this.xuggleErrorCheckbox.setEnabled(PrefsDialog.this.movieEngineButton.isSelected());
            }
        });
        this.movieEngineButton.setEnabled(movieEngineInstalled);
        this.noEngineButton = new JRadioButton();
        this.noEngineButton.setOpaque(false);
        this.noEngineButton.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 0));
        this.noEngineButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!PrefsDialog.this.noEngineButton.isSelected()) {
                    return;
                }
            }
        });
        if (!OSPRuntime.isJS) {
            JPanel xuggleSpeedSubPanel = new JPanel();
            box.add(xuggleSpeedSubPanel);
            xuggleSpeedSubPanel.setBackground(color);
            this.xuggleSpeedSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.Xuggle.Speed.BorderTitle"));
            if (!movieEngineInstalled) {
                this.xuggleSpeedSubPanelBorder.setTitleColor(GUIUtils.getDisabledTextColor());
            }
            xuggleSpeedSubPanel.setBorder(BorderFactory.createCompoundBorder(etched, this.xuggleSpeedSubPanelBorder));
            buttonGroup = new ButtonGroup();
            this.xuggleFastButton = new JRadioButton();
            this.xuggleFastButton.setOpaque(false);
            this.xuggleFastButton.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 10));
            this.xuggleFastButton.setSelected(movieEngineInstalled && Tracker.isXuggleFast);
            buttonGroup.add(this.xuggleFastButton);
            this.xuggleSlowButton = new JRadioButton();
            this.xuggleSlowButton.setOpaque(false);
            this.xuggleSlowButton.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 0));
            this.xuggleSlowButton.setSelected(movieEngineInstalled && !Tracker.isXuggleFast);
            buttonGroup.add(this.xuggleSlowButton);
            xuggleSpeedSubPanel.add(this.xuggleFastButton);
            xuggleSpeedSubPanel.add(this.xuggleSlowButton);
        }
        JPanel warningsSubPanel = new JPanel(new BorderLayout());
        box.add(warningsSubPanel);
        warningsSubPanel.setBackground(color);
        this.warningsSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.NoVideoWarning.BorderTitle"));
        warningsSubPanel.setBorder(BorderFactory.createCompoundBorder(etched, this.warningsSubPanelBorder));
        JPanel warningsNorthPanel = new JPanel();
        warningsNorthPanel.setBackground(color);
        warningsSubPanel.add((Component)warningsNorthPanel, "North");
        JPanel warningsCenterPanel = new JPanel();
        warningsCenterPanel.setBackground(color);
        JPanel warningsSouthPanel = new JPanel();
        warningsSouthPanel.setBackground(color);
        JPanel centerSouthPanel = new JPanel(new BorderLayout());
        centerSouthPanel.add((Component)warningsCenterPanel, "North");
        centerSouthPanel.add((Component)warningsSouthPanel, "Center");
        warningsSubPanel.add((Component)centerSouthPanel, "Center");
        if (!OSPRuntime.isJS) {
            this.vidWarningCheckbox = new JCheckBox();
            this.vidWarningCheckbox.setOpaque(false);
            this.vidWarningCheckbox.setSelected(Tracker.warnNoVideoEngine);
            this.vidWarningCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Tracker.warnNoVideoEngine = PrefsDialog.this.vidWarningCheckbox.isSelected();
                }
            });
            this.xuggleErrorCheckbox = new JCheckBox();
            this.xuggleErrorCheckbox.setOpaque(false);
            this.xuggleErrorCheckbox.setSelected(Tracker.warnXuggleError);
            this.xuggleErrorCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Tracker.warnXuggleError = PrefsDialog.this.xuggleErrorCheckbox.isSelected();
                }
            });
            warningsNorthPanel.add(this.vidWarningCheckbox);
            warningsCenterPanel.add(this.xuggleErrorCheckbox);
        }
        this.variableDurationCheckBox = new JCheckBox();
        this.variableDurationCheckBox.setOpaque(false);
        this.variableDurationCheckBox.setSelected(Tracker.warnVariableDuration);
        this.variableDurationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Tracker.warnVariableDuration = PrefsDialog.this.variableDurationCheckBox.isSelected();
            }
        });
        warningsNorthPanel.add(this.variableDurationCheckBox);
        this.actionsPanel = new JPanel(new BorderLayout());
        box = Box.createVerticalBox();
        this.actionsPanel.add((Component)box, "Center");
        horz = Box.createHorizontalBox();
        box.add(horz);
        JPanel markingSubPanel = new JPanel();
        horz.add(markingSubPanel);
        markingSubPanel.setBackground(color);
        this.resetToStep0SubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.Marking.BorderTitle"));
        markingSubPanel.setBorder(BorderFactory.createCompoundBorder(etched, this.resetToStep0SubPanelBorder));
        this.resetToStep0Checkbox = new JCheckBox();
        this.resetToStep0Checkbox.setOpaque(false);
        this.resetToStep0Checkbox.setSelected(!Tracker.markAtCurrentFrame);
        this.resetToStep0Checkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Tracker.markAtCurrentFrame = !PrefsDialog.this.resetToStep0Checkbox.isSelected();
            }
        });
        markingSubPanel.add(this.resetToStep0Checkbox);
        JPanel calibrationStickSubPanel = new JPanel();
        box.add(calibrationStickSubPanel);
        calibrationStickSubPanel.setBackground(color);
        this.calibrationStickSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.CalibrationStick.BorderTitle"));
        calibrationStickSubPanel.setBorder(BorderFactory.createCompoundBorder(etched, this.calibrationStickSubPanelBorder));
        this.markStickEndsButton = new JRadioButton();
        this.markStickEndsButton.setOpaque(false);
        this.markStickEndsButton.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 10));
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.markStickEndsButton);
        this.centerStickButton = new JRadioButton();
        this.centerStickButton.setOpaque(false);
        this.centerStickButton.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 10));
        buttonGroup.add(this.centerStickButton);
        if (Tracker.centerCalibrationStick) {
            this.centerStickButton.setSelected(true);
        } else {
            this.markStickEndsButton.setSelected(true);
        }
        calibrationStickSubPanel.add(this.markStickEndsButton);
        calibrationStickSubPanel.add(this.centerStickButton);
        ActionListener calStickAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Tracker.centerCalibrationStick = PrefsDialog.this.centerStickButton.isSelected();
            }
        };
        this.markStickEndsButton.addActionListener(calStickAction);
        this.centerStickButton.addActionListener(calStickAction);
        JPanel dataGapSubPanel = new JPanel();
        box.add(dataGapSubPanel);
        dataGapSubPanel.setBackground(color);
        this.dataGapSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.DataGap.BorderTitle"));
        dataGapSubPanel.setBorder(BorderFactory.createCompoundBorder(etched, this.dataGapSubPanelBorder));
        this.showGapsCheckbox = new JCheckBox();
        this.showGapsCheckbox.setOpaque(false);
        this.showGapsCheckbox.setSelected(Tracker.showGaps);
        this.showGapsCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Tracker.showGaps = PrefsDialog.this.showGapsCheckbox.isSelected();
            }
        });
        dataGapSubPanel.add(this.showGapsCheckbox);
        this.autofillCheckbox = new JCheckBox();
        this.autofillCheckbox.setOpaque(false);
        this.autofillCheckbox.setSelected(Tracker.enableAutofill);
        this.autofillCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Tracker.enableAutofill = PrefsDialog.this.autofillCheckbox.isSelected();
                if (PrefsDialog.this.panelID != null) {
                    TFrame.repaintT(PrefsDialog.this.frame.getTrackerPanelForID(PrefsDialog.this.panelID));
                }
            }
        });
        dataGapSubPanel.add(this.autofillCheckbox);
        this.skippedStepsCheckbox = new JCheckBox();
        this.skippedStepsCheckbox.setOpaque(false);
        this.skippedStepsCheckbox.setSelected(Tracker.warnSkippedStep);
        this.skippedStepsCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Tracker.warnSkippedStep = PrefsDialog.this.skippedStepsCheckbox.isSelected();
            }
        });
        dataGapSubPanel.add(this.skippedStepsCheckbox);
        horz = Box.createHorizontalBox();
        box.add(horz);
        JPanel footprintSubPanel = new JPanel();
        horz.add(footprintSubPanel);
        footprintSubPanel.setBackground(color);
        this.pointmassFootprintSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.PointMassFootprint.BorderTitle"));
        footprintSubPanel.setBorder(BorderFactory.createCompoundBorder(etched, this.pointmassFootprintSubPanelBorder));
        this.footprintDropdown = new JComboBox();
        this.footprintDropdown.setRenderer(new FootprintRenderer());
        Footprint[] footprints = new Footprint[PointMass.footprintNames.length];
        int i = 0;
        while (i < footprints.length) {
            String name = PointMass.footprintNames[i];
            footprints[i] = name.equals("CircleFootprint.Circle") ? CircleFootprint.getFootprint(name) : PointShapeFootprint.getFootprint(name);
            ++i;
        }
        i = 0;
        while (i < footprints.length) {
            this.footprintDropdown.addItem(footprints[i]);
            ++i;
        }
        footprintSubPanel.add(this.footprintDropdown);
        final ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrefsDialog.this.footprintDropdown.repaint();
            }
        };
        this.footprintDropdown.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PrefsDialog.this.refreshing) {
                    return;
                }
                Footprint footprint = (Footprint)PrefsDialog.this.footprintDropdown.getSelectedItem();
                if (footprint instanceof CircleFootprint) {
                    CircleFootprint cfp = (CircleFootprint)footprint;
                    cfp.showProperties(PrefsDialog.this.frame, al);
                    Tracker.preferredPointMassFootprint = String.valueOf(footprint.getName()) + "#" + cfp.getProperties();
                } else {
                    Tracker.preferredPointMassFootprint = footprint.getName();
                }
            }
        });
        JPanel trailLengthSubPanel = new JPanel();
        trailLengthSubPanel.setBorder(BorderFactory.createCompoundBorder(etched, this.trailLengthSubPanelBorder));
        horz.add(trailLengthSubPanel);
        trailLengthSubPanel.setBackground(color);
        this.trailLengthSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.Trails.BorderTitle"));
        trailLengthSubPanel.setBorder(BorderFactory.createCompoundBorder(etched, this.trailLengthSubPanelBorder));
        this.trailLengthDropdown = new JComboBox();
        this.trailLengthDropdown.addItem(TrackerRes.getString("TrackControl.TrailMenu.NoTrail"));
        this.trailLengthDropdown.addItem(TrackerRes.getString("TrackControl.TrailMenu.ShortTrail"));
        this.trailLengthDropdown.addItem(TrackerRes.getString("TrackControl.TrailMenu.LongTrail"));
        this.trailLengthDropdown.addItem(TrackerRes.getString("TrackControl.TrailMenu.FullTrail"));
        trailLengthSubPanel.add(this.trailLengthDropdown);
        this.generalPanel = new JPanel(new BorderLayout());
        box = Box.createVerticalBox();
        this.generalPanel.add((Component)box, "Center");
        if (!OSPRuntime.isJS) {
            JPanel recentSubPanel = new JPanel();
            box.add(recentSubPanel);
            recentSubPanel.setBackground(color);
            this.recentSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.RecentFiles.BorderTitle"));
            recentSubPanel.setBorder(BorderFactory.createCompoundBorder(etched, this.recentSubPanelBorder));
            this.clearRecentButton = new JButton();
            this.clearRecentButton.setEnabled(!Tracker.recentFiles.isEmpty());
            this.clearRecentButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Tracker.recentFiles.clear();
                    if (PrefsDialog.this.panelID != null) {
                        PrefsDialog.this.frame.refreshMenus(PrefsDialog.this.frame.getTrackerPanelForID(PrefsDialog.this.panelID), "PrefsDialog.clearRecent");
                    }
                    PrefsDialog.this.clearRecentButton.setEnabled(false);
                }
            });
            recentSubPanel.add(this.clearRecentButton);
            JPanel spinnerPanel = new JPanel();
            spinnerPanel.setOpaque(false);
            spinnerPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            SpinnerNumberModel model = new SpinnerNumberModel(Tracker.recentFilesSize, 0, 12, 1);
            this.recentSizeSpinner = new JSpinner(model);
            JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.recentSizeSpinner, "0");
            editor.getTextField().setHorizontalAlignment(2);
            this.recentSizeSpinner.setEditor(editor);
            spinnerPanel.add(this.recentSizeSpinner);
            this.recentSizeLabel = new JLabel();
            spinnerPanel.add(this.recentSizeLabel);
            recentSubPanel.add(spinnerPanel);
        }
        if (!OSPRuntime.isJS) {
            JPanel cacheSubPanel = new JPanel(new BorderLayout());
            box.add(cacheSubPanel);
            cacheSubPanel.setBackground(color);
            this.cacheSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.CacheFiles.BorderTitle"));
            cacheSubPanel.setBorder(BorderFactory.createCompoundBorder(etched, this.cacheSubPanelBorder));
            JPanel cacheNorthPanel = new JPanel();
            cacheNorthPanel.setBackground(color);
            this.cacheLabel = new JLabel();
            cacheNorthPanel.add(this.cacheLabel);
            this.cacheField = new JTextField(27);
            cacheNorthPanel.add(this.cacheField);
            this.cacheField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    PrefsDialog.this.cacheField.setBackground(Color.yellow);
                }
            });
            this.cacheField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (PrefsDialog.this.cacheField.getBackground() == Color.yellow) {
                        PrefsDialog.this.setCache(null);
                    }
                }
            });
            this.cacheField.addActionListener(e -> this.setCache(null));
            this.browseCacheButton = new TButton(openFileIcon);
            this.browseCacheButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File cache = ResourceLoader.getOSPCache();
                    Desktop desktop = Desktop.getDesktop();
                    try {
                        desktop.open(cache);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            this.browseCacheButton.setBorder(buttonBorder);
            this.browseCacheButton.setContentAreaFilled(false);
            cacheNorthPanel.add(this.browseCacheButton);
            cacheSubPanel.add((Component)cacheNorthPanel, "North");
            JPanel cacheSouthPanel = new JPanel();
            cacheSouthPanel.setBackground(color);
            this.clearHostButton = new JButton();
            this.clearHostButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File cache = ResourceLoader.getOSPCache();
                    if (cache == null) {
                        return;
                    }
                    final File[] hosts = cache.listFiles(ResourceLoader.OSP_CACHE_FILTER);
                    JPopupMenu popup = new JPopupMenu();
                    ActionListener clearAction = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            File[] fileArray = hosts;
                            int n = hosts.length;
                            int n2 = 0;
                            while (n2 < n) {
                                File host = fileArray[n2];
                                if (host.getAbsolutePath().equals(e.getActionCommand())) {
                                    ResourceLoader.clearOSPCacheHost(host);
                                    PrefsDialog.this.refreshTextFields();
                                    return;
                                }
                                ++n2;
                            }
                        }
                    };
                    File[] fileArray = hosts;
                    int n = hosts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File next = fileArray[n2];
                        String host = next.getName().substring(4).replace('_', '.');
                        long bytes = PrefsDialog.this.getFileSize(next);
                        long size = bytes / 0x100000L;
                        if (bytes > 0L) {
                            host = size > 0L ? String.valueOf(host) + " (" + size + " MB)" : String.valueOf(host) + " (" + bytes / 1024L + " kB)";
                        }
                        JMenuItem item = new JMenuItem(host);
                        item.setActionCommand(next.getAbsolutePath());
                        popup.add(item);
                        item.addActionListener(clearAction);
                        ++n2;
                    }
                    FontSizer.setFonts(popup, FontSizer.getLevel());
                    popup.show(PrefsDialog.this.clearHostButton, 0, PrefsDialog.this.clearHostButton.getHeight());
                }
            });
            cacheSouthPanel.add(this.clearHostButton);
            this.clearCacheButton = new JButton();
            this.clearCacheButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File cache = ResourceLoader.getOSPCache();
                    ResourceLoader.clearOSPCache(cache, false);
                    PrefsDialog.this.refreshTextFields();
                }
            });
            cacheSouthPanel.add(this.clearCacheButton);
            this.setCacheButton = new JButton();
            this.setCacheButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File newCache = ResourceLoader.chooseOSPCache(PrefsDialog.this.frame);
                    if (newCache != null) {
                        PrefsDialog.this.setCache(newCache.getPath());
                    }
                }
            });
            cacheSouthPanel.add(this.setCacheButton);
            cacheSubPanel.add((Component)cacheSouthPanel, "South");
        }
        this.logLevelDropdown = new JComboBox();
        String defaultLevel = TrackerRes.getString("PrefsDialog.Version.Default").toUpperCase();
        String selected = defaultLevel = String.valueOf(defaultLevel) + " (" + Tracker.DEFAULT_LOG_LEVEL.toString().toLowerCase() + ")";
        this.logLevelDropdown.addItem(defaultLevel);
        int i2 = OSPLog.levels.length - 1;
        while (i2 >= 0) {
            String s = OSPLog.levels[i2].toString();
            this.logLevelDropdown.addItem(s);
            if (OSPLog.levels[i2].equals(Tracker.preferredLogLevel) && !Tracker.preferredLogLevel.equals(Tracker.DEFAULT_LOG_LEVEL)) {
                selected = s;
            }
            --i2;
        }
        this.logLevelDropdown.setSelectedItem(selected);
        this.logLevelDropdown.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String s = PrefsDialog.this.logLevelDropdown.getSelectedItem().toString();
                Level level = OSPLog.parseLevel(s);
                if (level == null) {
                    level = Tracker.DEFAULT_LOG_LEVEL;
                }
                Tracker.preferredLogLevel = level;
            }
        });
        JPanel logLevelSubPanel = new JPanel();
        box.add(logLevelSubPanel);
        logLevelSubPanel.setBackground(color);
        this.logLevelSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.LogLevel.BorderTitle"));
        logLevelSubPanel.setBorder(BorderFactory.createCompoundBorder(etched, this.logLevelSubPanelBorder));
        logLevelSubPanel.add(this.logLevelDropdown);
        if (!OSPRuntime.isJS) {
            this.checkForUpgradeButton = new JButton();
            this.checkForUpgradeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Tracker.showUpgradeStatus(PrefsDialog.this.frame.getTrackerPanelForID(PrefsDialog.this.panelID));
                }
            });
            this.checkForUpgradeDropdown = new JComboBox();
            selected = null;
            for (String next : Tracker.checkForUpgradeChoices) {
                String s = TrackerRes.getString(next);
                this.checkForUpgradeDropdown.addItem(s);
                if (!Tracker.checkForUpgradeIntervals.get(next).equals(Tracker.checkForUpgradeInterval)) continue;
                selected = s;
            }
            this.checkForUpgradeDropdown.setSelectedItem(selected);
            this.checkForUpgradeDropdown.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String s = PrefsDialog.this.checkForUpgradeDropdown.getSelectedItem().toString();
                    for (String next : Tracker.checkForUpgradeChoices) {
                        if (!s.equals(TrackerRes.getString(next))) continue;
                        Tracker.checkForUpgradeInterval = Tracker.checkForUpgradeIntervals.get(next);
                        break;
                    }
                }
            });
            JPanel dropdownPanel = new JPanel();
            dropdownPanel.setOpaque(false);
            dropdownPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            JPanel upgradeSubPanel = new JPanel();
            box.add(upgradeSubPanel);
            upgradeSubPanel.setBackground(color);
            this.upgradeSubPanelBorder = BorderFactory.createTitledBorder(TrackerRes.getString("PrefsDialog.Upgrades.BorderTitle"));
            upgradeSubPanel.setBorder(BorderFactory.createCompoundBorder(etched, this.upgradeSubPanelBorder));
            upgradeSubPanel.add(this.checkForUpgradeButton);
            dropdownPanel.add(this.checkForUpgradeDropdown);
            upgradeSubPanel.add(dropdownPanel);
        }
        if (!OSPRuntime.isJS) {
            this.tabbedPane.addTab(null, this.runtimePanel);
        }
        this.tabbedPane.addTab(null, this.displayPanel);
        this.tabbedPane.addTab(null, this.videoPanel);
        this.tabbedPane.addTab(null, this.actionsPanel);
        if (!OSPRuntime.isJS) {
            this.tabbedPane.addTab(null, this.generalPanel);
            this.tabbedPane.addTab(null, this.configPanel);
        }
        this.mainButtonBar = new JPanel();
        this.mainButtonBar.add(this.relaunchButton);
        this.mainButtonBar.add(this.okButton);
        this.mainButtonBar.add(this.cancelButton);
        contentPane.add((Component)this.mainButtonBar, "South");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PrefsDialog.this.tabbedPane.getSelectedComponent() == PrefsDialog.this.runtimePanel) {
                    PrefsDialog.this.defaultMemoryCheckbox.setEnabled(!OSPRuntime.isWebStart());
                    if (OSPRuntime.isWebStart() && !webStartWarningShown) {
                        webStartWarningShown = true;
                        JOptionPane.showMessageDialog(PrefsDialog.this, TrackerRes.getString("PrefsDialog.Dialog.WebStart.Message"), TrackerRes.getString("PrefsDialog.Dialog.WebStart.Title"), 1);
                    }
                }
            }
        });
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.vm32Button);
        buttonGroup.add(this.vm64Button);
        if (!OSPRuntime.isJS) {
            buttonGroup = new ButtonGroup();
            buttonGroup.add(this.movieEngineButton);
            buttonGroup.add(this.noEngineButton);
            this.xuggleFastButton.setEnabled(this.movieEngineButton.isSelected());
            this.xuggleSlowButton.setEnabled(this.movieEngineButton.isSelected());
            this.xuggleErrorCheckbox.setEnabled(this.movieEngineButton.isSelected());
            if (OSPRuntime.isWindows()) {
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        PrefsDialog.this.vm32Button.setEnabled(!JREFinder.getFinder().getJREs(32).isEmpty());
                        PrefsDialog.this.vm64Button.setEnabled(!JREFinder.getFinder().getJREs(64).isEmpty());
                    }
                };
                new Thread(runner).start();
            } else if (OSPRuntime.isLinux()) {
                int bitness = OSPRuntime.getVMBitness();
                this.vm32Button.setEnabled(bitness == 32);
                this.vm64Button.setEnabled(bitness == 64);
            } else if (OSPRuntime.isMac()) {
                this.vm32Button.setEnabled(false);
                this.vm64Button.setEnabled(true);
            }
        }
        this.refreshGUI();
    }

    protected void setCache(String path) {
        if (path == null) {
            path = this.cacheField.getText();
        } else {
            this.cacheField.setText(path);
        }
        ResourceLoader.setOSPCache(XML.stripExtension(path));
        this.refreshTextFields();
    }

    private void savePrevious() {
        this.prevEnabled.clear();
        if (this.panelID != null) {
            TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
            this.prevEnabled.addAll(trackerPanel.getEnabled());
            trackerPanel.taintEnabled();
        }
        this.prevLogLevel = Tracker.preferredLogLevel;
        this.prevMemory = Tracker.preferredMemorySize;
        this.prevLookFeel = Tracker.lookAndFeel;
        this.prevRecentCount = Tracker.recentFilesSize;
        this.prevLocaleName = Tracker.preferredLocale;
        this.prevFontLevel = Tracker.preferredFontLevel;
        this.prevFontLevelPlus = Tracker.preferredFontLevelPlus;
        this.prevHints = Tracker.showHintsByDefault;
        this.prevRadians = Tracker.isRadians;
        this.prevDecimalSeparator = Tracker.preferredDecimalSeparator;
        this.prevFastXuggle = Tracker.isXuggleFast;
        this.prevJRE = Tracker.preferredJRE;
        this.prevTrackerJar = Tracker.preferredTrackerJar;
        this.prevExecutables = Tracker.prelaunchExecutables;
        this.prevWarnNoVideoEngine = Tracker.warnNoVideoEngine;
        this.prevWarnXuggleError = Tracker.warnXuggleError;
        this.prevWarnVariableDuration = Tracker.warnVariableDuration;
        this.prevMarkAtCurrentFrame = Tracker.markAtCurrentFrame;
        this.prevCache = ResourceLoader.getOSPCache();
        this.prevUpgradeInterval = Tracker.checkForUpgradeInterval;
        this.prevEngine = MovieFactory.getMovieEngineName(false);
        this.prevZoomMouseWheel = Tracker.scrubMouseWheel;
        this.prevCenterCalibrationStick = Tracker.centerCalibrationStick;
        this.prevAutofill = Tracker.enableAutofill;
        this.prevShowGaps = Tracker.showGaps;
        this.prevTrailLengthIndex = Tracker.preferredTrailLengthIndex;
        this.prevPointmassFootprint = Tracker.preferredPointMassFootprint;
    }

    private void revert() {
        if (this.panelID != null) {
            this.frame.getTrackerPanelForID(this.panelID).setEnabled(this.prevEnabled);
        }
        Tracker.preferredPointMassFootprint = this.prevPointmassFootprint;
        Tracker.preferredMemorySize = this.prevMemory;
        Tracker.lookAndFeel = this.prevLookFeel;
        Tracker.recentFilesSize = this.prevRecentCount;
        Tracker.preferredLogLevel = this.prevLogLevel;
        Tracker.setPreferredLocale(this.prevLocaleName);
        Tracker.preferredFontLevel = this.prevFontLevel;
        Tracker.preferredFontLevelPlus = this.prevFontLevelPlus;
        Tracker.showHintsByDefault = this.prevHints;
        Tracker.isRadians = this.prevRadians;
        Tracker.preferredDecimalSeparator = this.prevDecimalSeparator;
        Tracker.isXuggleFast = this.prevFastXuggle;
        Tracker.preferredJRE = this.prevJRE;
        Tracker.preferredTrackerJar = this.prevTrackerJar;
        Tracker.prelaunchExecutables = this.prevExecutables;
        Tracker.warnNoVideoEngine = this.prevWarnNoVideoEngine;
        Tracker.warnXuggleError = this.prevWarnXuggleError;
        Tracker.warnVariableDuration = this.prevWarnVariableDuration;
        Tracker.scrubMouseWheel = this.prevZoomMouseWheel;
        Tracker.markAtCurrentFrame = this.prevMarkAtCurrentFrame;
        Tracker.centerCalibrationStick = this.prevCenterCalibrationStick;
        Tracker.enableAutofill = this.prevAutofill;
        Tracker.showGaps = this.prevShowGaps;
        Tracker.preferredTrailLengthIndex = this.prevTrailLengthIndex;
        ResourceLoader.setOSPCache(this.prevCache);
        Tracker.checkForUpgradeInterval = this.prevUpgradeInterval;
        if (!OSPRuntime.isJS) {
            int vmBitness = OSPRuntime.getVMBitness();
            if (vmBitness == 32) {
                this.vm32Button.setSelected(true);
            } else {
                this.vm64Button.setSelected(true);
            }
        }
    }

    private void updateConfig() {
        if (this.panelID == null) {
            return;
        }
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        Component[] checkboxes = this.checkPanel.getComponents();
        int i = 0;
        while (i < checkboxes.length) {
            JCheckBoxMenuItem checkbox = (JCheckBoxMenuItem)checkboxes[i];
            if (checkbox.isSelected()) {
                trackerPanel.getEnabled().add(checkbox.getText());
            } else {
                trackerPanel.getEnabled().remove(checkbox.getText());
            }
            trackerPanel.taintEnabled();
            ++i;
        }
    }

    protected void refreshGUI() {
        this.unitsSubPanelBorder.setTitle(TrackerRes.getString("TMenuBar.Menu.AngleUnits"));
        this.resetToStep0SubPanelBorder.setTitle(TrackerRes.getString("PrefsDialog.Marking.BorderTitle"));
        this.dataGapSubPanelBorder.setTitle(TrackerRes.getString("PrefsDialog.DataGap.BorderTitle"));
        this.trailLengthSubPanelBorder.setTitle(TrackerRes.getString("PrefsDialog.Trails.BorderTitle"));
        this.decimalSeparatorBorder.setTitle(TrackerRes.getString("NumberFormatSetter.TitledBorder.DecimalSeparator.Text"));
        this.defaultDecimalButton.setText(TrackerRes.getString("NumberFormatSetter.Button.DecimalSeparator.Default"));
        this.periodDecimalButton.setText(TrackerRes.getString("NumberFormatSetter.Button.DecimalSeparator.Period"));
        this.commaDecimalButton.setText(TrackerRes.getString("NumberFormatSetter.Button.DecimalSeparator.Comma"));
        this.defaultDecimalButton.setSelected(OSPRuntime.getPreferredDecimalSeparator() == null);
        this.periodDecimalButton.setSelected(".".equals(OSPRuntime.getPreferredDecimalSeparator()));
        this.commaDecimalButton.setSelected(",".equals(OSPRuntime.getPreferredDecimalSeparator()));
        this.cancelButton.setText(TrackerRes.getString("Dialog.Button.Cancel"));
        this.okButton.setText(TrackerRes.getString("Dialog.Button.OK"));
        this.relaunchButton.setText(TrackerRes.getString("PrefsDialog.Button.Relaunch"));
        this.resetToStep0Checkbox.setText(TrackerRes.getString("PrefsDialog.Checkbox.ResetToZero.Text"));
        this.autofillCheckbox.setText(TrackerRes.getString("PrefsDialog.Checkbox.Autofill.Text"));
        this.showGapsCheckbox.setText(TrackerRes.getString("PrefsDialog.Checkbox.ShowGaps.Text"));
        this.radiansButton.setText(TrackerRes.getString("TMenuBar.MenuItem.Radians"));
        this.degreesButton.setText(TrackerRes.getString("TMenuBar.MenuItem.Degrees"));
        this.markStickEndsButton.setText(TrackerRes.getString("PrefsDialog.Button.MarkEnds"));
        this.centerStickButton.setText(TrackerRes.getString("PrefsDialog.Button.Center"));
        this.scrubButton.setText(TrackerRes.getString("PrefsDialog.Button.Scrub"));
        this.zoomButton.setText(TrackerRes.getString("PrefsDialog.Button.Zoom"));
        this.mouseWheelSubPanelBorder.setTitle(TrackerRes.getString("PrefsDialog.Mousewheel.BorderTitle"));
        this.variableDurationCheckBox.setText(TrackerRes.getString("PrefsDialog.Checkbox.WarnVariableDuration"));
        this.setTabTitle(this.displayPanel, TrackerRes.getString("PrefsDialog.Tab.Display.Title"));
        this.setTabTitle(this.actionsPanel, TrackerRes.getString("PrefsDialog.Tab.Tracking.Title"));
        this.setTabTitle(this.videoPanel, TrackerRes.getString("PrefsDialog.Tab.Video.Title"));
        if (!OSPRuntime.isJS) {
            this.setTabTitle(this.generalPanel, TrackerRes.getString("PrefsDialog.Tab.General.Title"));
            this.hintsCheckbox.setText(TrackerRes.getString("PrefsDialog.Checkbox.HintsOn"));
            this.logLevelSubPanelBorder.setTitle(TrackerRes.getString("PrefsDialog.LogLevel.BorderTitle"));
            this.fontSubPanelBorder.setTitle(TrackerRes.getString("PrefsDialog.FontSize.BorderTitle"));
            this.langSubPanelBorder.setTitle(TrackerRes.getString("PrefsDialog.Language.BorderTitle"));
            this.hintsSubPanelBorder.setTitle(TrackerRes.getString("PrefsDialog.Hints.BorderTitle"));
            this.checkPanelBorder.setTitle(TrackerRes.getString("ConfigInspector.Border.Title"));
            this.versionSubPanelBorder.setTitle(TrackerRes.getString("PrefsDialog.Version.BorderTitle"));
            this.jreSubPanelBorder.setTitle(TrackerRes.getString("PrefsDialog.JRE.BorderTitle"));
            this.memorySubPanelBorder.setTitle(TrackerRes.getString("PrefsDialog.Memory.BorderTitle"));
            this.recentSubPanelBorder.setTitle(TrackerRes.getString("PrefsDialog.RecentFiles.BorderTitle"));
            this.defaultMemoryCheckbox.setText(TrackerRes.getString("PrefsDialog.Checkbox.DefaultSize"));
            this.applyButton.setText(TrackerRes.getString("Dialog.Button.Apply"));
            this.applyButton.setEnabled(this.panelID != null);
            this.allButton.setText(TrackerRes.getString("Dialog.Button.All"));
            this.noneButton.setText(TrackerRes.getString("Dialog.Button.None"));
            this.cacheLabel.setText(String.valueOf(TrackerRes.getString("PrefsDialog.Label.Path")) + ":");
            this.clearCacheButton.setToolTipText(TrackerRes.getString("PrefsDialog.Button.ClearCache.Tooltip"));
            this.clearHostButton.setText(TrackerRes.getString("PrefsDialog.Button.ClearHost"));
            this.clearHostButton.setToolTipText(TrackerRes.getString("PrefsDialog.Button.ClearHost.Tooltip"));
            this.setCacheButton.setText(TrackerRes.getString("PrefsDialog.Button.SetCache"));
            this.saveButton.setText(TrackerRes.getString("ConfigInspector.Button.SaveAsDefault"));
            this.checkForUpgradeButton.setText(TrackerRes.getString("PrefsDialog.Button.CheckForUpgrade"));
            this.vm32Button.setText(TrackerRes.getString("PrefsDialog.Checkbox.32BitVM"));
            this.vm64Button.setText(TrackerRes.getString("PrefsDialog.Checkbox.64BitVM"));
            this.movieEngineButton.setText(TrackerRes.getString("PrefsDialog.Button.Xuggle"));
            this.noEngineButton.setText(TrackerRes.getString("PrefsDialog.Button.NoEngine"));
            this.xuggleFastButton.setText(TrackerRes.getString("PrefsDialog.Xuggle.Fast"));
            this.xuggleSlowButton.setText(TrackerRes.getString("PrefsDialog.Xuggle.Slow"));
            this.vidWarningCheckbox.setText(TrackerRes.getString("PrefsDialog.Checkbox.WarnIfNoEngine"));
            this.skippedStepsCheckbox.setText(TrackerRes.getString("PrefsDialog.Checkbox.WarnSkippedSteps"));
            this.xuggleErrorCheckbox.setText(TrackerRes.getString("PrefsDialog.Checkbox.WarnIfXuggleError"));
            this.xuggleSpeedSubPanelBorder.setTitle(TrackerRes.getString("PrefsDialog.Xuggle.Speed.BorderTitle"));
            this.warningsSubPanelBorder.setTitle(TrackerRes.getString("PrefsDialog.NoVideoWarning.BorderTitle"));
            this.cacheSubPanelBorder.setTitle(TrackerRes.getString("PrefsDialog.CacheFiles.BorderTitle"));
            this.upgradeSubPanelBorder.setTitle(TrackerRes.getString("PrefsDialog.Upgrades.BorderTitle"));
            this.runSubPanelBorder.setTitle(TrackerRes.getString("PrefsDialog.Run.BorderTitle"));
            this.clearRecentButton.setText(TrackerRes.getString("PrefsDialog.Button.ClearRecent"));
            this.recentSizeLabel.setText(TrackerRes.getString("PrefsDialog.Label.RecentSize"));
            this.setTabTitle(this.configPanel, TrackerRes.getString("PrefsDialog.Tab.Configuration.Title"));
            this.setTabTitle(this.runtimePanel, TrackerRes.getString("PrefsDialog.Tab.Runtime.Title"));
            this.refreshTextFields();
        }
        this.setFontLevel(FontSizer.getLevel());
        if (this.trailLengthDropdown != null) {
            this.trailLengthDropdown.removeAllItems();
            this.trailLengthDropdown.addItem(TrackerRes.getString("TrackControl.TrailMenu.NoTrail"));
            this.trailLengthDropdown.addItem(TrackerRes.getString("TrackControl.TrailMenu.ShortTrail"));
            this.trailLengthDropdown.addItem(TrackerRes.getString("TrackControl.TrailMenu.LongTrail"));
            this.trailLengthDropdown.addItem(TrackerRes.getString("TrackControl.TrailMenu.FullTrail"));
        }
        this.pack();
        this.updateDisplay();
    }

    private void refreshJREDropdown(final int vmBitness) {
        if (String.valueOf(vmBitness).equals(this.jreDropdown.getName())) {
            return;
        }
        this.jreDropdown.setName(String.valueOf(vmBitness));
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                while (!JREFinder.isReady()) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                Runnable refresher = new Runnable(){

                    @Override
                    public void run() {
                        (this).PrefsDialog.this.jreDropdown.removeAllItems();
                        JREFinder jreFinder = JREFinder.getFinder();
                        TreeSet<File> availableJREs = jreFinder.getJREs(vmBitness);
                        ArrayList<String> availableJREPaths = new ArrayList<String>();
                        String path = Tracker.trackerHome;
                        if (OSPRuntime.isMac()) {
                            path = String.valueOf(new File(Tracker.trackerHome).getParent()) + "/runtime";
                        }
                        String[] bundledVMs = TrackerStarter.findBundledVMs();
                        String bundledVM = vmBitness == 32 && OSPRuntime.isWindows() ? bundledVMs[1] : bundledVMs[0];
                        File defaultVM = jreFinder.getDefaultJRE(vmBitness, path, true, null);
                        for (File next : availableJREs) {
                            String jrePath = next.getPath();
                            if (bundledVM != null && jrePath.equals(bundledVM)) {
                                availableJREPaths.add(jrePath);
                                (this).PrefsDialog.this.jreDropdown.insertItemAt(String.valueOf(TrackerRes.getString("PrefsDialog.JREDropdown.BundledJRE")) + " " + jrePath, 0);
                                continue;
                            }
                            if (defaultVM != null && jrePath.equals(defaultVM.getPath()) && bundledVM == null) {
                                availableJREPaths.add(jrePath);
                                (this).PrefsDialog.this.jreDropdown.insertItemAt(TrackerRes.getString("PrefsDialog.JREDropdown.LatestJRE"), 0);
                                (this).PrefsDialog.this.jreDropdown.addItem(jrePath);
                                continue;
                            }
                            availableJREPaths.add(jrePath);
                            (this).PrefsDialog.this.jreDropdown.addItem(jrePath);
                        }
                        String selectedItem = Tracker.preferredJRE;
                        if (selectedItem == null || !availableJREPaths.contains(selectedItem)) {
                            selectedItem = bundledVM != null ? String.valueOf(TrackerRes.getString("PrefsDialog.JREDropdown.BundledJRE")) + " " + bundledVM : TrackerRes.getString("PrefsDialog.JREDropdown.LatestJRE");
                        }
                        (this).PrefsDialog.this.jreDropdown.setSelectedItem(selectedItem);
                        if (vmBitness == 32 && (this).PrefsDialog.this.relaunching && !"cancel".equals((this).PrefsDialog.this.vm32Button.getName())) {
                            (this).PrefsDialog.this.relaunching = false;
                            (this).PrefsDialog.this.relaunchButton.doClick(0);
                        }
                    }
                };
                SwingUtilities.invokeLater(refresher);
            }
        };
        new Thread(runner).start();
    }

    private void refreshTextFields() {
        int n = (Integer)this.runSpinner.getValue();
        if (Tracker.prelaunchExecutables.length > n && Tracker.prelaunchExecutables[n] != null) {
            this.runField.setText(Tracker.prelaunchExecutables[n]);
            this.runField.setToolTipText(Tracker.prelaunchExecutables[n]);
            this.runField.setBackground(new File(Tracker.prelaunchExecutables[n]).exists() ? Color.white : MEDIUM_RED);
        } else {
            this.runField.setText(null);
            this.runField.setToolTipText(null);
            this.runField.setBackground(Color.white);
        }
        String s = TrackerRes.getString("PrefsDialog.Button.ClearCache");
        File cache = ResourceLoader.getOSPCache();
        if (cache != null) {
            this.cacheField.setText(cache.getPath());
            this.cacheField.setToolTipText(cache.getAbsolutePath());
            this.cacheField.setBackground(cache.canWrite() ? Color.white : MEDIUM_RED);
            long bytes = this.getFileSize(cache);
            long size = bytes / 0x100000L;
            if (bytes > 0L) {
                s = size > 0L ? String.valueOf(s) + " (" + size + " MB)" : String.valueOf(s) + " (" + bytes / 1024L + " kB)";
            }
        } else {
            this.cacheField.setText("");
            this.cacheField.setToolTipText("");
            this.cacheField.setBackground(MEDIUM_RED);
        }
        this.clearCacheButton.setText(s);
        boolean isEmpty = cache == null || !cache.exists() || cache.listFiles(ResourceLoader.OSP_CACHE_FILTER).length == 0;
        this.clearCacheButton.setEnabled(!isEmpty);
        this.clearHostButton.setEnabled(!isEmpty);
    }

    private void applyPrefs() {
        String path;
        int index;
        TrackerPanel trackerPanel = this.panelID == null ? null : this.frame.getTrackerPanelForID(this.panelID);
        Tracker.showGaps = this.showGapsCheckbox.isSelected();
        if (this.trailLengthDropdown != null && (index = this.trailLengthDropdown.getSelectedIndex()) != Tracker.preferredTrailLengthIndex) {
            Tracker.preferredTrailLengthIndex = index;
            if (trackerPanel != null) {
                TToolBar toolbar = trackerPanel.getToolBar(true);
                toolbar.trailLengthIndex = Tracker.preferredTrailLengthIndex;
                toolbar.trailButton.setSelected(toolbar.trailLengthIndex != 0);
                toolbar.refresh("PrefsDialog");
            }
        }
        Tracker.isRadians = this.radiansButton.isSelected();
        if (this.frame != null) {
            this.frame.setAnglesInRadians(Tracker.isRadians);
        }
        if (!OSPRuntime.isJS) {
            Integer val = (Integer)this.recentSizeSpinner.getValue();
            Tracker.setRecentSize(val);
            if (trackerPanel != null) {
                trackerPanel.refreshMenus("PrefsDialog.applyPrefs");
            }
            this.updateConfig();
            Tracker.isXuggleFast = this.xuggleFastButton.isSelected();
            Tracker.preferredMemorySize = this.defaultMemoryCheckbox.isSelected() ? -1 : this.memoryField.getIntValue();
            Object selected = this.jreDropdown.getSelectedItem();
            if (selected != null && !selected.equals(Tracker.preferredJRE)) {
                Tracker.preferredJRE = selected.toString().startsWith(TrackerRes.getString("PrefsDialog.JREDropdown.BundledJRE")) ? null : (selected.equals(TrackerRes.getString("PrefsDialog.JREDropdown.LatestJRE")) ? null : selected.toString());
            }
        }
        if ((path = Tracker.savePreferences()) != null) {
            OSPLog.info("saved tracker preferences in " + XML.getAbsolutePath(new File(path)));
        }
    }

    private void saveConfigAsDefault() {
        Component[] checkboxes = this.checkPanel.getComponents();
        TreeSet<String> enabled = new TreeSet<String>();
        int i = 0;
        while (i < checkboxes.length) {
            JCheckBoxMenuItem checkbox = (JCheckBoxMenuItem)checkboxes[i];
            if (checkbox.isSelected()) {
                enabled.add(checkbox.getText());
            }
            ++i;
        }
        Tracker.setDefaultConfig(enabled);
    }

    protected void updateDisplay() {
        this.refreshing = true;
        if (this.footprintDropdown != null) {
            int selected = 0;
            int i = 0;
            while (i < this.footprintDropdown.getItemCount()) {
                Footprint footprint = this.footprintDropdown.getItemAt(i);
                if (Tracker.preferredPointMassFootprint != null && Tracker.preferredPointMassFootprint.startsWith(footprint.getName())) {
                    selected = i;
                    if (!(footprint instanceof CircleFootprint)) break;
                    CircleFootprint cfp = (CircleFootprint)footprint;
                    int n = Tracker.preferredPointMassFootprint.indexOf("#");
                    if (n <= -1) break;
                    cfp.setProperties(Tracker.preferredPointMassFootprint.substring(n + 1));
                    break;
                }
                ++i;
            }
            if (this.footprintDropdown.getItemCount() > selected) {
                this.footprintDropdown.setSelectedIndex(selected);
            }
        }
        int preferredLevel = Tracker.preferredFontLevel + Tracker.preferredFontLevelPlus;
        this.fontSizeDropdown.setSelectedIndex(preferredLevel);
        if (this.trailLengthDropdown != null) {
            this.trailLengthDropdown.setSelectedIndex(Tracker.preferredTrailLengthIndex);
        }
        this.showGapsCheckbox.setSelected(Tracker.showGaps);
        this.autofillCheckbox.setSelected(Tracker.enableAutofill);
        this.radiansButton.setSelected(Tracker.isRadians);
        this.degreesButton.setSelected(!Tracker.isRadians);
        this.resetToStep0Checkbox.setSelected(!Tracker.markAtCurrentFrame);
        if (Tracker.scrubMouseWheel) {
            this.scrubButton.setSelected(true);
        } else {
            this.zoomButton.setSelected(true);
        }
        if (Tracker.centerCalibrationStick) {
            this.centerStickButton.setSelected(true);
        } else {
            this.markStickEndsButton.setSelected(true);
        }
        if (!OSPRuntime.isJS) {
            String next;
            this.hintsCheckbox.setSelected(Tracker.showHintsByDefault);
            int index = 0;
            Locale[] locales = Tracker.getLocales();
            int i = 0;
            while (i < locales.length) {
                Locale next2 = locales[i];
                if (next2.equals(Locale.getDefault())) {
                    index = i + 1;
                    break;
                }
                ++i;
            }
            this.languageDropdown.setSelectedIndex(index);
            int selected = 0;
            if (!Tracker.preferredLogLevel.equals(Tracker.DEFAULT_LOG_LEVEL)) {
                int i2 = 1;
                int count = this.logLevelDropdown.getItemCount();
                while (i2 < count) {
                    String next3 = this.logLevelDropdown.getItemAt(i2).toString();
                    if (Tracker.preferredLogLevel.toString().equals(next3)) {
                        selected = i2;
                        break;
                    }
                    ++i2;
                }
            }
            if (this.logLevelDropdown.getItemCount() > selected) {
                this.logLevelDropdown.setSelectedIndex(selected);
            }
            this.recentSizeSpinner.setValue(Tracker.recentFilesSize);
            Component[] checkboxes = this.checkPanel.getComponents();
            Set<String> enabled = this.panelID == null ? Tracker.getDefaultConfig() : this.frame.getTrackerPanelForID(this.panelID).getEnabled();
            int i3 = 0;
            while (i3 < checkboxes.length) {
                JCheckBoxMenuItem checkbox = (JCheckBoxMenuItem)checkboxes[i3];
                checkbox.setSelected(enabled.contains(checkbox.getText()));
                ++i3;
            }
            this.vidWarningCheckbox.setSelected(Tracker.warnNoVideoEngine);
            this.variableDurationCheckBox.setSelected(Tracker.warnVariableDuration);
            this.xuggleErrorCheckbox.setSelected(Tracker.warnXuggleError);
            this.skippedStepsCheckbox.setSelected(Tracker.warnSkippedStep);
            this.defaultMemoryCheckbox.setSelected(Tracker.preferredMemorySize < 0);
            this.memoryField.setEnabled(Tracker.preferredMemorySize >= 0);
            this.memoryLabel.setEnabled(Tracker.preferredMemorySize >= 0);
            if (Tracker.preferredMemorySize >= 0) {
                this.memoryField.setValue(Tracker.preferredMemorySize);
            } else {
                this.memoryField.setText(null);
            }
            selected = 0;
            i3 = 0;
            int count = this.versionDropdown.getItemCount();
            while (i3 < count) {
                next = this.versionDropdown.getItemAt(i3).toString();
                if (Tracker.preferredTrackerJar != null && Tracker.preferredTrackerJar.indexOf(next) > -1 && Tracker.preferredTrackerJar.indexOf(".jar") - Tracker.preferredTrackerJar.indexOf(next) == next.length()) {
                    selected = i3;
                    break;
                }
                ++i3;
            }
            if (this.versionDropdown.getItemCount() > selected) {
                this.versionDropdown.setSelectedIndex(selected);
            }
            selected = 0;
            i3 = 0;
            count = this.jreDropdown.getItemCount();
            while (i3 < count) {
                next = this.jreDropdown.getItemAt(i3).toString();
                if (next.equals(Tracker.preferredJRE)) {
                    selected = i3;
                    break;
                }
                ++i3;
            }
            if (this.jreDropdown.getItemCount() > selected) {
                this.jreDropdown.setSelectedIndex(selected);
            }
            if (MovieFactory.hasVideoEngine()) {
                this.movieEngineButton.setSelected(true);
            }
            selected = 0;
            i3 = 1;
            count = Tracker.checkForUpgradeChoices.size();
            while (i3 < count) {
                next = Tracker.checkForUpgradeChoices.get(i3);
                if (Tracker.checkForUpgradeIntervals.get(next) == Tracker.checkForUpgradeInterval) {
                    selected = i3;
                    break;
                }
                ++i3;
            }
            if (this.checkForUpgradeDropdown.getItemCount() > selected) {
                this.checkForUpgradeDropdown.setSelectedIndex(selected);
            }
        }
        TFrame.repaintT(this);
        this.refreshing = false;
    }

    private void setTabTitle(JPanel tab, String title) {
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            if (this.tabbedPane.getComponentAt(i) == tab) {
                this.tabbedPane.setTitleAt(i, title);
            }
            ++i;
        }
    }

    public void relaunch64Bit() {
        this.relaunching = true;
        this.vm64Button.setSelected(true);
    }

    private long getFileSize(File folder) {
        File[] files;
        if (folder == null) {
            return 0L;
        }
        long foldersize = 0L;
        File cache = ResourceLoader.getOSPCache();
        File[] fileArray = files = folder.equals(cache) ? folder.listFiles(ResourceLoader.OSP_CACHE_FILTER) : folder.listFiles();
        if (files == null) {
            return 0L;
        }
        int i = 0;
        while (i < files.length) {
            foldersize = files[i].isDirectory() ? (foldersize += this.getFileSize(files[i])) : (foldersize += files[i].length());
            ++i;
        }
        return foldersize;
    }

    protected static JFileChooser getFileChooser(File file, boolean useJREFilter) {
        JFileChooser chooser = new JFileChooser(file);
        if (useJREFilter) {
            FileFilter folderFilter = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f == null) {
                        return false;
                    }
                    if (f.isDirectory()) {
                        return true;
                    }
                    if (f.getPath().indexOf("jre") > -1) {
                        return true;
                    }
                    return f.getPath().indexOf("jdk") > -1;
                }

                @Override
                public String getDescription() {
                    return TrackerRes.getString("PrefsDialog.FileFilter.JRE");
                }
            };
            if (OSPRuntime.isMac()) {
                chooser.setFileSelectionMode(2);
            } else {
                chooser.setFileSelectionMode(1);
            }
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.addChoosableFileFilter(folderFilter);
        }
        FontSizer.setFonts(chooser, FontSizer.getLevel());
        return chooser;
    }

    class FootprintRenderer
    extends JLabel
    implements ListCellRenderer<Footprint> {
        FootprintRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 0));
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Footprint> list, Footprint val, int index, boolean selected, boolean hasFocus) {
            if (selected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (val != null) {
                Footprint fp = val;
                String name = fp.getDisplayName();
                if (fp instanceof CircleFootprint) {
                    CircleFootprint cfp = (CircleFootprint)fp;
                    String[] props = cfp.getProperties().split(" ");
                    name = String.valueOf(name) + " r=" + props[0];
                }
                this.setText(name);
                this.setIcon(fp.getIcon(21, 16));
            }
            return this;
        }
    }
}

