/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.BitSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ToolTipManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.media.mov.MovieVideo;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ResourceLoader;

public class PropertiesDialog
extends JDialog {
    static final Color DARK_RED = new Color(220, 0, 0);
    static final Color MEDIUM_RED = new Color(255, 120, 140);
    static final Color LIGHT_RED = new Color(255, 180, 200);
    protected TFrame frame;
    protected Integer panelID;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JTextField authorField;
    protected JTextField contactField;
    protected JLabel authorLabel;
    protected JLabel contactLabel;
    protected JTabbedPane tabbedPane;
    protected JPanel metaPanel;
    protected JPanel videoPanel;
    protected JPanel trkPanel;
    protected JTable videoTable;
    protected JTable trkTable;
    protected PropertyCellRenderer cellRenderer = new PropertyCellRenderer();
    protected String[] vidProps = new String[6];
    protected String[] vidValues = new String[6];
    protected ArrayList<String> trkProps = new ArrayList();
    protected ArrayList<String> trkValues = new ArrayList();
    protected boolean hasVid;

    public PropertiesDialog(TrackerPanel panel) {
        super((Frame)panel.getTFrame(), true);
        this.frame = panel.getTFrame();
        this.panelID = panel.getID();
        this.createGUI();
        this.setFontLevel(FontSizer.getLevel());
        this.setLabelSizes();
        this.pack();
        this.okButton.requestFocusInWindow();
    }

    public void setFontLevel(int level) {
        FontSizer.setFonts(this, level);
        Font font = this.cellRenderer.getFont();
        font = FontSizer.getResizedFont(font, level);
        if (this.videoTable != null) {
            this.videoTable.setRowHeight(font.getSize() + 4);
        }
        if (this.trkTable != null) {
            this.trkTable.setRowHeight(font.getSize() + 4);
        }
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (!vis && !OSPRuntime.isJS) {
            this.dispose();
        }
    }

    private void createGUI() {
        Video video2;
        this.setTitle(TrackerRes.getString("PropertiesDialog.Title"));
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        this.tabbedPane = new JTabbedPane();
        contentPane.add((Component)this.tabbedPane, "Center");
        final TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        String path = XML.forwardSlash(trackerPanel.openedFromPath);
        String name = XML.getName(path);
        AbstractTableModel model = null;
        JButton button = null;
        JPanel buttonPanel = new JPanel();
        if (path != null && path.length() > 0) {
            model = new TRKTableModel();
            this.trkPanel = new JPanel(new BorderLayout());
            this.tabbedPane.addTab(TrackerRes.getString("PropertiesDialog.Tab.TrackerFile"), this.trkPanel);
            this.trkProps.add(TrackerRes.getString("TActions.Dialog.AboutVideo.Name"));
            this.trkProps.add(TrackerRes.getString("TActions.Dialog.AboutVideo.Path"));
            path = ResourceLoader.getNonURIPath(path);
            this.trkValues.add(name);
            this.trkValues.add(path);
            this.trkTable = new JTable(model);
            this.trkTable.setBackground(this.trkPanel.getBackground());
            this.trkTable.setDefaultRenderer(String.class, this.cellRenderer);
            this.trkTable.setSelectionMode(0);
            this.trkTable.setColumnSelectionAllowed(true);
            this.trkTable.getColumnModel().getColumn(0).setPreferredWidth(50);
            this.trkTable.getColumnModel().getColumn(1).setPreferredWidth(250);
            this.trkPanel.add((Component)this.trkTable.getTableHeader(), "North");
            this.trkPanel.add((Component)this.trkTable, "Center");
            ToolTipManager.sharedInstance().setInitialDelay(0);
            ToolTipManager.sharedInstance().setDismissDelay(20000);
            ToolTipManager.sharedInstance().registerComponent(this.trkTable);
            button = new JButton(TrackerRes.getString("PropertiesDialog.Button.CopyFilePath"));
            button.setForeground(new Color(0, 0, 102));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertiesDialog.this.trkTable.setRowSelectionInterval(1, 1);
                    PropertiesDialog.this.trkTable.setColumnSelectionInterval(1, 1);
                    String s = PropertiesDialog.this.trkTable.getValueAt(1, 1).toString();
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection stringSelection = new StringSelection(s);
                    clipboard.setContents(stringSelection, stringSelection);
                }
            });
            button.setEnabled(trackerPanel.openedFromPath != null);
            buttonPanel.add(button);
            this.trkPanel.add((Component)buttonPanel, "South");
        }
        this.hasVid = (video2 = trackerPanel.getVideo()) != null;
        VideoClip clip = trackerPanel.getPlayer().getVideoClip();
        if (this.hasVid || clip.getVideoPath() != null) {
            this.videoPanel = new JPanel(new BorderLayout());
            this.tabbedPane.addTab(TrackerRes.getString("TMenuBar.Menu.Video"), this.videoPanel);
            NumberFormat format = NumberFormat.getNumberInstance();
            format.setMinimumIntegerDigits(1);
            format.setMinimumFractionDigits(1);
            format.setMaximumFractionDigits(1);
            name = video2 == null ? null : XML.getName((String)video2.getProperty("name"));
            path = clip.getVideoPath();
            path = XML.forwardSlash(path);
            path = ResourceLoader.getNonURIPath(path);
            String type = null;
            String size = null;
            String length = null;
            String fps = null;
            if (video2 != null) {
                BitSet badFrames;
                VideoType videoType = (VideoType)video2.getProperty("video_type");
                type = videoType == null ? video2.getClass().getSimpleName() : videoType.getDescription();
                int n = type.lastIndexOf("(");
                if (n > -1) {
                    if (video2 instanceof MovieVideo) {
                        type = type.substring(0, n);
                        type = String.valueOf(type) + (OSPRuntime.isJS ? "(JS)" : "(Xuggle)");
                    } else if (video2 instanceof ImageVideo && video2.getProperty("ext") != null) {
                        String ext = (String)video2.getProperty("ext");
                        type = type.substring(0, n);
                        type = String.valueOf(type) + "(" + ext.toUpperCase() + ")";
                    }
                }
                Dimension d = video2.getImageSize(false);
                int w = d.width;
                int h = d.height;
                size = String.valueOf(w) + " x " + h;
                length = String.valueOf(video2.getFrameCount()) + " ";
                length = String.valueOf(length) + TrackerRes.getString("TActions.Dialog.AboutVideo.Frames");
                double dt = trackerPanel.getPlayer().getClipControl().getMeanFrameDuration();
                double frameRate = video2.getFrameCount() <= 1 ? 0.0 : 1000.0 / dt;
                String string = fps = frameRate == 0.0 ? "" : String.valueOf(format.format(frameRate)) + " ";
                if (frameRate > 0.0) {
                    fps = String.valueOf(fps) + TrackerRes.getString("TActions.Dialog.AboutVideo.FramesPerSecond");
                }
                if (!(badFrames = TrackerIO.findBadVideoFrames(trackerPanel, TrackerIO.defaultBadFrameTolerance, false, false, false)).isEmpty()) {
                    fps = String.valueOf(fps) + " (" + TrackerRes.getString("TActions.Dialog.AboutVideo.FramesPerSecond.NotConstant") + ")";
                }
            }
            this.vidProps[0] = TrackerRes.getString("TActions.Dialog.AboutVideo.Name");
            this.vidProps[1] = TrackerRes.getString("TActions.Dialog.AboutVideo.Path");
            this.vidProps[2] = TrackerRes.getString("TActions.Dialog.AboutVideo.Type");
            this.vidProps[3] = TrackerRes.getString("TActions.Dialog.AboutVideo.Size");
            this.vidProps[4] = TrackerRes.getString("TActions.Dialog.AboutVideo.Length");
            this.vidProps[5] = TrackerRes.getString("TActions.Dialog.AboutVideo.FrameRate");
            this.vidValues[0] = name;
            this.vidValues[1] = path;
            this.vidValues[2] = type;
            this.vidValues[3] = size;
            this.vidValues[4] = length;
            this.vidValues[5] = fps;
            model = new VideoTableModel();
            this.videoTable = new JTable(model);
            this.videoTable.setBackground(this.videoPanel.getBackground());
            this.videoTable.setDefaultRenderer(String.class, this.cellRenderer);
            this.videoTable.setSelectionMode(0);
            this.videoTable.setColumnSelectionAllowed(true);
            this.videoTable.getColumnModel().getColumn(0).setPreferredWidth(50);
            this.videoTable.getColumnModel().getColumn(1).setPreferredWidth(250);
            this.videoPanel.add((Component)this.videoTable.getTableHeader(), "North");
            this.videoPanel.add((Component)this.videoTable, "Center");
            ToolTipManager.sharedInstance().registerComponent(this.videoTable);
            button = new JButton(TrackerRes.getString("PropertiesDialog.Button.CopyVideoPath"));
            button.setForeground(new Color(0, 0, 102));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertiesDialog.this.videoTable.setRowSelectionInterval(1, 1);
                    PropertiesDialog.this.videoTable.setColumnSelectionInterval(1, 1);
                    String s = PropertiesDialog.this.videoTable.getValueAt(1, 1).toString();
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection stringSelection = new StringSelection(s);
                    clipboard.setContents(stringSelection, stringSelection);
                }
            });
            button.setEnabled(!path.equals(""));
            buttonPanel = new JPanel();
            buttonPanel.add(button);
            this.videoPanel.add((Component)buttonPanel, "South");
        }
        this.metaPanel = new JPanel(new BorderLayout());
        this.tabbedPane.addTab(TrackerRes.getString("PropertiesDialog.Tab.Metadata"), this.metaPanel);
        this.authorLabel = new JLabel(TrackerRes.getString("PropertiesDialog.Label.Author"));
        this.authorField = new JTextField(30);
        this.authorField.setText(trackerPanel.author);
        JToolBar authorbar = new JToolBar();
        authorbar.setBorder(BorderFactory.createEmptyBorder(6, 4, 2, 4));
        authorbar.setFloatable(false);
        authorbar.setOpaque(false);
        authorbar.add(this.authorLabel);
        authorbar.add(this.authorField);
        this.contactLabel = new JLabel(TrackerRes.getString("PropertiesDialog.Label.Contact"));
        this.contactField = new JTextField(30);
        this.contactField.setText(trackerPanel.contact);
        JToolBar contactbar = new JToolBar();
        contactbar.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        contactbar.setFloatable(false);
        contactbar.setOpaque(false);
        contactbar.add(this.contactLabel);
        contactbar.add(this.contactField);
        Box box = Box.createVerticalBox();
        box.add(authorbar);
        box.add(contactbar);
        this.metaPanel.add((Component)box, "North");
        this.okButton = new JButton(TrackerRes.getString("Dialog.Button.OK"));
        this.okButton.setForeground(new Color(0, 0, 102));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = PropertiesDialog.this.authorField.getText();
                trackerPanel.author = "".equals(s) ? null : s;
                s = PropertiesDialog.this.contactField.getText();
                trackerPanel.contact = "".equals(s) ? null : s;
                PropertiesDialog.this.setVisible(false);
            }
        });
        this.cancelButton = new JButton(TrackerRes.getString("Dialog.Button.Cancel"));
        this.cancelButton.setForeground(new Color(0, 0, 102));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesDialog.this.setVisible(false);
            }
        });
        JPanel buttonbar = new JPanel();
        buttonbar.setBorder(BorderFactory.createEmptyBorder(1, 0, 3, 0));
        contentPane.add((Component)buttonbar, "South");
        buttonbar.add(this.okButton);
        buttonbar.add(this.cancelButton);
    }

    private void setLabelSizes() {
        ArrayList<JLabel> labels = new ArrayList<JLabel>();
        labels.add(this.authorLabel);
        labels.add(this.contactLabel);
        Font font = this.authorLabel.getFont();
        int w = 0;
        for (JLabel next : labels) {
            Rectangle2D rect = font.getStringBounds(String.valueOf(next.getText()) + " ", OSPRuntime.frc);
            w = Math.max(w, (int)rect.getWidth() + 1);
        }
        Dimension labelSize = new Dimension(w, 20);
        for (JLabel next : labels) {
            next.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 2));
            next.setPreferredSize(labelSize);
            next.setHorizontalAlignment(11);
        }
    }

    class PropertyCellRenderer
    extends DefaultTableCellRenderer {
        PropertyCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object val, boolean selected, boolean hasFocus, int row, int col) {
            this.setToolTipText(row == 1 && col == 1 && val != null ? val.toString() : null);
            this.setBackground(Color.white);
            Component c = super.getTableCellRendererComponent(table, val, selected, hasFocus, row, col);
            boolean red = col == 1 && table == PropertiesDialog.this.videoTable && !PropertiesDialog.this.hasVid && val != null;
            this.setForeground(red ? DARK_RED : Color.black);
            if (red) {
                this.setBackground(selected ? MEDIUM_RED : LIGHT_RED);
            }
            return c;
        }
    }

    class TRKTableModel
    extends AbstractTableModel {
        TRKTableModel() {
        }

        @Override
        public int getRowCount() {
            return PropertiesDialog.this.trkProps.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return col == 0 ? PropertiesDialog.this.trkProps.get(row) : PropertiesDialog.this.trkValues.get(row);
        }

        @Override
        public String getColumnName(int col) {
            return col == 0 ? TrackerRes.getString("PropertiesDialog.Header.Property") : TrackerRes.getString("PropertiesDialog.Header.Value");
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return String.class;
        }
    }

    class VideoTableModel
    extends AbstractTableModel {
        VideoTableModel() {
        }

        @Override
        public int getRowCount() {
            return PropertiesDialog.this.vidProps.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return col == 0 ? PropertiesDialog.this.vidProps[row] : PropertiesDialog.this.vidValues[row];
        }

        @Override
        public String getColumnName(int col) {
            return col == 0 ? TrackerRes.getString("PropertiesDialog.Header.Property") : TrackerRes.getString("PropertiesDialog.Header.Value");
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return String.class;
        }
    }
}

