/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.opensourcephysics.cabrillo.tracker.AngleRuler;
import org.opensourcephysics.cabrillo.tracker.AttachmentDialog;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.InputTrack;
import org.opensourcephysics.cabrillo.tracker.NumberFormatDialog;
import org.opensourcephysics.cabrillo.tracker.PlotTView;
import org.opensourcephysics.cabrillo.tracker.PlotTrackView;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.ProtractorFootprint;
import org.opensourcephysics.cabrillo.tracker.ProtractorStep;
import org.opensourcephysics.cabrillo.tracker.Ruler;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.TableTView;
import org.opensourcephysics.cabrillo.tracker.TableTrackView;
import org.opensourcephysics.cabrillo.tracker.TrackPlottingPanel;
import org.opensourcephysics.cabrillo.tracker.TrackView;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPlayer;

public class Protractor
extends InputTrack {
    protected static final String[] dataVariables = new String[]{"t", Tracker.THETA, "L_{1}", "L_{2}", "step", "frame", String.valueOf(Tracker.THETA) + "_{rot}", TeXParser.parseTeX("$\\omega$"), TeXParser.parseTeX("$\\alpha$")};
    protected static final String[] fieldVariables = dataVariables;
    protected static final String[] formatVariables = new String[]{"t", "L", Tracker.THETA, TeXParser.parseTeX("$\\omega$"), TeXParser.parseTeX("$\\alpha$")};
    protected static final Map<String, String[]> formatMap = new HashMap<String, String[]>();
    protected static final Map<String, String> formatDescriptionMap;
    protected static final ArrayList<String> allVariables;
    protected JMenuItem attachmentItem;
    protected int firstDerivSpill = 1;
    protected int secondDerivSpill = 2;
    protected int[] params = new int[4];
    protected double[] rotationAngle = new double[5];
    protected boolean[] validData = new boolean[5];
    protected Object[] derivData;
    protected boolean needsRotationData;
    private static final String[] panelEventsProtractor;

    static {
        formatMap.put("t", new String[]{"t"});
        formatMap.put("L", new String[]{"L_{1}", "L_{2}"});
        formatMap.put(Tracker.THETA, new String[]{Tracker.THETA, String.valueOf(Tracker.THETA) + "_{rot}"});
        formatDescriptionMap = new HashMap<String, String>();
        formatDescriptionMap.put(formatVariables[0], TrackerRes.getString("PointMass.Data.Description.0"));
        formatDescriptionMap.put(formatVariables[1], TrackerRes.getString("TapeMeasure.Label.Length"));
        formatDescriptionMap.put(formatVariables[2], TrackerRes.getString("Vector.Data.Description.4"));
        allVariables = Protractor.createAllVariables(dataVariables, null);
        panelEventsProtractor = new String[]{"selectedtrack"};
    }

    @Override
    public String[] getFormatVariables() {
        return formatVariables;
    }

    @Override
    public Map<String, String[]> getFormatMap() {
        return formatMap;
    }

    @Override
    public Map<String, String> getFormatDescMap() {
        return formatDescriptionMap;
    }

    @Override
    public String getBaseType() {
        return "Protractor";
    }

    @Override
    public String getVarDimsImpl(String variable) {
        String[] vars = dataVariables;
        String[] names = formatVariables;
        if (names[1].equals(variable) || vars[2].equals(variable) || vars[3].equals(variable)) {
            return "L";
        }
        if (vars[4].equals(variable) || vars[5].equals(variable)) {
            return "I";
        }
        if (vars[7].equals(variable)) {
            return "A/T";
        }
        if (vars[8].equals(variable)) {
            return "A/TT";
        }
        return null;
    }

    public Protractor() {
        super(6);
        Object[] objectArray = new Object[4];
        objectArray[0] = this.params;
        objectArray[1] = this.rotationAngle;
        objectArray[3] = this.validData;
        this.derivData = objectArray;
        this.defaultColors = new Color[]{new Color(0, 140, 40)};
        this.setName(TrackerRes.getString("Protractor.New.Name"));
        this.setFootprints(new Footprint[]{ProtractorFootprint.getFootprint("ProtractorFootprint.Circle3"), ProtractorFootprint.getFootprint("ProtractorFootprint.Circle5"), ProtractorFootprint.getFootprint("ProtractorFootprint.Circle3Bold"), ProtractorFootprint.getFootprint("ProtractorFootprint.Circle5Bold")});
        this.defaultFootprint = this.getFootprint();
        this.setColor(this.defaultColors[0]);
        this.setProperty("tableVar0", "0");
        this.keyFrames.add(0);
        this.partName = TrackerRes.getString("TTrack.Selected.Hint");
        this.hint = TrackerRes.getString("Protractor.Hint");
        ProtractorStep step = new ProtractorStep(this, 0, 100.0, 150.0, 200.0, 150.0);
        step.setFootprint(this.getFootprint());
        this.steps = new TTrack.StepArray(this, step);
        this.fixedItem = new JCheckBoxMenuItem(TrackerRes.getString("TapeMeasure.MenuItem.Fixed"));
        this.fixedItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Protractor.this.setFixedPosition(Protractor.this.fixedItem.isSelected());
            }
        });
        this.attachmentItem = new JMenuItem(TrackerRes.getString("MeasuringTool.MenuItem.Attach"));
        this.attachmentItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttachmentDialog control = Protractor.this.tp.getAttachmentDialog(Protractor.this);
                control.setVisible(true);
            }
        });
        final FocusAdapter arcFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Protractor.this.angleField.getBackground() == Color.yellow) {
                    int n = Protractor.this.tp.getFrameNumber();
                    ProtractorStep step = (ProtractorStep)Protractor.this.getStep(n);
                    if (!Protractor.this.isFixedPosition()) {
                        Protractor.this.keyFrames.add(n);
                    }
                    step = (ProtractorStep)Protractor.this.getKeyStep(step);
                    double theta = Protractor.this.angleField.getValue();
                    if (theta != step.getProtractorAngle(false)) {
                        step.setProtractorAngle(theta);
                        Protractor.this.dataValid = false;
                        if (Protractor.this.isFixedPosition()) {
                            Protractor.this.fireStepsChanged();
                        } else {
                            Protractor.this.firePropertyChange("step", null, new Integer(n));
                        }
                        Protractor.this.tp.repaint();
                    }
                }
            }
        };
        this.angleField.addFocusListener(arcFocusListener);
        this.angleField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                arcFocusListener.focusLost(null);
                Protractor.this.angleField.requestFocusInWindow();
            }
        });
        final FocusAdapter lengthFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TPoint end;
                NumberField field = (NumberField)e.getSource();
                int n = Protractor.this.tp.getFrameNumber();
                ProtractorStep step = (ProtractorStep)Protractor.this.getStep(n);
                if (!Protractor.this.isFixedPosition()) {
                    Protractor.this.keyFrames.add(n);
                }
                step = (ProtractorStep)Protractor.this.getKeyStep(step);
                double length = field.getValue();
                TPoint tPoint = end = field == Protractor.this.xField ? step.end1 : step.end2;
                if (length != step.getArmLength(end)) {
                    step.setArmLength(end, length);
                    Protractor.this.dataValid = false;
                    if (Protractor.this.isFixedPosition()) {
                        Protractor.this.fireStepsChanged();
                    } else {
                        Protractor.this.firePropertyChange("step", null, new Integer(n));
                    }
                    Protractor.this.tp.repaint();
                }
            }
        };
        ActionListener lengthAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberField field = (NumberField)e.getSource();
                lengthFocusListener.focusLost(new FocusEvent(field, 1005));
                field.requestFocusInWindow();
            }
        };
        this.xField.addFocusListener(lengthFocusListener);
        this.xField.addActionListener(lengthAction);
        this.yField.addFocusListener(lengthFocusListener);
        this.yField.addActionListener(lengthAction);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean isSelectedTrack = this.tp.getSelectedTrack() == this;
        switch (e.getPropertyName()) {
            case "stepnumber": {
                if (!isSelectedTrack) break;
                ProtractorStep step = (ProtractorStep)this.getStep(this.tp.getFrameNumber());
                step.getProtractorAngle(true);
                step.getFormattedLength(step.end1);
                step.getFormattedLength(step.end2);
                this.stepValueLabel.setText(e.getNewValue() + ":");
                break;
            }
            case "adjusting": {
                if (!(e.getSource() instanceof TrackerPanel)) break;
                this.refreshDataLater = (Boolean)e.getNewValue();
                if (this.refreshDataLater) break;
                this.firePropertyChange("data", null, null);
                break;
            }
            case "step": 
            case "steps": {
                this.refreshAttachments();
                break;
            }
            case "selectedtrack": {
                if (e.getOldValue() != this || e.getNewValue() == this) break;
                this.repaint();
            }
        }
        super.propertyChange(e);
    }

    @Override
    public Step createStep(int n, double x, double y) {
        TPoint p;
        Step step = this.steps.getStep(n);
        TPoint[] pts = step.getPoints();
        TPoint tPoint = p = this.tp == null ? null : this.tp.getSelectedPoint();
        if (p == null) {
            p = pts[2];
        }
        if (p == pts[0] || p == pts[1] || p == pts[2]) {
            p.setXY(x, y);
            if (this.tp != null) {
                this.tp.setSelectedPoint(p);
                step.defaultIndex = p == pts[0] ? 0 : (p == pts[1] ? 1 : 2);
            }
        }
        return step;
    }

    public Step createStep(int n, double x1, double y1, double x2, double y2) {
        ProtractorStep step = (ProtractorStep)this.steps.getStep(n);
        step.end1.setLocation(x1, y1);
        step.end2.setLocation(x2, y2);
        this.keyFrames.add(n);
        return step;
    }

    @Override
    public TPoint autoMarkAt(int n, double x, double y) {
        this.setFixedPosition(false);
        ProtractorStep step = (ProtractorStep)this.steps.getStep(n);
        int i = this.getTargetIndex();
        if (i == 0) {
            step.vertex.setLocation(x, y);
        } else if (i == 1) {
            step.end1.setLocation(x, y);
        } else {
            step.end2.setLocation(x, y);
        }
        this.keyFrames.add(n);
        step.repaint();
        return this.getMarkedPoint(n, i);
    }

    @Override
    public int getStepLength() {
        return ProtractorStep.getLength();
    }

    @Override
    protected boolean isAutoTrackable() {
        return true;
    }

    @Override
    protected String getTargetDescription(int pointIndex) {
        if (pointIndex == 0) {
            return TrackerRes.getString("Protractor.Vertex.Name");
        }
        if (pointIndex == 1) {
            return TrackerRes.getString("Protractor.Base.Name");
        }
        return TrackerRes.getString("Protractor.End.Name");
    }

    @Override
    public int getFootprintLength() {
        return 3;
    }

    private boolean needsRotationData(TrackerPanel trackerPanel) {
        TView[][] views = this.tframe.getTViews(trackerPanel, false);
        int i = 0;
        while (i < views.length) {
            if (views[i] != null) {
                int j = 0;
                while (j < views[i].length) {
                    if (views[i][j] != null) {
                        PlotTView plotview;
                        int m;
                        int k;
                        TrackView trackView;
                        TTrack track;
                        if (views[i][j] != null && views[i][j] instanceof TableTView) {
                            TableTView tableView = (TableTView)views[i][j];
                            track = tableView.getSelectedTrack();
                            if (track != null && track instanceof Protractor) {
                                trackView = (TableTrackView)tableView.getTrackView(track);
                                String[] cols = ((TableTrackView)trackView).getVisibleColumns();
                                k = 0;
                                while (k < cols.length) {
                                    m = 6;
                                    while (m < 9) {
                                        if (dataVariables[m].equals(cols[k])) {
                                            return true;
                                        }
                                        ++m;
                                    }
                                    ++k;
                                }
                            }
                        } else if (views[i][j] != null && views[i][j] instanceof PlotTView && (track = (plotview = (PlotTView)views[i][j]).getSelectedTrack()) != null && track instanceof Protractor) {
                            trackView = (PlotTrackView)plotview.getTrackView(track);
                            TrackPlottingPanel[] plots = ((PlotTrackView)trackView).getPlots();
                            k = 0;
                            while (k < plots.length) {
                                if (plots[k] != null) {
                                    m = 6;
                                    while (m < 9) {
                                        String var = TeXParser.removeSubscripting(dataVariables[m]);
                                        if (plots[k].getXVariable() != null && plots[k].getXVariable().startsWith(var) || plots[k].getYVariable() != null && plots[k].getYVariable().startsWith(var)) {
                                            return true;
                                        }
                                        ++m;
                                    }
                                }
                                ++k;
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    @Override
    public DatasetManager getData(TrackerPanel panel) {
        boolean rot = this.needsRotationData(panel);
        if (rot && !this.needsRotationData) {
            this.dataValid = false;
        }
        this.needsRotationData = rot;
        int frameCount = panel.getPlayer().getVideoClip().getFrameCount();
        if (this.getSteps().length < frameCount) {
            this.steps.setLength(frameCount);
            this.dataValid = false;
        }
        return super.getData(panel);
    }

    @Override
    protected void refreshData(DatasetManager data, TrackerPanel trackerPanel) {
        if (this.refreshDataLater || trackerPanel == null || data == null) {
            return;
        }
        int count = dataVariables.length - 1;
        this.dataFrames.clear();
        VideoPlayer player = trackerPanel.getPlayer();
        VideoClip clip = player.getVideoClip();
        int len = clip.getStepCount();
        double[][] validData = new double[count + 1][len];
        int i = 0;
        while (i < len) {
            int frame = clip.stepToFrame(i);
            ProtractorStep next = (ProtractorStep)this.getStep(frame);
            next.dataVisible = true;
            double theta = next.getProtractorAngle(false);
            double t = player.getStepTime(i) / 1000.0;
            validData[0][i] = theta;
            validData[1][i] = next.getArmLength(next.end1);
            validData[2][i] = next.getArmLength(next.end2);
            validData[3][i] = i;
            validData[4][i] = frame;
            validData[8][i] = t;
            this.dataFrames.add(frame);
            ++i;
        }
        if (this.needsRotationData) {
            Object[] rotationData = this.getRotationData();
            double[] theta = (double[])rotationData[0];
            double[] omega = (double[])rotationData[1];
            double[] alpha = (double[])rotationData[2];
            double dt = player.getMeanStepDuration() / 1000.0;
            int i2 = 0;
            while (i2 < len) {
                validData[5][i2] = theta[clip.stepToFrame(i2)];
                validData[6][i2] = omega[clip.stepToFrame(i2)] / dt;
                validData[7][i2] = alpha[clip.stepToFrame(i2)] / (dt * dt);
                ++i2;
            }
        }
        this.clearColumns(data, count, dataVariables, "Protractor.Data.Description.", validData, len);
    }

    protected Object[] getRotationData() {
        if (this.rotationAngle.length < this.steps.array.length) {
            this.rotationAngle = new double[this.steps.array.length + 5];
            this.derivData[1] = this.rotationAngle;
            this.validData = new boolean[this.steps.array.length + 5];
            this.derivData[3] = this.validData;
        }
        int i = 0;
        while (i < this.validData.length) {
            this.validData[i] = false;
            ++i;
        }
        VideoClip clip = this.tp.getPlayer().getVideoClip();
        this.params[1] = clip.getStartFrameNumber();
        this.params[2] = clip.getStepSize();
        this.params[3] = clip.getStepCount();
        Step[] stepArray = this.steps.array;
        double rotation = 0.0;
        double prevAngle = 0.0;
        int n = 0;
        while (n < stepArray.length) {
            if (stepArray[n] != null && clip.includesFrame(n)) {
                ProtractorStep next = (ProtractorStep)stepArray[n];
                double theta = next.getProtractorAngle(false);
                double delta = theta - prevAngle;
                if (delta < -Math.PI) {
                    delta += Math.PI * 2;
                } else if (delta > Math.PI) {
                    delta -= Math.PI * 2;
                }
                prevAngle = theta;
                this.rotationAngle[n] = rotation += delta;
                this.validData[n] = true;
            } else {
                this.rotationAngle[n] = Double.NaN;
            }
            ++n;
        }
        boolean isLocked = this.locked;
        this.locked = false;
        this.params[0] = this.firstDerivSpill;
        Object[] result = PointMass.vDeriv.evaluate(this.derivData);
        double[] omega = (double[])result[0];
        this.params[0] = this.secondDerivSpill;
        result = PointMass.aDeriv.evaluate(this.derivData);
        double[] alpha = (double[])result[2];
        this.locked = isLocked;
        return new Object[]{this.rotationAngle, omega, alpha};
    }

    @Override
    public String getAttachmentDescription(int n) {
        return TrackerRes.getString(n == 0 ? "AttachmentInspector.Label.Vertex" : (n == 1 ? "Protractor.Attachment.Base" : "Protractor.Attachment.Arm"));
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel, JMenu menu0) {
        JMenu menu = super.getMenu(trackerPanel, menu0);
        if (menu0 == null) {
            return menu;
        }
        this.fixedItem.setText(TrackerRes.getString("TapeMeasure.MenuItem.Fixed"));
        this.fixedItem.setSelected(this.isFixedPosition());
        this.fixedItem.setEnabled(!this.isAttached());
        this.addFixedItem(menu);
        this.attachmentItem.setText(TrackerRes.getString("MeasuringTool.MenuItem.Attach"));
        menu.insert(this.attachmentItem, 0);
        menu.insertSeparator(1);
        return menu;
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        ArrayList<Component> list = super.getToolbarTrackComponents(trackerPanel);
        this.stepLabel.setText(TrackerRes.getString("TTrack.Label.Step"));
        this.angleLabel.setText(TrackerRes.getString("Protractor.Label.Angle"));
        this.angleField.setToolTipText(TrackerRes.getString("Protractor.Field.Angle.Tooltip"));
        this.xLabel.setText(dataVariables[2]);
        this.yLabel.setText(dataVariables[3]);
        this.xField.setUnits(trackerPanel.getUnits(this, dataVariables[2]));
        this.yField.setUnits(trackerPanel.getUnits(this, dataVariables[3]));
        ProtractorStep step = (ProtractorStep)this.getStep(trackerPanel.getFrameNumber());
        this.xField.setEnabled(!step.end1.isAttached() || !step.vertex.isAttached());
        this.yField.setEnabled(!step.end2.isAttached() || !step.vertex.isAttached());
        VideoClip clip = trackerPanel.getPlayer().getVideoClip();
        int n = clip.frameToStep(trackerPanel.getFrameNumber());
        this.stepValueLabel.setText(String.valueOf(n) + ":");
        this.angleField.setEnabled(!this.isFullyAttached() && !this.isLocked());
        this.rulerCheckbox.setText(TrackerRes.getString("InputTrack.Checkbox.Ruler"));
        this.rulerCheckbox.setToolTipText(TrackerRes.getString("InputTrack.Checkbox.Ruler.Tooltip"));
        this.rulerCheckbox.setSelected(this.ruler != null && this.ruler.isVisible());
        list.add(this.rulerCheckbox);
        list.add(this.stepSeparator);
        list.add(this.stepLabel);
        list.add(this.stepValueLabel);
        list.add(this.tSeparator);
        list.add(this.angleLabel);
        list.add(this.angleField);
        list.add(this.xSeparator);
        list.add(this.xLabel);
        list.add(this.xField);
        list.add(this.ySeparator);
        list.add(this.yLabel);
        list.add(this.yField);
        return list;
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (!(panel instanceof TrackerPanel) || !this.isVisible()) {
            return null;
        }
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        int n = trackerPanel.getFrameNumber();
        ProtractorStep step = (ProtractorStep)this.getStep(n);
        if (trackerPanel.getPlayer().getVideoClip().includesFrame(n)) {
            Interactive ia = step.findInteractive(trackerPanel, xpix, ypix);
            if (ia == null) {
                this.partName = TrackerRes.getString("TTrack.Selected.Hint");
                this.hint = TrackerRes.getString("Protractor.Hint");
                return null;
            }
            if (ia == step.vertex) {
                this.partName = TrackerRes.getString("Protractor.Vertex.Name");
                this.hint = TrackerRes.getString("Protractor.Vertex.Hint");
            } else if (ia == step.end1) {
                this.partName = TrackerRes.getString("Protractor.Base.Name");
                this.hint = TrackerRes.getString("Protractor.Base.Hint");
            } else if (ia == step.end2) {
                this.partName = TrackerRes.getString("Protractor.End.Name");
                this.hint = TrackerRes.getString("Protractor.End.Hint");
            } else if (ia == step.handle) {
                this.partName = TrackerRes.getString("Protractor.Handle.Name");
                this.hint = TrackerRes.getString("Protractor.Handle.Hint");
            } else if (ia == step.rotator) {
                this.partName = TrackerRes.getString("Protractor.Rotator.Name");
                this.hint = TrackerRes.getString("Protractor.Rotator.Hint");
            } else if (ia == this) {
                this.partName = TrackerRes.getString("Protractor.Readout.Name");
                this.hint = TrackerRes.getString("Protractor.Readout.Hint");
                trackerPanel.setMessage(this.getMessage());
            }
            return this.isLocked() ? null : ia;
        }
        return null;
    }

    @Override
    public String toString() {
        return TrackerRes.getString("Protractor.Name");
    }

    @Override
    public Map<String, NumberField[]> getNumberFields() {
        if (this.numberFields.isEmpty()) {
            this.numberFields.put(dataVariables[0], new NumberField[]{this.tField});
            this.numberFields.put(dataVariables[1], new NumberField[]{this.angleField, this.inputField});
            this.numberFields.put(dataVariables[2], new NumberField[]{this.xField});
            this.numberFields.put(dataVariables[3], new NumberField[]{this.yField});
        }
        return this.numberFields;
    }

    protected JPopupMenu getInputFieldPopup() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem item = new JMenuItem();
        final boolean radians = this.angleField.getConversionFactor() == 1.0;
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Protractor.this.tframe.setAnglesInRadians(!radians);
            }
        });
        item.setText(radians ? TrackerRes.getString("TTrack.AngleField.Popup.Degrees") : TrackerRes.getString("TTrack.AngleField.Popup.Radians"));
        popup.add(item);
        if (this.tp.isEnabled("number.formats")) {
            popup.addSeparator();
            item = new JMenuItem();
            final String[] selected = new String[]{Tracker.THETA};
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NumberFormatDialog.getNumberFormatDialog(Protractor.this.tp, Protractor.this, selected).setVisible(true);
                }
            });
            item.setText(TrackerRes.getString("TTrack.MenuItem.NumberFormat"));
            popup.add(item);
        }
        return popup;
    }

    @Override
    public void setTrackerPanel(TrackerPanel panel) {
        if (this.tp != null) {
            this.removePanelEvents(panelEventsProtractor);
        }
        super.setTrackerPanel(panel);
        if (panel != null) {
            this.setFixedPosition(this.isFixedPosition());
            this.addPanelEvents(panelEventsProtractor);
        }
    }

    @Override
    protected void setAnglesInRadians(boolean radians) {
        super.setAnglesInRadians(radians);
        this.inputField.setConversionFactor(radians ? 1.0 : 57.29577951308232);
        Step step = this.getStep(this.tp.getFrameNumber());
        step.repaint();
    }

    @Override
    protected Ruler getRuler() {
        if (this.ruler == null) {
            this.ruler = new AngleRuler(this);
        }
        return this.ruler;
    }

    @Override
    protected void refreshStep(Step step) {
        boolean different;
        ProtractorStep p = (ProtractorStep)step;
        ProtractorStep k = (ProtractorStep)this.getKeyStep(p);
        boolean bl = different = k.vertex.getX() != p.vertex.getX() || k.vertex.getY() != p.vertex.getY() || k.end1.getX() != p.end1.getX() || k.end1.getY() != p.end1.getY() || k.end2.getX() != p.end2.getX() || k.end2.getY() != p.end2.getY();
        if (different) {
            p.vertex.setLocation(k.vertex);
            p.end1.setLocation(k.end1);
            p.end2.setLocation(k.end2);
            p.erase();
        }
    }

    @Override
    protected NumberField createInputField() {
        return new NumberField(9){

            @Override
            public void setFixedPattern(String pattern) {
                super.setFixedPattern(pattern);
                Protractor.this.setMagValue();
            }
        };
    }

    @Override
    protected Rectangle getLayoutBounds(Step step) {
        return ((ProtractorStep)step).panelLayoutBounds.get(this.tp.getID());
    }

    @Override
    protected boolean checkKeyFrame() {
        return !this.editing;
    }

    @Override
    protected void endEditing(Step step, String rawText) {
        ProtractorStep p = (ProtractorStep)step;
        p.drawLayoutBounds = false;
        p.setProtractorAngle(this.inputField.getValue());
        this.inputField.setSigFigs(4);
    }

    @Override
    protected void setInputValue(Step step) {
        this.inputField.setValue(((ProtractorStep)step).getProtractorAngle(false));
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            Protractor protractor = (Protractor)obj;
            XML.getLoader(TTrack.class).saveObject(control, obj);
            control.setValue("fixed", protractor.isFixedPosition());
            Step[] steps = protractor.getSteps();
            int count = steps.length;
            if (protractor.isFixedPosition()) {
                count = 1;
            }
            double[][] data = new double[count][];
            int n = 0;
            while (n < count) {
                if (steps[n] != null && protractor.keyFrames.contains(n)) {
                    ProtractorStep pStep = (ProtractorStep)steps[n];
                    double[] stepData = new double[]{pStep.end1.getX(), pStep.end1.getY(), pStep.end2.getX(), pStep.end2.getY(), pStep.vertex.getX(), pStep.vertex.getY()};
                    data[n] = stepData;
                }
                ++n;
            }
            control.setValue("framedata", data);
            control.setValue("ruler_visible", protractor.ruler != null && protractor.ruler.isVisible());
        }

        @Override
        public Object createObject(XMLControl control) {
            return new Protractor();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            Protractor protractor = (Protractor)obj;
            XML.getLoader(TTrack.class).loadObject(control, obj);
            boolean locked = protractor.isLocked();
            protractor.setLocked(false);
            protractor.fixedPosition = control.getBoolean("fixed");
            protractor.keyFrames.clear();
            double[][] data = (double[][])control.getObject("framedata");
            int n = 0;
            while (n < data.length) {
                if (data[n] != null) {
                    Step step = protractor.createStep(n, data[n][0], data[n][1], data[n][2], data[n][3]);
                    ProtractorStep tapeStep = (ProtractorStep)step;
                    tapeStep.vertex.setLocation(data[n][4], data[n][5]);
                    tapeStep.erase();
                }
                ++n;
            }
            if (control.getPropertyNamesRaw().contains("ruler_visible")) {
                protractor.getRuler().setVisible(control.getBoolean("ruler_visible"));
            }
            protractor.setLocked(locked);
            return obj;
        }
    }
}

