/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.Collection;
import java.util.HashSet;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.cabrillo.tracker.ShapeIcon;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.tools.FontSizer;

public class ProtractorFootprint
implements Footprint,
Cloneable {
    public static final float[] DOTTED_LINE = new float[]{2.0f, 6.0f};
    public static final float[] STIPPLED_LINE = new float[]{2.0f, 2.0f};
    private static final ProtractorFootprint CIRCLE_3;
    private static final ProtractorFootprint CIRCLE_5;
    private static final ProtractorFootprint CIRCLE_3_BOLD;
    private static final ProtractorFootprint CIRCLE_5_BOLD;
    protected static int arcRadius;
    private static Collection<ProtractorFootprint> footprints;
    private static Shape hitShape;
    private static MultiShape arrowhead;
    private static Line2D line1;
    private static Line2D line2;
    private static Point p;
    private static AffineTransform transform;
    private static Arc2D arc;
    protected String name;
    protected BasicStroke baseStroke;
    protected BasicStroke stroke;
    protected Color color = Color.black;
    protected Shape[] hitShapes = new Shape[6];
    protected Shape circle;
    protected int radius;
    private Stroke arcStroke;
    private Stroke arcAdjustStroke;
    private Stroke armStroke;
    private boolean isArcVisible;

    static {
        arcRadius = 24;
        footprints = new HashSet<ProtractorFootprint>();
        hitShape = new Ellipse2D.Double(-6.0, -6.0, 12.0, 12.0);
        line1 = new Line2D.Double();
        line2 = new Line2D.Double();
        p = new Point();
        transform = new AffineTransform();
        arc = new Arc2D.Double(-arcRadius, -arcRadius, 2 * arcRadius, 2 * arcRadius, 0.0, 0.0, 0);
        BasicStroke stroke = new BasicStroke(1.0f);
        GeneralPath path = new GeneralPath();
        path.moveTo(-6.0f, 2.0f);
        path.lineTo(0.0f, 0.0f);
        path.lineTo(-6.0f, -3.0f);
        arrowhead = new MultiShape(path).andStroke(stroke);
        CIRCLE_3 = new ProtractorFootprint("ProtractorFootprint.Circle3", 3);
        CIRCLE_3.setStroke(stroke);
        footprints.add(CIRCLE_3);
        CIRCLE_5 = new ProtractorFootprint("ProtractorFootprint.Circle5", 8);
        CIRCLE_5.setStroke(stroke);
        footprints.add(CIRCLE_5);
        stroke = new BasicStroke(2.0f);
        CIRCLE_3_BOLD = new ProtractorFootprint("ProtractorFootprint.Circle3Bold", 3);
        CIRCLE_3_BOLD.setStroke(stroke);
        footprints.add(CIRCLE_3_BOLD);
        CIRCLE_5_BOLD = new ProtractorFootprint("ProtractorFootprint.Circle5Bold", 8);
        CIRCLE_5_BOLD.setStroke(stroke);
        footprints.add(CIRCLE_5_BOLD);
    }

    public ProtractorFootprint(String name, int r) {
        this.name = name;
        this.radius = r;
        this.circle = new Ellipse2D.Double(-r, -r, 2 * r, 2 * r);
        this.setStroke(new BasicStroke());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return TrackerRes.getString(this.name);
    }

    @Override
    public int getLength() {
        return 3;
    }

    @Override
    public ResizableIcon getIcon(int w, int h) {
        transform.setToScale(1.0, 1.0);
        Shape shape = transform.createTransformedShape(this.circle);
        if (this.stroke == null || this.stroke.getLineWidth() != this.baseStroke.getLineWidth()) {
            this.stroke = new BasicStroke(this.baseStroke.getLineWidth());
            this.arcStroke = new BasicStroke(1.0f);
            this.arcAdjustStroke = new BasicStroke(this.stroke.getLineWidth(), 0, 0, 8.0f, DOTTED_LINE, this.stroke.getDashPhase());
        }
        MultiShape drawShape = new MultiShape(shape).andStroke(this.stroke);
        double x0 = this.radius + 2 - w;
        double y0 = h - (this.radius + 2);
        double d = Math.sqrt(x0 * x0 + y0 * y0);
        double x1 = x0 * (double)this.radius / d;
        double y1 = y0 * (double)this.radius / d;
        drawShape.addDrawShape(new Line2D.Double(x0, y0, x1, y1), this.stroke);
        drawShape.addDrawShape(new Line2D.Double(x0, y0, this.radius - 2, y0), this.stroke);
        ShapeIcon icon = new ShapeIcon(drawShape, w, h);
        icon.setColor(this.color);
        return new ResizableIcon(icon);
    }

    @Override
    public Mark getMark(Point[] points) {
        final MultiShape shape = this.getShape(points, FontSizer.getIntegerFactor());
        return new Mark(){

            @Override
            public void draw(Graphics2D g, boolean highlighted) {
                Color gcolor = g.getColor();
                Stroke gstroke = g.getStroke();
                g.setColor(ProtractorFootprint.this.color);
                g.setStroke(ProtractorFootprint.this.stroke);
                if (OSPRuntime.setRenderingHints) {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                shape.draw(g);
                g.setColor(gcolor);
                g.setStroke(gstroke);
            }
        };
    }

    @Override
    public Shape[] getHitShapes() {
        return this.hitShapes;
    }

    @Override
    public void setStroke(BasicStroke stroke) {
        if (stroke == null) {
            return;
        }
        this.baseStroke = new BasicStroke(stroke.getLineWidth(), 0, 0, 8.0f, stroke.getDashArray(), stroke.getDashPhase());
        this.arcAdjustStroke = new BasicStroke(stroke.getLineWidth(), 0, 0, 8.0f, DOTTED_LINE, stroke.getDashPhase());
        this.armStroke = new BasicStroke(stroke.getLineWidth(), 0, 0, 8.0f, STIPPLED_LINE, stroke.getDashPhase());
    }

    @Override
    public BasicStroke getStroke() {
        return this.baseStroke;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    public void setArcVisible(boolean vis) {
        this.isArcVisible = vis;
    }

    public MultiShape getCircleShape(Point p) {
        transform.setToTranslation(p.x, p.y);
        int scale = FontSizer.getIntegerFactor();
        if (scale > 1) {
            transform.scale(scale, scale);
        }
        Shape shape = transform.createTransformedShape(this.circle);
        return new MultiShape(shape).andStroke(this.stroke);
    }

    public MultiShape getArcAdjustShape(Point vertex, Point rotator) {
        double theta = Math.toRadians(arc.getAngleStart() + arc.getAngleExtent() / 2.0);
        int scale = FontSizer.getIntegerFactor();
        ProtractorFootprint.p.x = (int)Math.round((double)vertex.x + (double)(scale * arcRadius) * Math.cos(theta));
        ProtractorFootprint.p.y = (int)Math.round((double)vertex.y - (double)(scale * arcRadius) * Math.sin(theta));
        MultiShape circle = this.getCircleShape(p);
        MultiShape drawShape = new MultiShape(circle);
        if (rotator != null) {
            int r = circle.getBounds().width / 2;
            double d = p.distance(rotator);
            line1.setLine(p.getX(), p.getY(), rotator.getX(), rotator.getY());
            if (d > 1.0) {
                ProtractorFootprint.adjustLineLength(line1, (d - (double)r) / d, (d - 6.0) / d);
            }
            drawShape.addDrawShape((Line2D)line1.clone(), this.arcAdjustStroke);
        }
        return drawShape;
    }

    @Override
    public MultiShape getShape(Point[] points, int scale) {
        Point vertex = points[0];
        Point end1 = points[1];
        Point end2 = points[2];
        int r = scale * this.circle.getBounds().width / 2;
        if (this.stroke == null || this.stroke.getLineWidth() != (float)scale * this.baseStroke.getLineWidth()) {
            this.stroke = new BasicStroke((float)scale * this.baseStroke.getLineWidth());
            this.arcStroke = new BasicStroke(scale);
            this.arcAdjustStroke = new BasicStroke(this.stroke.getLineWidth(), 0, 0, 8.0f, DOTTED_LINE, this.stroke.getDashPhase());
            this.armStroke = new BasicStroke(this.stroke.getLineWidth(), 0, 0, 8.0f, STIPPLED_LINE, this.stroke.getDashPhase());
        }
        MultiShape drawMe = new MultiShape(new Shape[0]);
        line1.setLine(vertex, end1);
        double d1 = vertex.distance(end1);
        if (d1 > 1.0) {
            ProtractorFootprint.adjustLineLength(line1, 1.0, (d1 - (double)r) / d1);
        }
        drawMe.addDrawShape((Line2D)line1.clone(), null);
        line2.setLine(vertex, end2);
        double d2 = vertex.distance(end2);
        if (d2 > 1.0) {
            ProtractorFootprint.adjustLineLength(line2, 1.0, (d2 - (double)r) / d2);
        }
        drawMe.addDrawShape((Line2D)line2.clone(), this.armStroke);
        transform.setToTranslation(end1.x, end1.y);
        if (scale > 1) {
            transform.scale(scale, scale);
        }
        Shape end1Shape = transform.createTransformedShape(this.circle);
        drawMe.addDrawShape(end1Shape, null);
        transform.setToTranslation(end2.x, end2.y);
        if (scale > 1) {
            transform.scale(scale, scale);
        }
        Shape end2Shape = transform.createTransformedShape(this.circle);
        drawMe.addDrawShape(end2Shape, null);
        double theta1 = -Math.atan2(end1.y - vertex.y, end1.x - vertex.x);
        double theta2 = -Math.atan2(end2.y - vertex.y, end2.x - vertex.x);
        arc.setAngleStart(Math.toDegrees(theta1));
        double degrees = Math.toDegrees(theta2 - theta1);
        if (degrees > 180.0) {
            degrees -= 360.0;
        }
        if (degrees < -180.0) {
            degrees += 360.0;
        }
        arc.setAngleExtent(degrees);
        transform.setToTranslation(vertex.x, vertex.y);
        if (scale > 1) {
            transform.scale(scale, scale);
        }
        Shape arcShape = transform.createTransformedShape(arc);
        if (this.isArcVisible) {
            drawMe.addDrawShape(arcShape, this.arcStroke);
            if (Math.abs(degrees) > 10.0) {
                double xDot = vertex.getX() + (double)(scale * arcRadius) * (end2.getX() - vertex.getX()) / d2;
                double yDot = vertex.getY() + (double)(scale * arcRadius) * (end2.getY() - vertex.getY()) / d2;
                double angle = -theta2 - 1.5707963267948966;
                if (degrees < 0.0) {
                    angle += Math.PI;
                }
                transform.setToRotation(angle, xDot, yDot);
                transform.translate(xDot, yDot);
                if (scale > 1) {
                    transform.scale(scale, scale);
                }
                MultiShape arrowShape = arrowhead.transform(transform);
                drawMe.addFillShape(arrowShape);
            }
        }
        transform.setToTranslation(vertex.x, vertex.y);
        if (scale > 1) {
            transform.scale(scale, scale);
        }
        this.hitShapes[0] = transform.createTransformedShape(hitShape);
        transform.setToTranslation(end1.x, end1.y);
        if (scale > 1) {
            transform.scale(scale, scale);
        }
        this.hitShapes[1] = transform.createTransformedShape(hitShape);
        transform.setToTranslation(end2.x, end2.y);
        if (scale > 1) {
            transform.scale(scale, scale);
        }
        this.hitShapes[2] = transform.createTransformedShape(hitShape);
        if (d1 > 1.0) {
            ProtractorFootprint.adjustLineLength(line1, (d1 - (double)(scale * arcRadius) - 8.0) / d1, (d1 - 8.0) / d1);
        }
        if (d2 > 1.0) {
            ProtractorFootprint.adjustLineLength(line2, (d2 - (double)(scale * arcRadius) - 8.0) / d2, (d2 - 8.0) / d2);
        }
        this.hitShapes[3] = (Line2D)line1.clone();
        this.hitShapes[4] = (Line2D)line2.clone();
        this.hitShapes[5] = arcShape;
        return drawMe;
    }

    private static void adjustLineLength(Line2D line, double end1Factor, double end2Factor) {
        double x1 = line.getX2() + (line.getX1() - line.getX2()) * end1Factor;
        double y1 = line.getY2() + (line.getY1() - line.getY2()) * end1Factor;
        double x2 = line.getX1() + (line.getX2() - line.getX1()) * end2Factor;
        double y2 = line.getY1() + (line.getY2() - line.getY1()) * end2Factor;
        line.setLine(x1, y1, x2, y2);
    }

    public static Footprint getFootprint(String name) {
        for (ProtractorFootprint footprint : footprints) {
            if (name != footprint.getName()) continue;
            try {
                return (ProtractorFootprint)footprint.clone();
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }
}

