/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.cabrillo.tracker.Protractor;
import org.opensourcephysics.cabrillo.tracker.ProtractorFootprint;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.cabrillo.tracker.WorldTView;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;

public class ProtractorStep
extends Step {
    protected static AffineTransform transform = new AffineTransform();
    protected static TPoint endPoint1 = new TPoint();
    protected static TPoint endPoint2 = new TPoint();
    protected static TPoint middle = new TPoint();
    protected static NumberField formatField = new NumberField(1);
    protected Protractor protractor;
    protected TPoint vertex;
    protected TPoint end1;
    protected TPoint end2;
    protected Handle handle;
    protected Rotator rotator;
    protected double line1Angle;
    protected double line2Angle;
    protected boolean endsEnabled = true;
    protected boolean drawArcCircle;
    protected boolean drawLayoutBounds;
    protected boolean drawLayout1;
    protected boolean drawLayout2;
    protected boolean drawLayoutAngle;
    protected MultiShape vertexCircle;
    protected Map<Integer, Shape> panelVertexShapes = new HashMap<Integer, Shape>();
    protected Map<Integer, Shape> panelEnd1Shapes = new HashMap<Integer, Shape>();
    protected Map<Integer, Shape> panelEnd2Shapes = new HashMap<Integer, Shape>();
    protected Map<Integer, Shape> panelLine1Shapes = new HashMap<Integer, Shape>();
    protected Map<Integer, Shape> panelLine2Shapes = new HashMap<Integer, Shape>();
    protected Map<Integer, Shape> panelRotatorShapes = new HashMap<Integer, Shape>();
    protected Map<Integer, OSPRuntime.TextLayout> panelTextLayouts = new HashMap<Integer, OSPRuntime.TextLayout>();
    protected Map<Integer, Rectangle> panelLayoutBounds = new HashMap<Integer, Rectangle>();
    protected Map<Integer, OSPRuntime.TextLayout> panelTextLayouts1 = new HashMap<Integer, OSPRuntime.TextLayout>();
    protected Map<Integer, Rectangle> panelLayout1Bounds = new HashMap<Integer, Rectangle>();
    protected Map<Integer, OSPRuntime.TextLayout> panelTextLayouts2 = new HashMap<Integer, OSPRuntime.TextLayout>();
    protected Map<Integer, Rectangle> panelLayout2Bounds = new HashMap<Integer, Rectangle>();
    protected Shape selectedShape;

    public ProtractorStep(Protractor track, int n, double x1, double y1, double x2, double y2) {
        super(track, n);
        this.protractor = track;
        this.vertex = new Tip(x1, y1);
        this.end1 = new Tip(x2, y2);
        double x = (x1 + x2) / 2.0;
        double y = y1 - (x2 - x1) * Math.sin(1.0471975511965976);
        this.end2 = new Tip(x, y);
        this.handle = new Handle((x1 + x2) / 2.0, (y1 + y2) / 2.0);
        this.rotator = new Rotator();
        this.points = new TPoint[]{this.vertex, this.end1, this.end2, this.handle, this.rotator};
        this.screenPoints = new Point[ProtractorStep.getLength()];
    }

    public void setEndsEnabled(boolean enabled) {
        this.endsEnabled = enabled;
    }

    public boolean isEndsEnabled() {
        return this.endsEnabled;
    }

    @Override
    public void setFootprint(Footprint footprint) {
        if (footprint.getLength() >= 2) {
            super.setFootprint(footprint);
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        Shape hitShape;
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        boolean isWorldView = panel instanceof WorldTView.WorldPanel;
        this.setHitRectCenter(xpix, ypix);
        Interactive hit = null;
        ProtractorFootprint footprint = null;
        this.drawLayout2 = false;
        this.drawLayout1 = false;
        this.drawLayoutBounds = false;
        this.drawLayoutAngle = false;
        if (this.protractor.getFootprint() != null && this.protractor.getFootprint() instanceof ProtractorFootprint) {
            footprint = (ProtractorFootprint)this.protractor.getFootprint();
        }
        if (this.endsEnabled) {
            hitShape = this.panelVertexShapes.get(trackerPanel.getID());
            if (!this.vertex.isAttached() && hitShape != null && hitShape.intersects(hitRect)) {
                hit = this.vertex;
                this.drawLayoutAngle = true;
                if (this.vertexCircle == null && footprint != null) {
                    this.vertexCircle = footprint.getCircleShape(this.vertex.getScreenPosition(trackerPanel));
                }
            }
            if (hit == null && this.vertexCircle != null) {
                this.vertexCircle = null;
            }
            hitShape = this.panelEnd1Shapes.get(trackerPanel.getID());
            if (hit == null && hitShape != null && hitShape.intersects(hitRect)) {
                hit = this.end1;
                this.drawLayout1 = true;
                this.drawLayoutAngle = true;
            }
            hitShape = this.panelEnd2Shapes.get(trackerPanel.getID());
            if (hit == null && hitShape != null && hitShape.intersects(hitRect)) {
                hit = this.end2;
                this.drawLayout2 = true;
                this.drawLayoutAngle = true;
            }
        }
        hitShape = this.panelRotatorShapes.get(trackerPanel.getID());
        if (!this.end1.isAttached() && !this.end2.isAttached() && hit == null && hitShape != null && hitShape.intersects(hitRect)) {
            hit = this.rotator;
        }
        if (hit == null && trackerPanel.getSelectedPoint() == this.rotator && this.selectedShape != null && this.selectedShape.intersects(hitRect)) {
            hit = this.rotator;
        }
        if (hit == this.rotator && trackerPanel.getSelectedPoint() != this.rotator && !isWorldView) {
            this.rotator.setScreenCoords(xpix, ypix);
        }
        this.drawArcCircle = hit == this.rotator || trackerPanel.getSelectedPoint() == this.rotator;
        hitShape = this.panelLine1Shapes.get(trackerPanel.getID());
        if (hit == null && hitShape != null && hitShape.intersects(hitRect)) {
            hit = this.handle;
            this.handle.setHandleEnd(this.end1);
            this.drawLayout1 = true;
            this.drawLayoutAngle = true;
        }
        hitShape = this.panelLine2Shapes.get(trackerPanel.getID());
        if (hit == null && hitShape != null && hitShape.intersects(hitRect)) {
            hit = this.handle;
            this.handle.setHandleEnd(this.end2);
            this.drawLayout2 = true;
            this.drawLayoutAngle = true;
        }
        if (hit == null && this.protractor.ruler != null && this.protractor.ruler.isVisible()) {
            hit = this.protractor.ruler.findInteractive(trackerPanel, hitRect);
        }
        Rectangle layoutRect = this.panelLayoutBounds.get(trackerPanel.getID());
        if (hit == null && layoutRect != null && layoutRect.intersects(hitRect)) {
            this.drawLayoutBounds = true;
            this.drawLayoutAngle = true;
            hit = this.protractor;
        }
        if (this.end1.isAttached() && (hit == this.end1 || hit == this.rotator)) {
            return null;
        }
        if (this.end2.isAttached() && (hit == this.end2 || hit == this.rotator)) {
            return null;
        }
        if (this.vertex.isAttached() && hit == this.vertex) {
            return null;
        }
        return hit;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics _g) {
        Point p;
        OSPRuntime.TextLayout layout;
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        boolean isWorldView = trackerPanel.isWorldPanel();
        Graphics2D g = (Graphics2D)_g;
        this.getMark(trackerPanel).draw(g, false);
        Paint gpaint = g.getPaint();
        g.setPaint(this.footprint.getColor());
        Font gfont = g.getFont();
        g.setFont(TFrame.textLayoutFont);
        if (!(this.protractor.editing || isWorldView || !this.drawLayoutAngle && trackerPanel.getSelectedTrack() != this.protractor)) {
            layout = this.panelTextLayouts.get(trackerPanel.getID());
            Rectangle bounds = this.panelLayoutBounds.get(trackerPanel.getID());
            g.setFont(TFrame.textLayoutFont);
            layout.draw(g, bounds.x, bounds.y + bounds.height);
            g.setFont(gfont);
            if (this.drawLayoutBounds) {
                g.drawRect(bounds.x - 2, bounds.y - 3, bounds.width + 6, bounds.height + 5);
            }
        }
        if (trackerPanel.getSelectedPoint() == this.vertex) {
            this.vertexCircle = null;
        }
        if (this.vertexCircle != null && !isWorldView) {
            this.vertexCircle.draw(g);
        }
        if (this.drawLayout1 && !isWorldView) {
            layout = this.panelTextLayouts1.get(trackerPanel.getID());
            p = this.getLayoutPosition(trackerPanel, layout, this.end1);
            layout.draw(g, p.x, p.y);
        }
        if (this.drawLayout2 && !isWorldView) {
            layout = this.panelTextLayouts2.get(trackerPanel.getID());
            p = this.getLayoutPosition(trackerPanel, layout, this.end2);
            layout.draw(g, p.x, p.y);
        }
        g.setFont(gfont);
        g.setPaint(gpaint);
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = (Mark)this.panelMarks.get(trackerPanel.getID());
        if (mark == null) {
            MultiShape arcCircle;
            this.getProtractorAngle(true);
            ProtractorFootprint pFootprint = (ProtractorFootprint)this.footprint;
            TPoint selection = trackerPanel.getSelectedPoint();
            final boolean isWorldView = trackerPanel.isWorldPanel();
            Point p = null;
            int i = 0;
            while (i < this.points.length) {
                this.screenPoints[i] = this.points[i].getScreenPosition(trackerPanel);
                if (selection == this.points[i]) {
                    p = this.screenPoints[i];
                }
                ++i;
            }
            final Mark rulerMark = this.protractor.ruler != null && this.protractor.ruler.isVisible() ? this.protractor.ruler.getMark(trackerPanel, this.n) : null;
            pFootprint.setArcVisible(!isWorldView);
            final Mark stepMark = pFootprint.getMark(this.screenPoints);
            MultiShape multiShape = isWorldView ? null : (arcCircle = selection == this.rotator ? pFootprint.getArcAdjustShape(this.screenPoints[0], this.screenPoints[4]) : pFootprint.getArcAdjustShape(this.screenPoints[0], null));
            if (!isWorldView) {
                if (p != null) {
                    transform.setToTranslation(p.x, p.y);
                    int scale = FontSizer.getIntegerFactor();
                    if (scale > 1) {
                        transform.scale(scale, scale);
                    }
                    this.selectedShape = transform.createTransformedShape(selectionShape);
                } else {
                    this.selectedShape = null;
                }
            }
            mark = new Mark(){

                @Override
                public void draw(Graphics2D g, boolean highlighted) {
                    stepMark.draw(g, false);
                    Paint gpaint = g.getPaint();
                    Stroke gstroke = g.getStroke();
                    g.setPaint(ProtractorStep.this.footprint.getColor());
                    if (rulerMark != null) {
                        rulerMark.draw(g, false);
                    }
                    if (arcCircle != null && ProtractorStep.this.drawArcCircle) {
                        arcCircle.draw(g);
                    }
                    if (ProtractorStep.this.selectedShape != null && !isWorldView) {
                        g.setStroke(selectionStroke);
                        g.draw(ProtractorStep.this.selectedShape);
                    }
                    g.setPaint(gpaint);
                    g.setStroke(gstroke);
                }
            };
            this.panelMarks.put(trackerPanel.getID(), mark);
            Shape[] shapes = this.footprint.getHitShapes();
            this.panelVertexShapes.put(trackerPanel.getID(), shapes[0]);
            this.panelEnd1Shapes.put(trackerPanel.getID(), shapes[1]);
            this.panelEnd2Shapes.put(trackerPanel.getID(), shapes[2]);
            this.panelLine1Shapes.put(trackerPanel.getID(), shapes[3]);
            this.panelLine2Shapes.put(trackerPanel.getID(), shapes[4]);
            this.panelRotatorShapes.put(trackerPanel.getID(), shapes[5]);
            String s = this.protractor.angleField.getText();
            OSPRuntime.TextLayout layout = new OSPRuntime.TextLayout(s, TFrame.textLayoutFont);
            this.panelTextLayouts.put(trackerPanel.getID(), layout);
            p = this.getLayoutPosition(trackerPanel, layout, this.vertex);
            Rectangle bounds = this.panelLayoutBounds.get(trackerPanel.getID());
            if (bounds == null) {
                bounds = new Rectangle();
                this.panelLayoutBounds.put(trackerPanel.getID(), bounds);
            }
            Rectangle2D rect = layout.getBounds();
            bounds.setRect(p.x, (double)p.y - rect.getHeight(), rect.getWidth(), rect.getHeight());
            int k = 0;
            while (k < 2) {
                TPoint end = k == 0 ? this.end1 : this.end2;
                Map<Integer, OSPRuntime.TextLayout> layouts = k == 0 ? this.panelTextLayouts1 : this.panelTextLayouts2;
                Map<Integer, Rectangle> lBounds = k == 0 ? this.panelLayout1Bounds : this.panelLayout2Bounds;
                s = this.getFormattedLength(end);
                s = String.valueOf(s) + trackerPanel.getUnits(this.protractor, Protractor.dataVariables[2 + k]);
                layout = new OSPRuntime.TextLayout(s, TFrame.textLayoutFont);
                layouts.put(trackerPanel.getID(), layout);
                p = this.getLayoutPosition(trackerPanel, layout, end);
                bounds = lBounds.get(trackerPanel.getID());
                if (bounds == null) {
                    bounds = new Rectangle();
                    lBounds.put(trackerPanel.getID(), bounds);
                }
                rect = layout.getBounds();
                bounds.setRect(p.x, (double)p.y - rect.getHeight(), rect.getWidth(), rect.getHeight());
                ++k;
            }
        }
        return mark;
    }

    public String getFormattedLength(TPoint end) {
        double length = this.getArmLength(end);
        if (this.protractor.tp.getFrameNumber() == this.n) {
            NumberField field = end == this.end1 ? this.getTrack().xField : this.getTrack().yField;
            field.setValue(length);
            return field.format(length);
        }
        formatField.setFixedPattern(this.getTrack().xField.getFixedPattern());
        formatField.setFormatFor(length);
        return formatField.format(length);
    }

    public double getProtractorAngle(boolean refreshField) {
        this.line1Angle = -this.vertex.angle(this.end1);
        this.line2Angle = -this.vertex.angle(this.end2);
        double theta = this.line2Angle - this.line1Angle;
        if (theta > Math.PI) {
            theta -= Math.PI * 2;
        }
        if (theta < -Math.PI) {
            theta += Math.PI * 2;
        }
        if (refreshField && this.protractor.tp.getFrameNumber() == this.n) {
            this.protractor.angleField.setValue(theta);
        }
        return theta;
    }

    public void setProtractorAngle(double theta) {
        if (this.protractor.isLocked() || this.protractor.tp == null) {
            return;
        }
        XMLControlElement state = new XMLControlElement(this.protractor);
        double d = this.end2.distance(this.vertex);
        double dx = d * Math.cos(theta += this.line1Angle);
        double dy = -d * Math.sin(theta);
        this.end2.setLocation(this.vertex.x + dx, this.vertex.y + dy);
        this.repaint();
        Undo.postTrackEdit(this.protractor, state);
        this.protractor.firePropertyChange("steps", null, null);
    }

    public double getArmLength(TPoint end) {
        if (this.protractor.tp == null) {
            return 1.0;
        }
        double scaleX = this.protractor.tp.getCoords().getScaleX(this.n);
        double scaleY = this.protractor.tp.getCoords().getScaleY(this.n);
        double dx = (this.vertex.getX() - end.getX()) / scaleX;
        double dy = (end.getY() - this.vertex.getY()) / scaleY;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public void setArmLength(TPoint end, double length) {
        if (this.protractor.isLocked() || this.protractor.tp == null) {
            return;
        }
        XMLControlElement state = new XMLControlElement(this.protractor);
        double scaleX = this.protractor.tp.getCoords().getScaleX(this.n);
        double scaleY = this.protractor.tp.getCoords().getScaleY(this.n);
        double dx = length * this.vertex.cos(end) * scaleX;
        double dy = -length * this.vertex.sin(end) * scaleY;
        end.setXY(this.vertex.x + dx, this.vertex.y + dy);
        this.repaint();
        Undo.postTrackEdit(this.protractor, state);
    }

    protected void moveVertexTo(double x, double y) {
        if (this.protractor.isLocked() || this.protractor.tp == null) {
            return;
        }
        double dx = x - this.vertex.x;
        double dy = y - this.vertex.y;
        this.handle.setXY(this.handle.x + dx, this.handle.y + dy);
    }

    @Override
    public Object clone() {
        ProtractorStep step = (ProtractorStep)super.clone();
        if (step != null) {
            TPoint[] tPointArray = step.points;
            ProtractorStep protractorStep = step;
            protractorStep.getClass();
            tPointArray[0] = step.vertex = protractorStep.new Tip(this.vertex.getX(), this.vertex.getY());
            TPoint[] tPointArray2 = step.points;
            ProtractorStep protractorStep2 = step;
            protractorStep2.getClass();
            tPointArray2[1] = step.end1 = protractorStep2.new Tip(this.end1.getX(), this.end1.getY());
            TPoint[] tPointArray3 = step.points;
            ProtractorStep protractorStep3 = step;
            protractorStep3.getClass();
            tPointArray3[2] = step.end2 = protractorStep3.new Tip(this.end2.getX(), this.end2.getY());
            TPoint[] tPointArray4 = step.points;
            ProtractorStep protractorStep4 = step;
            protractorStep4.getClass();
            step.handle = protractorStep4.new Handle(this.handle.getX(), this.handle.getY());
            tPointArray4[3] = step.handle;
            step.rotator = step.new Rotator();
            step.points[4] = step.rotator;
            step.vertex.setTrackEditTrigger(true);
            step.end1.setTrackEditTrigger(true);
            step.end2.setTrackEditTrigger(true);
            step.handle.setTrackEditTrigger(true);
            step.panelVertexShapes = new HashMap<Integer, Shape>();
            step.panelEnd1Shapes = new HashMap<Integer, Shape>();
            step.panelEnd2Shapes = new HashMap<Integer, Shape>();
            step.panelLine1Shapes = new HashMap<Integer, Shape>();
            step.panelLine2Shapes = new HashMap<Integer, Shape>();
            step.panelRotatorShapes = new HashMap<Integer, Shape>();
            step.panelTextLayouts = new HashMap<Integer, OSPRuntime.TextLayout>();
            step.panelLayoutBounds = new HashMap<Integer, Rectangle>();
        }
        return step;
    }

    @Override
    public String toString() {
        return "ProtractorStep";
    }

    public int n() {
        if (this.protractor.isFixedPosition() && this.protractor.tp != null) {
            return this.protractor.tp.getFrameNumber();
        }
        return this.n;
    }

    public static int getLength() {
        return 5;
    }

    private Point getLayoutPosition(TrackerPanel trackerPanel, OSPRuntime.TextLayout layout, TPoint end) {
        double scale = FontSizer.getFactor();
        Rectangle2D bounds = layout.getBounds();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        if (end == this.vertex) {
            Point p = this.vertex.getScreenPosition(trackerPanel);
            double angle = this.line1Angle - 1.5707963267948966;
            double sin = Math.sin(angle);
            double cos = Math.cos(angle);
            double halfhsin = h * sin / 2.0;
            double halfwcos = w * cos / 2.0;
            double d = Math.sqrt(halfhsin * halfhsin + halfwcos * halfwcos) + 8.0;
            if (this.getProtractorAngle(false) < 0.0) {
                p.setLocation((int)((double)p.x - d * cos - w / 2.0), (int)((double)p.y + d * sin + h / 2.0));
            } else {
                p.setLocation((int)((double)p.x + d * cos - w / 2.0), (int)((double)p.y - d * sin + h / 2.0));
            }
            return p;
        }
        middle.center(end, this.vertex);
        Point p = middle.getScreenPosition(trackerPanel);
        endPoint1.setLocation(end);
        endPoint2.setLocation(this.vertex);
        double cos = endPoint2.cos(endPoint1);
        double sin = endPoint2.sin(endPoint1);
        double d = scale * 6.0 + Math.abs(w * sin / 2.0) + Math.abs(h * cos / 2.0);
        if (cos >= 0.0) {
            p.setLocation((int)((double)p.x - d * sin - w / 2.0), (int)((double)p.y - d * cos + h / 2.0));
        } else {
            p.setLocation((int)((double)p.x + d * sin - w / 2.0), (int)((double)p.y + d * cos + h / 2.0));
        }
        return p;
    }

    class Handle
    extends Step.Handle {
        TPoint end;

        public Handle(double x, double y) {
            super(x, y);
            this.setTrackEditTrigger(true);
        }

        @Override
        public void setXY(double x, double y) {
            if (ProtractorStep.this.getTrack().locked) {
                return;
            }
            if (ProtractorStep.this.end1.isAttached() || ProtractorStep.this.end2.isAttached() || ProtractorStep.this.vertex.isAttached()) {
                return;
            }
            double dx = x - this.getX();
            double dy = y - this.getY();
            this.setLocation(x, y);
            if (ProtractorStep.this.protractor.isFixedPosition()) {
                ProtractorStep step = (ProtractorStep)ProtractorStep.this.protractor.steps.getStep(0);
                step.vertex.setLocation(ProtractorStep.this.vertex.getX() + dx, ProtractorStep.this.vertex.getY() + dy);
                step.end2.setLocation(ProtractorStep.this.end2.getX() + dx, ProtractorStep.this.end2.getY() + dy);
                step.end1.setLocation(ProtractorStep.this.end1.getX() + dx, ProtractorStep.this.end1.getY() + dy);
                step.erase();
                ProtractorStep.this.protractor.refreshStep(ProtractorStep.this);
            } else {
                ProtractorStep.this.vertex.setLocation(ProtractorStep.this.vertex.getX() + dx, ProtractorStep.this.vertex.getY() + dy);
                ProtractorStep.this.end2.setLocation(ProtractorStep.this.end2.getX() + dx, ProtractorStep.this.end2.getY() + dy);
                ProtractorStep.this.end1.setLocation(ProtractorStep.this.end1.getX() + dx, ProtractorStep.this.end1.getY() + dy);
                ProtractorStep.this.protractor.keyFrames.add(ProtractorStep.this.n);
            }
            ProtractorStep.this.repaint();
        }

        @Override
        public int getFrameNumber(VideoPanel vidPanel) {
            return ProtractorStep.this.n();
        }

        @Override
        public void setPositionOnLine(int xScreen, int yScreen, TrackerPanel trackerPanel) {
            this.setPositionOnLine(xScreen, yScreen, trackerPanel, ProtractorStep.this.vertex, this.end);
            ProtractorStep.this.repaint();
        }

        protected void setHandleEnd(TPoint end) {
            this.end = end;
        }
    }

    class Rotator
    extends TPoint {
        TPoint pt = new TPoint();

        public Rotator() {
            this.setTrackEditTrigger(true);
        }

        @Override
        public void setXY(double x, double y) {
            if (ProtractorStep.this.getTrack().locked) {
                return;
            }
            super.setXY(x, y);
            double theta = -ProtractorStep.this.vertex.angle(this);
            double arc = ProtractorStep.this.line2Angle - ProtractorStep.this.line1Angle;
            if (arc > Math.PI) {
                arc -= Math.PI * 2;
            }
            if (arc < -Math.PI) {
                arc += Math.PI * 2;
            }
            double midline = ProtractorStep.this.line1Angle + arc / 2.0;
            transform.setToRotation(midline - theta, ProtractorStep.this.vertex.x, ProtractorStep.this.vertex.y);
            if (ProtractorStep.this.protractor.isFixedPosition()) {
                ProtractorStep step = (ProtractorStep)ProtractorStep.this.protractor.steps.getStep(0);
                transform.transform(step.end1, step.end1);
                transform.transform(step.end2, step.end2);
                step.erase();
                ProtractorStep.this.protractor.refreshStep(ProtractorStep.this);
            } else {
                transform.transform(ProtractorStep.this.end1, ProtractorStep.this.end1);
                transform.transform(ProtractorStep.this.end2, ProtractorStep.this.end2);
                ProtractorStep.this.protractor.keyFrames.add(ProtractorStep.this.n);
            }
            ProtractorStep.this.getTrack().getStep(ProtractorStep.this.n).repaint();
        }

        @Override
        public int getFrameNumber(VideoPanel vidPanel) {
            return ProtractorStep.this.n();
        }

        protected void setScreenCoords(int x, int y) {
            this.pt.setScreenPosition(x, y, ProtractorStep.this.protractor.tp);
            this.setLocation(this.pt);
        }
    }

    class Tip
    extends TPoint {
        public Tip(double x, double y) {
            super(x, y);
            this.setTrackEditTrigger(true);
        }

        @Override
        public void setXY(double x, double y) {
            int r;
            double d;
            if (ProtractorStep.this.getTrack().locked) {
                return;
            }
            if (this != ProtractorStep.this.vertex && (d = ProtractorStep.this.vertex.distance(x, y)) > 0.01 && d < (double)(2 * (r = ProtractorFootprint.arcRadius))) {
                x = ProtractorStep.this.vertex.getX() + (double)(2 * r) * (x - ProtractorStep.this.vertex.getX()) / d;
                y = ProtractorStep.this.vertex.getY() + (double)(2 * r) * (y - ProtractorStep.this.vertex.getY()) / d;
            }
            if (ProtractorStep.this.protractor.isFixedPosition()) {
                ProtractorStep step = (ProtractorStep)ProtractorStep.this.protractor.steps.getStep(0);
                TPoint target = this == ProtractorStep.this.end1 ? step.end1 : (this == ProtractorStep.this.end2 ? step.end2 : step.vertex);
                target.setLocation(x, y);
                step.erase();
                ProtractorStep.this.protractor.refreshStep(ProtractorStep.this);
            } else {
                this.setLocation(x, y);
                ProtractorStep.this.protractor.keyFrames.add(ProtractorStep.this.n);
            }
            ProtractorStep.this.repaint();
            ProtractorStep.this.protractor.invalidateData(ProtractorStep.this.protractor);
        }

        @Override
        public int getFrameNumber(VideoPanel vidPanel) {
            return ProtractorStep.this.n();
        }

        @Override
        public void setAdjusting(boolean adjusting, MouseEvent e) {
            if (!adjusting && !this.isAdjusting()) {
                return;
            }
            if (this.isAdjusting && this.prevX == this.x && this.prevY == this.y) {
                return;
            }
            super.setAdjusting(adjusting, e);
            if (!adjusting) {
                ProtractorStep.this.protractor.firePropertyChange("step", null, new Integer(ProtractorStep.this.n()));
            }
        }
    }
}

