/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.MarkingRequired;
import org.opensourcephysics.cabrillo.tracker.PointShapeFootprint;
import org.opensourcephysics.cabrillo.tracker.RGBStep;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TMenuBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TTrackBar;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.IntegerField;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.FontSizer;

public class RGBRegion
extends TTrack
implements MarkingRequired {
    protected static final int defaultEdgeLength = 20;
    protected static final int defaultMaxEdgeLength = 200;
    protected static final String[] dataVariables = new String[]{"t", "x", "y", "R", "G", "B", "luma", "pixels", "step", "frame", "Rsd", "Gsd", "Bsd"};
    protected static final String[] fieldVariables = new String[]{"t", "x", "y"};
    protected static final String[] formatVariables = new String[]{"t", "xy", "RGB"};
    protected static final Map<String, String[]> formatMap = new HashMap<String, String[]>();
    protected static final Map<String, String> formatDescriptionMap;
    protected static final int SHAPE_ELLIPSE = 0;
    protected static final int SHAPE_RECTANGLE = 1;
    protected static final int SHAPE_POLYGON = 2;
    protected static final ArrayList<String> allVariables;
    protected boolean fixedPosition = true;
    protected boolean fixedShape = true;
    protected JCheckBoxMenuItem fixedPositionItem;
    protected JCheckBoxMenuItem fixedShapeItem;
    protected JLabel widthLabel;
    protected JLabel heightLabel;
    protected JLabel helpLabel;
    protected TButton editPolygonButton;
    protected JLabel unmarkedLabel;
    protected int maxEdgeLength = 200;
    protected int shapeType = 0;
    protected JComboBox<String> shapeTypeDropdown;
    protected IntegerField widthField;
    protected IntegerField heightField;
    protected ArrayList<RGBStep> validSteps = new ArrayList();
    protected boolean dataHidden = false;
    protected boolean loading;
    protected TreeSet<Integer> shapeKeyFrames = new TreeSet();
    protected XMLControl currentState;
    protected VertexHandle vertexHandle;

    static {
        formatMap.put("t", new String[]{"t"});
        formatMap.put("xy", new String[]{"x", "y"});
        formatMap.put("RGB", new String[]{"R", "G", "B", "luma", "Rsd", "Gsd", "Bsd"});
        formatDescriptionMap = new HashMap<String, String>();
        formatDescriptionMap.put(formatVariables[0], TrackerRes.getString("PointMass.Data.Description.0"));
        formatDescriptionMap.put(formatVariables[1], TrackerRes.getString("PointMass.Position.Name"));
        formatDescriptionMap.put(formatVariables[2], TrackerRes.getString("LineProfile.Description.RGB"));
        allVariables = RGBRegion.createAllVariables(dataVariables, null);
    }

    @Override
    public String[] getFormatVariables() {
        return formatVariables;
    }

    @Override
    public Map<String, String[]> getFormatMap() {
        return formatMap;
    }

    @Override
    public Map<String, String> getFormatDescMap() {
        return formatDescriptionMap;
    }

    @Override
    public String getBaseType() {
        return "RGBRegion";
    }

    @Override
    public String getVarDimsImpl(String variable) {
        String[] vars = dataVariables;
        String[] names = formatVariables;
        if (names[1].equals(variable) || vars[1].equals(variable) || vars[2].equals(variable)) {
            return "L";
        }
        if (vars[7].equals(variable) || vars[8].equals(variable) || vars[9].equals(variable)) {
            return "I";
        }
        if (names[2].equals(variable) || vars[3].equals(variable) || vars[4].equals(variable) || vars[5].equals(variable) || vars[6].equals(variable) || vars[10].equals(variable) || vars[11].equals(variable) || vars[12].equals(variable)) {
            return "C";
        }
        return null;
    }

    public RGBRegion() {
        super(7);
        this.defaultColors = new Color[]{Color.magenta};
        this.setName(TrackerRes.getString("RGBRegion.New.Name"));
        this.setProperty("yVarPlot0", dataVariables[6]);
        this.setProperty("yMinPlot0", 0.0);
        this.setProperty("yMaxPlot0", 255.0);
        this.setProperty("tableVar0", "0");
        this.setProperty("tableVar1", "1");
        this.setProperty("tableVar2", "5");
        this.setFootprints(new Footprint[]{PointShapeFootprint.getFootprint("Footprint.Shape"), PointShapeFootprint.getFootprint("Footprint.BoldShape")});
        this.defaultFootprint = this.getFootprint();
        this.setColor(this.defaultColors[0]);
        this.partName = TrackerRes.getString("TTrack.Selected.Hint");
        this.hint = TrackerRes.getString("RGBRegion.Unmarked.Hint");
        this.widthLabel = new JLabel();
        this.widthLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
        this.heightLabel = new JLabel("h");
        this.heightLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
        this.helpLabel = new JLabel();
        this.helpLabel.setForeground(Color.red.darker());
        this.helpLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
        this.editPolygonButton = new TButton(){

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = super.getMaximumSize();
                dim.height = RGBRegion.this.tp.getTrackBar((boolean)true).toolbarComponentHeight;
                return dim;
            }
        };
        this.editPolygonButton.addActionListener(e -> {
            int n = this.tp.getFrameNumber();
            RGBStep step = (RGBStep)this.getStep(n);
            if (!this.isFixedShape() && !this.shapeKeyFrames.contains(n)) {
                this.shapeKeyFrames.add(n);
                step.polygon = step.polygon.copy();
                step.rgbShape = step.polygon;
            }
            step.polygon.setClosed(false);
            step.repaint();
            this.tp.getTrackBar(false).refresh();
        });
        FocusAdapter sizeFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                RGBRegion.this.refreshShapeSize((IntegerField)e.getSource());
            }
        };
        ActionListener sizeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntegerField field = (IntegerField)e.getSource();
                RGBRegion.this.refreshShapeSize(field);
                field.selectAll();
                field.requestFocusInWindow();
            }
        };
        this.widthField = new IntegerField(2);
        this.widthField.setMinValue(1.0);
        this.widthField.addFocusListener(sizeFocusListener);
        this.widthField.addActionListener(sizeActionListener);
        this.widthField.addMouseListener(this.formatMouseListener);
        this.heightField = new IntegerField(2);
        this.heightField.setMinValue(1.0);
        this.heightField.addFocusListener(sizeFocusListener);
        this.heightField.addActionListener(sizeActionListener);
        this.heightField.addMouseListener(this.formatMouseListener);
        this.shapeTypeDropdown = new JComboBox();
        this.shapeTypeDropdown.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.shapeTypeDropdown.setOpaque(false);
        this.shapeTypeDropdown.setEditable(false);
        this.shapeTypeDropdown.addItem(TrackerRes.getString("RGBRegion.ShapeType.Ellipse"));
        this.shapeTypeDropdown.addItem(TrackerRes.getString("RGBRegion.ShapeType.Rectangle"));
        this.shapeTypeDropdown.addItem(TrackerRes.getString("RGBRegion.ShapeType.Polygon"));
        this.shapeTypeDropdown.addActionListener(e -> this.setShapeType(this.shapeTypeDropdown.getSelectedIndex()));
        this.fixedPositionItem = new JCheckBoxMenuItem(TrackerRes.getString("RGBRegion.MenuItem.Fixed"));
        this.fixedPositionItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RGBRegion.this.setFixedPosition(RGBRegion.this.fixedPositionItem.isSelected());
            }
        });
        this.fixedShapeItem = new JCheckBoxMenuItem(TrackerRes.getString("RGBRegion.MenuItem.FixedShape"));
        this.fixedShapeItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RGBRegion.this.setFixedShape(RGBRegion.this.fixedShapeItem.isSelected());
            }
        });
        AbstractAction positionAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberField field = (NumberField)e.getSource();
                if (field.getBackground() == Color.yellow) {
                    RGBRegion.this.setPositionFromFields();
                }
                field.selectAll();
                field.requestFocusInWindow();
            }
        };
        FocusAdapter positionFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                NumberField field = (NumberField)e.getSource();
                if (field.getBackground() == Color.yellow) {
                    RGBRegion.this.setPositionFromFields();
                }
            }
        };
        this.xField.addActionListener(positionAction);
        this.yField.addActionListener(positionAction);
        this.xField.addFocusListener(positionFocusListener);
        this.yField.addFocusListener(positionFocusListener);
        this.vertexHandle = new VertexHandle();
        this.unmarkedLabel = new JLabel();
        this.unmarkedLabel.setForeground(Color.red.darker());
    }

    private void refreshShapeSize(IntegerField field) {
        if (field.getBackground() == Color.yellow) {
            this.setShapeSize(this.tp.getFrameNumber(), this.widthField.getIntValue(), this.heightField.getIntValue());
        }
    }

    @Override
    public void setFixedPosition(boolean fixed) {
        if (this.fixedPosition == fixed) {
            return;
        }
        if (this.steps.isEmpty()) {
            this.fixedPosition = fixed;
            return;
        }
        XMLControlElement control = new XMLControlElement(this);
        if (this.tp != null) {
            this.tp.changed = true;
            int n = this.tp.getFrameNumber();
            RGBStep keyStep = (RGBStep)this.getStep(n);
            Step[] stepArray = this.steps.array;
            int n2 = this.steps.array.length;
            int n3 = 0;
            while (n3 < n2) {
                Step next = stepArray[n3];
                if (next != null) {
                    RGBStep step = (RGBStep)next;
                    step.getPosition().setLocation(keyStep.getPosition());
                }
                ++n3;
            }
        }
        this.fixedPosition = fixed;
        if (fixed) {
            this.keyFrames.clear();
            this.keyFrames.add(0);
            this.clearData();
            this.refreshData(this.datasetManager, this.tp);
            this.firePropertyChange("data", null, null);
        }
        if (!this.loading) {
            Undo.postTrackEdit(this, control);
        }
        this.repaint();
    }

    public boolean isFixedPosition() {
        return this.fixedPosition;
    }

    @Override
    protected String getTargetDescription(int pointIndex) {
        return TrackerRes.getString("PointMass.Position.Name");
    }

    protected void setShapeType(int type) {
        Shape shape;
        if (this.shapeType == type) {
            return;
        }
        this.shapeType = type;
        int i = 0;
        while (i < this.steps.array.length) {
            RGBStep step = (RGBStep)this.steps.getStep(i);
            if (step != null) {
                step.rgbShape = null;
                step.dataValid = false;
            }
            ++i;
        }
        if (this.shapeType == 0) {
            shape = new Ellipse2D.Double(-5.0, -5.0, 10.0, 10.0);
        } else if (this.shapeType == 1) {
            shape = new Rectangle(-5, -5, 10, 10);
        } else {
            int[] nArray = new int[5];
            nArray[0] = -6;
            nArray[2] = 5;
            nArray[4] = -2;
            shape = new Polygon(nArray, new int[]{-1, -5, -1, 1, 6}, 5);
        }
        Shape shape2 = shape;
        int i2 = 0;
        while (i2 < this.getFootprints().length) {
            ((PointShapeFootprint)this.getFootprints()[i2]).setShape(shape2);
            ++i2;
        }
        this.erase();
        if (this.tp != null) {
            TTrackBar trackBar = this.tp.getTrackBar(false);
            if (trackBar != null) {
                trackBar.refresh();
            }
            this.tp.changed = true;
            this.tp.refreshTrackData(0x8000000);
        }
        this.firePropertyChange("footprint", null, this.footprint);
    }

    public void setFixedShape(boolean fixed) {
        if (this.fixedShape == fixed) {
            return;
        }
        if (this.steps.isEmpty()) {
            this.fixedShape = fixed;
            return;
        }
        XMLControlElement control = new XMLControlElement(this);
        if (this.tp != null) {
            this.tp.changed = true;
            int n = this.tp.getFrameNumber();
            RGBStep keyStep = (RGBStep)this.getStep(n);
            Step[] stepArray = this.steps.array;
            int n2 = this.steps.array.length;
            int n3 = 0;
            while (n3 < n2) {
                Step next = stepArray[n3];
                if (next != null) {
                    RGBStep step = (RGBStep)next;
                    step.setShapeSize(keyStep.width, keyStep.height);
                }
                ++n3;
            }
        }
        this.fixedShape = fixed;
        if (fixed) {
            this.shapeKeyFrames.clear();
            this.shapeKeyFrames.add(0);
            this.clearData();
            this.refreshData(this.datasetManager, this.tp);
            this.firePropertyChange("data", null, null);
        }
        if (!this.loading) {
            Undo.postTrackEdit(this, control);
        }
        this.repaint();
    }

    public boolean isFixedShape() {
        return this.fixedShape;
    }

    protected void setShapeSize(int n, int width, int height) {
        RGBStep step;
        if (this.isLocked() || height == Integer.MIN_VALUE || width == Integer.MIN_VALUE || this.tp == null) {
            return;
        }
        width = Math.max(width, 0);
        width = Math.min(width, this.maxEdgeLength);
        this.widthField.setIntValue(width);
        height = Math.max(height, 0);
        height = Math.min(height, this.maxEdgeLength);
        this.heightField.setIntValue(height);
        RGBStep keyStep = step = (RGBStep)this.getStep(n);
        if (step != null && (step.height != height || step.width != width)) {
            TPoint selection = this.tp.getSelectedPoint();
            this.tp.setSelectedPoint(null);
            this.tp.selectedSteps.clear();
            XMLControlElement state = new XMLControlElement(step);
            if (this.isFixedShape()) {
                keyStep = (RGBStep)this.steps.getStep(0);
                this.clearData();
                keyStep.setShapeSize(width, height);
                this.refreshStep(step);
            } else {
                this.shapeKeyFrames.add(n);
                step.setShapeSize(width, height);
                step.dataValid = false;
            }
            Undo.postStepEdit(step, state);
            this.tp.setSelectedPoint(selection);
            this.refreshData(this.datasetManager, this.tp);
            step.repaint();
            this.tp.changed = true;
            this.firePropertyChange("step", null, new Integer(n));
        }
    }

    public Dimension getShapeSize() {
        int n;
        RGBStep step;
        if (this.isFixedShape()) {
            RGBStep step2 = (RGBStep)this.getStep(0);
            if (step2 != null) {
                return new Dimension(step2.width, step2.height);
            }
        } else if (this.tp != null && !this.fixedShape && (step = (RGBStep)this.getStep(n = this.tp.getFrameNumber())) != null) {
            return new Dimension(step.width, step.height);
        }
        return new Dimension(20, 20);
    }

    @Override
    public void draw(DrawingPanel panel, Graphics _g) {
        super.draw(panel, _g);
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        Interactive ia = super.findInteractive(panel, xpix, ypix);
        if (ia != null) {
            this.partName = TrackerRes.getString("RGBRegion.Position.Name");
            this.hint = TrackerRes.getString("RGBRegion.Position.Hint");
        } else {
            this.partName = TrackerRes.getString("TTrack.Selected.Hint");
            this.hint = this.getStep(this.tp.getFrameNumber()) == null ? TrackerRes.getString("RGBRegion.Unmarked.Hint") : TrackerRes.getString("RGBRegion.Hint");
            if (this.tp.getVideo() == null) {
                this.hint = String.valueOf(this.hint) + ", " + TrackerRes.getString("TTrack.ImportVideo.Hint");
            }
        }
        return ia;
    }

    @Override
    protected void setMarking(boolean marking) {
        super.setMarking(marking);
        this.repaint(this.tp.getID());
    }

    @Override
    public void setTrailVisible(boolean visible) {
    }

    @Override
    public void setLocked(boolean lock) {
        super.setLocked(lock);
        if (this.tp != null) {
            this.tp.getTrackBar(false).refresh();
        }
    }

    @Override
    public boolean isAutoAdvance() {
        return !this.isFixedPosition() && !this.isPolygonEditing();
    }

    @Override
    public boolean isMarkByDefault() {
        return this.requiresMarking() || super.isMarkByDefault();
    }

    @Override
    public boolean requiresMarking() {
        RGBStep step = (RGBStep)this.getStep(0);
        return step == null && this.shapeType != 2;
    }

    @Override
    public Step createStep(int n, double x, double y) {
        if (this.isLocked()) {
            return null;
        }
        int frame = this.isFixedPosition() && this.isFixedShape() ? 0 : n;
        RGBStep step = (RGBStep)this.steps.getStep(frame);
        if (step == null) {
            int w = this.widthField.getIntValue();
            int h = this.heightField.getIntValue();
            if (w == 0) {
                h = 20;
                w = 20;
            }
            step = new RGBStep(this, 0, x, y, w, h);
            step.setFootprint(this.getFootprint());
            this.steps = new TTrack.StepArray(this, step);
            this.keyFrames.add(0);
            this.shapeKeyFrames.add(0);
        } else {
            if (this.currentState == null) {
                this.currentState = new XMLControlElement(this);
            }
            if (!this.loading && this.shapeType == 2 && !step.isPolygonClosed()) {
                step = (RGBStep)this.getStep(n);
                step.append(x, y);
                if (!this.isFixedShape()) {
                    this.shapeKeyFrames.add(n);
                }
                if (step.polygon.vertices.size() > 1) {
                    this.prepareVertexHandle(step, step.polygon.vertices.size() - 2);
                }
            } else {
                if (this.isFixedPosition()) {
                    ((RGBStep)this.steps.getStep(0)).getPosition().setLocation(x, y);
                } else {
                    step.getPosition().setLocation(x, y);
                    this.keyFrames.add(n);
                }
                if (!this.loading) {
                    Undo.postTrackEdit(this, this.currentState);
                    this.currentState = null;
                }
            }
        }
        this.firePropertyChange("step", HINT_STEP_ADDED_OR_REMOVED, n);
        return this.getStep(n);
    }

    @Override
    public Step deleteStep(int n) {
        if (this.shapeType != 2 || this.tp.getSelectedPoint() != this.vertexHandle) {
            return null;
        }
        RGBStep step = (RGBStep)this.steps.getStep(n);
        if (step != null && step.getPolygonVertexCount() > 1) {
            if (!this.isFixedShape() && !this.shapeKeyFrames.contains(n)) {
                this.shapeKeyFrames.add(n);
                step.polygon = step.polygon.copy();
                step.rgbShape = step.polygon;
            }
            step.polygon.remove(this.vertexHandle.vertex);
            this.tp.setSelectedPoint(step.position);
            if (step.polygon.vertices.size() > this.vertexHandle.vertex) {
                this.prepareVertexHandle(step, this.vertexHandle.vertex);
            }
            step.repaint();
        }
        return null;
    }

    @Override
    public Step getStep(TPoint point, TrackerPanel trackerPanel) {
        if (point == null) {
            return null;
        }
        Step[] stepArray = this.steps.array;
        if (point == this.vertexHandle) {
            return stepArray[this.vertexHandle.n];
        }
        int j = 0;
        while (j < stepArray.length) {
            TPoint[] points;
            if (stepArray[j] != null && (points = stepArray[j].getPoints())[0] == point) {
                return stepArray[j];
            }
            ++j;
        }
        return null;
    }

    @Override
    public Step getStep(int n) {
        RGBStep step = (RGBStep)this.steps.getStep(n);
        this.refreshStep(step);
        return step;
    }

    @Override
    public int getStepLength() {
        return RGBStep.getLength();
    }

    @Override
    public TPoint autoMarkAt(int n, double x, double y) {
        this.setFixedPosition(false);
        return super.autoMarkAt(n, x, y);
    }

    @Override
    protected boolean isAutoTrackable() {
        return true;
    }

    @Override
    public int getFootprintLength() {
        return 1;
    }

    protected void clearData() {
        if (this.datasetManager == null) {
            return;
        }
        int i = 0;
        while (i < 7) {
            Dataset next = this.datasetManager.getDataset(i);
            next.clear();
            ++i;
        }
        Step[] steps = this.getSteps();
        int i2 = 0;
        while (i2 < steps.length) {
            if (steps[i2] != null) {
                steps[i2].dataVisible = false;
                ((RGBStep)steps[i2]).dataValid = false;
            }
            ++i2;
        }
    }

    protected void hideData() {
        Step[] steps = this.getSteps();
        int i = 0;
        while (i < steps.length) {
            if (steps[i] != null) {
                steps[i].dataVisible = false;
            }
            ++i;
        }
        this.dataHidden = true;
    }

    @Override
    protected void refreshData(DatasetManager data, TrackerPanel trackerPanel) {
        if (this.refreshDataLater || trackerPanel == null || data == null) {
            return;
        }
        this.dataFrames.clear();
        int frame = trackerPanel.getFrameNumber();
        Step step = this.getStep(frame);
        if (step != null) {
            ((RGBStep)step).getRGBData(trackerPanel);
        }
        int count = 12;
        Step[] stepArray = this.getSteps();
        this.validSteps.clear();
        VideoPlayer player = trackerPanel.getPlayer();
        VideoClip clip = player.getVideoClip();
        int n = 0;
        while (n < stepArray.length) {
            RGBStep next = (RGBStep)stepArray[n];
            if (next != null && next.dataValid && next.getRGBData(trackerPanel) != null) {
                TPoint p = next.getPosition();
                int stepFrame = p.getFrameNumber(trackerPanel);
                if (clip.includesFrame(stepFrame)) {
                    this.validSteps.add(next);
                } else {
                    next.dataVisible = false;
                }
            }
            ++n;
        }
        RGBStep[] valid = this.validSteps.toArray(new RGBStep[0]);
        int len = valid.length;
        double[][] validData = new double[count + 1][len];
        int i = 0;
        while (i < len) {
            double[] rgb = valid[i].getRGBData(trackerPanel);
            TPoint p = valid[i].getPosition();
            int stepFrame = p.getFrameNumber(trackerPanel);
            this.dataFrames.add(new Integer(stepFrame));
            int stepNumber = clip.frameToStep(stepFrame);
            double t = player.getStepTime(stepNumber) / 1000.0;
            Point2D pt = p.getWorldPosition(trackerPanel);
            validData[0][i] = pt.getX();
            validData[1][i] = pt.getY();
            int j = 2;
            while (j < 7) {
                validData[j][i] = rgb[j - 2];
                ++j;
            }
            validData[7][i] = stepNumber;
            validData[8][i] = stepFrame;
            j = 9;
            while (j < 12) {
                validData[j][i] = rgb[j - 4];
                ++j;
            }
            validData[12][i] = t;
            ++i;
        }
        this.clearColumns(data, count, dataVariables, "RGBRegion.Data.Description.", validData, len);
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel, JMenu menu0) {
        JMenu menu = super.getMenu(trackerPanel, menu0);
        if (menu0 == null) {
            return menu;
        }
        this.fixedPositionItem.setText(TrackerRes.getString("RGBRegion.MenuItem.Fixed"));
        this.fixedPositionItem.setSelected(this.isFixedPosition());
        this.fixedPositionItem.setEnabled(!this.isLocked());
        this.fixedShapeItem.setText(TrackerRes.getString("RGBRegion.MenuItem.FixedShape"));
        this.fixedShapeItem.setSelected(this.isFixedShape());
        this.fixedShapeItem.setEnabled(!this.isLocked());
        menu.remove(this.deleteTrackItem);
        TMenuBar.checkAddMenuSep(menu);
        menu.add(this.fixedPositionItem);
        menu.add(this.fixedShapeItem);
        if (trackerPanel.isEnabled("track.delete")) {
            TMenuBar.checkAddMenuSep(menu);
            menu.add(this.deleteTrackItem);
        }
        return menu;
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        ArrayList<Component> list = super.getToolbarTrackComponents(trackerPanel);
        if (!this.isLocked()) {
            this.shapeTypeDropdown.setSelectedIndex(this.shapeType);
            FontSizer.setFonts(this.shapeTypeDropdown, FontSizer.getLevel());
            list.add(this.shapeTypeDropdown);
        }
        int n = trackerPanel.getFrameNumber();
        RGBStep step = (RGBStep)this.getStep(n);
        if (this.shapeType == 2) {
            if (!this.isLocked()) {
                this.editPolygonButton.setText(TrackerRes.getString("RGBRegion.Button.Edit.Text"));
                FontSizer.setFonts(this.editPolygonButton, FontSizer.getLevel());
                if (step == null || !step.isPolygonClosed()) {
                    this.helpLabel.setText(TrackerRes.getString("RGBRegion.Label.MarkPolygon.Text"));
                    FontSizer.setFonts(this.helpLabel, FontSizer.getLevel());
                    list.add(this.helpLabel);
                } else {
                    list.add(this.editPolygonButton);
                }
            }
        } else {
            this.widthLabel.setText("w");
            list.add(this.widthLabel);
            Dimension dim = this.getShapeSize();
            this.widthField.setIntValue(dim.width);
            this.widthField.setEnabled(!this.isLocked());
            list.add(this.widthField);
            list.add(this.heightLabel);
            this.heightField.setIntValue(dim.height);
            this.heightField.setEnabled(!this.isLocked());
            list.add(this.heightField);
        }
        if (step == null) {
            if (this.shapeType != 2) {
                list.add(this.magSeparator);
                this.unmarkedLabel.setText(TrackerRes.getString("RGBRegion.Unmarked.Hint"));
                list.add(this.unmarkedLabel);
            }
            return list;
        }
        if (this.shapeType == 2 && !step.isPolygonClosed()) {
            return list;
        }
        this.stepLabel.setText(TrackerRes.getString("TTrack.Label.Step"));
        this.xLabel.setText(dataVariables[1]);
        this.yLabel.setText(dataVariables[2]);
        this.xField.setUnits(trackerPanel.getUnits(this, dataVariables[1]));
        this.yField.setUnits(trackerPanel.getUnits(this, dataVariables[2]));
        this.xField.setEnabled(!this.isLocked());
        this.yField.setEnabled(!this.isLocked());
        this.stepLabel.setText(TrackerRes.getString("TTrack.Label.Step"));
        VideoClip clip = trackerPanel.getPlayer().getVideoClip();
        n = clip.frameToStep(n);
        this.stepValueLabel.setText(String.valueOf(n) + ":");
        list.add(this.stepSeparator);
        list.add(this.stepLabel);
        list.add(this.stepValueLabel);
        list.add(this.tSeparator);
        list.add(this.xLabel);
        list.add(this.xField);
        list.add(this.xSeparator);
        list.add(this.yLabel);
        list.add(this.yField);
        list.add(this.ySeparator);
        return list;
    }

    @Override
    public ArrayList<Component> getToolbarPointComponents(TrackerPanel trackerPanel, TPoint point) {
        ArrayList<Component> list = super.getToolbarPointComponents(trackerPanel, point);
        return list;
    }

    @Override
    public void setFontLevel(int level) {
        super.setFontLevel(level);
        Object[] objectsToSize = new Object[]{this.unmarkedLabel, this.widthLabel};
        FontSizer.setFonts(objectsToSize, level);
    }

    @Override
    public void setTrackerPanel(TrackerPanel panel) {
        if (this.tp != null) {
            this.tp.removePropertyChangeListener("image", this);
        }
        super.setTrackerPanel(panel);
        if (this.tp != null) {
            this.tp.addPropertyChangeListener("image", this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        block19: {
            if (this.tp == null) break block19;
            if (this.maxEdgeLength == 200 && this.tp.getVideo() != null) {
                this.setMaxEdgeLength(this.tp.getVideo());
            }
            switch (e.getPropertyName()) {
                case "stepnumber": {
                    this.invalidateData(Boolean.FALSE);
                    int n = this.tp.getFrameNumber();
                    RGBStep step = (RGBStep)this.getStep(n);
                    if (step != null) {
                        this.widthField.setIntValue(step.width);
                        this.heightField.setIntValue(step.height);
                        Point2D p = step.position.getWorldPosition(this.tp);
                        this.xField.setValue(p.getX());
                        this.yField.setValue(p.getY());
                    }
                    this.stepValueLabel.setText(e.getNewValue() + ":");
                    this.checkPolygonEditing();
                    if (this.isFixedShape() || this.shapeType != 2) break;
                    this.tp.getTrackBar(false).refresh();
                    break;
                }
                case "image": {
                    this.invalidateData(Boolean.FALSE);
                    Video vid = this.tp.getVideo();
                    if (vid == null) {
                        this.clearData();
                    } else if (!vid.isVisible()) {
                        this.hideData();
                    } else if (!this.dataHidden && vid.isVisible()) {
                        this.clearData();
                    } else {
                        this.dataHidden = false;
                    }
                    if (vid != null) {
                        this.setMaxEdgeLength(vid);
                    }
                    this.firePropertyChange(e);
                }
            }
        }
        super.propertyChange(e);
    }

    private void setMaxEdgeLength(Video video2) {
        Dimension d = video2.getImageSize(true);
        this.maxEdgeLength = Math.min(d.height, d.width) - 1;
    }

    @Override
    public String toString() {
        return TrackerRes.getString("RGBRegion.Name");
    }

    @Override
    public Map<String, NumberField[]> getNumberFields() {
        if (this.numberFields.isEmpty()) {
            this.numberFields.put(dataVariables[0], new NumberField[]{this.tField});
            this.numberFields.put(dataVariables[1], new NumberField[]{this.xField});
            this.numberFields.put(dataVariables[2], new NumberField[]{this.yField});
        }
        return this.numberFields;
    }

    private void setPositionFromFields() {
        double xValue = this.xField.getValue();
        double yValue = this.yField.getValue();
        int n = this.tp.getFrameNumber();
        RGBStep step = (RGBStep)this.getStep(n);
        if (step != null) {
            RGBStep.Position p = step.position;
            ImageCoordSystem coords = this.tp.getCoords();
            double x = coords.worldToImageX(n, xValue, yValue);
            double y = coords.worldToImageY(n, xValue, yValue);
            ((TPoint)p).setXY(x, y);
            Point2D worldPt = p.getWorldPosition(this.tp);
            this.xField.setValue(worldPt.getX());
            this.yField.setValue(worldPt.getY());
        }
    }

    protected void refreshStep(RGBStep step) {
        boolean differentPosition;
        if (step == null) {
            return;
        }
        int key = 0;
        if (!this.isFixedPosition()) {
            Iterator iterator = this.keyFrames.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (i > step.n) continue;
                key = i;
            }
        }
        int shapeKey = 0;
        if (!this.isFixedShape()) {
            for (int i : this.shapeKeyFrames) {
                if (i > step.n) continue;
                shapeKey = i;
            }
        }
        RGBStep positionKeyStep = (RGBStep)this.steps.getStep(key);
        double x = positionKeyStep.getPosition().getX();
        double y = positionKeyStep.getPosition().getY();
        boolean bl = differentPosition = x != step.getPosition().getX() || y != step.getPosition().getY();
        if (differentPosition) {
            step.getPosition().setLocation(x, y);
            step.erase();
            step.dataValid = false;
        }
        RGBStep shapeKeyStep = (RGBStep)this.steps.getStep(shapeKey);
        if (this.shapeType == 2 && shapeKeyStep.polygon == null) {
            int i = 0;
            while (i < this.steps.array.length) {
                RGBStep aStep = (RGBStep)this.steps.getStep(i);
                if (aStep.polygon != null) {
                    shapeKeyStep.polygon = aStep.polygon.copy();
                    shapeKeyStep.rgbShape = shapeKeyStep.polygon;
                    break;
                }
                ++i;
            }
        }
        if (this.isDifferentShape(step, shapeKeyStep)) {
            if (this.shapeType == 2) {
                step.polygon = shapeKeyStep.polygon;
                step.rgbShape = step.polygon;
            } else {
                step.setShapeSize(shapeKeyStep.width, shapeKeyStep.height);
            }
            step.erase();
            step.dataValid = false;
        }
    }

    private boolean isDifferentShape(RGBStep step, RGBStep keyStep) {
        if (this.shapeType == 2) {
            return step.polygon != keyStep.polygon;
        }
        return keyStep.width != step.width || keyStep.height != step.height;
    }

    private boolean isPolygonEditing() {
        if (this.shapeType != 2) {
            return false;
        }
        RGBStep step = (RGBStep)this.steps.getStep(this.tp.getFrameNumber());
        return step != null && !step.isPolygonClosed();
    }

    protected void prepareVertexHandle(RGBStep step, int i) {
        this.vertexHandle.vertex = i;
        this.vertexHandle.n = step.n;
        Point2D pt = step.polygon.vertices.get(i + 1);
        this.vertexHandle.setLocation(step.position.getX() + pt.getX(), step.position.getY() + pt.getY());
    }

    protected void checkPolygonEditing() {
        if (this.shapeType != 2 || this.tp == null) {
            return;
        }
        RGBStep step = (RGBStep)this.steps.getStep(this.tp.getFrameNumber());
        if (!step.isPolygonClosed() && step.getPolygonVertexCount() > 2) {
            SwingUtilities.invokeLater(() -> {
                if (this.tp.getSelectedPoint() != rGBStep.position && this.tp.getSelectedPoint() != this.vertexHandle) {
                    rGBStep.polygon.setClosed(true);
                    this.repaint();
                    this.tp.getTrackBar(false).refresh();
                    if (this.currentState != null) {
                        Undo.postTrackEdit(this, this.currentState);
                        this.currentState = null;
                    }
                }
            });
        }
    }

    public static double getLuma(double r, double g, double b) {
        return 0.299 * r + 0.587 * g + 0.114 * b;
    }

    public static XML.ObjectLoader getLoader() {
        XML.setLoader(FrameData.class, new FrameDataLoader());
        return new Loader();
    }

    private static class FrameData {
        double x;
        double y;
        int r;

        FrameData() {
        }
    }

    private static class FrameDataLoader
    implements XML.ObjectLoader {
        private FrameDataLoader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
        }

        @Override
        public Object createObject(XMLControl control) {
            return new FrameData();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            FrameData data = (FrameData)obj;
            data.x = control.getDouble("x");
            data.y = control.getDouble("y");
            data.r = control.getInt("r");
            return obj;
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            RGBRegion region = (RGBRegion)obj;
            XML.getLoader(TTrack.class).saveObject(control, obj);
            control.setValue("fixed", region.isFixedPosition());
            control.setValue("fixed_shape", region.isFixedShape());
            control.setValue("shape_type", region.shapeType);
            if (!region.steps.isEmpty()) {
                Step[] steps = region.getSteps();
                int count = region.isFixedPosition() ? 1 : steps.length;
                double[][] positions = new double[count][];
                int n = 0;
                while (n < count) {
                    if (steps[n] != null && region.keyFrames.contains(n)) {
                        RGBStep.Position next = ((RGBStep)steps[n]).position;
                        positions[n] = new double[]{next.x, next.y};
                    }
                    ++n;
                }
                control.setValue("positions", positions);
                count = region.isFixedShape() ? 1 : steps.length;
                double[][][] shapes = new double[count][][];
                int n2 = 0;
                while (n2 < count) {
                    if (steps[n2] != null && region.shapeKeyFrames.contains(n2)) {
                        RGBStep step = (RGBStep)steps[n2];
                        shapes[n2] = region.shapeType == 2 ? step.getPolygonVertices() : (double[][])new double[][]{{step.width, step.height}};
                    }
                    ++n2;
                }
                control.setValue("shapes", shapes);
                count = steps.length;
                int first = 0;
                int last = count - 1;
                if (region.tp != null) {
                    first = region.tp.getPlayer().getVideoClip().getStartFrameNumber();
                    last = region.tp.getPlayer().getVideoClip().getEndFrameNumber();
                }
                double[][] rgb = new double[last + 1][];
                int n3 = first;
                while (n3 <= last) {
                    if (n3 <= steps.length - 1 && steps[n3] != null && ((RGBStep)steps[n3]).dataValid) {
                        double[] stepRGB = ((RGBStep)steps[n3]).rgbData;
                        rgb[n3] = new double[7];
                        System.arraycopy(stepRGB, 0, rgb[n3], 0, 3);
                        System.arraycopy(stepRGB, 4, rgb[n3], 3, 4);
                    }
                    ++n3;
                }
                control.setValue("rgb", rgb);
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            RGBRegion region = new RGBRegion();
            return region;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            double[][] rgb;
            Integer[] radii;
            RGBStep step;
            RGBStep step2;
            double[][][] shapes;
            RGBRegion region = (RGBRegion)obj;
            XML.getLoader(TTrack.class).loadObject(control, obj);
            boolean locked = region.isLocked();
            region.setLocked(false);
            region.loading = true;
            region.fixedPosition = control.getBoolean("fixed");
            region.fixedShape = control.getPropertyNamesRaw().contains("fixed_radius") ? control.getBoolean("fixed_radius") : control.getBoolean("fixed_shape");
            int type = control.getInt("shape_type");
            region.setShapeType(type == Integer.MIN_VALUE ? 0 : type);
            region.keyFrames.clear();
            region.shapeKeyFrames.clear();
            double[][] positions = (double[][])control.getObject("positions");
            if (positions != null) {
                int n = 0;
                while (n < positions.length) {
                    if (positions[n] != null) {
                        region.createStep(n, positions[n][0], positions[n][1]);
                    }
                    ++n;
                }
            }
            if ((shapes = (double[][][])control.getObject("shapes")) != null) {
                region.shapeKeyFrames.clear();
                int n = 0;
                while (n < shapes.length) {
                    if (shapes[n] != null) {
                        step2 = (RGBStep)region.steps.getStep(n);
                        step2.rgbShape = null;
                        step2.dataValid = false;
                        if (region.shapeType == 2) {
                            step2.setPolygonVertices(shapes[n]);
                        } else {
                            step2.setShapeSize(shapes[n][0][0], shapes[n][0][1]);
                        }
                        region.shapeKeyFrames.add(n);
                    }
                    ++n;
                }
            } else {
                int i = 0;
                while (i < region.steps.array.length) {
                    step2 = (RGBStep)region.steps.getStep(i);
                    if (step2 != null) {
                        step2.rgbShape = null;
                        step2.dataValid = false;
                    }
                    ++i;
                }
            }
            if (control.getPropertyNamesRaw().contains("framedata")) {
                Object dataObj = control.getObject("framedata");
                FrameData[] data = null;
                data = dataObj instanceof FrameData ? new FrameData[]{(FrameData)dataObj} : (FrameData[])dataObj;
                if (data != null) {
                    int n = 0;
                    while (n < data.length) {
                        if (data[n] != null) {
                            step = (RGBStep)region.createStep(n, data[n].x, data[n].y);
                            if (data[n].r != Integer.MIN_VALUE) {
                                step.setShapeSize(2 * data[n].r, 2 * data[n].r);
                                region.shapeKeyFrames.add(n);
                            }
                        }
                        ++n;
                    }
                }
            }
            if ((radii = (Integer[])control.getObject("radii")) != null) {
                region.shapeKeyFrames.clear();
                int n = 0;
                while (n < radii.length) {
                    if (radii[n] != null) {
                        RGBStep step3 = (RGBStep)region.steps.getStep(n);
                        int side = 2 * radii[n];
                        step3.setShapeSize(side, side);
                        region.shapeKeyFrames.add(n);
                    }
                    ++n;
                }
            }
            if ((rgb = (double[][])control.getObject("rgb")) != null) {
                int n = 0;
                while (n < rgb.length) {
                    if (rgb[n] != null) {
                        step = (RGBStep)region.steps.getStep(n);
                        System.arraycopy(rgb[n], 0, step.rgbData, 0, 3);
                        System.arraycopy(rgb[n], 3, step.rgbData, 4, rgb[n].length >= 7 ? 4 : 1);
                        step.rgbData[3] = RGBRegion.getLuma(rgb[n][0], rgb[n][1], rgb[n][2]);
                        region.refreshStep(step);
                        step.dataValid = true;
                    }
                    ++n;
                }
            }
            region.setLocked(locked);
            region.loading = false;
            region.repaint();
            return obj;
        }
    }

    protected class VertexHandle
    extends TPoint {
        int vertex;
        int n;

        protected VertexHandle() {
        }

        @Override
        public void setXY(double x, double y) {
            if (RGBRegion.this.isLocked()) {
                return;
            }
            this.setLocation(x, y);
            int n = RGBRegion.this.tp.getFrameNumber();
            RGBStep step = (RGBStep)RGBRegion.this.getStep(n);
            if (!RGBRegion.this.isFixedShape() && !RGBRegion.this.shapeKeyFrames.contains(n)) {
                RGBRegion.this.shapeKeyFrames.add(n);
                step.polygon = step.polygon.copy();
                step.rgbShape = step.polygon;
            }
            Point2D pt = step.polygon.vertices.get(this.vertex + 1);
            pt.setLocation(x - step.position.x, y - step.position.y);
            step.polygon.modify();
            if (RGBRegion.this.isFixedShape()) {
                RGBRegion.this.erase();
                RGBRegion.this.clearData();
            } else {
                RGBRegion.this.shapeKeyFrames.add(n);
                step.dataValid = false;
            }
            RGBRegion.this.repaint();
            RGBRegion.this.firePropertyChange("step", null, new Integer(n));
        }

        @Override
        public void setAdjusting(boolean adjusting, MouseEvent e) {
            if (!adjusting) {
                RGBRegion.this.checkPolygonEditing();
            }
        }
    }
}

