/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.RGBRegion;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;

public class RGBStep
extends Step {
    protected static GeneralPath crosshair;
    protected static AlphaComposite composite;
    protected static TPoint marker;
    protected Position position;
    protected RGBRegion rgbRegion;
    protected int width = 20;
    protected int height = 20;
    protected Map<Integer, Shape> panelHitShapes = new HashMap<Integer, Shape>();
    protected Map<Integer, Shape[]> polygonHitShapes = new HashMap<Integer, Shape[]>();
    protected double[] rgbData = new double[8];
    protected boolean dataValid = false;
    protected BasicStroke stroke;
    protected Shape rgbShape;
    protected Polygon2D polygon;

    static {
        composite = AlphaComposite.getInstance(3, 0.1f);
        crosshair = new GeneralPath();
        crosshair.moveTo(0.0f, -3.0f);
        crosshair.lineTo(0.0f, 3.0f);
        crosshair.moveTo(-3.0f, 0.0f);
        crosshair.lineTo(3.0f, 0.0f);
        marker = new TPoint();
    }

    public RGBStep(RGBRegion track, int n, double x, double y, int w, int h) {
        super(track, n);
        this.width = w;
        this.height = h;
        this.rgbRegion = track;
        this.position = new Position(x, y);
        this.position.setStepEditTrigger(true);
        this.points = new TPoint[]{this.position, track.vertexHandle};
        this.screenPoints = new Point[RGBStep.getLength()];
        this.valid = true;
    }

    public TPoint getPosition() {
        return this.position;
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        Shape[] polyshapes;
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        this.setHitRectCenter(xpix, ypix);
        Shape hitShape = this.panelHitShapes.get(trackerPanel.getID());
        if (hitShape != null && hitShape.intersects(hitRect)) {
            return this.position;
        }
        if (!this.isPolygonClosed() && (polyshapes = this.polygonHitShapes.get(trackerPanel.getID())) != null) {
            int i = 0;
            while (i < polyshapes.length) {
                if (polyshapes[i].intersects(hitRect)) {
                    this.rgbRegion.prepareVertexHandle(this, i);
                    return this.rgbRegion.vertexHandle;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics _g) {
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        Graphics2D g = (Graphics2D)_g;
        Mark mark = this.getMark(trackerPanel);
        if (mark != null) {
            mark.draw(g, false);
        }
        this.getRGBData(trackerPanel);
    }

    @Override
    public TPoint getDefaultPoint() {
        if (this.rgbRegion.shapeType == 2 && this.polygon != null && !this.polygon.isClosed() && this.polygon.vertices.size() > 1) {
            return this.rgbRegion.vertexHandle;
        }
        return this.points[this.defaultIndex];
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark;
        BasicStroke baseStroke = this.footprint.getStroke();
        int scale = FontSizer.getIntegerFactor();
        float size = Math.min(this.width, this.height);
        float lineWidth = Math.min((float)scale * baseStroke.getLineWidth(), size / 3.0f);
        lineWidth = Math.max(lineWidth, baseStroke.getLineWidth());
        if (this.stroke == null || this.stroke.getLineWidth() != lineWidth) {
            this.stroke = new BasicStroke(lineWidth);
        }
        if ((mark = (Mark)this.panelMarks.get(trackerPanel.getID())) == null) {
            Shape square;
            int n;
            trackerPanel.getPixelTransform(transform);
            if (!trackerPanel.isDrawingInImageSpace()) {
                transform.concatenate(trackerPanel.getCoords().getToWorldTransform(this.n));
            }
            Shape region = this.getRGBShape(this.position);
            final Shape rgn = transform.createTransformedShape(region);
            this.polygonHitShapes.remove(trackerPanel.getID());
            if (this.rgbRegion.shapeType == 2 && this.polygon != null && (n = this.polygon.vertices.size() - (this.polygon.isClosed() ? 2 : 1)) > 0) {
                Shape[] polyshapes = new Shape[n];
                int i = 0;
                while (i < n) {
                    Point2D pt = this.polygon.vertices.get(i + 1);
                    marker.setLocation(this.position.getX() + pt.getX(), this.position.getY() + pt.getY());
                    Point p = marker.getScreenPosition(trackerPanel);
                    transform.setToTranslation(p.x, p.y);
                    polyshapes[i] = transform.createTransformedShape(crosshair);
                    ++i;
                }
                this.polygonHitShapes.put(trackerPanel.getID(), polyshapes);
            }
            Point p = this.position.getScreenPosition(trackerPanel);
            transform.setToTranslation(p.x, p.y);
            final Shape cross = transform.createTransformedShape(crosshair);
            transform.scale(scale, scale);
            Shape shape = square = this.position == trackerPanel.getSelectedPoint() ? transform.createTransformedShape(selectionShape) : null;
            if (this.rgbRegion.vertexHandle == trackerPanel.getSelectedPoint()) {
                p = this.rgbRegion.vertexHandle.getScreenPosition(trackerPanel);
                transform.setToTranslation(p.x, p.y);
                transform.scale(scale, scale);
                square = transform.createTransformedShape(selectionShape);
            }
            final Shape selection = square;
            mark = new Mark(){

                @Override
                public void draw(Graphics2D g, boolean highlighted) {
                    Paint gpaint = g.getPaint();
                    g.setPaint(RGBStep.this.footprint.getColor());
                    if (OSPRuntime.setRenderingHints) {
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    }
                    if (selection != null) {
                        g.setStroke(selectionStroke);
                        g.draw(selection);
                        g.setStroke(RGBStep.this.stroke);
                    } else {
                        g.setStroke(RGBStep.this.stroke);
                        g.draw(cross);
                    }
                    if (rgn != null) {
                        g.draw(rgn);
                        if (RGBStep.this.rgbRegion.shapeType == 2 && !RGBStep.this.isPolygonClosed()) {
                            g.setComposite(composite);
                            g.fill(rgn);
                        }
                    }
                    g.setPaint(gpaint);
                }
            };
            this.panelMarks.put(trackerPanel.getID(), mark);
            this.panelHitShapes.put(trackerPanel.getID(), cross);
        }
        return mark;
    }

    public void setShapeSize(double w, double h) {
        this.height = (int)h;
        this.width = (int)w;
        this.rgbShape = null;
    }

    @Override
    public Object clone() {
        RGBStep step = (RGBStep)super.clone();
        if (step != null) {
            step.panelHitShapes = new HashMap<Integer, Shape>();
            step.polygonHitShapes = new HashMap<Integer, Shape[]>();
            TPoint[] tPointArray = step.points;
            RGBStep rGBStep = step;
            rGBStep.getClass();
            step.position = rGBStep.new Position(this.position.getX(), this.position.getY());
            tPointArray[0] = step.position;
            step.points[1] = this.rgbRegion.vertexHandle;
            step.position.setStepEditTrigger(true);
            step.rgbData = new double[8];
            step.dataValid = false;
        }
        return step;
    }

    @Override
    public String toString() {
        return "RGBStep " + this.n + " [" + format.format(this.position.x) + ", " + format.format(this.position.y) + "]";
    }

    protected Shape getRGBShape(TPoint pt) {
        if (this.rgbShape == null) {
            this.createRGBShape(pt);
        }
        AffineTransform transform = AffineTransform.getTranslateInstance(pt.getX(), pt.getY());
        return transform.createTransformedShape(this.rgbShape);
    }

    private void createRGBShape(TPoint pt) {
        if (this.rgbRegion.shapeType == 0) {
            this.rgbShape = new Ellipse2D.Double(-this.width / 2, -this.height / 2, this.width, this.height);
        } else if (this.rgbRegion.shapeType == 2) {
            if (this.polygon == null) {
                this.polygon = new Polygon2D();
                this.append(pt.x, pt.y);
            }
            this.rgbShape = this.polygon;
        } else {
            this.rgbShape = new Rectangle2D.Double(-this.width / 2, -this.height / 2, this.width, this.height);
        }
    }

    protected void append(double x, double y) {
        if (this.polygon == null) {
            this.polygon = new Polygon2D();
        }
        this.polygon.add(x - this.position.x, y - this.position.y);
        if (this.polygon.vertices.size() < 4 && this.rgbRegion.tp != null) {
            this.rgbRegion.tp.getTrackBar(false).refresh();
        }
    }

    protected boolean isPolygonClosed() {
        return this.polygon != null && this.polygon.isClosed();
    }

    protected int getPolygonVertexCount() {
        return this.polygon == null ? 0 : this.polygon.vertices.size();
    }

    protected double[][] getPolygonVertices() {
        if (this.polygon == null) {
            return null;
        }
        return this.polygon.getVertices();
    }

    protected void setPolygonVertices(double[][] vertices) {
        if (this.polygon == null) {
            this.polygon = new Polygon2D();
        } else {
            this.polygon.reset();
            this.polygon.vertices.clear();
        }
        int i = 0;
        while (i < vertices.length) {
            if (vertices[i] != null) {
                this.polygon.add(vertices[i][0], vertices[i][1]);
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double[] getRGBData(TrackerPanel trackerPanel) {
        BufferedImage image;
        Video vid = trackerPanel.getVideo();
        if (vid == null || !vid.isVisible()) {
            return null;
        }
        if (!this.dataValid && trackerPanel.getFrameNumber() == this.n && (image = vid.getImage()) != null && image.getType() == 1) {
            RGBStep step = this.rgbRegion.isFixedPosition() ? (RGBStep)this.rgbRegion.getStep(0) : this;
            TPoint pt = step.getPosition();
            Shape region = this.getRGBShape(pt);
            if (region == null) {
                return null;
            }
            Rectangle rect = region.getBounds();
            int h = rect.height;
            int w = rect.width;
            int x0 = rect.x;
            int y0 = rect.y;
            Point2D.Double centerPt = new Point2D.Double();
            try {
                int[] pixels = new int[h * w];
                int n = 0;
                int r = 0;
                int g = 0;
                int b = 0;
                int r2 = 0;
                int g2 = 0;
                int b2 = 0;
                image.getRaster().getDataElements(x0, y0, w, h, pixels);
                int i = 0;
                while (i < w) {
                    int j = 0;
                    while (j < h) {
                        ((Point2D)centerPt).setLocation((double)(x0 + i) + 0.5, (double)(y0 + j) + 0.5);
                        if (vid.getTypeName().equals("Image")) {
                            ImageVideo iVid = (ImageVideo)vid;
                            int wid = iVid.getRGBSize().width;
                            int ht = iVid.getRGBSize().height;
                            if ((double)wid < ((Point2D)centerPt).getX() || (double)ht < ((Point2D)centerPt).getY()) {
                                return null;
                            }
                        }
                        if (region.contains(centerPt)) {
                            int pixel = pixels[i + j * w];
                            ++n;
                            int rp = pixel >> 16 & 0xFF;
                            r += rp;
                            r2 += rp * rp;
                            int gp = pixel >> 8 & 0xFF;
                            g += gp;
                            g2 += gp * gp;
                            int bp = pixel & 0xFF;
                            b += bp;
                            b2 += bp * bp;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (n == 0) {
                    return null;
                }
                double rMean = 1.0 * (double)r / (double)n;
                double rSD = n == 1 ? Double.NaN : Math.sqrt(((double)r2 - (double)r * rMean) / (double)(n - 1));
                double gMean = 1.0 * (double)g / (double)n;
                double gSD = n == 1 ? Double.NaN : Math.sqrt(((double)g2 - (double)g * gMean) / (double)(n - 1));
                double bMean = 1.0 * (double)b / (double)n;
                double bSD = n == 1 ? Double.NaN : Math.sqrt(((double)b2 - (double)b * bMean) / (double)(n - 1));
                this.rgbData[0] = rMean;
                this.rgbData[1] = gMean;
                this.rgbData[2] = bMean;
                this.rgbData[3] = RGBRegion.getLuma(rMean, gMean, bMean);
                this.rgbData[4] = n;
                this.rgbData[5] = rSD;
                this.rgbData[6] = gSD;
                this.rgbData[7] = bSD;
                this.dataValid = true;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return null;
            }
        }
        this.dataVisible = true;
        return this.rgbData;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            RGBStep step = (RGBStep)obj;
            control.setValue("position", new double[]{step.position.x, step.position.y});
            control.setValue("size", new int[]{step.width, step.height});
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            RGBStep step = (RGBStep)obj;
            double[] position = (double[])control.getObject("position");
            step.position.setXY(position[0], position[1]);
            int[] size = (int[])control.getObject("size");
            step.setShapeSize(size[0], size[1]);
            step.dataValid = false;
            step.rgbRegion.firePropertyChange("step", null, new Integer(step.n));
            return obj;
        }
    }

    protected static class Polygon2D
    extends Path2D.Double {
        static double[] pts = new double[6];
        ArrayList<Point2D> vertices = new ArrayList();

        protected Polygon2D() {
        }

        protected Polygon2D copy() {
            Polygon2D copy = new Polygon2D();
            PathIterator it = this.getPathIterator(null);
            while (!it.isDone()) {
                it.currentSegment(pts);
                copy.add(pts[0], pts[1]);
                it.next();
            }
            return copy;
        }

        protected double[][] getVertices() {
            PathIterator it = this.getPathIterator(null);
            double[][] result = new double[this.vertices.size()][];
            int i = 0;
            while (!it.isDone()) {
                it.currentSegment(pts);
                result[i] = new double[]{pts[0], pts[1]};
                it.next();
                ++i;
            }
            return result;
        }

        protected void remove(int vertex) {
            if (this.vertices.size() < 2 || this.vertices.size() < vertex + 1) {
                return;
            }
            this.reset();
            this.vertices.remove(vertex + 1);
            ArrayList<Point2D> array = new ArrayList<Point2D>(this.vertices);
            this.vertices.clear();
            int n = array.size();
            int i = 0;
            while (i < n) {
                Point2D next = array.get(i);
                this.add(next.getX(), next.getY());
                ++i;
            }
        }

        protected boolean isClosed() {
            if (this.vertices.size() < 3) {
                return false;
            }
            Point2D pt = this.vertices.get(this.vertices.size() - 1);
            return pt.getX() == 0.0 && pt.getY() == 0.0;
        }

        protected void modify() {
            ArrayList<Point2D> array = new ArrayList<Point2D>(this.vertices);
            this.reset();
            this.vertices.clear();
            int n = array.size();
            int i = 0;
            while (i < n) {
                Point2D next = array.get(i);
                this.add(next.getX(), next.getY());
                ++i;
            }
        }

        protected void setClosed(boolean close) {
            if (close && (this.isClosed() || this.vertices.size() < 3)) {
                return;
            }
            if (!close && this.vertices.size() <= 1) {
                return;
            }
            if (close) {
                this.add(0.0, 0.0);
            } else {
                this.reset();
                ArrayList<Point2D> array = new ArrayList<Point2D>(this.vertices);
                this.vertices.clear();
                int n = array.size() - 1;
                int i = 0;
                while (i < n) {
                    Point2D next = array.get(i);
                    this.add(next.getX(), next.getY());
                    ++i;
                }
            }
        }

        protected void add(double x, double y) {
            if (this.getCurrentPoint() == null) {
                this.moveTo(x, y);
            } else {
                this.lineTo(x, y);
            }
            this.vertices.add(this.getCurrentPoint());
        }
    }

    protected class Position
    extends TPoint {
        public Position(double x, double y) {
            super(x, y);
        }

        @Override
        public void setXY(double x, double y) {
            TTrack track = RGBStep.this.getTrack();
            if (track.isLocked()) {
                return;
            }
            if (RGBStep.this.rgbRegion.isFixedPosition()) {
                RGBStep step = (RGBStep)RGBStep.this.rgbRegion.steps.getStep(0);
                step.getPosition().setLocation(x, y);
                step.erase();
                RGBStep.this.rgbRegion.refreshStep(RGBStep.this);
                RGBStep.this.rgbRegion.clearData();
            } else {
                this.setLocation(x, y);
                RGBStep.this.rgbRegion.keyFrames.add(RGBStep.this.n);
                RGBStep.this.dataValid = false;
            }
            RGBStep.this.repaint();
            track.firePropertyChange("step", null, new Integer(RGBStep.this.n));
        }

        @Override
        public void showCoordinates(VideoPanel vidPanel) {
            TTrack track = RGBStep.this.getTrack();
            Point2D p = this.getWorldPosition(vidPanel);
            track.xField.setValue(p.getX());
            track.yField.setValue(p.getY());
            super.showCoordinates(vidPanel);
        }

        @Override
        public int getFrameNumber(VideoPanel vidPanel) {
            return RGBStep.this.n;
        }

        @Override
        public void setAdjusting(boolean adjusting, MouseEvent e) {
            if (!adjusting) {
                RGBStep.this.rgbRegion.checkPolygonEditing();
            }
        }
    }
}

