/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.media.core.ImageCoordSystem;

public class ReferenceFrame
extends ImageCoordSystem
implements PropertyChangeListener {
    private PointMass originTrack;
    private ImageCoordSystem coords;
    private boolean lockEnabled = false;
    private boolean originLocked;

    public ReferenceFrame(ImageCoordSystem coords, PointMass originTrack) {
        super(coords.getLength());
        this.originTrack = originTrack;
        this.coords = coords;
        this.ignoreUpdateRequests = true;
        this.setFixedOrigin(false);
        this.setFixedScale(coords.isFixedScale());
        coords.addPropertyChangeListener("transform", this);
        originTrack.addStepListener(this);
        boolean doScale = true;
        int i = 0;
        int n = coords.getLength();
        while (i < n) {
            doScale = doScale && this.setScaleXY(i, coords.getScaleX(i), coords.getScaleY(i));
            this.setCosineSine(i, coords.getCosine(i), coords.getSine(i));
            ++i;
        }
        this.setOrigins();
        this.lockEnabled = true;
        this.ignoreUpdateRequests = false;
        this.updateAllTransforms();
    }

    @Override
    public void setFixedOrigin(boolean fixed, int n) {
        super.setFixedOrigin(false, n);
    }

    @Override
    public void setLocked(boolean locked) {
        if (locked) {
            this.originLocked = this.originTrack.isLocked();
            this.originTrack.setLocked(true);
        } else {
            this.originTrack.setLocked(this.originLocked);
        }
        this.coords.setLocked(locked);
        super.setLocked(locked);
    }

    @Override
    public boolean isLocked() {
        return this.lockEnabled && this.coords.isLocked();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "step": 
            case "steps": {
                this.setOrigins();
                break;
            }
            case "transform": {
                Integer integer = (Integer)e.getNewValue();
                if (integer != null) {
                    int n = integer;
                    this.setScaleXY(n, this.coords.getScaleX(n), this.coords.getScaleY(n));
                    this.setCosineSine(n, this.coords.getCosine(n), this.coords.getSine(n));
                    if (!this.originTrack.isEmpty() || n != 0) break;
                    this.setOrigins();
                    break;
                }
                int n = 0;
                while (n < this.coords.getLength()) {
                    this.setScaleXY(n, this.coords.getScaleX(n), this.coords.getScaleY(n));
                    this.setCosineSine(n, this.coords.getCosine(n), this.coords.getSine(n));
                    ++n;
                }
                if (!this.originTrack.isEmpty()) break;
                this.setOrigins();
            }
        }
    }

    @Override
    protected void updateAllTransforms() {
        if (this.ignoreUpdateRequests) {
            return;
        }
        super.updateAllTransforms();
    }

    public ImageCoordSystem getCoords() {
        this.coords.removePropertyChangeListener("transform", this);
        this.coords.setFixedAngle(this.isFixedAngle());
        this.coords.setFixedScale(this.isFixedScale());
        boolean doScale = true;
        int n = 0;
        while (n < this.coords.getLength()) {
            doScale = doScale && this.coords.setScaleXY(n, this.getScaleX(n), this.getScaleY(n));
            this.coords.setCosineSine(n, this.getCosine(n), this.getSine(n));
            ++n;
        }
        this.coords.addPropertyChangeListener("transform", this);
        return this.coords;
    }

    public PointMass getOriginTrack() {
        return this.originTrack;
    }

    protected void setOrigins() {
        PositionStep.Position p;
        Step step;
        this.firePropChange = false;
        double x = this.coords.getOriginX(0);
        double y = this.coords.getOriginY(0);
        int n = this.coords.getLength();
        int i = 0;
        while (i < n) {
            step = this.originTrack.getStep(i);
            if (step != null) {
                p = ((PositionStep)step).getPosition();
                x = p.getX();
                y = p.getY();
                break;
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            step = this.originTrack.getStep(i);
            if (step != null) {
                p = ((PositionStep)step).getPosition();
                x = p.getX();
                y = p.getY();
            }
            this.setOriginXY(i, x, y);
            ++i;
        }
        this.firePropChange = true;
        this.firePropertyChange("transform", null, null);
    }
}

