/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import org.opensourcephysics.cabrillo.tracker.InputTrack;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.tools.FontSizer;

public abstract class Ruler {
    protected static final float[] DASHED_LINE = new float[]{4.0f, 8.0f};
    protected static final int MAX_RULER_SIZE = 200;
    protected static final int DEFAULT_RULER_SIZE = 30;
    protected static final double MAX_RULER_LINE_SPACING = 100.0;
    protected static final double MIN_RULER_LINE_SPACING = 4.0;
    protected static final int NUMBER_OF_LEVELS = 3;
    protected static final int MIN_INSET_PER_LEVEL = 5;
    protected static final int DEFAULT_LABEL_GAP = 12;
    protected static final int DEFAULT_LINE_GAP = 4;
    protected InputTrack track;
    protected BasicStroke[] baseStrokes;
    protected BasicStroke[] strokes;
    protected BasicStroke dashedStroke;
    protected Color[] colors = new Color[3];
    protected int alpha = 255;
    protected ArrayList<ArrayList<Line2D>> lines;
    protected MultiShape[] multiShapes = new MultiShape[3];
    protected ArrayList<Label> labelMarks;
    protected Handle handle;
    protected TPoint utilityPoint;
    protected boolean visible;
    protected boolean hitShapeVisible;
    protected double rulerSize;
    protected double rulerLineSpacing = 4.0;
    protected int insetPerLevel = 5;
    protected int labelGap = 12;
    protected int lineGap = 4;
    protected AffineTransform transform = new AffineTransform();
    protected AffineTransform labelTransform = new AffineTransform();
    protected DecimalFormat format = (DecimalFormat)NumberFormat.getInstance();
    protected Double previousDistFromLineEnd;
    protected double previousLineSpacing;
    protected double previousAngle;
    protected int prevSigFigs = 0;

    public Ruler(InputTrack track) {
        this.track = track;
        this.handle = new Handle();
        this.utilityPoint = new TPoint();
        this.lines = new ArrayList();
        this.labelMarks = new ArrayList();
        int i = 0;
        while (i < 3) {
            this.lines.add(new ArrayList());
            ++i;
        }
        this.setRulerSize(30.0);
        this.setStrokeWidth(1.0f);
        this.setColor(track.getColor());
    }

    protected abstract Mark getMark(TrackerPanel var1, int var2);

    protected Interactive findInteractive(TrackerPanel trackerPanel, Rectangle hitRect) {
        return null;
    }

    protected void setHandleXY(double x, double y) {
    }

    public Handle getHandle() {
        return this.handle;
    }

    protected void setHitShapeVisible(boolean vis) {
        this.hitShapeVisible = vis && !this.track.isLocked();
    }

    public void setStrokeWidth(float width) {
        this.baseStrokes = new BasicStroke[]{new BasicStroke(width), new BasicStroke(width), new BasicStroke(width)};
        this.dashedStroke = new BasicStroke(width, 0, 0, 8.0f, DASHED_LINE, 0.0f);
        this.strokes = new BasicStroke[this.baseStrokes.length];
    }

    public float getStrokeWidth() {
        return this.baseStrokes[0].getLineWidth();
    }

    public void refreshStrokes() {
        int scale = FontSizer.getIntegerFactor();
        if (this.strokes[0] == null || this.strokes[0].getLineWidth() != (float)scale * this.baseStrokes[0].getLineWidth()) {
            int i = 0;
            while (i < this.strokes.length) {
                this.strokes[i] = new BasicStroke((float)scale * this.baseStrokes[i].getLineWidth());
                ++i;
            }
            this.dashedStroke = new BasicStroke((float)scale * this.baseStrokes[0].getLineWidth(), 0, 0, 8.0f, DASHED_LINE, 0.0f);
        }
    }

    public void setRulerSize(double size) {
        int minSize = 15;
        if (Math.abs(size) < (double)minSize) {
            return;
        }
        this.rulerSize = size >= 0.0 ? Math.max(Math.min(size, 200.0), (double)minSize) : Math.min(Math.max(size, -200.0), (double)(-minSize));
        this.insetPerLevel = Math.max((int)(Math.abs(this.rulerSize) / 3.0), 5);
    }

    public double getRulerSize() {
        return this.rulerSize;
    }

    public void setLineSpacing(double space) {
        this.rulerLineSpacing = Math.min(Math.max(space, 4.0), 100.0);
    }

    public double getLineSpacing() {
        return this.rulerLineSpacing;
    }

    public Color getColor() {
        return this.colors[0];
    }

    public void setColor(Color color) {
        if (color != null) {
            int i = 0;
            while (i < this.colors.length) {
                int alfa = this.alpha - i * this.alpha / (this.colors.length + 1);
                this.colors[i] = new Color(color.getRed(), color.getGreen(), color.getBlue(), alfa);
                ++i;
            }
        }
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        alpha = Math.min(alpha, 255);
        this.alpha = alpha = Math.max(alpha, 0);
        this.setColor(this.colors[1]);
    }

    public void setVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String getFormattedValue(double value, double min) {
        int sigfigs;
        if (value == 0.0) {
            return "0";
        }
        int n = min >= 1000.0 ? 4 : (min >= 1.0 ? 0 : (min >= 0.1 ? 1 : (min >= 0.01 ? 2 : (sigfigs = min >= 0.001 ? 3 : 4))));
        if (this.prevSigFigs != sigfigs) {
            switch (sigfigs) {
                case 0: {
                    this.format.applyPattern("0");
                    break;
                }
                case 1: {
                    this.format.applyPattern("0.0");
                    break;
                }
                case 2: {
                    this.format.applyPattern("0.00");
                    break;
                }
                case 3: {
                    this.format.applyPattern("0.000");
                    break;
                }
                default: {
                    this.format.applyPattern("0E0");
                }
            }
        }
        this.prevSigFigs = sigfigs;
        return this.format.format(value);
    }

    protected double getScreenDistanceToBase(Point p) {
        TPoint[] pts = this.track.getStep(this.track.tp.getFrameNumber()).getPoints();
        Point p1 = pts[0].getScreenPosition(this.track.tp);
        Point p2 = pts[1].getScreenPosition(this.track.tp);
        Line2D.Double tapeLine = new Line2D.Double(p1, p2);
        return tapeLine.ptLineDist(p.x, p.y);
    }

    protected boolean isLeft(TPoint p, TPoint end1, TPoint end2) {
        return (end2.x - end1.x) * (p.y - end1.y) - (end2.y - end1.y) * (p.x - end1.x) > 0.0;
    }

    class Handle
    extends TPoint {
        private Handle() {
            super(0.0, 0.0);
        }

        @Override
        public void setXY(double x, double y) {
            Ruler.this.setHandleXY(x, y);
        }

        protected void setScreenLocation(int xpix, int ypix, TrackerPanel trackerPanel) {
            Ruler.this.utilityPoint.setScreenPosition(xpix, ypix, trackerPanel);
            this.setLocation(Ruler.this.utilityPoint.x, Ruler.this.utilityPoint.y);
        }

        @Override
        public void setAdjusting(boolean adjust, MouseEvent e) {
            if (adjust == this.isAdjusting) {
                return;
            }
            super.setAdjusting(adjust, e);
            if (this.isAdjusting) {
                Ruler.this.previousDistFromLineEnd = null;
            }
        }
    }

    class Label {
        int x;
        int y;
        String text;
        Double rotation;

        Label(String s, double x, double y) {
            this.text = s;
            this.x = (int)x;
            this.y = (int)y;
        }

        void draw(Graphics2D g) {
            Graphics2D g2 = (Graphics2D)g.create();
            FontMetrics metrics = g2.getFontMetrics();
            int x1 = this.x - metrics.stringWidth(this.text) / 2;
            int y1 = this.y - metrics.getHeight() / 2 + metrics.getAscent();
            if (this.rotation != null) {
                Ruler.this.labelTransform.setToRotation(this.rotation, this.x, this.y);
                AffineTransform t = g2.getTransform();
                t.concatenate(Ruler.this.labelTransform);
                g2.setTransform(t);
            }
            g2.drawString(this.text, x1, y1);
            g2.dispose();
        }
    }
}

