/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import org.opensourcephysics.cabrillo.tracker.Derivative;

public class SecondDerivative
implements Derivative {
    private int spill;
    private int start;
    private int step;
    private int count;
    private double[] xDeriv = new double[0];
    private double[] yDeriv;
    private Object[] result = new Object[4];

    @Override
    public Object[] evaluate(Object[] data) {
        int[] params = (int[])data[0];
        this.spill = params[0];
        this.start = params[1];
        this.step = params[2];
        this.count = params[3];
        double[] x = (double[])data[1];
        double[] y = (double[])data[2];
        boolean[] valid = (boolean[])data[3];
        if (this.xDeriv.length != x.length) {
            this.xDeriv = new double[x.length];
            this.result[2] = this.xDeriv;
            this.yDeriv = new double[x.length];
            this.result[3] = this.yDeriv;
        }
        int lower = this.start;
        int upper = Math.min(this.start + this.step * (this.count - 1), x.length);
        int i = lower;
        while (i <= upper) {
            block10: {
                int j = i - this.spill * this.step;
                while (j <= i + this.spill * this.step) {
                    if (!(j >= 0 && j < valid.length && valid[j] || j >= 0 && j < valid.length && valid[j])) {
                        if (i < valid.length) {
                            this.xDeriv[i] = Double.NaN;
                            if (y != null) {
                                this.yDeriv[i] = Double.NaN;
                            }
                        }
                        break block10;
                    }
                    j += this.step;
                }
                if (this.spill == 1) {
                    this.xDeriv[i] = x[i - this.step] - 2.0 * x[i] + x[i + this.step];
                    if (y != null) {
                        this.yDeriv[i] = y[i - this.step] - 2.0 * y[i] + y[i + this.step];
                    }
                } else {
                    this.xDeriv[i] = (2.0 * x[i - 2 * this.step] - x[i - this.step] - 2.0 * x[i] - x[i + this.step] + 2.0 * x[i + 2 * this.step]) / 7.0;
                    if (y != null) {
                        this.yDeriv[i] = (2.0 * y[i - 2 * this.step] - y[i - this.step] - 2.0 * y[i] - y[i + this.step] + 2.0 * y[i + 2 * this.step]) / 7.0;
                    }
                }
            }
            i += this.step;
        }
        return this.result;
    }
}

