/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.display.OSPRuntime;

public class ShapeIcon
implements Icon {
    private int w;
    private int h;
    private MultiShape shape;
    private MultiShape decoration;
    private Color color = Color.black;
    private Color decoColor = Color.black;
    private double offsetX;
    private double offsetY;
    private BasicStroke stroke;

    public ShapeIcon(MultiShape shape, MultiShape decoration, int width, int height) {
        Rectangle rect;
        this.w = width;
        this.h = height;
        this.shape = shape;
        this.decoration = decoration;
        Rectangle rectangle = rect = shape == null ? new Rectangle() : shape.getBounds();
        if (decoration != null) {
            rect = rect.union(decoration.getBounds());
        }
        this.offsetX = this.w / 2 - rect.width / 2 - rect.x;
        this.offsetY = this.h / 2 - rect.height / 2 - rect.y;
    }

    public ShapeIcon(MultiShape shape, int width, int height) {
        this(shape, null, width, height);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(Color color, Color decorationColor) {
        this.color = color;
        this.decoColor = decorationColor;
    }

    public void setStroke(BasicStroke stroke) {
        this.stroke = stroke;
    }

    @Override
    public int getIconWidth() {
        return this.w;
    }

    @Override
    public int getIconHeight() {
        return this.h;
    }

    @Override
    public void paintIcon(Component c, Graphics _g, int x, int y) {
        if (this.shape == null && this.decoration == null) {
            return;
        }
        Graphics2D g = (Graphics2D)_g.create();
        AffineTransform at = AffineTransform.getTranslateInstance((double)x + this.offsetX, (double)y + this.offsetY);
        g.setPaint(this.color);
        if (OSPRuntime.setRenderingHints) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.clipRect(x, y, this.w, this.h);
        if (this.shape != null) {
            if (this.stroke != null) {
                g.setStroke(this.stroke);
            }
            this.shape.transform(at).draw(g);
        }
        if (this.decoration != null) {
            g.setPaint(this.decoColor);
            this.decoration.transform(at).draw(g);
        }
        g.dispose();
    }
}

