/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.opensourcephysics.cabrillo.tracker.AutoTracker;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.tools.FontSizer;

public abstract class Step
implements Cloneable {
    protected static final Rectangle hitRect = new Rectangle(-4, -4, 8, 8);
    protected static Shape selectionShape;
    protected static Stroke selectionStroke;
    protected static final AffineTransform transform;
    protected static final NumberFormat format;
    protected int trackID;
    protected int n;
    protected Footprint footprint;
    protected TPoint[] points;
    protected Point[] screenPoints;
    protected boolean valid;
    protected Map<Integer, Mark> panelMarks = new HashMap<Integer, Mark>();
    protected int defaultIndex = 0;
    protected boolean dataVisible = true;
    public int type = 0;
    public static final int TYPE_ACCELERATION = 2;
    public static final int TYPE_VELOCITY = 1;
    public static final int TYPE_UNKNOWN = 0;

    static {
        transform = new AffineTransform();
        format = NumberFormat.getNumberInstance(Locale.US);
        selectionStroke = new BasicStroke(2.0f);
        selectionShape = (Rectangle)hitRect.clone();
        format.setMinimumIntegerDigits(1);
        format.setMinimumFractionDigits(1);
        format.setMaximumFractionDigits(2);
    }

    protected Step(TTrack track, int n) {
        this.trackID = track.getID();
        this.n = n;
    }

    public int getFrameNumber() {
        return this.n;
    }

    public void setFootprint(Footprint footprint) {
        this.footprint = footprint;
    }

    public TTrack getTrack() {
        return TTrack.getTrack(this.trackID);
    }

    public TPoint[] getPoints() {
        return this.points;
    }

    public int getPointIndex(TPoint p) {
        int i = 0;
        while (i < this.points.length) {
            if (this.points[i] == p) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public TPoint getDefaultPoint() {
        return this.points[this.defaultIndex];
    }

    public void setDefaultPointIndex(int index) {
        index = Math.min(index, this.points.length - 1);
        this.defaultIndex = Math.max(0, index);
    }

    public void erase(Integer panelID) {
        if (this.panelMarks.get(panelID) == null) {
            return;
        }
        this.panel(panelID).addDirtyRegion(null);
        this.panelMarks.put(panelID, null);
    }

    public void remark(Integer panelID) {
        this.erase(panelID);
        this.panel(panelID).addDirtyRegion(null);
    }

    public void repaint(Integer panelID) {
        this.remark(panelID);
        this.panel(panelID).repaintDirtyRegion();
    }

    public void erase() {
        if (this.panelMarks.isEmpty()) {
            return;
        }
        Iterator<Integer> panelIDs = this.panelMarks.keySet().iterator();
        while (panelIDs.hasNext()) {
            this.erase(panelIDs.next());
        }
    }

    public void remark() {
        if (this.panelMarks.isEmpty()) {
            return;
        }
        Iterator<Integer> panelIDs = this.panelMarks.keySet().iterator();
        while (panelIDs.hasNext()) {
            this.remark(panelIDs.next());
        }
    }

    public void repaint() {
        Iterator<Integer> panelIDs = this.panelMarks.keySet().iterator();
        while (panelIDs.hasNext()) {
            this.repaint(panelIDs.next());
        }
    }

    private TrackerPanel panel(Integer panelID) {
        if (this.getTrack() == null) {
            System.out.println("OHOH");
        }
        return this.getTrack().panel(panelID);
    }

    protected void dispose() {
        this.panelMarks.clear();
    }

    public void draw(DrawingPanel panel, Graphics g) {
        boolean highlighted;
        AutoTracker t;
        TTrack track = this.getTrack();
        if (track.tp == panel && (t = track.tp.getAutoTracker(false)) != null && t.isInteracting(track)) {
            return;
        }
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        boolean bl = highlighted = trackerPanel.getFrameNumber() == this.n;
        if (trackerPanel.autoTracker != null && trackerPanel.autoTracker.getWizard().isVisible() && trackerPanel.autoTracker.getTrack() == track) {
            highlighted = false;
        }
        this.getMark(trackerPanel).draw((Graphics2D)g, highlighted);
    }

    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        TTrack track = this.getTrack();
        boolean highlighted = track.tp.getFrameNumber() == this.getFrameNumber();
        AutoTracker autoTracker = track.tp.getAutoTracker(false);
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        this.setHitRectCenter(xpix, ypix);
        int i = 0;
        while (i < this.points.length) {
            if (this.points[i] != null && !Double.isNaN(this.points[i].getX()) && hitRect.contains(this.points[i].getScreenPosition(trackerPanel))) {
                if (highlighted && autoTracker != null && autoTracker.isDrawingKeyFrameFor(track, i)) {
                    return null;
                }
                return this.points[i];
            }
            ++i;
        }
        return null;
    }

    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = this.panelMarks.get(trackerPanel.getID());
        TPoint selection = null;
        if (mark == null) {
            selection = trackerPanel.getSelectedPoint();
            Point p = null;
            this.valid = true;
            int n = 0;
            while (n < this.points.length) {
                if (this.valid) {
                    this.valid = this.valid && !Double.isNaN(this.points[n].getX()) && !Double.isNaN(this.points[n].getY());
                    this.screenPoints[n] = this.points[n].getScreenPosition(trackerPanel);
                    if (this.valid && selection == this.points[n]) {
                        p = this.screenPoints[n];
                    }
                }
                ++n;
            }
            mark = this.footprint.getMark(this.screenPoints);
            if (p != null) {
                transform.setToTranslation(p.x, p.y);
                int scale = FontSizer.getIntegerFactor();
                if (scale > 1) {
                    transform.scale(scale, scale);
                }
                final Color color = this.footprint.getColor();
                final Mark stepMark = mark;
                final MultiShape selectedShape = new MultiShape(transform.createTransformedShape(selectionShape)).andStroke(selectionStroke);
                mark = new Mark(){

                    @Override
                    public void draw(Graphics2D g, boolean highlighted) {
                        stepMark.draw(g, false);
                        Paint gpaint = g.getPaint();
                        g.setPaint(color);
                        selectedShape.draw(g);
                        g.setPaint(gpaint);
                    }
                };
            }
            final Mark theMark = mark;
            mark = new Mark(){

                @Override
                public void draw(Graphics2D g, boolean highlighted) {
                    if (!Step.this.valid) {
                        return;
                    }
                    theMark.draw(g, false);
                }
            };
            this.panelMarks.put(trackerPanel.getID(), mark);
        }
        return mark;
    }

    public String toString() {
        return "Step " + this.n;
    }

    public Object clone() {
        try {
            Step step = (Step)super.clone();
            step.points = new TPoint[this.points.length];
            step.screenPoints = new Point[this.points.length];
            step.panelMarks = new HashMap<Integer, Mark>();
            return step;
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected void setHitRectCenter(int xpix, int ypix) {
        hitRect.setLocation(xpix - Step.hitRect.width / 2, ypix - Step.hitRect.height / 2);
    }

    public static int getLength() {
        return 1;
    }

    static class Handle
    extends TPoint {
        public Handle(double x, double y) {
            super(x, y);
        }

        public void setPositionOnLine(int xScreen, int yScreen, TrackerPanel trackerPanel) {
        }
    }
}

