/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.util.ArrayList;
import java.util.HashSet;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.media.core.TPoint;

public class StepSet
extends HashSet<Step> {
    private TFrame frame;
    private Integer panelID;
    boolean changed;
    String trackUndoXML;
    HashSet<String[]> undoStepStates = new HashSet();
    HashSet<Step> removedSteps = new HashSet();
    boolean saveUndoStates = false;
    boolean isModified = false;
    HashSet<TTrack> tracks = new HashSet();

    public StepSet(TFrame frame, Integer panelID) {
        this.frame = frame;
        this.panelID = panelID;
    }

    @Override
    public boolean add(Step step) {
        boolean added;
        if (!(step instanceof PositionStep)) {
            return false;
        }
        this.isModified = added = super.add(step);
        if (!added) {
            return false;
        }
        if (!this.removedSteps.contains(step)) {
            String xml = new XMLControlElement(step).toXML();
            String[] data = new String[]{step.getTrack().getName(), String.valueOf(step.getFrameNumber()), xml};
            String[] match = null;
            for (String[] next : this.undoStepStates) {
                if (!next[0].equals(data[0]) || !next[1].equals(data[1])) continue;
                match = next;
                break;
            }
            if (match == null) {
                this.undoStepStates.add(data);
            }
            if (this.trackUndoXML == null) {
                TTrack track = step.getTrack();
                this.trackUndoXML = new XMLControlElement(track).toXML();
            }
        }
        TPoint pt = null;
        switch (this.size()) {
            case 0: {
                return true;
            }
            case 1: {
                pt = ((PositionStep)this.toArray(new Step[1])[0]).getPoints()[0];
                break;
            }
        }
        this.panel().setSelectedPoint(pt);
        return true;
    }

    @Override
    public boolean remove(Object step) {
        if (!(step instanceof PositionStep)) {
            return false;
        }
        boolean removed = super.remove(step);
        if (removed) {
            this.isModified = true;
            PositionStep stepp = (PositionStep)step;
            if (!this.isChanged()) {
                String frameNum = String.valueOf(stepp.getFrameNumber());
                String[] match = null;
                for (String[] next : this.undoStepStates) {
                    if (!next[0].equals(stepp.getTrack().getName()) || !next[1].equals(frameNum)) continue;
                    match = next;
                    break;
                }
                if (match != null) {
                    this.undoStepStates.remove(match);
                }
            } else {
                this.removedSteps.add(stepp);
            }
            TrackerPanel trackerPanel = this.panel();
            if (stepp.getPoints()[0] == trackerPanel.getSelectedPoint()) {
                trackerPanel.setSelectedPoint(null);
                trackerPanel.selectedSteps.clear();
            }
            if (this.size() == 1) {
                stepp = (PositionStep)this.toArray(new Step[1])[0];
                trackerPanel.setSelectedPoint(stepp.getPoints()[0]);
            } else if (this.isEmpty()) {
                this.clear();
            }
        }
        return removed;
    }

    @Override
    public void clear() {
        if (!(!this.changed || this.isEmpty() && this.removedSteps.isEmpty())) {
            TTrack[] tracks = this.getTracks();
            if (tracks.length == 1 && this.getTrackUndoControl() != null) {
                Undo.postTrackEdit(tracks[0], this.getTrackUndoControl());
            } else {
                Undo.postStepSetEdit(this, this.getStepsUndoControl());
            }
        }
        for (Step next : this) {
            next.erase();
        }
        super.clear();
        this.undoStepStates.clear();
        this.removedSteps.clear();
        this.trackUndoXML = null;
        this.changed = false;
        this.isModified = false;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public XMLControl getStepsUndoControl() {
        this.saveUndoStates = true;
        XMLControlElement control = new XMLControlElement(this);
        this.saveUndoStates = false;
        return control;
    }

    public XMLControl getTrackUndoControl() {
        return this.trackUndoXML == null ? null : new XMLControlElement(this.trackUndoXML);
    }

    public TTrack[] getTracks() {
        this.tracks.clear();
        for (Step step : this) {
            if (step.getTrack() == null) continue;
            this.tracks.add(step.getTrack());
        }
        return this.tracks.toArray(new TTrack[this.tracks.size()]);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected TrackerPanel panel() {
        return this.frame == null ? null : this.frame.getTrackerPanelForID(this.panelID);
    }

    public void dispose() {
        this.frame = null;
        this.panelID = null;
        this.tracks = null;
        this.undoStepStates = null;
    }

    public void finalize() {
        OSPLog.finalized(this);
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            String[][] stepsData;
            StepSet steps = (StepSet)obj;
            if (steps.saveUndoStates) {
                stepsData = (String[][])steps.undoStepStates.toArray((T[])new String[steps.undoStepStates.size()][]);
            } else {
                String[] data;
                String xml;
                stepsData = new String[steps.size() + steps.removedSteps.size()][];
                int i = 0;
                for (Step step : steps) {
                    xml = new XMLControlElement(step).toXML();
                    data = new String[]{step.getTrack().getName(), String.valueOf(step.getFrameNumber()), xml};
                    stepsData[i++] = data;
                }
                for (Step step : steps.removedSteps) {
                    xml = new XMLControlElement(step).toXML();
                    data = new String[]{step.getTrack().getName(), String.valueOf(step.getFrameNumber()), xml};
                    stepsData[i++] = data;
                }
            }
            control.setValue("steps", stepsData);
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            StepSet steps = (StepSet)obj;
            String[][] stepsData = (String[][])control.getObject("steps");
            TrackerPanel panel = steps.panel();
            int ns = stepsData.length;
            if (ns > 0) {
                ArrayList<TTrack> tracks = panel.getTracksTemp();
                int i = 0;
                while (i < ns) {
                    int n;
                    Step step;
                    String[] next = stepsData[i];
                    TTrack track = panel.getTrack(next[0], tracks);
                    if (track != null && (step = track.getStep(n = Integer.parseInt(next[1]))) != null) {
                        String xml = next[2];
                        if (xml.indexOf("<![CDATA[") != -1) {
                            xml = xml.substring(xml.indexOf("<![CDATA[") + "<![CDATA[".length(), xml.indexOf("]]>"));
                        }
                        XMLControlElement stepControl = new XMLControlElement(xml);
                        stepControl.loadObject(step);
                        step.erase();
                    }
                    ++i;
                }
                tracks.clear();
            }
            return obj;
        }
    }
}

