/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.opensourcephysics.cabrillo.tracker.AnalyticParticle;
import org.opensourcephysics.cabrillo.tracker.Calibration;
import org.opensourcephysics.cabrillo.tracker.CenterOfMass;
import org.opensourcephysics.cabrillo.tracker.CircleFitter;
import org.opensourcephysics.cabrillo.tracker.DynamicParticle;
import org.opensourcephysics.cabrillo.tracker.DynamicParticlePolar;
import org.opensourcephysics.cabrillo.tracker.DynamicSystem;
import org.opensourcephysics.cabrillo.tracker.ExportZipDialog;
import org.opensourcephysics.cabrillo.tracker.LineProfile;
import org.opensourcephysics.cabrillo.tracker.MainTView;
import org.opensourcephysics.cabrillo.tracker.ModelBuilder;
import org.opensourcephysics.cabrillo.tracker.OffsetOrigin;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.PerspectiveTrack;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PropertiesDialog;
import org.opensourcephysics.cabrillo.tracker.Protractor;
import org.opensourcephysics.cabrillo.tracker.ProtractorStep;
import org.opensourcephysics.cabrillo.tracker.RGBRegion;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.cabrillo.tracker.Vector;
import org.opensourcephysics.cabrillo.tracker.VectorSum;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.FilterStack;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.Video;

public class TActions {
    static String newline = System.getProperty("line.separator", "\n");
    protected TFrame frame;
    protected Integer panelID;

    public static Map<String, AbstractAction> createActions(TrackerPanel trackerPanel) {
        return new TActions(trackerPanel).getActions();
    }

    private TActions(TrackerPanel trackerPanel) {
        this.frame = trackerPanel.getTFrame();
        this.panelID = trackerPanel.getID();
    }

    protected TrackerPanel panel() {
        return this.frame == null ? null : this.frame.getTrackerPanelForID(this.panelID);
    }

    private Map<String, AbstractAction> getActions() {
        HashMap<String, AbstractAction> actions = new HashMap<String, AbstractAction>();
        actions.put("clearTracks", new AbstractAction(TrackerRes.getString("TActions.Action.ClearTracks")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.this.panel().checkAndClearTracks();
            }
        });
        actions.put("newTab", TActions.getAsyncAction(new AbstractAction(TrackerRes.getString("TActions.Action.NewTab")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TActions.this.frame != null) {
                    TActions.this.frame.addTrackerPanel(true, null);
                }
            }
        }, true));
        actions.put("paste", new AbstractAction(TrackerRes.getString("TActions.Action.Paste")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OSPRuntime.isJS) {
                    TActions.this.panel().getPasteDataDialog().setVisible(true);
                } else {
                    OSPRuntime.paste(data -> TActions.this.panel().doPaste((String)data));
                }
            }
        });
        actions.put("open", new AbstractAction(TrackerRes.getString("TActions.Action.Open"), Tracker.getResourceIcon("open.gif", true)){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.this.panel().setSelectedPoint(null);
                TActions.this.panel().selectedSteps.clear();
                if (TActions.this.frame != null) {
                    TActions.this.frame.doOpenFileFromDialog();
                }
            }
        });
        actions.put("openURL", new AbstractAction(TrackerRes.getString("TActions.Action.OpenURL")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.this.panel().openURLFromDialog();
            }
        });
        actions.put("openBrowser", TActions.getAsyncAction(new AbstractAction(TrackerRes.getString("TActions.Action.OpenBrowser")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TActions.this.frame != null) {
                    TActions.this.frame.getLibraryBrowser().setVisible(true);
                }
            }
        }, true));
        actions.put("properties", new AbstractAction(TrackerRes.getString("TActions.Action.Properties")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TActions.this.frame != null) {
                    TActions.this.frame.getPropertiesDialog(TActions.this.panel()).setVisible(true);
                }
            }
        });
        actions.put("close", new AbstractAction(TrackerRes.getString("TActions.Action.Close")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TActions.this.frame != null) {
                    TActions.this.frame.doCloseAction(TActions.this.panel());
                }
            }
        });
        actions.put("closeAll", new AbstractAction(TrackerRes.getString("TActions.Action.CloseAll")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TActions.this.frame != null) {
                    TActions.this.frame.removeAllTabs(false);
                }
            }
        });
        actions.put("import", new AbstractAction(TrackerRes.getString("TActions.Action.ImportTRK")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerIO.importFile(TActions.this.panel());
            }
        });
        actions.put("importData", new AbstractAction(TrackerRes.getString("TActions.Action.ImportData")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.dataTrackActionAsync(TActions.this.panel());
            }
        });
        actions.put("save", new AbstractAction(TrackerRes.getString("TActions.Action.Save"), Tracker.getResourceIcon("save.gif", true)){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerPanel trackerPanel = TActions.this.panel();
                TrackerIO.save(trackerPanel.getDataFile(), trackerPanel);
                trackerPanel.refreshNotesDialog();
            }
        });
        actions.put("saveAs", new AbstractAction(TrackerRes.getString("TActions.Action.SaveAs")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerPanel trackerPanel = TActions.this.panel();
                TrackerIO.save(null, trackerPanel);
                trackerPanel.refreshNotesDialog();
            }
        });
        actions.put("saveZip", new AbstractAction(String.valueOf(TrackerRes.getString("TActions.Action.SaveZip")) + "...", Tracker.getResourceIcon("save_zip.gif", true)){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportZipDialog.getDialog(TActions.this.panel()).setVisible(true);
            }
        });
        actions.put("saveTabsetAs", new AbstractAction(TrackerRes.getString("TActions.Action.SaveFrame")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerPanel trackerPanel = TActions.this.panel();
                TrackerIO.saveTabset(null, trackerPanel.getTFrame());
                trackerPanel.refreshNotesDialog();
            }
        });
        actions.put("saveVideo", new AbstractAction(TrackerRes.getString("TActions.Action.SaveVideoAs")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerIO.saveVideo(null, TActions.this.panel(), false, true);
            }
        });
        actions.put("export", new AbstractAction(TrackerRes.getString("TActions.Action.ImportTRK")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerIO.exportXMLFile(TActions.this.panel());
            }
        });
        actions.put("deleteTrack", new AbstractAction(TrackerRes.getString("TActions.Action.Delete")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TTrack track = TActions.this.panel().getTrack(e.getActionCommand());
                if (track != null) {
                    track.delete();
                }
            }
        });
        actions.put("config", new AbstractAction(TrackerRes.getString("TActions.Action.Config")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.this.frame.showPrefsDialog();
            }
        });
        actions.put("axesVisible", new AbstractAction(TrackerRes.getString("TActions.Action.AxesVisible"), Tracker.getResourceIcon("axes.gif", true)){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.this.panel().toggleAxesVisible();
            }
        });
        actions.put("videoFilter", TActions.getAsyncAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.this.panel().addVideoFilter(e.getActionCommand());
            }
        }, true));
        actions.put("aboutVideo", new AbstractAction(TrackerRes.getString("TActions.AboutVideo")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TActions.this.frame != null) {
                    TrackerPanel trackerPanel = TActions.this.panel();
                    PropertiesDialog dialog = TActions.this.frame.getPropertiesDialog(trackerPanel);
                    if (trackerPanel.getVideo() != null) {
                        dialog.tabbedPane.setSelectedIndex(trackerPanel.openedFromPath == null ? 0 : 1);
                    }
                    dialog.setVisible(true);
                }
            }
        });
        actions.put("print", new AbstractAction(TrackerRes.getString("TActions.Action.Print")){

            @Override
            public void actionPerformed(ActionEvent e) {
                new TrackerIO.ComponentImage(TActions.this.panel()).print();
            }
        });
        actions.put("exit", new AbstractAction(TrackerRes.getString("TActions.Action.Exit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.exitAction(TActions.this.panel());
            }
        });
        actions.put("pointMass", TActions.getAsyncAction(new AbstractAction(TrackerRes.getString("PointMass.Name")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.pointMassAction(TActions.this.panel());
            }
        }, true));
        actions.put("cm", TActions.getAsyncAction(new AbstractAction(TrackerRes.getString("CenterOfMass.Name")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.cmAction(TActions.this.panel());
            }
        }, true));
        actions.put("vector", TActions.getAsyncAction(new AbstractAction(TrackerRes.getString("Vector.Name")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.vectorAction(TActions.this.panel());
            }
        }, true));
        actions.put("vectorSum", TActions.getAsyncAction(new AbstractAction(TrackerRes.getString("VectorSum.Name")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.vectorSumAction(TActions.this.panel());
            }
        }, true));
        actions.put("offsetOrigin", TActions.getAsyncAction(new AbstractAction(TrackerRes.getString("OffsetOrigin.Name")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.offsetOriginAction(TActions.this.panel());
            }
        }, true));
        actions.put("calibration", TActions.getAsyncAction(new AbstractAction(TrackerRes.getString("Calibration.Name")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.calibrationAction(TActions.this.panel());
            }
        }, true));
        actions.put("lineProfile", TActions.getAsyncAction(new AbstractAction(TrackerRes.getString("LineProfile.Name")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.lineProfileAction(TActions.this.panel());
            }
        }, true));
        actions.put("rgbRegion", TActions.getAsyncAction(new AbstractAction(TrackerRes.getString("RGBRegion.Name")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.rgbRegionAction(TActions.this.panel());
            }
        }, true));
        actions.put("analyticParticle", TActions.getAsyncAction(new AbstractAction(TrackerRes.getString("AnalyticParticle.Name")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.analyticalParticleAction(TActions.this.panel());
            }
        }, true));
        actions.put("dynamicParticle", TActions.getAsyncAction(new AbstractAction(TrackerRes.getString("DynamicParticle.Name")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.dynamicParticleAction(TActions.this.panel());
            }
        }, true));
        actions.put("dynamicParticlePolar", TActions.getAsyncAction(new AbstractAction(TrackerRes.getString("DynamicParticlePolar.Name")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.dynamicParticlePolarAction(TActions.this.panel());
            }
        }, true));
        actions.put("dynamicSystem", TActions.getAsyncAction(new AbstractAction(TrackerRes.getString("DynamicSystem.Name")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.dynamicSystemAction(TActions.this.panel());
            }
        }, true));
        actions.put("tape", TActions.getAsyncAction(new AbstractAction(TrackerRes.getString("TapeMeasure.Name")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.tapeAction(TActions.this.panel());
            }
        }, true));
        actions.put("protractor", TActions.getAsyncAction(new AbstractAction(TrackerRes.getString("Protractor.Name")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.protractorAction(TActions.this.panel());
            }
        }, true));
        actions.put("circleFitter", TActions.getAsyncAction(new AbstractAction(TrackerRes.getString("CircleFitter.Name")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.circleFitterAction(TActions.this.panel());
            }
        }, true));
        actions.put("cloneTrack", TActions.getAsyncAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.cloneAction(TActions.this.panel(), e.getActionCommand());
            }
        }, true));
        actions.put("clearFilters", new AbstractAction(TrackerRes.getString("TActions.Action.ClearFilters")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.clearFiltersAction(TActions.this.panel(), true);
            }
        });
        actions.put("dataTrack", new AbstractAction(TrackerRes.getString("ParticleDataTrack.Name")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TActions.dataTrackActionAsync(TActions.this.panel());
            }
        });
        actions.put("openVideo", new AbstractAction(TrackerRes.getString("TActions.Action.ImportVideo")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerIO.importVideo(TActions.this.panel(), null);
            }
        });
        actions.put("closeVideo", new AbstractAction(TrackerRes.getString("TActions.Action.CloseVideo")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerPanel trackerPanel = TActions.this.panel();
                trackerPanel.setVideo(null);
                TFrame.repaintT(trackerPanel);
                trackerPanel.setImageSize(640.0, 480.0);
                TActions.this.frame.refreshMenus(trackerPanel, "TActions.openVideo");
            }
        });
        actions.put("refFrame", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                TActions.this.panel().setReferenceFrame(item.getActionCommand());
            }
        });
        return actions;
    }

    private static TTrack addTrack(TTrack t, TrackerPanel p) {
        t.setDefaultNameAndColor(p, " ");
        p.addTrack(t);
        p.setSelectedPoint(null);
        p.selectedSteps.clear();
        p.setSelectedTrack(t);
        return t;
    }

    private static void addParticle(ParticleModel model, TrackerPanel trackerPanel, boolean isDynamic) {
        ModelBuilder builder = model.getModelBuilder();
        if (builder != null) {
            builder.setVisible(false);
        }
        SwingUtilities.invokeLater(() -> {
            TActions.addTrack(model, trackerPanel);
            model.setStartFrame(trackerPanel.getPlayer().getVideoClip().getStartFrameNumber());
            if (isDynamic) {
                ((DynamicSystem)model).getSystemInspector().setVisible(true);
            }
            model.getModelBuilder().refreshDropdown(model.getName());
            model.getModelBuilder().setVisible(true);
        });
    }

    protected static void analyticalParticleAction(TrackerPanel trackerPanel) {
        TActions.addParticle(new AnalyticParticle(), trackerPanel, false);
    }

    public static void dynamicParticleAction(TrackerPanel trackerPanel) {
        TActions.addParticle(new DynamicParticle(), trackerPanel, false);
    }

    public static void dynamicParticlePolarAction(TrackerPanel trackerPanel) {
        TActions.addParticle(new DynamicParticlePolar(), trackerPanel, false);
    }

    protected static void dynamicSystemAction(TrackerPanel trackerPanel) {
        TActions.addParticle(new DynamicSystem(), trackerPanel, true);
    }

    protected static void rgbRegionAction(TrackerPanel trackerPanel) {
        TActions.addTrack(new RGBRegion(), trackerPanel);
        if (!Tracker.markAtCurrentFrame) {
            trackerPanel.getPlayer().setStepNumber(0);
        }
    }

    protected static void lineProfileAction(TrackerPanel trackerPanel) {
        TActions.addTrack(new LineProfile(), trackerPanel);
    }

    protected static void calibrationAction(TrackerPanel trackerPanel) {
        TActions.addTrack(new Calibration(), trackerPanel);
        trackerPanel.getAxes().setVisible(true);
    }

    protected static void offsetOriginAction(TrackerPanel trackerPanel) {
        TActions.addTrack(new OffsetOrigin(), trackerPanel);
        trackerPanel.getAxes().setVisible(true);
    }

    protected static void vectorSumAction(TrackerPanel trackerPanel) {
        ((VectorSum)TActions.addTrack(new VectorSum(), trackerPanel)).getInspector().setVisible(true);
    }

    protected static void vectorAction(TrackerPanel trackerPanel) {
        TActions.addTrack(new Vector(), trackerPanel);
        if (!Tracker.markAtCurrentFrame) {
            trackerPanel.getPlayer().setStepNumber(0);
        }
    }

    protected static void cmAction(TrackerPanel trackerPanel) {
        ((CenterOfMass)TActions.addTrack(new CenterOfMass(), trackerPanel)).getInspector().setVisible(true);
    }

    protected static void tapeAction(TrackerPanel trackerPanel) {
        TapeMeasure tape = new TapeMeasure();
        tape.setReadOnly(true);
        tape.getRuler().setVisible(true);
        MainTView mainView = trackerPanel.getTFrame().getMainView(trackerPanel);
        Rectangle rect = mainView.scrollPane.getViewport().getViewRect();
        int xpix = rect.x + rect.width / 2;
        int ypix = rect.y + rect.height / 2;
        double x = trackerPanel.pixToX(xpix);
        double y = trackerPanel.pixToY(ypix);
        tape.createStep(0, x - 100.0, y, x + 100.0, y);
        TActions.addTrack(tape, trackerPanel);
    }

    protected static void circleFitterAction(TrackerPanel trackerPanel) {
        TActions.addTrack(new CircleFitter(), trackerPanel);
    }

    protected static void protractorAction(TrackerPanel trackerPanel) {
        Protractor protractor = new Protractor();
        protractor.getRuler().setVisible(true);
        MainTView mainView = trackerPanel.getTFrame().getMainView(trackerPanel);
        Rectangle rect = mainView.scrollPane.getViewport().getViewRect();
        int xpix = rect.x + rect.width / 2;
        int ypix = rect.y + rect.height / 2;
        double x = trackerPanel.pixToX(xpix);
        double y = trackerPanel.pixToY(ypix);
        TPoint origin = trackerPanel.getAxes().getOrigin();
        if (Math.abs(origin.x - x) < 20.0 && Math.abs(origin.y - y) < 20.0) {
            x = origin.x;
            y = origin.y;
        }
        ProtractorStep step = (ProtractorStep)protractor.getStep(0);
        TActions.addTrack(protractor, trackerPanel);
        step.moveVertexTo(x, y);
    }

    protected static void pointMassAction(TrackerPanel trackerPanel) {
        ArrayList<CenterOfMass> list;
        PointMass pointMass = new PointMass();
        TActions.addTrack(pointMass, trackerPanel);
        if (!Tracker.markAtCurrentFrame) {
            trackerPanel.getPlayer().setStepNumber(0);
        }
        if ((list = trackerPanel.getDrawablesTemp(CenterOfMass.class)).size() == 1) {
            CenterOfMass cm = list.get(0);
            int result = JOptionPane.showConfirmDialog(trackerPanel, "Add " + pointMass.getName() + " to center of mass \"" + cm.getName() + "\"?" + newline + "Note: \"" + cm.getName() + "\" will disappear until  " + pointMass.getName() + " is marked!", TrackerRes.getString("TActions.Dialog.NewPointMass.Title"), 0, 3);
            if (result == 0) {
                cm.addMass(pointMass);
            }
        }
        list.clear();
    }

    protected static void dataTrackActionAsync(TrackerPanel trackerPanel) {
        TFrame frame = trackerPanel.getTFrame();
        TrackerIO.getChooserFilesAsync(frame, "open data", files -> {
            if (files == null) {
                return null;
            }
            String filePath = files[0].getAbsolutePath();
            trackerPanel.importDataAsync(filePath, null, null);
            return null;
        });
    }

    public static void cloneAction(TrackerPanel trackerPanel, String name) {
        trackerPanel.cloneNamed(name);
    }

    private static AbstractAction getAsyncAction(final AbstractAction a, boolean useSeparateThread) {
        Object nameObj = a.getValue("Name");
        String name = nameObj == null ? null : nameObj.toString();
        return new AbstractAction(name){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(() -> a.actionPerformed(e));
            }
        };
    }

    public static void clearFiltersAction(TrackerPanel trackerPanel, boolean andUndo) {
        Video video2 = trackerPanel.getVideo();
        if (video2 != null) {
            ArrayList<String> xml = new ArrayList<String>();
            FilterStack stack = video2.getFilterStack();
            for (Filter filter : stack.getFilters()) {
                xml.add(new XMLControlElement(filter).toXML());
                PerspectiveTrack track = PerspectiveTrack.filterMap.get(filter);
                if (track == null) continue;
                trackerPanel.removeTrack(track);
                track.dispose();
            }
            stack.clear();
            if (andUndo) {
                Undo.postFilterClear(trackerPanel, xml);
            }
        }
    }

    public static void exitAction(TrackerPanel trackerPanel) {
        if (trackerPanel == null) {
            Tracker.exit();
            return;
        }
        TFrame frame = trackerPanel.getTFrame();
        if (frame != null) {
            frame.removeAllTabs(true);
        }
    }
}

