/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.tools.FontSizer;

public class TButton
extends JButton {
    private int trackID;
    private boolean hidePopup = false;
    private JPopupMenu popup;
    protected String context = "track";
    protected boolean alwaysShowBorder;

    public TButton() {
        this.setOpaque(false);
        this.setBorderPainted(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!TButton.this.isEnabled()) {
                    return;
                }
                TButton.this.setBorderPainted(true);
                TButton.this.hidePopup = TButton.this.popup != null && TButton.this.popup.isVisible();
                TTrack track = TButton.this.getTrack();
                if (Tracker.showHints && track != null && track.tp != null) {
                    if (track.tp.getSelectedTrack() == track) {
                        track.tp.setMessage(track.getMessage());
                    } else {
                        String s = String.valueOf(track.getClass().getSimpleName()) + " " + track.getName() + " (" + TrackerRes.getString("TTrack.Unselected.Hint") + ")";
                        track.tp.setMessage(s);
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!TButton.this.alwaysShowBorder) {
                    TButton.this.setBorderPainted(false);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TTrack track = TButton.this.getTrack();
                if (track != null && track.tp != null && track != track.tp.getSelectedTrack()) {
                    track.tp.setSelectedTrack(track);
                    track.tp.setSelectedPoint(null);
                    track.tp.selectedSteps.clear();
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!TButton.this.isEnabled()) {
                    return;
                }
                TButton.this.popup = TButton.this.getPopup();
                if (TButton.this.popup != null) {
                    if (e.getClickCount() == 2) {
                        TButton.this.hidePopup = false;
                    }
                    if (TButton.this.hidePopup) {
                        TButton.this.hidePopup = false;
                        TButton.this.popup.setVisible(false);
                    } else {
                        TButton.this.hidePopup = true;
                        TButton.this.popup.show(TButton.this, 0, TButton.this.getHeight());
                    }
                }
            }
        });
    }

    public TButton(TTrack track) {
        this();
        this.setTrack(track);
    }

    public TButton(Icon icon) {
        this();
        this.setIcon(icon);
    }

    public TButton(Icon off, Icon on) {
        this();
        this.setIcons(off, on);
    }

    public void setIcons(Icon off, Icon on) {
        super.setIcon(off);
        this.setSelectedIcon(on);
    }

    public void setTrack(TTrack track) {
        if (track == null) {
            this.trackID = -1;
            this.setIcon(null);
            this.setText(" ");
            this.setToolTipText(null);
        } else {
            this.trackID = track.getID();
            this.setIcon(track.getIcon(21, 16, this.context));
            this.setText(track.getName(this.context));
            this.setToolTipText(String.valueOf(TrackerRes.getString("TButton.Track.ToolTip")) + " " + track.getName(this.context));
            FontSizer.setFont(this);
        }
    }

    public TTrack getTrack() {
        return TTrack.getTrack(this.trackID);
    }

    protected JPopupMenu getPopup() {
        TTrack track = this.getTrack();
        if (track != null && track.tp != null) {
            JMenu trackMenu = track.getMenu(track.tp, new JMenu());
            FontSizer.setFonts(trackMenu, FontSizer.getLevel());
            return trackMenu.getPopupMenu();
        }
        return null;
    }

    protected void showPopup() {
        this.popup = this.getPopup();
        if (this.popup != null) {
            this.hidePopup = true;
            this.popup.show(this, 0, this.getHeight());
        }
    }

    protected void alwaysShowBorder(boolean showBorder) {
        this.alwaysShowBorder = showBorder;
        this.setOpaque(this.alwaysShowBorder);
        this.setBorderPainted(this.alwaysShowBorder);
    }
}

