/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.media.core.XYCoordinateStringBuilder;

public class TCoordinateStringBuilder
extends CoordinateStringBuilder
implements XYCoordinateStringBuilder {
    NumberField xField = new NumberField(0);
    NumberField yField = new NumberField(0);

    @Override
    public String getCoordinateString(DrawingPanel panel, MouseEvent e) {
        if (panel instanceof TrackerPanel) {
            TrackerPanel trackerPanel = (TrackerPanel)panel;
            Point2D pt = trackerPanel.getWorldMousePoint();
            return this.getCoordinateString(trackerPanel, pt.getX(), pt.getY());
        }
        double x = panel.pixToX(e.getPoint().x);
        double y = panel.pixToY(e.getPoint().y);
        return this.getCoordinateString(null, x, y);
    }

    @Override
    public String getCoordinateString(VideoPanel vidPanel, double x, double y) {
        this.xField.setFormatFor(x);
        String xStr = this.xField.format(x);
        if (this.xField.getUnits() != null) {
            xStr = String.valueOf(xStr) + this.xField.getUnits();
        }
        this.yField.setFormatFor(y);
        String yStr = this.yField.format(y);
        if (this.yField.getUnits() != null) {
            yStr = String.valueOf(yStr) + this.yField.getUnits();
        }
        return String.valueOf(this.xLabel) + xStr + this.yLabel + yStr;
    }

    public void setUnitsAndPatterns(TTrack track, String xVar, String yVar) {
        if (track == null || track.tp == null) {
            return;
        }
        this.xField.setUnits(track.tp.getUnits(track, xVar));
        this.yField.setUnits(track.tp.getUnits(track, yVar));
        this.xField.setFixedPattern(track.getVarFormatPattern(xVar));
        this.yField.setFixedPattern(track.getVarFormatPattern(yVar));
    }

    @Override
    public void setCoordinateLabels(String xLabel, String yLabel) {
        this.xLabel = xLabel;
        this.yLabel = yLabel;
    }

    public void refreshDecimalSeparators() {
        this.xField.refreshDecimalSeparators(true);
        this.yField.refreshDecimalSeparators(true);
    }
}

