/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.cabrillo.tracker.ClipboardListener;
import org.opensourcephysics.cabrillo.tracker.CoordAxes;
import org.opensourcephysics.cabrillo.tracker.ExportVideoDialog;
import org.opensourcephysics.cabrillo.tracker.ExportZipDialog;
import org.opensourcephysics.cabrillo.tracker.HelpFinder;
import org.opensourcephysics.cabrillo.tracker.MainTView;
import org.opensourcephysics.cabrillo.tracker.PencilDrawer;
import org.opensourcephysics.cabrillo.tracker.PlotTView;
import org.opensourcephysics.cabrillo.tracker.PrefsDialog;
import org.opensourcephysics.cabrillo.tracker.PropertiesDialog;
import org.opensourcephysics.cabrillo.tracker.TMenuBar;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TTrackBar;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.TableTView;
import org.opensourcephysics.cabrillo.tracker.ThumbnailDialog;
import org.opensourcephysics.cabrillo.tracker.TrackChooserTView;
import org.opensourcephysics.cabrillo.tracker.TrackControl;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.cabrillo.tracker.deploy.TrackerStarter;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ClipInspector;
import org.opensourcephysics.media.core.DataTrack;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.FileDropHandler;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.LaunchPanel;
import org.opensourcephysics.tools.Launcher;
import org.opensourcephysics.tools.LibraryBrowser;
import org.opensourcephysics.tools.LibraryComPADRE;
import org.opensourcephysics.tools.LibraryResource;
import org.opensourcephysics.tools.LibraryTreePanel;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class TFrame
extends OSPFrame
implements PropertyChangeListener,
FileDropHandler.FileImporter {
    public static Font textLayoutFont = new JTextField().getFont();
    public static final String PROPERTY_TFRAME_TAB = "tab";
    public static final String PROPERTY_TFRAME_RADIANANGLES = "radian_angles";
    public static final String PROPERTY_TFRAME_WINDOWFOCUS = "windowfocus";
    protected static final String HELP_PATH = "/org/opensourcephysics/cabrillo/tracker/resources/help/";
    protected static final String WEB_HELP_PATH = "https://opensourcephysics.github.io/tracker-website/help/frameset.html";
    protected static final Color YELLOW;
    private static final int DEFAULT_DIVIDER_SIZE = 10;
    private static final double MIN_DIVIDER_OFFSET = 0.07;
    private static final int TFRAME_MAINVIEW = 0;
    private static final int TFRAME_VIEWCHOOSERS = 1;
    private static final int TFRAME_SPLITPANES = 2;
    protected static final int DEFAULT_VIEWS = 0;
    protected static final int OTHER_VIEWS = 1;
    protected static final double DEFAULT_MAIN_DIVIDER = 0.67;
    protected static final double DEFAULT_RIGHT_DIVIDER = 0.57;
    protected static final double DEFAULT_LEFT_DIVIDER = 0.57;
    protected static final double DEFAULT_BOTTOM_DIVIDER = 0.5;
    protected static final double DEFAULT_FRAME_WIDTH = 0.92;
    protected static final double MAXIMIZED_FRAME_WIDTH = 1.0;
    protected static final double DEFAULT_FRAME_HEIGHT = 0.75;
    protected static final double MAXIMIZED_FRAME_HEIGHT = 1.0;
    protected static final int DEFAULT_FRAME_CEILING = 60;
    protected static final int MAXIMIZED_FRAME_CEILING = 0;
    protected static boolean isPortraitOrientation;
    private static boolean isLayoutChanged;
    protected static boolean isLayoutAdaptive;
    private static boolean loadFailed;
    public static boolean haveExportDialog;
    public static boolean haveThumbnailDialog;
    public static boolean maximize;
    protected ClipboardListener clipboardListener;
    protected LibraryBrowser libraryBrowser;
    protected Launcher helpLauncher;
    private JToolBar playerBar;
    protected JDialog helpDialog;
    protected JDialog dataToolDialog;
    protected PrefsDialog prefsDialog;
    private DataDropHandler dataDropHandler;
    protected FileDropHandler fileDropHandler;
    private JPopupMenu popup = new JPopupMenu();
    private JMenuItem closeItem;
    private DefaultMenuBar defaultMenuBar;
    private JMenu recentMenu;
    protected JTabbedPane tabbedPane;
    protected Action saveNotesAction;
    protected Action openRecentAction;
    protected ArrayList<String> loadedFiles = new ArrayList();
    protected File tabsetFile;
    protected String currentLangugae = "en";
    protected Integer prevPanelID;
    protected int maximizedView = -1;
    protected int framesLoaded;
    protected int prevFramesLoaded;
    protected boolean splashing = true;
    private boolean anglesInRadians = Tracker.isRadians;
    private boolean alwaysListenToClipboard;
    private Notes notes;
    private JPanel frameContentPane;
    public static final int STATE_ACTIVE = 0;
    public static final int STATE_BLOCKED = 2;
    public static final int STATE_REMOVING = 3;
    private int state = 0;
    private boolean removingAll;
    protected static final int SPLIT_MAIN_RIGHT = 0;
    protected static final int SPLIT_PLOT_TABLE = 1;
    protected static final int SPLIT_MAIN_BOTTOM = 2;
    protected static final int SPLIT_WORLD_PAGE = 3;
    protected static final int SIDEVIEW_RIGHT_TOP = 0;
    protected static final int SIDEVIEW_RIGHT_BOTTOM = 1;
    protected static final int SIDEVIEW_BOTTOM_LEFT = 2;
    protected static final int SIDEVIEW_BOTTOM_RIGHT = 3;
    protected static final int[] DEFAULT_ORDER;
    protected static final int[] PORTRAIT_VIEW_ORDER;
    protected static final int[] PORTRAIT_DIVIDER_ORDER;
    public static final int ADD_NOREFRESH = 0;
    public static final int ADD_NOSELECT = 0;
    public static final int ADD_SELECT = 1;
    public static final int ADD_REFRESH = 2;
    private int paintHold = 0;
    private String lastExperiment = "";
    public Function<List<String>, Void> whenObjectLoadingComplete;
    private FrameBlocker frameBlocker;
    private final BitSet _bsPanelIDs = new BitSet();
    private static final int MAX_PID = 127;
    private TrackerPanel[] _apanels = new TrackerPanel[127];
    private TMenuBar[] _amenubars = new TMenuBar[127];
    private TTrackBar[] _atrackbars = new TTrackBar[127];
    private TToolBar[] _atoolbars = new TToolBar[127];
    private Timer memoryTimer;
    private static final int MEMORY_TIMER_DELAY_MS = 15000;

    static {
        ToolTipManager.sharedInstance().setDismissDelay(2000);
        YELLOW = new Color(255, 255, 105);
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        DEFAULT_ORDER = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 3;
        nArray2[1] = 2;
        nArray2[2] = 1;
        PORTRAIT_VIEW_ORDER = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 2;
        nArray3[1] = 3;
        nArray3[3] = 1;
        PORTRAIT_DIVIDER_ORDER = nArray3;
    }

    public TFrame() {
        super("Tracker");
        OSPRuntime.Disposable.allocate(this._apanels, "_apanels");
        OSPRuntime.Disposable.allocate(this._amenubars, "_amenubars");
        OSPRuntime.Disposable.allocate(this._atrackbars, "_atrackbars");
        OSPRuntime.Disposable.allocate(this._atoolbars, "_atoolbars");
        this.init(null);
    }

    public TFrame(TrackerPanel trackerPanel) {
        super("Tracker");
        OSPRuntime.Disposable.allocate(this._apanels, "_apanels");
        OSPRuntime.Disposable.allocate(this._amenubars, "_amenubars");
        OSPRuntime.Disposable.allocate(this._atrackbars, "_atrackbars");
        OSPRuntime.Disposable.allocate(this._atoolbars, "_atoolbars");
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("-panel", trackerPanel);
        this.init(options);
    }

    public TFrame(Map<String, Object> options) {
        super("Tracker");
        OSPRuntime.Disposable.allocate(this._apanels, "_apanels");
        OSPRuntime.Disposable.allocate(this._amenubars, "_amenubars");
        OSPRuntime.Disposable.allocate(this._atrackbars, "_atrackbars");
        OSPRuntime.Disposable.allocate(this._atoolbars, "_atoolbars");
        this.init(options);
    }

    private void init(Map<String, Object> options) {
        this.setTitle("Tracker" + (OSPRuntime.isJS ? " Online" : ""));
        if (options == null) {
            options = new HashMap<String, Object>();
        }
        isLayoutAdaptive = OSPRuntime.isJS;
        Dimension dim = (Dimension)options.get("-dim");
        Rectangle bounds = (Rectangle)options.get("-bounds");
        Video video2 = (Video)options.get("-video");
        TrackerPanel panel = video2 != null ? new TrackerPanel(this, video2) : (TrackerPanel)options.get("-panel");
        this.setName("Tracker");
        if (Tracker.TRACKER_ICON != null) {
            this.setIconImage(Tracker.TRACKER_ICON.getImage());
        }
        this.setDefaultCloseOperation(0);
        TrackerRes.addListener(this);
        Rectangle screenRect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        if (OSPRuntime.isJS) {
            this.setMaximizedBounds(screenRect);
        }
        if (isLayoutAdaptive) {
            bounds = this.getAdaptiveBounds(true);
        }
        if (bounds == null) {
            if (dim == null) {
                double extra = FontSizer.getFactor(Tracker.preferredFontLevel) - 1.0;
                int w = (int)Math.min((double)screenRect.width * 0.9, 1024.0 + extra * 800.0);
                int h = (int)Math.min((double)screenRect.height * 0.9, (double)(3 * w / 4));
                dim = new Dimension(w, h);
            }
            int x = (screenRect.width - dim.width) / 2;
            int y = OSPRuntime.isJS ? 50 : (screenRect.height - dim.height) / 2;
            bounds = new Rectangle(x, y, dim.width, dim.height);
        } else {
            dim = new Dimension(bounds.width, bounds.height);
        }
        this.createGUI();
        this.setPreferredSize(dim);
        this.pack();
        this.setLocation(bounds.x, bounds.y);
        Rectangle rect = this.getBounds();
        isPortraitOrientation = rect.height > rect.width;
        this.fileDropHandler = new FileDropHandler(this);
        this.tabbedPane.setTransferHandler(this.fileDropHandler);
        if (panel != null) {
            this.addTab(panel, 2, () -> {});
        }
    }

    protected Rectangle getAdaptiveBounds(boolean isInit) {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        double wid = maximize ? 1.0 : 0.92;
        double ht = maximize ? 1.0 : 0.75;
        int ceil = maximize ? 0 : 60;
        int w = (int)(wid * (double)dim.width);
        int margin = (int)((1.0 - wid) * (double)dim.width / 2.0);
        int h = (int)(ht * (double)(dim.height - ceil));
        Rectangle rect = new Rectangle(margin, ceil, w, h);
        if (isInit) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    TFrame.this.getAdaptiveBounds(false);
                }
            };
        } else {
            this.setBounds(rect);
            this.validate();
            this.repaint();
        }
        return rect;
    }

    @Override
    public void repaint(long time, int x, int y, int w, int h) {
        if (!this.isPaintable()) {
            return;
        }
        super.repaint(time, x, y, w, h);
    }

    public static void repaintT(Component c) {
        if (c == null) {
            return;
        }
        if (c instanceof TrackerPanel) {
            if (!((TrackerPanel)c).isPaintable()) {
                return;
            }
            ((TrackerPanel)c).clearTainted();
        }
        c.repaint();
    }

    @Override
    public void update(Graphics g) {
        super.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (!this.isShowing()) {
            return;
        }
        super.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTab(TrackerPanel trackerPanel, int addMode, Runnable whenDone) {
        this.setFrameBlocker(false, trackerPanel);
        boolean doSelect = (addMode & 1) != 0;
        boolean doRefresh = (addMode & 2) != 0;
        Integer panelID = trackerPanel.getID();
        int tab = this.getTab(panelID);
        TTabPanel tabPanel = null;
        if (tab >= 0) {
            String name = trackerPanel.getTitle();
            JTabbedPane jTabbedPane = this.tabbedPane;
            synchronized (jTabbedPane) {
                this.tabbedPane.setTitleAt(tab, name);
                this.tabbedPane.setToolTipTextAt(tab, trackerPanel.getToolTipPath());
            }
            tabPanel = this.getTabPanel(trackerPanel);
        } else {
            this.setIgnoreRepaint(true);
            Object[] objects = new Object[3];
            tabPanel = new TTabPanel(trackerPanel, objects);
            trackerPanel.addPropertyChangeListener("datafile", this);
            trackerPanel.addPropertyChangeListener("video", this);
            this.addPropertyChangeListener(PROPERTY_TFRAME_RADIANANGLES, trackerPanel);
            objects[0] = new MainTView(trackerPanel);
            objects[2] = this.getSplitPanes(trackerPanel);
            objects[1] = TFrame.createTViews(trackerPanel);
            String name = trackerPanel.getTitle();
            JTabbedPane jTabbedPane = this.tabbedPane;
            synchronized (jTabbedPane) {
                this.tabbedPane.addTab(name, tabPanel);
                tab = this.getTab(panelID);
                this.tabbedPane.setToolTipTextAt(tab, trackerPanel.getToolTipPath());
            }
            this.getToolBar(panelID, true);
            this.getMenuBar(panelID, true);
        }
        this.setupAddedPanel(tabPanel, tab, trackerPanel, doSelect, doRefresh, whenDone);
        this.doTabStateChanged();
    }

    /*
     * WARNING - void declaration
     */
    private void setupAddedPanel(TTabPanel tabPanel, int tab, TrackerPanel trackerPanel, boolean doSelect, boolean doRefresh, Runnable whenDone) {
        TViewChooser[] viewChoosers = this.getViewChoosers(trackerPanel);
        if (trackerPanel.customViewsProperty != null) {
            List<Object> arrayItems = trackerPanel.customViewsProperty.getPropertyContent();
            for (XMLProperty xMLProperty : arrayItems) {
                if (xMLProperty == null) continue;
                try {
                    String index = xMLProperty.getPropertyName().substring(1);
                    index = index.substring(0, index.length() - 1);
                    int chooserIndex = Integer.parseInt(index);
                    XMLControl[] viewControls = xMLProperty.getChildControls();
                    int j = 0;
                    while (j < viewControls.length) {
                        Class<?> viewClass = viewControls[j].getObjectClass();
                        TView view = viewChoosers[chooserIndex].getTView(viewClass);
                        if (view != null) {
                            viewControls[j].loadObject(view);
                            viewChoosers[chooserIndex].refresh();
                            viewChoosers[chooserIndex].repaint();
                        }
                        ++j;
                    }
                }
                catch (NumberFormatException e2) {
                    e2.printStackTrace();
                }
            }
            trackerPanel.customViewsProperty = null;
        }
        if (trackerPanel.selectedViewTypesProperty != null) {
            for (Object next : trackerPanel.selectedViewTypesProperty.getPropertyContent()) {
                String string = next.toString();
                int n = string.indexOf("{");
                if (n <= -1) continue;
                String string2 = string.substring(n + 1);
                try {
                    int i = 0;
                    while (i < viewChoosers.length) {
                        int currentType;
                        void var10_18;
                        int desiredType = Integer.parseInt(var10_18.substring(0, 1));
                        if (desiredType != (currentType = viewChoosers[i].getSelectedViewType())) {
                            viewChoosers[i].setSelectedViewType(Integer.parseInt(var10_18.substring(0, 1)));
                            viewChoosers[i].refresh();
                            viewChoosers[i].repaint();
                        }
                        String string3 = var10_18.substring(2);
                        ++i;
                    }
                }
                catch (NumberFormatException e3) {
                    e3.printStackTrace();
                }
            }
            trackerPanel.selectedViewTypesProperty = null;
        }
        if (trackerPanel.selectedViewsProperty != null) {
            List<Object> list = trackerPanel.selectedViewsProperty.getPropertyContent();
            int i = 0;
            while (i < list.size() && i < viewChoosers.length) {
                XMLProperty xMLProperty = (XMLProperty)list.get(i);
                if (xMLProperty != null) {
                    int type;
                    String viewName = ((String)xMLProperty.getPropertyContent().get(0)).toLowerCase();
                    int n = viewName.contains("diagrama") || viewName.contains("plot") ? 0 : (viewName.contains("tabla") || viewName.contains("table") ? 1 : (viewName.contains("mundo") || viewName.contains("world") ? 2 : (type = viewName.contains("texto") || viewName.contains("page") ? 3 : -1)));
                    if (type != i) {
                        if (viewChoosers[i].getSelectedViewType() != type) {
                            viewChoosers[i].ignoreSelectedTrack = true;
                        }
                        viewChoosers[i].setSelectedViewType(type);
                        viewChoosers[i].refresh();
                        viewChoosers[i].repaint();
                    }
                }
                ++i;
            }
            trackerPanel.selectedViewsProperty = null;
        }
        if (trackerPanel.selectedTrackViewsProperty != null) {
            void var10_23;
            String val = trackerPanel.selectedTrackViewsProperty.getPropertyContent().get(0).toString();
            String[] forChoosers = val.split(";");
            boolean bl = false;
            while (var10_23 < viewChoosers.length) {
                String[] selectedNames = forChoosers[var10_23].split(",");
                TView[] tviews = viewChoosers[var10_23].getTViews();
                int k = 0;
                while (k < selectedNames.length) {
                    if (!selectedNames[k].equals("null") && tviews[k] != null) {
                        TrackChooserTView view = (TrackChooserTView)tviews[k];
                        TTrack track = trackerPanel.getTrack(selectedNames[k]);
                        if (view.getSelectedTrack() != track) {
                            view.setSelectedTrack(track);
                            if (viewChoosers[var10_23].getSelectedView() == view) {
                                viewChoosers[var10_23].refresh();
                                viewChoosers[var10_23].repaint();
                            }
                        }
                    }
                    ++k;
                }
                ++var10_23;
            }
            trackerPanel.selectedViewTypesProperty = null;
        }
        this.placeViews(tabPanel, trackerPanel, viewChoosers);
        tabPanel.setToolbarVisible(true);
        this.initialize(trackerPanel);
        JPanel panel = (JPanel)this.tabbedPane.getComponentAt(tab);
        FontSizer.setFonts(panel);
        for (TTrack track : trackerPanel.getTracksTemp()) {
            track.setAnglesInRadians(this.anglesInRadians);
        }
        trackerPanel.clearTemp();
        this.setIgnoreRepaint(false);
        trackerPanel.refreshTrackData(4);
        if (doSelect) {
            this.setSelectedTab(trackerPanel);
        }
        if (doRefresh) {
            this.refresh();
        }
        if (whenDone != null) {
            whenDone.run();
        }
        Integer panelID = trackerPanel.getID();
        OSPRuntime.trigger(100, e -> {
            TrackerPanel tp = this.getTrackerPanelForID(panelID);
            if (doRefresh) {
                tp.refreshTrackBar();
            }
            tp.getDataBuilder();
            tp.changed = false;
        });
    }

    public void saveAllTabs(final boolean isExit, final Function<Integer, Void> whenEachApproved, final Runnable whenAllApproved, final Runnable whenCanceled) {
        final int[] tab = new int[]{this.getTabCount() - 1};
        TrackerPanel trackerPanel = this.getTrackerPanelForTab(tab[0]);
        if (trackerPanel == null) {
            return;
        }
        Function<Boolean, Void> whenClosed = new Function<Boolean, Void>(){

            @Override
            public Void apply(Boolean doSave) {
                TrackerPanel trackerPanel = TFrame.this.getTrackerPanelForTab(tab[0]);
                if ((!isExit || doSave.booleanValue()) && whenEachApproved != null) {
                    whenEachApproved.apply(trackerPanel.getID());
                }
                tab[0] = tab[0] - 1;
                if (tab[0] > -1) {
                    TFrame.this.getTrackerPanelForTab(tab[0]).askSaveIfChanged(this, whenCanceled);
                } else if (whenAllApproved != null) {
                    whenAllApproved.run();
                }
                return null;
            }
        };
        trackerPanel.askSaveIfChanged(whenClosed, whenCanceled);
    }

    protected void relaunchCurrentTabs() {
        final ArrayList filenames = new ArrayList();
        this.saveAllTabs(false, new Function<Integer, Void>(){

            @Override
            public Void apply(Integer panelID) {
                String fileName;
                String path;
                TrackerPanel trackerPanel = TFrame.this.getTrackerPanelForID(panelID);
                File datafile = trackerPanel.getDataFile();
                if (datafile == null && (path = trackerPanel.openedFromPath) != null) {
                    datafile = new File(path);
                }
                if (datafile != null && !filenames.contains(fileName = datafile.getAbsolutePath())) {
                    filenames.add(fileName);
                }
                return null;
            }
        }, new Runnable(){

            @Override
            public void run() {
                String[] args = filenames.isEmpty() ? null : filenames.toArray(new String[0]);
                TrackerStarter.relaunch(args, false);
            }
        }, null);
    }

    public void removeAllTabs(boolean isExit) {
        if (!this.haveContent() && this.getTabCount() == 1) {
            this.removeTabNow(0);
            OSPRuntime.Disposable.dump();
            if (isExit) {
                System.exit(0);
            }
            return;
        }
        this.hideNotes();
        ArrayList panels = new ArrayList();
        boolean[] cancelled = new boolean[1];
        this.removingAll = true;
        this.saveAllTabs(false, panelID -> {
            if (!cancelled[0]) {
                panels.add(panelID);
            }
            return null;
        }, () -> {
            if (isExit) {
                System.exit(0);
            }
            while (panels.size() > 0) {
                this.removeTabSynchronously(this.getTrackerPanelForID((Integer)panels.remove(0)));
            }
            OSPRuntime.Disposable.dump();
            this.checkMemTest();
            this.removingAll = false;
        }, () -> {
            blArray[0] = true;
            panels.clear();
            this.removingAll = false;
        });
    }

    private void checkMemTest() {
        if (!OSPRuntime.isJS) {
            System.gc();
            System.gc();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.gc();
            System.gc();
            System.out.println("TFrame memory:" + OSPRuntime.getMemoryStr());
        }
    }

    private void hideNotes() {
        if (this.notesVisible()) {
            this.notes.setVisible(false);
        }
    }

    @Override
    public int getState() {
        return this.state;
    }

    public boolean isRemovingAll() {
        return this.removingAll;
    }

    public boolean doCloseAction(TrackerPanel trackerPanel) {
        if (this.getTab(trackerPanel.getID()) < 0) {
            return false;
        }
        Function<Boolean, Void> removeTab = doSave -> {
            this.removeTabSynchronously(trackerPanel);
            return null;
        };
        trackerPanel.askSaveIfChanged(removeTab, null);
        return true;
    }

    public void removeTabSynchronously(TrackerPanel trackerPanel) {
        Object[] objects;
        TViewChooser[] sideViews;
        if (trackerPanel == null) {
            return;
        }
        this.state = 3;
        Integer panelID = trackerPanel.getID();
        int id = panelID;
        int tab = this.getTab(panelID);
        TTabPanel tabPanel = this.getTabPanel(trackerPanel);
        this.closeAllDialogs(trackerPanel, tabPanel);
        try {
            this.tabbedPane.remove(tab);
            this.tabbedPane.remove(tabPanel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (trackerPanel.trackControl != null) {
            this.deallocate(trackerPanel.trackControl);
        }
        if ((sideViews = (TViewChooser[])(objects = tabPanel.getObjects())[1]) != null) {
            int i = 0;
            while (i < sideViews.length) {
                this.deallocate(sideViews[i]);
                sideViews[i] = null;
                ++i;
            }
        }
        objects[1] = null;
        if (objects[0] != null) {
            this.deallocate((OSPRuntime.Disposable)objects[0]);
        }
        objects[0] = null;
        OSPRuntime.Disposable.deallocate((OSPRuntime.Disposable[])this._atoolbars, id);
        OSPRuntime.Disposable.deallocate((OSPRuntime.Disposable[])this._atrackbars, id);
        OSPRuntime.Disposable.deallocate((OSPRuntime.Disposable[])this._amenubars, id);
        JSplitPane[] panes = (JSplitPane[])objects[2];
        int i = 0;
        while (i < panes.length) {
            JSplitPane pane = panes[i];
            pane.removeAll();
            ++i;
        }
        i = 0;
        while (i < panes.length) {
            panes[i] = null;
            ++i;
        }
        objects[2] = null;
        if (this.prefsDialog != null) {
            this.prefsDialog.panelID = null;
        }
        Undo.undomap.remove(panelID);
        OSPRuntime.Disposable.deallocate((OSPRuntime.Disposable[])this._apanels, id);
        this.deallocatePanelID(panelID);
        System.gc();
        OSPRuntime.Disposable.deallocate(tabPanel);
        this.removePropertyChangeListener(PROPERTY_TFRAME_RADIANANGLES, trackerPanel);
        this.firePropertyChange(PROPERTY_TFRAME_TAB, trackerPanel, null);
        trackerPanel = null;
        tabPanel = (TTabPanel)this.tabbedPane.getSelectedComponent();
        objects = tabPanel == null ? null : tabPanel.getObjects();
        JMenuBar currentBar = this.getJMenuBar();
        if (currentBar != this.defaultMenuBar) {
            if (objects == null) {
                FontSizer.setFonts(this.defaultMenuBar, FontSizer.getLevel());
                this.setJMenuBar(this.defaultMenuBar);
                OSPRuntime.Disposable.deallocate((OSPRuntime.Disposable[])this._amenubars, id);
            } else if (tabPanel != null) {
                id = tabPanel.panelID;
                this.setJMenuBar(this.getMenuBar(id, true));
                this.getTrackBar(id, true).refresh();
                this.playerBar = ((MainTView)objects[0]).getPlayerBar();
                Container frame = this.playerBar.getTopLevelAncestor();
                if (frame != null && frame != this) {
                    frame.setVisible(true);
                }
            }
        }
        if (this.getTabCount() == 0) {
            this.clearAllReferences();
        }
        this.state = this.frameBlocker == null ? 0 : 2;
    }

    private void clearAllReferences() {
        if (this.notes != null) {
            this.notes.dispose();
            this.notes = null;
        }
        this.playerBar = null;
    }

    private void closeAllDialogs(TrackerPanel trackerPanel, TTabPanel tabPanel) {
        if (this.notesVisible() && !trackerPanel.getTitle().equals("Untitled")) {
            this.notes.dispose();
        }
    }

    public int getTab(Integer panelID) {
        int i = this.getTabCount();
        while (--i >= 0) {
            TTabPanel panel = (TTabPanel)this.tabbedPane.getComponentAt(i);
            if (panel.panelID != panelID) continue;
            return i;
        }
        return -1;
    }

    public int getTabForID(Integer panelID) {
        int i = this.getTabCount();
        while (--i >= 0) {
            TTabPanel panel = (TTabPanel)this.tabbedPane.getComponentAt(i);
            if (panel.getTrackerPanel().getID() != panelID) continue;
            return i;
        }
        return -1;
    }

    public int getTab(File dataFile) {
        if (dataFile == null) {
            return -1;
        }
        try {
            String path = dataFile.getCanonicalPath();
            int i = this.getTabCount();
            while (--i >= 0) {
                File file = ((TTabPanel)this.tabbedPane.getComponentAt(i)).getTrackerPanel().getDataFile();
                if (file == null || !path.equals(file.getCanonicalPath())) continue;
                return i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1;
    }

    public int getTabCount() {
        return this.tabbedPane.getTabCount();
    }

    public int getSelectedTab() {
        return this.tabbedPane == null ? -1 : this.tabbedPane.getSelectedIndex();
    }

    public void setSelectedTab(int tab) {
        if (tab < 0 || tab >= this.getTabCount()) {
            return;
        }
        this.tabbedPane.setSelectedIndex(tab);
        this.updateNotesDialog(this.getTrackerPanelForTab(tab));
    }

    public void setSelectedTab(File dataFile) {
        this.setSelectedTab(this.getTab(dataFile));
    }

    public void setSelectedTab(TrackerPanel trackerPanel) {
        this.setSelectedTab(this.getTab(trackerPanel.getID()));
    }

    public TrackerPanel getTrackerPanelForTab(int tab) {
        return tab < 0 || tab >= this.tabbedPane.getTabCount() ? null : ((TTabPanel)this.tabbedPane.getComponentAt(tab)).getTrackerPanel();
    }

    public TrackerPanel getSelectedPanel() {
        return this.getTrackerPanelForTab(this.getSelectedTab());
    }

    public void addTrackerPanel(boolean changedState, Runnable whenDone) {
        TrackerPanel newPanel = new TrackerPanel(this);
        Integer panelID = newPanel.getID();
        this.addTab(newPanel, 1, () -> {
            if (!changedState) {
                this.getTrackerPanelForID((Integer)n).changed = false;
            }
            if (whenDone == null) {
                this.refresh();
            } else {
                whenDone.run();
            }
        });
    }

    public String getTabTitle(int tab) {
        return tab < 0 ? null : this.tabbedPane.getTitleAt(tab);
    }

    public void refreshTab(TrackerPanel panel) {
        int tab = this.getTab(panel.getID());
        this.tabbedPane.setTitleAt(tab, panel.getTitle());
        this.tabbedPane.setToolTipTextAt(tab, panel.getToolTipPath());
    }

    public void setTabTitle(int tab, String title) {
        this.tabbedPane.setTitleAt(tab, title);
    }

    public void placeViews(TTabPanel tabPanel, TrackerPanel trackerPanel, TViewChooser[] viewChoosers) {
        if (viewChoosers == null) {
            viewChoosers = new TViewChooser[]{};
        }
        int[] order = TFrame.isPortraitLayout() ? PORTRAIT_VIEW_ORDER : DEFAULT_ORDER;
        Object[] objects = tabPanel.getObjects();
        TViewChooser[] choosers = (TViewChooser[])objects[1];
        if (choosers != null) {
            int i = 0;
            while (i < Math.min(viewChoosers.length, choosers.length)) {
                if (viewChoosers[i] != null) {
                    choosers[i] = viewChoosers[i];
                }
                ++i;
            }
        }
        if (order == null || order.length != viewChoosers.length) {
            order = DEFAULT_ORDER;
        }
        MainTView mainView = (MainTView)objects[0];
        JSplitPane[] panes = (JSplitPane[])objects[2];
        if (((BorderLayout)tabPanel.getLayout()).getLayoutComponent("Center") != panes[0]) {
            tabPanel.removeAll();
            tabPanel.add((Component)panes[0], "Center");
        }
        this.addPaneSafely(panes[0], 2, panes[2]);
        this.addPaneSafely(panes[0], 1, panes[1]);
        this.addPaneSafely(panes[2], 0, mainView);
        this.addPaneSafely(panes[2], 3, panes[3]);
        if (choosers != null) {
            this.addPaneSafely(panes[1], 0, choosers[order[0]]);
            this.addPaneSafely(panes[1], 3, choosers[order[1]]);
            this.addPaneSafely(panes[3], 1, choosers[order[2]]);
            this.addPaneSafely(panes[3], 2, choosers[order[3]]);
        }
    }

    public TTabPanel getTabPanel(TrackerPanel trackerPanel) {
        int tab = this.getTab(trackerPanel.getID());
        return tab >= 0 ? (TTabPanel)this.tabbedPane.getComponentAt(tab) : null;
    }

    private void addPaneSafely(JSplitPane pane, int where, Component c) {
        switch (where) {
            case 0: {
                if (pane.getTopComponent() == c) break;
                pane.setTopComponent(c);
                break;
            }
            case 1: {
                if (pane.getRightComponent() == c) break;
                pane.setRightComponent(c);
                break;
            }
            case 2: {
                if (pane.getLeftComponent() == c) break;
                pane.setLeftComponent(c);
                break;
            }
            case 3: {
                if (pane.getBottomComponent() == c) break;
                pane.setBottomComponent(c);
            }
        }
    }

    public void arrangeViews(TrackerPanel trackerPanel, boolean showDefaultViews, boolean showOtherViews) {
        if (!isLayoutAdaptive) {
            return;
        }
        TTabPanel tabPanel = this.getTabPanel(trackerPanel);
        this.placeViews(tabPanel, trackerPanel, this.getViewChoosers(trackerPanel));
        tabPanel.setToolbarVisible(true);
        boolean showRight = isPortraitOrientation ? showOtherViews : showDefaultViews;
        this.setDividerLocation(trackerPanel, 0, showRight ? 0.67 : 1.0);
        this.setDividerLocation(trackerPanel, 1, 0.57);
        boolean showBottom = isPortraitOrientation ? showDefaultViews : showOtherViews;
        this.setDividerLocation(trackerPanel, 2, showBottom ? 0.57 : 1.0);
        Integer panelID = trackerPanel.getID();
        SwingUtilities.invokeLater(() -> this.setDividerLocation(this.getTrackerPanelForID(panelID), 3, 0.5));
    }

    public TView[][] getTViews(TrackerPanel trackerPanel, boolean customOnly) {
        TViewChooser[] choosers = this.getViewChoosers(trackerPanel);
        if (choosers == null) {
            return null;
        }
        TView[][] array = new TView[choosers.length][];
        if (!customOnly) {
            int i = 0;
            while (i < choosers.length) {
                array[i] = choosers[i] == null ? null : choosers[i].getTViews();
                ++i;
            }
            return array;
        }
        int i = 0;
        while (i < choosers.length) {
            TView[] views = choosers[i].getTViews();
            if (views != null) {
                int j = 0;
                while (j < views.length) {
                    TView next = views[j];
                    if (next != null && next.isCustomState()) {
                        if (array[i] == null) {
                            array[i] = new TView[4];
                        }
                        array[i][j] = next;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return array;
    }

    public List<TView> getTViews(Integer panelID, int viewType, List<TView> list) {
        if (list == null) {
            list = new ArrayList<TView>();
        }
        TViewChooser[] choosers = this.getViewChoosers(panelID);
        int i = 0;
        while (i < choosers.length) {
            if (choosers[i] != null) {
                TView[] views = choosers[i].getTViews();
                if (viewType == -1) {
                    int j = 0;
                    while (j < views.length) {
                        if (views[j] != null) {
                            list.add(views[j]);
                        }
                        ++j;
                    }
                } else if (choosers[i].getSelectedViewType() == viewType) {
                    list.add(views[viewType]);
                }
            }
            ++i;
        }
        return list;
    }

    public int[] getSelectedViewTypes(TrackerPanel trackerPanel) {
        TViewChooser[] choosers = this.getViewChoosers(trackerPanel);
        int[] selectedViews = new int[4];
        int i = 0;
        while (i < selectedViews.length) {
            selectedViews[i] = choosers[i].getSelectedViewType();
            ++i;
        }
        return selectedViews;
    }

    public String getSelectedTrackViews(TrackerPanel trackerPanel) {
        StringBuffer buf = new StringBuffer();
        TViewChooser[] choosers = this.getViewChoosers(trackerPanel);
        int i = 0;
        while (i < choosers.length) {
            TTrack track;
            TrackChooserTView view;
            TView[] views;
            if (i > 0) {
                buf.append(";");
            }
            if ((views = choosers[i].getTViews())[0] != null) {
                view = (PlotTView)views[0];
                track = view.getSelectedTrack();
                buf.append(track == null ? "null," : String.valueOf(track.getName()) + ",");
            } else {
                buf.append("null,");
            }
            if (views[1] != null) {
                view = (TableTView)views[1];
                track = view.getSelectedTrack();
                buf.append(track == null ? "null" : track.getName());
            } else {
                buf.append("null");
            }
            ++i;
        }
        return buf.toString();
    }

    public boolean isViewPaneVisible(int position, Integer panelID) {
        JSplitPane[] panes = this.getSplitPanes(panelID);
        double[] locs = new double[panes.length];
        int i = 0;
        while (i < panes.length) {
            int max = panes[i].getMaximumDividerLocation();
            locs[i] = 1.0 * (double)panes[i].getDividerLocation() / (double)max;
            ++i;
        }
        switch (position) {
            case 0: {
                return locs[0] < 0.95 && locs[1] > 0.05;
            }
            case 1: {
                return locs[0] < 0.95 && locs[1] < 0.95;
            }
            case 2: {
                return locs[2] < 0.92 && locs[3] < 0.95;
            }
            case 3: {
                return locs[2] < 0.95 && locs[3] > 0.05;
            }
        }
        return false;
    }

    public boolean areViewsVisible(int whichViews, TrackerPanel trackerPanel) {
        boolean standardLayout;
        boolean bl = standardLayout = this.getSplitPane(trackerPanel, 1).getTopComponent() == this.getViewChoosers(trackerPanel)[0];
        int splitPaneIndex = whichViews == 0 && standardLayout ? 0 : (whichViews == 1 && !standardLayout ? 0 : 2);
        JSplitPane pane = this.getSplitPane(trackerPanel, splitPaneIndex);
        int max = pane.getMaximumDividerLocation();
        int cur = pane.getDividerLocation();
        double loc = 1.0 * (double)cur / (double)max;
        return splitPaneIndex == 0 ? loc < 0.95 : loc < 0.92;
    }

    public void setDividerLocation(TrackerPanel trackerPanel, int paneIndex, double loc) {
        JSplitPane[] panes = this.getSplitPanes(trackerPanel);
        if (paneIndex < panes.length) {
            panes[paneIndex].setDividerLocation(loc);
        }
    }

    public void setDividerLocation(TrackerPanel trackerPanel, int paneIndex, int loc) {
        JSplitPane[] panes = this.getSplitPanes(trackerPanel);
        if (paneIndex < panes.length) {
            panes[paneIndex].setDividerLocation(loc);
        }
    }

    JSplitPane getSplitPane(TrackerPanel trackerPanel, int paneIndex) {
        JSplitPane[] panes = this.getSplitPanes(trackerPanel);
        return paneIndex < panes.length ? panes[paneIndex] : null;
    }

    public MainTView getMainView(TrackerPanel trackerPanel) {
        Object[] objects = this.getObjects(trackerPanel);
        return objects == null ? null : (objects[0] == null ? new MainTView(trackerPanel) : (MainTView)objects[0]);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "video": 
            case "datafile": {
                TrackerPanel panel = (TrackerPanel)e.getSource();
                this.refreshTab(panel);
                break;
            }
            case "progress": {
                Object val = e.getNewValue();
                String vidName = XML.forwardSlash((String)e.getOldValue());
                if (val == null) break;
                try {
                    this.framesLoaded = Integer.parseInt(val.toString());
                    TrackerIO.setProgress(vidName, val.toString(), this.framesLoaded);
                }
                catch (Exception exception) {}
                break;
            }
            case "stalled": {
                String fileName = XML.getName((String)e.getNewValue());
                String s = String.valueOf(TrackerRes.getString("TFrame.Dialog.StalledVideo.Message0")) + "\n" + TrackerRes.getString("TFrame.Dialog.StalledVideo.Message1") + "\n" + TrackerRes.getString("TFrame.Dialog.StalledVideo.Message2") + "\n\n" + TrackerRes.getString("TFrame.Dialog.StalledVideo.Message3");
                String stop = TrackerRes.getString("TFrame.Dialog.StalledVideo.Button.Stop");
                String wait = TrackerRes.getString("TFrame.Dialog.StalledVideo.Button.Wait");
                int response = JOptionPane.showOptionDialog(this, s, String.valueOf(TrackerRes.getString("TFrame.Dialog.StalledVideo.Title")) + ": " + fileName, 0, 2, null, new String[]{stop, wait}, stop);
                if (response != 0) break;
                VideoIO.setCanceled(true);
                TrackerIO.closeMonitor(fileName);
                break;
            }
            case "locale": {
                Integer panelID;
                TrackerPanel panel;
                OSPRuntime.Disposable.deallocate((OSPRuntime.Disposable[])this._amenubars, this._bsPanelIDs);
                Tracker.createActions();
                this.checkLocale();
                this.defaultMenuBar = new DefaultMenuBar();
                this.setJMenuBar(this.defaultMenuBar);
                FontSizer.setFonts(this.defaultMenuBar, FontSizer.getLevel());
                int i = this.getTabCount();
                while (--i >= 0) {
                    Object[] objects = this.getObjects(i);
                    MainTView mainView = (MainTView)objects[0];
                    panel = mainView.getTrackerPanel();
                    panelID = panel.getID();
                    boolean changed = panel.changed;
                    OSPRuntime.Disposable.deallocate((OSPRuntime.Disposable[])this._amenubars, panelID);
                    this.getMenuBar(panelID, true);
                    CoordAxes axes = panel.getAxes();
                    if (axes != null) {
                        axes.setName(TrackerRes.getString("CoordAxes.New.Name"));
                    }
                    panel.changed = changed;
                    this.getToolBar(panelID, true).refresh("TFrame.locale");
                    this.getTrackBar(panelID, true).refresh();
                }
                panel = this.getSelectedPanel();
                if (panel != null) {
                    TMenuBar menuBar = this.getMenuBar(panel.getID(), false);
                    if (menuBar != null) {
                        this.setJMenuBar(menuBar);
                        menuBar.refresh("TFrame.locale");
                    }
                    if (Tracker.startupHintShown) {
                        panel.setMessage(TrackerRes.getString("Tracker.Startup.Hint"));
                    } else {
                        panel.setCursorForMarking(false, null);
                    }
                } else {
                    FontSizer.setFonts(this.defaultMenuBar, FontSizer.getLevel());
                    this.setJMenuBar(this.defaultMenuBar);
                }
                i = this.tabbedPane.getTabCount();
                while (--i >= 0) {
                    panel = this.getTrackerPanelForTab(i);
                    panelID = panel.getID();
                    this.tabbedPane.setTitleAt(i, panel.getTitle());
                    VideoPlayer player = panel.getPlayer();
                    player.refresh();
                    player.setLocale((Locale)e.getNewValue());
                    Video vid = panel.getVideo();
                    if (vid != null) {
                        vid.getFilterStack().refresh();
                    }
                    TrackControl.getControl(panel).refresh();
                    this.getToolBar(panelID, false).refresh("TFrame.locale2 ??");
                    this.getTrackBar(panelID, false).refresh();
                    TViewChooser[] choosers = this.getViewChoosers(panel);
                    int j = 0;
                    while (j < choosers.length) {
                        choosers[j].refresh();
                        ++j;
                    }
                    if (panel.autoTracker != null) {
                        panel.autoTracker.getWizard().textPaneSize = null;
                        panel.autoTracker.getWizard().refreshGUI();
                        panel.autoTracker.getWizard().pack();
                    }
                    if (this.prefsDialog != null && this.prefsDialog.isVisible()) {
                        this.prefsDialog.refreshGUI();
                    }
                    PencilDrawer.getDrawer(panel).refresh();
                    if (!this.notesVisible()) continue;
                    this.notes.refreshTextAndFonts();
                }
                this.validate();
                if (this.helpLauncher == null) break;
                Component[] search = HelpFinder.getNavComponentsFor(this.helpLauncher);
                Component[] comps = new Component[search.length + 2];
                System.arraycopy(search, 0, comps, 0, search.length);
                Tracker.pdfHelpButton.setText(TrackerRes.getString("Tracker.Button.PDFHelp"));
                comps[comps.length - 2] = Tracker.pdfHelpButton;
                comps[comps.length - 1] = Box.createHorizontalStrut(4);
                this.helpLauncher.setNavbarRightEndComponents(comps);
                break;
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        Tracker.checkSplash();
    }

    public boolean isAnglesInRadians() {
        return this.anglesInRadians;
    }

    public void setAnglesInRadians(boolean inRadians) {
        if (this.anglesInRadians == inRadians) {
            return;
        }
        this.anglesInRadians = inRadians;
        this.firePropertyChange(PROPERTY_TFRAME_RADIANANGLES, null, (Object)inRadians);
    }

    public PrefsDialog getPrefsDialog() {
        TrackerPanel trackerPanel = this.getSelectedPanel();
        if (this.prefsDialog != null) {
            Integer id;
            Integer n = id = trackerPanel == null ? null : trackerPanel.getID();
            if (this.prefsDialog.panelID != id) {
                this.prefsDialog.panelID = id;
                this.prefsDialog.refreshGUI();
            }
        } else {
            this.prefsDialog = new PrefsDialog(trackerPanel, this);
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - this.prefsDialog.getBounds().width) / 2;
            int y = (dim.height - this.prefsDialog.getBounds().height) / 2;
            this.prefsDialog.setLocation(x, y);
        }
        return this.prefsDialog;
    }

    public void showPrefsDialog() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                PrefsDialog prefsDialog = TFrame.this.getPrefsDialog();
                prefsDialog.setVisible(true);
                prefsDialog.requestFocus();
            }
        };
        new Thread(runner).start();
    }

    public void showPrefsDialog(final String tabName) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                PrefsDialog prefsDialog = TFrame.this.getPrefsDialog();
                if (tabName != null) {
                    if (tabName.contains("runtime")) {
                        prefsDialog.tabbedPane.setSelectedComponent(prefsDialog.runtimePanel);
                    } else if (tabName.contains("video")) {
                        prefsDialog.tabbedPane.setSelectedComponent(prefsDialog.videoPanel);
                    } else if (tabName.contains("general")) {
                        prefsDialog.tabbedPane.setSelectedComponent(prefsDialog.generalPanel);
                    } else if (tabName.contains("display")) {
                        prefsDialog.tabbedPane.setSelectedComponent(prefsDialog.displayPanel);
                    }
                }
                prefsDialog.setVisible(true);
                prefsDialog.requestFocus();
            }
        };
        new Thread(runner).start();
    }

    private static TViewChooser[] createTViews(TrackerPanel trackerPanel) {
        if (!Tracker.allowViews) {
            return new TViewChooser[4];
        }
        return new TViewChooser[]{TFrame.newTViewChooser(trackerPanel, 0), TFrame.newTViewChooser(trackerPanel, 1), TFrame.newTViewChooser(trackerPanel, 2), TFrame.newTViewChooser(trackerPanel, 3)};
    }

    private static TViewChooser newTViewChooser(TrackerPanel trackerPanel, int view) {
        TViewChooser c = new TViewChooser(trackerPanel, view);
        return c;
    }

    JSplitPane[] getSplitPanes(Integer panelID) {
        return this.getSplitPanes(this.getTrackerPanelForID(panelID));
    }

    JSplitPane[] getSplitPanes(TrackerPanel trackerPanel) {
        Object[] objects = this.getObjects(trackerPanel);
        if (objects != null && objects[2] != null) {
            return (JSplitPane[])objects[2];
        }
        JSplitPane[] panes = new JSplitPane[]{new JSplitPane(1), new JSplitPane(0), new JSplitPane(0), new JSplitPane(1){

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(0, 0);
            }
        }};
        panes[0].setName("TOP(0)");
        panes[1].setName("RIGHT(1)");
        panes[2].setName("LEFT(2)");
        panes[3].setName("BOTTOM(3)");
        TFrame.setDefaultWeights(panes);
        return panes;
    }

    private static void setDefaultWeights(JSplitPane[] panes) {
        TFrame.setDefaultWeight(panes[0], 1.0);
        TFrame.setDefaultWeight(panes[1], 0.5);
        TFrame.setDefaultWeight(panes[2], 1.0);
        TFrame.setDefaultWeight(panes[3], 0.5);
    }

    private static void setDefaultWeight(JSplitPane pane, double d) {
        pane.setDividerSize(10);
        pane.setResizeWeight(d);
        pane.setOneTouchExpandable(true);
    }

    public int getMaximizedView() {
        return this.maximizedView;
    }

    void maximizeView(TrackerPanel trackerPanel, int viewIndex) {
        this.maximizedView = viewIndex;
        JSplitPane[] panes = this.getSplitPanes(trackerPanel);
        int i = 0;
        while (i < panes.length) {
            panes[i].setDividerSize(0);
            ++i;
        }
        int[] order = TFrame.isPortraitLayout() ? PORTRAIT_VIEW_ORDER : DEFAULT_ORDER;
        int viewPosition = viewIndex < order.length ? order[viewIndex] : viewIndex;
        switch (viewPosition) {
            case 0: {
                panes[1].setResizeWeight(1.0);
                this.setDividerLocation(trackerPanel, 0, 0.0);
                this.setDividerLocation(trackerPanel, 1, 1.0);
                break;
            }
            case 1: {
                panes[1].setResizeWeight(0.0);
                this.setDividerLocation(trackerPanel, 0, 0.0);
                this.setDividerLocation(trackerPanel, 1, 0.0);
                break;
            }
            case 2: {
                panes[3].setResizeWeight(0.0);
                this.setDividerLocation(trackerPanel, 0, 1.0);
                this.setDividerLocation(trackerPanel, 2, 0.0);
                this.setDividerLocation(trackerPanel, 3, 0.0);
                break;
            }
            case 3: {
                panes[3].setResizeWeight(1.0);
                this.setDividerLocation(trackerPanel, 0, 1.0);
                int max = panes[0].getMaximumDividerLocation();
                this.setDividerLocation(trackerPanel, 2, 0.0);
                this.setDividerLocation(trackerPanel, 3, max);
                break;
            }
            case 4: {
                this.setDividerLocation(trackerPanel, 0, 1.0);
                this.setDividerLocation(trackerPanel, 2, 1.0);
                this.setDividerLocation(trackerPanel, 3, 0.0);
            }
        }
        TMenuBar menubar = this.getMenuBar(trackerPanel.getID(), true);
        menubar.setMenuTainted(32, true);
    }

    void saveCurrentDividerLocations(TrackerPanel trackerPanel) {
        if (this.maximizedView != -1) {
            return;
        }
        if (trackerPanel.dividerLocs == null) {
            trackerPanel.dividerLocs = new double[4];
        }
        int i = 0;
        while (i < trackerPanel.dividerFractions.length) {
            JSplitPane pane = this.getSplitPane(trackerPanel, i);
            int max = pane.getMaximumDividerLocation();
            int cur = Math.min(pane.getDividerLocation(), max);
            trackerPanel.dividerLocs[i] = cur;
            double fraction = 1.0 * (double)cur / (double)max;
            fraction = fraction < 0.07 && (i == 1 || i == 3) ? 0.0 : fraction;
            trackerPanel.dividerFractions[i] = fraction = fraction > 0.9299999999999999 ? 1.0 : fraction;
            ++i;
        }
    }

    void restoreViews(TrackerPanel trackerPanel) {
        int i = 0;
        while (i < trackerPanel.dividerFractions.length) {
            if (trackerPanel.dividerLocs == null) {
                this.setDividerLocation(trackerPanel, i, trackerPanel.dividerFractions[i]);
            } else {
                this.setDividerLocation(trackerPanel, i, (int)trackerPanel.dividerLocs[i]);
            }
            ++i;
        }
        TFrame.setDefaultWeights(this.getSplitPanes(trackerPanel));
        this.maximizedView = -1;
        TMenuBar menubar = this.getMenuBar(trackerPanel.getID(), true);
        menubar.setMenuTainted(32, true);
        if (isLayoutChanged) {
            this.frameResized();
        }
    }

    public TTrackBar getTrackBar(Integer panelID, boolean forceNew) {
        int i = panelID;
        TTrackBar bar = this._atrackbars[i];
        if (bar == null && forceNew) {
            this._atrackbars[i] = bar = new TTrackBar(this._apanels[i]);
        }
        return bar;
    }

    public TToolBar getToolBar(Integer panelID, boolean forceNew) {
        int i = panelID;
        TToolBar bar = this._atoolbars[i];
        if (bar == null && forceNew) {
            this._atoolbars[i] = new TToolBar(this._apanels[i]);
        }
        return bar;
    }

    public void setToolBar(TrackerPanel trackerPanel, TToolBar toolbar) {
        int i = trackerPanel.getID();
        TToolBar old = this._atoolbars[i];
        if (old != null) {
            OSPRuntime.Disposable.deallocate(old);
        }
        this._atoolbars[i] = toolbar;
    }

    public TMenuBar getMenuBar(Integer panelID, boolean forceNew) {
        TrackerPanel panel = this.getTrackerPanelForID(panelID);
        int i = panelID;
        TMenuBar bar = this._amenubars[i];
        if (bar == null && forceNew) {
            bar = this._amenubars[i] = new TMenuBar(panel);
            FontSizer.setFonts(bar);
        }
        return bar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshOpenRecentMenu(JMenu menu) {
        if (!OSPRuntime.isJS) {
            ArrayList<String> arrayList = Tracker.recentFiles;
            synchronized (arrayList) {
                menu.setText(TrackerRes.getString("TMenuBar.Menu.OpenRecent"));
                menu.setEnabled(!Tracker.recentFiles.isEmpty());
                if (this.openRecentAction == null) {
                    this.openRecentAction = new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TFrame.this.doRecentFiles(e.getActionCommand());
                        }
                    };
                }
                menu.removeAll();
                menu.setEnabled(!Tracker.recentFiles.isEmpty());
                for (String next : Tracker.recentFiles) {
                    JMenuItem item = new JMenuItem(XML.getName(next));
                    FontSizer.setFont(item);
                    item.setActionCommand(next);
                    item.setToolTipText(next);
                    item.addActionListener(this.openRecentAction);
                    menu.add(item);
                }
            }
        }
    }

    protected void doRecentFiles(String path) {
        URL url = null;
        if (!ResourceLoader.isHTTP(path)) {
            int n;
            File file = new File(path);
            if (!file.exists() && (n = path.indexOf("!")) >= 0 && !(file = new File(path.substring(0, n))).exists()) {
                try {
                    url = new URL(path);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (!file.exists() && url == null) {
                Tracker.recentFiles.remove(path);
                TrackerPanel panel = this.getSelectedPanel();
                if (panel != null) {
                    this.refreshMenus(panel, "TFrame.openRecent");
                }
                this.sayFileNotFound(path);
                return;
            }
        }
        this.doOpenURL(path);
    }

    public void refresh() {
        TViewChooser[] choosers;
        TTrackBar rb;
        TToolBar tb;
        TrackerPanel panel = this.getSelectedPanel();
        if (panel == null) {
            return;
        }
        Integer panelID = panel.getID();
        TMenuBar mb = this.getMenuBar(panelID, false);
        if (mb != null) {
            mb.refresh("TFrame.refresh");
        }
        if ((tb = this.getToolBar(panelID, false)) != null) {
            tb.refresh("TFrame.refresh");
        }
        if ((rb = this.getTrackBar(panelID, false)) != null) {
            rb.refresh();
        }
        if ((choosers = this.getViewChoosers(panel)) != null) {
            TViewChooser[] tViewChooserArray = choosers;
            int n = choosers.length;
            int n2 = 0;
            while (n2 < n) {
                TViewChooser next = tViewChooserArray[n2];
                if (next instanceof TViewChooser) {
                    TViewChooser chooser = next;
                    chooser.refreshMenus();
                }
                ++n2;
            }
        }
        this.updateNotesDialog(panel);
    }

    @Override
    public void setFontLevel(int level) {
        if (!OSPRuntime.allowSetFonts) {
            return;
        }
        try {
            super.setFontLevel(level);
            if (this.libraryBrowser != null) {
                this.libraryBrowser.setFontLevel(level);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.tabbedPane == null) {
            return;
        }
        textLayoutFont = FontSizer.getResizedFont(textLayoutFont, level);
        int i = this.getTabCount();
        while (--i >= 0) {
            TrackerPanel trackerPanel = this.getTrackerPanelForTab(i);
            trackerPanel.setFontLevel(level);
        }
        if (haveExportDialog) {
            ExportZipDialog.setFontLevels(level);
            if (ExportVideoDialog.videoExporter != null) {
                ExportVideoDialog.videoExporter.setFontLevel(level);
            }
        }
        if (haveThumbnailDialog && ThumbnailDialog.thumbnailDialog != null) {
            FontSizer.setFonts(ThumbnailDialog.thumbnailDialog, level);
            ThumbnailDialog.thumbnailDialog.refreshGUI();
        }
        if (this.prefsDialog != null) {
            this.prefsDialog.refreshGUI();
        }
        if (this.libraryBrowser != null) {
            this.libraryBrowser.setFontLevel(level);
        }
        if (this.notesVisible()) {
            this.notes.refreshTextAndFonts();
        }
        OSPLog.setFonts(level);
        if (Tracker.readmeDialog != null) {
            FontSizer.setFonts(Tracker.readmeDialog, level);
        }
        if (Tracker.startLogDialog != null) {
            FontSizer.setFonts(Tracker.startLogDialog, level);
        }
        FontSizer.setFonts(this.defaultMenuBar, level);
        if (this.helpLauncher != null) {
            this.helpLauncher.setFontLevel(level);
            i = 0;
            while (i < this.helpLauncher.getTabCount()) {
                LaunchPanel tab = this.helpLauncher.getTab(i);
                if (level > 0) {
                    String newValue = "help" + level + ".css";
                    tab.getHTMLSubstitutionMap().put("help.css", newValue);
                } else {
                    tab.getHTMLSubstitutionMap().remove("help.css");
                }
                ++i;
            }
            i = 0;
            while (i < this.helpLauncher.getHTMLTabCount()) {
                Launcher.HTMLPane pane = this.helpLauncher.getHTMLTab(i);
                pane.editorPane.getDocument().putProperty("stream", null);
                ++i;
            }
            this.helpLauncher.setDivider((int)(175.0 * FontSizer.getFactor(level)));
            this.helpLauncher.refreshSelectedTab();
        }
    }

    protected LibraryBrowser getLibraryBrowser() {
        if (this.libraryBrowser == null) {
            try {
                LibraryComPADRE.desiredOSPType = "Tracker";
                this.libraryBrowser = LibraryBrowser.getBrowser(null);
                this.libraryBrowser.addOSPLibrary("https://opensourcephysics.github.io/resources/CAB/tracker_library.xml");
                this.libraryBrowser.addOSPLibrary("https://opensourcephysics.github.io/resources/CAB/shared_library.xml");
                this.libraryBrowser.addComPADRECollection("https://www.compadre.org/osp/services/REST/osp_tracker.cfm?verb=Identify&OSPType=Tracker&OSPPrimary=Subject");
                this.libraryBrowser.refreshCollectionsMenu();
                this.libraryBrowser.addPropertyChangeListener("target", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        File file;
                        if ("LOAD" == e.getOldValue()) {
                            LibraryResource record = (LibraryResource)e.getNewValue();
                            String toCancel = " [" + TrackerRes.getString("TFrame.LibraryBrowser.Message.Cancel") + "]";
                            String loading = " " + TrackerRes.getString("Tracker.Splash.Loading") + " \"";
                            String message = String.valueOf(loading) + record.getName() + "\"" + toCancel;
                            TFrame.this.libraryBrowser.setMessage(message, Color.YELLOW);
                            TFrame.this.libraryBrowser.setComandButtonEnabled(false);
                            VideoIO.setCanceled(false);
                            SwingUtilities.invokeLater(() -> TFrame.this.loadLibraryRecord(record));
                        } else if ("DOWNLOAD" == e.getOldValue() && (file = (File)e.getNewValue()) != null) {
                            file.exists();
                        }
                    }
                });
                LibraryBrowser.fireHelpEvent = true;
                this.libraryBrowser.addPropertyChangeListener("help", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        TFrame.this.showHelp("library", 0);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.libraryBrowser;
    }

    protected PropertiesDialog getPropertiesDialog(TrackerPanel trackerPanel) {
        PropertiesDialog dialog = new PropertiesDialog(trackerPanel);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - dialog.getBounds().width) / 2;
        int y = (dim.height - dialog.getBounds().height) / 2;
        dialog.setLocation(x, y);
        return dialog;
    }

    protected Component getHelpDialog() {
        if (this.helpDialog == null) {
            this.helpDialog = new JDialog(this, TrackerRes.getString("TFrame.Dialog.Help.Title"), false);
            String help_path = "/org/opensourcephysics/cabrillo/tracker/resources/help/help_set.xml";
            this.helpLauncher = new Launcher(help_path, false, (JPanel)this.helpDialog.getContentPane());
            this.helpLauncher.popupEnabled = false;
            int level = FontSizer.getLevel();
            if (this.helpLauncher.getTabCount() > 0) {
                LaunchPanel tab = this.helpLauncher.getTab(0);
                if (level > 0) {
                    String newValue = "help" + level + ".css";
                    tab.getHTMLSubstitutionMap().put("help.css", newValue);
                } else {
                    tab.getHTMLSubstitutionMap().remove("help.css");
                }
            }
            this.helpLauncher.setDivider((int)(175.0 * FontSizer.getFactor(level)));
            this.helpLauncher.setNavigationVisible(true);
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dim = this.helpLauncher.getSize();
            dim.width = Math.min(9 * screen.width / 10, (int)((1.0 + (double)level * 0.35) * (double)dim.width));
            dim.height = Math.min(9 * screen.height / 10, (int)((1.0 + (double)level * 0.35) * (double)dim.height));
            this.helpLauncher.setSize(dim);
            FontSizer.setFonts(this.helpDialog, FontSizer.getLevel());
            this.helpDialog.pack();
            int x = (screen.width - this.helpDialog.getBounds().width) / 2;
            int y = (screen.height - this.helpDialog.getBounds().height) / 2;
            this.helpDialog.setLocation(x, y);
        }
        Component[] search = HelpFinder.getNavComponentsFor(this.helpLauncher);
        Component[] comps = new Component[search.length + 2];
        System.arraycopy(search, 0, comps, 0, search.length);
        Tracker.pdfHelpButton.setText(TrackerRes.getString("Tracker.Button.PDFHelp"));
        comps[comps.length - 2] = Tracker.pdfHelpButton;
        comps[comps.length - 1] = Box.createHorizontalStrut(4);
        FontSizer.setFonts(comps, FontSizer.getLevel());
        this.helpLauncher.setNavbarRightEndComponents(comps);
        return this.helpDialog;
    }

    protected void showHelp(String selectedNode) {
        this.getHelpDialog();
        this.helpLauncher.setSelectedNode(selectedNode);
        this.helpDialog.setVisible(true);
    }

    protected void showHelp(String keywords, int pageNumber) {
        boolean firstTime = this.helpDialog == null;
        this.getHelpDialog();
        if (keywords == null && firstTime) {
            keywords = "help";
        }
        this.helpLauncher.setSelectedNodeByKey(keywords, pageNumber);
        if (firstTime) {
            this.helpLauncher.clearHistory();
        }
        this.helpDialog.setVisible(true);
    }

    private Object[] getObjects(TrackerPanel trackerPanel) {
        return this.getObjects(this.getTab(trackerPanel.getID()));
    }

    public Object[] getObjects(int tab) {
        return tab < 0 || tab >= this.tabbedPane.getTabCount() ? null : ((TTabPanel)this.tabbedPane.getComponentAt(tab)).getObjects();
    }

    protected ClipboardListener getClipboardListener() {
        if (this.clipboardListener == null && OSPRuntime.allowAutopaste) {
            this.clipboardListener = new ClipboardListener(this);
            this.clipboardListener.start();
        }
        return this.clipboardListener;
    }

    public boolean getAlwaysListenToClipboard() {
        return this.alwaysListenToClipboard;
    }

    public void setAlwaysListenToClipboard(boolean b) {
        this.alwaysListenToClipboard = b;
        this.checkClipboardListener();
    }

    protected void checkClipboardListener() {
        SwingUtilities.invokeLater(() -> {
            boolean needListener = this.alwaysListenToClipboard;
            if (!needListener) {
                try {
                    int i = this.getTabCount();
                    while (--i >= 0) {
                        TrackerPanel trackerPanel = this.getTrackerPanelForTab(i);
                        ArrayList<DataTrack> list = trackerPanel.getDrawablesTemp(DataTrack.class);
                        int m = 0;
                        int n = list.size();
                        while (m < n) {
                            DataTrack next = list.get(m);
                            if (next.getSource() == null && next.isAutoPasteEnabled()) {
                                needListener = true;
                                break;
                            }
                            ++m;
                        }
                        list.clear();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (needListener) {
                this.getClipboardListener();
            } else {
                if (this.clipboardListener == null) {
                    return;
                }
                this.clipboardListener.end();
                this.clipboardListener = null;
            }
        });
    }

    private void createGUI() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TFrame.this.frameResized();
            }
        });
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                TFrame.this.firePropertyChange(TFrame.PROPERTY_TFRAME_WINDOWFOCUS, null, null);
            }
        });
        this.saveNotesAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TFrame.this.getNotes().save();
            }
        };
        this.tabbedPane = new JTabbedPane(3);
        this.frameContentPane = new JPanel(new BorderLayout());
        this.setContentPane(this.frameContentPane);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.checkLocale();
        this.defaultMenuBar = new DefaultMenuBar();
        this.setJMenuBar(this.defaultMenuBar);
        FontSizer.setFonts(this.defaultMenuBar, FontSizer.getLevel());
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TFrame.this.doTabStateChanged();
            }
        });
        this.closeItem = new JMenuItem();
        this.closeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TFrame.this.hideNotes();
                TFrame.this.doCloseAction(TFrame.this.getSelectedPanel());
            }
        });
        this.popup.add(this.closeItem);
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TrackerPanel panel = TFrame.this.getSelectedPanel();
                if (panel == null || !panel.isEnabled("file.close")) {
                    return;
                }
                if (OSPRuntime.isPopupTrigger(e)) {
                    TFrame.this.closeItem.setText(String.valueOf(TrackerRes.getString("TActions.Action.Close")) + " \"" + TFrame.this.tabbedPane.getTitleAt(TFrame.this.getSelectedTab()) + "\"");
                    FontSizer.setFonts(TFrame.this.popup, FontSizer.getLevel());
                    TFrame.this.popup.show(TFrame.this.tabbedPane, e.getX(), e.getY());
                }
            }
        });
    }

    protected Notes getNotes() {
        if (this.notes == null) {
            this.notes = new Notes();
        }
        return this.notes;
    }

    protected void doTabStateChanged() {
        TrackerPanel oldPanel;
        TrackerPanel newPanel;
        Object[] objects = this.getObjects(this.tabbedPane.getSelectedIndex());
        MainTView mainView = objects == null ? null : (MainTView)objects[0];
        TrackerPanel trackerPanel = newPanel = mainView == null ? null : mainView.getTrackerPanel();
        if (mainView == null && objects != null) {
            return;
        }
        TrackerPanel trackerPanel2 = oldPanel = newPanel != null && this.prevPanelID == newPanel.panelID ? newPanel : this.deactivateOldTrackerPanel(this.prevPanelID);
        if (objects == null) {
            FontSizer.setFonts(this.defaultMenuBar, FontSizer.getLevel());
            this.setJMenuBar(this.defaultMenuBar);
        } else if (mainView != null && newPanel != null) {
            Video vid;
            TMenuBar menubar;
            TTrackBar tbar;
            this.prevPanelID = newPanel.getID();
            if (this.prefsDialog != null) {
                this.prefsDialog.panelID = newPanel.getID();
            }
            if (oldPanel != null) {
                oldPanel.isNotesVisible = this.notesVisible();
            }
            if (this.notes != null) {
                this.notes.dialog.setVisible(newPanel.isNotesVisible);
            }
            this.updateNotesDialog(newPanel);
            Integer panelID = newPanel.getID();
            TToolBar bar = this.getToolBar(panelID, true);
            if (bar != null) {
                bar.notesButton.setSelected(this.notesVisible());
            }
            if ((tbar = this.getTrackBar(panelID, true)) != null) {
                tbar.refresh();
            }
            if ((menubar = this.getMenuBar(panelID, true)) != null) {
                this.setJMenuBar(menubar);
            }
            this.playerBar = mainView.getPlayerBar();
            Container frame = this.playerBar.getTopLevelAncestor();
            if (frame != null && frame != this) {
                frame.setVisible(true);
            }
            if (newPanel.dataBuilder != null) {
                newPanel.dataBuilder.setVisible(newPanel.dataToolVisible);
            }
            if ((vid = newPanel.getVideo()) != null) {
                vid.getFilterStack().setInspectorsVisible(true);
            }
        }
        if (this.prefsDialog != null && this.prefsDialog.isVisible()) {
            this.prefsDialog.refreshGUI();
        }
        if (oldPanel != newPanel) {
            this.firePropertyChange(PROPERTY_TFRAME_TAB, oldPanel, newPanel);
        }
        this.clearHoldPainting();
        TFrame.repaintT(newPanel);
    }

    private TrackerPanel deactivateOldTrackerPanel(Integer panelID) {
        Container frame;
        TrackerPanel oldPanel = this.getTrackerPanelForID(panelID);
        if (this.prefsDialog != null) {
            this.prefsDialog.panelID = null;
        }
        if (this.playerBar != null && (frame = this.playerBar.getTopLevelAncestor()) != null && frame != this) {
            frame.setVisible(false);
        }
        if (oldPanel != null) {
            Video vid;
            if (oldPanel.dataBuilder != null) {
                boolean vis = oldPanel.dataToolVisible;
                oldPanel.dataBuilder.setVisible(false);
                oldPanel.dataToolVisible = vis;
            }
            if (oldPanel.getPlayer() != null) {
                ClipInspector ci;
                VideoClip clip = oldPanel.getPlayer().getVideoClip();
                ClipInspector clipInspector = ci = clip == null ? null : clip.getClipInspector();
                if (ci != null) {
                    ci.setVisible(false);
                }
            }
            if ((vid = oldPanel.getVideo()) != null) {
                vid.getFilterStack().setInspectorsVisible(false);
            }
        }
        return oldPanel;
    }

    protected void frameResized() {
        TrackerPanel trackerPanel = this.getSelectedPanel();
        if (!isLayoutAdaptive || trackerPanel == null) {
            return;
        }
        Rectangle rect = this.getBounds();
        isLayoutChanged = isPortraitOrientation ^ rect.height > rect.width;
        if (this.maximizedView != -1) {
            this.maximizeView(trackerPanel, this.maximizedView);
            trackerPanel.dividerLocs = null;
            return;
        }
        if (isLayoutChanged) {
            isPortraitOrientation = !isPortraitOrientation;
            int i = this.getTabCount();
            while (--i >= 0) {
                trackerPanel = this.getTrackerPanelForTab(i);
                boolean defaultViewsVisible = this.areViewsVisible(0, trackerPanel);
                boolean moreViewsVisible = this.areViewsVisible(1, trackerPanel);
                this.arrangeViews(trackerPanel, defaultViewsVisible, moreViewsVisible);
            }
            isLayoutChanged = false;
        }
    }

    DataDropHandler getDataDropHandler() {
        return this.dataDropHandler == null ? (this.dataDropHandler = new DataDropHandler()) : this.dataDropHandler;
    }

    private void initialize(TrackerPanel trackerPanel) {
        TMenuBar mbar = this.getMenuBar(trackerPanel.getID(), false);
        if (mbar != null) {
            mbar.setAllowRefresh(false);
        }
        trackerPanel.initialize(this.fileDropHandler);
        this.validate();
        boolean portrait = TFrame.isPortraitLayout();
        if (trackerPanel.dividerLocs == null) {
            this.setDividerLocation(trackerPanel, 0, portrait ? 1.0 : 0.67);
            this.setDividerLocation(trackerPanel, 0, 1.0);
            this.setDividerLocation(trackerPanel, 1, 0.57);
            this.setDividerLocation(trackerPanel, 2, portrait ? 0.57 : 1.0);
            this.setDividerLocation(trackerPanel, 3, 0.5);
        } else {
            int w = 0;
            int[] order = portrait ? PORTRAIT_DIVIDER_ORDER : DEFAULT_ORDER;
            int i = 0;
            while (i < order.length) {
                JSplitPane pane = this.getSplitPane(trackerPanel, i);
                if (i == 0) {
                    w = pane.getMaximumDividerLocation();
                }
                int max = i == 3 ? w : pane.getMaximumDividerLocation();
                double loc = trackerPanel.dividerLocs[order[i]];
                loc = this.getConvertedDividerLoc(i, loc);
                pane.setDividerLocation((int)(loc * (double)max));
                ++i;
            }
            trackerPanel.dividerLocs = null;
        }
        this.validate();
        trackerPanel.initialize(null);
        mbar = this.getMenuBar(trackerPanel.getID(), false);
        if (mbar != null) {
            mbar.setAllowRefresh(true);
        }
    }

    protected static boolean isPortraitLayout() {
        return isLayoutAdaptive && isPortraitOrientation;
    }

    protected double getConvertedDividerLoc(int splitPaneIndex, double loc) {
        if (TFrame.isPortraitLayout()) {
            switch (splitPaneIndex) {
                case 0: {
                    return loc > 0.92 ? 1.0 : 0.67;
                }
                case 1: {
                    return loc > 0.92 ? 1.0 : (loc < 0.08 ? 0.0 : 0.57);
                }
                case 2: {
                    return loc > 0.92 ? 1.0 : 0.57;
                }
                case 3: {
                    return loc > 0.92 ? 1.0 : (loc < 0.08 ? 0.0 : 0.5);
                }
            }
        }
        return loc;
    }

    public void holdPainting(boolean b) {
        if (!Tracker.doHoldRepaint) {
            return;
        }
        this.paintHold += b ? 1 : (this.paintHold > 0 ? -1 : 0);
    }

    public boolean isPaintable() {
        return this.isVisible() && this.paintHold == 0 && !this.getIgnoreRepaint();
    }

    public boolean hasPaintHold() {
        return this.paintHold != 0;
    }

    public void clearHoldPainting() {
        this.paintHold = 0;
    }

    public ComponentListener addFollower(final Component c, Point ignored) {
        final Point pt0 = this.getLocation();
        ComponentAdapter listener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                Point fp = TFrame.this.getLocation();
                int dx = fp.x - pt0.x;
                int dy = fp.y - pt0.y;
                pt0.x = fp.x;
                pt0.y = fp.y;
                Point p = c.getLocation();
                p.x += dx;
                p.y += dy;
                c.setLocation(p);
            }
        };
        this.addComponentListener(listener);
        return listener;
    }

    public static void addMenuListener(JMenu m, final Runnable r) {
        m.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                r.run();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    boolean haveContent() {
        return this.getTabCount() > 0 && (this.getTrackerPanelForTab((int)0).changed || !this.tabbedPane.getTitleAt(0).equals(TrackerRes.getString("TrackerPanel.NewTab.Name")));
    }

    int getRemovableTabNumber(Integer panelID) {
        int tab = this.getTab(panelID);
        boolean clean = tab > -1 && !this.getTrackerPanelForID((Integer)panelID).changed && this.tabbedPane.getTitleAt(tab).equals(TrackerRes.getString("TrackerPanel.NewTab.Name"));
        return clean ? tab : -1;
    }

    synchronized TrackerPanel getCleanTrackerPanel() {
        TrackerPanel panel = new TrackerPanel(this);
        return panel;
    }

    public void removeEmptyTabIfTabCountGreaterThan(int n) {
        if (this.getTabCount() > n && !this.haveContent()) {
            this.removeTabNow(0);
        }
    }

    public void removeTabNow(int i) {
        TrackerPanel tp = this.getTrackerPanelForTab(i);
        if (tp != null) {
            this.removeTabSynchronously(tp);
        }
    }

    public void loadExperimentURL(String path) {
        if (path != null && !path.startsWith("http")) {
            path = "https://./" + path;
            OSPLog.fine("Loading Tracker experiment path=" + path);
        }
        if (path == null && (path = GUIUtils.showInputDialog(this, "Load Experiment", "Load Experiment", 3, this.lastExperiment)) == null) {
            return;
        }
        if (TrackerIO.isVideo(new File(path))) {
            this.loadVideo(path, false, null, null);
            return;
        }
        if (this.getTabCount() > 0) {
            this.removeAllTabs(false);
        }
        try {
            this.doOpenURL(path);
        }
        catch (Throwable t) {
            this.removeAllTabs(false);
        }
    }

    protected void loadLibraryRecord(LibraryResource record) {
        this.openLibraryResource(record, () -> {
            Integer panelID = this.getSelectedPanelID();
            OSPRuntime.trigger(200, ev -> {
                this.libraryBrowser.doneLoading();
                if (!loadFailed) {
                    this.requestFocus();
                }
                if (panelID != null) {
                    TrackerPanel panel = this.getTrackerPanelForID(panelID);
                    panel.changed = false;
                    TFrame.repaintT(panel);
                    if (panel.openedFromPath != null) {
                        Tracker.addRecent(panel.openedFromPath, false);
                    }
                }
            });
        });
    }

    private Integer getSelectedPanelID() {
        TrackerPanel panel = this.getSelectedPanel();
        return panel == null ? null : panel.getID();
    }

    /*
     * Exception decompiling
     */
    public void openLibraryResource(LibraryResource record, Runnable whenDone) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setCursor(Cursor c) {
        super.setCursor(c);
        if (this.tabbedPane != null) {
            this.tabbedPane.setCursor(c);
        }
        this.defaultMenuBar.setCursor(c);
    }

    public void doOpenExportedAndUpdateLibrary(String path) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (path == null) {
            return;
        }
        this.loadedFiles.remove(path);
        TrackerIO.openFileFromDialog(new File(path), this, () -> {
            this.setCursor(Cursor.getDefaultCursor());
            this.libraryBrowser.open(path);
            this.libraryBrowser.setVisible(true);
            OSPRuntime.trigger(1000, e -> {
                LibraryTreePanel treePanel = this.libraryBrowser.getSelectedTreePanel();
                if (treePanel != null) {
                    treePanel.refreshSelectedNode();
                }
            });
        });
    }

    public void doOpenFileFromDialog() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        TrackerIO.openFileFromDialog(null, this, () -> this.setCursor(Cursor.getDefaultCursor()));
        if (!OSPRuntime.isJS) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void doOpenURL(String url) {
        TrackerPanel selected = this.getSelectedPanel();
        if (selected != null) {
            selected.setMouseCursor(Cursor.getPredefinedCursor(3));
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        TrackerIO.openURL(url, this, () -> {
            this.setCursor(Cursor.getDefaultCursor());
            TrackerPanel panel = this.getSelectedPanel();
            if (panel != null) {
                panel.setMouseCursor(Cursor.getDefaultCursor());
            }
        });
    }

    public void addTabFromLoader(TrackerPanel trackerPanel) {
        this.addTab(trackerPanel, 0, null);
        this.getSplitPane(trackerPanel, 0).setDividerLocation(0.57);
    }

    void loadVideo(String path, boolean asNewTab, LibraryBrowser libraryBrowser, final Runnable whenDone) {
        if (!VideoIO.checkMP4(path, libraryBrowser, this.getSelectedPanel())) {
            return;
        }
        ArrayList<String> stackPaths = ImageVideo.getStackPaths(path);
        int i = 0;
        while (i < stackPaths.size()) {
            if (ResourceLoader.download(stackPaths.get(i), null, false) == null) break;
            ++i;
        }
        final File localFile = ResourceLoader.download(path, null, false);
        Runnable importer = new Runnable(){

            @Override
            public void run() {
                TrackerIO.importVideo(XML.getAbsolutePath(localFile), TFrame.this.getSelectedPanel(), whenDone);
            }
        };
        if (asNewTab) {
            this.addTrackerPanel(false, importer);
        } else {
            importer.run();
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public void setFrameBlocker(boolean blocking, TrackerPanel panel) {
        this.getJMenuBar().setEnabled(!blocking);
        int n = this.state = blocking ? 2 : 0;
        if (blocking) {
            this.frameBlocker = new FrameBlocker();
            this.setContentPane(this.frameBlocker);
            this.revalidate();
            if (this.notesVisible()) {
                this.setNotesVisible(false);
                this.notes.wasVisible = true;
            }
            if ((panel = this.getSelectedPanel()) != null) {
                panel.onBlocked();
            }
        } else if (this.frameBlocker != null) {
            this.frameBlocker = null;
            this.setContentPane(this.frameContentPane);
            if (panel != null) {
                panel.onLoaded();
            }
            if (this.notesVisible()) {
                this.setNotesVisible(true);
                this.notes.wasVisible = false;
            }
        }
    }

    public void setNotesVisible(boolean b) {
        this.notes.setVisible(b);
    }

    @Override
    public void setJMenuBar(JMenuBar bar) {
        super.setJMenuBar(bar);
        bar.setEnabled(this.frameBlocker == null);
    }

    protected void checkLocale() {
        if (TrackerRes.locale != Locale.ENGLISH && TrackerRes.locale != Locale.US) {
            Locale loc;
            Locale[] locales = Tracker.getLocales();
            int i = 0;
            while (i < locales.length) {
                loc = locales[i];
                if (loc.equals(TrackerRes.locale)) {
                    this.setLanguage(loc.toString());
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < locales.length) {
                loc = locales[i];
                if (loc.getLanguage().equals(TrackerRes.locale.getLanguage())) {
                    this.setLanguage(loc.getLanguage());
                    return;
                }
                ++i;
            }
        }
    }

    protected void setLanguage(String language) {
        if (language.equals(this.currentLangugae)) {
            return;
        }
        this.currentLangugae = language;
        Locale[] locales = Tracker.getLocales();
        int i = 0;
        while (i < Tracker.incompleteLocales.length) {
            if (language.equals(Tracker.incompleteLocales[i][0].toString())) {
                Locale locale = (Locale)Tracker.incompleteLocales[i][0];
                String lang = OSPRuntime.getDisplayLanguage(locale);
                JOptionPane.showMessageDialog(this, "This translation has not been updated since " + Tracker.incompleteLocales[i][1] + ".\nIf you speak " + lang + " and would like to help translate" + "\nplease contact Douglas Brown at dobrown@cabrillo.edu.", "Incomplete Translation: " + lang, 2);
                break;
            }
            ++i;
        }
        i = 0;
        while (i < locales.length) {
            if (language.equals(locales[i].toString())) {
                TrackerRes.setLocale(locales[i]);
                return;
            }
            ++i;
        }
    }

    boolean notesVisible() {
        return this.notes != null && (this.notes.isVisible() || this.notes.wasVisible);
    }

    void updateNotesDialog(TrackerPanel panel) {
        if (panel != null && this.notesVisible()) {
            this.notes.updateDialog(panel);
        }
    }

    JDialog getNotesDialog() {
        return (this.notes == null ? (this.notes = new Notes()) : this.notes).getDialog();
    }

    void setNotesDialog(TrackerPanel trackerPanel, WindowListener infoListener) {
        this.getNotes().setDialog(trackerPanel, infoListener);
    }

    public void disposeOf(TrackerPanel trackerPanel) {
        if (this.prevPanelID == trackerPanel.getID()) {
            this.prevPanelID = null;
        }
    }

    public TViewChooser[] getViewChoosers(TrackerPanel trackerPanel) {
        Object[] objects = this.getObjects(trackerPanel);
        return objects == null ? new TViewChooser[4] : (TViewChooser[])objects[1];
    }

    public TViewChooser[] getViewChoosers(Integer panelID) {
        Object[] objects = this.getObjects(this.getTab(panelID));
        return objects == null ? new TViewChooser[4] : (TViewChooser[])objects[1];
    }

    public TViewChooser[] getVisibleChoosers(Integer panelID) {
        TViewChooser[] choosers = this.getViewChoosers(this.getTrackerPanelForID(panelID));
        TViewChooser[] ret = new TViewChooser[4];
        int i = 0;
        while (i < choosers.length) {
            ret[i] = this.isViewPaneVisible(i, panelID) ? choosers[i] : null;
            ++i;
        }
        return ret;
    }

    public void removeTabSynchronously(Integer panelID) {
        this.removeTabSynchronously(this.getTrackerPanelForID(panelID));
    }

    public void refreshMenus(TrackerPanel trackerPanel, String whereFrom) {
        TMenuBar menubar = this.getMenuBar(trackerPanel.getID(), false);
        if (menubar != null) {
            menubar.refresh(whereFrom);
        }
    }

    public Integer allocatePanel(TrackerPanel trackerPanel) {
        int i = this._bsPanelIDs.nextClearBit(0);
        if (i > 127) {
            System.err.println("MAX_PID EXCEEDED");
            throw new ArrayIndexOutOfBoundsException("Too many panels!");
        }
        this._bsPanelIDs.set(i);
        this._apanels[i] = trackerPanel;
        return i;
    }

    public void deallocatePanelID(Integer panelID) {
        int i = panelID;
        this._apanels[i] = null;
        this._bsPanelIDs.clear(i);
    }

    public void deallocate(OSPRuntime.Disposable obj) {
        OSPRuntime.Disposable.deallocate(obj);
    }

    public TrackerPanel getTrackerPanelForID(Integer panelID) {
        return panelID == null ? null : this._apanels[panelID];
    }

    public void startMemoryTimer() {
        this.memoryTimer = new Timer(15000, e -> {
            System.gc();
            TrackerPanel panel = this.getSelectedPanel();
            if (panel != null) {
                TToolBar.refreshMemoryButton(panel);
            }
        });
        this.memoryTimer.setRepeats(true);
        this.memoryTimer.start();
    }

    public static void main(String[] args) {
        Tracker.main(args);
    }

    public void sayFileNotFound(String path) {
        JOptionPane.showMessageDialog(this, String.valueOf(TrackerRes.getString("TFrame.Dialog.FileNotFound.Message")) + "\n" + MediaRes.getString("VideoIO.Dialog.Label.Path") + ": " + path, TrackerRes.getString("TFrame.Dialog.FileNotFound.Title"), 2);
    }

    @Override
    public boolean importData(Object data, Component component) {
        if (data instanceof List) {
            return TrackerIO.loadFiles(this, (List)data, component instanceof TrackerPanel ? (TrackerPanel)component : null);
        }
        if (data instanceof URL) {
            this.loadExperimentURL(data.toString());
            return true;
        }
        return false;
    }

    public class DataDropHandler
    extends TransferHandler {
        DataFlavor df = DataFlavor.plainTextFlavor;

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.getTransferable().isDataFlavorSupported(this.df);
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            try {
                TFrame.this.getSelectedPanel().importDataAsync((String)t.getTransferData(this.df), null, null);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    static class DeactivatingMenuBar
    extends JMenuBar {
        DeactivatingMenuBar() {
        }

        @Override
        public void setEnabled(boolean b) {
            super.setEnabled(b);
            Component[] c = this.getComponents();
            int i = 0;
            while (i < c.length) {
                c[i].setEnabled(b);
                ++i;
            }
        }
    }

    public class DefaultMenuBar
    extends DeactivatingMenuBar {
        DefaultMenuBar() {
            int keyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            JMenu fileMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.File"));
            this.add(fileMenu);
            JMenuItem newItem = new JMenuItem(TrackerRes.getString("TActions.Action.NewTab"));
            newItem.setAccelerator(KeyStroke.getKeyStroke(78, keyMask));
            newItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TFrame.this.addTrackerPanel(false, null);
                }
            });
            fileMenu.add(newItem);
            fileMenu.addSeparator();
            Icon icon = Tracker.getResourceIcon("open.gif", true);
            JMenu openMenu = new JMenu(TrackerRes.getString("TrackerIO.Dialog.Open.Title"));
            openMenu.setIcon(icon);
            fileMenu.add(openMenu);
            JMenuItem openItem = new JMenuItem(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.FileChooser")) + "...");
            openItem.setAccelerator(KeyStroke.getKeyStroke(79, keyMask));
            openItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TFrame.this.doOpenFileFromDialog();
                }
            });
            openMenu.add(openItem);
            icon = Tracker.getResourceIcon("open_catalog.gif", true);
            JMenuItem openBrowserItem = new JMenuItem(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.LibraryBrowser")) + "...");
            openBrowserItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TFrame.this.getLibraryBrowser().setVisible(true);
                }
            });
            openMenu.add(openBrowserItem);
            TFrame.this.recentMenu = new JMenu();
            if (!OSPRuntime.isJS) {
                fileMenu.add(TFrame.this.recentMenu);
            }
            fileMenu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    TFrame.this.checkMemTest();
                    TFrame.this.refreshOpenRecentMenu(TFrame.this.recentMenu);
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
            fileMenu.addSeparator();
            JMenuItem exitItem = new JMenuItem(TrackerRes.getString("TActions.Action.Exit"));
            exitItem.setAccelerator(KeyStroke.getKeyStroke(81, keyMask));
            exitItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Tracker.exit();
                }
            });
            fileMenu.add(exitItem);
            JMenu editMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.Edit"));
            this.add(editMenu);
            final JMenu languageMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.Language"));
            languageMenu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    TMenuBar.setLangMenu(languageMenu, TFrame.this);
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
            editMenu.add(languageMenu);
            JMenuItem prefsItem = new JMenuItem(TrackerRes.getString("TActions.Action.Config"));
            prefsItem.setAccelerator(KeyStroke.getKeyStroke(10, keyMask));
            prefsItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TFrame.this.showPrefsDialog();
                }
            });
            editMenu.addSeparator();
            editMenu.add(prefsItem);
            this.add(TMenuBar.getTrackerHelpMenu(null, null));
        }
    }

    private class FrameBlocker
    extends JPanel {
        private BufferedImage image;

        public FrameBlocker() {
            this.image = new BufferedImage(TFrame.this.frameContentPane.getWidth(), TFrame.this.frameContentPane.getHeight(), 5);
            Graphics g = this.image.getGraphics();
            TFrame.this.frameContentPane.paint(g);
            g.dispose();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(this.image, 0, 0, this);
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            TFrame frame = (TFrame)obj;
            String relativeTo = frame.tabsetFile != null ? XML.getDirectoryPath(XML.getAbsolutePath(frame.tabsetFile)) : XML.getUserDirectory();
            relativeTo = XML.forwardSlash(relativeTo);
            ArrayList<String[]> pathList = new ArrayList<String[]>();
            int i = 0;
            while (i < frame.getTabCount()) {
                TrackerPanel trackerPanel = frame.getTrackerPanelForTab(i);
                File file = trackerPanel.getDataFile();
                if (trackerPanel.openedFromPath != null) {
                    file = new File(trackerPanel.openedFromPath);
                }
                if (file != null) {
                    String path = XML.getAbsolutePath(file);
                    String relativePath = XML.getPathRelativeTo(path, relativeTo);
                    pathList.add(new String[]{path, relativePath});
                } else {
                    String path;
                    Video video2 = trackerPanel.getVideo();
                    if (!trackerPanel.changed && video2 != null && (path = (String)video2.getProperty("absolutePath")) != null) {
                        path = XML.forwardSlash(path);
                        String relativePath = XML.getPathRelativeTo(path, relativeTo);
                        pathList.add(new String[]{path, relativePath});
                    }
                }
                ++i;
            }
            String[][] paths = (String[][])pathList.toArray((T[])new String[0][0]);
            control.setValue("tabs", paths);
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            TFrame frame = (TFrame)obj;
            String[][] tabs = (String[][])control.getObject("tabs");
            if (tabs == null) {
                return this.loadObjectFinally(frame, null);
            }
            VideoFileFilter videoFilter = new VideoFileFilter();
            String base = control.getString("basepath");
            File dataFile = null;
            ArrayList<String> files = new ArrayList<String>();
            String[][] stringArray = tabs;
            int n = tabs.length;
            int n2 = 0;
            while (n2 < n) {
                block13: {
                    Resource res;
                    File file;
                    block11: {
                        String[] next;
                        block12: {
                            next = stringArray[n2];
                            file = null;
                            res = null;
                            if (base != null) {
                                file = new File(base, next[1]);
                                res = ResourceLoader.getResource(file.getPath());
                            }
                            if (res == null) {
                                file = new File(XML.getUserDirectory(), next[1]);
                                res = ResourceLoader.getResource(file.getPath());
                            }
                            if (res == null && next[0] != null) {
                                file = new File(next[0]);
                                res = ResourceLoader.getResource(file.getPath());
                            }
                            if (res != null) break block11;
                            if (!OSPRuntime.isJS) break block12;
                            JOptionPane.showMessageDialog(frame, "\"" + next[1] + "\" " + MediaRes.getString("VideoClip.Dialog.VideoNotFound.Message"));
                            break block13;
                        }
                        int i = JOptionPane.showConfirmDialog(frame, "\"" + next[1] + "\" " + MediaRes.getString("VideoClip.Dialog.VideoNotFound.Message"), TrackerRes.getString("TFrame.Dialog.FileNotFound.Title"), 0, 2);
                        if (i != 0) break block13;
                        TrackerIO.getChooser().setSelectedFile(file);
                        File[] a = TrackerIO.getChooserFiles("open");
                        if (a == null) break block13;
                        file = a[0];
                    }
                    if (res != null) {
                        if (!((FileFilter)videoFilter).accept(file) && dataFile == null) {
                            dataFile = file;
                        }
                        files.add(XML.getAbsolutePath(file));
                    }
                }
                ++n2;
            }
            File file0 = dataFile;
            if (frame.whenObjectLoadingComplete != null) {
                files.add(0, XML.getAbsolutePath(dataFile));
                frame.whenObjectLoadingComplete.apply(files);
                frame.whenObjectLoadingComplete = null;
                return frame;
            }
            TrackerIO.openFiles(frame, files, () -> this.loadObjectFinally(frame, file0));
            return frame;
        }

        protected TFrame loadObjectFinally(TFrame frame, File dataFile) {
            if (frame.whenObjectLoadingComplete != null) {
                frame.whenObjectLoadingComplete.apply(new ArrayList());
                frame.whenObjectLoadingComplete = null;
            }
            frame.setSelectedTab(dataFile);
            return frame;
        }
    }

    private class Notes {
        private JDialog dialog;
        private JTextPane textPane;
        private JButton cancelDialogButton;
        private JButton closeDialogButton;
        private JCheckBox displayWhenLoadedCheckbox;
        private int thisFontLevel;
        private Integer panelID;
        private boolean wasVisible;
        boolean needPosition = true;

        private Notes() {
            this.createNotesGUI();
        }

        private void dispose() {
            WindowListener[] a = this.dialog.getWindowListeners();
            int i = a.length;
            while (--i >= 0) {
                this.dialog.removeWindowListener(a[i]);
            }
            this.dialog.setVisible(false);
        }

        private void createNotesGUI() {
            this.dialog = new JDialog(TFrame.this, false){

                @Override
                public void setVisible(boolean vis) {
                    TToolBar tbar;
                    super.setVisible(vis);
                    TrackerPanel panel = TFrame.this.getSelectedPanel();
                    if (panel != null && (tbar = TFrame.this.getToolBar(panel.getID(), false)) != null) {
                        tbar.notesButton.setSelected(vis);
                    }
                }
            };
            this.textPane = new JTextPane();
            this.textPane.setBackground(Color.WHITE);
            this.textPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        String url = e.getURL().toString();
                        OSPDesktop.displayURL(url);
                    }
                }
            });
            this.textPane.setPreferredSize(new Dimension(420, 200));
            this.textPane.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    TrackerPanel trackerPanel = TFrame.this.getSelectedPanel();
                    if (!trackerPanel.isEnabled("notes.edit")) {
                        return;
                    }
                    Notes.this.textPane.setBackground(YELLOW);
                    Notes.this.closeDialogButton.setText(TrackerRes.getString("PrefsDialog.Button.Save"));
                    Notes.this.cancelDialogButton.setEnabled(true);
                }
            });
            this.textPane.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (e.getOppositeComponent() != Notes.this.cancelDialogButton) {
                        ((Notes)Notes.this).TFrame.this.saveNotesAction.actionPerformed(null);
                    }
                }
            });
            this.displayWhenLoadedCheckbox = new JCheckBox(TrackerRes.getString("TFrame.NotesDialog.Checkbox.ShowByDefault"));
            this.displayWhenLoadedCheckbox.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrackerPanel trackerPanel = TFrame.this.getSelectedPanel();
                    if (trackerPanel != null) {
                        trackerPanel.hideDescriptionWhenLoaded = !Notes.this.displayWhenLoadedCheckbox.isSelected();
                    }
                }
            });
            JPanel buttonbar = new JPanel(new FlowLayout());
            buttonbar.add(this.displayWhenLoadedCheckbox);
            buttonbar.add(Box.createHorizontalStrut(50));
            this.cancelDialogButton = new JButton(TrackerRes.getString("Dialog.Button.Cancel"));
            this.cancelDialogButton.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Notes.this.dialog.setName("canceled");
                    Notes.this.dialog.setVisible(false);
                }
            });
            buttonbar.add(this.cancelDialogButton);
            this.closeDialogButton = new JButton(TrackerRes.getString("Dialog.Button.Close"));
            this.closeDialogButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Notes.this.dialog.setVisible(false);
                }
            });
            buttonbar.add(this.closeDialogButton);
            JPanel infoContentPane = new JPanel(new BorderLayout());
            infoContentPane.add((Component)new JScrollPane(this.textPane), "Center");
            infoContentPane.add((Component)buttonbar, "South");
            this.dialog.setContentPane(infoContentPane);
            this.dialog.pack();
        }

        private void save() {
            if (this.textPane.getBackground() == Color.WHITE) {
                return;
            }
            String desc = this.textPane.getText();
            TrackerPanel trackerPanel = TFrame.this.getSelectedPanel();
            if (trackerPanel != null && this.dialog.getName() != "canceled") {
                trackerPanel.changed = true;
                TTrack track = trackerPanel.getTrack(this.dialog.getName());
                if (track != null && !desc.equals(track.getDescription())) {
                    track.setDescription(desc);
                } else if (!desc.equals(trackerPanel.getDescription())) {
                    trackerPanel.setDescription(desc);
                    trackerPanel.hideDescriptionWhenLoaded = !this.displayWhenLoadedCheckbox.isSelected();
                }
            }
            this.textPane.setBackground(Color.WHITE);
            this.cancelDialogButton.setEnabled(false);
            this.closeDialogButton.setEnabled(true);
            this.closeDialogButton.setText(TrackerRes.getString("Dialog.Button.Close"));
        }

        private void setVisible(boolean b) {
            if (b && this.needPosition) {
                this.needPosition = false;
                TrackerPanel trackerPanel = TFrame.this.getTrackerPanelForID(this.panelID);
                Point p0 = new JFrame().getLocation();
                if (trackerPanel.infoX != Integer.MIN_VALUE || this.dialog.getLocation().x == p0.x) {
                    int y;
                    int x;
                    Point p = TFrame.this.getLocationOnScreen();
                    if (trackerPanel.infoX != Integer.MIN_VALUE) {
                        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                        x = Math.max(p.x + trackerPanel.infoX, 0);
                        x = Math.min(x, dim.width - this.dialog.getWidth());
                        y = Math.max(p.y + trackerPanel.infoY, 0);
                        y = Math.min(y, dim.height - this.dialog.getHeight());
                        trackerPanel.infoX = Integer.MIN_VALUE;
                    } else {
                        TToolBar toolbar = TFrame.this.getToolBar(this.panelID, true);
                        Point pleft = toolbar.getLocationOnScreen();
                        Dimension dim = this.dialog.getSize();
                        Dimension wdim = toolbar.getSize();
                        x = pleft.x + (int)(0.5 * (double)(wdim.width - dim.width));
                        y = p.y + 16;
                    }
                    this.dialog.setLocation(x, y);
                }
                System.out.println("TFrame.notes " + this.dialog.isVisible());
            }
            this.dialog.setVisible(b);
        }

        private boolean isVisible() {
            return this.dialog.isVisible();
        }

        private void updateDialog(TrackerPanel panel) {
            this.textPane.setEditable(panel.isEnabled("notes.edit"));
            TFrame.this.saveNotesAction.actionPerformed(null);
            TTrack track = panel.selectedTrack;
            if (track != null) {
                this.textPane.setText(track.getDescription());
                this.dialog.setName(track.getName());
                this.dialog.setTitle(String.valueOf(TrackerRes.getString("TActions.Dialog.Description.Title")) + " \"" + track.getName() + "\"");
            } else {
                this.textPane.setText(panel.getDescription());
                this.dialog.setName(null);
                String tabName = TFrame.this.getTabTitle(TFrame.this.getSelectedTab());
                this.dialog.setTitle(String.valueOf(TrackerRes.getString("TActions.Dialog.Description.Title")) + " \"" + tabName + "\"");
            }
            this.textPane.setBackground(Color.WHITE);
            this.cancelDialogButton.setEnabled(false);
            this.closeDialogButton.setEnabled(true);
            panel = TFrame.this.getSelectedPanel();
            this.displayWhenLoadedCheckbox.setEnabled(panel != null);
            if (panel != null) {
                this.displayWhenLoadedCheckbox.setSelected(!panel.hideDescriptionWhenLoaded);
            }
            this.refreshTextAndFonts();
        }

        private JDialog getDialog() {
            this.refreshTextAndFonts();
            return this.dialog;
        }

        private void refreshTextAndFonts() {
            this.cancelDialogButton.setText(TrackerRes.getString("Dialog.Button.Cancel"));
            this.closeDialogButton.setText(TrackerRes.getString("Dialog.Button.Close"));
            this.displayWhenLoadedCheckbox.setText(TrackerRes.getString("TFrame.NotesDialog.Checkbox.ShowByDefault"));
            int level = FontSizer.getLevel();
            if (level != this.thisFontLevel) {
                this.thisFontLevel = level;
                FontSizer.setFonts(this.dialog, level);
                this.dialog.pack();
            }
        }

        private void setDialog(TrackerPanel panel, WindowListener infoListener) {
            this.panelID = panel.getID();
            this.dialog.removeWindowListener(infoListener);
            this.dialog.addWindowListener(infoListener);
            TrackerPanel trackerPanel = TFrame.this.getSelectedPanel();
            this.setVisible(true);
            TFrame.this.updateNotesDialog(trackerPanel);
        }
    }

    class TTabPanel
    extends JPanel
    implements OSPRuntime.Disposable {
        private Object[] objects;
        Integer panelID;
        Box toolbarBox;

        public TTabPanel(TrackerPanel trackerPanel, Object[] objects) {
            super(new BorderLayout());
            this.panelID = trackerPanel.getID();
            this.objects = objects;
        }

        public TrackerPanel getTrackerPanel() {
            return TFrame.this.getTrackerPanelForID(this.panelID);
        }

        public Object[] getObjects() {
            return this.objects;
        }

        public void setToolbarVisible(boolean vis) {
            if (this.toolbarBox == null) {
                int i = this.panelID;
                TToolBar bar = TFrame.this._atoolbars[i];
                if (bar == null) {
                    return;
                }
                this.toolbarBox = Box.createVerticalBox();
                this.toolbarBox.add(bar);
            }
            if (vis) {
                this.add((Component)this.toolbarBox, "North");
            } else {
                this.remove(this.toolbarBox);
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            if (!TFrame.this.isPaintable()) {
                return;
            }
            super.paintComponent(g);
        }

        @Override
        public void dispose() {
            this.panelID = null;
            this.objects = null;
            this.toolbarBox = null;
            this.removeAll();
        }

        public void finalize() {
            OSPLog.finalized(this);
        }
    }
}

