/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPanel;

public class TMat
implements Measurable,
Trackable,
PropertyChangeListener {
    private TFrame frame;
    private Integer panelID;
    private Rectangle mat;
    private Rectangle2D worldBounds;
    private Paint paint = Color.white;
    private boolean visible = true;
    private boolean isValidMeasure = false;
    private ImageCoordSystem coords;
    protected Rectangle2D drawnBounds;
    private AffineTransform trTM = new AffineTransform();
    private boolean haveVideo;

    public TMat(TrackerPanel panel) {
        this.mat = new Rectangle();
        this.setTrackerPanel(panel);
        this.refresh();
    }

    public void setTrackerPanel(TrackerPanel panel) {
        if (panel == null || this.panelID == panel.getID()) {
            return;
        }
        this.frame = panel.getTFrame();
        this.panelID = panel.getID();
        panel = this.frame.getTrackerPanelForID(this.panelID);
        panel.addPropertyChangeListener("coords", this);
        this.refreshCoords(panel);
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        if (!(panel instanceof VideoPanel) || !this.isVisible()) {
            return;
        }
        VideoPanel vidPanel = (VideoPanel)panel;
        Graphics2D g2 = (Graphics2D)g.create();
        g2.transform(vidPanel.getPixelTransform(this.trTM));
        if (!vidPanel.isDrawingInImageSpace()) {
            ImageCoordSystem coords = vidPanel.getCoords();
            int n = vidPanel.getFrameNumber();
            g2.transform(coords.getToWorldTransform(n));
        }
        g2.setPaint(this.paint);
        g2.fill(this.mat);
        this.drawnBounds = vidPanel.transformShape(this.mat).getBounds2D();
        g2.dispose();
    }

    protected Rectangle2D getDrawingBounds() {
        return this.drawnBounds;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public double getXMin() {
        if (!this.isValidMeasure) {
            this.getWorldBounds();
        }
        return this.worldBounds.getMinX();
    }

    @Override
    public double getXMax() {
        if (!this.isValidMeasure) {
            this.getWorldBounds();
        }
        return this.worldBounds.getMaxX();
    }

    @Override
    public double getYMin() {
        if (!this.isValidMeasure) {
            this.getWorldBounds();
        }
        return this.worldBounds.getMinY();
    }

    @Override
    public double getYMax() {
        if (!this.isValidMeasure) {
            this.getWorldBounds();
        }
        return this.worldBounds.getMaxY();
    }

    @Override
    public boolean isMeasured() {
        return this.isVisible();
    }

    public void refresh() {
        TrackerPanel panel = this.frame.getTrackerPanelForID(this.panelID);
        this.refreshCoords(panel);
        this.refreshMat(panel);
    }

    private void refreshCoords(TrackerPanel panel) {
        if (this.coords != null) {
            this.coords.removePropertyChangeListener("transform", this);
        }
        this.coords = panel.getCoords();
        this.coords.addPropertyChangeListener("transform", this);
    }

    private void refreshMat(TrackerPanel trackerPanel) {
        Rectangle mat0 = new Rectangle(this.mat);
        this.mat.width = (int)trackerPanel.getImageWidth();
        this.mat.height = (int)trackerPanel.getImageHeight();
        int w = (int)TrackerPanel.getDefaultImageWidth();
        int h = (int)TrackerPanel.getDefaultImageHeight();
        Video video2 = trackerPanel.getVideo();
        if (video2 != null) {
            boolean useRaw = video2 instanceof ImageVideo && video2.getFilterStack().isEmpty();
            Dimension d = video2.getImageSize(!useRaw);
            if (d.width > 0) {
                this.haveVideo = true;
                w = d.width;
                h = d.height;
            }
        }
        this.mat.x = Math.min((w - this.mat.width) / 2, 0);
        this.mat.y = Math.min((h - this.mat.height) / 2, 0);
        if (!mat0.equals(this.mat)) {
            this.invalidate();
            trackerPanel.scale();
        }
    }

    protected void checkVideo(TrackerPanel panel) {
        if (!this.haveVideo && panel.getVideo() != null) {
            this.refreshMat(panel);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "transform": {
                this.invalidate();
                break;
            }
            case "coords": {
                this.refresh();
            }
        }
    }

    public void cleanup() {
        if (this.frame != null) {
            this.frame.getTrackerPanelForID(this.panelID).removePropertyChangeListener("coords", this);
            this.coords.removePropertyChangeListener("transform", this);
            this.panelID = null;
            this.frame = null;
        }
    }

    private void getWorldBounds() {
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        ImageCoordSystem coords = trackerPanel.getCoords();
        VideoClip clip = trackerPanel.getPlayer().getVideoClip();
        int stepCount = clip.getStepCount();
        AffineTransform at = coords.getToWorldTransform(clip.stepToFrame(0));
        this.worldBounds = at.createTransformedShape(this.mat).getBounds2D();
        int n = 0;
        while (n < stepCount) {
            at = coords.getToWorldTransform(clip.stepToFrame(n));
            this.worldBounds.add(at.createTransformedShape(this.mat).getBounds2D());
            ++n;
        }
        this.isValidMeasure = true;
    }

    public void finalize() {
        OSPLog.finalized(this);
    }

    protected Rectangle getBounds() {
        return this.mat;
    }

    public void invalidate() {
        this.isValidMeasure = false;
    }
}

