/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.opensourcephysics.cabrillo.tracker.CoordAxes;
import org.opensourcephysics.cabrillo.tracker.ExportDataDialog;
import org.opensourcephysics.cabrillo.tracker.ExportVideoDialog;
import org.opensourcephysics.cabrillo.tracker.NumberFormatDialog;
import org.opensourcephysics.cabrillo.tracker.ParticleDataTrack;
import org.opensourcephysics.cabrillo.tracker.PerspectiveTrack;
import org.opensourcephysics.cabrillo.tracker.PlotTView;
import org.opensourcephysics.cabrillo.tracker.PlotTrackView;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.ReferenceFrame;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.TableTView;
import org.opensourcephysics.cabrillo.tracker.TableTrackView;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.ThumbnailDialog;
import org.opensourcephysics.cabrillo.tracker.TrackChooserTView;
import org.opensourcephysics.cabrillo.tracker.TrackControl;
import org.opensourcephysics.cabrillo.tracker.TrackPlottingPanel;
import org.opensourcephysics.cabrillo.tracker.TrackView;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.cabrillo.tracker.UnitsDialog;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.FilterStack;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.media.mov.SmoothPlayable;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionTool;

public class TMenuBar
extends TFrame.DeactivatingMenuBar
implements OSPRuntime.Disposable,
PropertyChangeListener,
MenuListener {
    static final String POPUPMENU_TTOOLBAR_TRACKS = "TToolBar.tracks";
    static final String POPUPMENU_TFRAME_BOTTOM = "TFrame.bottom";
    static final String POPUPMENU_TFRAME_RIGHT = "TFrame.right";
    static final String POPUPMENU_MAINTVIEW_POPUP = "MainTView.popup";
    static final String POPUPMENU_TRACKCONTROL_TRACKS = "TrackControl.tracks";
    protected static final int MENU_FILE = 1;
    protected static final int MENU_EDIT = 2;
    protected static final int MENU_VIDEO = 4;
    protected static final int MENU_COORDS = 8;
    protected static final int MENU_TRACK = 16;
    protected static final int MENU_VIEW = 32;
    protected static final int MENU_HELP = 64;
    protected static final int MENU_ALL = 127;
    private static final String[] panelProps = new String[]{"loaded", "locked", "track", "clear", "selectedtrack", "selectedpoint", "video", "size", "datafile"};
    private int status = 0;
    boolean refreshing;
    private boolean allowRefresh = true;
    private TFrame frame;
    private Map<String, AbstractAction> actions;
    private JMenu fileMenu;
    private JMenuItem file_newTabItem;
    private JMenuItem file_replaceTabItem;
    private JMenu file_openMenu;
    private JMenuItem file_openItem;
    private JMenuItem file_openBrowserItem;
    JMenu file_openRecentMenu;
    private JMenuItem file_reloadItem;
    private JMenuItem file_closeItem;
    private JMenuItem file_closeAllItem;
    private JMenu file_saveMenu;
    private JMenuItem file_saveItem;
    private JMenuItem file_saveTabAsItem;
    private JMenuItem file_saveProjectAsItem;
    private JMenuItem file_saveVideoAsItem;
    private JMenuItem file_saveTabsetAsItem;
    private JMenu file_importMenu;
    private JMenuItem file_import_videoItem;
    private JMenuItem file_import_TRKItem;
    private JMenuItem file_import_dataItem;
    private JMenu file_exportMenu;
    private JMenuItem file_export_zipItem;
    private JMenuItem file_export_videoItem;
    private JMenuItem file_export_thumbnailItem;
    private JMenuItem file_export_dataItem;
    private JMenuItem file_propertiesItem;
    private JMenuItem file_printFrameItem;
    private JMenuItem file_exitItem;
    private JMenu editMenu;
    private JMenuItem edit_undoItem;
    private JMenuItem edit_redoItem;
    private JMenu edit_copyDataMenu;
    private JMenu edit_copyImageMenu;
    private JMenuItem edit_copyMainViewImageItem;
    private JMenuItem edit_copyFrameImageItem;
    private JMenuItem[] edit_copyViewImageItems;
    private JMenu edit_copyObjectMenu;
    private JMenuItem edit_pasteItem;
    private JCheckBoxMenuItem edit_autopasteCheckbox;
    private JMenu edit_deleteTracksMenu;
    private JMenuItem edit_delTracks_deleteSelectedPointItem;
    private JMenuItem edit_clearTracksItem;
    private JMenu edit_numberMenu;
    private JMenuItem edit_formatsItem;
    private JMenuItem edit_unitsItem;
    private JMenuItem edit_configItem;
    private JMenu edit_matSizeMenu;
    private ButtonGroup matSizeGroup;
    private Action matSizeAction;
    private JMenu edit_fontSizeMenu;
    private JRadioButtonMenuItem edit_matsize_videoSizeItem;
    private JRadioButtonMenuItem edit_matsize_matSizeItem;
    private JMenu edit_languageMenu;
    private JMenu videoMenu;
    private JCheckBoxMenuItem video_videoVisibleItem;
    private JMenuItem video_goToItem;
    private JMenu video_filtersMenu;
    private JMenu video_filter_newFilterMenu;
    private JMenuItem video_pasteFilterItem;
    private JMenuItem video_clearFiltersItem;
    private JMenuItem video_openVideoItem;
    private JMenuItem video_closeVideoItem;
    private JMenuItem video_clipSettingsItem;
    private JMenu video_pasteImageMenu;
    private JMenuItem video_pasteImageItem;
    private JMenuItem video_pasteReplaceItem;
    private JMenuItem video_pasteImageAfterItem;
    private JMenuItem video_pasteImageBeforeItem;
    private JMenu video_importImageMenu;
    private JMenuItem addImageAfterItem;
    private JMenuItem addImageBeforeItem;
    private JMenuItem video_removeImageItem;
    private JMenuItem video_editVideoItem;
    private JMenuItem video_playAllStepsItem;
    private JMenuItem video_playXuggleSmoothlyItem;
    private JMenuItem video_aboutVideoItem;
    private JMenuItem video_checkDurationsItem;
    private JMenuItem video_emptyVideoItem;
    private JMenu trackMenu;
    private JMenu track_createMenu;
    private JMenu track_cloneMenu;
    private JMenu popupTracksMenu;
    private JMenu popupVideoFiltersMenu;
    private JMenu track_measuringToolsMenu;
    private Component[] videoFiltersMenuItems;
    private Component[] tracksMenuItems;
    private JMenuItem track_newPointMassItem;
    private JMenuItem track_newCMItem;
    private JMenuItem track_newVectorItem;
    private JMenuItem track_newVectorSumItem;
    private JMenuItem track_newLineProfileItem;
    private JMenuItem track_newRGBRegionItem;
    private JMenuItem track_newProtractorItem;
    private JMenuItem track_newTapeItem;
    private JMenuItem track_newCircleFitterItem;
    private JCheckBoxMenuItem track_axesVisibleItem;
    private JMenuItem track_newAnalyticParticleItem;
    private JMenu track_newDynamicParticleMenu;
    private JMenuItem track_newDynamicParticleCartesianItem;
    private JMenuItem track_newDynamicParticlePolarItem;
    private JMenuItem track_newDynamicSystemItem;
    private JMenu track_newDataTrackMenu;
    private JMenuItem track_newDataTrackPasteItem;
    private JMenuItem track_newDataTrackFromFileItem;
    private JMenuItem track_dataTrackHelpItem;
    private JMenuItem track_emptyTracksItem;
    private JMenu coordsMenu;
    private JCheckBoxMenuItem coords_lockedCoordsItem;
    private JCheckBoxMenuItem coords_fixedOriginItem;
    private JCheckBoxMenuItem coords_fixedAngleItem;
    private JCheckBoxMenuItem coords_fixedScaleItem;
    private JMenu coords_refFrameMenu;
    private ButtonGroup coords_refFrameGroup;
    private JRadioButtonMenuItem coords_defaultRefFrameItem;
    private JMenuItem coords_showUnitDialogItem;
    private JMenuItem coords_emptyCoordsItem;
    private JMenu viewMenu;
    private JMenuItem view_restoreItem;
    protected JCheckBoxMenuItem view_rightPaneItem;
    protected JCheckBoxMenuItem view_bottomPaneItem;
    private JMenuItem view_trackControlItem;
    private JMenuItem view_notesItem;
    private JMenuItem view_dataBuilderItem;
    private JMenuItem view_dataToolItem;
    private JMenuItem[] tabItems;
    private JMenu helpMenu;
    protected int enabledNewTrackCount = 0;
    private Integer panelID;
    static final String REFRESH_TFRAME_LOCALE = "TFrame.locale";
    static final String REFRESH_TFRAME_REFRESH = "TFrame.refresh";
    static final String REFRESH_PROPERTY_ = "property:?";
    static final String REFRESH_TRACKERIO_OPENFRAME = "TrackerIO.aferOpenFrame";
    static final String REFRESH_TRACKERIO_BEFORESETVIDEO = "TrackerIO.beforeSetVideo";
    static final String REFRESH_TRACKERIO_SAVE = "TrackerIO.save";
    static final String REFRESH_TRACKERIO_SAVETABSET = "TrackerIO.saveTabset";
    static final String REFRESH_TRACKERIO_SAVEVIDEO = "TrackerIO.saveVideoOK";
    static final String REFRESH_TPANEL_SETTRACKNAME = "TrackerPanel.setTrackName";
    static final String REFRESH_PREFS_CLEARRECENT = "PrefsDialog.clearRecent";
    static final String REFRESH_PREFS_APPLYPREFS = "PrefsDialog.applyPrefs";
    static final String REFRESH_TACTIONS_OPENVIDEO = "TActions.openVideo";
    static final String REFRESH_TFRAME_OPENRECENT = "TFrame.openRecent";
    static final String REFRESH_UNDO = "Undo.refreshMenus";
    private static boolean testing = false;
    static final String[] baseMatSizes = new String[]{"480x360", "640x480", "960x720", "1280x960", "1600x1200", "2400x1800"};

    private boolean isTainted(int id) {
        return (this.status & id) == id;
    }

    protected void setMenuTainted(int id, boolean taint) {
        this.status = taint ? (id == 127 ? 127 : (this.status |= id)) : (id == 127 ? 0 : (this.status &= ~id));
    }

    public void setAllowRefresh(boolean b) {
        this.allowRefresh = b;
    }

    TrackerPanel panel() {
        return this.frame.getTrackerPanelForID(this.panelID);
    }

    protected void loadVideoMenu(JMenu vidMenu) {
    }

    TMenuBar(TrackerPanel panel) {
        this.frame = panel.getTFrame();
        this.panelID = panel.getID();
        System.out.println("creating TMenuBar for " + panel);
        panel.addListeners(panelProps, this);
        this.actions = panel.getActions();
        this.createGUI();
        this.setMenuTainted(127, true);
    }

    @Override
    public void menuSelected(MenuEvent e) {
        switch (((JMenu)e.getSource()).getName()) {
            case "file": {
                this.refreshFileMenu(true);
                break;
            }
            case "edit": {
                this.refreshEditMenu(true);
                break;
            }
            case "edit_font": {
                this.rebuildEditFontSizeMenu();
                break;
            }
            case "edit_lang": {
                TMenuBar.setLangMenu(this.edit_languageMenu, this.frame);
                break;
            }
            case "edit_size": {
                this.rebuildEditMatSizeMenu();
                break;
            }
            case "edit_copyData": {
                this.rebuildEditCopyMenu("data");
                break;
            }
            case "edit_copyImage": {
                this.rebuildEditCopyMenu("image");
                break;
            }
            case "edit_copyObject": {
                this.rebuildEditCopyMenu("object");
                break;
            }
            case "video": {
                this.refreshVideoMenu(true);
                break;
            }
            case "coords": {
                this.refreshCoordsMenu(true);
                break;
            }
            case "tracks": {
                this.refreshTrackMenu(true, this.trackMenu.getPopupMenu());
                break;
            }
            case "window": {
                this.refreshViewMenu(true);
                break;
            }
            case "help": {
                this.refreshHelpMenu(true);
            }
        }
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    protected void refresh(String whereFrom) {
        if (!this.allowRefresh || this.frame != null && this.frame.hasPaintHold()) {
            return;
        }
        SwingUtilities.invokeLater(() -> this.refreshAll(whereFrom));
    }

    /*
     * Exception decompiling
     */
    protected void refreshAll(String whereFrom) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[0, 17] lbl89 : CaseStatement: default:\u000a, @NONE, blocks:[0, 17] lbl89 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.binarySort(TimSort.java:296)
         *     at java.base/java.util.TimSort.sort(TimSort.java:221)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void createGUI() {
        int keyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.createFileMenu(keyMask);
        this.createEditMenu(keyMask);
        this.createVideoMenu(keyMask);
        this.createTracksMenu(keyMask);
        this.createCoordsMenu(keyMask);
        this.createViewMenu(keyMask);
        this.helpMenu = TMenuBar.getTrackerHelpMenu(this.panel(), null);
        this.helpMenu.setName("help");
        this.add(this.helpMenu);
    }

    private void createFileMenu(int keyMask) {
        this.fileMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.File"));
        this.fileMenu.setName("file");
        this.fileMenu.addMenuListener(this);
        if (testing) {
            this.file_replaceTabItem = new JMenuItem("Replace Tab");
            this.file_replaceTabItem.addActionListener(e -> this.frame.loadExperimentURL(null));
        }
        this.file_newTabItem = new JMenuItem(TrackerRes.getString("TActions.Action.NewTab"));
        this.file_newTabItem.addActionListener(this.actions.get("newTab"));
        this.file_newTabItem.setAccelerator(KeyStroke.getKeyStroke(78, keyMask));
        this.file_openMenu = new JMenu(TrackerRes.getString("TrackerIO.Dialog.Open.Title"));
        this.file_openItem = new JMenuItem(this.actions.get("open"));
        this.file_openItem.setAccelerator(KeyStroke.getKeyStroke(79, keyMask));
        this.file_openItem.setText(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.FileChooser")) + "...");
        this.file_openMenu.setIcon(this.file_openItem.getIcon());
        this.file_openItem.setIcon(null);
        this.file_openBrowserItem = new JMenuItem(this.actions.get("openBrowser"));
        this.file_openBrowserItem.setText(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.LibraryBrowser")) + "...");
        this.file_openBrowserItem.setIcon(null);
        this.file_openRecentMenu = new JMenu();
        this.file_importMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.Import"));
        this.file_import_videoItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Video"));
        this.file_import_videoItem.addActionListener(this.actions.get("openVideo"));
        this.file_import_videoItem.setAccelerator(KeyStroke.getKeyStroke(73, keyMask));
        this.file_import_TRKItem = new JMenuItem(this.actions.get("import"));
        this.file_import_dataItem = new JMenuItem(this.actions.get("importData"));
        this.file_importMenu.add(this.file_import_videoItem);
        this.file_importMenu.add(this.file_import_TRKItem);
        this.file_importMenu.add(this.file_import_dataItem);
        this.file_reloadItem = new JMenuItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TMenuBar.this.panel().reload();
            }
        });
        this.file_reloadItem.setAccelerator(KeyStroke.getKeyStroke(82, keyMask));
        this.file_closeItem = new JMenuItem(this.actions.get("close"));
        this.file_closeAllItem = new JMenuItem(TrackerRes.getString("TActions.Action.CloseAll"));
        this.file_closeAllItem.addActionListener(this.actions.get("closeAll"));
        this.file_exportMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.Export"));
        this.file_export_zipItem = new JMenuItem(this.actions.get("saveZip"));
        this.file_export_zipItem.setText(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.ExportZIP")) + "...");
        this.file_export_videoItem = new JMenuItem(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.VideoClip")) + "...");
        this.file_export_videoItem.addActionListener(e -> {
            ExportVideoDialog exporter = ExportVideoDialog.getVideoDialog(this.panel());
            exporter.setVisible(true);
        });
        this.file_exportMenu.add(this.file_export_videoItem);
        new JMenuItem(this.actions.get("export"));
        this.file_export_thumbnailItem = new JMenuItem(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.Thumbnail")) + "...");
        this.file_export_thumbnailItem.addActionListener(e -> ThumbnailDialog.getDialog(this.panel(), true).setVisible(true));
        this.file_exportMenu.add(this.file_export_thumbnailItem);
        this.file_export_dataItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Data"));
        this.file_export_dataItem.addActionListener(e -> {
            ExportDataDialog exporter = ExportDataDialog.getDialog(this.panel());
            exporter.setVisible(true);
        });
        this.file_exportMenu.add(this.file_export_dataItem);
        this.file_saveMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.Save"));
        this.file_saveItem = new JMenuItem(this.actions.get("save"));
        this.file_saveItem.setAccelerator(KeyStroke.getKeyStroke(83, keyMask));
        File file = this.panel().getDataFile();
        String path = file == null ? "..." : " \"" + file.getName() + "\"";
        this.file_saveItem.setText(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.Tab")) + path);
        this.file_saveMenu.setIcon(this.file_saveItem.getIcon());
        this.file_saveItem.setIcon(null);
        this.file_saveTabAsItem = new JMenuItem(TrackerRes.getString("TActions.Action.SaveAs"));
        this.file_saveTabAsItem.addActionListener(this.actions.get("saveAs"));
        this.file_saveProjectAsItem = new JMenuItem(this.actions.get("saveZip"));
        this.file_saveProjectAsItem.setText(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.Project")) + "...");
        this.file_saveProjectAsItem.setIcon(null);
        this.file_saveVideoAsItem = new JMenuItem(this.actions.get("saveVideo"));
        this.file_saveVideoAsItem.setText(TrackerRes.getString("TActions.Action.SaveVideoAs"));
        this.file_saveTabsetAsItem = new JMenuItem(this.actions.get("saveTabsetAs"));
        this.file_saveTabsetAsItem.setText(TrackerRes.getString("TActions.Action.SaveFrame"));
        this.file_propertiesItem = new JMenuItem(this.actions.get("properties"));
        this.file_propertiesItem.setText(TrackerRes.getString("TActions.Action.Properties"));
        this.file_printFrameItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.PrintFrame"));
        this.file_printFrameItem.setAccelerator(KeyStroke.getKeyStroke(80, keyMask));
        this.file_printFrameItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TFrame c = TMenuBar.this.panel().getTFrame();
                new TrackerIO.ComponentImage(c).print();
            }
        });
        this.file_exitItem = new JMenuItem(this.actions.get("exit"));
        this.file_exitItem.setAccelerator(KeyStroke.getKeyStroke(81, keyMask));
        this.refreshFileMenu(false);
        this.add(this.fileMenu);
    }

    private void createEditMenu(int keyMask) {
        this.editMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.Edit"));
        this.editMenu.setName("edit");
        this.editMenu.addMenuListener(this);
        this.edit_undoItem = new JMenuItem();
        this.edit_undoItem.setAccelerator(KeyStroke.getKeyStroke(90, keyMask));
        this.edit_undoItem.addActionListener(e -> {
            this.panel().setSelectedPoint(null);
            this.panel().selectedSteps.clear();
            if (Undo.canUndo(this.panel())) {
                Undo.undo(this.panel());
            }
        });
        this.edit_redoItem = new JMenuItem();
        this.edit_redoItem.setAccelerator(KeyStroke.getKeyStroke(89, keyMask));
        this.edit_redoItem.addActionListener(e -> {
            if (Undo.canRedo(this.panel())) {
                Undo.redo(this.panel());
            }
            this.panel().setSelectedPoint(null);
            this.panel().selectedSteps.clear();
        });
        this.edit_pasteItem = this.editMenu.add(this.actions.get("paste"));
        if (!OSPRuntime.isJS) {
            this.edit_pasteItem.setAccelerator(KeyStroke.getKeyStroke(86, keyMask));
        }
        this.editMenu.addSeparator();
        this.edit_autopasteCheckbox = new JCheckBoxMenuItem(TrackerRes.getString("TMenuBar.Checkbox.Autopaste"));
        this.edit_autopasteCheckbox.addActionListener(e -> this.frame.setAlwaysListenToClipboard(this.edit_autopasteCheckbox.isSelected()));
        this.edit_copyDataMenu = new JMenu();
        this.edit_copyDataMenu.setName("edit_copyData");
        this.edit_copyDataMenu.addMenuListener(this);
        this.edit_copyImageMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.CopyImage"));
        this.edit_copyImageMenu.setName("edit_copyImage");
        this.edit_copyImageMenu.addMenuListener(this);
        this.edit_copyObjectMenu = new JMenu();
        this.edit_copyObjectMenu.setName("edit_copyObject");
        this.edit_copyObjectMenu.addMenuListener(this);
        this.edit_delTracks_deleteSelectedPointItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.DeleteSelectedPoint"));
        this.edit_delTracks_deleteSelectedPointItem.addActionListener(e -> this.panel().deletePoint(this.panel().getSelectedPoint()));
        this.edit_deleteTracksMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.DeleteTrack"));
        this.editMenu.add(this.edit_deleteTracksMenu);
        this.editMenu.addSeparator();
        this.edit_clearTracksItem = this.edit_deleteTracksMenu.add(this.actions.get("clearTracks"));
        this.edit_configItem = this.editMenu.add(this.actions.get("config"));
        this.edit_configItem.setAccelerator(KeyStroke.getKeyStroke(10, keyMask));
        this.edit_numberMenu = new JMenu(TrackerRes.getString("Popup.Menu.Numbers"));
        this.edit_formatsItem = new JMenuItem(String.valueOf(TrackerRes.getString("Popup.MenuItem.Formats")) + "...");
        this.edit_formatsItem.addActionListener(e -> NumberFormatDialog.getNumberFormatDialog(this.panel(), this.panel().getSelectedTrack(), null).setVisible(true));
        this.edit_unitsItem = new JMenuItem(String.valueOf(TrackerRes.getString("Popup.MenuItem.Units")) + "...");
        this.edit_unitsItem.addActionListener(e -> {
            UnitsDialog dialog = this.panel().getUnitsDialog();
            dialog.setVisible(true);
        });
        this.edit_matSizeMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.MatSize"));
        this.edit_matSizeMenu.setName("edit_size");
        this.edit_matSizeMenu.addMenuListener(this);
        this.edit_fontSizeMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.FontSize"));
        this.edit_fontSizeMenu.setName("edit_font");
        this.edit_fontSizeMenu.addMenuListener(this);
        this.edit_languageMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.Language"));
        this.edit_languageMenu.setName("edit_lang");
        this.edit_languageMenu.addMenuListener(this);
        this.editMenu.add(this.edit_languageMenu);
        this.add(this.editMenu);
    }

    private void createCoordsMenu(int keyMask) {
        this.coordsMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.Coords"));
        this.coordsMenu.setName("coords");
        this.coordsMenu.addMenuListener(this);
        this.coords_showUnitDialogItem = new JMenuItem(String.valueOf(TrackerRes.getString("Popup.MenuItem.Units")) + "...");
        this.coordsMenu.add(this.coords_showUnitDialogItem);
        this.coordsMenu.addSeparator();
        this.coords_showUnitDialogItem.addActionListener(e -> {
            UnitsDialog dialog = this.panel().getUnitsDialog();
            dialog.setVisible(true);
        });
        this.coords_lockedCoordsItem = new JCheckBoxMenuItem(TrackerRes.getString("TMenuBar.MenuItem.CoordsLocked"));
        this.coordsMenu.add(this.coords_lockedCoordsItem);
        this.coords_lockedCoordsItem.addItemListener(e -> {
            ImageCoordSystem coords = this.panel().getCoords();
            coords.setLocked(this.coords_lockedCoordsItem.isSelected());
        });
        this.coordsMenu.addSeparator();
        this.coords_fixedOriginItem = new JCheckBoxMenuItem(TrackerRes.getString("TMenuBar.MenuItem.CoordsFixedOrigin"));
        this.coords_fixedOriginItem.setSelected(true);
        this.coordsMenu.add(this.coords_fixedOriginItem);
        this.coords_fixedOriginItem.addItemListener(e -> {
            int n = this.panel().getFrameNumber();
            ImageCoordSystem coords = this.panel().getCoords();
            XMLControlElement currentState = new XMLControlElement(this.panel().getCoords());
            coords.setFixedOrigin(this.coords_fixedOriginItem.isSelected(), n);
            if (!this.refreshing) {
                Undo.postCoordsEdit(this.panel(), currentState);
            }
        });
        this.coords_fixedAngleItem = new JCheckBoxMenuItem(TrackerRes.getString("TMenuBar.MenuItem.CoordsFixedAngle"));
        this.coords_fixedAngleItem.setSelected(true);
        this.coordsMenu.add(this.coords_fixedAngleItem);
        this.coords_fixedAngleItem.addItemListener(e -> {
            int n = this.panel().getFrameNumber();
            ImageCoordSystem coords = this.panel().getCoords();
            XMLControlElement currentState = new XMLControlElement(this.panel().getCoords());
            coords.setFixedAngle(this.coords_fixedAngleItem.isSelected(), n);
            if (!this.refreshing) {
                Undo.postCoordsEdit(this.panel(), currentState);
            }
        });
        this.coords_fixedScaleItem = new JCheckBoxMenuItem(TrackerRes.getString("TMenuBar.MenuItem.CoordsFixedScale"));
        this.coords_fixedScaleItem.setSelected(true);
        this.coordsMenu.add(this.coords_fixedScaleItem);
        this.coords_fixedScaleItem.addItemListener(e -> {
            int n = this.panel().getFrameNumber();
            ImageCoordSystem coords = this.panel().getCoords();
            XMLControlElement currentState = new XMLControlElement(this.panel().getCoords());
            coords.setFixedScale(this.coords_fixedScaleItem.isSelected(), n);
            if (!this.refreshing) {
                Undo.postCoordsEdit(this.panel(), currentState);
            }
        });
        this.coordsMenu.addSeparator();
        this.coordsMenu.addSeparator();
        this.coords_refFrameMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.CoordsRefFrame"));
        this.coordsMenu.add(this.coords_refFrameMenu);
        this.coords_refFrameGroup = new ButtonGroup();
        this.coords_defaultRefFrameItem = new JRadioButtonMenuItem(TrackerRes.getString("TMenuBar.MenuItem.CoordsDefault"), true);
        this.coords_defaultRefFrameItem.addActionListener(this.actions.get("refFrame"));
        this.coords_emptyCoordsItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Empty"));
        this.coords_emptyCoordsItem.setEnabled(false);
        this.add(this.coordsMenu);
    }

    private void createVideoMenu(int keyMask) {
        this.videoMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.Video"));
        this.videoMenu.setName("video");
        this.videoMenu.addMenuListener(this);
        this.video_pasteImageMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.PasteImage"));
        AbstractAction pasteImageAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Image image = TrackerIO.getClipboardImage();
                if (image != null) {
                    ImageVideo video2 = new ImageVideo(image);
                    TMenuBar.this.panel().setVideo(video2);
                    int n = TMenuBar.this.panel().getPlayer().getVideoClip().getStepCount();
                    TMenuBar.this.panel().getPlayer().getVideoClip().setStepCount(n);
                }
            }
        };
        this.video_pasteImageItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.PasteImage"));
        this.video_pasteImageItem.addActionListener(pasteImageAction);
        this.video_editVideoItem = new JCheckBoxMenuItem(new AbstractAction(TrackerRes.getString("TMenuBar.MenuItem.EditVideoFrames")){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                Video video2 = TMenuBar.this.panel().getVideo();
                if (video2 == null || !(video2 instanceof ImageVideo)) return;
                boolean edit = TMenuBar.this.video_editVideoItem.isSelected();
                ImageVideo iVideo = (ImageVideo)video2;
                if (!edit) {
                    try {
                        int n = TMenuBar.this.panel().getFrameNumber();
                        iVideo.setEditable(false);
                        iVideo.setFrameNumber(n);
                        TMenuBar.this.refresh("menuItem.editVideoFrames !edit");
                        TToolBar.refreshMemoryButton(TMenuBar.this.panel());
                        return;
                    }
                    catch (Exception e1) {
                        Toolkit.getDefaultToolkit().beep();
                        OSPLog.finer("exception occurred: " + e1);
                    }
                    return;
                }
                BufferedImage image = iVideo.getImage();
                DataBuffer buff = image.getRaster().getDataBuffer();
                long bytes = buff.getSize() * DataBuffer.getDataTypeSize(buff.getDataType()) / 8;
                bytes = bytes * (long)iVideo.getFrameCount() / 0x100000L;
                long[] memory = OSPRuntime.getMemory();
                long availableMemory = memory[1] - memory[0];
                int response = 0;
                if (bytes > availableMemory) {
                    String mem = " (" + bytes + "MB needed, ";
                    String message = String.valueOf(TrackerRes.getString("TMenuBar.Dialog.RequiresMemory.Message1")) + mem + availableMemory + "MB available)";
                    message = String.valueOf(message) + "\n" + TrackerRes.getString("TMenuBar.Dialog.RequiresMemory.Message2");
                    response = JOptionPane.showConfirmDialog(TMenuBar.this.frame, message, TrackerRes.getString("TMenuBar.Dialog.RequiresMemory.Title"), 2, 1);
                }
                if (response == 0) {
                    boolean error = false;
                    try {
                        try {
                            int n = TMenuBar.this.panel().getFrameNumber();
                            iVideo.setEditable(true);
                            iVideo.setFrameNumber(n);
                            TMenuBar.this.refresh("memory_issue");
                            TToolBar.refreshMemoryButton(TMenuBar.this.panel());
                            return;
                        }
                        catch (Exception ex) {
                            Toolkit.getDefaultToolkit().beep();
                            error = true;
                            OSPLog.finer("exception occurred: " + ex);
                            if (!error) return;
                            try {
                                int n = TMenuBar.this.panel().getFrameNumber();
                                iVideo.setEditable(false);
                                iVideo.setFrameNumber(n);
                            }
                            catch (Exception n) {
                            }
                            catch (Error n) {
                                // empty catch block
                            }
                            System.gc();
                            TMenuBar.this.refresh("memory error");
                            TToolBar.refreshMemoryButton(TMenuBar.this.panel());
                            return;
                        }
                        catch (Error er) {
                            Toolkit.getDefaultToolkit().beep();
                            error = true;
                            OSPLog.finer("error occurred: " + er);
                            throw er;
                        }
                    }
                    finally {
                        if (error) {
                            try {
                                int n = TMenuBar.this.panel().getFrameNumber();
                                iVideo.setEditable(false);
                                iVideo.setFrameNumber(n);
                            }
                            catch (Exception exception) {
                            }
                            catch (Error error2) {}
                            System.gc();
                            TMenuBar.this.refresh("memory error");
                            TToolBar.refreshMemoryButton(TMenuBar.this.panel());
                        }
                    }
                }
                TMenuBar.this.video_editVideoItem.setSelected(false);
            }
        });
        this.video_pasteReplaceItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.PasteReplace"));
        this.video_pasteReplaceItem.addActionListener(pasteImageAction);
        this.video_pasteImageAfterItem = new JMenuItem(new AbstractAction(TrackerRes.getString("TMenuBar.MenuItem.PasteAfter")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Image image = TrackerIO.getClipboardImage();
                if (image != null) {
                    int n = TMenuBar.this.panel().getFrameNumber();
                    ImageVideo imageVid = (ImageVideo)TMenuBar.this.panel().getVideo();
                    imageVid.insert(image, n + 1);
                    VideoClip clip = TMenuBar.this.panel().getPlayer().getVideoClip();
                    clip.setStepCount(imageVid.getFrameCount());
                    TMenuBar.this.panel().getPlayer().setStepNumber(clip.frameToStep(n + 1));
                    TMenuBar.this.refresh("menuItem.pageInsertAfter");
                    TMenuBar.this.checkMatSize();
                }
            }
        });
        this.video_pasteImageBeforeItem = new JMenuItem(new AbstractAction(TrackerRes.getString("TMenuBar.MenuItem.PasteBefore")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Image image = TrackerIO.getClipboardImage();
                if (image != null) {
                    int n = TMenuBar.this.panel().getFrameNumber();
                    ImageVideo imageVid = (ImageVideo)TMenuBar.this.panel().getVideo();
                    imageVid.insert(image, n);
                    VideoClip clip = TMenuBar.this.panel().getPlayer().getVideoClip();
                    clip.setStepCount(imageVid.getFrameCount());
                    TMenuBar.this.panel().getPlayer().setStepNumber(clip.frameToStep(n));
                    TMenuBar.this.refresh("menuItem.pastImageBefore");
                    TMenuBar.this.checkMatSize();
                }
            }
        });
        this.video_pasteImageMenu.add(this.video_pasteReplaceItem);
        this.video_openVideoItem = this.videoMenu.add(this.actions.get("openVideo"));
        this.video_closeVideoItem = this.videoMenu.add(this.actions.get("closeVideo"));
        this.video_clipSettingsItem = new JMenuItem(String.valueOf(MediaRes.getString("ClipInspector.Title")) + "...");
        this.video_clipSettingsItem.addActionListener(e -> this.panel().setClipSettingsVisible(true));
        this.video_goToItem = new JMenuItem(String.valueOf(MediaRes.getString("VideoPlayer.Readout.Menu.GoTo")) + "...");
        this.video_goToItem.setAccelerator(KeyStroke.getKeyStroke(71, keyMask));
        this.video_goToItem.addActionListener(e -> {
            VideoPlayer player = this.panel().getPlayer();
            player.showGoToDialog();
        });
        this.video_importImageMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.AddImage"));
        this.addImageAfterItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.AddAfter"));
        this.addImageAfterItem.addActionListener(e -> {
            TrackerIO.insertImagesIntoVideo(this.panel(), this.panel().getFrameNumber() + 1);
            this.checkMatSize();
        });
        this.addImageBeforeItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.AddBefore"));
        this.addImageBeforeItem.addActionListener(e -> {
            TrackerIO.insertImagesIntoVideo(this.panel(), this.panel().getFrameNumber());
            this.checkMatSize();
        });
        this.video_importImageMenu.add(this.addImageBeforeItem);
        this.video_importImageMenu.add(this.addImageAfterItem);
        this.video_removeImageItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.RemoveImage"));
        this.video_removeImageItem.setAccelerator(KeyStroke.getKeyStroke(82, keyMask));
        this.video_removeImageItem.addActionListener(e -> {
            ImageVideo imageVid = (ImageVideo)this.panel().getVideo();
            int n = this.panel().getFrameNumber();
            String path = imageVid.remove(n);
            int len = imageVid.getFrameCount();
            VideoClip clip = this.panel().getPlayer().getVideoClip();
            clip.setStepCount(len);
            int step = Math.min(n, len - 1);
            step = clip.frameToStep(step);
            this.panel().getPlayer().setStepNumber(step);
            if (path != null && !path.equals("")) {
                Undo.postImageVideoEdit(this.panel(), new String[]{path}, n, step, false);
            }
            this.refresh("menuItem.removeImage");
        });
        this.video_playAllStepsItem = new JCheckBoxMenuItem(TrackerRes.getString("TMenuBar.MenuItem.PlayAllSteps"), true);
        VideoClip clip = this.panel().getPlayer().getVideoClip();
        this.video_playAllStepsItem.setSelected(clip.isPlayAllSteps());
        this.video_playAllStepsItem.addActionListener(e -> {
            VideoPlayer player = this.panel().getPlayer();
            VideoClip c = player.getVideoClip();
            c.setPlayAllSteps(this.video_playAllStepsItem.isSelected());
            player.setVideoClip(c);
        });
        this.video_videoVisibleItem = new JCheckBoxMenuItem(TrackerRes.getString("TMenuBar.MenuItem.VideoVisible"));
        this.video_videoVisibleItem.setSelected(true);
        this.video_videoVisibleItem.addItemListener(e -> {
            Video video2 = this.panel().getVideo();
            if (e.getStateChange() != 1 && e.getStateChange() != 2 || video2 == null) {
                return;
            }
            boolean visible = this.video_videoVisibleItem.isSelected();
            this.panel().setVideoVisible(visible);
        });
        this.video_playXuggleSmoothlyItem = new JCheckBoxMenuItem(TrackerRes.getString("XuggleVideo.MenuItem.SmoothPlay"));
        this.video_playXuggleSmoothlyItem.addItemListener(e -> {
            Video video2 = this.panel().getVideo();
            if (video2 instanceof SmoothPlayable && (e.getStateChange() == 1 || e.getStateChange() == 2)) {
                ((SmoothPlayable)((Object)video2)).setSmoothPlay(this.video_playXuggleSmoothlyItem.isSelected());
            }
        });
        this.video_checkDurationsItem = new JMenuItem(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.CheckFrameDurations")) + "...");
        this.video_checkDurationsItem.addActionListener(e -> TrackerIO.findBadVideoFrames(this.panel(), TrackerIO.defaultBadFrameTolerance, true, false, false));
        this.video_aboutVideoItem = this.videoMenu.add(this.actions.get("aboutVideo"));
        this.video_filtersMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.VideoFilters"));
        this.popupVideoFiltersMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.VideoFilters"));
        this.video_filter_newFilterMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.NewVideoFilter"));
        this.video_filtersMenu.add(this.video_filter_newFilterMenu);
        this.video_filtersMenu.addSeparator();
        this.video_pasteFilterItem = new JMenuItem(TrackerRes.getString("TActions.Action.Paste"));
        this.video_pasteFilterItem.addActionListener(e -> OSPRuntime.paste(s -> {
            if (s != null) {
                Filter filter = (Filter)new XMLControlElement((String)s).loadObject(null);
                this.panel().getVideo().getFilterStack().addFilter(filter);
                filter.setVideoPanel(this.panel());
            }
        }));
        this.video_clearFiltersItem = this.video_filtersMenu.add(this.actions.get("clearFilters"));
        this.video_emptyVideoItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Empty"));
        this.video_emptyVideoItem.setEnabled(false);
        this.add(this.videoMenu);
    }

    private void createTracksMenu(int keyMask) {
        this.trackMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.Tracks"));
        this.popupTracksMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.Tracks"));
        this.trackMenu.setName("tracks");
        this.trackMenu.addMenuListener(this);
        this.trackMenu.addSeparator();
        this.track_axesVisibleItem = new JCheckBoxMenuItem(this.actions.get("axesVisible"));
        this.track_newAnalyticParticleItem = new JMenuItem(TrackerRes.getString("AnalyticParticle.Name"));
        this.track_newAnalyticParticleItem.addActionListener(this.actions.get("analyticParticle"));
        this.track_newDynamicParticleMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.DynamicParticle"));
        this.track_newDynamicParticleCartesianItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Cartesian"));
        this.track_newDynamicParticleCartesianItem.addActionListener(this.actions.get("dynamicParticle"));
        this.track_newDynamicParticlePolarItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Polar"));
        this.track_newDynamicParticlePolarItem.addActionListener(this.actions.get("dynamicParticlePolar"));
        this.track_newDynamicSystemItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.TwoBody"));
        this.track_newDynamicSystemItem.addActionListener(this.actions.get("dynamicSystem"));
        this.track_newDataTrackMenu = new JMenu(TrackerRes.getString("ParticleDataTrack.Name"));
        this.track_newDataTrackFromFileItem = new JMenuItem(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.DataFile")) + "...");
        this.track_newDataTrackFromFileItem.addActionListener(this.actions.get("dataTrack"));
        this.track_newDataTrackPasteItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Clipboard"));
        this.track_newDataTrackPasteItem.addActionListener(this.actions.get("paste"));
        this.track_dataTrackHelpItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.DataTrackHelp"));
        this.track_dataTrackHelpItem.addActionListener(e -> this.frame.showHelp("datatrack", 0));
        this.track_createMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.NewTrack"));
        this.track_newPointMassItem = new JMenuItem(TrackerRes.getString("PointMass.Name"));
        this.track_newPointMassItem.addActionListener(this.actions.get("pointMass"));
        this.track_newCMItem = new JMenuItem(TrackerRes.getString("CenterOfMass.Name"));
        this.track_newCMItem.addActionListener(this.actions.get("cm"));
        this.track_newVectorItem = new JMenuItem(TrackerRes.getString("Vector.Name"));
        this.track_newVectorItem.addActionListener(this.actions.get("vector"));
        this.track_newVectorSumItem = new JMenuItem(TrackerRes.getString("VectorSum.Name"));
        this.track_newVectorSumItem.addActionListener(this.actions.get("vectorSum"));
        this.track_newLineProfileItem = new JMenuItem(TrackerRes.getString("LineProfile.Name"));
        this.track_newLineProfileItem.addActionListener(this.actions.get("lineProfile"));
        this.track_newRGBRegionItem = new JMenuItem(TrackerRes.getString("RGBRegion.Name"));
        this.track_newRGBRegionItem.addActionListener(this.actions.get("rgbRegion"));
        this.track_newProtractorItem = new JMenuItem(TrackerRes.getString("Protractor.Name"));
        this.track_newProtractorItem.addActionListener(this.actions.get("protractor"));
        this.track_newTapeItem = new JMenuItem(TrackerRes.getString("TapeMeasure.Name"));
        this.track_newTapeItem.addActionListener(this.actions.get("tape"));
        this.track_newCircleFitterItem = new JMenuItem(TrackerRes.getString("CircleFitter.Name"));
        this.track_newCircleFitterItem.addActionListener(this.actions.get("circleFitter"));
        this.track_cloneMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.Clone"));
        this.track_measuringToolsMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.MeasuringTools"));
        this.track_emptyTracksItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Empty"));
        this.track_emptyTracksItem.setEnabled(false);
        this.add(this.trackMenu);
    }

    private void createViewMenu(int keyMask) {
        this.viewMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.Window"));
        this.viewMenu.setName("window");
        this.viewMenu.addMenuListener(this);
        this.view_restoreItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Restore"));
        this.view_restoreItem.addActionListener(e -> this.panel().restoreViews());
        this.view_rightPaneItem = new JCheckBoxMenuItem(TrackerRes.getString("TMenuBar.MenuItem.WindowRight"), false);
        this.view_rightPaneItem.setAccelerator(KeyStroke.getKeyStroke(82, keyMask));
        this.view_rightPaneItem.addActionListener(e -> {
            if (this.frame != null) {
                JSplitPane pane = this.frame.getSplitPane(this.panel(), 0);
                if (this.view_rightPaneItem.isSelected()) {
                    pane.setDividerLocation(0.67);
                } else {
                    pane.setDividerLocation(1.0);
                }
            }
        });
        this.view_bottomPaneItem = new JCheckBoxMenuItem(TrackerRes.getString("TMenuBar.MenuItem.WindowBottom"), false);
        this.view_bottomPaneItem.setAccelerator(KeyStroke.getKeyStroke(66, keyMask));
        this.view_bottomPaneItem.addActionListener(e -> {
            if (this.frame != null) {
                JSplitPane pane = this.frame.getSplitPane(this.panel(), 2);
                if (this.view_bottomPaneItem.isSelected()) {
                    pane.setDividerLocation(0.57);
                } else {
                    pane.setDividerLocation(1.0);
                }
            }
        });
        this.view_trackControlItem = new JCheckBoxMenuItem(TrackerRes.getString("TMenuBar.MenuItem.TrackControl"));
        this.view_trackControlItem.addActionListener(e -> {
            TrackControl tc;
            tc.setVisible(!(tc = TrackControl.getControl(this.panel())).isVisible());
        });
        this.view_notesItem = new JCheckBoxMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Description"));
        this.view_notesItem.addActionListener(e -> {
            if (this.frame != null) {
                if (this.frame.notesVisible()) {
                    this.frame.getNotesDialog().setVisible(false);
                } else {
                    this.panel().getToolBar(true).doNotesAction();
                }
            }
        });
        String s = TrackerRes.getString("TMenuBar.MenuItem.DataFunctionTool");
        s = String.valueOf(s) + " (" + TrackerRes.getString("TView.Menuitem.Define") + ")";
        this.view_dataBuilderItem = new JCheckBoxMenuItem(s);
        this.view_dataBuilderItem.addActionListener(e -> {
            FunctionTool builder = this.panel().getDataBuilder();
            if (builder.isVisible()) {
                builder.setVisible(false);
            } else {
                TTrack track = this.panel().getSelectedTrack();
                if (track != null) {
                    builder.setSelectedPanel(track.getName());
                }
                builder.setVisible(true);
            }
        });
        s = TrackerRes.getString("TMenuBar.MenuItem.DatasetTool");
        s = String.valueOf(s) + " (" + TrackerRes.getString("TableTrackView.Popup.MenuItem.Analyze") + ")";
        this.view_dataToolItem = new JCheckBoxMenuItem(s);
        this.view_dataToolItem.addActionListener(e -> {
            TrackChooserTView v;
            DataTool tool = DataTool.getTool(true);
            if (tool.isVisible()) {
                tool.setVisible(false);
                return;
            }
            boolean sent = false;
            List<TView> views = this.frame.getTViews(this.panelID, 0, null);
            int i = 0;
            while (i < views.size()) {
                v = (PlotTView)views.get(i);
                PlotTrackView view = (PlotTrackView)v.getTrackView(v.getSelectedTrack());
                if (view != null) {
                    TrackPlottingPanel[] trackPlottingPanelArray = view.getPlots();
                    int n = trackPlottingPanelArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TrackPlottingPanel plot = trackPlottingPanelArray[n2];
                        plot.showDataTool();
                        sent = true;
                        ++n2;
                    }
                }
                ++i;
            }
            if (!sent) {
                views.clear();
                views = this.frame.getTViews(this.panelID, 1, views);
                i = 0;
                while (i < views.size()) {
                    v = (TableTView)views.get(i);
                    TableTrackView tableView = (TableTrackView)v.getTrackView(v.getSelectedTrack());
                    if (tableView != null) {
                        tableView.dataToolAction();
                    }
                    ++i;
                }
            }
            tool.setDefaultCloseOperation(1);
            tool.setVisible(true);
        });
        this.viewMenu.addSeparator();
        this.refreshViewMenu(false);
        this.add(this.viewMenu);
    }

    protected void setupVideoMenu() {
        Clipboard clipboard;
        Transferable data;
        if (this.video_filtersMenu.getComponentCount() == 0) {
            this.addItems(this.video_filtersMenu, this.videoFiltersMenuItems);
        }
        boolean b = (data = (clipboard = Toolkit.getDefaultToolkit().getSystemClipboard()).getContents(null)) != null && data.isDataFlavorSupported(DataFlavor.imageFlavor);
        this.video_pasteImageMenu.setEnabled(b);
        this.video_pasteImageItem.setEnabled(b);
        OSPRuntime.paste(xml -> {
            XMLControlElement control;
            boolean filterOnClipboard = false;
            String pasteFilterText = TrackerRes.getString("TActions.Action.Paste");
            if (xml != null && xml.contains("<?xml") && (filterOnClipboard = Filter.class.isAssignableFrom((control = new XMLControlElement((String)xml)).getObjectClass()))) {
                String filterName = control.getObjectClass().getSimpleName();
                int i = filterName.indexOf("Filter");
                if (i > 0 && i < filterName.length() - 1) {
                    filterName = filterName.substring(0, i);
                }
                filterName = MediaRes.getString("VideoFilter." + filterName);
                pasteFilterText = String.valueOf(pasteFilterText) + " " + filterName;
            }
            this.video_pasteFilterItem.setEnabled(filterOnClipboard);
            this.video_pasteFilterItem.setText(pasteFilterText);
        });
        Video video2 = this.panel().getVideo();
        if (video2 != null) {
            boolean vis = this.panel().getPlayer().getClipControl().videoVisible;
            this.video_videoVisibleItem.setSelected(video2.isVisible() || vis);
            boolean showFiltersMenu = this.panel().isEnabled("video.filters");
            boolean hasNoFiltersMenu = true;
            int i = 0;
            while (i < this.videoMenu.getItemCount()) {
                JMenuItem item = this.videoMenu.getItem(i);
                if (item == this.video_filtersMenu) {
                    hasNoFiltersMenu = false;
                }
                ++i;
            }
            if (hasNoFiltersMenu && showFiltersMenu) {
                this.videoMenu.remove(this.video_checkDurationsItem);
                this.videoMenu.remove(this.video_aboutVideoItem);
                i = this.videoMenu.getItemCount() - 1;
                while (i >= 0) {
                    Component next = this.videoMenu.getMenuComponent(i);
                    if (next instanceof JMenuItem) break;
                    this.videoMenu.remove(next);
                    --i;
                }
                this.videoMenu.addSeparator();
                this.videoMenu.add(this.video_filtersMenu);
                this.videoMenu.addSeparator();
                this.videoMenu.remove(this.video_checkDurationsItem);
                this.videoMenu.add(this.video_aboutVideoItem);
            }
        }
    }

    protected void setupEditMenu() {
        this.refreshTracks(2);
        Step step = this.panel().getSelectedStep();
        TTrack track = this.panel().getSelectedTrack();
        boolean cantDeleteSteps = track == null || track.isLocked() || track.isDependent();
        this.edit_delTracks_deleteSelectedPointItem.setEnabled(!cantDeleteSteps && step != null);
        this.refreshPasteItem();
        TreeMap<Integer, TableTrackView> dataViews = this.getDataViews();
        this.edit_copyDataMenu.setEnabled(!dataViews.isEmpty());
    }

    protected JMenu createTrackMenu(TTrack track) {
        JMenuItem item;
        int i;
        JMenu menu = track.getMenu(this.panel(), null);
        menu.setName("track");
        ImageCoordSystem coords = this.panel().getCoords();
        if (coords.isLocked() && coords instanceof ReferenceFrame && track == ((ReferenceFrame)coords).getOriginTrack()) {
            i = 0;
            while (i < menu.getItemCount()) {
                item = menu.getItem(i);
                if (item != null && item.getText().equals(TrackerRes.getString("TMenuBar.MenuItem.CoordsLocked"))) {
                    menu.getItem(i).setEnabled(false);
                    break;
                }
                ++i;
            }
        }
        if (track == this.panel().getAxes()) {
            i = 0;
            while (i < menu.getItemCount()) {
                item = menu.getItem(i);
                if (item != null && item.getText().equals(TrackerRes.getString("TTrack.MenuItem.Visible"))) {
                    menu.remove(i);
                    break;
                }
                ++i;
            }
            this.track_axesVisibleItem.setSelected(track.isVisible());
            menu.insert(this.track_axesVisibleItem, i);
        }
        FontSizer.setMenuFonts(menu);
        return menu;
    }

    protected void refreshFileMenu(boolean opening) {
        boolean newtabEnabled = this.panel().isEnabled("file.new");
        boolean openEnabled = this.panel().isEnabled("file.open");
        boolean closeEnabled = this.panel().isEnabled("file.close");
        boolean importEnabled = this.panel().isEnabled("file.import");
        boolean exportEnabled = this.panel().isEnabled("file.export");
        boolean showLib = this.panel().isEnabled("file.library") && (openEnabled || exportEnabled);
        boolean saveEnabled = this.panel().isEnabled("file.save");
        boolean saveAsEnabled = this.panel().isEnabled("file.saveAs");
        boolean printEnabled = this.panel().isEnabled("file.print");
        this.fileMenu.removeAll();
        if (newtabEnabled) {
            this.fileMenu.add(this.file_newTabItem);
            if (this.file_replaceTabItem != null) {
                this.fileMenu.add(this.file_replaceTabItem);
            }
            this.fileMenu.addSeparator();
        }
        this.file_openMenu.removeAll();
        if (openEnabled) {
            this.file_openMenu.add(this.file_openItem);
            if (showLib) {
                this.file_openMenu.add(this.file_openBrowserItem);
            }
            this.fileMenu.add(this.file_openMenu);
        }
        if (openEnabled && !OSPRuntime.isJS) {
            this.fileMenu.add(this.file_openRecentMenu);
        }
        if (openEnabled && this.panel().getDataFile() != null) {
            TMenuBar.checkAddMenuSep(this.fileMenu);
            this.fileMenu.add(this.file_reloadItem);
        }
        if (closeEnabled) {
            TMenuBar.checkAddMenuSep(this.fileMenu);
            this.fileMenu.add(this.file_closeItem);
            this.fileMenu.add(this.file_closeAllItem);
        }
        if (saveEnabled || saveAsEnabled) {
            TMenuBar.checkAddMenuSep(this.fileMenu);
        }
        if (saveEnabled) {
            this.fileMenu.add(this.file_saveMenu);
        }
        if (saveAsEnabled) {
            this.file_saveMenu.add(this.file_saveItem);
            this.fileMenu.add(this.file_saveTabAsItem);
            if (this.panel().getVideo() != null) {
                this.fileMenu.add(this.file_saveVideoAsItem);
            }
            this.file_saveMenu.add(this.file_saveProjectAsItem);
            if (this.frame != null && this.frame.getTabCount() > 1) {
                this.fileMenu.add(this.file_saveTabsetAsItem);
            }
        }
        if (importEnabled || exportEnabled) {
            TMenuBar.checkAddMenuSep(this.fileMenu);
            if (importEnabled) {
                this.fileMenu.add(this.file_importMenu);
            }
            if (exportEnabled) {
                this.fileMenu.add(this.file_exportMenu);
            }
        }
        TMenuBar.checkAddMenuSep(this.fileMenu);
        this.fileMenu.add(this.file_propertiesItem);
        this.fileMenu.addSeparator();
        if (printEnabled) {
            this.fileMenu.add(this.file_printFrameItem);
        }
        this.fileMenu.add(this.file_exitItem);
        if (opening && this.isTainted(1)) {
            this.file_newTabItem.setEnabled(newtabEnabled);
            this.checkShowMenuSep(this.fileMenu, this.file_openItem, openEnabled);
            this.file_openItem.setEnabled(openEnabled);
            this.checkShowMenuSep(this.fileMenu, this.file_openBrowserItem, showLib);
            this.file_openBrowserItem.setEnabled(showLib && openEnabled);
            this.checkShowMenuSep(this.fileMenu, this.file_closeItem, closeEnabled);
            this.file_closeItem.setEnabled(closeEnabled);
            this.file_closeAllItem.setEnabled(closeEnabled);
            this.checkShowMenuSep(this.fileMenu, this.file_saveItem, saveEnabled || saveAsEnabled);
            this.file_saveItem.setEnabled(saveEnabled);
            this.file_saveTabAsItem.setEnabled(saveAsEnabled);
            this.file_saveVideoAsItem.setEnabled(saveAsEnabled && this.panel().getVideo() != null);
            this.file_saveProjectAsItem.setEnabled(saveAsEnabled);
            this.file_saveTabsetAsItem.setEnabled(saveAsEnabled && this.frame != null && this.frame.getTabCount() > 1);
            this.checkShowMenuSep(this.fileMenu, this.file_importMenu, importEnabled || exportEnabled);
            this.file_importMenu.setEnabled(importEnabled);
            this.file_exportMenu.setEnabled(exportEnabled);
            this.checkShowMenuSep(this.fileMenu, this.file_printFrameItem, printEnabled);
            this.file_printFrameItem.setEnabled(printEnabled);
            String name = " \"" + this.panel().getTitle() + "\"";
            this.file_closeItem.setText(String.valueOf(TrackerRes.getString("TActions.Action.Close")) + name);
            this.file_reloadItem.setText(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.Reload")) + name);
            this.file_export_dataItem.setEnabled(!this.panel().getExportableTracks().isEmpty());
            FontSizer.setMenuFonts(this.fileMenu);
            this.setMenuTainted(1, false);
        }
        if (opening && !OSPRuntime.isJS && this.frame != null) {
            System.out.println("TMenuBar mem test " + OSPRuntime.getMemoryStr());
            this.frame.refreshOpenRecentMenu(this.file_openRecentMenu);
        }
    }

    private void checkShowMenuSep(JMenu menu, JMenuItem item, boolean isEnabled) {
    }

    protected void rebuildEditFontSizeMenu() {
        this.edit_fontSizeMenu.removeAll();
        int i = 0;
        while (i <= Tracker.maxFontLevel) {
            String s = TrackerRes.getString("TMenuBar.MenuItem.Font");
            ResizableIcon icon = (ResizableIcon)Tracker.getResourceIcon("zoom.gif", true);
            icon.setFixedSizeFactor(FontSizer.getIntegerFactor(i));
            JMenuItem item = new JMenuItem(s, icon);
            FontSizer.setFonts(item, i);
            int n = i;
            item.addActionListener(e -> FontSizer.setLevel(n));
            this.edit_fontSizeMenu.add(item);
            if (i == FontSizer.getLevel()) {
                item.setForeground(Color.green.darker());
            }
            ++i;
        }
    }

    protected void rebuildEditMatSizeMenu() {
        if (this.matSizeAction == null) {
            this.matSizeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String c = e.getActionCommand();
                    String[] size = c.split("x");
                    double w = Double.parseDouble(size[0]);
                    double h = Double.parseDouble(size[1]);
                    TMenuBar.this.panel().setImageSize(w, h);
                }
            };
            this.matSizeGroup = new ButtonGroup();
            this.edit_matsize_videoSizeItem = new JRadioButtonMenuItem();
            this.edit_matsize_videoSizeItem.setActionCommand("0x0");
            this.edit_matsize_videoSizeItem.addActionListener(this.matSizeAction);
            this.matSizeGroup.add(this.edit_matsize_videoSizeItem);
            int i = 0;
            while (i < baseMatSizes.length) {
                String size = baseMatSizes[i];
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(size);
                item.setActionCommand(size);
                item.addActionListener(this.matSizeAction);
                this.matSizeGroup.add(item);
                ++i;
            }
            this.edit_matsize_matSizeItem = new JRadioButtonMenuItem();
        }
        this.edit_matSizeMenu.removeAll();
        this.matSizeGroup.remove(this.edit_matsize_matSizeItem);
        int vidWidth = 1;
        int vidHeight = 1;
        TrackerPanel panel = this.panel();
        Video video2 = panel.getVideo();
        Rectangle mat = panel.getMatBounds();
        String dimensionString = String.valueOf(mat.width) + "x" + mat.height;
        this.edit_matsize_matSizeItem.setText(dimensionString);
        this.edit_matsize_matSizeItem.setActionCommand(dimensionString);
        if (video2 != null) {
            Dimension d = video2.getImageSize(true);
            vidWidth = d.width;
            vidHeight = d.height;
            String s = TrackerRes.getString("TMenuBar.Menu.Video");
            String description = " (" + s.toLowerCase() + ")";
            dimensionString = String.valueOf(vidWidth) + "x" + vidHeight;
            this.edit_matsize_videoSizeItem.setText(String.valueOf(dimensionString) + description);
            this.edit_matsize_videoSizeItem.setActionCommand(dimensionString);
            int maxW = 0;
            int maxH = 0;
            Enumeration<AbstractButton> e = this.matSizeGroup.getElements();
            while (e.hasMoreElements()) {
                AbstractButton next = e.nextElement();
                String[] size = next.getActionCommand().split("x");
                maxW = Math.max(maxW, Integer.parseInt(size[0]));
                maxH = Math.max(maxH, Integer.parseInt(size[1]));
            }
            int i = 0;
            while (maxW < 2 * vidWidth || maxH < 2 * vidHeight) {
                JRadioButtonMenuItem item;
                int multiplier = (int)Math.pow(2.0, i);
                int w = multiplier * 3200;
                maxW = Math.max(maxW, w);
                int h = multiplier * 2400;
                maxH = Math.max(maxH, h);
                dimensionString = String.valueOf(w) + "x" + h;
                if (!this.matSizeGroupContains(dimensionString)) {
                    item = new JRadioButtonMenuItem(dimensionString);
                    item.setActionCommand(dimensionString);
                    item.addActionListener(this.matSizeAction);
                    this.matSizeGroup.add(item);
                }
                if (maxW < 2 * vidWidth || maxH < 2 * vidHeight) {
                    w = (int)((double)w * 1.5);
                    maxW = Math.max(maxW, w);
                    h = (int)((double)h * 1.5);
                    maxH = Math.max(maxH, h);
                    dimensionString = String.valueOf(w) + "x" + h;
                    if (!this.matSizeGroupContains(dimensionString)) {
                        item = new JRadioButtonMenuItem(dimensionString);
                        item.setActionCommand(dimensionString);
                        item.addActionListener(this.matSizeAction);
                        this.matSizeGroup.add(item);
                    }
                }
                ++i;
            }
        } else {
            this.edit_matsize_videoSizeItem.setActionCommand("0x0");
        }
        int imageWidth = (int)this.panel().getImageWidth();
        int imageHeight = (int)this.panel().getImageHeight();
        int matIndex = 0;
        Enumeration<AbstractButton> e = this.matSizeGroup.getElements();
        while (e.hasMoreElements()) {
            boolean matIsHigher;
            AbstractButton next = e.nextElement();
            String[] size = next.getActionCommand().split("x");
            int w = Integer.parseInt(size[0]);
            int h = Integer.parseInt(size[1]);
            boolean matIsWider = w < mat.width;
            boolean bl = matIsHigher = h < mat.height;
            if (w >= vidWidth && h >= vidHeight) {
                if (matIsWider || matIsHigher) {
                    ++matIndex;
                }
                this.edit_matSizeMenu.add(next);
                if (next != this.edit_matsize_videoSizeItem && next.getActionCommand().equals(this.edit_matsize_videoSizeItem.getActionCommand())) {
                    this.edit_matSizeMenu.remove(next);
                    --matIndex;
                }
            }
            if (w == vidWidth && h == vidHeight) {
                this.edit_matsize_videoSizeItem.setSelected(true);
                continue;
            }
            if (w != imageWidth || h != imageHeight) continue;
            next.setSelected(true);
        }
        if (!this.matSizeGroupContains(this.edit_matsize_matSizeItem.getActionCommand())) {
            this.matSizeGroup.add(this.edit_matsize_matSizeItem);
            this.edit_matsize_matSizeItem.setSelected(true);
            this.edit_matSizeMenu.insert(this.edit_matsize_matSizeItem, matIndex);
        }
        FontSizer.setMenuFonts(this.edit_matSizeMenu);
    }

    private boolean matSizeGroupContains(String actionCommand) {
        Enumeration<AbstractButton> e = this.matSizeGroup.getElements();
        while (e.hasMoreElements()) {
            AbstractButton next = e.nextElement();
            if (!next.getActionCommand().equals(actionCommand)) continue;
            return true;
        }
        return false;
    }

    protected void rebuildEditCopyMenu(String type) {
        switch (type) {
            case "data": {
                this.edit_copyDataMenu.removeAll();
                TreeMap<Integer, TableTrackView> dataViews = this.getDataViews();
                if (dataViews.isEmpty()) {
                    this.edit_copyDataMenu.setText(TrackerRes.getString("TableTrackView.Action.CopyData"));
                } else if (dataViews.size() == 1) {
                    Integer key = dataViews.firstKey();
                    TableTrackView view = dataViews.get(key);
                    view.refreshCopyDataMenu(this.edit_copyDataMenu);
                    String text = this.edit_copyDataMenu.getText();
                    this.edit_copyDataMenu.setText(String.valueOf(text) + " (" + key + ")");
                } else {
                    this.edit_copyDataMenu.setText(TrackerRes.getString("TableTrackView.Action.CopyData"));
                    for (int key : dataViews.keySet()) {
                        TableTrackView view = dataViews.get(key);
                        JMenu menu = new JMenu();
                        this.edit_copyDataMenu.add(view.refreshCopyDataMenu(menu));
                        String text = menu.getText();
                        menu.setText(String.valueOf(text) + " (" + key + ")");
                    }
                }
                FontSizer.setMenuFonts(this.edit_copyDataMenu);
                break;
            }
            case "image": {
                int i;
                final TViewChooser[] choosers = this.frame.getViewChoosers(this.panel());
                if (this.edit_copyFrameImageItem == null) {
                    this.edit_copyFrameImageItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.CopyFrame"));
                    this.edit_copyFrameImageItem.addActionListener(e -> {
                        TFrame c = this.frame;
                        new TrackerIO.ComponentImage(c).copyToClipboard();
                    });
                    this.edit_copyMainViewImageItem = new JMenuItem(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.CopyMainView")) + " (0)");
                    this.edit_copyMainViewImageItem.addActionListener(e -> new TrackerIO.ComponentImage(this.panel()).copyToClipboard());
                    AbstractAction copyView = new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            int i = Integer.parseInt(e.getActionCommand());
                            new TrackerIO.ComponentImage(choosers[i]).copyToClipboard();
                        }
                    };
                    this.edit_copyViewImageItems = new JMenuItem[choosers.length];
                    i = 0;
                    while (i < choosers.length) {
                        this.edit_copyViewImageItems[i] = new JMenuItem();
                        this.edit_copyViewImageItems[i].setActionCommand(String.valueOf(i));
                        this.edit_copyViewImageItems[i].setAction(copyView);
                        ++i;
                    }
                }
                this.edit_copyImageMenu.removeAll();
                this.edit_copyImageMenu.add(this.edit_copyMainViewImageItem);
                TViewChooser[] vchoosers = this.frame.getVisibleChoosers(this.panel().getID());
                i = 0;
                while (i < choosers.length) {
                    if (vchoosers[i] != null) {
                        String viewname = null;
                        TView tview = vchoosers[i].getSelectedView();
                        viewname = tview == null ? TrackerRes.getString("TFrame.View.Unknown") : tview.getViewName();
                        this.edit_copyViewImageItems[i].setText(String.valueOf(viewname) + " (" + (i + 1) + ")");
                        String command = String.valueOf(i);
                        this.edit_copyViewImageItems[i].setActionCommand(command);
                        this.edit_copyImageMenu.add(this.edit_copyViewImageItems[i]);
                    } else {
                        this.edit_copyImageMenu.remove(this.edit_copyViewImageItems[i]);
                    }
                    ++i;
                }
                this.edit_copyImageMenu.add(this.edit_copyFrameImageItem);
                FontSizer.setMenuFonts(this.edit_copyImageMenu);
                break;
            }
            case "object": {
                this.edit_copyObjectMenu.removeAll();
                AbstractAction copyObjectAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String s = ((JMenuItem)e.getSource()).getActionCommand();
                        if ("coords".equals(s)) {
                            TrackerIO.copyXML(TMenuBar.this.panel().getCoords());
                        } else if ("clip".equals(s)) {
                            TrackerIO.copyXML(TMenuBar.this.panel().getPlayer().getVideoClip());
                        } else {
                            TTrack track = TMenuBar.this.panel().getTrack(s);
                            if (track != null) {
                                TrackerIO.copyXML(track);
                            }
                        }
                    }
                };
                JMenuItem item = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Coords"));
                item.setActionCommand("coords");
                item.addActionListener(copyObjectAction);
                this.edit_copyObjectMenu.add(item);
                item = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.VideoClip"));
                item.setActionCommand("clip");
                item.addActionListener(copyObjectAction);
                this.edit_copyObjectMenu.add(item);
                for (TTrack next : this.panel().getTracksTemp()) {
                    if (next == this.panel().getAxes() || next instanceof PerspectiveTrack) continue;
                    item = new JMenuItem(next.getName());
                    item.setActionCommand(next.getName());
                    item.addActionListener(copyObjectAction);
                    this.edit_copyObjectMenu.add(item);
                }
                this.panel().clearTemp();
                FontSizer.setMenuFonts(this.edit_copyObjectMenu);
            }
        }
    }

    protected void refreshEditMenu(boolean opening) {
        if (this.isTainted(2)) {
            boolean hasTracks = !this.panel().getUserTracks().isEmpty();
            boolean undoEnabled = this.panel().isEnabled("edit.undoRedo");
            boolean copyDataEnabled = this.panel().isEnabled("edit.copyData");
            boolean copyImageEnabled = this.panel().isEnabled("edit.copyImage");
            boolean copyObjectEnabled = this.panel().isEnabled("edit.copyObject");
            boolean pasteEnabled = this.panel().isEnabled("edit.paste");
            boolean deleteEnabled = this.panel().isEnabled("track.delete");
            boolean formatsEnabled = this.panel().isEnabled("number.formats");
            boolean unitsEnabled = this.panel().isEnabled("number.units");
            boolean matSizeEnabled = this.panel().isEnabled("edit.matSize");
            this.editMenu.removeAll();
            if (undoEnabled) {
                this.edit_undoItem.setText(TrackerRes.getString("TMenuBar.MenuItem.Undo"));
                this.edit_undoItem.setText(Undo.getUndoDescription(this.panel()));
                this.editMenu.add(this.edit_undoItem);
                this.edit_undoItem.setEnabled(Undo.canUndo(this.panel()));
                this.edit_redoItem.setText(TrackerRes.getString("TMenuBar.MenuItem.Redo"));
                this.edit_redoItem.setText(Undo.getRedoDescription(this.panel()));
                this.editMenu.add(this.edit_redoItem);
                this.edit_redoItem.setEnabled(Undo.canRedo(this.panel()));
            }
            if (copyImageEnabled || copyDataEnabled || copyObjectEnabled) {
                TMenuBar.checkAddMenuSep(this.editMenu);
                if (copyDataEnabled) {
                    this.editMenu.add(this.edit_copyDataMenu);
                    TreeMap<Integer, TableTrackView> dataViews = this.getDataViews();
                    this.edit_copyDataMenu.setEnabled(!dataViews.isEmpty());
                    if (dataViews.isEmpty()) {
                        this.edit_copyDataMenu.setText(TrackerRes.getString("TableTrackView.Action.CopyData"));
                    } else {
                        Integer key = dataViews.firstKey();
                        TableTrackView view = dataViews.get(key);
                        view.refreshCopyDataMenu(this.edit_copyDataMenu);
                        String text = this.edit_copyDataMenu.getText();
                        this.edit_copyDataMenu.setText(String.valueOf(text) + " (" + key + ")");
                    }
                }
                if (copyImageEnabled) {
                    this.editMenu.add(this.edit_copyImageMenu);
                }
                if (copyObjectEnabled) {
                    this.editMenu.add(this.edit_copyObjectMenu);
                    this.edit_copyObjectMenu.setText(TrackerRes.getString("TMenuBar.Menu.CopyObject"));
                }
            }
            if (pasteEnabled) {
                TMenuBar.checkAddMenuSep(this.editMenu);
                this.editMenu.add(this.edit_pasteItem);
            }
            this.edit_deleteTracksMenu.setEnabled(hasTracks);
            if (deleteEnabled) {
                TMenuBar.checkAddMenuSep(this.editMenu);
                if (deleteEnabled || hasTracks) {
                    this.editMenu.add(this.edit_deleteTracksMenu);
                }
            }
            if (formatsEnabled || unitsEnabled) {
                TMenuBar.checkAddMenuSep(this.editMenu);
                this.editMenu.add(this.edit_numberMenu);
                this.edit_numberMenu.removeAll();
                if (formatsEnabled) {
                    this.edit_numberMenu.add(this.edit_formatsItem);
                }
                if (unitsEnabled) {
                    this.edit_numberMenu.add(this.edit_unitsItem);
                }
            }
            if (matSizeEnabled) {
                TMenuBar.checkAddMenuSep(this.editMenu);
                this.editMenu.add(this.edit_matSizeMenu);
            }
            TMenuBar.checkAddMenuSep(this.editMenu);
            this.editMenu.add(this.edit_fontSizeMenu);
            TMenuBar.checkAddMenuSep(this.editMenu);
            this.editMenu.add(this.edit_languageMenu);
            if (!OSPRuntime.isJS) {
                TMenuBar.checkAddMenuSep(this.editMenu);
                this.editMenu.add(this.edit_configItem);
            }
            FontSizer.setMenuFonts(this.editMenu);
            this.setMenuTainted(2, false);
        }
        if (opening) {
            this.setupEditMenu();
            this.refreshTrackNames(2);
        }
    }

    protected void refreshCoordsMenu(boolean opening) {
        if (this.isTainted(8)) {
            this.coordsMenu.removeAll();
            if (this.panel().isEnabled("number.units")) {
                this.coordsMenu.add(this.coords_showUnitDialogItem);
            }
            if (this.panel().isEnabled("coords.locked")) {
                TMenuBar.checkAddMenuSep(this.coordsMenu);
                this.coordsMenu.add(this.coords_lockedCoordsItem);
            }
            if (this.panel().isEnabled("coords.origin") || this.panel().isEnabled("coords.angle") || this.panel().isEnabled("coords.scale")) {
                TMenuBar.checkAddMenuSep(this.coordsMenu);
                if (this.panel().isEnabled("coords.origin")) {
                    this.coordsMenu.add(this.coords_fixedOriginItem);
                }
                if (this.panel().isEnabled("coords.angle")) {
                    this.coordsMenu.add(this.coords_fixedAngleItem);
                }
                if (this.panel().isEnabled("coords.scale")) {
                    this.coordsMenu.add(this.coords_fixedScaleItem);
                }
            }
            if (this.panel().isEnabled("coords.refFrame")) {
                TMenuBar.checkAddMenuSep(this.coordsMenu);
                this.coordsMenu.add(this.coords_refFrameMenu);
            }
            this.refreshTracks(8);
            if (this.coordsMenu.getItemCount() == 0) {
                this.coordsMenu.add(this.coords_emptyCoordsItem);
            }
            this.setMenuTainted(8, false);
        }
        if (opening) {
            this.refreshTrackNames(8);
            ImageCoordSystem coords = this.panel().getCoords();
            boolean defaultCoords = !(coords instanceof ReferenceFrame);
            this.coords_lockedCoordsItem.setSelected(coords.isLocked());
            this.coords_fixedOriginItem.setSelected(coords.isFixedOrigin());
            this.coords_fixedAngleItem.setSelected(coords.isFixedAngle());
            this.coords_fixedScaleItem.setSelected(coords.isFixedScale());
            this.coords_fixedOriginItem.setEnabled(defaultCoords && !coords.isLocked());
            this.coords_fixedAngleItem.setEnabled(defaultCoords && !coords.isLocked());
            boolean stickAttached = false;
            ArrayList<TapeMeasure> tapes = this.panel().getDrawablesTemp(TapeMeasure.class);
            int i = 0;
            int n = tapes.size();
            while (i < n) {
                TapeMeasure tape = tapes.get(i);
                if (tape.isStickMode() && tape.isAttached()) {
                    stickAttached = true;
                    break;
                }
                ++i;
            }
            tapes.clear();
            this.coords_fixedScaleItem.setEnabled(defaultCoords && !coords.isLocked() && !stickAttached);
            this.coords_refFrameMenu.setEnabled(!coords.isLocked());
        }
        FontSizer.setMenuFonts(this.coordsMenu);
    }

    private PointMass getOriginTrack() {
        ImageCoordSystem coords = this.panel().getCoords();
        return coords instanceof ReferenceFrame ? ((ReferenceFrame)coords).getOriginTrack() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshVideoMenu(boolean opening) {
        if (this.isTainted(4)) {
            int n;
            boolean importEnabled;
            Video video2 = this.panel().getVideo();
            boolean hasVideo = video2 != null;
            this.videoMenu.removeAll();
            boolean bl = importEnabled = this.panel().isEnabled("video.import") || this.panel().isEnabled("video.open");
            if (importEnabled) {
                if (hasVideo) {
                    this.video_openVideoItem.setText(TrackerRes.getString("TMenuBar.MenuItem.Replace"));
                } else {
                    this.video_openVideoItem.setText(TrackerRes.getString("TActions.Action.ImportVideo"));
                }
                this.videoMenu.add(this.video_openVideoItem);
            }
            if (hasVideo && this.panel().isEnabled("video.close")) {
                this.videoMenu.add(this.video_closeVideoItem);
            }
            TMenuBar.checkAddMenuSep(this.videoMenu);
            if (this.panel().isEnabled("button.clipSettings")) {
                this.videoMenu.add(this.video_clipSettingsItem);
            }
            this.videoMenu.add(this.video_goToItem);
            TMenuBar.checkAddMenuSep(this.videoMenu);
            if (importEnabled && video2 instanceof ImageVideo) {
                boolean editable = ((ImageVideo)video2).isEditable();
                this.video_editVideoItem.setSelected(editable);
                String tip = editable ? TrackerRes.getString("TMenuBar.MenuItem.StopEditVideoFrames.Tooltip") : TrackerRes.getString("TMenuBar.MenuItem.EditVideoFrames.Tooltip");
                this.video_editVideoItem.setToolTipText(tip);
                this.videoMenu.add(this.video_editVideoItem);
                this.videoMenu.addSeparator();
            }
            if (importEnabled) {
                this.videoMenu.add(hasVideo ? this.video_pasteImageMenu : this.video_pasteImageItem);
            }
            if (video2 != null) {
                boolean isEditableVideo;
                boolean bl2 = isEditableVideo = importEnabled && video2 instanceof ImageVideo && ((ImageVideo)video2).isEditable();
                if (isEditableVideo && importEnabled) {
                    this.video_pasteImageMenu.add(this.video_pasteImageBeforeItem);
                    this.video_pasteImageMenu.add(this.video_pasteImageAfterItem);
                    this.videoMenu.add(this.video_importImageMenu);
                    this.videoMenu.add(this.video_removeImageItem);
                    this.video_removeImageItem.setEnabled(video2.getFrameCount() > 1);
                } else {
                    this.video_pasteImageMenu.remove(this.video_pasteImageBeforeItem);
                    this.video_pasteImageMenu.remove(this.video_pasteImageAfterItem);
                }
                if (this.panel().isEnabled("video.visible")) {
                    TMenuBar.checkAddMenuSep(this.videoMenu);
                    this.videoMenu.add(this.video_videoVisibleItem);
                }
                VideoClip clip = this.panel().getPlayer().getVideoClip();
                this.video_playAllStepsItem.setSelected(clip.isPlayAllSteps());
                this.videoMenu.add(this.video_playAllStepsItem);
                if (video2 instanceof SmoothPlayable) {
                    this.video_playXuggleSmoothlyItem.setSelected(((SmoothPlayable)((Object)video2)).isSmoothPlay());
                    this.videoMenu.add(this.video_playXuggleSmoothlyItem);
                }
                if (this.panel().isEnabled("video.filters")) {
                    this.video_filtersMenu.removeAll();
                    this.video_filtersMenu.add(this.video_filter_newFilterMenu);
                    this.video_filter_newFilterMenu.removeAll();
                    Map<String, Class<? extends Filter>> map = this.panel().getFilters();
                    synchronized (map) {
                        for (String name : this.panel().getFilters().keySet()) {
                            String shortName = name;
                            int i = shortName.lastIndexOf(46);
                            if (i > 0 && i < shortName.length() - 1) {
                                shortName = shortName.substring(i + 1);
                            }
                            if ((i = shortName.indexOf("Filter")) > 0 && i < shortName.length() - 1) {
                                shortName = shortName.substring(0, i);
                            }
                            shortName = MediaRes.getString("VideoFilter." + shortName);
                            JMenuItem item = new JMenuItem(shortName);
                            item.setActionCommand(name);
                            item.addActionListener(this.actions.get("videoFilter"));
                            this.video_filter_newFilterMenu.add(item);
                        }
                    }
                    FilterStack stack = video2.getFilterStack();
                    stack.removePropertyChangeListener("filter", this);
                    stack.addPropertyChangeListener("filter", this);
                    if (!stack.getFilters().isEmpty()) {
                        this.video_filtersMenu.addSeparator();
                        for (Filter filter : stack.getFilters()) {
                            this.video_filtersMenu.add(filter.getMenu(video2));
                        }
                    }
                    this.video_filtersMenu.addSeparator();
                    this.video_filtersMenu.add(this.video_pasteFilterItem);
                    if (!stack.getFilters().isEmpty()) {
                        this.video_filtersMenu.addSeparator();
                        this.video_filtersMenu.add(this.video_clearFiltersItem);
                    }
                    TMenuBar.checkAddMenuSep(this.videoMenu);
                    this.videoMenu.add(this.video_filtersMenu);
                    this.videoMenu.addSeparator();
                    this.videoMenu.add(this.video_aboutVideoItem);
                }
            }
            if ((n = this.videoMenu.getMenuComponentCount()) > 0 && this.videoMenu.getMenuComponent(n - 1) instanceof JSeparator) {
                this.videoMenu.remove(n - 1);
            }
            if (this.videoMenu.getItemCount() == 0) {
                this.videoMenu.add(this.video_emptyVideoItem);
            }
            this.setMenuTainted(4, false);
            this.videoFiltersMenuItems = this.video_filtersMenu.getMenuComponents();
        }
        if (opening) {
            this.setupVideoMenu();
        }
        FontSizer.setMenuFonts(this.videoMenu);
    }

    protected void refreshPasteItem() {
        String paste = this.actions.get("paste").getValue("Name").toString();
        this.edit_pasteItem.setText(paste);
        this.edit_pasteItem.setEnabled(false);
        String s = OSPRuntime.paste(null);
        if (s == null) {
            return;
        }
        Class<?> type = null;
        XMLControlElement control = null;
        if (s.startsWith("<?xml")) {
            control = new XMLControlElement(s);
            Class<?> clazz = type = control.failedToRead() ? null : control.getObjectClass();
        }
        if (type == null) {
            if (ParticleDataTrack.getImportableDataName(s) != null) {
                paste = TrackerRes.getString("ParticleDataTrack.Button.Paste.Text");
                this.edit_pasteItem.setEnabled(true);
                this.edit_pasteItem.setText(paste);
            }
        } else if (control != null && TTrack.class.isAssignableFrom(type)) {
            String name = control.getString("name");
            this.edit_pasteItem.setEnabled(true);
            this.edit_pasteItem.setText(String.valueOf(paste) + " " + name);
        } else if (ImageCoordSystem.class.isAssignableFrom(type)) {
            this.edit_pasteItem.setEnabled(true);
            this.edit_pasteItem.setText(String.valueOf(paste) + " " + TrackerRes.getString("TMenuBar.MenuItem.Coords"));
        } else if (VideoClip.class.isAssignableFrom(type)) {
            this.edit_pasteItem.setEnabled(true);
            this.edit_pasteItem.setText(String.valueOf(paste) + " " + TrackerRes.getString("TMenuBar.MenuItem.VideoClip"));
        }
    }

    protected void refreshTracks(int menu) {
        ArrayList<TTrack> userTracks = this.panel().getUserTracks();
        int n = userTracks.size();
        PointMass originTrack = null;
        switch (menu) {
            case 8: {
                originTrack = this.getOriginTrack();
                this.coords_refFrameMenu.removeAll();
                Enumeration<AbstractButton> e = this.coords_refFrameGroup.getElements();
                while (e.hasMoreElements()) {
                    this.coords_refFrameGroup.remove(e.nextElement());
                }
                this.coords_refFrameMenu.add(this.coords_defaultRefFrameItem);
                this.coords_refFrameGroup.add(this.coords_defaultRefFrameItem);
                this.coords_defaultRefFrameItem.setSelected(originTrack == null);
                break;
            }
            case 2: {
                this.edit_deleteTracksMenu.removeAll();
                this.edit_deleteTracksMenu.add(this.edit_delTracks_deleteSelectedPointItem);
                this.edit_deleteTracksMenu.addSeparator();
                this.edit_clearTracksItem.setEnabled(n > 0);
            }
        }
        int i = 0;
        while (i < n) {
            TTrack track = userTracks.get(i);
            String trackName = track.getName("track");
            switch (menu) {
                case 8: {
                    if (track.ttype != 5 || track.getClass().getSimpleName().endsWith("DataTrack")) break;
                    JMenuItem item = new JRadioButtonMenuItem(trackName);
                    item.addActionListener(this.actions.get("refFrame"));
                    this.coords_refFrameGroup.add(item);
                    this.coords_refFrameMenu.add(item);
                    if (track != originTrack) break;
                    item.setSelected(true);
                    break;
                }
                case 2: {
                    JMenuItem item = new JMenuItem(trackName);
                    item.setName("track");
                    item.setIcon(track.getIcon(21, 16, "track"));
                    item.addActionListener(this.actions.get("deleteTrack"));
                    item.setEnabled(!track.isLocked() || track.isDependent());
                    this.edit_deleteTracksMenu.add(item);
                }
            }
            ++i;
        }
        switch (menu) {
            case 8: {
                FontSizer.setMenuFonts(this.coords_refFrameMenu);
                break;
            }
            case 2: {
                this.edit_clearTracksItem.setEnabled(n > 0);
                if (this.panel().isEnabled("edit.clear") & n > 0) {
                    this.edit_deleteTracksMenu.addSeparator();
                    this.edit_deleteTracksMenu.add(this.edit_clearTracksItem);
                }
                FontSizer.setMenuFonts(this.edit_deleteTracksMenu);
            }
        }
    }

    protected void refreshTrackMenu(boolean opening, JPopupMenu target) {
        boolean hasTracks;
        ArrayList<TTrack> userTracks = this.panel().getUserTracks();
        boolean bl = hasTracks = !userTracks.isEmpty();
        if (this.isTainted(16)) {
            CoordAxes axes = this.panel().getAxes();
            TTrack track = this.panel().getSelectedTrack();
            this.trackMenu.removeAll();
            this.track_cloneMenu.removeAll();
            this.enabledNewTrackCount = this.refreshTracksCreateMenu(this.track_createMenu, this.enabledNewTrackCount, false);
            if (this.track_createMenu.getItemCount() > 0) {
                this.trackMenu.add(this.track_createMenu);
            }
            if (hasTracks && this.panel().isEnabled("new.clone")) {
                this.trackMenu.add(this.track_cloneMenu);
            }
            if (hasTracks) {
                TMenuBar.checkAddMenuSep(this.trackMenu);
            }
            int i = 0;
            int n = userTracks.size();
            while (i < n) {
                track = userTracks.get(i);
                String trackName = track.getName("track");
                JMenuItem item = new JMenuItem(trackName);
                item.setName("track");
                item.setIcon(track.getIcon(21, 16, "track"));
                item.addActionListener(this.actions.get("cloneTrack"));
                this.track_cloneMenu.add(item);
                track.removePropertyChangeListener("locked", this);
                track.addPropertyChangeListener("locked", this);
                this.trackMenu.add(this.createTrackMenu(track));
                ++i;
            }
            if ((this.panel().isEnabled("button.axes") || this.panel().isEnabled("calibration.stick") || this.panel().isEnabled("calibration.tape") || this.panel().isEnabled("calibration.points") || this.panel().isEnabled("calibration.offsetOrigin")) && axes != null && this.panel().isEnabled("button.axes")) {
                track = axes;
                track.removePropertyChangeListener("locked", this);
                track.addPropertyChangeListener("locked", this);
            }
            if (this.trackMenu.getItemCount() == 0) {
                this.trackMenu.add(this.track_emptyTracksItem);
            }
            this.setMenuTainted(16, false);
            this.tracksMenuItems = this.trackMenu.getMenuComponents();
        }
        if (opening) {
            String s;
            if (this.trackMenu.getItemCount() == 0) {
                int i = 0;
                while (i < this.tracksMenuItems.length) {
                    this.trackMenu.add(this.tracksMenuItems[i]);
                    ++i;
                }
            }
            if (this.track_createMenu.getParent() != target) {
                if (this.track_createMenu.getItemCount() > 0) {
                    target.add((Component)this.track_createMenu, 0);
                }
                if (hasTracks && this.panel().isEnabled("new.clone")) {
                    this.trackMenu.add((Component)this.track_cloneMenu, 1);
                }
            }
            this.track_newDataTrackPasteItem.setEnabled(OSPRuntime.isJS);
            if (!OSPRuntime.isJS && (s = OSPRuntime.paste(null)) != null) {
                this.track_newDataTrackPasteItem.setEnabled(ParticleDataTrack.getImportableDataName(s) != null);
            }
            this.refreshTrackNames(16);
        }
        FontSizer.setMenuFonts(this.trackMenu);
    }

    private void refreshTrackNames(int type) {
        ArrayList<TTrack> userTracks = this.panel().getUserTracks();
        int i = 0;
        int jd = 0;
        int jc = 0;
        int jt = 0;
        int jp = 0;
        int n = userTracks.size();
        while (i < n) {
            TTrack track = userTracks.get(i);
            String trackName = track.getName("track");
            switch (type) {
                case 2: {
                    jd = this.setNextTrackMenuText(this.edit_deleteTracksMenu, jd, trackName);
                    break;
                }
                case 16: {
                    jc = this.setNextTrackMenuText(this.track_cloneMenu, jc, trackName);
                    jt = this.setNextTrackMenuText(this.trackMenu, jt, trackName);
                    break;
                }
                case 8: {
                    if (track.ttype != 5) break;
                    jp = this.setNextTrackMenuText(this.coords_refFrameMenu, jp, trackName);
                }
            }
            ++i;
        }
    }

    private int setNextTrackMenuText(JMenu menu, int j, String trackName) {
        Component c = null;
        int n = menu.getItemCount();
        while (j < n && !"track".equals((c = menu.getMenuComponent(j)).getName())) {
            if (++j < n) continue;
            return j;
        }
        if (c != null) {
            ((JMenuItem)c).setText(trackName);
        }
        return ++j;
    }

    private int refreshTracksCreateMenu(JMenu menu, int enabledCount, boolean userTracksOnly) {
        TrackerPanel p = this.panel();
        if (p.getEnabledCount() != enabledCount || menu.getComponentCount() == 0) {
            enabledCount = p.getEnabledCount();
            menu.removeAll();
            if (p.isEnabled("new.pointMass") || p.isEnabled("new.cm")) {
                if (p.isEnabled("new.pointMass")) {
                    menu.add(this.track_newPointMassItem);
                }
                if (p.isEnabled("new.cm")) {
                    menu.add(this.track_newCMItem);
                }
            }
            if (p.isEnabled("new.vector") || p.isEnabled("new.vectorSum")) {
                TMenuBar.checkAddMenuSep(menu);
                if (p.isEnabled("new.vector")) {
                    menu.add(this.track_newVectorItem);
                }
                if (p.isEnabled("new.vectorSum")) {
                    menu.add(this.track_newVectorSumItem);
                }
            }
            if (p.isEnabled("new.lineProfile") || p.isEnabled("new.RGBRegion")) {
                TMenuBar.checkAddMenuSep(menu);
                if (p.isEnabled("new.lineProfile")) {
                    menu.add(this.track_newLineProfileItem);
                }
                if (p.isEnabled("new.RGBRegion")) {
                    menu.add(this.track_newRGBRegionItem);
                }
            }
            if (p.isEnabled("new.analyticParticle") || p.isEnabled("new.dynamicParticle") || p.isEnabled("new.dynamicTwoBody") || p.isEnabled("new.dataTrack")) {
                TMenuBar.checkAddMenuSep(menu);
                if (p.isEnabled("new.analyticParticle")) {
                    menu.add(this.track_newAnalyticParticleItem);
                }
                if (p.isEnabled("new.dynamicParticle") || p.isEnabled("new.dynamicTwoBody")) {
                    menu.add(this.track_newDynamicParticleMenu);
                    this.track_newDynamicParticleMenu.removeAll();
                    if (p.isEnabled("new.dynamicParticle")) {
                        this.track_newDynamicParticleMenu.add(this.track_newDynamicParticleCartesianItem);
                        this.track_newDynamicParticleMenu.add(this.track_newDynamicParticlePolarItem);
                    }
                    if (p.isEnabled("new.dynamicTwoBody")) {
                        this.track_newDynamicParticleMenu.add(this.track_newDynamicSystemItem);
                    }
                }
                if (p.isEnabled("new.dataTrack")) {
                    menu.add(this.track_newDataTrackMenu);
                    this.track_newDataTrackMenu.removeAll();
                    this.track_newDataTrackMenu.add(this.track_newDataTrackFromFileItem);
                    this.track_newDataTrackMenu.add(this.track_newDataTrackPasteItem);
                    this.track_newDataTrackMenu.addSeparator();
                    this.track_newDataTrackMenu.add(this.track_dataTrackHelpItem);
                }
            }
            if (!userTracksOnly) {
                if (p.isEnabled("new.tapeMeasure") || p.isEnabled("new.protractor") || p.isEnabled("new.circleFitter")) {
                    TMenuBar.checkAddMenuSep(menu);
                    menu.add(this.track_measuringToolsMenu);
                    this.refreshMeasuringToolsMenu(this.track_measuringToolsMenu);
                }
                if (p.isEnabled("calibration.stick") || p.isEnabled("calibration.tape") || p.isEnabled("calibration.points") || p.isEnabled("calibration.offsetOrigin")) {
                    TMenuBar.checkAddMenuSep(menu);
                    TToolBar toolbar = this.panel().getToolBar(true);
                    TToolBar.CalibrationButton calibrationButton = toolbar.calibrationButton;
                    JMenu calibrationToolsMenu = calibrationButton.getCalibrationToolsMenu();
                    calibrationToolsMenu.setText(TrackerRes.getString("TMenuBar.Menu.CalibrationTools"));
                    menu.add(calibrationToolsMenu);
                }
            }
        }
        return enabledCount;
    }

    public void refreshViewMenu(boolean opening) {
        int i;
        TrackerPanel panel = this.panel();
        if (!opening) {
            this.viewMenu.add(this.view_rightPaneItem);
            this.viewMenu.add(this.view_bottomPaneItem);
            return;
        }
        TViewChooser[] choosers = this.frame.getViewChoosers(this.panelID);
        String[] viewNames = new String[4];
        int i2 = 0;
        while (i2 < choosers.length) {
            if (choosers[i2] != null && i2 <= viewNames.length) {
                int viewType = choosers[i2].getSelectedViewType();
                viewNames[i2] = viewType == 0 ? TrackerRes.getString("PlotTView.Name") : (viewType == 1 ? TrackerRes.getString("TableTView.Name") : (viewType == 2 ? TrackerRes.getString("WorldTView.Button.World") : (viewType == 3 ? TrackerRes.getString("PageTView.Button.Page") : null)));
            }
            ++i2;
        }
        JSplitPane pane = this.frame.getSplitPane(this.panel(), 0);
        int max = pane.getMaximumDividerLocation();
        int cur = pane.getDividerLocation();
        double loc = 1.0 * (double)cur / (double)max;
        this.view_rightPaneItem.setSelected(loc < 0.99);
        String rp = TrackerRes.getString("TMenuBar.MenuItem.WindowRight");
        this.view_rightPaneItem.setText(String.valueOf(rp) + " (" + viewNames[0] + ", " + viewNames[1] + ")");
        pane = this.frame.getSplitPane(panel, 2);
        max = pane.getMaximumDividerLocation();
        cur = pane.getDividerLocation();
        loc = 1.0 * (double)cur / (double)max;
        this.view_bottomPaneItem.setSelected(loc < 0.95);
        String bp = TrackerRes.getString("TMenuBar.MenuItem.WindowBottom");
        this.view_bottomPaneItem.setText(String.valueOf(bp) + " (" + viewNames[3] + ", " + viewNames[2] + ")");
        TrackControl tc = TrackControl.getControl(panel);
        this.view_trackControlItem.setSelected(tc.isVisible());
        this.view_trackControlItem.setEnabled(!tc.isEmpty());
        this.view_notesItem.setSelected(this.frame.notesVisible());
        this.view_dataBuilderItem.setSelected(panel.dataBuilder != null && panel.dataBuilder.isVisible());
        DataTool tool = DataTool.getTool(false);
        this.view_dataToolItem.setSelected(tool != null && tool.isVisible());
        if (this.isTainted(32)) {
            i = this.viewMenu.getItemCount();
            while (--i > -1) {
                this.viewMenu.remove(i);
            }
            if (this.frame.getMaximizedView() != -1) {
                this.viewMenu.add(this.view_restoreItem);
            } else {
                this.viewMenu.add(this.view_rightPaneItem);
                this.viewMenu.add(this.view_bottomPaneItem);
            }
            this.viewMenu.addSeparator();
            this.viewMenu.add(this.view_trackControlItem);
            this.viewMenu.add(this.view_notesItem);
            if (panel.isEnabled("data.builder") || panel.isEnabled("data.tool")) {
                this.viewMenu.addSeparator();
                if (panel.isEnabled("data.builder")) {
                    this.viewMenu.add(this.view_dataBuilderItem);
                }
                if (panel.isEnabled("data.tool")) {
                    this.viewMenu.add(this.view_dataToolItem);
                }
            }
            this.tabItems = new JMenuItem[this.frame.getTabCount()];
            i = 0;
            while (i < this.tabItems.length) {
                if (i == 0) {
                    this.viewMenu.addSeparator();
                }
                this.tabItems[i] = new JRadioButtonMenuItem(this.frame.getTabTitle(i));
                this.tabItems[i].setActionCommand(String.valueOf(i));
                this.tabItems[i].setSelected(i == this.frame.getSelectedTab());
                this.tabItems[i].addActionListener(e -> {
                    int j = Integer.parseInt(e.getActionCommand());
                    this.frame.setSelectedTab(j);
                });
                this.viewMenu.add(this.tabItems[i]);
                ++i;
            }
            if (this.frame.getTabCount() == 1) {
                this.tabItems[0].setEnabled(false);
            }
            FontSizer.setMenuFonts(this.viewMenu);
            this.setMenuTainted(32, false);
        }
        i = 0;
        while (i < this.tabItems.length) {
            this.tabItems[i].setSelected(i == this.frame.getSelectedTab());
            ++i;
        }
    }

    protected void refreshHelpMenu(boolean opening) {
        if (this.isTainted(64)) {
            TMenuBar.getTrackerHelpMenu(this.panel(), this.helpMenu);
            this.setMenuTainted(64, false);
        }
    }

    protected static JMenu getTrackerHelpMenu(TrackerPanel trackerPanel, JMenu hMenu) {
        boolean showDiagnostics;
        int keyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if (hMenu == null) {
            hMenu = new JMenu();
        } else {
            hMenu.removeAll();
        }
        hMenu.setText(TrackerRes.getString("TMenuBar.Menu.Help"));
        JMenu helpMenu = hMenu;
        JMenuItem startItem = new JMenuItem(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.GettingStarted")) + "...");
        startItem.addActionListener(e -> {
            String quickStartURL = "https://www.youtube.com/watch?v=n4Eqy60yYUY";
            OSPDesktop.displayURL(quickStartURL);
        });
        helpMenu.add(startItem);
        JMenuItem helpItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.TrackerHelp"));
        helpItem.setAccelerator(KeyStroke.getKeyStroke(72, keyMask));
        helpItem.addActionListener(e -> {
            Container c = helpMenu.getTopLevelAncestor();
            if (c instanceof TFrame) {
                TFrame frame = (TFrame)c;
                frame.showHelp(null, 0);
            }
        });
        helpMenu.add(helpItem);
        JMenuItem onlineHelpItem = new JMenuItem(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.OnlineHelp")) + "...");
        onlineHelpItem.addActionListener(e -> {
            String lang = TrackerRes.locale.getLanguage();
            if ("en".equals(lang)) {
                OSPDesktop.displayURL("https://" + Tracker.trackerWebsite + "/help/frameset.html");
            } else {
                String message;
                String english = Locale.ENGLISH.getDisplayLanguage(TrackerRes.locale);
                String language = TrackerRes.locale.getDisplayLanguage(TrackerRes.locale);
                TFrame frame = trackerPanel == null ? null : trackerPanel.getTFrame();
                int response = JOptionPane.showOptionDialog(frame, message = String.valueOf(TrackerRes.getString("TMenuBar.Dialog.Translate.Message1")) + "\n" + TrackerRes.getString("TMenuBar.Dialog.Translate.Message2") + " " + language + "." + "\n" + TrackerRes.getString("TMenuBar.Dialog.Translate.Message3"), TrackerRes.getString("TMenuBar.Dialog.Translate.Title"), 1, 3, null, new String[]{english, language, TrackerRes.getString("Dialog.Button.Cancel")}, language);
                if (response == 1) {
                    String helpURL = "https://translate.google.com/translate?hl=en&sl=en&tl=" + lang + "&u=https://opensourcephysics.github.io/tracker-website/help/frameset.html";
                    OSPDesktop.displayURL(helpURL);
                } else if (response == 0) {
                    OSPDesktop.displayURL("https://" + Tracker.trackerWebsite + "/help/frameset.html");
                }
            }
        });
        helpMenu.add(onlineHelpItem);
        JMenuItem discussionHelpItem = new JMenuItem(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.ForumHelp")) + "...");
        discussionHelpItem.addActionListener(e -> {
            String helpURL = "https://www.compadre.org/osp/bulletinboard/ForumDetails.cfm?FID=57";
            OSPDesktop.displayURL(helpURL);
        });
        helpMenu.add(discussionHelpItem);
        if (!OSPRuntime.isJS && Tracker.trackerHome != null && Tracker.readmeAction != null) {
            helpMenu.add(Tracker.readmeAction);
        }
        JCheckBoxMenuItem hintsItem = new JCheckBoxMenuItem(TrackerRes.getString("Tracker.MenuItem.Hints"));
        hintsItem.setSelected(Tracker.showHints);
        hintsItem.addActionListener(e -> {
            TFrame frame;
            TrackerPanel p;
            Tracker.showHints = hintsItem.isSelected();
            Tracker.startupHintShown = false;
            Container c = helpMenu.getTopLevelAncestor();
            if (c instanceof TFrame && (p = (frame = (TFrame)c).getSelectedPanel()) != null) {
                p.setCursorForMarking(false, null);
                List<TView> views = frame.getTViews(trackerPanel.getID(), 0, null);
                int i = 0;
                while (i < views.size()) {
                    PlotTView v = (PlotTView)views.get(i);
                    TrackView trackView = v.getTrackView(v.getSelectedTrack());
                    PlotTrackView plotView = (PlotTrackView)trackView;
                    if (plotView != null) {
                        TrackPlottingPanel[] trackPlottingPanelArray = plotView.getPlots();
                        int n = trackPlottingPanelArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TrackPlottingPanel plot = trackPlottingPanelArray[n2];
                            plot.plotData();
                            ++n2;
                        }
                    }
                    ++i;
                }
            }
        });
        if (!OSPRuntime.isMac()) {
            helpMenu.addSeparator();
            helpMenu.add(hintsItem);
        }
        if (!OSPRuntime.isJS) {
            JMenuItem trackerOnlineItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.TrackerOnline"));
            trackerOnlineItem.addActionListener(e -> {
                String uRL = "https://opensourcephysics.github.io/tracker-online/";
                OSPDesktop.displayURL(uRL);
            });
            helpMenu.addSeparator();
            helpMenu.add(trackerOnlineItem);
        } else {
            JMenuItem trackerHomeItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.TrackerHome"));
            trackerHomeItem.addActionListener(e -> {
                String uRL = "https://opensourcephysics.github.io/tracker-website/";
                OSPDesktop.displayURL(uRL);
            });
            helpMenu.addSeparator();
            helpMenu.add(trackerHomeItem);
        }
        boolean bl = showDiagnostics = trackerPanel == null ? Tracker.getDefaultConfig().contains("help.diagnostics") : trackerPanel.isEnabled("help.diagnostics");
        if (showDiagnostics) {
            JMenuItem item;
            helpMenu.addSeparator();
            JMenu diagMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.Diagnostics"));
            helpMenu.add(diagMenu);
            JMenuItem logItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.MessageLog"));
            logItem.setAccelerator(KeyStroke.getKeyStroke(76, keyMask));
            logItem.addActionListener(e -> OSPLog.showLogInvokeLater());
            diagMenu.add(logItem);
            if (Tracker.startLogAction != null) {
                item = diagMenu.add(Tracker.startLogAction);
                item.setToolTipText(System.getenv("START_LOG"));
            }
            if (Tracker.trackerPrefsAction != null) {
                item = diagMenu.add(Tracker.trackerPrefsAction);
                item.setToolTipText(XML.forwardSlash(Tracker.prefsPath));
            }
            diagMenu.addSeparator();
            if (Tracker.aboutJavaAction != null) {
                diagMenu.add(Tracker.aboutJavaAction);
            }
            if (Tracker.aboutXuggleAction != null) {
                diagMenu.add(Tracker.aboutXuggleAction);
            }
            if (Tracker.aboutThreadsAction != null) {
                diagMenu.add(Tracker.aboutThreadsAction);
            }
        }
        helpMenu.addSeparator();
        if (!OSPRuntime.isJS) {
            JMenuItem checkForUpgradeItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.CheckForUpgrade.Text"));
            checkForUpgradeItem.addActionListener(e -> new Thread(() -> Tracker.showUpgradeStatus(trackerPanel)).start());
            helpMenu.add(checkForUpgradeItem);
        }
        if (Tracker.aboutTrackerAction != null) {
            helpMenu.add(Tracker.aboutTrackerAction);
        }
        FontSizer.setMenuFonts(helpMenu);
        return helpMenu;
    }

    @Override
    public void dispose() {
        TrackerPanel panel = this.panel();
        panel.removeListeners(panelProps, this);
        Video video2 = panel.getVideo();
        if (video2 != null) {
            video2.getFilterStack().removePropertyChangeListener("filter", this);
        }
        for (TTrack t : TTrack.getValues()) {
            t.removePropertyChangeListener("locked", this);
        }
        this.actions = null;
        if (this.edit_copyViewImageItems != null) {
            int i = 0;
            while (i < this.edit_copyViewImageItems.length) {
                this.edit_copyViewImageItems[i] = null;
                ++i;
            }
        }
        this.panelID = null;
        this.frame = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "filter": {
                if (this.refreshing) {
                    return;
                }
                Filter filter = (Filter)e.getOldValue();
                if (filter == null) break;
                Undo.postFilterDelete(this.panel(), filter);
                break;
            }
            case "track": {
                if (!(e.getOldValue() instanceof TTrack)) break;
                TTrack track = (TTrack)e.getOldValue();
                track.removePropertyChangeListener("locked", this);
                this.panel().setSelectedTrack(null);
                break;
            }
            case "clear": {
                for (TTrack t : TTrack.getValues()) {
                    t.removePropertyChangeListener("locked", this);
                }
                break;
            }
            default: {
                return;
            }
            case "loaded": 
            case "locked": 
            case "size": 
            case "video": 
            case "selectedpoint": 
            case "selectedtrack": 
            case "datafile": 
        }
        this.refresh("property:? " + e.getPropertyName());
    }

    protected TreeMap<Integer, TableTrackView> getDataViews() {
        TreeMap<Integer, TableTrackView> dataViews = new TreeMap<Integer, TableTrackView>();
        if (this.frame == null) {
            return dataViews;
        }
        TViewChooser[] choosers = this.frame.getVisibleChoosers(this.panel().getID());
        int i = 0;
        while (i < choosers.length) {
            TableTView tableView;
            TTrack track;
            TView tview;
            if (choosers[i] != null && (tview = choosers[i].getSelectedView()) != null && tview.getViewType() == 1 && (track = (tableView = (TableTView)tview).getSelectedTrack()) != null) {
                Step[] stepArray = track.getSteps();
                int n = stepArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableTrackView trackView;
                    Step step = stepArray[n2];
                    if (step != null && (trackView = (TableTrackView)tableView.getTrackView(track)) != null) {
                        dataViews.put(i + 1, trackView);
                    }
                    ++n2;
                }
            }
            ++i;
        }
        return dataViews;
    }

    public static void refreshPopup(TrackerPanel panel, String item, JPopupMenu menu) {
        block13: {
            TMenuBar menubar = panel.getMenuBar(false);
            if (menubar == null) break block13;
            switch (item) {
                case "TToolBar.tracks": {
                    menubar.refreshTracksPopup(menu);
                    return;
                }
                case "TrackControl.tracks": {
                    menubar.refreshTrackControlPopup(menu);
                    menubar.setMenuTainted(16, true);
                    return;
                }
                case "MainTView.popup": {
                    menubar.refreshMainTViewPopup(menu);
                }
            }
        }
    }

    public static void refreshMeasuringToolsMenu(TrackerPanel panel, JMenu menu) {
        TMenuBar menubar = panel.getMenuBar(false);
        if (menubar != null) {
            menubar.refreshMeasuringToolsMenu(menu);
        }
    }

    protected JPopupMenu refreshTrackControlPopup(JPopupMenu popup) {
        JMenu menu = new JMenu();
        boolean noTools = false;
        this.refreshTracksCreateMenu(menu, this.enabledNewTrackCount, noTools);
        FontSizer.setMenuFonts(menu);
        int n = menu.getPopupMenu().getComponentCount();
        popup.removeAll();
        int i = 0;
        while (i < n) {
            Component item = menu.getPopupMenu().getComponent(0);
            if (item != null) {
                popup.add(item);
            }
            ++i;
        }
        return popup;
    }

    protected JPopupMenu refreshTracksPopup(JPopupMenu newPopup) {
        this.refreshTrackMenu(true, newPopup);
        newPopup.removeAll();
        newPopup.add(this.track_createMenu);
        if (this.track_cloneMenu.getItemCount() > 0) {
            newPopup.add(this.track_cloneMenu);
        }
        return newPopup;
    }

    private void refreshMainTViewPopup(JPopupMenu popup) {
        if (this.panel().getVideo() != null && this.panel().isEnabled("video.filters")) {
            this.refreshVideoMenu(true);
            if (this.videoFiltersMenuItems.length > 0) {
                popup.addSeparator();
                this.popupVideoFiltersMenu.removeAll();
                this.addItems(this.popupVideoFiltersMenu, this.videoFiltersMenuItems);
                popup.add(this.popupVideoFiltersMenu);
            }
        }
        this.refreshTrackMenu(true, this.trackMenu.getPopupMenu());
        this.popupTracksMenu.removeAll();
        this.addItems(this.popupTracksMenu, this.tracksMenuItems);
        popup.addSeparator();
        popup.add(this.popupTracksMenu);
    }

    private void refreshMeasuringToolsMenu(JMenu menu) {
        menu.removeAll();
        TrackerPanel panel = this.panel();
        if (panel.isEnabled("new.tapeMeasure")) {
            menu.add(this.track_newTapeItem);
        }
        if (panel.isEnabled("new.protractor")) {
            menu.add(this.track_newProtractorItem);
        }
        if (panel.isEnabled("new.circleFitter")) {
            menu.add(this.track_newCircleFitterItem);
        }
    }

    private void addItems(JMenu menu, Component[] items) {
        int i = 0;
        while (i < items.length) {
            menu.add(items[i]);
            ++i;
        }
    }

    public void checkMatSize() {
        Rectangle mat;
        boolean isVideoSize;
        TrackerPanel panel = this.panel();
        boolean bl = isVideoSize = panel.getVideo() != null && this.edit_matSizeMenu.getMenuComponents().length == 0;
        if (!isVideoSize) {
            Component[] componentArray = this.edit_matSizeMenu.getMenuComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c == this.edit_matsize_videoSizeItem && this.edit_matsize_videoSizeItem.isSelected()) {
                    isVideoSize = true;
                }
                ++n2;
            }
        }
        if ((mat = panel.getMatBounds()) != null) {
            TToolBar toolbar;
            if (isVideoSize) {
                Dimension dim = mat.getSize();
                int vidWidth = panel.getVideo().getImage().getWidth();
                int vidHeight = panel.getVideo().getImage().getHeight();
                if (vidWidth != dim.width || vidHeight != dim.height) {
                    panel.setImageSize(vidWidth, vidHeight);
                }
            } else {
                this.panel().setImageSize(mat.width, mat.height);
            }
            if ((toolbar = panel.getToolBar(false)) != null) {
                toolbar.refreshZoomButton();
            }
        }
    }

    public static void setLangMenu(JMenu menu, final TFrame frame) {
        AbstractAction languageAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setLanguage(e.getActionCommand());
            }
        };
        menu.removeAll();
        ButtonGroup languageGroup = new ButtonGroup();
        JMenuItem selected = null;
        Locale[] locales = Tracker.getLocales();
        int i = 0;
        while (i < locales.length) {
            Locale loc = locales[i];
            String lang = OSPRuntime.getDisplayLanguage(loc);
            String co = loc.getCountry();
            if (co != null && co != "") {
                lang = String.valueOf(lang) + " (" + co + ")";
            } else if (!OSPRuntime.isJS && loc.getLanguage().equals("ko")) {
                lang = "Korean";
            }
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(lang);
            item.setActionCommand(loc.toString());
            item.addActionListener(languageAction);
            menu.add(item);
            languageGroup.add(item);
            if (loc.equals(TrackerRes.locale)) {
                selected = item;
            }
            ++i;
        }
        JMenuItem otherLanguageItem = new JMenuItem("Other");
        menu.addSeparator();
        menu.add(otherLanguageItem);
        otherLanguageItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(frame, "Do you speak a language not yet available in Tracker?\nTo learn more about translating Tracker into your language\nplease contact Douglas Brown at dobrown@cabrillo.edu.", "New Translation", 1);
            }
        });
        (selected == null ? menu.getItem(0) : selected).setSelected(true);
        FontSizer.setMenuFonts(menu);
    }

    public static void checkAddMenuSep(JMenu menu) {
        int n = menu.getItemCount();
        if (n > 0 && menu.getItem(n - 1) != null) {
            menu.addSeparator();
        }
    }

    public void dispose(TrackerPanel trackerPanel) {
        System.out.println("TMenuBar.dispose " + this.panelID);
        this.panelID = null;
        this.frame = null;
    }

    public void finalize() {
        OSPLog.finalized(this);
    }

    @Override
    public String toString() {
        return "[TMenuBar " + this.panelID + "]";
    }
}

