/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.text.JTextComponent;
import org.opensourcephysics.cabrillo.tracker.AutoTracker;
import org.opensourcephysics.cabrillo.tracker.PencilDrawer;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.Ruler;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.TrackControl;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.VectorStep;
import org.opensourcephysics.cabrillo.tracker.VectorSum;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractiveMouseHandler;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.TPoint;

public class TMouseHandler
implements InteractiveMouseHandler {
    static Cursor markPointCursor;
    static Cursor autoTrackCursor;
    static Cursor autoTrackMarkCursor;
    static final int STATE_MARK = 1;
    static final int STATE_AUTO = 2;
    static final int STATE_AUTOMARK = 3;
    Interactive iad = null;
    TPoint selectedPoint = null;
    boolean stepCreated = false;
    boolean autoTracked = false;
    boolean marking;
    TTrack selectedTrack;
    int frameNumber;
    Point mousePtRelativeToViewRect = new Point();
    Point viewLoc = new Point();
    Dimension dim = new Dimension();

    static {
        ImageIcon icon = (ImageIcon)Tracker.getResourceIcon("creatept.gif", false);
        markPointCursor = GUIUtils.createCustomCursor(icon.getImage(), new Point(8, 8), TrackerRes.getString("Tracker.Cursor.Crosshair.Description"), 13);
        icon = (ImageIcon)Tracker.getResourceIcon("autotrack.gif", false);
        autoTrackCursor = GUIUtils.createCustomCursor(icon.getImage(), new Point(9, 9), TrackerRes.getString("PointMass.Cursor.Autotrack.Description"), 13);
        icon = (ImageIcon)Tracker.getResourceIcon("autotrack_mark.gif", false);
        autoTrackMarkCursor = GUIUtils.createCustomCursor(icon.getImage(), new Point(9, 9), TrackerRes.getString("Tracker.Cursor.Autotrack.Keyframe.Description"), 13);
    }

    @Override
    public void handleMouseAction(InteractivePanel panel, MouseEvent e) {
        if (!(panel instanceof TrackerPanel)) {
            return;
        }
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        if (OSPRuntime.isPopupTrigger(e) || panel.getZoomBox().isVisible()) {
            this.iad = null;
            return;
        }
        if (!trackerPanel.isDrawingInImageSpace()) {
            return;
        }
        if (PencilDrawer.isDrawing(trackerPanel)) {
            PencilDrawer.getDrawer(trackerPanel).handleMouseAction(e);
            return;
        }
        KeyboardFocusManager focuser = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = focuser.getFocusOwner();
        AutoTracker autoTracker = trackerPanel.getAutoTracker(false);
        if (autoTracker != null && autoTracker.getTrack() == null) {
            autoTracker.setTrack(trackerPanel.getSelectedTrack());
        }
        switch (trackerPanel.getMouseAction()) {
            case 7: {
                Step step;
                this.selectedTrack = trackerPanel.getSelectedTrack();
                this.frameNumber = trackerPanel.getFrameNumber();
                this.iad = trackerPanel.getInteractive();
                boolean invertCursor = e.isShiftDown();
                this.marking = trackerPanel.setCursorForMarking(invertCursor, e);
                if (this.selectedTrack != null && this.marking != this.selectedTrack.isMarking) {
                    this.selectedTrack.setMarking(this.marking);
                }
                if (this.marking) {
                    this.iad = null;
                    if (this.selectedTrack != null && this.selectedTrack.ttype == 8) {
                        TapeMeasure tape = (TapeMeasure)this.selectedTrack;
                        if (tape.isIncomplete) {
                            tape.createStep(this.frameNumber, 0.0, 0.0, trackerPanel.getMouseX(), trackerPanel.getMouseY());
                        }
                    }
                }
                if (this.selectedTrack != null && autoTracker != null && autoTracker.getWizard().isVisible() && autoTracker.getTrack() == this.selectedTrack && (step = this.selectedTrack.getStep(this.frameNumber)) != null) {
                    this.selectedTrack.repaintStep(step);
                }
                if (!OSPRuntime.outOfMemory) break;
                TToolBar.refreshMemoryButton(trackerPanel);
                break;
            }
            case 1: {
                if (Tracker.startupHintShown) {
                    Tracker.startupHintShown = false;
                    trackerPanel.setMessage("");
                }
                TrackControl.getControl((TrackerPanel)trackerPanel).popup.setVisible(false);
                boolean bl = this.marking = this.selectedTrack != null && trackerPanel.getCursor() == this.selectedTrack.getMarkingCursor(e);
                if (this.marking) {
                    this.markPoint(trackerPanel, e, autoTracker);
                    return;
                }
                if (this.iad instanceof TPoint) {
                    this.selectPoint(trackerPanel, e);
                    return;
                }
                this.clearInteractive(trackerPanel, e);
                return;
            }
            case 3: {
                this.selectedPoint = trackerPanel.getSelectedPoint();
                TTrack track = trackerPanel.getSelectedTrack();
                if (this.selectedPoint != null) {
                    int dx = 0;
                    int dy = 0;
                    if (track != null && track.isLocked() && !(track instanceof VectorSum)) {
                        Toolkit.getDefaultToolkit().beep();
                        OSPLog.finer(track + " is locked");
                        return;
                    }
                    this.selectedPoint.setAdjusting(true, e);
                    Point scrPt = this.selectedPoint.getScreenPosition(trackerPanel);
                    dx = e.getX() - scrPt.x;
                    dy = e.getY() - scrPt.y;
                    this.selectedPoint.setScreenPosition(e.getX(), e.getY(), trackerPanel, e);
                    this.selectedPoint.showCoordinates(trackerPanel);
                    trackerPanel.selectedSteps.setChanged(true);
                    for (Step step : trackerPanel.selectedSteps) {
                        this.selectedPoint = step.points[0];
                        if (this.selectedPoint == trackerPanel.getSelectedPoint()) continue;
                        this.selectedPoint.setAdjusting(true, e);
                        scrPt = this.selectedPoint.getScreenPosition(trackerPanel);
                        this.selectedPoint.setScreenPosition(scrPt.x + dx, scrPt.y + dy, trackerPanel, e);
                    }
                } else if (!Tracker.isZoomInCursor(trackerPanel.getCursor()) && !Tracker.isZoomOutCursor(trackerPanel.getCursor())) {
                    Rectangle rect = trackerPanel.scrollPane.getViewport().getViewRect();
                    trackerPanel.scrollPane.getViewport().getView().getSize(this.dim);
                    int dx = this.mousePtRelativeToViewRect.x - e.getPoint().x + rect.x;
                    int dy = this.mousePtRelativeToViewRect.y - e.getPoint().y + rect.y;
                    int x = Math.max(0, this.viewLoc.x + dx);
                    x = Math.min(x, this.dim.width - rect.width);
                    int y = Math.max(0, this.viewLoc.y + dy);
                    y = Math.min(y, this.dim.height - rect.height);
                    if (x != rect.x || y != rect.y) {
                        trackerPanel.setMouseCursor(Tracker.grabCursor);
                        rect.x = x;
                        rect.y = y;
                        trackerPanel.scrollRectToVisible(rect);
                    } else {
                        this.viewLoc.setLocation(rect.getLocation());
                        this.mousePtRelativeToViewRect.setLocation(e.getPoint().x - rect.x, e.getPoint().y - rect.y);
                    }
                }
                if (trackerPanel.getSelectedStep() != null) break;
                TFrame.repaintT(trackerPanel);
                break;
            }
            case 2: {
                Cursor c = trackerPanel.getCursor();
                if (!Tracker.isZoomInCursor(c) && !Tracker.isZoomOutCursor(c)) {
                    trackerPanel.setMouseCursor(Cursor.getDefaultCursor());
                }
                trackerPanel.requestFocusInWindow();
                this.selectedPoint = trackerPanel.getSelectedPoint();
                if (this.selectedPoint != null) {
                    this.selectedPoint.setAdjusting(false, e);
                    if (this.selectedPoint instanceof VectorStep.Handle) {
                        ((VectorStep.Handle)this.selectedPoint).snap(trackerPanel);
                    }
                }
                if (this.stepCreated && this.selectedTrack != null && this.selectedTrack.isAutoAdvance()) {
                    trackerPanel.getPlayer().step();
                    trackerPanel.hideMouseBox();
                    this.stepCreated = false;
                }
                this.autoTracked = false;
                break;
            }
            case 5: {
                if (focusOwner == null || focusOwner instanceof JTextComponent) break;
                trackerPanel.requestFocusInWindow();
            }
        }
    }

    private void clearInteractive(TrackerPanel trackerPanel, MouseEvent e) {
        if (trackerPanel.getSelectedPoint() != null) {
            trackerPanel.setSelectedPoint(null);
        }
        TTrack[] tracks = trackerPanel.selectedSteps.getTracks();
        for (Step step : trackerPanel.selectedSteps) {
            step.erase();
        }
        trackerPanel.selectedSteps.clear();
        TTrack[] tTrackArray = tracks;
        int n = tracks.length;
        int n2 = 0;
        while (n2 < n) {
            TTrack next = tTrackArray[n2];
            next.fireStepsChanged();
            ++n2;
        }
        if (!trackerPanel.isShowCoordinates()) {
            trackerPanel.hideMouseBox();
            trackerPanel.setMouseCursor(Cursor.getDefaultCursor());
        }
        if (e.getClickCount() == 2) {
            trackerPanel.setSelectedTrack(null);
        }
        Rectangle rect = trackerPanel.scrollPane.getViewport().getViewRect();
        this.viewLoc.setLocation(rect.getLocation());
        this.mousePtRelativeToViewRect.setLocation(e.getPoint().x - rect.x, e.getPoint().y - rect.y);
        trackerPanel.scrollPane.getViewport().getView().getSize(this.dim);
        Cursor c = trackerPanel.getCursor();
        if (!(this.dim.width <= rect.width && this.dim.height <= rect.height || Tracker.isZoomInCursor(c) || Tracker.isZoomOutCursor(c))) {
            trackerPanel.setMouseCursor(Tracker.grabCursor);
        }
    }

    private void selectPoint(TrackerPanel trackerPanel, MouseEvent e) {
        this.selectedPoint = (TPoint)this.iad;
        Step step = null;
        TTrack stepTrack = null;
        for (TTrack track : trackerPanel.getTracksTemp()) {
            step = track.getStep(this.selectedPoint, trackerPanel);
            if (step == null) continue;
            stepTrack = track;
            break;
        }
        trackerPanel.clearTemp();
        boolean isStepSelected = trackerPanel.selectedSteps.contains(step);
        boolean selectedStepsChanged = false;
        if (e.isControlDown()) {
            if (isStepSelected) {
                this.selectedPoint = null;
                trackerPanel.selectedSteps.remove(step);
                selectedStepsChanged = true;
            } else {
                if (!trackerPanel.selectedSteps.isEmpty()) {
                    this.selectedPoint = null;
                }
                trackerPanel.selectedSteps.add(step);
                selectedStepsChanged = true;
            }
        } else if (!trackerPanel.selectedSteps.contains(step)) {
            boolean stepsIncludeSelectedPoint = false;
            for (Step next : trackerPanel.selectedSteps) {
                next.erase();
                boolean bl = stepsIncludeSelectedPoint = stepsIncludeSelectedPoint || next.getPoints()[0] == trackerPanel.getSelectedPoint();
            }
            trackerPanel.selectedSteps.clear();
            trackerPanel.selectedSteps.add(step);
            selectedStepsChanged = true;
            if (stepsIncludeSelectedPoint) {
                trackerPanel.pointState.setLocation(trackerPanel.getSelectedPoint());
            }
        }
        if (selectedStepsChanged && stepTrack != null) {
            stepTrack.firePropertyChange("steps", TTrack.HINT_STEPS_SELECTED, null);
        }
        if (step != null) {
            step.erase();
        }
        if (this.selectedPoint instanceof AutoTracker.Handle) {
            ((AutoTracker.Handle)this.selectedPoint).setScreenLocation(e.getX(), e.getY(), trackerPanel);
        } else if (this.selectedPoint instanceof Ruler.Handle) {
            ((Ruler.Handle)this.selectedPoint).setScreenLocation(e.getX(), e.getY(), trackerPanel);
        }
        if (this.selectedPoint != null) {
            this.selectedPoint.setAdjusting(true, e);
            this.selectedPoint.showCoordinates(trackerPanel);
            trackerPanel.setSelectedPoint(this.selectedPoint);
        }
        if (this.selectedPoint instanceof Step.Handle) {
            ((Step.Handle)this.selectedPoint).setPositionOnLine(e.getX(), e.getY(), trackerPanel);
        }
    }

    private void markPoint(TrackerPanel trackerPanel, MouseEvent e, AutoTracker autoTracker) {
        int index;
        this.iad = null;
        boolean autotrackEneabled = trackerPanel.isEnabled("track.autotrack");
        boolean autotrackTrigger = autotrackEneabled && AutoTracker.isAutoTrackTrigger(e) && this.selectedTrack.isAutoTrackable() && trackerPanel.getVideo() != null;
        AutoTracker.KeyFrameData keyFrameData = autotrackTrigger ? this.getActiveKeyFrame(autoTracker) : null;
        this.frameNumber = trackerPanel.getFrameNumber();
        Step step = this.selectedTrack.getStep(this.frameNumber);
        int nextIndex = index = this.selectedTrack.getTargetIndex();
        if (step == null || !autotrackTrigger) {
            if (autotrackTrigger) {
                this.selectedTrack.autoMarkAt(this.frameNumber, trackerPanel.getMouseX(), trackerPanel.getMouseY());
                step = this.selectedTrack.getStep(this.frameNumber);
            } else {
                PointMass m;
                boolean newStep;
                boolean bl = newStep = step == null;
                if (this.selectedTrack.ttype == 5) {
                    this.selectedTrack.keyFrames.add(this.frameNumber);
                }
                step = this.selectedTrack.createStep(this.frameNumber, trackerPanel.getMouseX(), trackerPanel.getMouseY());
                if (this.selectedTrack.ttype == 5 && (m = (PointMass)this.selectedTrack).isAutofill()) {
                    m.markInterpolatedSteps((PositionStep)step, true);
                }
                trackerPanel.newlyMarkedPoint = step.getDefaultPoint();
                TPoint[] pts = step.getPoints();
                if (newStep && pts.length > index + 1) {
                    nextIndex = index + 1;
                }
            }
        } else if (step.getPoints()[index] == null) {
            if (keyFrameData != null) {
                AutoTracker.Target target = keyFrameData.getTarget();
                ((TPoint)target).setXY(trackerPanel.getMouseX(), trackerPanel.getMouseY());
            }
            this.selectedTrack.autoMarkAt(this.frameNumber, trackerPanel.getMouseX(), trackerPanel.getMouseY());
            TPoint[] pts = step.getPoints();
            if (pts.length > index + 1) {
                nextIndex = index + 1;
            }
        }
        if (autotrackTrigger && step != null && step.getPoints()[index] != null) {
            TPoint target = step.getPoints()[index];
            if (autoTracker == null) {
                autoTracker = trackerPanel.getAutoTracker(true);
                autoTracker.setTrack(trackerPanel.getSelectedTrack());
            }
            if (autoTracker.getTrack() == this.selectedTrack) {
                switch (this.selectedTrack.ttype) {
                    case 2: 
                    case 6: 
                    case 8: 
                    case 10: {
                        if (autoTracker.getOrCreateFrameData(this.frameNumber).getKeyFrameData() != null) break;
                        target.setXY(trackerPanel.getMouseX(), trackerPanel.getMouseY());
                    }
                }
            }
            autoTracker.addKeyFrame(target, trackerPanel.getMouseX(), trackerPanel.getMouseY());
            trackerPanel.refreshTrackBar();
        }
        if (step != null && !autotrackTrigger) {
            trackerPanel.setMouseCursor(Cursor.getPredefinedCursor(12));
            trackerPanel.setSelectedPoint(step.getDefaultPoint());
            this.selectedTrack.repaintStep(step);
            this.selectedPoint = trackerPanel.getSelectedPoint();
            this.iad = this.selectedPoint;
            this.stepCreated = keyFrameData == null;
        }
        this.selectedTrack.setTargetIndex(nextIndex);
        if (autoTracker != null && autoTracker.getWizard().isVisible()) {
            autoTracker.getWizard().refreshGUI();
        }
    }

    protected AutoTracker.KeyFrameData getActiveKeyFrame(AutoTracker autoTracker) {
        AutoTracker.FrameData frameData;
        return this.selectedTrack != null && autoTracker != null && this.selectedTrack == autoTracker.getTrack() && autoTracker.getWizard().isVisible() && (frameData = autoTracker.getOrCreateFrameData(this.frameNumber)).getKeyFrameData() == frameData ? (AutoTracker.KeyFrameData)frameData : null;
    }
}

