/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import org.opensourcephysics.media.core.TPoint;

public class TRegion
extends Polygon {
    private float brightLimit = 0.5f;
    private int width;
    private int height;
    private int w = 100;
    private int h = 100;
    private int[] pixels;
    private float[] hsb = new float[3];
    private int x0;
    private int y0;

    public TRegion(BufferedImage image, int x0, int y0) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.pixels = new int[this.width * this.height];
        image.getRaster().getDataElements(0, 0, this.width, this.height, this.pixels);
        this.x0 = x0;
        this.y0 = y0;
        this.findEdge();
    }

    public TPoint getCenter() {
        if (this.npoints == 0) {
            return null;
        }
        double x = this.getBounds2D().getCenterX();
        double y = this.getBounds2D().getCenterY();
        return new TPoint(x, y);
    }

    public void findEdge() {
        boolean foundEdge = false;
        boolean foundInside = false;
        boolean moveUp = false;
        int x = this.x0;
        int y = this.y0;
        int rightLimit = Math.min(this.width, this.x0 + this.w / 2);
        int leftLimit = Math.max(0, this.x0 - this.w / 2);
        int topLimit = Math.max(0, this.y0 - this.h / 2);
        int bottomLimit = Math.min(this.height, this.y0 + this.h / 2);
        int n = 1;
        while (!foundInside) {
            if (y <= topLimit || y >= bottomLimit) break;
            if (this.isInside(x, y)) {
                foundInside = true;
            }
            if (foundInside) continue;
            if (x < rightLimit) {
                ++x;
                continue;
            }
            if (moveUp) {
                y = this.y0 - n;
                moveUp = false;
            } else {
                y = this.y0 + n;
                moveUp = true;
                ++n;
            }
            x = leftLimit;
        }
        while (foundInside && x >= leftLimit) {
            if (this.isInside(--x, y)) continue;
            ++x;
            foundEdge = true;
            break;
        }
        if (foundEdge) {
            this.reset();
            this.traceEdge(x, y, 'U');
        }
    }

    private boolean isInside(int x, int y) {
        int pixel = this.pixels[y * this.w + x];
        int r = pixel >> 16 & 0xFF;
        int g = pixel >> 8 & 0xFF;
        int b = pixel & 0xFF;
        Color.RGBtoHSB(r, g, b, this.hsb);
        return this.hsb[2] >= this.brightLimit;
    }

    private void traceEdge(int x, int y, char startingDirection) {
        int newDirection;
        char[] table = new char[]{'X', 'R', 'D', 'R', 'U', 'U', 'u', 'U', 'L', 'l', 'D', 'R', 'L', 'L', 'D', 'X'};
        int direction = startingDirection;
        int hloc = x;
        int vloc = y;
        boolean UL = this.isInside(hloc - 1, vloc - 1);
        boolean UR = this.isInside(hloc, vloc - 1);
        boolean LL = this.isInside(hloc - 1, vloc);
        boolean LR = this.isInside(hloc, vloc);
        this.addPoint(hloc, vloc);
        do {
            int index = 0;
            if (LR) {
                index |= 1;
            }
            if (LL) {
                index |= 2;
            }
            if (UR) {
                index |= 4;
            }
            if (UL) {
                index |= 8;
            }
            if ((newDirection = table[index]) == 117) {
                newDirection = direction == 82 ? 85 : 68;
            }
            if (newDirection == 108) {
                newDirection = direction == 85 ? 76 : 82;
            }
            switch (newDirection) {
                case 85: {
                    LL = UL;
                    LR = UR;
                    UL = this.isInside(hloc - 1, --vloc - 1);
                    UR = this.isInside(hloc, vloc - 1);
                    break;
                }
                case 68: {
                    UL = LL;
                    UR = LR;
                    LL = this.isInside(hloc - 1, ++vloc);
                    LR = this.isInside(hloc, vloc);
                    break;
                }
                case 76: {
                    UR = UL;
                    LR = LL;
                    UL = this.isInside(--hloc - 1, vloc - 1);
                    LL = this.isInside(hloc - 1, vloc);
                    break;
                }
                case 82: {
                    UL = UR;
                    LL = LR;
                    UR = this.isInside(++hloc, vloc - 1);
                    LR = this.isInside(hloc, vloc);
                }
            }
            this.addPoint(hloc, vloc);
        } while ((direction = newDirection) != 88 && (hloc != x || vloc != y || direction != startingDirection));
    }
}

