/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.opensourcephysics.cabrillo.tracker.ArrowFootprint;
import org.opensourcephysics.cabrillo.tracker.AutoTracker;
import org.opensourcephysics.cabrillo.tracker.Calibration;
import org.opensourcephysics.cabrillo.tracker.CenterOfMass;
import org.opensourcephysics.cabrillo.tracker.CircleFitter;
import org.opensourcephysics.cabrillo.tracker.CircleFitterStep;
import org.opensourcephysics.cabrillo.tracker.CoordAxes;
import org.opensourcephysics.cabrillo.tracker.DynamicSystem;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.MainTView;
import org.opensourcephysics.cabrillo.tracker.OffsetOrigin;
import org.opensourcephysics.cabrillo.tracker.PageTView;
import org.opensourcephysics.cabrillo.tracker.PencilDrawer;
import org.opensourcephysics.cabrillo.tracker.PencilScene;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.RGBRegion;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TMenuBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TTrackBar;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.TrackControl;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Vector;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.media.core.ClipInspector;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ResourceLoader;

public class TToolBar
extends JToolBar
implements OSPRuntime.Disposable,
PropertyChangeListener {
    protected static final int[] trailLengths;
    protected static final String[] trailLengthNames;
    protected static final Icon newTrackIcon;
    protected static final Icon pointmassOffIcon;
    protected static final Icon pointmassOnIcon;
    protected static final Icon trackControlIcon;
    protected static final Icon trackControlOnIcon;
    protected static final Icon trackControlDisabledIcon;
    protected static final Icon zoomIcon;
    protected static final Icon clipOffIcon;
    protected static final Icon clipOnIcon;
    protected static final Icon axesOffIcon;
    protected static final Icon axesOnIcon;
    protected static final Icon calibrationToolsOffIcon;
    protected static final Icon calibrationToolsOnIcon;
    protected static final Icon calibrationOnlyIcon;
    protected static final Icon rulerOnlyIcon;
    protected static final Icon calibrationToolsOffRolloverIcon;
    protected static final Icon calibrationToolsOnRolloverIcon;
    protected static final Icon eyeIcon;
    protected static final Icon rulerIcon;
    protected static final Icon rulerOnIcon;
    protected static final Icon rulerRolloverIcon;
    protected static final Icon rulerOnRolloverIcon;
    protected static final Icon pointsOffIcon;
    protected static final Icon pointsOnIcon;
    protected static final Icon velocOffIcon;
    protected static final Icon velocOnIcon;
    protected static final Icon accelOffIcon;
    protected static final Icon accelOnIcon;
    protected static final Icon traceOffIcon;
    protected static final Icon traceOnIcon;
    protected static final Icon labelsOffIcon;
    protected static final Icon labelsOnIcon;
    protected static final Icon stretchOffIcon;
    protected static final Icon stretchOnIcon;
    protected static final Icon xmassOffIcon;
    protected static final Icon xmassOnIcon;
    protected static final Icon fontSizeIcon;
    protected static final Icon memoryIcon;
    protected static final Icon redMemoryIcon;
    protected static final Icon autotrackerOffIcon;
    protected static final Icon autotrackerOnIcon;
    protected static final Icon infoIcon;
    protected static final Icon infoOnIcon;
    protected static final Icon refreshIcon;
    protected static final Icon htmlIcon;
    protected static final Icon htmlDisabledIcon;
    protected static final Icon[] trailIcons;
    protected static final int[] stretchValues;
    protected static final Icon separatorIcon;
    protected static final Icon pencilOffIcon;
    protected static final Icon pencilOnIcon;
    protected static final Icon pencilOffRolloverIcon;
    protected static final Icon pencilOnRolloverIcon;
    protected static final Icon pencilIcon;
    protected static final NumberFormat zoomFormat;
    protected static final int wideIconWidth = 28;
    protected static final int wideIconDivider = 18;
    public static final String REFRESH_PAGETVIEW_TABS = "PageTView.tabs";
    public static final String REFRESH_PAGETVIEW_TITLE = "PageTView.title";
    public static final String REFRESH_PAGETVIEW_URL = "PageTView.url";
    public static final String REFRESH_LINEPROFILE = "LineProfile";
    public static final String REFRESH_TFRAME_LOCALE = "TFrame.locale";
    public static final String REFRESH_TFRAME_LOCALE2 = "TFrame.locale2 ??";
    protected static final String REFRESH__CLIP_SETTINGS_HIDDEN = "clip settings hidden";
    protected static final String REFRESH__CLIP_SETTINGS_SHOWN = "clip settings shown";
    private static final String REFRESH__PROPERTY_VIDEO = "property video";
    private static final String REFRESH__PROPERTY_SELECTED_TRACK = "property selected track";
    protected static final String REFRESH__NEW_VERSION = "new version";
    public static final String REFRESH_PREFS_TRUE = "PrefsDialog";
    public static final String REFRESH_TFRAME_REFRESH_TRUE = "TFrame.refresh";
    protected static final String REFRESH__REFRESH_ACTION_TRUE = "refresh action";
    protected static final String REFRESH__TRAIL_BUTTON_ACTION_TRUE = "trail button action";
    protected static final String REFRESH__VSTRETCH_ACTION_TRUE = "vstretch action";
    protected static final String REFRESH__ASTRETCH_ACTION_TRUE = "astretch action";
    protected static final String REFRESH__STRETCHOFF_ACTION_TRUE = "stretchoff action";
    private static final String REFRESH__CREATE_GUI_TRUE = "create gui";
    private static final String REFRESH__PROPERTY_TRACK_TRUE = "property track";
    private static final String REFRESH__PROPERTY_CLEAR_TRUE = "property track clear";
    private static final String BUTTON_OPEN = "Open";
    private static final String BUTTON_SAVE = "Save";
    private static final String BUTTON_CLIP = "ClipSettings";
    private static final String BUTTON_CALIBRATION = "CalibrationTools";
    private static final String BUTTON_AXES = "Axes";
    private static final String BUTTON_MEASURE = "MeasuringTools";
    private static final String BUTTON_TRACK_CONTROL = "TrackControl";
    private static final String BUTTON_AUTOTRACKER = "Autotracker";
    private static final String BUTTON_TRACK_DISPLAY = "TrackDisplay";
    private static final String BUTTON_ZOOM = "Zoom";
    private static final String BUTTON_DRAWINGS = "Drawings";
    private static final String BUTTON_NOTES = "Notes";
    private static final String BUTTON_MEMORY = "Memory";
    private static final String BUTTON_REFRESH = "Refresh";
    private static final String BUTTON_DESKTOP = "SupportDocs";
    private static final String BUTTON_MAXIMIZE = "Maximize";
    protected final WindowListener infoListener;
    protected final JButton openButton;
    protected final JButton saveButton;
    protected final TButton newTrackButton;
    protected final JButton trackControlButton;
    protected final JButton clipSettingsButton;
    protected final CalibrationButton calibrationButton;
    protected final RulerButton rulerButton;
    protected final DrawingButton drawingButton;
    protected final TButton axesButton;
    protected final TButton zoomButton;
    protected final TButton autotrackerButton;
    protected final TButton eyeButton;
    protected final TButton traceVisButton;
    protected final TButton pVisButton;
    protected final TButton vVisButton;
    protected final TButton aVisButton;
    protected final TButton xMassButton;
    protected final TButton trailButton;
    protected final TButton labelsButton;
    protected final TButton stretchButton;
    protected JMenuItem pathVisMenuItem;
    protected JMenuItem pVisMenuItem;
    protected JMenuItem vVisMenuItem;
    protected JMenuItem aVisMenuItem;
    protected JMenuItem xMassMenuItem;
    protected JMenuItem labelsMenuItem;
    protected JMenu trailsMenu;
    protected JMenu stretchMenu;
    protected final JButton fontSizeButton;
    protected final JPopupMenu newPopup = new JPopupMenu();
    protected final JPopupMenu selectPopup = new JPopupMenu();
    protected final JPopupMenu eyePopup = new JPopupMenu();
    protected final JPopupMenu zoomPopup = new JPopupMenu();
    protected final JMenu vStretchMenu;
    protected final JMenu aStretchMenu;
    protected ButtonGroup vGroup;
    protected ButtonGroup aGroup;
    protected final JMenuItem showTrackControlItem;
    protected final JMenuItem selectNoneItem;
    protected final JMenuItem stretchOffItem;
    protected final JButton notesButton;
    protected final JButton refreshButton;
    protected final JButton desktopButton;
    protected final JButton memoryButton;
    protected final JButton maximizeButton;
    protected final Component toolbarFiller;
    protected final JMenu cloneMenu;
    protected final ArrayList<PageTView.TabData> pageViewTabs = new ArrayList();
    protected int overflowIndex = -1;
    protected JPopupMenu overflowPopup;
    protected TButton overflowButton;
    protected JMenu rulerMenu;
    protected JMenu refreshMenu;
    protected JMenu memoryMenu;
    protected JMenu desktopMenu;
    protected JMenu zoomMenu;
    protected JMenu drawingMenu;
    protected JMenu calibrationMenu;
    protected JMenu eyeMenu;
    protected JMenu openMenu;
    protected JMenu saveMenu;
    protected JCheckBoxMenuItem trackControlCheckbox;
    protected JCheckBoxMenuItem notesCheckbox;
    protected JCheckBoxMenuItem maximizeCheckbox;
    protected JCheckBoxMenuItem axesCheckbox;
    protected JCheckBoxMenuItem autotrackerCheckbox;
    protected JCheckBoxMenuItem clipCheckbox;
    protected JCheckBoxMenuItem drawingControlCheckbox;
    protected ArrayList<JButton> overflowButtons;
    protected boolean refreshing;
    protected boolean useEyeButton = true;
    private boolean refreshingTracks;
    protected int vStretch = 1;
    protected int aStretch = 1;
    protected int trailLengthIndex = Tracker.preferredTrailLengthIndex;
    protected boolean notYetCalibrated = true;
    protected int toolbarComponentHeight;
    private AbstractAction zoomAction;
    private TFrame frame;
    private Integer panelID;
    private static final String[] panelProps;
    private Timer refreshTimer;
    private boolean disposed;
    private int enabledCount;
    private boolean allowRebuild = true;

    static {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[2] = 15;
        trailLengths = nArray;
        trailLengthNames = new String[]{"none", "short", "long", "full"};
        trailIcons = new Icon[4];
        stretchValues = new int[]{1, 2, 3, 4, 6, 8, 12, 16, 24, 32};
        zoomFormat = NumberFormat.getNumberInstance();
        newTrackIcon = Tracker.getResourceIcon("poof.gif", true);
        pointmassOffIcon = Tracker.getResourceIcon("track_off.gif", true);
        pointmassOnIcon = Tracker.getResourceIcon("track_on.gif", true);
        trackControlIcon = Tracker.getResourceIcon("track_control.gif", true);
        trackControlOnIcon = Tracker.getResourceIcon("track_control_on.gif", true);
        trackControlDisabledIcon = Tracker.getResourceIcon("track_control_disabled.gif", true);
        zoomIcon = Tracker.getResourceIcon("zoom.gif", true);
        clipOffIcon = Tracker.getResourceIcon("clip_off.gif", true);
        clipOnIcon = Tracker.getResourceIcon("clip_on.gif", true);
        axesOffIcon = Tracker.getResourceIcon("axes.gif", true);
        axesOnIcon = Tracker.getResourceIcon("axes_on.gif", true);
        calibrationOnlyIcon = Tracker.getResourceIcon("calibration_tool_alone.gif", true);
        calibrationToolsOffIcon = Tracker.getResourceIcon("calibration_tool.gif", true);
        calibrationToolsOnIcon = Tracker.getResourceIcon("calibration_tool_on.gif", true);
        calibrationToolsOffRolloverIcon = Tracker.getResourceIcon("calibration_tool_rollover.gif", true);
        calibrationToolsOnRolloverIcon = Tracker.getResourceIcon("calibration_tool_on_rollover.gif", true);
        eyeIcon = Tracker.getResourceIcon("eye.gif", true);
        rulerOnlyIcon = Tracker.getResourceIcon("ruler_alone.gif", true);
        rulerIcon = Tracker.getResourceIcon("ruler.gif", true);
        rulerOnIcon = Tracker.getResourceIcon("ruler_on.gif", true);
        rulerRolloverIcon = Tracker.getResourceIcon("ruler_rollover.gif", true);
        rulerOnRolloverIcon = Tracker.getResourceIcon("ruler_on_rollover.gif", true);
        pointsOffIcon = Tracker.getResourceIcon("positions.gif", true);
        pointsOnIcon = Tracker.getResourceIcon("positions_on.gif", true);
        velocOffIcon = Tracker.getResourceIcon("velocities.gif", true);
        velocOnIcon = Tracker.getResourceIcon("velocities_on.gif", true);
        accelOffIcon = Tracker.getResourceIcon("accel.gif", true);
        accelOnIcon = Tracker.getResourceIcon("accel_on.gif", true);
        traceOffIcon = Tracker.getResourceIcon("trace.gif", true);
        traceOnIcon = Tracker.getResourceIcon("trace_on.gif", true);
        labelsOffIcon = Tracker.getResourceIcon("labels.gif", true);
        labelsOnIcon = Tracker.getResourceIcon("labels_on.gif", true);
        stretchOffIcon = Tracker.getResourceIcon("stretch.gif", true);
        stretchOnIcon = Tracker.getResourceIcon("stretch_on.gif", true);
        xmassOffIcon = Tracker.getResourceIcon("x_mass.gif", true);
        xmassOnIcon = Tracker.getResourceIcon("x_mass_on.gif", true);
        fontSizeIcon = Tracker.getResourceIcon("font_size.gif", true);
        autotrackerOffIcon = Tracker.getResourceIcon("autotrack_off.gif", true);
        autotrackerOnIcon = Tracker.getResourceIcon("autotrack_on.gif", true);
        infoIcon = Tracker.getResourceIcon("info.gif", true);
        infoOnIcon = Tracker.getResourceIcon("info_on.gif", true);
        refreshIcon = Tracker.getResourceIcon("refresh.gif", true);
        memoryIcon = Tracker.getResourceIcon("memory.gif", true);
        redMemoryIcon = Tracker.getResourceIcon("memory_red.gif", true);
        htmlIcon = Tracker.getResourceIcon("html.gif", true);
        htmlDisabledIcon = Tracker.getResourceIcon("html_disabled.gif", true);
        TToolBar.trailIcons[0] = Tracker.getResourceIcon("trails_off.gif", true);
        TToolBar.trailIcons[1] = Tracker.getResourceIcon("trails_1.gif", true);
        TToolBar.trailIcons[2] = Tracker.getResourceIcon("trails_2.gif", true);
        TToolBar.trailIcons[3] = Tracker.getResourceIcon("trails_on.gif", true);
        separatorIcon = Tracker.getResourceIcon("separator.gif", true);
        pencilIcon = Tracker.getResourceIcon("pencil_only.gif", true);
        pencilOffIcon = Tracker.getResourceIcon("pencil_off.gif", true);
        pencilOnIcon = Tracker.getResourceIcon("pencil_on.gif", true);
        pencilOffRolloverIcon = Tracker.getResourceIcon("pencil_off_rollover.gif", true);
        pencilOnRolloverIcon = Tracker.getResourceIcon("pencil_on_rollover.gif", true);
        zoomFormat.setMaximumFractionDigits(0);
        panelProps = new String[]{"selectedpoint", "selectedtrack", "track", "clear", "video", "magnification"};
    }

    TToolBar(TrackerPanel panel) {
        this.frame = panel.getTFrame();
        this.panelID = panel.getID();
        System.out.println("Creating toolbar for " + panel);
        panel.addListeners(panelProps, this);
        this.setFloatable(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                TToolBar.this.rebuild(-1);
            }
        });
        this.overflowButtons = new ArrayList();
        Map<String, AbstractAction> actions = panel.getActions();
        this.openButton = new TButton(){

            @Override
            protected JPopupMenu getPopup() {
                return TToolBar.this.refreshOpenPopup(null);
            }
        };
        this.openButton.setIcon(Tracker.getResourceIcon("open.gif", true));
        this.openButton.setName(BUTTON_OPEN);
        this.saveButton = new TButton(){

            @Override
            protected JPopupMenu getPopup() {
                return TToolBar.this.refreshSavePopup(null);
            }
        };
        this.saveButton.setIcon(Tracker.getResourceIcon("save.gif", true));
        this.saveButton.setName(BUTTON_SAVE);
        this.saveButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                String fileName = TToolBar.this.panel().getTitle();
                String extension = XML.getExtension(fileName);
                if (extension == null || !extension.equals("trk")) {
                    fileName = String.valueOf(XML.stripExtension(fileName)) + ".trk";
                }
                TToolBar.this.saveButton.setToolTipText(TrackerRes.getString("TToolBar.Button.Save.Tooltip"));
            }
        });
        this.clipSettingsButton = new TButton(clipOffIcon, clipOnIcon);
        this.clipSettingsButton.addActionListener(e -> this.panel().setClipSettingsVisible(null));
        this.clipSettingsButton.setName(BUTTON_CLIP);
        this.axesButton = new TButton(axesOffIcon, axesOnIcon);
        this.axesButton.addActionListener(actions.get("axesVisible"));
        this.axesButton.setName(BUTTON_AXES);
        this.calibrationButton = new CalibrationButton();
        this.calibrationButton.setName(BUTTON_CALIBRATION);
        this.zoomAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rectangle rect = TToolBar.this.panel().scrollPane.getViewport().getViewRect();
                MainTView mainView = TToolBar.this.frame.getMainView(TToolBar.this.panel());
                mainView.setZoomCenter(rect.x + rect.width / 2, rect.y + rect.height / 2);
                String name = e.getActionCommand();
                if (name.equals("auto")) {
                    TToolBar.this.panel().setMagnification(-1.0);
                } else {
                    double mag = Double.parseDouble(name);
                    TToolBar.this.panel().setMagnification(mag / 100.0);
                }
            }
        };
        this.zoomButton = new TButton(zoomIcon){

            @Override
            protected JPopupMenu getPopup() {
                return TToolBar.this.refreshZoomPopup(TToolBar.this.zoomPopup);
            }
        };
        this.zoomButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TToolBar.this.panel().setMagnification(-1.0);
                    if (TToolBar.this.zoomPopup != null) {
                        TToolBar.this.zoomPopup.setVisible(false);
                    }
                }
            }
        });
        this.zoomButton.setName(BUTTON_ZOOM);
        this.newTrackButton = new TButton(pointmassOffIcon){

            @Override
            protected JPopupMenu getPopup() {
                TMenuBar.refreshPopup(TToolBar.this.panel(), "TToolBar.tracks", TToolBar.this.newPopup);
                return TToolBar.this.newPopup;
            }
        };
        this.trackControlButton = new TButton(pointmassOffIcon, pointmassOnIcon);
        this.trackControlButton.addActionListener(e -> {
            boolean vis;
            TrackControl tc = TrackControl.getControl(this.panel());
            boolean bl = vis = !tc.isVisible();
            if (!tc.positioned) {
                try {
                    Point p = this.trackControlButton.getLocationOnScreen();
                    tc.setLocation(p.x, p.y + this.trackControlButton.getHeight());
                }
                catch (Exception e1) {
                    Point p = this.panel().getLocationOnScreen();
                    tc.setLocation(p.x + 4, p.y + 4);
                }
                tc.positioned = true;
            }
            tc.setVisible(vis);
        });
        this.trackControlButton.setName(BUTTON_TRACK_CONTROL);
        this.autotrackerButton = new TButton(autotrackerOffIcon, autotrackerOnIcon);
        this.autotrackerButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                TToolBar.this.requestFocus();
            }
        });
        this.autotrackerButton.addActionListener(e -> {
            this.autotrackerButton.setSelected(!this.autotrackerButton.isSelected());
            AutoTracker autoTracker = this.panel().getAutoTracker(true);
            if (this.autotrackerButton.isSelected()) {
                autoTracker.getWizard().setFontLevel(FontSizer.getLevel());
            }
            autoTracker.getWizard().setVisible(this.autotrackerButton.isSelected());
            TFrame.repaintT(this.panel());
        });
        this.autotrackerButton.setName(BUTTON_AUTOTRACKER);
        AbstractAction refreshAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton button;
                button.setSelected(!(button = (JButton)e.getSource()).isSelected());
                if (TToolBar.this.useEyeButton) {
                    TToolBar.this.refreshTracks();
                } else {
                    TToolBar.this.refresh(TToolBar.REFRESH__REFRESH_ACTION_TRUE);
                }
            }
        };
        this.pVisButton = new TButton(pointsOffIcon, pointsOnIcon);
        this.pVisButton.setSelected(true);
        this.pVisButton.addActionListener(refreshAction);
        this.vVisButton = new TButton(velocOffIcon, velocOnIcon);
        this.vVisButton.addActionListener(refreshAction);
        this.aVisButton = new TButton(accelOffIcon, accelOnIcon);
        this.aVisButton.addActionListener(refreshAction);
        this.traceVisButton = new TButton(traceOffIcon, traceOnIcon);
        this.traceVisButton.addActionListener(refreshAction);
        this.trailButton = new TButton(){

            @Override
            protected JPopupMenu getPopup() {
                JPopupMenu popup = new JPopupMenu();
                ActionListener listener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        (this).TToolBar.this.trailLengthIndex = Integer.parseInt(e.getActionCommand());
                        (this).TToolBar.this.trailButton.setSelected((this).TToolBar.this.trailLengthIndex != 0);
                        TToolBar.this.refresh(TToolBar.REFRESH__TRAIL_BUTTON_ACTION_TRUE);
                        TFrame.repaintT(TToolBar.this.panel());
                    }
                };
                ButtonGroup group = new ButtonGroup();
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(TrackerRes.getString("TrackControl.TrailMenu.NoTrail"));
                item.setSelected(TToolBar.this.trailLengthIndex == 0);
                item.setActionCommand(String.valueOf(0));
                item.addActionListener(listener);
                popup.add(item);
                group.add(item);
                item = new JRadioButtonMenuItem(TrackerRes.getString("TrackControl.TrailMenu.ShortTrail"));
                item.setSelected(TToolBar.this.trailLengthIndex == 1);
                item.setActionCommand(String.valueOf(1));
                item.addActionListener(listener);
                popup.add(item);
                group.add(item);
                item = new JRadioButtonMenuItem(TrackerRes.getString("TrackControl.TrailMenu.LongTrail"));
                item.setSelected(TToolBar.this.trailLengthIndex == 2);
                item.setActionCommand(String.valueOf(2));
                item.addActionListener(listener);
                popup.add(item);
                group.add(item);
                item = new JRadioButtonMenuItem(TrackerRes.getString("TrackControl.TrailMenu.FullTrail"));
                item.setSelected(TToolBar.this.trailLengthIndex == 3);
                item.setActionCommand(String.valueOf(3));
                item.addActionListener(listener);
                popup.add(item);
                group.add(item);
                FontSizer.setFonts(popup, FontSizer.getLevel());
                return popup;
            }
        };
        this.trailButton.setSelected(true);
        this.labelsButton = new TButton(labelsOffIcon, labelsOnIcon);
        this.labelsButton.setSelected(!Tracker.hideLabels);
        this.labelsButton.addActionListener(refreshAction);
        this.xMassButton = new TButton(xmassOffIcon, xmassOnIcon);
        this.xMassButton.addActionListener(e -> {
            refreshAction.actionPerformed(e);
            TTrack track = this.panel().getSelectedTrack();
            if (track != null && track.ttype == 5) {
                this.panel().refreshTrackBar();
            }
        });
        this.vStretchMenu = new JMenu();
        this.vStretchMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                if (TToolBar.this.vGroup != null) {
                    return;
                }
                TToolBar.this.vGroup = new ButtonGroup();
                int i = 0;
                while (i < stretchValues.length) {
                    String s = String.valueOf(stretchValues[i]);
                    JRadioButtonMenuItem item = new JRadioButtonMenuItem("x" + s);
                    if (i == 0) {
                        item.setText(TrackerRes.getString("TrackControl.StretchVectors.None"));
                    }
                    item.setActionCommand(s);
                    item.setSelected(TToolBar.this.vStretch == stretchValues[i]);
                    item.addActionListener(ae -> {
                        int n = Integer.parseInt(ae.getActionCommand());
                        TToolBar.this.panel().setSelectedPoint(null);
                        TToolBar.this.panel().selectedSteps.clear();
                        TToolBar.this.vStretch = n;
                        TToolBar.this.refresh(TToolBar.REFRESH__VSTRETCH_ACTION_TRUE);
                    });
                    TToolBar.this.vGroup.add(item);
                    TToolBar.this.vStretchMenu.add(item);
                    FontSizer.setMenuFonts(TToolBar.this.vStretchMenu);
                    ++i;
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.aStretchMenu = new JMenu();
        this.aStretchMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                if (TToolBar.this.aGroup != null) {
                    return;
                }
                TToolBar.this.aGroup = new ButtonGroup();
                int i = 0;
                while (i < stretchValues.length) {
                    String s = String.valueOf(stretchValues[i]);
                    JRadioButtonMenuItem item = new JRadioButtonMenuItem("x" + s);
                    if (i == 0) {
                        item.setText(TrackerRes.getString("TrackControl.StretchVectors.None"));
                    }
                    item.setActionCommand(s);
                    item.setSelected(TToolBar.this.aStretch == stretchValues[i]);
                    item.addActionListener(ae -> {
                        int n = Integer.parseInt(ae.getActionCommand());
                        TToolBar.this.panel().setSelectedPoint(null);
                        TToolBar.this.panel().selectedSteps.clear();
                        TToolBar.this.aStretch = n;
                        TToolBar.this.refresh(TToolBar.REFRESH__ASTRETCH_ACTION_TRUE);
                    });
                    TToolBar.this.aGroup.add(item);
                    TToolBar.this.aStretchMenu.add(item);
                    FontSizer.setMenuFonts(TToolBar.this.aStretchMenu);
                    ++i;
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.stretchOffItem = new JMenuItem();
        this.stretchOffItem.addActionListener(e -> {
            this.vStretch = 1;
            this.aStretch = 1;
            this.refresh(REFRESH__STRETCHOFF_ACTION_TRUE);
        });
        this.stretchButton = new TButton(stretchOffIcon, stretchOnIcon){

            @Override
            protected JPopupMenu getPopup() {
                JPopupMenu popup = new JPopupMenu();
                popup.add(TToolBar.this.vStretchMenu);
                popup.add(TToolBar.this.aStretchMenu);
                popup.addSeparator();
                popup.add(TToolBar.this.stretchOffItem);
                FontSizer.setFonts(popup, FontSizer.getLevel());
                return popup;
            }
        };
        this.eyeButton = new TButton(eyeIcon){

            @Override
            protected JPopupMenu getPopup() {
                return TToolBar.this.refreshEyePopup(TToolBar.this.eyePopup);
            }
        };
        this.eyeButton.setName(BUTTON_TRACK_DISPLAY);
        this.rulerButton = new RulerButton();
        this.rulerButton.setName(BUTTON_MEASURE);
        this.fontSizeButton = new TButton(fontSizeIcon){

            @Override
            protected JPopupMenu getPopup() {
                JPopupMenu popup = new JPopupMenu();
                int i = 0;
                while (i <= Tracker.maxFontLevel) {
                    String s = TrackerRes.getString("TMenuBar.MenuItem.Font");
                    ResizableIcon icon = (ResizableIcon)Tracker.getResourceIcon("zoom.gif", true);
                    icon.setFixedSizeFactor(FontSizer.getIntegerFactor(i));
                    JMenuItem item = new JMenuItem(s, icon);
                    FontSizer.setFonts(item, i);
                    int n = i;
                    item.addActionListener(e -> FontSizer.setLevel(n));
                    popup.add(item);
                    if (i == FontSizer.getLevel()) {
                        item.setForeground(Color.green.darker());
                    }
                    ++i;
                }
                return popup;
            }
        };
        this.toolbarFiller = Box.createHorizontalGlue();
        this.infoListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TToolBar.this.notesButton.setSelected(false);
            }
        };
        this.drawingButton = new DrawingButton();
        this.drawingButton.setName(BUTTON_DRAWINGS);
        this.notesButton = new TButton(infoIcon, infoOnIcon);
        this.notesButton.addActionListener(e -> this.doNotesAction());
        this.notesButton.setName(BUTTON_NOTES);
        this.memoryButton = new TButton(memoryIcon){

            @Override
            public JPopupMenu getPopup() {
                return TToolBar.this.refreshMemoryPopup(new JPopupMenu());
            }
        };
        Font font = this.memoryButton.getFont();
        this.memoryButton.setFont(font.deriveFont(0, font.getSize() - 1));
        this.memoryButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                TToolBar.this.refreshMemoryButton();
            }
        });
        this.memoryButton.setName(BUTTON_MEMORY);
        this.refreshButton = new TButton(refreshIcon){

            @Override
            protected JPopupMenu getPopup() {
                return TToolBar.this.refreshRefreshPopup(null);
            }
        };
        this.refreshButton.setName(BUTTON_REFRESH);
        this.desktopButton = new TButton(htmlIcon){

            @Override
            protected JPopupMenu getPopup() {
                return TToolBar.this.refreshDesktopPopup(null);
            }
        };
        this.desktopButton.setDisabledIcon(htmlDisabledIcon);
        this.desktopButton.setName(BUTTON_DESKTOP);
        this.maximizeButton = new TButton(TViewChooser.MAXIMIZE_ICON, TViewChooser.RESTORE_ICON);
        this.maximizeButton.setName(BUTTON_MAXIMIZE);
        this.maximizeButton.setToolTipText(TrackerRes.getString("TFrame.Maximize.Tooltip"));
        this.maximizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TFrame.maximize = !TFrame.maximize;
                TToolBar.this.maximizeButton.setSelected(TFrame.maximize);
                if (OSPRuntime.isJS) {
                    TToolBar.this.maximizeButton.setIcon(TFrame.maximize ? TViewChooser.RESTORE_ICON : TViewChooser.MAXIMIZE_ICON);
                }
                TToolBar.this.maximizeButton.setToolTipText(TFrame.maximize ? TrackerRes.getString("TFrame.Restore.Tooltip") : TrackerRes.getString("TFrame.Maximize.Tooltip"));
                if (TFrame.maximize) {
                    TToolBar.this.panel().getTFrame().getAdaptiveBounds(false);
                } else {
                    TToolBar.this.panel().getTFrame().getAdaptiveBounds(false);
                }
            }
        });
        this.overflowPopup = new JPopupMenu();
        this.overflowButton = new TButton(){

            @Override
            protected JPopupMenu getPopup() {
                TToolBar.this.refreshOverflowComponents();
                FontSizer.setFonts(TToolBar.this.overflowPopup);
                return TToolBar.this.overflowPopup;
            }
        };
        this.overflowButton.setIcon(Tracker.getResourceIcon("overflow.gif", true));
        this.cloneMenu = new JMenu();
        this.showTrackControlItem = new JCheckBoxMenuItem();
        this.showTrackControlItem.addActionListener(e -> {
            TrackControl tc = TrackControl.getControl(this.panel());
            tc.setVisible(this.showTrackControlItem.isSelected());
        });
        this.selectNoneItem = new JMenuItem();
        this.selectNoneItem.addActionListener(e -> this.panel().setSelectedTrack(null));
        this.frame.clearHoldPainting();
        this.refresh(REFRESH__CREATE_GUI_TRUE);
        this.validate();
    }

    protected JPopupMenu refreshOpenPopup(JPopupMenu popup) {
        boolean showbrowser;
        boolean isButton;
        boolean bl = isButton = popup == null;
        if (popup == null) {
            popup = new JPopupMenu();
        }
        popup.removeAll();
        Map<String, AbstractAction> actions = this.panel().getActions();
        JMenuItem openfile = new JMenuItem(actions.get("open"));
        openfile.setIcon(null);
        popup.add(openfile);
        JMenuItem openbrowser = new JMenuItem(actions.get("openBrowser"));
        openbrowser.setIcon(null);
        boolean bl2 = showbrowser = this.panel().isEnabled("file.library") && this.panel().isEnabled("file.open");
        if (showbrowser) {
            popup.add(openbrowser);
        }
        if (isButton) {
            openfile.setText(TrackerRes.getString("TActions.Action.Open"));
            openbrowser.setText(TrackerRes.getString("TActions.Action.OpenBrowser"));
        } else {
            openfile.setText(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.FileChooser")) + "...");
            openbrowser.setText(String.valueOf(TrackerRes.getString("TMenuBar.MenuItem.LibraryBrowser")) + "...");
        }
        FontSizer.setFonts(popup, FontSizer.getLevel());
        return popup;
    }

    protected JPopupMenu refreshSavePopup(JPopupMenu popup) {
        boolean isButton;
        boolean bl = isButton = popup == null;
        if (popup == null) {
            popup = new JPopupMenu();
        }
        popup.removeAll();
        Map<String, AbstractAction> actions = this.panel().getActions();
        JMenuItem savetab = new JMenuItem(actions.get("save"));
        savetab.setIcon(null);
        File file = this.panel().getDataFile();
        String path = file == null ? "..." : " \"" + file.getName() + "\"";
        savetab.setText(String.valueOf(TrackerRes.getString(isButton ? "TActions.Action.Save" : "TMenuBar.MenuItem.Tab")) + path);
        popup.add(savetab);
        JMenuItem saveproject = new JMenuItem(actions.get("saveZip"));
        saveproject.setIcon(null);
        saveproject.setText(String.valueOf(TrackerRes.getString(isButton ? "TActions.Action.SaveZip" : "TMenuBar.MenuItem.Project")) + "...");
        popup.add(saveproject);
        FontSizer.setFonts(popup, FontSizer.getLevel());
        return popup;
    }

    protected JPopupMenu refreshRulerPopup(JPopupMenu popup) {
        popup.removeAll();
        for (TTrack track : this.panel().measuringTools) {
            JCheckBoxMenuItem checkbox = new JCheckBoxMenuItem(track.getName());
            checkbox.setSelected(track.isVisible());
            checkbox.addActionListener(e -> track.setVisible(checkbox.isSelected()));
            popup.add(checkbox);
        }
        JMenu newToolsMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.NewTrack"));
        TMenuBar.refreshMeasuringToolsMenu(this.panel(), newToolsMenu);
        if (newToolsMenu.getItemCount() > 0) {
            if (!this.panel().measuringTools.isEmpty()) {
                popup.addSeparator();
            }
            popup.add(newToolsMenu);
        }
        FontSizer.setFonts(popup, FontSizer.getLevel());
        return popup;
    }

    protected JPopupMenu refreshZoomPopup(JPopupMenu popup) {
        popup.removeAll();
        JMenuItem item = new JMenuItem(TrackerRes.getString("MainTView.Popup.MenuItem.ToFit"));
        item.setActionCommand("auto");
        item.addActionListener(this.zoomAction);
        popup.add(item);
        popup.addSeparator();
        int i = 0;
        int nz = TrackerPanel.ZOOM_LEVELS.length;
        while (i < nz) {
            int n = (int)(100.0 * TrackerPanel.ZOOM_LEVELS[i]);
            String m = String.valueOf(n);
            item = new JMenuItem(String.valueOf(m) + "%");
            item.setActionCommand(m);
            item.addActionListener(this.zoomAction);
            popup.add(item);
            ++i;
        }
        FontSizer.setFonts(popup, FontSizer.getLevel());
        return popup;
    }

    protected JPopupMenu refreshDesktopPopup(JPopupMenu popup) {
        JMenuItem item;
        String path;
        String title;
        TrackerPanel panel = this.panel();
        if (popup == null) {
            popup = new JPopupMenu();
        }
        popup.removeAll();
        if (!panel.supplementalFilePaths.isEmpty()) {
            JMenu fileMenu = new JMenu(TrackerRes.getString("TToolbar.Button.Desktop.Menu.OpenFile"));
            popup.add(fileMenu);
            for (String string : panel.supplementalFilePaths) {
                title = XML.getName(string);
                path = ResourceLoader.getNonURIPath(string);
                item = new JMenuItem(title);
                fileMenu.add(item);
                item.setActionCommand(path);
                item.addActionListener(e -> OSPDesktop.displayURL(e.getActionCommand()));
            }
        }
        if (!this.pageViewTabs.isEmpty()) {
            JMenu pageMenu = new JMenu(TrackerRes.getString("TToolbar.Button.Desktop.Menu.OpenPage"));
            popup.add(pageMenu);
            for (PageTView.TabData tabData : this.pageViewTabs) {
                if (tabData.url == null) continue;
                title = tabData.title;
                path = panel.pageViewFilePaths.get(tabData.text);
                if (path == null) {
                    path = tabData.url.toExternalForm();
                }
                item = new JMenuItem(title);
                item.setActionCommand(path);
                item.setToolTipText(path);
                item.addActionListener(e -> OSPDesktop.displayURL(e.getActionCommand()));
                pageMenu.add(item);
            }
        }
        FontSizer.setFonts(popup, FontSizer.getLevel());
        return popup;
    }

    private JPopupMenu refreshMemoryPopup(JPopupMenu popup) {
        popup.removeAll();
        JMenuItem memoryItem = new JMenuItem(TrackerRes.getString("TTrackBar.Memory.Menu.SetSize"));
        popup.add(memoryItem);
        memoryItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Tracker.askToSetMemory((TFrame)TToolBar.this.memoryButton.getTopLevelAncestor());
            }
        });
        FontSizer.setFonts(popup, FontSizer.getLevel());
        return popup;
    }

    protected JPopupMenu refreshRefreshPopup(JPopupMenu popup) {
        if (popup == null) {
            popup = new JPopupMenu();
        }
        popup.removeAll();
        JMenuItem item = new JMenuItem(TrackerRes.getString("TToolbar.Button.Refresh.Popup.RefreshNow"));
        item.addActionListener(e -> this.doRefreshPopup());
        popup.add(item);
        popup.addSeparator();
        item = new JCheckBoxMenuItem(TrackerRes.getString("TToolbar.Button.Refresh.Popup.AutoRefresh"));
        item.setSelected(this.panel().isAutoRefresh());
        item.addActionListener(e -> {
            TrackerPanel panel = this.panel();
            panel.setAutoRefresh(((JCheckBoxMenuItem)e.getSource()).isSelected());
            if (panel.isAutoRefresh()) {
                panel.refreshTrackData(0x8000000);
                panel.eraseAll();
                panel.repaintDirtyRegion();
            }
        });
        popup.add(item);
        FontSizer.setFonts(popup, FontSizer.getLevel());
        return popup;
    }

    protected void doRefreshPopup() {
        TrackerPanel panel = this.panel();
        ArrayList<RGBRegion> regions = panel.getDrawablesTemp(RGBRegion.class);
        ArrayList<RGBRegion> regionsToClear = new ArrayList<RGBRegion>();
        if (!regions.isEmpty()) {
            for (RGBRegion next : regions) {
                if (!panel.isTrackViewDisplayed(next) || !next.dataValid) continue;
                regionsToClear.add(next);
            }
        }
        regions.clear();
        if (!regionsToClear.isEmpty()) {
            String list = " ";
            for (RGBRegion next : regionsToClear) {
                list = String.valueOf(list) + next.getName() + ", ";
            }
            list = list.substring(0, list.length() - 2);
            int i = JOptionPane.showConfirmDialog(panel.getTopLevelAncestor(), String.valueOf(TrackerRes.getString("TToolBar.Dialog.ClearRGB.Message1")) + "\n" + TrackerRes.getString("TToolBar.Dialog.ClearRGB.Message2"), String.valueOf(TrackerRes.getString("TToolBar.Dialog.ClearRGB.Title")) + list, 0, 3);
            if (i == 0) {
                for (RGBRegion next : regionsToClear) {
                    next.clearData();
                }
            }
        }
        panel.refreshTrackData(0x8000000);
        panel.eraseAll();
        panel.repaintDirtyRegion();
    }

    protected void doNotesAction() {
        if (this.frame != null && this.frame.getSelectedPanel() == this.panel()) {
            this.notesButton.setSelected(!this.notesButton.isSelected());
            if (this.notesButton.isSelected()) {
                this.frame.setNotesDialog(this.panel(), this.infoListener);
            } else {
                this.frame.setNotesVisible(false);
            }
        }
    }

    private String getLocalizedName(JButton button) {
        return TrackerRes.getString("TToolBar.Overflow." + button.getName());
    }

    private Component getOverflowComponent(JButton button) {
        switch (button.getName()) {
            case "Open": {
                if (this.openMenu == null) {
                    this.openMenu = new JMenu();
                    this.openMenu.setIcon(button.getIcon());
                }
                this.openMenu.setText(this.getLocalizedName(button));
                return this.openMenu;
            }
            case "Save": {
                if (this.saveMenu == null) {
                    this.saveMenu = new JMenu();
                    this.saveMenu.setIcon(button.getIcon());
                }
                this.saveMenu.setText(this.getLocalizedName(button));
                return this.saveMenu;
            }
            case "ClipSettings": {
                if (this.clipCheckbox == null) {
                    this.clipCheckbox = new JCheckBoxMenuItem("", button.getIcon());
                    this.clipCheckbox.addActionListener(e -> button.doClick(0));
                }
                this.clipCheckbox.setText(this.getLocalizedName(button));
                return this.clipCheckbox;
            }
            case "CalibrationTools": {
                if (this.calibrationMenu == null) {
                    this.calibrationMenu = new JMenu();
                    this.calibrationMenu.setIcon(calibrationOnlyIcon);
                }
                this.calibrationMenu.setText(this.getLocalizedName(button));
                return this.calibrationMenu;
            }
            case "Axes": {
                if (this.axesCheckbox == null) {
                    this.axesCheckbox = new JCheckBoxMenuItem("", button.getIcon());
                    this.axesCheckbox.addActionListener(e -> button.doClick(0));
                }
                this.axesCheckbox.setText(this.getLocalizedName(button));
                return this.axesCheckbox;
            }
            case "MeasuringTools": {
                if (this.rulerMenu == null) {
                    this.rulerMenu = new JMenu();
                    this.rulerMenu.setIcon(rulerOnlyIcon);
                }
                this.rulerMenu.setText(this.getLocalizedName(button));
                return this.rulerMenu;
            }
            case "TrackControl": {
                if (this.trackControlCheckbox == null) {
                    this.trackControlCheckbox = new JCheckBoxMenuItem("", button.getIcon());
                    this.trackControlCheckbox.addActionListener(e -> button.doClick(0));
                }
                this.trackControlCheckbox.setText(this.getLocalizedName(button));
                return this.trackControlCheckbox;
            }
            case "Autotracker": {
                if (this.autotrackerCheckbox == null) {
                    this.autotrackerCheckbox = new JCheckBoxMenuItem("", button.getIcon());
                    this.autotrackerCheckbox.addActionListener(e -> button.doClick(0));
                }
                this.autotrackerCheckbox.setText(this.getLocalizedName(button));
                return this.autotrackerCheckbox;
            }
            case "TrackDisplay": {
                if (this.eyeMenu == null) {
                    this.eyeMenu = new JMenu();
                    this.eyeMenu.setIcon(button.getIcon());
                }
                this.eyeMenu.setText(this.getLocalizedName(button));
                return this.eyeMenu;
            }
            case "Zoom": {
                if (this.zoomMenu == null) {
                    this.zoomMenu = new JMenu();
                    this.zoomMenu.setIcon(button.getIcon());
                }
                this.zoomMenu.setText(this.getLocalizedName(button));
                return this.zoomMenu;
            }
            case "Drawings": {
                if (this.drawingMenu == null) {
                    this.drawingMenu = new JMenu();
                    this.drawingMenu.setIcon(pencilIcon);
                    this.drawingControlCheckbox = new JCheckBoxMenuItem();
                    this.drawingControlCheckbox.addActionListener(e -> {
                        this.drawingButton.showPopup = false;
                        button.doClick();
                    });
                }
                this.drawingMenu.setText(this.getLocalizedName(button));
                return this.drawingMenu;
            }
            case "Notes": {
                if (this.notesCheckbox == null) {
                    this.notesCheckbox = new JCheckBoxMenuItem("", button.getIcon());
                    this.notesCheckbox.addActionListener(e -> button.doClick(0));
                }
                this.notesCheckbox.setText(this.getLocalizedName(button));
                return this.notesCheckbox;
            }
            case "SupportDocs": {
                if (this.desktopMenu == null) {
                    this.desktopMenu = new JMenu();
                    this.desktopMenu.setIcon(button.getIcon());
                }
                this.desktopMenu.setText(this.getLocalizedName(button));
                return this.desktopMenu;
            }
            case "Memory": {
                if (this.memoryMenu == null) {
                    this.memoryMenu = new JMenu();
                    this.memoryMenu.setIcon(button.getIcon());
                }
                this.memoryMenu.setText(this.getLocalizedName(button));
                return this.memoryMenu;
            }
            case "Refresh": {
                if (this.refreshMenu == null) {
                    this.refreshMenu = new JMenu();
                    this.refreshMenu.setIcon(button.getIcon());
                }
                this.refreshMenu.setText(this.getLocalizedName(button));
                return this.refreshMenu;
            }
            case "Maximize": {
                if (this.maximizeCheckbox == null) {
                    this.maximizeCheckbox = new JCheckBoxMenuItem("", button.getIcon());
                    this.maximizeCheckbox.addActionListener(e -> button.doClick(0));
                }
                this.maximizeCheckbox.setText(this.getLocalizedName(button));
                return this.maximizeCheckbox;
            }
        }
        JMenu menu = new JMenu(this.getLocalizedName(button));
        menu.setIcon(button.getIcon());
        return menu;
    }

    protected void refreshOverflowComponents() {
        int i = 0;
        while (i < this.overflowButtons.size()) {
            JButton button = this.overflowButtons.get(i);
            switch (button.getName()) {
                case "Open": {
                    this.refreshOpenPopup(this.openMenu.getPopupMenu());
                    break;
                }
                case "Save": {
                    this.refreshSavePopup(this.saveMenu.getPopupMenu());
                    break;
                }
                case "ClipSettings": {
                    this.clipCheckbox.setSelected(this.clipSettingsButton.isSelected());
                    break;
                }
                case "CalibrationTools": {
                    this.refreshCalibrationPopup(this.calibrationMenu.getPopupMenu());
                    break;
                }
                case "Axes": {
                    this.axesCheckbox.setSelected(this.axesButton.isSelected());
                    break;
                }
                case "MeasuringTools": {
                    this.refreshRulerPopup(this.rulerMenu.getPopupMenu());
                    break;
                }
                case "TrackControl": {
                    this.trackControlCheckbox.setSelected(this.trackControlButton.isSelected());
                    break;
                }
                case "Autotracker": {
                    AutoTracker autoTracker = this.panel().getAutoTracker(true);
                    this.autotrackerCheckbox.setSelected(autoTracker.getWizard().isVisible());
                    break;
                }
                case "TrackDisplay": {
                    this.refreshEyePopup(this.eyeMenu.getPopupMenu());
                    break;
                }
                case "Zoom": {
                    this.refreshZoomPopup(this.zoomMenu.getPopupMenu());
                    break;
                }
                case "Drawings": {
                    this.drawingButton.drawingVisibleCheckbox.setText(TrackerRes.getString("TTrack.MenuItem.Visible"));
                    PencilDrawer drawer = PencilDrawer.getDrawer(this.panel());
                    this.drawingButton.drawingVisibleCheckbox.setSelected(drawer.areDrawingsVisible());
                    this.drawingButton.drawingVisibleCheckbox.setEnabled(PencilDrawer.hasDrawings(this.panel()) && !PencilDrawer.isDrawing(this.panel()));
                    this.drawingControlCheckbox.setText(TrackerRes.getString("TToolBar.Checkbox.DrawingControl"));
                    this.drawingControlCheckbox.setSelected(this.drawingButton.isSelected());
                    this.drawingMenu.removeAll();
                    if (PencilDrawer.hasDrawings(this.panel())) {
                        this.drawingMenu.add(this.drawingButton.drawingVisibleCheckbox);
                    }
                    this.drawingMenu.add(this.drawingControlCheckbox);
                    break;
                }
                case "Notes": {
                    this.notesCheckbox.setSelected(this.notesButton.isSelected());
                    break;
                }
                case "Memory": {
                    this.refreshMemoryPopup(this.memoryMenu.getPopupMenu());
                    break;
                }
                case "Refresh": {
                    this.refreshRefreshPopup(this.refreshMenu.getPopupMenu());
                    Component comp = this.refreshMenu.getMenuComponent(0);
                    ((JMenuItem)comp).setText(TrackerRes.getString("TToolBar.MenuItem.RefreshNow"));
                    break;
                }
                case "Maximize": {
                    this.maximizeCheckbox.setSelected(this.maximizeButton.isSelected());
                    break;
                }
                case "SupportDocs": {
                    this.refreshDesktopPopup(this.desktopMenu.getPopupMenu());
                }
            }
            ++i;
        }
    }

    protected JPopupMenu refreshCalibrationPopup(JPopupMenu popup) {
        if (popup == null) {
            popup = new JPopupMenu();
        }
        popup.removeAll();
        for (TTrack track : this.panel().calibrationTools) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(track.getName());
            item.setSelected(this.panel().visibleCalibrationTools.contains(track));
            item.setActionCommand(track.getName());
            item.addActionListener(this.calibrationButton);
            popup.add(item);
        }
        JMenu newToolsMenu = this.calibrationButton.getCalibrationToolsMenu();
        if (newToolsMenu.getItemCount() > 0) {
            if (!this.panel().calibrationTools.isEmpty()) {
                popup.addSeparator();
            }
            popup.add(newToolsMenu);
        }
        FontSizer.setFonts(popup, FontSizer.getLevel());
        return popup;
    }

    protected void refreshZoomButton() {
        double zoom = this.panel().getMagnification() * 100.0;
        this.zoomButton.setText(String.valueOf(zoomFormat.format(zoom)) + "%");
    }

    protected static void refreshMemoryButton(TrackerPanel trackerPanel) {
        if (OSPRuntime.isJS) {
            return;
        }
        if (trackerPanel == null) {
            return;
        }
        Integer panelID = trackerPanel.getID();
        TFrame frame = trackerPanel.getTFrame();
        System.gc();
        SwingUtilities.invokeLater(() -> {
            TrackerPanel panel = frame.getTrackerPanelForID(panelID);
            if (panel != null && panel.hasToolBar()) {
                panel.getToolBar(true).refreshMemoryButton();
            }
        });
    }

    private void refreshMemoryButton() {
        System.gc();
        long[] memory = OSPRuntime.getMemory();
        if (OSPRuntime.outOfMemory && TTrackBar.showOutOfMemoryDialog) {
            OSPRuntime.outOfMemory = false;
            TTrackBar.showOutOfMemoryDialog = false;
            memory[0] = memory[1];
            JOptionPane.showMessageDialog(this.memoryButton, String.valueOf(TrackerRes.getString("Tracker.Dialog.OutOfMemory.Message1")) + "\n" + TrackerRes.getString("Tracker.Dialog.OutOfMemory.Message2"), TrackerRes.getString("Tracker.Dialog.OutOfMemory.Title"), 2);
        }
        String mem = String.valueOf(TrackerRes.getString("TTrackBar.Button.Memory")) + " ";
        String of = String.valueOf(TrackerRes.getString("DynamicSystem.Parameter.Of")) + " ";
        this.memoryButton.setToolTipText(String.valueOf(mem) + memory[0] + "MB " + of + memory[1] + "MB");
        double used = (double)memory[0] / (double)memory[1];
        this.memoryButton.setIcon(used > 0.8 ? redMemoryIcon : memoryIcon);
    }

    protected JPopupMenu refreshEyePopup(JPopupMenu popup) {
        int n;
        popup.removeAll();
        if (this.pathVisMenuItem == null) {
            int gap = 6;
            this.pathVisMenuItem = new JCheckBoxMenuItem(traceOffIcon);
            this.pathVisMenuItem.addActionListener(e -> {
                this.traceVisButton.setSelected(!this.traceVisButton.isSelected());
                this.refresh(REFRESH__REFRESH_ACTION_TRUE);
            });
            this.pathVisMenuItem.setIconTextGap(gap);
            this.pVisMenuItem = new JCheckBoxMenuItem(pointsOffIcon);
            this.pVisMenuItem.addActionListener(e -> {
                this.pVisButton.setSelected(!this.pVisButton.isSelected());
                this.refresh(REFRESH__REFRESH_ACTION_TRUE);
            });
            this.pVisMenuItem.setIconTextGap(gap);
            this.vVisMenuItem = new JCheckBoxMenuItem(velocOffIcon);
            this.vVisMenuItem.addActionListener(e -> {
                this.vVisButton.setSelected(!this.vVisButton.isSelected());
                this.refresh(REFRESH__REFRESH_ACTION_TRUE);
            });
            this.vVisMenuItem.setIconTextGap(gap);
            this.aVisMenuItem = new JCheckBoxMenuItem(accelOffIcon);
            this.aVisMenuItem.addActionListener(e -> {
                this.aVisButton.setSelected(!this.aVisButton.isSelected());
                this.refresh(REFRESH__REFRESH_ACTION_TRUE);
            });
            this.aVisMenuItem.setIconTextGap(gap);
            this.trailsMenu = new JMenu();
            this.trailsMenu.setIconTextGap(gap);
            JPopupMenu trailPopup = this.trailButton.getPopup();
            int n2 = trailPopup.getComponentCount();
            int i = 0;
            while (i < n2) {
                this.trailsMenu.add(trailPopup.getComponent(0));
                ++i;
            }
            this.labelsMenuItem = new JCheckBoxMenuItem(labelsOffIcon);
            this.labelsMenuItem.addActionListener(e -> {
                this.labelsButton.setSelected(!this.labelsButton.isSelected());
                this.refresh(REFRESH__REFRESH_ACTION_TRUE);
            });
            this.labelsMenuItem.setIconTextGap(gap);
            this.stretchMenu = new JMenu();
            this.stretchMenu.setIcon(stretchOffIcon);
            this.stretchMenu.setIconTextGap(gap);
            this.xMassMenuItem = new JCheckBoxMenuItem(xmassOffIcon);
            this.xMassMenuItem.addActionListener(e -> {
                this.xMassButton.setSelected(!this.xMassButton.isSelected());
                this.refresh(REFRESH__REFRESH_ACTION_TRUE);
            });
            this.xMassMenuItem.setIconTextGap(gap);
        }
        if (this.panel().isEnabled("button.path") || this.panel().isEnabled("button.x") || this.panel().isEnabled("button.v") || this.panel().isEnabled("button.a")) {
            if (this.panel().isEnabled("button.path")) {
                popup.add(this.pathVisMenuItem);
            }
            if (this.panel().isEnabled("button.x")) {
                popup.add(this.pVisMenuItem);
            }
            if (this.panel().isEnabled("button.v")) {
                popup.add(this.vVisMenuItem);
            }
            if (this.panel().isEnabled("button.a")) {
                popup.add(this.aVisMenuItem);
            }
            popup.addSeparator();
        }
        if (this.panel().isEnabled("button.trails") || this.panel().isEnabled("button.labels")) {
            if (this.panel().isEnabled("button.trails")) {
                popup.add(this.trailsMenu);
            }
            if (this.panel().isEnabled("button.labels")) {
                popup.add(this.labelsMenuItem);
            }
            popup.addSeparator();
        }
        if (this.panel().isEnabled("button.stretch") || this.panel().isEnabled("button.xMass")) {
            if (this.panel().isEnabled("button.stretch")) {
                popup.add(this.stretchMenu);
            }
            if (this.panel().isEnabled("button.xMass")) {
                popup.add(this.xMassMenuItem);
            }
        }
        if ((n = popup.getComponentCount()) > 0 && popup.getComponent(n - 1) instanceof JSeparator) {
            popup.remove(n - 1);
        }
        this.pathVisMenuItem.setText(TrackerRes.getString("TToolBar.Menuitem.Paths.Text"));
        this.pVisMenuItem.setText(TrackerRes.getString("TToolBar.Menuitem.Positions.Text"));
        this.vVisMenuItem.setText(this.xMassButton.isSelected() ? TrackerRes.getString("TToolBar.Menuitem.Veloc.Text.P") : TrackerRes.getString("TToolBar.Menuitem.Veloc.Text.V"));
        this.aVisMenuItem.setText(this.xMassButton.isSelected() ? TrackerRes.getString("TToolBar.Menuitem.Accel.Text.F") : TrackerRes.getString("TToolBar.Menuitem.Accel.Text.A"));
        this.trailsMenu.setText(TrackerRes.getString("TToolBar.Menu.Trails.Text"));
        this.labelsMenuItem.setText(TrackerRes.getString("TToolBar.Menuitem.Labels.Text"));
        this.stretchMenu.setText(TrackerRes.getString("TToolBar.Menu.Stretch.Text"));
        this.xMassMenuItem.setText(TrackerRes.getString("TToolBar.Menuitem.Xmass.Text"));
        if (this.stretchMenu.getItemCount() != 4) {
            this.stretchMenu.removeAll();
            this.stretchMenu.add(this.vStretchMenu);
            this.stretchMenu.add(this.aStretchMenu);
            this.stretchMenu.addSeparator();
            this.stretchMenu.add(this.stretchOffItem);
        }
        this.trailsMenu.setIcon(trailIcons[this.trailLengthIndex]);
        this.pathVisMenuItem.setSelected(this.traceVisButton.isSelected());
        this.pVisMenuItem.setSelected(this.pVisButton.isSelected());
        this.vVisMenuItem.setSelected(this.vVisButton.isSelected());
        this.aVisMenuItem.setSelected(this.aVisButton.isSelected());
        this.labelsMenuItem.setSelected(this.labelsButton.isSelected());
        this.xMassMenuItem.setSelected(this.xMassButton.isSelected());
        FontSizer.setFonts(popup, FontSizer.getLevel());
        return popup;
    }

    @Override
    protected void paintChildren(Graphics g) {
        if (!OSPRuntime.isJS) {
            super.paintChildren(g);
        }
    }

    protected synchronized void refresh(String whereFrom) {
        if (this.disposed || this.frame.hasPaintHold() || !Tracker.allowToolbarRefresh) {
            return;
        }
        boolean doRefresh = false;
        switch (whereFrom) {
            case "TFrame.locale": 
            case "TFrame.locale2 ??": {
                doRefresh = true;
                this.vGroup = null;
                this.aGroup = null;
                this.enabledCount = -1;
                break;
            }
            case "refresh action": 
            case "TFrame.refresh": 
            case "vstretch action": 
            case "stretchoff action": 
            case "trail button action": 
            case "property track": 
            case "astretch action": 
            case "create gui": 
            case "PrefsDialog": 
            case "property track clear": {
                doRefresh = true;
            }
        }
        boolean bl = this.refreshingTracks = this.refreshingTracks || doRefresh;
        if (this.refreshTimer != null) {
            this.refreshTimer.stop();
        }
        this.refreshTimer = OSPRuntime.trigger(200, e -> {
            if (!this.disposed) {
                this.refreshAsync(this.refreshingTracks);
                this.refreshingTracks = false;
            }
            this.refreshTimer = null;
        });
    }

    public void setAllowRefresh(boolean b) {
        this.allowRebuild = b;
    }

    protected void refreshAsync(boolean refreshTrackProperties) {
        this.refreshing = true;
        int enabledCount = this.panel().getEnabledCount();
        boolean trackerPanelTainted = enabledCount != this.enabledCount;
        this.enabledCount = enabledCount;
        if (trackerPanelTainted && this.allowRebuild) {
            this.rebuild(-1);
        }
        this.checkEnabled(refreshTrackProperties);
        this.refreshing = false;
    }

    private void add(int index, Component comp) {
        if (this.overflowIndex < 0 || this.overflowIndex > index) {
            this.add(comp);
        } else if (comp instanceof JButton) {
            JButton button = (JButton)comp;
            String name = button.getName();
            if (name == null) {
                this.overflowPopup.addSeparator();
            } else {
                Component c = this.getOverflowComponent(button);
                FontSizer.setFont(c);
                this.overflowPopup.add(c);
                this.overflowButtons.add(button);
            }
        }
        if (index == this.overflowIndex) {
            this.add(this.overflowButton);
            this.add(this.toolbarFiller);
        }
    }

    private int getLastVisibleComponentIndex() {
        int n = this.getComponentCount();
        int w = this.getWidth();
        int i = n - 1;
        while (i > -1) {
            Component c = this.getComponent(i);
            int end = c.getLocation().x + c.getWidth();
            if (w > end && c instanceof JButton && ((JButton)c).getName() != null) {
                return i;
            }
            --i;
        }
        return n - 1;
    }

    private void rebuild(int overflow) {
        this.removeAll();
        this.overflowPopup.removeAll();
        this.overflowIndex = overflow;
        this.overflowButtons.clear();
        int index = 0;
        if (this.panel().isEnabled("file.open")) {
            this.add(index++, (Component)this.openButton);
        }
        if (this.panel().isEnabled("file.save")) {
            this.add(index++, (Component)this.saveButton);
        }
        if (this.getComponentCount() > 0) {
            this.add(index++, (Component)TToolBar.getSeparator());
        }
        boolean addSeparator = false;
        if (this.panel().isEnabled("button.clipSettings")) {
            this.add(index++, (Component)this.clipSettingsButton);
            addSeparator = true;
        }
        if (this.panel().isEnabled("calibration.stick") || this.panel().isEnabled("calibration.tape") || this.panel().isEnabled("calibration.points") || this.panel().isEnabled("calibration.offsetOrigin")) {
            this.add(index++, (Component)this.calibrationButton);
            addSeparator = true;
        }
        if (this.panel().isEnabled("button.axes")) {
            this.add(index++, (Component)this.axesButton);
            addSeparator = true;
        }
        boolean newTracksEnabled = false;
        boolean measuringToolsEnabled = false;
        boolean eyeEnabled = false;
        String[] fullconfig = Tracker.getFullConfig().toArray(new String[0]);
        int i = 0;
        while (i < fullconfig.length) {
            if (fullconfig[i].startsWith("new.") && !fullconfig[i].endsWith("clone")) {
                if (this.panel().isEnabled(fullconfig[i])) {
                    if (fullconfig[i].endsWith("tapeMeasure") || fullconfig[i].endsWith("protractor") || fullconfig[i].endsWith("circleFitter")) {
                        measuringToolsEnabled = true;
                    } else {
                        newTracksEnabled = true;
                    }
                }
            } else if (fullconfig[i].startsWith("button.") && !fullconfig[i].endsWith("clipSettings") && !fullconfig[i].endsWith("axes") && !fullconfig[i].endsWith("drawing") && this.panel().isEnabled(fullconfig[i])) {
                eyeEnabled = true;
            }
            ++i;
        }
        if (measuringToolsEnabled) {
            this.add(index++, (Component)this.rulerButton);
            addSeparator = true;
        }
        if (addSeparator) {
            this.add(index++, (Component)TToolBar.getSeparator());
        }
        this.panel().isCreateTracksEnabled();
        if (newTracksEnabled) {
            FontSizer.setFonts(this.trackControlButton);
            this.add(index++, (Component)this.trackControlButton);
        }
        if (this.panel().isEnabled("track.autotrack")) {
            this.add(index++, (Component)this.autotrackerButton);
        } else {
            AutoTracker autoTracker = this.panel().getAutoTracker(false);
            if (autoTracker != null) {
                autoTracker.getWizard().setVisible(false);
            }
        }
        this.add(index++, (Component)TToolBar.getSeparator());
        if (this.useEyeButton) {
            if (eyeEnabled) {
                this.add(index++, (Component)this.eyeButton);
            }
        } else {
            if (this.panel().isEnabled("button.trails") || this.panel().isEnabled("button.labels")) {
                if (this.panel().isEnabled("button.trails")) {
                    this.add(this.trailButton);
                }
                if (this.panel().isEnabled("button.labels")) {
                    this.add(this.labelsButton);
                }
                this.add(TToolBar.getSeparator());
            }
            if (this.panel().isEnabled("button.path") || this.panel().isEnabled("button.x") || this.panel().isEnabled("button.v") || this.panel().isEnabled("button.a")) {
                if (this.panel().isEnabled("button.path")) {
                    this.add(this.traceVisButton);
                }
                if (this.panel().isEnabled("button.x")) {
                    this.add(this.pVisButton);
                }
                if (this.panel().isEnabled("button.v")) {
                    this.add(this.vVisButton);
                }
                if (this.panel().isEnabled("button.a")) {
                    this.add(this.aVisButton);
                }
                this.add(TToolBar.getSeparator());
            }
            if (this.panel().isEnabled("button.stretch") || this.panel().isEnabled("button.xMass")) {
                if (this.panel().isEnabled("button.stretch")) {
                    this.add(this.stretchButton);
                }
                if (this.panel().isEnabled("button.xMass")) {
                    this.add(this.xMassButton);
                }
                this.add(TToolBar.getSeparator());
            }
        }
        FontSizer.setFonts(this.zoomButton);
        this.add(index++, (Component)this.zoomButton);
        this.add(index++, (Component)TToolBar.getSeparator());
        this.add(index++, this.toolbarFiller);
        if (Tracker.newerVersion != null) {
            String s = TrackerRes.getString("TTrackBar.Button.Version");
            TTrackBar.newVersionButton.setText(String.valueOf(s) + " " + Tracker.newerVersion);
            this.add(TTrackBar.newVersionButton);
        }
        if (this.panel().isEnabled("button.drawing")) {
            this.add(index++, (Component)this.drawingButton);
        }
        if (this.desktopButton.isEnabled()) {
            this.add(index++, (Component)this.desktopButton);
        }
        this.add(index++, (Component)this.notesButton);
        if (!OSPRuntime.isJS) {
            this.add(index++, (Component)TToolBar.getSeparator());
            this.add(index++, (Component)this.memoryButton);
        }
        this.add(index++, (Component)this.refreshButton);
        if (TFrame.isLayoutAdaptive) {
            this.add(index++, (Component)this.maximizeButton);
        }
        i = this.getLastVisibleComponentIndex();
        if (overflow == -1 && i < this.getComponentCount() - 1) {
            this.rebuild(i);
        } else {
            TFrame.repaintT(this);
        }
    }

    private void checkEnabled(boolean refreshTracks) {
        TPoint pt;
        CoordAxes axes;
        this.refreshZoomButton();
        this.calibrationButton.refresh();
        this.rulerButton.refresh();
        this.drawingButton.refresh();
        this.stretchButton.setSelected(this.vStretch > 1 || this.aStretch > 1);
        this.stretchOffItem.setText(TrackerRes.getString("TToolBar.MenuItem.StretchOff"));
        this.stretchOffItem.setEnabled(this.vStretch > 1 || this.aStretch > 1);
        this.setMenuText();
        if (this.panel().getPlayer() != null) {
            VideoClip clip = this.panel().getPlayer().getVideoClip();
            ClipInspector inspector = clip.getClipInspector();
            this.clipSettingsButton.setSelected(inspector != null && inspector.isVisible());
        }
        if ((axes = this.panel().getAxes()) != null) {
            this.axesButton.setSelected(axes.isVisible());
            axes.updateListenerVisible(this);
        }
        this.trackControlButton.setEnabled(true);
        if (refreshTracks) {
            this.refreshTracks();
        }
        if ((pt = this.panel().getSelectedPoint()) != null) {
            pt.showCoordinates(this.panel());
        }
        if (trailIcons[this.trailLengthIndex] != this.trailButton.getIcon()) {
            this.trailButton.setIcon(trailIcons[this.trailLengthIndex]);
            FontSizer.setFont(this.trailButton);
        }
        this.pageViewTabs.clear();
        if (this.frame != null) {
            List<TView> views = this.frame.getTViews(this.panelID, 3, null);
            int i = 0;
            while (i < views.size()) {
                PageTView page = (PageTView)views.get(i);
                for (PageTView.TabView tab : page.tabs) {
                    if (tab.data.url == null) continue;
                    this.pageViewTabs.add(tab.data);
                }
                ++i;
            }
            this.sortPageViewTabs();
        }
        boolean hasPageURLs = !this.pageViewTabs.isEmpty();
        this.desktopButton.setEnabled(hasPageURLs || !this.panel().supplementalFilePaths.isEmpty());
        if (this.desktopButton.isEnabled() && this.desktopButton.getParent() == null) {
            this.rebuild(-1);
        } else if (!this.desktopButton.isEnabled()) {
            this.remove(this.desktopButton);
        }
    }

    private void refreshTracks() {
        TrackerPanel panel = this.panel();
        ArrayList<TTrack> tracks = panel.getTracks();
        double totalMass = 0.0;
        int massCount = 0;
        for (TTrack track : tracks) {
            if (track.ttype != 5 || track instanceof CenterOfMass || track instanceof DynamicSystem) continue;
            PointMass p = (PointMass)track;
            totalMass += p.getMass();
            ++massCount;
        }
        boolean doRepaint = false;
        for (TTrack track : tracks) {
            track.removePropertyChangeListener("locked", this);
            track.addPropertyChangeListener("locked", this);
            track.setTrailLength(trailLengths[this.trailLengthIndex]);
            track.setTrailVisible(this.trailButton.isSelected());
            if (track.ttype == 5) {
                ArrowFootprint arrow;
                PointMass p = (PointMass)track;
                p.setTraceVisible(this.traceVisButton.isSelected());
                p.setPositionVisible(panel, this.pVisButton.isSelected());
                p.setVVisible(panel, this.vVisButton.isSelected());
                p.setAVisible(panel, this.aVisButton.isSelected());
                p.setLabelsVisible(panel, this.labelsButton.isSelected());
                Footprint[] footprints = p.getVelocityFootprints();
                int i = 0;
                while (i < footprints.length) {
                    if (footprints[i] instanceof ArrowFootprint) {
                        arrow = (ArrowFootprint)footprints[i];
                        if (this.xMassButton.isSelected()) {
                            arrow.setStretch((double)(this.vStretch * massCount) * p.getMass() / totalMass);
                            arrow.setSolidHead(false);
                        } else {
                            arrow.setStretch(this.vStretch);
                            arrow.setSolidHead(false);
                        }
                    }
                    ++i;
                }
                footprints = p.getAccelerationFootprints();
                i = 0;
                while (i < footprints.length) {
                    if (footprints[i] instanceof ArrowFootprint) {
                        arrow = (ArrowFootprint)footprints[i];
                        if (this.xMassButton.isSelected()) {
                            arrow.setStretch((double)(this.aStretch * massCount) * p.getMass() / totalMass);
                            arrow.setSolidHead(true);
                        } else {
                            arrow.setStretch(this.aStretch);
                            arrow.setSolidHead(true);
                        }
                    }
                    ++i;
                }
                doRepaint = true;
                track.erase();
                continue;
            }
            if (track.ttype != 9) continue;
            Vector v = (Vector)track;
            v.setLabelsVisible(this.labelsButton.isSelected());
            doRepaint = true;
        }
        if (doRepaint) {
            int i = 0;
            while (i < panel.andWorld.size()) {
                this.frame.getTrackerPanelForID(panel.andWorld.get(i)).repaint();
                ++i;
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.panel() == null || !this.panel().isPaintable() || this.getComponentCount() == 0) {
            return;
        }
        super.paint(g);
    }

    private void setMenuText() {
        this.trackControlButton.setText(TrackerRes.getString("Undo.Description.Track"));
        this.vStretchMenu.setText(TrackerRes.getString("PointMass.MenuItem.Velocity"));
        this.aStretchMenu.setText(TrackerRes.getString("PointMass.MenuItem.Acceleration"));
        this.openButton.setToolTipText(TrackerRes.getString("TToolBar.Button.Open.Tooltip"));
        this.clipSettingsButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.ClipSettings.ToolTip"));
        this.axesButton.setToolTipText(TrackerRes.getString("TToolbar.Button.AxesVisible.Tooltip"));
        this.zoomButton.setToolTipText(TrackerRes.getString("TToolBar.Button.Zoom.Tooltip"));
        this.notesButton.setToolTipText(TrackerRes.getString("TActions.Action.Description"));
        this.refreshButton.setToolTipText(TrackerRes.getString("TToolbar.Button.Refresh.Tooltip"));
        this.desktopButton.setToolTipText(TrackerRes.getString("TToolbar.Button.Desktop.Tooltip"));
        this.pVisButton.setToolTipText(TrackerRes.getString("TrackControl.Button.Positions.ToolTip"));
        this.vVisButton.setToolTipText(TrackerRes.getString("TrackControl.Button.Velocities.ToolTip"));
        this.aVisButton.setToolTipText(TrackerRes.getString("TrackControl.Button.Accelerations.ToolTip"));
        this.xMassButton.setToolTipText(TrackerRes.getString("TrackControl.Button.Xmass.ToolTip"));
        this.trailButton.setToolTipText(TrackerRes.getString("TrackControl.Button.Trails.ToolTip"));
        this.labelsButton.setToolTipText(TrackerRes.getString("TrackControl.Button.Labels.ToolTip"));
        this.stretchButton.setToolTipText(TrackerRes.getString("TrackControl.Button.StretchVectors.ToolTip"));
        this.traceVisButton.setToolTipText(TrackerRes.getString("TrackControl.Button.Trace.ToolTip"));
        this.newTrackButton.setText(TrackerRes.getString("TrackControl.Button.NewTrack"));
        this.newTrackButton.setToolTipText(TrackerRes.getString("TrackControl.Button.NewTrack.ToolTip"));
        this.eyeButton.setToolTipText(TrackerRes.getString("TToolbar.Button.Eye.Tooltip"));
        this.trackControlButton.setToolTipText(TrackerRes.getString("TToolBar.Button.TrackControl.Tooltip"));
        this.autotrackerButton.setToolTipText(TrackerRes.getString("TToolBar.Button.AutoTracker.Tooltip"));
        this.fontSizeButton.setToolTipText(TrackerRes.getString("TToolBar.Button.FontSize.ToolTip"));
    }

    @Override
    public void dispose() {
        this.disposed = true;
        if (this.refreshTimer != null) {
            this.refreshTimer.stop();
        }
        this.refreshTimer = null;
        this.removeAll();
        this.panel().removeListeners(panelProps, this);
        for (TTrack track : TTrack.getValues()) {
            track.removePropertyChangeListener("locked", this);
            track.removePropertyChangeListener("visible", this);
        }
        this.pageViewTabs.clear();
        this.panelID = null;
        this.frame = null;
    }

    public void finalize() {
        OSPLog.finalized(this);
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            comps[i].setEnabled(enable);
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void propertyChange(PropertyChangeEvent e) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[10] lbl96 : CaseStatement: default:\u000a, @NONE, blocks:[10] lbl96 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static JButton getSeparator() {
        JButton b = new JButton(separatorIcon);
        b.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        b.setOpaque(false);
        b.setContentAreaFilled(false);
        return b;
    }

    private void sortPageViewTabs() {
        Collections.sort(this.pageViewTabs, new Comparator<PageTView.TabData>(){

            @Override
            public int compare(PageTView.TabData one, PageTView.TabData two) {
                return one.title.toLowerCase().compareTo(two.title.toLowerCase());
            }
        });
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private void setTrailLength(int length) {
        if (length == Integer.MIN_VALUE) {
            return;
        }
        if (length <= 0 || length > trailLengths[trailLengths.length - 2]) {
            this.trailLengthIndex = trailLengths.length - 1;
        } else {
            int i = 0;
            while (i < trailLengths.length - 1) {
                if (trailLengths[i] >= length) {
                    this.trailLengthIndex = i;
                    break;
                }
                ++i;
            }
        }
    }

    protected TrackerPanel panel() {
        return this.frame == null ? null : this.frame.getTrackerPanelForID(this.panelID);
    }

    @Override
    public String toString() {
        return "[TToolBar " + this.panelID + "]";
    }

    protected class CalibrationButton
    extends TButton
    implements ActionListener {
        boolean showPopup;

        private CalibrationButton() {
            this.setIcons(calibrationToolsOffIcon, calibrationToolsOnIcon);
            this.setRolloverIcon(calibrationToolsOffRolloverIcon);
            this.setRolloverSelectedIcon(calibrationToolsOnRolloverIcon);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int wicon = CalibrationButton.this.getIcon().getIconWidth();
                    int factor = wicon / 28;
                    int wbutton = CalibrationButton.this.getWidth();
                    int limit = (wbutton - wicon) / 2 + factor * 18;
                    CalibrationButton.this.showPopup = e.getX() > limit || ((CalibrationButton)CalibrationButton.this).TToolBar.this.panel().visibleCalibrationTools.isEmpty();
                }
            });
            this.addActionListener(this);
        }

        @Override
        protected JPopupMenu getPopup() {
            if (!this.showPopup) {
                return null;
            }
            return TToolBar.this.refreshCalibrationPopup(null);
        }

        protected JMenu getCalibrationToolsMenu() {
            JMenuItem item;
            JMenu newToolsMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.NewTrack"));
            if (TToolBar.this.panel().isEnabled("calibration.stick")) {
                item = new JMenuItem(TrackerRes.getString("Stick.Name"));
                item.addActionListener(e -> {
                    TapeMeasure track = new TapeMeasure();
                    track.setColor(Color.BLUE);
                    track.setStickMode(true);
                    double scale = TToolBar.this.panel().getCoords().getScaleX(0);
                    boolean uncalibrated = TToolBar.this.panel().calibrationTools.isEmpty();
                    track.setCalibrator(scale == 1.0 && uncalibrated ? Double.valueOf(1.0) : null);
                    String name = TrackerRes.getString("CalibrationStick.New.Name");
                    track.setName(TToolBar.this.panel().getNextName(name, " "));
                    TToolBar.this.panel().addTrack(track);
                    TToolBar.this.calibrationButton.setSelected(true);
                    for (TTrack next : TToolBar.this.panel().visibleCalibrationTools) {
                        this.showCalibrationTool(next);
                    }
                    if (Tracker.centerCalibrationStick) {
                        MainTView mainView = TToolBar.this.frame.getMainView(TToolBar.this.panel());
                        Rectangle rect = mainView.scrollPane.getViewport().getViewRect();
                        int xpix = rect.x + rect.width / 2;
                        int ypix = rect.y + rect.height / 2;
                        double x = TToolBar.this.panel().pixToX(xpix);
                        double y = TToolBar.this.panel().pixToY(ypix);
                        track.createStep(0, x - 100.0, y - 20.0, x + 100.0, y - 20.0);
                    }
                    TToolBar.this.panel().setSelectedTrack(track);
                });
                newToolsMenu.add(item);
            }
            if (TToolBar.this.panel().isEnabled("calibration.points")) {
                item = new JMenuItem(TrackerRes.getString("Calibration.Name"));
                item.addActionListener(e -> {
                    Calibration track = new Calibration();
                    String name = TrackerRes.getString("Calibration.New.Name");
                    track.setName(TToolBar.this.panel().getNextName(name, " "));
                    TToolBar.this.panel().addTrack(track);
                    TToolBar.this.calibrationButton.setSelected(true);
                    for (TTrack next : TToolBar.this.panel().visibleCalibrationTools) {
                        this.showCalibrationTool(next);
                    }
                    TToolBar.this.panel().setSelectedTrack(track);
                    TToolBar.this.panel().getAxes().setVisible(true);
                });
                newToolsMenu.add(item);
            }
            if (TToolBar.this.panel().isEnabled("calibration.offsetOrigin")) {
                item = new JMenuItem(TrackerRes.getString("OffsetOrigin.Name"));
                item.addActionListener(e -> {
                    OffsetOrigin track = new OffsetOrigin();
                    String name = TrackerRes.getString("OffsetOrigin.New.Name");
                    track.setName(TToolBar.this.panel().getNextName(name, " "));
                    TToolBar.this.panel().addTrack(track);
                    TToolBar.this.calibrationButton.setSelected(true);
                    for (TTrack next : TToolBar.this.panel().visibleCalibrationTools) {
                        this.showCalibrationTool(next);
                    }
                    TToolBar.this.panel().setSelectedTrack(track);
                    TToolBar.this.panel().getAxes().setVisible(true);
                });
                newToolsMenu.add(item);
            }
            return newToolsMenu;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == TToolBar.this.calibrationButton) {
                if (this.showPopup) {
                    return;
                }
                TToolBar.this.panel().setSelectedPoint(null);
                TToolBar.this.panel().selectedSteps.clear();
                TToolBar.this.panel().hideMouseBox();
                if (!TToolBar.this.calibrationButton.isSelected()) {
                    TToolBar.this.calibrationButton.setSelected(true);
                    for (TTrack track : TToolBar.this.panel().visibleCalibrationTools) {
                        this.showCalibrationTool(track);
                    }
                } else {
                    TToolBar.this.calibrationButton.setSelected(false);
                    for (TTrack track : TToolBar.this.panel().calibrationTools) {
                        this.hideCalibrationTool(track);
                    }
                }
                TFrame.repaintT(TToolBar.this.panel());
            } else {
                TToolBar.this.panel().setSelectedPoint(null);
                TToolBar.this.panel().selectedSteps.clear();
                JMenuItem source = (JMenuItem)e.getSource();
                for (TTrack track : TToolBar.this.panel().calibrationTools) {
                    if (!e.getActionCommand().equals(track.getName())) continue;
                    if (source.isSelected()) {
                        TToolBar.this.panel().visibleCalibrationTools.add(track);
                        TToolBar.this.calibrationButton.setSelected(true);
                        for (TTrack next : TToolBar.this.panel().visibleCalibrationTools) {
                            this.showCalibrationTool(next);
                        }
                        continue;
                    }
                    this.hideCalibrationTool(track);
                    TToolBar.this.panel().visibleCalibrationTools.remove(track);
                    boolean toolsVisible = false;
                    for (TTrack next : TToolBar.this.panel().visibleCalibrationTools) {
                        boolean bl = toolsVisible = toolsVisible || next.isVisible();
                    }
                    TToolBar.this.calibrationButton.setSelected(toolsVisible);
                }
                this.refresh();
            }
        }

        void showCalibrationTool(TTrack track) {
            int n;
            Step step;
            track.erase();
            track.setVisible(true);
            if (track.ttype == 0) {
                int n2 = TToolBar.this.panel().getFrameNumber();
                Step step2 = track.getStep(n2);
                if (step2 == null || step2.getPoints()[1] == null) {
                    TToolBar.this.panel().setSelectedTrack(track);
                }
            } else if (track.ttype == 4 && (step = track.getStep(n = TToolBar.this.panel().getFrameNumber())) == null) {
                TToolBar.this.panel().setSelectedTrack(track);
            }
        }

        void hideCalibrationTool(TTrack track) {
            track.setVisible(false);
            if (TToolBar.this.panel().getSelectedTrack() == track) {
                TToolBar.this.panel().setSelectedTrack(null);
            }
        }

        void refresh() {
            this.setToolTipText(TrackerRes.getString("TToolbar.Button.TapeVisible.Tooltip"));
            for (TTrack track : TToolBar.this.panel().calibrationTools) {
                track.updateListenerVisible(TToolBar.this);
            }
            boolean toolsVisible = false;
            for (TTrack track : TToolBar.this.panel().calibrationTools) {
                boolean bl = toolsVisible = toolsVisible || track.isVisible();
            }
            if (TToolBar.this.notYetCalibrated && toolsVisible) {
                TToolBar.this.notYetCalibrated = false;
            }
            this.setSelected(toolsVisible);
        }
    }

    protected class DrawingButton
    extends TButton
    implements ActionListener {
        boolean showPopup;
        JPopupMenu popup;
        JCheckBoxMenuItem drawingVisibleCheckbox;

        private DrawingButton() {
            this.setIcons(pencilOffIcon, pencilOnIcon);
            this.setRolloverIcon(pencilOffRolloverIcon);
            this.setRolloverSelectedIcon(pencilOnRolloverIcon);
            this.addActionListener(this);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int wicon = DrawingButton.this.getIcon().getIconWidth();
                    int factor = wicon / 28;
                    int wbutton = DrawingButton.this.getWidth();
                    int limit = (wbutton - wicon) / 2 + factor * 18;
                    DrawingButton.this.showPopup = e.getX() > limit;
                }
            });
            this.drawingVisibleCheckbox = new JCheckBoxMenuItem();
            this.drawingVisibleCheckbox.setSelected(true);
            this.drawingVisibleCheckbox.addActionListener(e -> {
                TToolBar.this.panel().setSelectedPoint(null);
                TToolBar.this.panel().selectedSteps.clear();
                PencilDrawer drawer = PencilDrawer.getDrawer(TToolBar.this.panel());
                drawer.setDrawingsVisible(!drawer.areDrawingsVisible(), true);
                this.drawingVisibleCheckbox.setSelected(drawer.areDrawingsVisible());
                TFrame.repaintT(TToolBar.this.panel());
            });
            this.popup = new JPopupMenu();
        }

        @Override
        protected JPopupMenu getPopup() {
            if (!this.showPopup) {
                return null;
            }
            this.refresh();
            FontSizer.setFonts(this.popup);
            return this.popup;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.showPopup) {
                return;
            }
            TToolBar.this.panel().setSelectedPoint(null);
            TToolBar.this.panel().selectedSteps.clear();
            TToolBar.this.panel().hideMouseBox();
            this.setSelected(!this.isSelected());
            PencilDrawer drawer = PencilDrawer.getDrawer(TToolBar.this.panel());
            drawer.getDrawingControl().setVisible(this.isSelected());
            if (this.isSelected()) {
                if (drawer.scenes.isEmpty()) {
                    drawer.addNewScene();
                } else {
                    PencilScene scene = drawer.getSceneAtFrame(TToolBar.this.panel().getFrameNumber());
                    drawer.getDrawingControl().setSelectedScene(scene);
                }
                drawer.setDrawingsVisible(true, true);
            }
        }

        void refresh() {
            this.setToolTipText(TrackerRes.getString("TToolBar.Button.Drawings.Tooltip"));
            this.drawingVisibleCheckbox.setText(TrackerRes.getString("TToolBar.MenuItem.DrawingsVisible.Text"));
            PencilDrawer drawer = PencilDrawer.getDrawer(TToolBar.this.panel());
            this.drawingVisibleCheckbox.setSelected(drawer.areDrawingsVisible());
            this.drawingVisibleCheckbox.setEnabled(PencilDrawer.hasDrawings(TToolBar.this.panel()) && !PencilDrawer.isDrawing(TToolBar.this.panel()));
            this.popup.add(this.drawingVisibleCheckbox);
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            TToolBar toolbar = (TToolBar)obj;
            control.setValue("trace", toolbar.traceVisButton.isSelected());
            control.setValue("position", toolbar.pVisButton.isSelected());
            control.setValue("velocity", toolbar.vVisButton.isSelected());
            control.setValue("acceleration", toolbar.aVisButton.isSelected());
            control.setValue("labels", toolbar.labelsButton.isSelected());
            control.setValue("multiply_by_mass", toolbar.xMassButton.isSelected());
            control.setValue("trail_length", trailLengths[toolbar.trailLengthIndex]);
            control.setValue("stretch", toolbar.vStretch);
            control.setValue("stretch_acceleration", toolbar.aStretch);
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            TToolBar toolbar = (TToolBar)obj;
            toolbar.traceVisButton.setSelected(control.getBoolean("trace"));
            toolbar.pVisButton.setSelected(control.getBoolean("position"));
            toolbar.vVisButton.setSelected(control.getBoolean("velocity"));
            toolbar.aVisButton.setSelected(control.getBoolean("acceleration"));
            toolbar.labelsButton.setSelected(control.getBoolean("labels"));
            toolbar.xMassButton.setSelected(control.getBoolean("multiply_by_mass"));
            toolbar.setTrailLength(control.getInt("trail_length"));
            toolbar.vStretch = control.getInt("stretch");
            toolbar.aStretch = control.getPropertyNamesRaw().contains("stretch_acceleration") ? control.getInt("stretch_acceleration") : toolbar.vStretch;
            return obj;
        }
    }

    protected class RulerButton
    extends TButton
    implements ActionListener {
        boolean showPopup;

        private RulerButton() {
            this.setIcons(rulerIcon, rulerOnIcon);
            this.setRolloverIcon(rulerRolloverIcon);
            this.setRolloverSelectedIcon(rulerOnRolloverIcon);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int wicon = RulerButton.this.getIcon().getIconWidth();
                    int factor = wicon / 28;
                    int wbutton = RulerButton.this.getWidth();
                    int limit = (wbutton - wicon) / 2 + factor * 18;
                    RulerButton.this.showPopup = e.getX() > limit || ((RulerButton)RulerButton.this).TToolBar.this.panel().visibleMeasuringTools.isEmpty();
                }
            });
            this.addActionListener(this);
        }

        @Override
        protected JPopupMenu getPopup() {
            if (!this.showPopup) {
                return null;
            }
            JPopupMenu popup = new JPopupMenu();
            for (TTrack track : TToolBar.this.panel().measuringTools) {
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(track.getName());
                item.setSelected(TToolBar.this.panel().visibleMeasuringTools.contains(track));
                item.setActionCommand(track.getName());
                item.addActionListener(this);
                popup.add(item);
            }
            JMenu newToolsMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.NewTrack"));
            TMenuBar.refreshMeasuringToolsMenu(TToolBar.this.panel(), newToolsMenu);
            if (newToolsMenu.getItemCount() > 0) {
                if (!TToolBar.this.panel().measuringTools.isEmpty()) {
                    popup.addSeparator();
                }
                popup.add(newToolsMenu);
            }
            FontSizer.setFonts(popup);
            return popup;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == TToolBar.this.rulerButton) {
                if (this.showPopup) {
                    return;
                }
                TToolBar.this.panel().setSelectedPoint(null);
                TToolBar.this.panel().selectedSteps.clear();
                TToolBar.this.panel().hideMouseBox();
                if (!TToolBar.this.rulerButton.isSelected()) {
                    TToolBar.this.rulerButton.setSelected(true);
                    for (TTrack track : TToolBar.this.panel().visibleMeasuringTools) {
                        this.showMeasuringTool(track);
                    }
                } else {
                    TToolBar.this.rulerButton.setSelected(false);
                    for (TTrack track : TToolBar.this.panel().measuringTools) {
                        this.hideMeasuringTool(track);
                    }
                }
                TFrame.repaintT(TToolBar.this.panel());
            } else {
                TToolBar.this.panel().setSelectedPoint(null);
                TToolBar.this.panel().selectedSteps.clear();
                JMenuItem source = (JMenuItem)e.getSource();
                for (TTrack track : TToolBar.this.panel().measuringTools) {
                    if (!e.getActionCommand().equals(track.getName())) continue;
                    if (source.isSelected()) {
                        TToolBar.this.panel().visibleMeasuringTools.add(track);
                        for (TTrack next : TToolBar.this.panel().visibleMeasuringTools) {
                            this.showMeasuringTool(next);
                        }
                        continue;
                    }
                    this.hideMeasuringTool(track);
                    TToolBar.this.panel().visibleMeasuringTools.remove(track);
                }
            }
            this.refresh();
        }

        void showMeasuringTool(TTrack track) {
            CircleFitter fitter;
            CircleFitterStep step;
            track.erase();
            track.setVisible(true);
            if (track.ttype == 1 && (step = (CircleFitterStep)(fitter = (CircleFitter)track).getStep(0)).getValidDataPoints().size() < 3) {
                TToolBar.this.panel().setSelectedTrack(track);
            }
        }

        void hideMeasuringTool(TTrack track) {
            track.setVisible(false);
            if (TToolBar.this.panel().getSelectedTrack() == track) {
                TToolBar.this.panel().setSelectedTrack(null);
            }
        }

        void refresh() {
            this.setToolTipText(TrackerRes.getString("TToolbar.Button.RulerVisible.Tooltip"));
            for (TTrack track : TToolBar.this.panel().measuringTools) {
                track.updateListenerVisible(TToolBar.this);
            }
            boolean toolsVisible = false;
            for (TTrack track : TToolBar.this.panel().measuringTools) {
                if (!track.isVisible()) continue;
                TToolBar.this.panel().visibleMeasuringTools.add(track);
                toolsVisible = true;
            }
            this.setSelected(toolsVisible);
        }
    }
}

