/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.opensourcephysics.cabrillo.tracker.AutoTracker;
import org.opensourcephysics.cabrillo.tracker.Calibration;
import org.opensourcephysics.cabrillo.tracker.CircleFitter;
import org.opensourcephysics.cabrillo.tracker.CircleFootprint;
import org.opensourcephysics.cabrillo.tracker.CoordAxes;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.LineProfile;
import org.opensourcephysics.cabrillo.tracker.NumberFormatDialog;
import org.opensourcephysics.cabrillo.tracker.OffsetOrigin;
import org.opensourcephysics.cabrillo.tracker.PlotTView;
import org.opensourcephysics.cabrillo.tracker.PlotTrackView;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.Protractor;
import org.opensourcephysics.cabrillo.tracker.RGBRegion;
import org.opensourcephysics.cabrillo.tracker.ReferenceFrame;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TMenuBar;
import org.opensourcephysics.cabrillo.tracker.TMouseHandler;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.TTrackBar;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.TableTView;
import org.opensourcephysics.cabrillo.tracker.TableTrackView;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.TrackProperties;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.cabrillo.tracker.UnitsDialog;
import org.opensourcephysics.cabrillo.tracker.Vector;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawableTextLine;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.media.core.DecimalField;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionPanel;

public abstract class TTrack
extends OSPRuntime.Supported
implements Interactive,
Trackable,
PropertyChangeListener {
    public static final String PROPERTY_TTRACK_FOOTPRINT = "footprint";
    public static final String PROPERTY_TTRACK_MASS = "mass";
    public static final String PROPERTY_TTRACK_MODELEND = "model_end";
    public static final String PROPERTY_TTRACK_MODELSTART = "model_start";
    public static final String PROPERTY_TTRACK_NAME = "name";
    public static final String PROPERTY_TTRACK_STEP = "step";
    public static final String PROPERTY_TTRACK_STEPS = "steps";
    public static final String PROPERTY_TTRACK_FORMAT = "format";
    public static final String PROPERTY_TTRACK_VISIBLE = "visible";
    public static final String PROPERTY_TTRACK_DATA = "data";
    public static final String PROPERTY_TTRACK_COLOR = "color";
    public static final String PROPERTY_TTRACK_LOCKED = "locked";
    public static final String PROPERTY_TTRACK_TEXTCOLUMN = "text_column";
    public static final Integer HINT_STEP_ADDED_OR_REMOVED = -2;
    public static final Integer HINT_STEPS_SELECTED = -3;
    private static final String[] panelEventsTTrack = new String[]{"radian_angles", "magnification", "stepnumber", "data", "coords", "transform", "imagespace"};
    private static HashMap<Integer, TTrack> panelActiveTracks = new HashMap();
    public final int ttype;
    protected static JDialog skippedStepWarningDialog;
    protected static JTextPane skippedStepWarningTextpane;
    protected static JCheckBox skippedStepWarningCheckbox;
    protected static JButton closeButton;
    protected static NameDialog nameDialog;
    protected static int nextID;
    protected String name = TrackerRes.getString("TTrack.Name.None");
    protected String description = "";
    protected boolean visible = true;
    protected boolean trailVisible = false;
    protected int trailLength = 0;
    protected boolean locked = false;
    protected boolean enabled = true;
    protected boolean viewable = true;
    protected Footprint[] footprints = new Footprint[0];
    protected Footprint footprint;
    protected Footprint defaultFootprint;
    protected Color[] defaultColors = new Color[]{Color.red};
    protected StepArray steps = new StepArray();
    protected HashMap<String, Object> properties = new HashMap();
    protected DatasetManager datasetManager;
    protected final Point2D.Double[] points = new Point2D.Double[]{new Point2D.Double()};
    protected ArrayList<Component> toolbarTrackComponents = new ArrayList();
    protected ArrayList<Component> toolbarPointComponents = new ArrayList();
    protected Map<String, NumberField[]> numberFields = new TreeMap<String, NumberField[]>();
    protected boolean autoAdvance;
    protected boolean markByDefault = false;
    protected boolean isMarking = false;
    protected TextLineLabel xLabel;
    protected TextLineLabel yLabel;
    protected TextLineLabel magLabel;
    protected TextLineLabel angleLabel;
    protected boolean undoEnabled = true;
    protected ActionListener footprintListener;
    protected ActionListener circleFootprintListener;
    protected Font labelFont = new Font("arial", 0, 12);
    protected TrackerPanel tp;
    protected TFrame tframe;
    protected XMLProperty dataProp;
    protected Object[][] constantsLoadedFromXML;
    protected String[] dataDescriptions;
    protected boolean initialized = true;
    protected boolean dataValid;
    protected boolean refreshDataLater;
    protected int[] preferredColumnOrder;
    protected ArrayList<Integer> dataFrames = new ArrayList();
    protected String partName;
    protected String hint;
    protected int stepSizeWhenFirstMarked;
    protected TreeSet<Integer> keyFrames = new TreeSet();
    protected boolean autoTrackerMarking;
    protected int targetIndex;
    protected TTrack[] attachments;
    protected String[] attachmentNames;
    protected Map<String, String[]> textColumnEntries = new TreeMap<String, String[]>();
    protected ArrayList<String> textColumnNames = new ArrayList();
    protected MouseAdapter formatMouseListener;
    protected MouseAdapter formatAngleMouseListener;
    protected String[] customNumberFormats;
    private int ID;
    protected JLabel tLabel;
    protected JLabel stepLabel;
    protected JLabel tValueLabel;
    protected JLabel stepValueLabel;
    protected NumberField tField;
    protected NumberField xField;
    protected NumberField yField;
    protected NumberField magField;
    protected DecimalField angleField;
    protected NumberField[] positionFields;
    protected Border fieldBorder;
    protected JSpinner xSpinner;
    protected JSpinner ySpinner;
    protected JMenu footprintMenu;
    protected Component tSeparator;
    protected Component xSeparator;
    protected Component ySeparator;
    protected Component magSeparator;
    protected Component angleSeparator;
    protected Component stepSeparator;
    protected JCheckBoxMenuItem visibleItem;
    protected JCheckBoxMenuItem trailVisibleItem;
    protected JCheckBoxMenuItem markByDefaultItem;
    protected JCheckBoxMenuItem autoAdvanceItem;
    protected JCheckBoxMenuItem lockedItem;
    protected JCheckBoxMenuItem fixedItem;
    protected JMenuItem nameItem;
    protected JMenuItem colorItem;
    protected JMenuItem deleteTrackItem;
    protected JMenuItem deleteStepItem;
    protected JMenuItem clearStepsItem;
    protected JMenuItem descriptionItem;
    protected JMenuItem dataBuilderItem;
    private static final String[] baseTrackTypes;
    private static final TreeMap<String, String>[] defaultFormatPatterns;
    private static final TreeMap<String, String>[] prevDefaultPatterns;
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_CALIBRATION = 0;
    public static final int TYPE_CIRCLEFITTER = 1;
    public static final int TYPE_COORDAXES = 2;
    public static final int TYPE_LINEPROFILE = 3;
    public static final int TYPE_OFFSETORIGIN = 4;
    public static final int TYPE_POINTMASS = 5;
    public static final int TYPE_PROTRACTOR = 6;
    public static final int TYPE_RGBREGION = 7;
    public static final int TYPE_TAPEMEASURE = 8;
    public static final int TYPE_VECTOR = 9;
    public static final int TYPE_PERSPECTIVE = 10;
    protected static final Map<String, String[]> NOMAP;
    protected static final Map<String, String> NOMAPS;
    protected static final String[] NOVARS;
    protected static final ArrayList<String> NOVARA;

    static {
        nextID = 1;
        baseTrackTypes = new String[]{"Calibaration", "CircleFitter", "CoordAxes", "LineProfile", "OffsetOrigin", "PointMass", "Protractor", "RGBRegion", "TapeMeasure", "Vector", "Perspective"};
        defaultFormatPatterns = new TreeMap[baseTrackTypes.length];
        prevDefaultPatterns = new TreeMap[baseTrackTypes.length];
        NOMAP = new HashMap<String, String[]>();
        NOMAPS = new HashMap<String, String>();
        NOVARS = new String[0];
        NOVARA = new ArrayList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void propertyChange(PropertyChangeEvent e) {
        block27: {
            if (!(e.getSource() instanceof TrackerPanel)) break block27;
            TrackerPanel trackerPanel = (TrackerPanel)e.getSource();
            switch (e.getPropertyName()) {
                case "radian_angles": {
                    this.setAnglesInRadians((Boolean)e.getNewValue());
                    return;
                }
                case "magnification": {
                    this.erase();
                    return;
                }
                case "data": {
                    this.dataValid = false;
                    return;
                }
                case "imagespace": {
                    this.erase(trackerPanel.getID());
                    return;
                }
                case "coords": 
                case "transform": {
                    if (this.ttype != 5) {
                        this.dataValid = false;
                    }
                    this.erase();
                    TFrame.repaintT(trackerPanel);
                }
                default: {
                    return;
                }
                case "stepnumber": 
                case "adjusting": {
                    return;
                }
            }
        }
        System.out.println("??? TTRack " + e);
    }

    public void setTrackerPanel(TrackerPanel panel) {
        if (this.tp != null) {
            this.removePanelEvents(panelEventsTTrack);
        }
        if (panel == null) {
            this.tp = null;
            this.tframe = null;
        } else {
            this.tp = panel.ref(this);
            this.tframe = panel.getTFrame();
            this.addPanelEvents(panelEventsTTrack);
        }
    }

    protected void addPanelEvents(String[] events) {
        int i = events.length;
        while (--i >= 0) {
            this.tp.addPropertyChangeListener(events[i], this);
        }
    }

    protected void removePanelEvents(String[] events) {
        int i = events.length;
        while (--i >= 0) {
            this.tp.removePropertyChangeListener(events[i], this);
        }
    }

    public void addListener(TrackerPanel panel) {
        this.addPropertyChangeListener(PROPERTY_TTRACK_FORMAT, panel);
        this.addPropertyChangeListener(PROPERTY_TTRACK_MASS, panel);
        this.addPropertyChangeListener(PROPERTY_TTRACK_MODELEND, panel);
        this.addPropertyChangeListener(PROPERTY_TTRACK_MODELSTART, panel);
        this.addPropertyChangeListener(PROPERTY_TTRACK_NAME, panel);
        this.addPropertyChangeListener(PROPERTY_TTRACK_FOOTPRINT, panel);
        this.addStepListener(panel);
    }

    public void removeListener(TrackerPanel panel) {
        this.removePropertyChangeListener(PROPERTY_TTRACK_FORMAT, panel);
        this.removePropertyChangeListener(PROPERTY_TTRACK_MASS, panel);
        this.removePropertyChangeListener(PROPERTY_TTRACK_MODELEND, panel);
        this.removePropertyChangeListener(PROPERTY_TTRACK_MODELSTART, panel);
        this.removePropertyChangeListener(PROPERTY_TTRACK_NAME, panel);
        this.removePropertyChangeListener(PROPERTY_TTRACK_FOOTPRINT, panel);
        this.removeStepListener(panel);
        this.removePropertyChangeListener(PROPERTY_TTRACK_VISIBLE, panel);
    }

    public void addListenerNCF(PropertyChangeListener l) {
        this.addPropertyChangeListener(PROPERTY_TTRACK_NAME, l);
        this.addPropertyChangeListener(PROPERTY_TTRACK_COLOR, l);
        this.addPropertyChangeListener(PROPERTY_TTRACK_FOOTPRINT, l);
    }

    public void removeListenerNCF(PropertyChangeListener l) {
        this.removePropertyChangeListener(PROPERTY_TTRACK_NAME, l);
        this.removePropertyChangeListener(PROPERTY_TTRACK_COLOR, l);
        this.removePropertyChangeListener(PROPERTY_TTRACK_FOOTPRINT, l);
    }

    public void addStepListener(PropertyChangeListener c) {
        this.addPropertyChangeListener(PROPERTY_TTRACK_STEP, c);
        this.addPropertyChangeListener(PROPERTY_TTRACK_STEPS, c);
    }

    public void removeStepListener(PropertyChangeListener c) {
        this.removePropertyChangeListener(PROPERTY_TTRACK_STEP, c);
        this.removePropertyChangeListener(PROPERTY_TTRACK_STEPS, c);
    }

    public void updateListenerVisible(PropertyChangeListener l) {
        this.removePropertyChangeListener(PROPERTY_TTRACK_VISIBLE, l);
        this.addPropertyChangeListener(PROPERTY_TTRACK_VISIBLE, l);
    }

    public static String getBaseTrackName(int ttype) {
        return ttype >= 0 ? baseTrackTypes[ttype] : null;
    }

    public static TreeMap<String, String>[] getDefaultFormatPatterns() {
        return defaultFormatPatterns;
    }

    public static void savePatterns(TrackerPanel panel) {
        int ttype = baseTrackTypes.length;
        while (--ttype >= 0) {
            TreeMap<String, String> prevPatterns = new TreeMap<String, String>();
            prevPatterns.putAll(panel.getFormatPatterns(ttype));
            TTrack.prevDefaultPatterns[ttype] = prevPatterns;
        }
    }

    public static void restorePatterns(TrackerPanel panel) {
        TreeMap<String, String>[] patterns = panel.formatPatterns;
        int ttype = baseTrackTypes.length;
        while (--ttype >= 0) {
            patterns[ttype] = prevDefaultPatterns[ttype];
        }
    }

    protected TTrack(int ttype) {
        this.ttype = ttype;
        OSPLog.notify(this, "<init>");
        this.ID = nextID++;
        this.stepLabel = new JLabel();
        this.stepLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.stepValueLabel = new JLabel();
        this.stepValueLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.tLabel = new JLabel();
        this.tLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
        this.tValueLabel = new JLabel();
        this.tValueLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
        this.tField = new TrackDecimalField(this, 3){

            @Override
            public void setValue(double value) {
                super.setValue(value);
                tValueLabel.setText("(" + tField.getText() + ")");
            }
        };
        this.tField.setUnits("s");
        SpinnerNumberModel model = new SpinnerNumberModel(0.0, -100.0, 100.0, 0.1);
        this.xSpinner = new JSpinner(model);
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.xSpinner, "0.00");
        editor.getTextField().setHorizontalAlignment(2);
        this.xSpinner.setEditor(editor);
        model = new SpinnerNumberModel(0.0, -100.0, 100.0, 0.1);
        this.ySpinner = new JSpinner(model);
        editor = new JSpinner.NumberEditor(this.ySpinner, "0.00");
        editor.getTextField().setHorizontalAlignment(2);
        this.ySpinner.setEditor(editor);
        this.stepSeparator = Box.createRigidArea(new Dimension(4, 4));
        this.tSeparator = Box.createRigidArea(new Dimension(6, 4));
        this.xSeparator = Box.createRigidArea(new Dimension(6, 4));
        this.ySeparator = Box.createRigidArea(new Dimension(6, 4));
        this.magSeparator = Box.createRigidArea(new Dimension(6, 4));
        this.angleSeparator = Box.createRigidArea(new Dimension(6, 4));
        this.formatMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (OSPRuntime.isPopupTrigger(e)) {
                    TTrack.this.showFormatPopup((NumberField)e.getSource());
                }
            }
        };
        this.formatAngleMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e == null || OSPRuntime.isPopupTrigger(e)) {
                    TTrack.this.showAnglePopup(e == null ? TTrack.this.angleField : (NumberField)e.getSource());
                }
            }
        };
        this.xLabel = new TextLineLabel();
        this.yLabel = new TextLineLabel();
        this.magLabel = new TextLineLabel();
        this.angleLabel = new TextLineLabel();
        this.xField = new TrackNumberField();
        this.yField = new TrackNumberField();
        this.magField = new TrackNumberField();
        this.magField.setMinValue(0.0);
        this.xField.addMouseListener(this.formatMouseListener);
        this.yField.addMouseListener(this.formatMouseListener);
        this.magField.addMouseListener(this.formatMouseListener);
        this.angleField = new TrackDecimalField(1);
        this.angleField.addMouseListener(this.formatAngleMouseListener);
        Border empty = BorderFactory.createEmptyBorder(0, 3, 0, 3);
        Color grey = new Color(102, 102, 102);
        Border etch = BorderFactory.createEtchedBorder(Color.white, grey);
        this.fieldBorder = BorderFactory.createCompoundBorder(etch, empty);
        this.tField.setBorder(this.fieldBorder);
        this.xField.setBorder(this.fieldBorder);
        this.yField.setBorder(this.fieldBorder);
        this.magField.setBorder(this.fieldBorder);
        this.angleField.setBorder(this.fieldBorder);
        this.positionFields = new NumberField[]{this.xField, this.yField, this.magField, this.angleField};
        this.footprintListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String footprintName = e.getActionCommand();
                if (TTrack.this.getFootprint().getName().equals(footprintName)) {
                    return;
                }
                XMLControlElement control = new XMLControlElement(new TrackProperties(TTrack.this));
                TTrack.this.setFootprint(footprintName);
                Undo.postTrackDisplayEdit(TTrack.this, control);
            }
        };
        this.circleFootprintListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TTrack.this.footprintListener.actionPerformed(e);
                CircleFootprint cfp = (CircleFootprint)TTrack.this.getFootprint();
                cfp.showProperties(TTrack.this);
            }
        };
    }

    protected void showAnglePopup(NumberField field) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem item = new JMenuItem();
        final boolean radians = field.getConversionFactor() == 1.0;
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TTrack.this.tframe.setAnglesInRadians(!radians);
            }
        });
        item.setText(radians ? TrackerRes.getString("TTrack.AngleField.Popup.Degrees") : TrackerRes.getString("TTrack.AngleField.Popup.Radians"));
        popup.add(item);
        popup.addSeparator();
        if (this.tp.isEnabled("number.formats")) {
            item = new JMenuItem();
            final String[] selected = new String[]{this.getNumberFieldName0(field)};
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NumberFormatDialog.getNumberFormatDialog(TTrack.this.tp, TTrack.this, selected).setVisible(true);
                }
            });
            item.setText(TrackerRes.getString("TTrack.MenuItem.NumberFormat"));
            popup.add(item);
        }
        FontSizer.setFonts(popup, FontSizer.getLevel());
        popup.show(field, 0, this.angleField.getHeight());
    }

    protected void showFormatPopup(NumberField field) {
        boolean hasMassUnit;
        String[] fieldName = null;
        boolean hasUnits = false;
        String name = this.getNumberFieldName0(field);
        if (name != null) {
            fieldName = new String[]{name};
            String s = TTrack.getVariableDimensions(this, name);
            hasUnits = s.contains("L") || s.contains("M") || s.contains("T");
        }
        JPopupMenu popup = new JPopupMenu();
        if (this.tp.isEnabled("number.formats") || this.tp.isEnabled("number.units")) {
            JMenuItem item;
            JMenu numberMenu = new JMenu(TrackerRes.getString("Popup.Menu.Numbers"));
            popup.add(numberMenu);
            if (this.tp.isEnabled("number.formats")) {
                item = new JMenuItem();
                final String[] selected = fieldName;
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NumberFormatDialog.getNumberFormatDialog(TTrack.this.tp, TTrack.this, selected).setVisible(true);
                    }
                });
                item.setText(String.valueOf(TrackerRes.getString("Popup.MenuItem.Formats")) + "...");
                numberMenu.add(item);
            }
            if (hasUnits && this.tp.isEnabled("number.units")) {
                item = new JMenuItem();
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        UnitsDialog dialog = TTrack.this.tp.getUnitsDialog();
                        dialog.setVisible(true);
                    }
                });
                item.setText(String.valueOf(TrackerRes.getString("Popup.MenuItem.Units")) + "...");
                numberMenu.add(item);
            }
        }
        boolean hasLengthUnit = this.tp.lengthUnit != null;
        boolean bl = hasMassUnit = this.tp.massUnit != null;
        if (hasLengthUnit && hasMassUnit) {
            JMenuItem item = new JMenuItem();
            final boolean vis = this.tp.isUnitsVisible();
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TTrack.this.tp.setUnitsVisible(!vis);
                }
            });
            item.setText(vis ? TrackerRes.getString("TTrack.MenuItem.HideUnits") : TrackerRes.getString("TTrack.MenuItem.ShowUnits"));
            if (popup.getComponentCount() > 0) {
                popup.addSeparator();
            }
            popup.add(item);
        }
        FontSizer.setFonts(popup, FontSizer.getLevel());
        popup.show(field, 0, field.getHeight());
    }

    private String getNumberFieldName0(NumberField field) {
        for (String name : this.getNumberFields().keySet()) {
            if (this.numberFields.get(name)[0] != field) continue;
            return name;
        }
        return null;
    }

    public void setVisible(boolean visible) {
        Boolean prev = this.visible;
        this.visible = visible;
        this.firePropertyChange(PROPERTY_TTRACK_VISIBLE, prev, visible);
        if (this.tp != null) {
            TFrame.repaintT(this.tp);
        }
    }

    public void delete() {
        this.delete(true);
    }

    protected void delete(boolean postEdit) {
        if (this.isLocked() && !this.isDependent()) {
            return;
        }
        if (this.tp != null) {
            this.tp.setSelectedPoint(null);
            this.tp.selectedSteps.clear();
            ImageCoordSystem coords = this.tp.getCoords();
            if (coords instanceof ReferenceFrame && ((ReferenceFrame)coords).getOriginTrack() == this) {
                coords = ((ReferenceFrame)coords).getCoords();
                this.tp.setCoords(coords);
            }
        }
        if (postEdit) {
            Undo.postTrackDelete(this);
        }
        this.erase();
        int j = 0;
        while (j < this.tp.andWorld.size()) {
            TrackerPanel panel = this.panel(this.tp.andWorld.get(j));
            panel.removeTrack(this);
            ++j;
        }
        this.dispose();
    }

    TrackerPanel panel(Integer panelID) {
        return this.tframe.getTrackerPanelForID(panelID);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setTrailVisible(boolean visible) {
        this.trailVisible = visible;
    }

    public boolean isTrailVisible() {
        return this.trailVisible;
    }

    public void setTrailLength(int steps) {
        this.trailLength = Math.max(0, steps);
    }

    public int getTrailLength() {
        if (this.isMarking) {
            return 1;
        }
        return this.trailLength;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        this.firePropertyChange(PROPERTY_TTRACK_LOCKED, null, locked);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setAutoAdvance(boolean auto) {
        this.autoAdvance = auto;
    }

    public boolean isAutoAdvance() {
        return this.autoAdvance;
    }

    public void setMarkByDefault(boolean mark) {
        this.markByDefault = mark;
    }

    public boolean isMarkByDefault() {
        return this.markByDefault;
    }

    public Color getColor() {
        if (this.footprint == null) {
            return this.defaultColors[0];
        }
        return this.footprint.getColor();
    }

    public void setColor(Color color) {
        if (color == null) {
            color = this.defaultColors[0];
        }
        int i = 0;
        while (i < this.footprints.length) {
            this.footprints[i].setColor(color);
            ++i;
        }
        this.erase();
        if (this.tp != null) {
            FunctionPanel panel;
            this.tp.changed = true;
            if (this.tp.modelBuilder != null) {
                this.tp.modelBuilder.refreshDropdown(null);
            }
            if (this.tp.dataBuilder != null && (panel = this.tp.dataBuilder.getPanel(this.getName())) != null) {
                panel.setIcon(this.getIcon(21, 16, "track"));
                this.tp.dataBuilder.refreshDropdown(null);
            }
        }
        this.firePropertyChange(PROPERTY_TTRACK_COLOR, null, color);
    }

    public void setColorToDefault(int index) {
        this.setColor(this.defaultColors[index % this.defaultColors.length]);
    }

    public void setDefaultNameAndColor(TrackerPanel trackerPanel, String connector) {
        String name = trackerPanel.getNextName(this.getName(), connector);
        this.setName(name);
        this.setColorToDefault(name.charAt(name.length() - 1) - 65);
    }

    public int getID() {
        return this.ID;
    }

    public String getName() {
        return this.name;
    }

    public String getName(String context) {
        return this.getName();
    }

    public void setName(String newName) {
        if (newName != null && !newName.trim().equals("")) {
            String prevName = this.name;
            this.name = newName;
            this.repaint();
            if (this.tp != null) {
                this.tp.changed = true;
                if (this.tp.dataBuilder != null) {
                    this.tp.dataBuilder.renamePanel(prevName, newName);
                }
                if (this.tp.modelBuilder != null) {
                    this.tp.modelBuilder.refreshBoosterDropdown();
                }
            }
            this.firePropertyChange(PROPERTY_TTRACK_NAME, prevName, this.name);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        if (desc == null) {
            desc = "";
        }
        this.description = desc;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.name + " " + this.ID;
    }

    public void finalize() {
        OSPLog.finalized(this);
    }

    public String getMessage() {
        String s = this.getName();
        if (this.partName != null) {
            s = String.valueOf(s) + " " + this.partName;
        }
        if (this.isLocked() && !TrackerRes.getString("PointMass.Position.Locked.Hint").equals(this.hint)) {
            this.hint = TrackerRes.getString("TTrack.Locked.Hint");
        }
        if (Tracker.showHints && this.hint != null) {
            s = String.valueOf(s) + " (" + this.hint + ")";
        }
        return s;
    }

    public void setViewable(boolean viewable) {
        this.viewable = viewable;
    }

    public boolean isViewable() {
        return this.viewable;
    }

    public boolean isDependent() {
        return false;
    }

    public void setFootprints(Footprint[] choices) {
        ArrayList<Footprint> valid = new ArrayList<Footprint>();
        int i = 0;
        while (i < choices.length) {
            if (choices[i] != null && choices[i].getLength() <= this.getFootprintLength()) {
                if (this.getFootprint() != null) {
                    choices[i].setColor(this.getColor());
                }
                valid.add(choices[i]);
            }
            ++i;
        }
        if (valid.size() > 0) {
            this.footprints = valid.toArray(new Footprint[0]);
            this.setFootprint(this.footprints[0].getName());
        }
    }

    public void setFootprints(Footprint[] choices, Step step) {
        this.setFootprints(choices);
    }

    public Footprint[] getFootprints() {
        return this.footprints;
    }

    public Footprint[] getFootprints(Step step) {
        return this.footprints;
    }

    public void addFootprint(Footprint footprint) {
        if (footprint.getLength() == this.getFootprintLength()) {
            Footprint[] prints = new Footprint[this.footprints.length + 1];
            System.arraycopy(this.footprints, 0, prints, 0, this.footprints.length);
            prints[this.footprints.length] = footprint;
            this.footprints = prints;
        }
    }

    public void setFootprint(String name) {
        if (name == null) {
            return;
        }
        String props = null;
        int n = name.indexOf("#");
        if (n > -1) {
            props = name.substring(n + 1);
            name = name.substring(0, n);
        }
        int i = 0;
        while (i < this.footprints.length) {
            if (name.equals(this.footprints[i].getName())) {
                this.footprint = this.footprints[i];
                if (this.footprint instanceof CircleFootprint) {
                    ((CircleFootprint)this.footprint).setProperties(props);
                }
                Step[] stepArray = this.steps.array;
                int j = 0;
                while (j < stepArray.length) {
                    if (stepArray[j] != null) {
                        stepArray[j].setFootprint(this.footprint);
                    }
                    ++j;
                }
                this.repaint();
                if (this.tp != null) {
                    FunctionPanel panel;
                    this.tp.changed = true;
                    if (this.tp.modelBuilder != null) {
                        this.tp.modelBuilder.refreshDropdown(null);
                    }
                    if (this.tp.dataBuilder != null && (panel = this.tp.dataBuilder.getPanel(this.getName())) != null) {
                        panel.setIcon(this.getIcon(21, 16, "track"));
                        this.tp.dataBuilder.refreshDropdown(null);
                    }
                }
                this.firePropertyChange(PROPERTY_TTRACK_FOOTPRINT, null, this.footprint);
                return;
            }
            ++i;
        }
    }

    public String getFootprintName() {
        Footprint fp = this.getFootprint();
        String s = fp.getName();
        if (fp instanceof CircleFootprint) {
            CircleFootprint cfp = (CircleFootprint)fp;
            s = String.valueOf(s) + "#" + cfp.getProperties();
        }
        return s;
    }

    public Footprint getFootprint() {
        return this.footprint;
    }

    public void setFootprint(String name, Step step) {
        this.setFootprint(name);
    }

    public Footprint getFootprint(Step step) {
        return this.getFootprint();
    }

    public Icon getIcon(int w, int h, String context) {
        return this.getFootprint().getIcon(w, h);
    }

    public abstract int getStepLength();

    public abstract int getFootprintLength();

    public abstract Step createStep(int var1, double var2, double var4);

    public Step deleteStep(int n) {
        if (this.locked) {
            return null;
        }
        Step step = this.steps.getStep(n);
        if (step != null) {
            XMLControlElement control = new XMLControlElement(this);
            this.steps.setStep(n, null);
            for (String columnName : this.textColumnNames) {
                String[] entries = this.textColumnEntries.get(columnName);
                if (entries.length <= n) continue;
                entries[n] = null;
            }
            if (!this.isDependent()) {
                Undo.postTrackEdit(this, control);
            }
            this.firePropertyChange(PROPERTY_TTRACK_STEP, HINT_STEP_ADDED_OR_REMOVED, new Integer(n));
        }
        return step;
    }

    public Step getStep(int n) {
        return this.steps.getStep(n);
    }

    public Step getNextVisibleStep(Step step, TrackerPanel panel) {
        Step[] steps = this.getSteps();
        boolean found = false;
        int i = 0;
        while (i < steps.length) {
            if (found && steps[i] != null && this.isStepVisible(steps[i], panel)) {
                return steps[i];
            }
            if (steps[i] == step) {
                found = true;
            }
            ++i;
        }
        if (found) {
            i = 0;
            while (i < steps.length) {
                if (steps[i] != null && steps[i] != step && this.isStepVisible(steps[i], panel)) {
                    return steps[i];
                }
                ++i;
            }
        }
        return null;
    }

    public Step getPreviousVisibleStep(Step step, TrackerPanel trackerPanel) {
        Step[] steps = this.getSteps();
        boolean found = false;
        int i = steps.length - 1;
        while (i > -1) {
            if (found && steps[i] != null && this.isStepVisible(steps[i], trackerPanel)) {
                return steps[i];
            }
            if (steps[i] == step) {
                found = true;
            }
            --i;
        }
        if (found) {
            i = steps.length - 1;
            while (i > -1) {
                if (steps[i] != null && steps[i] != step && this.isStepVisible(steps[i], trackerPanel)) {
                    return steps[i];
                }
                --i;
            }
        }
        return null;
    }

    public Step getStep(TPoint point, TrackerPanel trackerPanel) {
        if (point == null) {
            return null;
        }
        Step[] stepArray = this.steps.array;
        int j = 0;
        while (j < stepArray.length) {
            if (stepArray[j] != null) {
                TPoint[] points = stepArray[j].getPoints();
                int i = 0;
                while (i < points.length) {
                    if (points[i] == point) {
                        return stepArray[j];
                    }
                    ++i;
                }
            }
            ++j;
        }
        return null;
    }

    public Step[] getSteps() {
        return this.steps.array;
    }

    public boolean isStepComplete(int n) {
        Step step;
        if (this.isMarkByDefault() && (step = this.getStep(n)) != null) {
            TPoint[] points = step.getPoints();
            int i = 0;
            while (i < points.length) {
                if (points[i] == null) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public TPoint autoMarkAt(int n, double x, double y) {
        this.createStep(n, x, y);
        return this.getMarkedPoint(n, this.getTargetIndex());
    }

    public TPoint getMarkedPoint(int n, int index) {
        Step step = this.getStep(n);
        if (step == null) {
            return null;
        }
        return step.getPoints()[index];
    }

    protected int getTargetIndex() {
        return this.targetIndex;
    }

    protected void setTargetIndex(int index) {
        if (this.isAutoTrackable(index)) {
            this.targetIndex = index;
        }
    }

    protected void setTargetIndex(String description) {
        int i = 0;
        while (i < this.getStepLength()) {
            if (description.equals(this.getTargetDescription(i))) {
                this.setTargetIndex(i);
                break;
            }
            ++i;
        }
    }

    protected void setTargetIndex(TPoint p) {
        Step step = this.getStep(p, this.tp);
        if (step != null) {
            this.setTargetIndex(step.getPointIndex(p));
        }
    }

    protected String getTargetDescription(int pointIndex) {
        return null;
    }

    protected boolean isAutoTrackable(int pointIndex) {
        return true;
    }

    protected boolean isAutoTrackable() {
        return false;
    }

    public boolean isEmpty() {
        Step[] array = this.steps.array;
        int n = 0;
        while (n < array.length) {
            if (array[n] != null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected NumberField[] getNumberFieldsForStep(Step step) {
        return this.positionFields;
    }

    public void setFontLevel(int level) {
        Object[] objectsToSize = new Object[]{this.tLabel, this.xLabel, this.yLabel, this.magLabel, this.angleLabel, this.stepLabel, this.tValueLabel, this.stepValueLabel, this.tField, this.xField, this.yField, this.magField, this.angleField};
        FontSizer.setFonts(objectsToSize);
        this.erase();
    }

    public DatasetManager getData(TrackerPanel panel) {
        if (this.datasetManager == null) {
            this.datasetManager = new DatasetManager(true);
            this.datasetManager.setSorted(true);
        }
        if (this.refreshDataLater || this.dataValid) {
            return this.datasetManager;
        }
        this.dataValid = true;
        this.refreshData(this.datasetManager, panel);
        if (this.constantsLoadedFromXML != null) {
            int i = 0;
            while (i < this.constantsLoadedFromXML.length) {
                String name = (String)this.constantsLoadedFromXML[i][0];
                double val = (Double)this.constantsLoadedFromXML[i][1];
                String expression = (String)this.constantsLoadedFromXML[i][2];
                String desc = this.constantsLoadedFromXML[i].length < 4 ? null : (String)this.constantsLoadedFromXML[i][3];
                this.datasetManager.setConstant(name, val, expression, desc);
                ++i;
            }
            this.constantsLoadedFromXML = null;
        }
        if (this.dataProp != null) {
            XMLControl[] children = this.dataProp.getChildControls();
            int i = 0;
            while (i < children.length) {
                block11: {
                    String name = children[i].getString("function_name");
                    for (Dataset next : this.datasetManager.getDatasetsRaw()) {
                        if (!(next instanceof DataFunction) || !next.getYColumnName().equals(name)) {
                            continue;
                        }
                        break block11;
                    }
                    DataFunction f = new DataFunction(this.datasetManager);
                    children[i].loadObject(f);
                    f.setXColumnVisible(false);
                    this.datasetManager.addDataset(f);
                }
                ++i;
            }
            this.dataProp = null;
        }
        ArrayList<Dataset> datasets = this.datasetManager.getDatasetsRaw();
        int i = 0;
        while (i < datasets.size()) {
            if (datasets.get(i) instanceof DataFunction) {
                ((DataFunction)datasets.get(i)).refreshFunctionData();
            }
            ++i;
        }
        DataTool tool = DataTool.getTool(false);
        if (panel != null && tool != null && tool.isVisible() && tool.getSelectedTab() != null && tool.getSelectedTab().isInterestedIn(this.datasetManager)) {
            tool.getSelectedTab().refreshData();
        }
        return this.datasetManager;
    }

    public DatasetManager getData(TrackerPanel panel, int datasetIndex) {
        return this.getData(panel);
    }

    protected void refreshData(DatasetManager data, TrackerPanel panel) {
    }

    protected void refreshData(DatasetManager data, TrackerPanel trackerPanel, int startFrame, int stepCount) {
        this.refreshData(data, trackerPanel);
    }

    public String getDataName(int index) {
        if (index == 0) {
            return this.datasetManager.getDataset(0).getXColumnName();
        }
        if (index < this.datasetManager.getDatasetsRaw().size() + 1) {
            return this.datasetManager.getDataset(index - 1).getYColumnName();
        }
        return null;
    }

    public String getDataDescription(int index) {
        if (this.dataDescriptions == null) {
            return "";
        }
        if (index >= this.dataDescriptions.length) {
            ArrayList<Dataset> datasets = this.datasetManager.getDatasetsRaw();
            if (--index < datasets.size() && datasets.get(index) instanceof DataFunction) {
                String desc = datasets.get(index).getYColumnDescription();
                if (desc == null) {
                    desc = "";
                }
                return desc;
            }
            return "";
        }
        return this.dataDescriptions[index];
    }

    public ArrayList<Integer> getPreferredDataOrder() {
        int i;
        ArrayList<Integer> orderedData = new ArrayList<Integer>();
        int n = this.datasetManager.getDatasetsRaw().size();
        if (this.preferredColumnOrder != null) {
            i = 0;
            while (i < this.preferredColumnOrder.length) {
                if (!orderedData.contains(this.preferredColumnOrder[i]) && this.preferredColumnOrder[i] < n) {
                    orderedData.add(this.preferredColumnOrder[i]);
                }
                ++i;
            }
        }
        i = 0;
        while (i < n) {
            if (!orderedData.contains(i)) {
                orderedData.add(i);
            }
            ++i;
        }
        return orderedData;
    }

    public int getFrameForData(String xVar, String yVar, double[] xyValues) {
        if (this.dataFrames.isEmpty() || this.datasetManager.getDatasetsRaw().isEmpty()) {
            return -1;
        }
        Dataset dataset = this.datasetManager.getDataset(0);
        double x = xyValues[0];
        if (xVar.equals(dataset.getXColumnName())) {
            int nf = this.dataFrames.size();
            double[] vals = dataset.getXPointsRaw();
            int i = 0;
            int n = dataset.getIndex();
            while (i < n) {
                if (x == vals[i]) {
                    return i < nf ? this.dataFrames.get(i) : -1;
                }
                ++i;
            }
            return -1;
        }
        int index = this.datasetManager.getDatasetIndex(xVar);
        if (index < 0) {
            return -1;
        }
        dataset = this.datasetManager.getDataset(index);
        double[] xVals = dataset.getYPointsRaw();
        double[] yVals = null;
        double y = yVar == null ? Double.NaN : xyValues[1];
        int i = 0;
        int n = dataset.getIndex();
        while (i < n) {
            block10: {
                int frame;
                block11: {
                    if (x != xVals[i]) break block10;
                    int n2 = frame = i < this.dataFrames.size() ? this.dataFrames.get(i) : -1;
                    if (yVar == null) break block11;
                    if (yVals == null) {
                        yVals = this.datasetManager.getDataset(this.datasetManager.getDatasetIndex(yVar)).getYPoints();
                    }
                    if (y != yVals[i]) break block10;
                }
                return frame;
            }
            ++i;
        }
        return -1;
    }

    public void refreshDecimalSeparators() {
        for (String key : this.numberFields.keySet()) {
            NumberField[] fields = this.numberFields.get(key);
            int i = 0;
            while (i < fields.length) {
                fields[i].refreshDecimalSeparators(true);
                ++i;
            }
        }
    }

    protected Map<String, NumberField[]> getNumberFields() {
        return this.numberFields;
    }

    protected static ArrayList<String> getAllVariables(int ttype) {
        switch (ttype) {
            case 0: {
                return Calibration.allVariables;
            }
            case 1: {
                return CircleFitter.allVariables;
            }
            case 2: {
                return CoordAxes.allVariables;
            }
            case 3: {
                return LineProfile.allVariables;
            }
            case 4: {
                return OffsetOrigin.allVariables;
            }
            case 5: {
                return PointMass.allVariables;
            }
            case 6: {
                return Protractor.allVariables;
            }
            case 7: {
                return RGBRegion.allVariables;
            }
            case 8: {
                return TapeMeasure.allVariables;
            }
            case 9: {
                return Vector.allVariables;
            }
        }
        return NOVARA;
    }

    public static int getBaseTypeInt(String type) {
        type = type.substring(type.lastIndexOf(".") + 1);
        int i = baseTrackTypes.length;
        while (--i >= 0) {
            if (!baseTrackTypes[i].equals(type)) continue;
            return i;
        }
        return -1;
    }

    protected static ArrayList<String> createAllVariables(String[] datavars, String[] fieldvars) {
        String next;
        int n;
        int n2;
        String[] stringArray;
        ArrayList<String> list = new ArrayList<String>();
        if (datavars != null) {
            stringArray = datavars;
            n2 = datavars.length;
            n = 0;
            while (n < n2) {
                next = stringArray[n];
                list.add(next);
                ++n;
            }
        }
        if (fieldvars != null) {
            stringArray = fieldvars;
            n2 = fieldvars.length;
            n = 0;
            while (n < n2) {
                next = stringArray[n];
                if (!list.contains(next)) {
                    list.add(next);
                }
                ++n;
            }
        }
        return list;
    }

    protected String[] getVariablesFromFormatterDisplayName(String name) {
        return this.getFormatMap().get(name);
    }

    public ArrayList<String> getTextColumnNames() {
        return this.textColumnNames;
    }

    public boolean addTextColumn(String name) {
        if (name == null || name.trim().equals("")) {
            return false;
        }
        name = name.trim();
        for (String next : this.textColumnNames) {
            if (!next.equals(name)) continue;
            return false;
        }
        XMLControlElement control = new XMLControlElement(this);
        control.setValue("isTextColumn", true);
        this.textColumnNames.add(name);
        this.textColumnEntries.put(name, new String[0]);
        Undo.postTrackEdit(this, control);
        this.tp.changed = true;
        this.firePropertyChange(PROPERTY_TTRACK_TEXTCOLUMN, null, name);
        return true;
    }

    public boolean removeTextColumn(String name) {
        if (name == null) {
            return false;
        }
        name = name.trim();
        for (String next : this.textColumnNames) {
            if (!next.equals(name)) continue;
            XMLControlElement control = new XMLControlElement(this);
            this.textColumnEntries.remove(name);
            this.textColumnNames.remove(name);
            Undo.postTrackEdit(this, control);
            this.tp.changed = true;
            this.firePropertyChange(PROPERTY_TTRACK_TEXTCOLUMN, name, null);
            return true;
        }
        return false;
    }

    public boolean renameTextColumn(String name, String newName) {
        if (name == null) {
            return false;
        }
        name = name.trim();
        if (newName == null || newName.trim().equals("")) {
            return false;
        }
        newName = newName.trim();
        for (String next : this.textColumnNames) {
            if (!next.equals(newName)) continue;
            return false;
        }
        int i = 0;
        while (i < this.textColumnNames.size()) {
            String next = this.textColumnNames.get(i);
            if (name.equals(next)) {
                XMLControlElement control = new XMLControlElement(this);
                this.textColumnNames.remove(name);
                this.textColumnNames.add(i, newName);
                String[] entries = this.textColumnEntries.remove(name);
                this.textColumnEntries.put(newName, entries);
                Undo.postTrackEdit(this, control);
            }
            ++i;
        }
        this.tp.changed = true;
        this.firePropertyChange(PROPERTY_TTRACK_TEXTCOLUMN, name, newName);
        return true;
    }

    public String getTextColumnEntry(String columnName, int frameNumber) {
        if (frameNumber < 0) {
            return null;
        }
        String[] entries = this.textColumnEntries.get(columnName);
        if (entries == null) {
            return null;
        }
        if (frameNumber > entries.length - 1) {
            return null;
        }
        return entries[frameNumber];
    }

    public boolean setTextColumnEntry(String columnName, int frameNumber, String text) {
        String prev;
        if (this.isLocked()) {
            return false;
        }
        if (frameNumber < 0) {
            return false;
        }
        String[] entries = this.textColumnEntries.get(columnName);
        if (entries == null) {
            return false;
        }
        text = text.trim().equals("") ? null : text.trim();
        XMLControlElement control = new XMLControlElement(this);
        if (frameNumber > entries.length - 1) {
            String[] newEntries = new String[frameNumber + 1];
            System.arraycopy(entries, 0, newEntries, 0, entries.length);
            entries = newEntries;
            this.textColumnEntries.put(columnName, entries);
        }
        if ((prev = entries[frameNumber]) == text || prev != null && prev.equals(text)) {
            return false;
        }
        entries[frameNumber] = text;
        Undo.postTrackEdit(this, control);
        this.tp.changed = true;
        this.firePropertyChange(PROPERTY_TTRACK_TEXTCOLUMN, null, null);
        return true;
    }

    protected int getAttachmentLength() {
        return 0;
    }

    public TTrack[] getAttachments() {
        int n = this.getAttachmentLength();
        if (n > 0) {
            if (this.attachments == null) {
                this.attachments = new TTrack[n];
            }
            if (this.attachments.length < n) {
                TTrack[] newAttachments = new TTrack[n];
                System.arraycopy(this.attachments, 0, newAttachments, 0, this.attachments.length);
                this.attachments = newAttachments;
            }
        }
        return this.attachments;
    }

    public String getAttachmentDescription(int n) {
        return String.valueOf(TrackerRes.getString("AttachmentInspector.Label.End")) + " " + (n + 1);
    }

    protected boolean loadAttachmentsFromNames(boolean refresh) {
        int n;
        if (this.attachmentNames == null || (n = this.attachmentNames.length) == 0) {
            return false;
        }
        boolean foundAll = true;
        TTrack[] temp = new TTrack[n];
        ArrayList<TTrack> tracks = this.tp.getTracksTemp();
        int i = 0;
        while (i < n) {
            String name = this.attachmentNames[i];
            if (name != null) {
                TTrack track = this.tp.getTrack(name, tracks);
                if (track == null) {
                    foundAll = false;
                    break;
                }
                temp[i] = track;
            }
            ++i;
        }
        tracks.clear();
        if (foundAll) {
            this.attachments = temp;
            this.attachmentNames = null;
            if (refresh) {
                this.refreshAttachmentsLater();
            }
        }
        return foundAll;
    }

    protected void refreshAttachmentsLater() {
        OSPRuntime.trigger(2000, e -> {
            boolean changed = this.tp != null && this.tp.changed;
            this.refreshAttachments();
            if (this.tp != null) {
                this.tp.changed = changed;
            }
        });
    }

    protected boolean isFullyAttached() {
        int n = this.getAttachmentLength();
        if (n > 0) {
            TTrack[] attached = this.getAttachments();
            int i = 0;
            while (i < n) {
                if (attached[i] == null) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean isAttached() {
        TTrack[] attachments = this.getAttachments();
        int i = 0;
        while (i < attachments.length) {
            if (attachments[i] != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void refreshAttachments() {
        if (this.attachments == null || this.getAttachmentLength() == 0) {
            return;
        }
        if (this.isAttached()) {
            this.setFixedPosition(false);
        }
        VideoClip clip = this.tp.getPlayer().getVideoClip();
        int i = 0;
        while (i < this.attachments.length) {
            int n;
            TTrack targetTrack = this.attachments[i];
            if (targetTrack != null) {
                targetTrack.removeStepListener(this);
                targetTrack.addStepListener(this);
                n = clip.getStartFrameNumber();
                while (n <= clip.getEndFrameNumber()) {
                    Step targetStep = targetTrack.getStep(n);
                    Step step = this.getStep(n);
                    if (step != null) {
                        TPoint p = this.getPoint(step, i);
                        if (targetStep == null) {
                            if (p != null) {
                                p.detach();
                            }
                        } else if (p != null) {
                            TPoint target = targetStep.getPoints()[0];
                            p.attachTo(target);
                        }
                    }
                    ++n;
                }
            } else {
                n = clip.getStartFrameNumber();
                while (n <= clip.getEndFrameNumber()) {
                    TPoint p;
                    Step step = this.getStep(n);
                    if (step != null && (p = this.getPoint(step, i)) != null) {
                        p.detach();
                    }
                    ++n;
                }
            }
            ++i;
        }
        this.tp.refreshTrackBar();
    }

    private TPoint getPoint(Step step, int i) {
        TPoint[] pts = step.points;
        return pts == null || i >= pts.length ? null : pts[i];
    }

    protected void setFixedPosition(boolean b) {
    }

    public JMenu getMenu(final TrackerPanel trackerPanel, JMenu menu) {
        if (menu == null) {
            final JMenu menu0 = new JMenu();
            menu0.setText(this.getName("track"));
            menu0.setIcon(this.getFootprint().getIcon(21, 16));
            menu0.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    menu0.removeAll();
                    TTrack.this.getMenu(trackerPanel, menu0);
                    FontSizer.setMenuFonts(menu0);
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
            return menu0;
        }
        menu.setText(this.getName("track"));
        menu.setIcon(this.getFootprint().getIcon(21, 16));
        this.getMenuItems();
        this.visibleItem.setText(TrackerRes.getString("TTrack.MenuItem.Visible"));
        this.trailVisibleItem.setText(TrackerRes.getString("TTrack.MenuItem.TrailVisible"));
        this.autoAdvanceItem.setText(TrackerRes.getString("TTrack.MenuItem.Autostep"));
        this.markByDefaultItem.setText(TrackerRes.getString("TTrack.MenuItem.MarkByDefault"));
        this.lockedItem.setText(TrackerRes.getString("TTrack.MenuItem.Locked"));
        this.deleteTrackItem.setText(TrackerRes.getString("TTrack.MenuItem.Delete"));
        this.deleteStepItem.setText(TrackerRes.getString("TTrack.MenuItem.DeletePoint"));
        this.clearStepsItem.setText(TrackerRes.getString("TTrack.MenuItem.ClearSteps"));
        this.colorItem.setText(TrackerRes.getString("TTrack.MenuItem.Color"));
        this.nameItem.setText(TrackerRes.getString("TTrack.MenuItem.Name"));
        this.footprintMenu.setText(TrackerRes.getString("TTrack.MenuItem.Footprint"));
        this.descriptionItem.setText(TrackerRes.getString("TTrack.MenuItem.Description"));
        this.dataBuilderItem.setText(TrackerRes.getString("TView.Menuitem.Define"));
        this.visibleItem.setSelected(this.isVisible());
        this.lockedItem.setSelected(this.isLocked());
        this.trailVisibleItem.setSelected(this.isTrailVisible());
        this.markByDefaultItem.setSelected(this.isMarkByDefault());
        this.autoAdvanceItem.setSelected(this.isAutoAdvance());
        this.lockedItem.setEnabled(true);
        boolean cantDeleteSteps = this.isLocked() || this.isDependent();
        TPoint p = trackerPanel.getSelectedPoint();
        Step step = this.getStep(p, trackerPanel);
        this.deleteStepItem.setEnabled(!cantDeleteSteps && step != null);
        this.clearStepsItem.setEnabled(!cantDeleteSteps);
        this.deleteTrackItem.setEnabled(!this.isLocked() || this.isDependent());
        this.nameItem.setEnabled(!this.isLocked() || this.isDependent());
        this.footprintMenu.removeAll();
        Footprint[] fp = this.getFootprints();
        int i = 0;
        while (i < fp.length) {
            JMenuItem item = new JMenuItem(fp[i].getDisplayName(), fp[i].getIcon(21, 16));
            item.setActionCommand(fp[i].getName());
            if (fp[i] instanceof CircleFootprint) {
                item.setText(String.valueOf(fp[i].getDisplayName()) + "...");
                item.addActionListener(this.circleFootprintListener);
            } else {
                item.addActionListener(this.footprintListener);
            }
            if (fp[i] == this.footprint) {
                item.setBorder(BorderFactory.createLineBorder(item.getBackground().darker()));
            }
            this.footprintMenu.add(item);
            ++i;
        }
        if (trackerPanel.isEnabled("track.name") || trackerPanel.isEnabled("track.description")) {
            TMenuBar.checkAddMenuSep(menu);
            if (trackerPanel.isEnabled("track.name")) {
                menu.add(this.nameItem);
            }
            if (trackerPanel.isEnabled("track.description")) {
                menu.add(this.descriptionItem);
            }
        }
        if (trackerPanel.isEnabled("track.color") || trackerPanel.isEnabled("track.footprint")) {
            TMenuBar.checkAddMenuSep(menu);
            if (trackerPanel.isEnabled("track.color")) {
                menu.add(this.colorItem);
            }
            if (trackerPanel.isEnabled("track.footprint")) {
                menu.add(this.footprintMenu);
            }
        }
        if (trackerPanel.isEnabled("track.visible") || trackerPanel.isEnabled("track.locked")) {
            TMenuBar.checkAddMenuSep(menu);
            if (trackerPanel.isEnabled("track.visible")) {
                menu.add(this.visibleItem);
            }
            if (trackerPanel.isEnabled("track.locked")) {
                menu.add(this.lockedItem);
            }
        }
        if (this.isViewable() && trackerPanel.isEnabled("data.builder")) {
            TMenuBar.checkAddMenuSep(menu);
            menu.add(this.dataBuilderItem);
        }
        if (trackerPanel.isEnabled("track.delete")) {
            TMenuBar.checkAddMenuSep(menu);
            menu.add(this.deleteTrackItem);
        }
        return menu;
    }

    protected void getMenuItems() {
        if (this.visibleItem != null) {
            return;
        }
        this.visibleItem = new JCheckBoxMenuItem();
        this.trailVisibleItem = new JCheckBoxMenuItem();
        this.autoAdvanceItem = new JCheckBoxMenuItem();
        this.markByDefaultItem = new JCheckBoxMenuItem();
        this.lockedItem = new JCheckBoxMenuItem();
        this.deleteTrackItem = new JMenuItem();
        this.deleteStepItem = new JMenuItem();
        this.clearStepsItem = new JMenuItem();
        this.colorItem = new JMenuItem();
        this.colorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = TTrack.this.getColor();
                OSPRuntime.chooseColor(color, TrackerRes.getString("TTrack.Dialog.Color.Title"), newColor -> {
                    if (newColor != color) {
                        XMLControlElement control = new XMLControlElement(new TrackProperties(TTrack.this));
                        TTrack.this.setColor((Color)newColor);
                        Undo.postTrackDisplayEdit(TTrack.this, control);
                    }
                });
            }
        });
        this.nameItem = new JMenuItem();
        this.nameItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TTrack.this.getNameDialog().setVisible(true);
            }
        });
        this.footprintMenu = new JMenu();
        this.descriptionItem = new JMenuItem();
        this.descriptionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TTrack.this.tp != null && TTrack.this.tframe != null) {
                    if (TTrack.this.tframe.notesVisible()) {
                        TTrack.this.tframe.getNotesDialog().setVisible(true);
                    } else {
                        TTrack.this.tp.getToolBar(true).doNotesAction();
                    }
                }
            }
        });
        this.dataBuilderItem = new JMenuItem();
        this.dataBuilderItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TTrack.this.tp != null) {
                    TTrack.this.tp.getDataBuilder().setSelectedPanel(TTrack.this.getName());
                    TTrack.this.tp.getDataBuilder().setVisible(true);
                }
            }
        });
        this.visibleItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TTrack.this.setVisible(TTrack.this.visibleItem.isSelected());
                TTrack.this.repaint();
            }
        });
        this.trailVisibleItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TTrack.this.setTrailVisible(TTrack.this.trailVisibleItem.isSelected());
                if (!TTrack.this.isTrailVisible()) {
                    int j = 0;
                    while (j < TTrack.this.tp.andWorld.size()) {
                        TrackerPanel panel = TTrack.this.panel(TTrack.this.tp.andWorld.get(j));
                        Step step = panel.getSelectedStep();
                        if (step != null && step.getTrack() == TTrack.this && step.getFrameNumber() != panel.getFrameNumber()) {
                            panel.setSelectedPoint(null);
                            panel.selectedSteps.clear();
                        }
                        ++j;
                    }
                }
                TTrack.this.repaint();
            }
        });
        this.markByDefaultItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TTrack.this.setMarkByDefault(TTrack.this.markByDefaultItem.isSelected());
            }
        });
        this.autoAdvanceItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TTrack.this.setAutoAdvance(TTrack.this.autoAdvanceItem.isSelected());
            }
        });
        this.lockedItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TTrack.this.setLocked(TTrack.this.lockedItem.isSelected());
            }
        });
        this.deleteTrackItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TTrack.this.delete();
            }
        });
        this.deleteStepItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TTrack.this.tp.deletePoint(TTrack.this.tp.getSelectedPoint());
            }
        });
        this.clearStepsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoTracker autoTracker;
                if (TTrack.this.isLocked()) {
                    return;
                }
                XMLControlElement control = new XMLControlElement(TTrack.this);
                int n = 0;
                while (n < TTrack.this.getSteps().length) {
                    TTrack.this.steps.setStep(n, null);
                    ++n;
                }
                for (String columnName : TTrack.this.textColumnNames) {
                    TTrack.this.textColumnEntries.put(columnName, new String[0]);
                }
                Undo.postTrackEdit(TTrack.this, control);
                if (TTrack.this.ttype == 5) {
                    PointMass p = (PointMass)TTrack.this;
                    p.updateDerivatives();
                }
                if ((autoTracker = TTrack.this.tp.getAutoTracker(false)) != null) {
                    if (autoTracker.getTrack() == TTrack.this) {
                        autoTracker.reset();
                    }
                    autoTracker.getWizard().setVisible(false);
                }
                TTrack.this.fireStepsChanged();
                TFrame.repaintT(TTrack.this.tp);
            }
        });
    }

    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        String tooltip = TrackerRes.getString("TTrack.NumberField.Format.Tooltip");
        if (OSPRuntime.isMac()) {
            tooltip = TrackerRes.getString("TTrack.NumberField.Format.Tooltip.OSX");
        }
        for (NumberField[] fields : this.getNumberFields().values()) {
            int i = 0;
            while (i < fields.length) {
                fields[i].setToolTipText(tooltip);
                ++i;
            }
        }
        this.tField.setUnits(trackerPanel.getUnits(this, "t"));
        this.toolbarTrackComponents.clear();
        return this.toolbarTrackComponents;
    }

    public ArrayList<Component> getToolbarPointComponents(TrackerPanel trackerPanel, TPoint point) {
        this.toolbarPointComponents.clear();
        this.stepLabel.setText(TrackerRes.getString("TTrack.Label.Step"));
        Step step = this.getStep(point, trackerPanel);
        VideoClip clip = trackerPanel.getPlayer().getVideoClip();
        if (step != null && clip.includesFrame(step.getFrameNumber())) {
            int n = clip.frameToStep(step.getFrameNumber());
            this.stepValueLabel.setText(String.valueOf(n) + ":");
            double t = trackerPanel.getPlayer().getStepTime(n) / 1000.0;
            if (t >= 0.0) {
                this.tField.setValue(t);
            }
        }
        this.angleField.setToolTipText(this.angleField.getConversionFactor() == 1.0 ? TrackerRes.getString("TTrack.AngleField.Radians.Tooltip") : TrackerRes.getString("TTrack.AngleField.Degrees.Tooltip"));
        return this.toolbarPointComponents;
    }

    public void erase() {
        AutoTracker autoTracker;
        Step[] stepArray = this.steps.array;
        int j = 0;
        while (j < stepArray.length) {
            if (stepArray[j] != null) {
                stepArray[j].erase();
            }
            ++j;
        }
        if (this.tp != null && this.tp.autoTracker != null && (autoTracker = this.tp.getAutoTracker(false)) != null && autoTracker.getWizard().isVisible() && autoTracker.getTrack() == this) {
            autoTracker.erase();
        }
    }

    public void remark() {
        Step[] stepArray = this.steps.array;
        int j = 0;
        while (j < stepArray.length) {
            if (stepArray[j] != null) {
                stepArray[j].remark();
            }
            ++j;
        }
    }

    public void repaint() {
        if (this.tp == null || !this.tp.isPaintable()) {
            return;
        }
        this.remark();
        int i = 0;
        while (i < this.tp.andWorld.size()) {
            this.panel(this.tp.andWorld.get(i)).repaintDirtyRegion();
            ++i;
        }
    }

    protected void repaintAll() {
        if (this.tp != null) {
            int i = 0;
            while (i < this.tp.andWorld.size()) {
                this.panel(this.tp.andWorld.get(i)).repaint();
                ++i;
            }
        }
    }

    public void erase(Integer panelID) {
        Step[] stepArray = this.steps.array;
        int j = 0;
        while (j < stepArray.length) {
            if (stepArray[j] != null) {
                stepArray[j].erase(panelID);
            }
            ++j;
        }
        TrackerPanel panel = this.panel(panelID);
        AutoTracker autoTracker = panel.autoTracker;
        if (autoTracker != null && autoTracker.getWizard().isVisible() && autoTracker.getTrack() == this) {
            autoTracker.erase();
        }
    }

    public void remark(Integer panelID) {
        Step[] stepArray = this.steps.array;
        int j = 0;
        while (j < stepArray.length) {
            if (stepArray[j] != null) {
                stepArray[j].remark(panelID);
            }
            ++j;
        }
    }

    public void repaint(Integer panelID) {
        this.remark(panelID);
        this.panel(panelID).repaintDirtyRegion();
    }

    public void repaintStep(Step step) {
        int j = 0;
        while (j < this.tp.andWorld.size()) {
            step.repaint(this.tp.andWorld.get(j));
            ++j;
        }
    }

    @Override
    public void draw(DrawingPanel panel, Graphics _g) {
        this.loadAttachmentsFromNames(true);
        if (!this.visible || !(panel instanceof TrackerPanel)) {
            return;
        }
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        Graphics2D g = (Graphics2D)_g;
        int n = trackerPanel.getFrameNumber();
        int stepSize = trackerPanel.getPlayer().getVideoClip().getStepSize();
        if (this.trailVisible) {
            boolean shortTrail = this.getTrailLength() > 0;
            Step[] stepArray = this.steps.array;
            int frame = 0;
            while (frame < stepArray.length) {
                if ((!shortTrail || n - frame <= (this.getTrailLength() - 1) * stepSize && frame <= n) && stepArray[frame] != null && trackerPanel.getPlayer().getVideoClip().includesFrame(frame)) {
                    stepArray[frame].draw(trackerPanel, g);
                }
                ++frame;
            }
        } else {
            Step step = this.getStep(n);
            if (step != null) {
                step.draw(trackerPanel, g);
            }
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (!(panel instanceof TrackerPanel) || !this.visible) {
            return null;
        }
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        Interactive iad = null;
        int n = trackerPanel.getFrameNumber();
        int stepSize = trackerPanel.getPlayer().getVideoClip().getStepSize();
        if (this.trailVisible) {
            boolean shortTrail = this.getTrailLength() > 0;
            Step[] stepArray = this.steps.array;
            int frame = 0;
            while (frame < stepArray.length) {
                if ((!shortTrail || n - frame <= (this.getTrailLength() - 1) * stepSize && frame <= n) && stepArray[frame] != null && trackerPanel.getPlayer().getVideoClip().includesFrame(frame) && (iad = stepArray[frame].findInteractive(trackerPanel, xpix, ypix)) != null) {
                    return iad;
                }
                ++frame;
            }
        } else {
            Step step = this.getStep(n);
            if (step != null && trackerPanel.getPlayer().getVideoClip().includesFrame(n) && (iad = step.findInteractive(trackerPanel, xpix, ypix)) != null) {
                return iad;
            }
        }
        return null;
    }

    @Override
    public double getX() {
        return 0.0;
    }

    @Override
    public double getY() {
        return 0.0;
    }

    @Override
    public void setX(double x) {
    }

    @Override
    public void setY(double y) {
    }

    @Override
    public void setXY(double x, double y) {
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isMeasured() {
        return !this.isEmpty();
    }

    @Override
    public double getXMin() {
        return this.getX();
    }

    @Override
    public double getXMax() {
        return this.getX();
    }

    @Override
    public double getYMin() {
        return this.getY();
    }

    @Override
    public double getYMax() {
        return this.getY();
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public boolean isStepVisible(Step step, TrackerPanel trackerPanel) {
        if (!this.isVisible()) {
            return false;
        }
        int n = step.getFrameNumber();
        if (!trackerPanel.getPlayer().getVideoClip().includesFrame(n)) {
            return false;
        }
        int frame = trackerPanel.getFrameNumber();
        if (n == frame) {
            return true;
        }
        if (!this.trailVisible) {
            return false;
        }
        if (this.getTrailLength() == 0) {
            return true;
        }
        int stepSize = trackerPanel.getPlayer().getVideoClip().getStepSize();
        return frame - n > -1 && frame - n < this.getTrailLength() * stepSize;
    }

    protected void setAnglesInRadians(boolean radians) {
        this.angleField.setUnits(radians ? null : "\u00b0");
        this.angleField.setDecimalPlaces(radians ? 3 : 1);
        this.angleField.setConversionFactor(radians ? 1.0 : 57.29577951308232);
        this.angleField.setToolTipText(radians ? TrackerRes.getString("TTrack.AngleField.Radians.Tooltip") : TrackerRes.getString("TTrack.AngleField.Degrees.Tooltip"));
    }

    @Override
    public void dispose() {
        OSPLog.notify(this, "disposing");
        this.properties.clear();
        this.datasetManager = null;
        if (this.attachments != null) {
            int i = 0;
            while (i < this.attachments.length) {
                TTrack targetTrack = this.attachments[i];
                if (targetTrack != null) {
                    targetTrack.removePropertyChangeListener(PROPERTY_TTRACK_STEP, this);
                    targetTrack.removePropertyChangeListener(PROPERTY_TTRACK_STEPS, this);
                }
                this.attachments[i] = null;
                ++i;
            }
            this.refreshAttachments();
        }
        this.attachments = null;
        this.attachmentNames = null;
        Step[] stepArray = this.steps.array;
        int n = this.steps.array.length;
        int n2 = 0;
        while (n2 < n) {
            Step step = stepArray[n2];
            if (step != null) {
                step.dispose();
            }
            ++n2;
        }
        this.steps = null;
        this.setTrackerPanel(null);
        super.dispose();
    }

    protected void setMarking(boolean marking) {
        this.isMarking = marking;
    }

    protected boolean isMarking() {
        return this.isMarking;
    }

    protected Cursor getMarkingCursor(InputEvent e) {
        switch (this.getMarkingCursorType(e)) {
            case 2: {
                return TMouseHandler.autoTrackCursor;
            }
            case 3: {
                return TMouseHandler.autoTrackMarkCursor;
            }
        }
        return TMouseHandler.markPointCursor;
    }

    int getMarkingCursorType(InputEvent e) {
        boolean autotrackEneabled = this.tp.isEnabled("track.autotrack");
        if (autotrackEneabled && e != null && AutoTracker.isAutoTrackTrigger(e) && this.tp.getVideo() != null && this.isAutoTrackable(this.getTargetIndex())) {
            TPoint[] pts;
            Step step = this.getStep(this.tp.getFrameNumber());
            TPoint[] tPointArray = pts = step == null ? null : step.getPoints();
            if (pts == null || pts[pts.length - 1] == null) {
                return 3;
            }
            switch (this.ttype) {
                case 2: 
                case 6: 
                case 8: 
                case 10: {
                    int n;
                    AutoTracker autoTracker = this.tp.getAutoTracker(true);
                    if (autoTracker.getTrack() != null && autoTracker.getTrack() != this || autoTracker.getOrCreateFrameData(n = this.tp.getFrameNumber()).getKeyFrameData() != null) break;
                    return 3;
                }
            }
            return 2;
        }
        return 1;
    }

    protected void createWarningDialog() {
        if (skippedStepWarningDialog == null && this.tp != null && this.tframe != null) {
            skippedStepWarningDialog = new JDialog((Frame)this.tframe, true);
            skippedStepWarningDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    Tracker.warnSkippedStep = !skippedStepWarningCheckbox.isSelected();
                }
            });
            JPanel contentPane = new JPanel(new BorderLayout());
            skippedStepWarningDialog.setContentPane(contentPane);
            skippedStepWarningTextpane = new JTextPane();
            skippedStepWarningTextpane.setEditable(false);
            skippedStepWarningTextpane.setOpaque(false);
            skippedStepWarningTextpane.setPreferredSize(new Dimension(400, 120));
            skippedStepWarningTextpane.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 12));
            skippedStepWarningTextpane.setContentType("text");
            skippedStepWarningTextpane.setFont(new JLabel().getFont());
            contentPane.add((Component)skippedStepWarningTextpane, "Center");
            skippedStepWarningCheckbox = new JCheckBox();
            skippedStepWarningCheckbox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 30));
            closeButton = new JButton();
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Tracker.warnSkippedStep = !skippedStepWarningCheckbox.isSelected();
                    skippedStepWarningDialog.setVisible(false);
                }
            });
            JPanel buttonbar = new JPanel();
            buttonbar.add(skippedStepWarningCheckbox);
            buttonbar.add(closeButton);
            contentPane.add((Component)buttonbar, "South");
        }
    }

    protected JDialog getStepSizeWarningDialog() {
        this.createWarningDialog();
        if (skippedStepWarningDialog == null) {
            return null;
        }
        skippedStepWarningDialog.setTitle(TrackerRes.getString("TTrack.Dialog.StepSizeWarning.Title"));
        String m1 = TrackerRes.getString("TTrack.Dialog.StepSizeWarning.Message1");
        String m2 = TrackerRes.getString("TTrack.Dialog.StepSizeWarning.Message2");
        String m3 = TrackerRes.getString("TTrack.Dialog.StepSizeWarning.Message3");
        skippedStepWarningTextpane.setText(String.valueOf(m1) + "  " + m2 + "  " + m3);
        skippedStepWarningCheckbox.setText(TrackerRes.getString("TTrack.Dialog.SkippedStepWarning.Checkbox"));
        closeButton.setText(TrackerRes.getString("Dialog.Button.Close"));
        skippedStepWarningDialog.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - TTrack.skippedStepWarningDialog.getBounds().width) / 2;
        int y = (dim.height - TTrack.skippedStepWarningDialog.getBounds().height) / 2;
        skippedStepWarningDialog.setLocation(x, y);
        return skippedStepWarningDialog;
    }

    protected JDialog getSkippedStepWarningDialog() {
        this.createWarningDialog();
        if (skippedStepWarningDialog == null) {
            return null;
        }
        skippedStepWarningDialog.setTitle(TrackerRes.getString("TTrack.Dialog.SkippedStepWarning.Title"));
        String m1 = TrackerRes.getString("TTrack.Dialog.SkippedStepWarning.Message1");
        String m3 = TrackerRes.getString("TTrack.Dialog.StepSizeWarning.Message3");
        skippedStepWarningTextpane.setText(String.valueOf(m1) + "  " + m3);
        skippedStepWarningCheckbox.setText(TrackerRes.getString("TTrack.Dialog.SkippedStepWarning.Checkbox"));
        closeButton.setText(TrackerRes.getString("Dialog.Button.Close"));
        FontSizer.setFonts(skippedStepWarningDialog, FontSizer.getLevel());
        skippedStepWarningDialog.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - TTrack.skippedStepWarningDialog.getBounds().width) / 2;
        int y = (dim.height - TTrack.skippedStepWarningDialog.getBounds().height) / 2;
        skippedStepWarningDialog.setLocation(x, y);
        return skippedStepWarningDialog;
    }

    protected Dataset convertTextToDataColumn(String textColumnName) {
        if (textColumnName == null || this.tp == null) {
            return null;
        }
        String[] entries = this.textColumnEntries.get(textColumnName);
        if (entries != null && entries.length > 0) {
            DatasetManager data = this.getData(this.tp);
            double[] x = data.getDataset(0).getXPoints();
            int len = data.getDataset(0).getIndex();
            ArrayList<Dataset> datasets = data.getDatasetsRaw();
            boolean isFrames = this.getClass() != LineProfile.class;
            int frameIndex = isFrames ? -1 : 0;
            int i = 0;
            while (i < datasets.size()) {
                if (datasets.get(i).getYColumnName().equals("frame")) {
                    frameIndex = i;
                    break;
                }
                ++i;
            }
            double[] values = new double[len];
            int i2 = 0;
            while (i2 < values.length) {
                int frame;
                int n = frame = frameIndex < 0 ? i2 : (int)datasets.get(frameIndex).getY(i2);
                if (entries.length > frame) {
                    if (entries[frame] == null) {
                        values[i2] = Double.NaN;
                    } else {
                        try {
                            values[i2] = Double.parseDouble(entries[frame]);
                        }
                        catch (Exception ex) {
                            return null;
                        }
                    }
                } else {
                    values[i2] = Double.NaN;
                }
                ++i2;
            }
            Dataset dataset = new Dataset();
            dataset.append(x, values);
            dataset.setXYColumnNames(data.getDataset(0).getXColumnName(), textColumnName, this.getName());
            dataset.setMarkerColor(this.getColor());
            return dataset;
        }
        return null;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected NameDialog getNameDialog() {
        if (nameDialog == null) {
            nameDialog = new NameDialog();
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - TTrack.nameDialog.getBounds().width) / 2;
            int y = (dim.height - TTrack.nameDialog.getBounds().height) / 2;
            nameDialog.setLocation(x, y);
        }
        nameDialog.setTrack(this);
        return nameDialog;
    }

    public void setActive() {
        panelActiveTracks.put(this.ID, this);
    }

    protected static TTrack getTrack(int ID) {
        return panelActiveTracks.get(ID);
    }

    public static void removeActiveTrack(int id) {
        panelActiveTracks.remove(id);
    }

    public static Collection<TTrack> getValues() {
        return panelActiveTracks.values();
    }

    public void invalidateData(Object newValue) {
        this.dataValid = false;
        if (newValue != Boolean.FALSE) {
            this.firePropertyChange(PROPERTY_TTRACK_DATA, null, newValue == Boolean.TRUE ? null : newValue);
        }
    }

    public boolean isDataValid() {
        return this.dataValid;
    }

    public void initialize(TrackerPanel panel) {
    }

    public void fireStepsChanged() {
        this.firePropertyChange(PROPERTY_TTRACK_STEPS, null, null);
    }

    public abstract Map<String, String[]> getFormatMap();

    public abstract Map<String, String> getFormatDescMap();

    public abstract String[] getFormatVariables();

    public abstract String getVarDimsImpl(String var1);

    public abstract String getBaseType();

    private TableTrackView.TrackDataTable getDataTable() {
        TableTrackView view;
        ArrayList<TableTrackView> tableViews = this.getTableViews();
        return tableViews.isEmpty() || (view = tableViews.get(0)) == null ? null : view.getDataTable();
    }

    protected String[] getCustomFormatPatterns() {
        if (this.tp == null) {
            return new String[0];
        }
        String[] patterns = this.getFormatPatterns();
        TreeMap<String, String> defaultPatterns = this.tp.getFormatPatterns(this.ttype);
        ArrayList<String> customPatterns = new ArrayList<String>();
        int i = 0;
        while (i < patterns.length - 1) {
            String pattern;
            String name = patterns[i];
            String string = pattern = defaultPatterns.get(name) == null ? "" : defaultPatterns.get(name);
            if (!pattern.equals(patterns[i + 1])) {
                customPatterns.add(name);
                customPatterns.add(patterns[i + 1]);
            }
            i += 2;
        }
        return customPatterns.toArray(new String[customPatterns.size()]);
    }

    protected ArrayList<TableTrackView> getTableViews() {
        ArrayList<TableTrackView> tableTrackViews = new ArrayList<TableTrackView>();
        if (this.tp == null || this.tframe == null) {
            return tableTrackViews;
        }
        TViewChooser[] choosers = this.tframe.getViewChoosers(this.tp);
        int i = 0;
        while (i < choosers.length) {
            TableTView tableView;
            if (choosers[i] != null && (tableView = (TableTView)choosers[i].getView(1)) != null) {
                tableTrackViews.add((TableTrackView)tableView.getTrackView(this));
            }
            ++i;
        }
        return tableTrackViews;
    }

    protected ArrayList<PlotTrackView> getPlotViews() {
        ArrayList<PlotTrackView> plotTrackViews = new ArrayList<PlotTrackView>();
        if (this.tp == null || this.tframe == null) {
            return plotTrackViews;
        }
        TViewChooser[] choosers = this.tframe.getViewChoosers(this.tp);
        int i = 0;
        while (i < choosers.length) {
            PlotTView plotView;
            if (choosers[i] != null && (plotView = (PlotTView)choosers[i].getView(0)) != null) {
                plotTrackViews.add((PlotTrackView)plotView.getTrackView(this));
            }
            ++i;
        }
        return plotTrackViews;
    }

    public String[] getFormatPatterns() {
        ArrayList<String> patterns = new ArrayList<String>();
        for (String name : TTrack.getAllVariables(this.ttype)) {
            patterns.add(name);
            patterns.add(this.getVarFormatPattern(name));
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    protected boolean setFormatPattern(String name, String pattern) {
        boolean changed = false;
        String[] vars = this.getVariablesFromFormatterDisplayName(name);
        if (vars != null) {
            String[] stringArray = vars;
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                String var = stringArray[n2];
                changed = this.setFormatPatternForVariable(var, pattern) || changed;
                ++n2;
            }
            return changed;
        }
        return this.setFormatPatternForVariable(name, pattern);
    }

    private boolean setFormatPatternForVariable(String var, String pattern) {
        Map<String, NumberField[]> fieldMap;
        NumberField[] fields;
        boolean changed = false;
        boolean found = false;
        if (this.isViewable()) {
            found = true;
            ArrayList<TableTrackView> tableViews = this.getTableViews();
            for (TableTrackView view : tableViews) {
                TableTrackView.TrackDataTable table;
                if (view == null || (table = view.getDataTable()).getFormatPattern(var).equals(pattern)) continue;
                table.setFormatPattern(var, pattern);
                changed = true;
            }
        }
        if ((fields = (fieldMap = this.getNumberFields()).get(var)) != null) {
            found = true;
            NumberField[] numberFieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                NumberField field = numberFieldArray[n2];
                if (!field.getFixedPattern().equals(pattern)) {
                    field.setFixedPattern(pattern);
                    changed = true;
                }
                ++n2;
            }
        }
        if (!found && !pattern.equals(this.getProperty(var))) {
            this.setProperty(var, pattern);
            changed = true;
        }
        if (changed && (var.equals("x") || var.equals("y")) && this.tp != null && this.tp.getSelectedTrack() == this) {
            this.tp.coordStringBuilder.setUnitsAndPatterns(this, "x", "y");
            if (this.tp.getSelectedPoint() != null) {
                this.tp.getSelectedPoint().showCoordinates(this.tp);
            }
        }
        return changed;
    }

    protected String getVarFormatPattern(String name) {
        String val;
        NumberField[] fields;
        String[] vars;
        if (!TTrack.getAllVariables(this.ttype).contains(name) && (vars = this.getVariablesFromFormatterDisplayName(name)) != null && vars.length > 0) {
            name = vars[0];
        }
        if ((fields = this.getNumberFields().get(name)) != null && fields.length > 0) {
            return fields[0].getFixedPattern();
        }
        TableTrackView.TrackDataTable table = this.getDataTable();
        if (table != null && (val = table.getFormatPattern(name)) != null && !"".equals(val.trim())) {
            return val;
        }
        val = (String)this.getProperty(name);
        if (val != null) {
            return val;
        }
        TreeMap<String, String> patterns = this.tp.getFormatPatterns(this.ttype);
        val = patterns.get(name);
        if (val != null) {
            return val;
        }
        patterns = TTrack.getDefaultFormatPatterns(this.ttype);
        if (patterns != null && (val = patterns.get(name)) != null) {
            return val;
        }
        return "";
    }

    protected static TreeMap<String, String> getDefaultFormatPatterns(int ttype) {
        TreeMap<String, String> patterns = defaultFormatPatterns[ttype];
        if (patterns != null) {
            return patterns;
        }
        patterns = new TreeMap();
        TTrack.defaultFormatPatterns[ttype] = patterns;
        switch (ttype) {
            case 1: {
                patterns.put(TrackerRes.getString("CircleFitter.Data.PointCount"), "0");
            }
            case 6: {
                patterns.put(Tracker.THETA, "0.0");
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                patterns.put("t", "0.000");
                patterns.put(PROPERTY_TTRACK_STEP, "0");
                patterns.put("frame", "0");
            }
        }
        switch (ttype) {
            case 3: {
                patterns.put("n", "0");
            }
            case 7: {
                patterns.put("pixels", "0");
                patterns.put("R", "0.0");
                patterns.put("G", "0.0");
                patterns.put("B", "0.0");
                patterns.put("luma", "0.0");
            }
        }
        return patterns;
    }

    public static String getVariableDimensions(TTrack track, String variable) {
        if (variable.startsWith(Tracker.THETA)) {
            return "A";
        }
        if (variable.equals("t")) {
            return "T";
        }
        return track.getVarDimsImpl(variable);
    }

    public void setInitialFormatPatterns(TrackerPanel trackerPanel) {
        TreeMap<String, String> patterns = trackerPanel.getFormatPatterns(this.ttype);
        for (String name : patterns.keySet()) {
            this.setFormatPattern(name, patterns.get(name));
        }
        if (this.customNumberFormats != null) {
            this.getData(trackerPanel);
            int i = 0;
            while (i < this.customNumberFormats.length - 1) {
                String name = this.customNumberFormats[i];
                String pattern = this.customNumberFormats[i + 1];
                this.setFormatPattern(name, pattern);
                i += 2;
            }
            this.customNumberFormats = null;
        }
    }

    protected void clearColumns(DatasetManager data, int count, String[] dataVariables, String desc, double[][] validData, int len) {
        int i;
        String v0;
        String string = v0 = dataVariables == null ? null : dataVariables[0];
        if (v0 == null || data.getDataset(0).getColumnName(0).equals(v0)) {
            i = 0;
            while (i < count) {
                data.getDataset(i).clear();
                ++i;
            }
        } else if (dataVariables != null) {
            i = 0;
            while (i < count) {
                data.setXYColumnNames(i, v0, dataVariables[i + 1]);
                ++i;
            }
        }
        this.dataDescriptions = new String[count + 1];
        if (desc != null) {
            i = 0;
            while (i <= count) {
                this.dataDescriptions[i] = TrackerRes.getString(String.valueOf(desc) + i);
                ++i;
            }
        }
        if (validData != null) {
            double[] t = validData[count];
            int i2 = 0;
            while (i2 < count) {
                data.getDataset(i2).append(t, validData[i2], len);
                ++i2;
            }
        }
    }

    protected void addFixedItem(JMenu menu) {
        int i = menu.getItemCount();
        while (--i >= 0) {
            if (menu.getItem(i) != this.lockedItem) continue;
            menu.insert(this.fixedItem, i + 1);
            break;
        }
    }

    protected JMenu assembleMenu(JMenu menu, JMenuItem topItem) {
        menu.remove(this.lockedItem);
        menu.remove(this.autoAdvanceItem);
        menu.remove(this.markByDefaultItem);
        menu.insert(topItem, 0);
        if (menu.getItemCount() > 1) {
            menu.insertSeparator(1);
        }
        JMenuItem prevItem = topItem;
        int j = menu.getItemCount();
        while (--j >= 0) {
            JMenuItem item = menu.getItem(j);
            if (item == null && prevItem == null) {
                menu.remove(j);
                continue;
            }
            prevItem = item;
        }
        return menu;
    }

    protected void removeDeleteTrackItem(JMenu menu) {
        int n = menu.getItemCount();
        if (n > 0 && menu.getItem(n - 1) == this.deleteTrackItem) {
            menu.remove(--n);
            if (n > 0 && menu.getItem(n - 1) == null) {
                menu.remove(n - 1);
            }
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            TTrack[] att;
            String[] customPatterns;
            TTrack track = (TTrack)obj;
            control.setValue(TTrack.PROPERTY_TTRACK_NAME, track.getName());
            if (!track.description.equals("")) {
                control.setValue("description", track.description);
            }
            control.setValue(TTrack.PROPERTY_TTRACK_COLOR, track.getColor());
            control.setValue(TTrack.PROPERTY_TTRACK_FOOTPRINT, track.getFootprintName());
            control.setValue(TTrack.PROPERTY_TTRACK_VISIBLE, track.isVisible());
            control.setValue("trail", track.isTrailVisible());
            if (track.isLocked()) {
                control.setValue(TTrack.PROPERTY_TTRACK_LOCKED, track.isLocked());
            }
            if ((customPatterns = track.getCustomFormatPatterns()).length > 0) {
                control.setValue("number_formats", customPatterns);
            }
            if (!track.getTextColumnNames().isEmpty()) {
                String[] names = track.getTextColumnNames().toArray(new String[0]);
                control.setValue("text_column_names", names);
                String[][] entries = new String[names.length][];
                int i = 0;
                while (i < names.length) {
                    entries[i] = track.textColumnEntries.get(names[i]);
                    ++i;
                }
                control.setValue("text_column_entries", entries);
            }
            if (track.tp != null) {
                ArrayList<Dataset> list = new ArrayList<Dataset>();
                track.refreshDataLater = true;
                DatasetManager data = track.getData(track.tp);
                track.refreshDataLater = false;
                ArrayList<Dataset> datasets = data.getDatasetsRaw();
                int i = 0;
                int n = datasets.size();
                while (i < n) {
                    Dataset dataset = datasets.get(i);
                    if (dataset instanceof DataFunction) {
                        list.add(dataset);
                    }
                    ++i;
                }
                if (!list.isEmpty()) {
                    ArrayList<String> names = data.getConstantNames();
                    n = names.size();
                    if (n > 0) {
                        Object[][] paramArray = new Object[n][4];
                        int i2 = 0;
                        for (String key : names) {
                            paramArray[i2][0] = key;
                            paramArray[i2][1] = data.getConstantValue(key);
                            paramArray[i2][2] = data.getConstantExpression(key);
                            paramArray[i2][3] = data.getConstantDescription(key);
                            ++i2;
                        }
                        control.setValue("constants", paramArray);
                    }
                    DataFunction[] f = list.toArray(new DataFunction[0]);
                    control.setValue("data_functions", f);
                }
            }
            if ((att = track.attachments) != null && att.length > 0) {
                String[] names = new String[att.length];
                boolean notNull = false;
                int i = 0;
                while (i < att.length) {
                    TTrack next = att[i];
                    names[i] = next == null ? null : next.getName();
                    notNull = notNull || names[i] != null;
                    ++i;
                }
                if (notNull) {
                    control.setValue("attachments", names);
                }
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            String[][] columnEntries;
            TTrack track = (TTrack)obj;
            boolean locked = track.isLocked();
            track.setLocked(false);
            track.setName(control.getString(TTrack.PROPERTY_TTRACK_NAME));
            track.setDescription(control.getString("description"));
            track.setColor((Color)control.getObject(TTrack.PROPERTY_TTRACK_COLOR));
            String s = control.getString(TTrack.PROPERTY_TTRACK_FOOTPRINT);
            if (s != null) {
                track.setFootprint(s.trim());
            }
            track.setVisible(control.getBoolean(TTrack.PROPERTY_TTRACK_VISIBLE));
            int index = Tracker.preferredTrailLengthIndex;
            if (track.tp != null && track.tp.getTFrame() != null) {
                TToolBar toolbar = track.tp.getTFrame().getToolBar(track.tp.getID(), false);
                index = toolbar.trailLengthIndex;
            }
            track.setTrailLength(TToolBar.trailLengths[index]);
            track.setTrailVisible(control.getBoolean("trail"));
            track.customNumberFormats = (String[])control.getObject("number_formats");
            track.textColumnNames.clear();
            track.textColumnEntries.clear();
            String[] columnNames = (String[])control.getObject("text_column_names");
            if (columnNames != null && (columnEntries = (String[][])control.getObject("text_column_entries")) != null) {
                int i = 0;
                while (i < columnNames.length) {
                    track.textColumnNames.add(columnNames[i]);
                    track.textColumnEntries.put(columnNames[i], columnEntries[i]);
                    ++i;
                }
            }
            track.constantsLoadedFromXML = (Object[][])control.getObject("constants");
            for (XMLProperty prop : control.getPropsRaw()) {
                if (!prop.getPropertyName().equals("data_functions")) continue;
                track.dataProp = prop;
            }
            String[] names = (String[])control.getObject("attachments");
            if (names != null) {
                track.attachmentNames = names;
            }
            track.setLocked(locked || control.getBoolean(TTrack.PROPERTY_TTRACK_LOCKED));
            return obj;
        }
    }

    protected class NameDialog
    extends JDialog {
        JLabel nameLabel;
        JTextField nameField;
        TTrack target;

        NameDialog() {
            super(TTrack.this.tframe, null, true);
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    String newName = NameDialog.this.nameField.getText();
                    if (NameDialog.this.target != null && ((NameDialog)NameDialog.this).TTrack.this.tp != null) {
                        ((NameDialog)NameDialog.this).TTrack.this.tp.setTrackName(NameDialog.this.target, newName, true);
                    }
                }
            });
            this.nameField = new JTextField(20);
            this.nameField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String newName = NameDialog.this.nameField.getText();
                    if (NameDialog.this.target != null) {
                        ((NameDialog)NameDialog.this).TTrack.this.tp.setTrackName(NameDialog.this.target, newName, true);
                    }
                }
            });
            this.nameLabel = new JLabel();
            JToolBar bar = new JToolBar();
            bar.setFloatable(false);
            bar.add(this.nameLabel);
            bar.add(this.nameField);
            JPanel contentPane = new JPanel(new BorderLayout());
            contentPane.add((Component)bar, "Center");
            this.setContentPane(contentPane);
        }

        void setTrack(TTrack track) {
            this.target = track;
            FontSizer.setFonts(this, FontSizer.getLevel());
            this.setTitle(TrackerRes.getString("TTrack.Dialog.Name.Title"));
            this.nameLabel.setText(TrackerRes.getString("TTrack.Dialog.Name.Label"));
            this.nameField.setText(track.getName());
            this.nameField.selectAll();
            this.pack();
        }
    }

    protected class StepArray {
        protected int delta = 10;
        protected Step[] array = new Step[this.delta];
        private boolean autofill = false;

        public StepArray() {
        }

        public StepArray(Step step) {
            this.autofill = true;
            step.n = 0;
            this.array[0] = step;
            this.fill(this.array, step);
        }

        public Step getStep(int n) {
            if (n >= this.array.length) {
                int len = Math.max(n + this.delta, n - this.array.length + 1);
                this.setLength(len);
            }
            return this.array[n];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStep(int n, Step step) {
            if (this.autofill && step == null) {
                return;
            }
            if (n >= this.array.length) {
                int len = Math.max(n + this.delta, n - this.array.length + 1);
                this.setLength(len);
            }
            Step[] stepArray = this.array;
            synchronized (this.array) {
                this.array[n] = step;
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean contains(Step step) {
            Step[] stepArray = this.array;
            synchronized (this.array) {
                int i = 0;
                while (true) {
                    if (i >= this.array.length) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return false;
                    }
                    if (this.array[i] == step) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return true;
                    }
                    ++i;
                }
            }
        }

        public void setLength(int len) {
            Step[] newArray = new Step[len];
            System.arraycopy(this.array, 0, newArray, 0, Math.min(len, this.array.length));
            if (len > this.array.length && this.autofill) {
                Step step = this.array[this.array.length - 1];
                this.fill(newArray, step);
            }
            this.array = newArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isEmpty() {
            Step[] stepArray = this.array;
            synchronized (this.array) {
                int i = 0;
                while (true) {
                    if (i >= this.array.length) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return true;
                    }
                    if (this.array[i] != null) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return false;
                    }
                    ++i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isPreceded(int n) {
            Step[] stepArray = this.array;
            synchronized (this.array) {
                int k = Math.min(n, this.array.length);
                int i = 0;
                while (true) {
                    if (i >= k) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return false;
                    }
                    if (this.array[i] != null) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return true;
                    }
                    ++i;
                }
            }
        }

        public boolean isAutofill() {
            return this.autofill;
        }

        private void fill(Step[] array, Step step) {
            int n = 0;
            while (n < array.length) {
                if (array[n] == null) {
                    Step clone = (Step)step.clone();
                    clone.n = n;
                    array[n] = clone;
                }
                ++n;
            }
        }
    }

    protected static class TextLineLabel
    extends DrawingPanel {
        DrawableTextLine textLine = new DrawableTextLine("", 0.0, -4.3);
        JLabel label;
        int w;

        TextLineLabel() {
            this.textLine.setJustification(0);
            this.addDrawable(this.textLine);
            this.label = new JLabel();
            this.textLine.setFont(this.label.getFont());
            this.textLine.setColor(this.label.getForeground());
            this.setShowCoordinates(false);
        }

        TextLineLabel(String text) {
            this();
            this.setText(text);
        }

        void setText(String text) {
            if (text == null) {
                text = "";
            }
            if (text.equals(this.textLine.getText())) {
                return;
            }
            this.w = -1;
            this.textLine.setText(text);
            this.setToolTipText(text);
            if (text.contains("_{")) {
                text = TeXParser.removeSubscripting(text);
            }
            this.label.setText(text);
            Dimension dim = this.label.getPreferredSize();
            dim.width += 4;
            this.setPreferredSize(dim);
        }

        @Override
        public Font getFont() {
            if (this.textLine != null) {
                return this.textLine.getFont();
            }
            return super.getFont();
        }

        @Override
        public void setFont(Font font) {
            if (this.textLine != null) {
                this.textLine.setFont(font);
                this.w = -1;
            } else {
                super.setFont(font);
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            this.setPixelScale();
            if (OSPRuntime.setRenderingHints) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            this.textLine.draw(this, g);
            if (this.w == -1) {
                this.w = this.textLine.getWidth(g);
                Dimension dim = this.getPreferredSize();
                if (dim.width > this.w + 4 || dim.width < this.w + 4) {
                    dim.width = this.w + 4;
                    this.setPreferredSize(dim);
                    JToolBar c = GUIUtils.getParentToolBar(this);
                    if (c != null) {
                        ((TTrackBar)c).refresh();
                    }
                }
            }
        }
    }

    protected class TrackDecimalField
    extends DecimalField {
        TrackDecimalField(int places) {
            super(0, places);
        }

        @Override
        public void setText(String t) {
            TTrackBar tbar;
            super.setText(t);
            if (TTrack.this.tp != null && (tbar = TTrack.this.tp.getTrackBar(false)) != null) {
                tbar.resizeField(this);
            }
        }
    }

    protected class TrackNumberField
    extends NumberField {
        TrackNumberField() {
            super(0);
        }

        @Override
        public void setText(String t) {
            super.setText(t);
            if (TTrack.this.tp != null) {
                TTrack.this.tp.getTrackBar(true).resizeField(this);
            }
        }
    }
}

