/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.opensourcephysics.cabrillo.tracker.CoordAxes;
import org.opensourcephysics.cabrillo.tracker.ParticleDataTrack;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Upgrader;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.tools.FontSizer;

public class TTrackBar
extends JToolBar
implements OSPRuntime.Disposable,
PropertyChangeListener {
    protected static JButton newVersionButton;
    protected static Icon selectTrackIcon;
    protected static JButton testButton;
    protected static Timer testTimer;
    protected static boolean showOutOfMemoryDialog;
    private static final JTextField sizingField;
    private JLabel viewLabel = new JLabel();
    static int testIndex;
    protected final Component toolbarEnd = Box.createGlue();
    protected int toolbarComponentHeight;
    protected int numberFieldWidth;
    protected TButton trackButton;
    protected JButton maximizeButton;
    protected TButton selectButton;
    protected JLabel emptyLabel = new JLabel();
    protected JPopupMenu selectPopup = new JPopupMenu();
    private TFrame frame;
    private Integer panelID;
    private static final String[] panelProps;
    private boolean buildRequested;

    static {
        showOutOfMemoryDialog = true;
        sizingField = new JTextField("1234567");
        selectTrackIcon = Tracker.getResourceIcon("select_track.gif", true);
        TTrackBar.setTestOn(Tracker.testOn);
        TTrackBar.setJava();
        panelProps = new String[]{"track", "clear", "selectedtrack", "selectedpoint"};
    }

    TTrackBar(TrackerPanel panel) {
        System.out.println("Creating trackbar for " + panel);
        this.frame = panel.getTFrame();
        this.panelID = panel.getID();
        panel.addListeners(panelProps, this);
    }

    public void finalize() {
        OSPLog.finalized(this);
    }

    private static void setTestOn(boolean on) {
        if (on) {
            testButton = new JButton("test");
            testButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final TFrame frame = (TFrame)testButton.getTopLevelAncestor();
                    if (frame != null && frame.getSelectedPanel() != null) {
                        if (testTimer == null) {
                            testTimer = new Timer(20, new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    TrackerPanel trackerPanel = frame.getSelectedPanel();
                                    ++testIndex;
                                    testButton.setEnabled(true);
                                    if (!testTimer.isRepeats()) {
                                        testTimer.stop();
                                        testTimer = null;
                                    }
                                }
                            });
                            testTimer.setInitialDelay(0);
                            testTimer.setRepeats(false);
                            testTimer.start();
                        } else {
                            testTimer.stop();
                            testTimer = null;
                        }
                    }
                }
            });
        }
    }

    protected static void buildUpgradePopup(JPopupMenu popup) {
        JMenuItem upgradeItem = new JMenuItem(TrackerRes.getString("TTrackBar.Popup.MenuItem.Upgrade"));
        popup.add(upgradeItem);
        upgradeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TFrame frame = (TFrame)newVersionButton.getTopLevelAncestor();
                new Upgrader(frame).upgrade();
            }
        });
        JMenuItem learnMoreItem = new JMenuItem(String.valueOf(TrackerRes.getString("TTrackBar.Popup.MenuItem.LearnMore")) + "...");
        popup.add(learnMoreItem);
        learnMoreItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String websiteurl = "https://" + Tracker.trackerWebsite + "/change_log.html";
                OSPDesktop.displayURL(websiteurl);
            }
        });
        JMenuItem homePageItem = new JMenuItem(String.valueOf(TrackerRes.getString("TTrackBar.Popup.MenuItem.TrackerHomePage")) + "...");
        popup.add(homePageItem);
        homePageItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String websiteurl = "https://" + Tracker.trackerWebsite;
                OSPDesktop.displayURL(websiteurl);
            }
        });
        JMenuItem ignoreItem = new JMenuItem(TrackerRes.getString("TTrackBar.Popup.MenuItem.Ignore"));
        popup.add(ignoreItem);
        ignoreItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerPanel trackerPanel;
                Tracker.checkedForNewerVersion = false;
                Tracker.newerVersion = null;
                Tracker.lastMillisChecked = System.currentTimeMillis();
                TFrame frame = (TFrame)newVersionButton.getTopLevelAncestor();
                TrackerPanel trackerPanel2 = trackerPanel = frame == null ? null : frame.getSelectedPanel();
                if (trackerPanel != null) {
                    trackerPanel.taintEnabled();
                    trackerPanel.getToolBar(true).refresh("new version");
                }
            }
        });
        FontSizer.setFonts(popup, FontSizer.getLevel());
    }

    private static void setJava() {
        OSPLog.addPropertyChangeListener("error", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getNewValue().equals(OSPRuntime.OUT_OF_MEMORY_ERROR)) {
                    OSPRuntime.outOfMemory = true;
                }
            }
        });
        newVersionButton = new TButton(){

            @Override
            public JPopupMenu getPopup() {
                JPopupMenu popup = new JPopupMenu();
                TTrackBar.buildUpgradePopup(popup);
                return popup;
            }
        };
        Font font = newVersionButton.getFont();
        newVersionButton.setFont(font.deriveFont(0, font.getSize() - 1));
        newVersionButton.setForeground(Color.GREEN.darker());
    }

    public void setFontLevel(int level) {
        Object[] objectsToSize = new Object[]{newVersionButton, this.trackButton, sizingField, testButton};
        FontSizer.setFonts(objectsToSize, level);
        this.numberFieldWidth = TTrackBar.sizingField.getPreferredSize().width;
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            comps[i].setEnabled(enable);
            ++i;
        }
    }

    protected JPopupMenu getPopup(TTrack track) {
        JMenu trackMenu = track.getMenu(this.panel(), new JMenu());
        FontSizer.setFonts(trackMenu, FontSizer.getLevel());
        return trackMenu.getPopupMenu();
    }

    protected void createGUI() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TTrackBar.this.maximizeButton.doClick(0);
                }
            }
        });
        this.setFloatable(false);
        this.viewLabel.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 0));
        if (OSPRuntime.isJS) {
            this.viewLabel.setEnabled(false);
        }
        this.selectButton = new TButton(selectTrackIcon){

            @Override
            protected JPopupMenu getPopup() {
                return TTrackBar.this.getSelectTrackPopup();
            }
        };
        this.trackButton = new TButton(){

            @Override
            protected JPopupMenu getPopup() {
                TTrack track = this.getTrack();
                if (track instanceof ParticleDataTrack) {
                    if (TTrackBar.this.trackButton.context.contains("point")) {
                        ParticleDataTrack dt = (ParticleDataTrack)track;
                        JMenu trackMenu = dt.getPointMenu(track.tp);
                        FontSizer.setFonts(trackMenu, FontSizer.getLevel());
                        return trackMenu.getPopupMenu();
                    }
                    ParticleDataTrack dt = ((ParticleDataTrack)track).getLeader();
                    JMenu trackMenu = dt.getMenu(track.tp, new JMenu());
                    FontSizer.setFonts(trackMenu, FontSizer.getLevel());
                    return trackMenu.getPopupMenu();
                }
                return super.getPopup();
            }
        };
        this.trackButton.setOpaque(false);
        this.emptyLabel.setOpaque(false);
        Border empty = BorderFactory.createEmptyBorder(7, 3, 7, 3);
        Border etched = BorderFactory.createEtchedBorder();
        this.maximizeButton = new TButton(TViewChooser.MAXIMIZE_ICON, TViewChooser.RESTORE_ICON);
        this.maximizeButton.setBorder(BorderFactory.createCompoundBorder(etched, empty));
        this.maximizeButton.setToolTipText(TrackerRes.getString("TViewChooser.Maximize.Tooltip"));
        this.maximizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean maximize;
                boolean bl = maximize = TTrackBar.this.frame.getMaximizedView() == -1;
                if (maximize) {
                    TTrackBar.this.frame.saveCurrentDividerLocations(TTrackBar.this.panel());
                    TTrackBar.this.frame.maximizeView(TTrackBar.this.panel(), 4);
                } else {
                    TTrackBar.this.frame.restoreViews(TTrackBar.this.panel());
                }
                TTrackBar.this.maximizeButton.setSelected(maximize);
                if (OSPRuntime.isJS) {
                    TTrackBar.this.maximizeButton.setIcon(maximize ? TViewChooser.RESTORE_ICON : TViewChooser.MAXIMIZE_ICON);
                }
                TTrackBar.this.maximizeButton.setToolTipText(maximize ? TrackerRes.getString("TViewChooser.Restore.Tooltip") : TrackerRes.getString("TViewChooser.Maximize.Tooltip"));
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    protected JPopupMenu getSelectTrackPopup() {
        JMenuItem item;
        this.selectPopup.removeAll();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                TrackerPanel panel = TTrackBar.this.panel();
                TTrack track = panel.getTrack(item.getText());
                if (track == null) {
                    return;
                }
                if (panel.calibrationTools.contains(track) || panel.measuringTools.contains(track) || track == panel.getAxes()) {
                    track.setVisible(true);
                }
                panel.setSelectedTrack(track);
            }
        };
        boolean hasTracks = false;
        TrackerPanel panel = this.panel();
        ArrayList<TTrack> userTracks = panel.getUserTracks();
        for (TTrack track : userTracks) {
            hasTracks = true;
            item = new JMenuItem(track.getName("track"), track.getIcon(21, 16, "track"));
            item.addActionListener(listener);
            this.selectPopup.add(item);
        }
        if (hasTracks) {
            this.selectPopup.addSeparator();
        }
        block8: for (TTrack track : panel.getTracks()) {
            if (userTracks.contains(track) || track == panel.getAxes() && !panel.isEnabled("button.axes")) continue;
            switch (track.ttype) {
                case 8: {
                    TapeMeasure tape;
                    if (!panel.calibrationTools.contains(track) || !((tape = (TapeMeasure)track).isStickMode() ? !panel.isEnabled("calibration.stick") : !panel.isEnabled("calibration.tape"))) break;
                    continue block8;
                }
                case 0: {
                    if (panel.isEnabled("calibration.points")) break;
                    continue block8;
                }
                case 5: {
                    if (!(track instanceof ParticleDataTrack)) break;
                    continue block8;
                }
                case 4: {
                    if (panel.isEnabled("calibration.offsetOrigin")) break;
                    continue block8;
                }
                case 10: {
                    continue block8;
                }
            }
            item = new JMenuItem(track.getName(), track.getFootprint().getIcon(21, 16));
            item.addActionListener(listener);
            this.selectPopup.add(item);
        }
        FontSizer.setFonts(this.selectPopup, FontSizer.getLevel());
        return this.selectPopup;
    }

    protected void refresh() {
        if (!this.panel().isPaintable() || this.buildRequested) {
            return;
        }
        if (this.selectButton == null) {
            this.createGUI();
        }
        this.buildRequested = true;
        OSPRuntime.postEvent(() -> this.rebuild());
    }

    protected void rebuild() {
        this.buildRequested = false;
        this.numberFieldWidth = TTrackBar.sizingField.getPreferredSize().width;
        this.selectButton.setToolTipText(TrackerRes.getString("TToolBar.Button.SelectTrack.Tooltip"));
        this.removeAll();
        TrackerPanel panel = this.panel();
        TTrack track = this.trackButton.getTrack();
        if (track == null) {
            CoordAxes axes = panel.getAxes();
            if (axes != null) {
                this.trackButton.setTrack(axes);
            }
        } else {
            track.removeListenerNCF(this);
        }
        this.add(this.selectButton);
        this.selectButton.setForeground(Color.red);
        this.trackButton.context = "track";
        track = panel.getSelectedTrack();
        if (track != null && track.ttype != 10) {
            Step step;
            TPoint p;
            if (track instanceof ParticleDataTrack && (p = panel.getSelectedPoint()) != null && (step = track.getStep(p, panel)) != null && step.getTrack() == track) {
                this.trackButton.context = "point";
            }
            this.trackButton.setTrack(track);
            track.addListenerNCF(this);
            this.add(this.trackButton);
            this.toolbarComponentHeight = this.selectButton.getPreferredSize().height;
            ArrayList<Component> list = track.getToolbarTrackComponents(panel);
            for (Component c : list) {
                if (c instanceof JComponent && !(c instanceof JButton) && !(c instanceof JCheckBox)) {
                    this.updateSize((JComponent)c);
                }
                this.add(c);
            }
            TPoint p2 = panel.getSelectedPoint();
            if (p2 != null) {
                list = track.getToolbarPointComponents(panel, p2);
                for (Component c : list) {
                    if (c instanceof JComponent && !(c instanceof JButton)) {
                        this.updateSize((JComponent)c);
                    }
                    this.add(c);
                }
            }
        }
        ArrayList<TTrack> userTracks = panel.getUserTracks();
        TFrame frame = panel.getTFrame();
        if ((userTracks == null || userTracks.isEmpty()) && panel.measuringTools.isEmpty()) {
            TViewChooser[] choosers = frame.getViewChoosers(this.panelID);
            boolean close = true;
            int i = 0;
            while (i < choosers.length) {
                int viewType;
                if (choosers[i] != null && ((viewType = choosers[i].getSelectedViewType()) == 2 || viewType == 3)) {
                    close = false;
                }
                ++i;
            }
            if (close) {
                if (!TFrame.isPortraitOrientation) {
                    frame.setDividerLocation(panel, 0, 1.0);
                } else {
                    frame.setDividerLocation(panel, 2, 1.0);
                }
            }
            if (panel.getVideo() == null && panel.calibrationTools.isEmpty() && panel.getSelectedTrack() == null) {
                String name = TrackerRes.getString("TFrame.View.Main");
                String hint = TrackerRes.getString("TTrackBar.Hint.OpenFile");
                this.viewLabel.setText(String.valueOf(name) + ": " + hint);
                FontSizer.setFonts(this.viewLabel);
                this.add(this.viewLabel);
            }
        }
        this.add(this.toolbarEnd);
        if (!OSPRuntime.isJS && testButton != null) {
            this.add(testButton);
        }
        this.add(this.maximizeButton);
        this.revalidate();
        TFrame.repaintT(this);
    }

    @Override
    public void paint(Graphics g) {
        if (this.selectButton == null) {
            return;
        }
        super.paint(g);
    }

    private void updateSize(JComponent jc) {
        int w = jc.getPreferredSize().width;
        jc.setMaximumSize(null);
        jc.setPreferredSize(null);
        Dimension dim = jc.getPreferredSize();
        dim.height = this.toolbarComponentHeight;
        if (jc instanceof NumberField) {
            dim.width = Math.max(this.numberFieldWidth, dim.width);
        } else if (jc instanceof TTrack.TextLineLabel) {
            dim.width = w;
        } else if (jc instanceof JLabel) {
            JLabel lab = (JLabel)jc;
            lab.setToolTipText(lab.getText());
            dim.width += 4;
        }
        jc.setPreferredSize(dim);
        jc.setMaximumSize(dim);
    }

    protected void resizeField(NumberField field) {
        if (this.getComponentIndex(field) < 0) {
            return;
        }
        field.setMaximumSize(null);
        field.setPreferredSize(null);
        Dimension dim = field.getPreferredSize();
        dim.height = this.toolbarComponentHeight;
        dim.width = Math.max(this.numberFieldWidth, dim.width);
        field.setMaximumSize(dim);
        field.setPreferredSize(dim);
        this.revalidate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "selectedtrack": {
                this.refresh();
                break;
            }
            case "footprint": 
            case "name": 
            case "color": {
                this.refresh();
                break;
            }
            case "selectedpoint": {
                this.refresh();
                break;
            }
            case "track": {
                this.refresh();
                break;
            }
            case "clear": {
                for (TTrack t : TTrack.getValues()) {
                    t.removeListenerNCF(this);
                }
                if (this.trackButton != null) {
                    this.trackButton.setTrack(null);
                }
                this.refresh();
            }
        }
    }

    @Override
    public void dispose() {
        this.removeAll();
        this.panel().removeListeners(panelProps, this);
        for (TTrack t : TTrack.getValues()) {
            t.removeListenerNCF(this);
        }
        if (this.trackButton != null) {
            this.trackButton.setTrack(null);
        }
        this.panelID = null;
        this.frame = null;
    }

    protected TrackerPanel panel() {
        return this.frame == null ? null : this.frame.getTrackerPanelForID(this.panelID);
    }

    @Override
    public String toString() {
        return "[TTrackBar " + this.panelID + "]";
    }
}

