/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.opensourcephysics.cabrillo.tracker.PageTView;
import org.opensourcephysics.cabrillo.tracker.PlotTView;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TableTView;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.WorldTView;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.OSPRuntime;

public abstract class TView
extends JPanel
implements PropertyChangeListener,
OSPRuntime.Disposable {
    public static final String PROPERTY_TVIEW_TRACKVIEW = "trackview";
    public static final int VIEW_UNSET = -1;
    public static final int VIEW_PLOT = 0;
    public static final int VIEW_TABLE = 1;
    public static final int VIEW_WORLD = 2;
    public static final int VIEW_PAGE = 3;
    public static final int VIEW_MAIN = 4;
    public static final Icon[] VIEW_ICONS = new Icon[]{PlotTView.PLOTVIEW_ICON, TableTView.TABLEVIEW_ICON, WorldTView.WORLDVIEW_ICON, PageTView.PAGEVIEW_ICON};
    public static final String[] VIEW_NAMES = new String[]{"TFrame.View.Plot", "TFrame.View.Table", "TFrame.View.World", "TFrame.View.Text"};
    protected TFrame frame;
    protected Integer panelID;
    protected ArrayList<Component> toolbarComponents = new ArrayList();

    public TView(TrackerPanel panel) {
        this.frame = panel.getTFrame();
        this.panelID = panel.getID();
    }

    public abstract void init();

    public abstract void refresh();

    public abstract void cleanup();

    public abstract TrackerPanel getTrackerPanel();

    public abstract String getViewName();

    public abstract Icon getViewIcon();

    public abstract int getViewType();

    public ArrayList<Component> getToolBarComponents() {
        return this.toolbarComponents;
    }

    public void refreshPopup(JPopupMenu popup) {
    }

    public boolean isCustomState() {
        return false;
    }

    public boolean isViewPaneVisible() {
        TFrame tf;
        TrackerPanel trackerPanel = this.getTrackerPanel();
        if (trackerPanel == null || (tf = trackerPanel.getTFrame()) == null || tf.getTabCount() == 0) {
            return false;
        }
        Integer id = trackerPanel.getID();
        TView[][] views = tf.getTViews(trackerPanel, false);
        if (views == null) {
            return false;
        }
        int i = 0;
        while (i < views.length) {
            if (views[i] != null) {
                int j = 0;
                while (j < views[i].length) {
                    if (views[i][j] == this) {
                        int[] order = TFrame.isPortraitLayout() ? TFrame.PORTRAIT_VIEW_ORDER : TFrame.DEFAULT_ORDER;
                        return tf.isViewPaneVisible(order[i], id);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    @Override
    public void dispose() {
        this.frame = null;
        this.panelID = null;
        this.toolbarComponents = null;
    }

    public void finalize() {
        OSPLog.finalized(this);
    }
}

