/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import org.opensourcephysics.cabrillo.tracker.MainTView;
import org.opensourcephysics.cabrillo.tracker.PageTView;
import org.opensourcephysics.cabrillo.tracker.PlotTView;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.TableTView;
import org.opensourcephysics.cabrillo.tracker.TrackChooserTView;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.WorldTView;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.FontSizer;

public class TViewChooser
extends JPanel
implements PropertyChangeListener,
OSPRuntime.Disposable {
    protected static final Icon MAXIMIZE_ICON = Tracker.getResourceIcon("maximize.gif", true);
    protected static final Icon RESTORE_ICON = Tracker.getResourceIcon("restore.gif", true);
    protected static final Icon DOWN_ARROW_ICON = Tracker.getResourceIcon("triangle_down.gif", true);
    protected TFrame frame;
    protected Integer panelID;
    protected TView[] tViews = new TView[4];
    protected TView selectedView;
    protected int selectedType = -1;
    private JToolBar toolbar;
    private Component toolbarFiller = Box.createHorizontalGlue();
    private JButton maximizeButton;
    private JPanel viewPanel;
    private JButton chooserButton;
    protected JPopupMenu popup = new JPopupMenu();
    protected boolean ignoreSelectedTrack;

    public boolean isMaximized() {
        return this.frame != null && this.frame.getMaximizedView() != -1;
    }

    public TViewChooser(TrackerPanel panel, int type) {
        super(new BorderLayout());
        this.setName("TViewChooser " + type);
        this.frame = panel.getTFrame();
        this.panelID = panel.getID();
        panel.addPropertyChangeListener("track", this);
        panel.addPropertyChangeListener("clear", this);
        this.viewPanel = new JPanel(new CardLayout());
        this.viewPanel.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.viewPanel, "Center");
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TViewChooser.this.toolbar.requestFocusInWindow();
                if (e.getClickCount() == 2) {
                    TViewChooser.this.maximizeButton.doClick(0);
                }
                if (OSPRuntime.isPopupTrigger(e)) {
                    TViewChooser.this.showToolbarPopup(e.getX(), e.getY());
                }
            }
        });
        this.toolbar.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.toolbar, "North");
        this.chooserButton = new TButton(){

            @Override
            protected JPopupMenu getPopup() {
                return TViewChooser.this.getChooserPopup();
            }
        };
        Border empty = BorderFactory.createEmptyBorder(7, 3, 7, 3);
        Border etched = BorderFactory.createEtchedBorder();
        this.maximizeButton = new TButton(MAXIMIZE_ICON, RESTORE_ICON);
        this.maximizeButton.setBorder(BorderFactory.createCompoundBorder(etched, empty));
        this.maximizeButton.setToolTipText(TrackerRes.getString("TViewChooser.Maximize.Tooltip"));
        this.maximizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!TViewChooser.this.isMaximized()) {
                    TViewChooser.this.maximize();
                } else {
                    TViewChooser.this.restore();
                }
            }
        });
        this.setSelectedViewType(type);
    }

    private void refreshMaximizeButton() {
        boolean maximized = this.isMaximized();
        this.maximizeButton.setSelected(maximized);
        if (OSPRuntime.isJS) {
            this.maximizeButton.setIcon(maximized ? RESTORE_ICON : MAXIMIZE_ICON);
        }
        this.maximizeButton.setToolTipText(maximized ? TrackerRes.getString("TViewChooser.Restore.Tooltip") : TrackerRes.getString("TViewChooser.Maximize.Tooltip"));
    }

    protected void showToolbarPopup(int x, int y) {
        final TView view = this.getSelectedView();
        if (view == null) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        view.refreshPopup(popup);
        JMenuItem helpItem = new JMenuItem(String.valueOf(TrackerRes.getString("Dialog.Button.Help")) + "...");
        helpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (view.getViewType()) {
                    case 3: {
                        TViewChooser.this.frame.showHelp("textview", 0);
                        break;
                    }
                    case 1: {
                        TViewChooser.this.frame.showHelp("datatable", 0);
                        break;
                    }
                    case 0: {
                        TViewChooser.this.frame.showHelp("plot", 0);
                        break;
                    }
                    case 2: {
                        TViewChooser.this.frame.showHelp("GUI", 0);
                    }
                }
            }
        });
        popup.add(helpItem);
        FontSizer.setFonts(popup, FontSizer.getLevel());
        popup.show(this.toolbar, x, y);
    }

    protected JPopupMenu getChooserPopup() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = Integer.parseInt(e.getActionCommand());
                TViewChooser.this.setSelectedViewType(i);
            }
        };
        this.popup.removeAll();
        int i = 0;
        while (i < TView.VIEW_NAMES.length) {
            String name = TrackerRes.getString(TView.VIEW_NAMES[i]);
            JMenuItem item = new JMenuItem(name, TView.VIEW_ICONS[i]);
            item.setActionCommand("" + i);
            item.addActionListener(listener);
            this.popup.add(item);
            ++i;
        }
        FontSizer.setFonts(this.popup, FontSizer.getLevel());
        return this.popup;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public TrackerPanel getTrackerPanel() {
        return this.frame.getTrackerPanelForID(this.panelID);
    }

    public TView[] getTViews() {
        return this.tViews;
    }

    public TView getTView(Class<? extends TView> c) {
        TView[] tViewArray = this.tViews;
        int n = this.tViews.length;
        int n2 = 0;
        while (n2 < n) {
            TView view = tViewArray[n2];
            if (view != null && view.getClass() == c) {
                return view;
            }
            ++n2;
        }
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        if (c == PlotTView.class) {
            this.tViews[0] = new PlotTView(trackerPanel);
            return this.tViews[0];
        }
        if (c == TableTView.class) {
            this.tViews[1] = new TableTView(trackerPanel);
            return this.tViews[1];
        }
        if (c == WorldTView.class) {
            this.tViews[2] = new WorldTView(trackerPanel);
            return this.tViews[2];
        }
        if (c == PageTView.class) {
            this.tViews[3] = new PageTView(trackerPanel);
            return this.tViews[3];
        }
        return null;
    }

    public TView getSelectedView() {
        return this.selectedView;
    }

    public int getSelectedViewType() {
        return this.selectedType;
    }

    public void setSelectedView(TView view, boolean newView) {
        if (view == null || this.selectedView == view) {
            return;
        }
        if (newView) {
            this.selectedType = view instanceof PlotTView ? 0 : (view instanceof TableTView ? 1 : (view instanceof WorldTView ? 2 : 3));
            this.tViews[this.selectedType] = view;
            this.refreshViewPanel();
        }
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        trackerPanel.changed = true;
        TTrack selectedTrack = null;
        if (this.selectedView != null) {
            this.selectedView.cleanup();
            this.selectedView.removePropertyChangeListener("trackview", this);
            boolean isTrackChooser = this.selectedView instanceof TrackChooserTView;
            if (isTrackChooser && !this.ignoreSelectedTrack) {
                selectedTrack = ((TrackChooserTView)this.selectedView).getSelectedTrack();
            }
            this.ignoreSelectedTrack = false;
        }
        this.selectedView = view;
        view.init();
        ((Component)view).addPropertyChangeListener("trackview", this);
        if (selectedTrack != null && this.selectedView instanceof TrackChooserTView) {
            ((TrackChooserTView)this.selectedView).setSelectedTrack(selectedTrack);
        }
        view.refresh();
        this.chooserButton.setIcon(view.getViewIcon());
        CardLayout cl = (CardLayout)this.viewPanel.getLayout();
        cl.show(this.viewPanel, TView.VIEW_NAMES[this.selectedType]);
        this.repaint();
        this.refreshToolbar();
    }

    public void setSelectedViewType(int type) {
        if (type < 0 || type > 3) {
            this.ignoreSelectedTrack = false;
            return;
        }
        TView view = this.tViews[type];
        if (type == this.selectedType) {
            this.ignoreSelectedTrack = false;
            if (view != null) {
                view.refresh();
                return;
            }
        }
        this.selectedType = type;
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        if (view == null) {
            switch (type) {
                default: {
                    view = new PlotTView(trackerPanel);
                    break;
                }
                case 1: {
                    view = new TableTView(trackerPanel);
                    break;
                }
                case 2: {
                    view = new WorldTView(trackerPanel);
                    break;
                }
                case 3: {
                    view = new PageTView(trackerPanel);
                }
            }
            this.tViews[type] = view;
            this.refreshViewPanel();
        }
        if (view.getParent() == null) {
            this.refreshViewPanel();
        }
        view.refresh();
        this.setSelectedView(view, false);
    }

    public TView removeViewType(int viewType) {
        TView view = null;
        if (viewType > -1 && viewType < 4) {
            view = this.tViews[viewType];
            this.tViews[viewType] = null;
            if (viewType == this.selectedType) {
                this.selectedView = null;
                TViewChooser[] viewChoosers = this.frame.getViewChoosers(this.panelID);
                int i = 0;
                while (i < viewChoosers.length) {
                    if (viewChoosers[i] == this) {
                        this.setSelectedViewType(i);
                        break;
                    }
                    ++i;
                }
            }
            this.refreshViewPanel();
        }
        return view;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "clear": 
            case "track": {
                TView[] tViewArray = this.tViews;
                int n = this.tViews.length;
                int n2 = 0;
                while (n2 < n) {
                    TView view = tViewArray[n2];
                    if (view != null) {
                        view.propertyChange(e);
                    }
                    ++n2;
                }
                this.refreshToolbar();
                break;
            }
            case "trackview": {
                this.refreshToolbar();
            }
        }
    }

    public void refresh() {
        this.chooserButton.setToolTipText(TrackerRes.getString("TViewChooser.Button.Choose.Tooltip"));
        if (this.selectedView != null) {
            this.selectedView.refresh();
        }
    }

    public void refreshMenus() {
        int i = 0;
        while (i < 2) {
            if (this.tViews[i] != null) {
                TrackChooserTView chooser = (TrackChooserTView)this.tViews[i];
                chooser.refreshMenus();
            }
            ++i;
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.chooserButton.setEnabled(enable);
        this.maximizeButton.setEnabled(enable);
        TView view = this.getSelectedView();
        ArrayList<Component> comps = view.getToolBarComponents();
        int j = 0;
        while (j < comps.size()) {
            comps.get(j).setEnabled(enable);
            ++j;
        }
    }

    public void maximize() {
        if (this.isMaximized()) {
            return;
        }
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        this.frame.saveCurrentDividerLocations(trackerPanel);
        JToolBar player = this.frame.getMainView(trackerPanel).getPlayerBar();
        if (player.getTopLevelAncestor() == this.frame) {
            this.add((Component)player, "South");
        }
        TViewChooser[] choosers = this.frame.getViewChoosers(trackerPanel);
        int i = 0;
        while (i < choosers.length) {
            if (choosers[i] == this) {
                this.frame.maximizeView(trackerPanel, i);
                break;
            }
            ++i;
        }
        this.refreshMaximizeButton();
    }

    public void restore() {
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        MainTView mainView = this.frame.getMainView(trackerPanel);
        JToolBar player = mainView.getPlayerBar();
        if (player.getParent() == this) {
            mainView.add((Component)player, "South");
        }
        this.frame.restoreViews(trackerPanel);
        this.refreshMaximizeButton();
    }

    protected void refreshToolbar() {
        ArrayList<Component> list;
        this.toolbar.removeAll();
        this.toolbar.add(this.chooserButton);
        if (this.selectedView != null && (list = this.selectedView.getToolBarComponents()) != null) {
            for (Component c : list) {
                this.toolbar.add(c);
                FontSizer.setFont(c);
            }
        }
        this.toolbar.add(this.toolbarFiller);
        this.toolbar.add(this.maximizeButton);
        this.toolbar.repaint();
    }

    private void refreshViewPanel() {
        this.viewPanel.removeAll();
        int i = 0;
        while (i < 4) {
            TView view = this.tViews[i];
            if (view != null) {
                this.viewPanel.add((Component)view, TView.VIEW_NAMES[i]);
            }
            ++i;
        }
        if (this.selectedView != null) {
            this.repaint();
        } else {
            this.setSelectedViewType(this.selectedType);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    TView getView(int type) {
        if (type >= 0 && type < this.tViews.length) {
            return this.tViews[type];
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        if (this.panelID == null || !this.frame.getTrackerPanelForID(this.panelID).isPaintable()) {
            return;
        }
        super.paint(g);
    }

    public static TViewChooser getChooserParent(Container c) {
        while ((c = c.getParent()) != null && !(c instanceof TViewChooser)) {
        }
        return (TViewChooser)c;
    }

    static Dimension getButtonMaxSize(Container c, Dimension max, int minHeight) {
        return (c = TViewChooser.getChooserParent(c)) == null ? max : new Dimension(max.width, Math.max(minHeight, ((TViewChooser)c).chooserButton.getHeight()));
    }

    public static boolean isSelectedView(TView view) {
        TViewChooser c = TViewChooser.getChooserParent(view);
        return c != null && view == c.getSelectedView();
    }

    public void finalize() {
    }

    @Override
    public void dispose() {
        CardLayout cl = (CardLayout)this.viewPanel.getLayout();
        TView[] tViewArray = this.tViews;
        int n = this.tViews.length;
        int n2 = 0;
        while (n2 < n) {
            TView view = tViewArray[n2];
            if (view != null) {
                view.removePropertyChangeListener("trackview", this);
                cl.removeLayoutComponent(view);
                OSPRuntime.Disposable.deallocate(view);
            }
            ++n2;
        }
        this.tViews = null;
        this.selectedView = null;
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        trackerPanel.removePropertyChangeListener("track", this);
        trackerPanel.removePropertyChangeListener("clear", this);
        this.viewPanel.removeAll();
        this.toolbar.removeAll();
        this.panelID = null;
        this.frame = null;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + " " + Arrays.toString(this.tViews);
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            TViewChooser chooser = (TViewChooser)obj;
            control.setValue("selected_view", chooser.selectedView);
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            TViewChooser chooser = (TViewChooser)obj;
            TView view = (TView)control.getObject("selected_view");
            if (view != null) {
                chooser.setSelectedView(view, true);
            }
            return obj;
        }
    }
}

