/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TableTrackView;
import org.opensourcephysics.cabrillo.tracker.TrackChooserTView;
import org.opensourcephysics.cabrillo.tracker.TrackView;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.tools.FontSizer;

public class TableTView
extends TrackChooserTView {
    protected static final Icon TABLEVIEW_ICON = Tracker.getResourceIcon("datatable.gif", true);

    public TableTView(TrackerPanel panel) {
        super(panel);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.frame.removePropertyChangeListener("tab", this);
        this.frame.addPropertyChangeListener("tab", this);
    }

    @Override
    public void removeNotify() {
        if (this.panelID != null && this.frame != null) {
            this.frame.removePropertyChangeListener("tab", this);
        }
        super.removeNotify();
    }

    @Override
    public String getViewName() {
        return TrackerRes.getString("TFrame.View.Table");
    }

    @Override
    public Icon getViewIcon() {
        return TABLEVIEW_ICON;
    }

    @Override
    public int getViewType() {
        return 1;
    }

    @Override
    public void refreshPopup(JPopupMenu popup) {
        TableTrackView trackview = (TableTrackView)this.getTrackView(this.selectedTrack);
        if (trackview != null) {
            trackview.refreshToolbarPopup(popup);
        }
    }

    @Override
    protected TrackView createTrackView(TTrack track) {
        TableTrackView trackView = new TableTrackView(track, this.getPanel(), this);
        FontSizer.setFonts(trackView);
        return trackView;
    }

    protected void refreshColumnsDialog(TTrack track, boolean onlyIfVisible) {
        TableTrackView tableView = (TableTrackView)this.getTrackView(track);
        if (tableView != null) {
            tableView.refreshColumnDialog(track, onlyIfVisible);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        TrackerPanel panel = this.getPanel();
        switch (e.getPropertyName()) {
            case "format": {
                TrackView view = null;
                TTrack track = this.getSelectedTrack();
                if (track == null || (view = this.getTrackView(track)) == null) break;
                int frameNo = panel.getFrameNumber();
                view.refresh(frameNo, 4352);
                break;
            }
            case "tab": {
                TableTrackView trackview;
                if (e.getNewValue() == null || this.frame.isRemovingAll() || (trackview = (TableTrackView)this.getTrackView(this.selectedTrack)) == null) break;
                trackview.setDialogAsLastVisible(e.getNewValue() == panel && this.isVisible());
                break;
            }
            case "function": {
                super.propertyChange(e);
                if (this.trackViews == null) break;
                for (TrackView next : this.trackViews.values()) {
                    TableTrackView trackView = (TableTrackView)next;
                    trackView.refreshNameMaps();
                    trackView.buildForNewFunction();
                }
                break;
            }
            default: {
                super.propertyChange(e);
            }
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.panelID != null && this.frame != null) {
            this.frame.removePropertyChangeListener("tab", this);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    @Override
    protected void refreshMenus() {
    }

    @Override
    public void dispose() {
        this.frame.removePropertyChangeListener("tab", this);
        super.dispose();
    }

    static class Loader
    implements XML.ObjectLoader {
        private TableTrackView tableTrackView;
        private TTrack track;
        private TableTView view;
        private Map<TTrack, TrackView> trackViews;

        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            TableTView view = (TableTView)obj;
            TTrack selectedTrack = view.getSelectedTrack();
            if (selectedTrack != null) {
                control.setValue("selected_track", selectedTrack.getName());
                ArrayList<TTrack> customized = new ArrayList<TTrack>();
                Map views = view.trackViews;
                for (TTrack next : views.keySet()) {
                    if (!((TrackView)views.get(next)).isCustomState()) continue;
                    customized.add(next);
                }
                if (!customized.isEmpty()) {
                    ArrayList<String[][]> formattedColumns = new ArrayList<String[][]>();
                    String[][] data = new String[customized.size()][];
                    ArrayList<String[]> datasetIndices = new ArrayList<String[]>();
                    int i = 0;
                    int n = customized.size();
                    while (i < n) {
                        TTrack track = (TTrack)customized.get(i);
                        String name = track.getName();
                        TableTrackView trackView = (TableTrackView)view.getTrackView(track);
                        String[] columns = trackView.getOrderedVisibleColumns();
                        data[i] = new String[columns.length + 1];
                        data[i][0] = name;
                        System.arraycopy(columns, 0, data[i], 1, columns.length);
                        String[][] formats = trackView.getColumnFormats();
                        if (formats.length > 0) {
                            String[][] withName = new String[formats.length][3];
                            int j = 0;
                            while (j < formats.length) {
                                withName[j][0] = name;
                                withName[j][1] = formats[j][0];
                                withName[j][2] = formats[j][1];
                                ++j;
                            }
                            formattedColumns.add(withName);
                        }
                        if (trackView.myDatasetIndex > -1) {
                            datasetIndices.add(new String[]{name, Integer.toString(trackView.myDatasetIndex)});
                        }
                        ++i;
                    }
                    control.setValue("track_columns", data);
                    if (!formattedColumns.isEmpty()) {
                        String[][][] patterns = (String[][][])formattedColumns.toArray((T[])new String[formattedColumns.size()][][]);
                        control.setValue("column_formats", patterns);
                    }
                    if (!datasetIndices.isEmpty()) {
                        String[][] indices = (String[][])datasetIndices.toArray((T[])new String[datasetIndices.size()][]);
                        control.setValue("dataset_indices", indices);
                    }
                }
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            TTrack selectedTrack;
            this.view = (TableTView)obj;
            this.trackViews = this.view.trackViews;
            String[][] data = (String[][])control.getObject("track_columns");
            if (data != null && this.trackViews == null) {
                this.view.refresh();
                this.trackViews = this.view.trackViews;
            }
            if (this.trackViews != null && data != null) {
                String[][] datasetIndices;
                int i = 0;
                while (i < data.length) {
                    String[] columns = data[i];
                    if (columns != null && this.setTrackAndTableView(columns[0])) {
                        this.tableTrackView.setRefreshing(false);
                        this.tableTrackView.bsCheckBoxes.clear();
                        this.tableTrackView.bsTextColumnsVisible.clear();
                        columns = Loader.fixColumnList(columns, this.track);
                        int j = 1;
                        while (j < columns.length) {
                            columns[j] = Loader.fixColumnName(columns[j], this.track);
                            this.tableTrackView.setVisible(columns[j], true);
                            ++j;
                        }
                        this.setColumnOrder(this.tableTrackView, this.track, columns);
                        this.tableTrackView.setRefreshing(true);
                    }
                    ++i;
                }
                String[][][] formats = (String[][][])control.getObject("column_formats");
                if (formats != null) {
                    int i2 = 0;
                    while (i2 < formats.length) {
                        String[][] patterns = formats[i2];
                        if (this.setTrackAndTableView(patterns[0][0])) {
                            this.tableTrackView.setRefreshing(false);
                            int j = 0;
                            while (j < patterns.length) {
                                this.tableTrackView.dataTable.setFormatPattern(patterns[j][1], patterns[j][2]);
                                ++j;
                            }
                            this.tableTrackView.setRefreshing(true);
                        }
                        ++i2;
                    }
                }
                if ((datasetIndices = (String[][])control.getObject("dataset_indices")) != null) {
                    int i3 = 0;
                    while (i3 < datasetIndices.length) {
                        String[] indices = datasetIndices[i3];
                        if (this.setTrackAndTableView(indices[0])) {
                            this.tableTrackView.setRefreshing(false);
                            this.tableTrackView.setDatasetIndex(Integer.parseInt(indices[1]));
                            this.tableTrackView.setRefreshing(true);
                        }
                        ++i3;
                    }
                }
            }
            if ((selectedTrack = this.view.getTrack(control.getString("selected_track"))) != null) {
                this.view.setSelectedTrack(selectedTrack);
                String[] visibleColumns = (String[])control.getObject("visible_columns");
                if (visibleColumns != null) {
                    this.tableTrackView = (TableTrackView)this.view.getTrackView(selectedTrack);
                    this.tableTrackView.setRefreshing(false);
                    this.tableTrackView.bsCheckBoxes.clear();
                    int i = 0;
                    while (i < visibleColumns.length) {
                        this.tableTrackView.setVisible(Loader.fixColumnName(visibleColumns[i], selectedTrack), true);
                        ++i;
                    }
                    this.tableTrackView.setRefreshing(true);
                    this.tableTrackView.refresh(this.view.getPanel().getFrameNumber(), 6144);
                }
            }
            this.tableTrackView = null;
            this.view = null;
            this.trackViews = null;
            return obj;
        }

        private boolean setTrackAndTableView(String name) {
            for (TTrack track : this.trackViews.keySet()) {
                this.tableTrackView = (TableTrackView)this.view.getTrackView(track);
                if (this.tableTrackView == null || !name.equals(track.getName())) continue;
                this.track = track;
                return true;
            }
            this.tableTrackView = null;
            return false;
        }

        private static String fixColumnName(String name, TTrack track) {
            switch (name) {
                case "theta": {
                    return track.ttype == 5 ? "\u03b8r" : "\u03b8";
                }
                case "theta_v": {
                    return "\u03b8v";
                }
                case "theta_a": {
                    return "\u03b8a";
                }
                case "theta_p": {
                    return "\u03b8p";
                }
                case "n": {
                    return track.ttype == 5 ? "step" : name;
                }
                case "KE": {
                    return "K";
                }
                case "x-comp": {
                    return "x";
                }
                case "y-comp": {
                    return "y";
                }
                case "x_tail": {
                    return "xtail";
                }
                case "y_tail": {
                    return "ytail";
                }
                case "pixelx": 
                case "pixely": 
                case "ax": 
                case "ay": 
                case "px": 
                case "py": 
                case "vx": 
                case "vy": {
                    return String.valueOf(name.substring(0, name.length() - 1)) + "_{" + name.charAt(name.length() - 1) + "}";
                }
            }
            return name;
        }

        private static String[] fixColumnList(String[] columns, TTrack track) {
            String indepVar = track.getDataName(0);
            if (columns.length < 2 || indepVar.equals(columns[1])) {
                return columns;
            }
            String[] newCols = new String[columns.length + 1];
            newCols[0] = columns[0];
            newCols[1] = indepVar;
            int i = 1;
            while (i < columns.length) {
                newCols[i + 1] = columns[i];
                ++i;
            }
            return newCols;
        }

        private void setColumnOrder(TableTrackView tableView, TTrack track, String[] columns) {
            String[] checkedBoxes = tableView.getVisibleColumns();
            if (checkedBoxes.length == 0) {
                return;
            }
            String[] visibleColumns = new String[checkedBoxes.length + 1];
            visibleColumns[0] = track.getDataName(0);
            System.arraycopy(checkedBoxes, 0, visibleColumns, 1, checkedBoxes.length);
            String[] desiredOrder = new String[columns.length - 1];
            System.arraycopy(columns, 1, desiredOrder, 0, desiredOrder.length);
            int[] desiredIndexes = new int[desiredOrder.length];
            int k = 0;
            while (k < desiredOrder.length) {
                String name = desiredOrder[k];
                int g = 0;
                while (g < visibleColumns.length) {
                    if (visibleColumns[g].equals(name)) {
                        desiredIndexes[k] = g;
                    }
                    ++g;
                }
                ++k;
            }
            SwingUtilities.invokeLater(() -> {
                try {
                    tableTrackView.dataTable.setModelColumnOrder(desiredIndexes);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.err.println("TableTView.Loader invokelater exception " + Arrays.toString(desiredIndexes));
                }
            });
        }
    }
}

