/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javajs.async.AsyncDialog;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.opensourcephysics.cabrillo.tracker.LineProfile;
import org.opensourcephysics.cabrillo.tracker.NumberFormatDialog;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.TableTView;
import org.opensourcephysics.cabrillo.tracker.TrackView;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.UnitsDialog;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.tools.DataRefreshTool;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.LocalJob;
import org.opensourcephysics.tools.ToolsRes;

public class TableTrackView
extends TrackView {
    static final String DEFINED_AS = ": ";
    static final Icon SKIPS_ON_ICON = Tracker.getResourceIcon("skips_on.gif", true);
    static final Icon SKIPS_OFF_ICON = Tracker.getResourceIcon("skips_off.gif", true);
    protected DatasetManager trackDataManager;
    protected DatasetManager dataTableManager;
    BitSet bsCheckBoxes = new BitSet();
    protected int colCount;
    protected int datasetCount;
    private Map<String, Integer> htNames;
    private String[] aNames;
    protected boolean dialogLastVisible;
    private boolean showAllColumns;
    private int varCount;
    protected boolean refreshing = true;
    private boolean refreshed = false;
    private int leadCol;
    private final Font font = new JTextField().getFont();
    private final Map<String, TableCellRenderer> degreeRenderers = new HashMap<String, TableCellRenderer>();
    protected final ArrayList<String> textColumnNames = new ArrayList();
    protected final BitSet bsTextColumnsVisible = new BitSet();
    protected final TreeSet<Double> selectedIndepVarValues = new TreeSet();
    private boolean haveMenuItems;
    protected TrackDataTable dataTable;
    protected TextColumnEditor textColumnEditor;
    protected TextColumnTableModel textColumnModel;
    protected JButton columnsDialogButton;
    protected JButton gapsButton;
    protected JButton multipleFramesButton;
    protected JCheckBox multiframeCheckbox;
    private ColumnsDialog columnsDialog;
    private JPopupMenu popup;
    private JMenu textColumnMenu;
    private JMenu deleteTextColumnMenu;
    private JMenu renameTextColumnMenu;
    private JMenuItem createTextColumnItem;
    private JMenuItem dataToolItem;
    private JMenuItem dataBuilderItem;
    private JMenuItem deleteDataFunctionItem;
    private JMenu numberMenu;
    private JMenuItem goToFrameItem;
    private JMenuItem formatDialogItem;
    private JMenuItem setUnitsItem;
    private JMenuItem showUnitsItem;
    private JMenu copyDataMenu;
    private JMenuItem copyDataRawItem;
    private JMenuItem copyDataFormattedItem;
    private JMenu setDelimiterMenu;
    private JMenuItem includeHeadersItem;
    private JMenuItem copyImageItem;
    private JMenuItem snapshotItem;
    private JMenuItem printItem;
    private JMenuItem helpItem;

    public void setRefreshing(boolean b) {
        this.refreshing = b;
    }

    public TableTrackView(TTrack track, TrackerPanel panel, TableTView view) {
        super(track, panel, view, 1);
        track.addPropertyChangeListener("text_column", this);
        this.textColumnNames.addAll(track.getTextColumnNames());
        this.textColumnModel = new TextColumnTableModel();
        this.textColumnEditor = new TextColumnEditor();
        this.dataTable = new TrackDataTable();
        this.trackDataManager = track.getData(panel, this.myDatasetIndex);
        this.dataTableManager = new DatasetManager();
        this.dataTableManager.setXPointsLinked(true);
        this.dataTable.add(this.dataTableManager.model);
        this.dataTable.add(this.textColumnModel);
        this.setViewportView(this.dataTable);
        this.dataTable.setPreferredScrollableViewportSize(new Dimension(160, 200));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TableTrackView.this.dataTable.clearSelection();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                TableTrackView.this.dataTable.requestFocusInWindow();
            }
        });
        this.dataTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                TableTrackView.this.dataTable.requestFocusInWindow();
            }
        });
        this.dataTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    int row = TableTrackView.this.dataTable.getSelectedRow();
                    int col = TableTrackView.this.dataTable.getSelectedColumn();
                    TableTrackView.this.dataTable.editCellAt(row, col);
                    TableTrackView.this.textColumnEditor.field.selectAll();
                    Runnable runner = new Runnable(){

                        @Override
                        public synchronized void run() {
                            (this).TableTrackView.this.textColumnEditor.field.requestFocusInWindow();
                        }
                    };
                    SwingUtilities.invokeLater(runner);
                }
            }
        });
        ListSelectionModel selectionModel = this.dataTable.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TableTrackView.this.selectedIndepVarValues.clear();
                int[] rows = TableTrackView.this.dataTable.getSelectedRows();
                int i = 0;
                while (i < rows.length) {
                    double val = TableTrackView.this.getIndepVarValueAtRow(rows[i]);
                    if (!Double.isNaN(val)) {
                        TableTrackView.this.selectedIndepVarValues.add(val);
                    }
                    ++i;
                }
            }
        });
        this.setToolTipText(ToolsRes.getString("DataToolTab.Scroller.Tooltip"));
        this.highlightVisible = track.ttype != 3;
        this.refreshNameMaps();
        this.createGUI();
        boolean useDefault = true;
        int i = 0;
        while (i < 4) {
            String col = (String)track.getProperty("tableVar" + i);
            if (col != null) {
                this.setVisible(Integer.parseInt(col), true);
                useDefault = false;
            }
            ++i;
        }
        if (useDefault) {
            this.setVisible(0, true);
            this.setVisible(1, true);
        }
        TreeMap<String, String> patterns = panel.getFormatPatterns(track.ttype);
        TrackDataTable table = this.getDataTable();
        for (Map.Entry<String, String> e : patterns.entrySet()) {
            table.setFormatPattern(e.getKey(), e.getValue());
        }
        this.prevDatasetIndex = 5;
    }

    protected void refreshNameMaps() {
        String name;
        if (this.myDatasetIndex > -1) {
            return;
        }
        this.htNames = new LinkedHashMap<String, Integer>();
        ArrayList<Dataset> sets = this.trackDataManager.getDatasetsRaw();
        ArrayList<String> textSet = this.textColumnNames;
        this.datasetCount = sets.size();
        this.colCount = this.datasetCount + textSet.size();
        this.aNames = new String[this.colCount];
        this.varCount = 0;
        int i = 0;
        while (i < this.datasetCount) {
            Dataset next = sets.get(i);
            this.aNames[i] = name = next.getYColumnName();
            this.htNames.put(name, i);
            if (next.getClass() == Dataset.class) {
                ++this.varCount;
            }
            ++i;
        }
        i = 0;
        int n = textSet.size();
        while (i < n) {
            this.aNames[this.datasetCount + i] = name = textSet.get(i);
            this.htNames.put(name, this.datasetCount + i);
            ++i;
        }
    }

    @Override
    public void refresh(int frameNumber, int mode) {
        TViewChooser chooser;
        this.forceRefresh = false;
        if (!this.forceRefresh && !this.isRefreshEnabled() || !this.viewParent.isViewPaneVisible()) {
            return;
        }
        this.forceRefresh = false;
        if (mode == 6400) {
            FontSizer.setFonts(this.columnsDialogButton);
            FontSizer.setFonts(this.gapsButton);
            FontSizer.setFonts(this.multipleFramesButton);
            FontSizer.setFonts(this.multiframeCheckbox);
        }
        if (this.isClipAdjusting()) {
            return;
        }
        if (mode == 7168 && this.getTrack() instanceof PointMass && (chooser = this.getOwner()) != null) {
            chooser.refreshToolbar();
        }
        if (Tracker.timeLogEnabled) {
            Tracker.logTime(String.valueOf(this.getClass().getSimpleName()) + this.hashCode() + " refresh " + frameNumber);
        }
        this.dataTable.clearSelection();
        TTrack track = this.getTrack();
        int highlightCol = -1;
        try {
            ArrayList<Dataset> datasets;
            int count;
            this.trackDataManager = track.getData(this.frame.getTrackerPanelForID(this.panelID), this.myDatasetIndex);
            if (this.datasetCount != this.trackDataManager.getDatasetsRaw().size()) {
                this.refreshNameMaps();
            }
            if ((count = (datasets = this.trackDataManager.getDatasetsRaw()).size()) > 0) {
                this.dataTable.setUnits(datasets.get(0).getXColumnName(), "", track.getDataDescription(0));
            }
            boolean degrees = this.frame != null && !this.frame.isAnglesInRadians();
            this.dataTableManager.clear();
            int colCount = 0;
            int i = 0;
            while (i < count) {
                if (this.showAllColumns || this.bsCheckBoxes.get(i)) {
                    boolean refreshUnits;
                    int k;
                    String yTitle;
                    Dataset ds = datasets.get(i);
                    String xTitle = ds.getXColumnName();
                    String yVarName = yTitle = ds.getYColumnName();
                    if (this.myDatasetIndex > -1 && (k = yVarName.indexOf("_{ ")) > 0) {
                        if (highlightCol == -1) {
                            try {
                                String num = yVarName.substring(k + 3, yVarName.indexOf("}"));
                                if (frameNumber == Integer.parseInt(num)) {
                                    highlightCol = i + 1;
                                }
                            }
                            catch (Exception num) {
                                // empty catch block
                            }
                        }
                        yVarName = yVarName.substring(0, k);
                    }
                    double[] yPoints = ds.getYPoints();
                    boolean bl = refreshUnits = this.myDatasetIndex == -1 || i < 2;
                    if (refreshUnits && this.setUnitsAndTooltip(yVarName, track.getDataDescription(i + 1), degrees)) {
                        int k2 = 0;
                        while (k2 < yPoints.length) {
                            if (!Double.isNaN(yPoints[k2])) {
                                int n = k2;
                                yPoints[n] = yPoints[n] * 57.29577951308232;
                            }
                            ++k2;
                        }
                    }
                    Dataset local = this.dataTableManager.getDataset(colCount++);
                    local.append(ds.getXPointsRaw(), yPoints, ds.getIndex());
                    local.setXYColumnNames(xTitle, yTitle);
                    local.setYColumnVisible(true);
                }
                ++i;
            }
            i = colCount;
            while (i < this.dataTableManager.getDatasetsRaw().size()) {
                this.dataTableManager.setYColumnVisible(i, false);
                ++i;
            }
            if (colCount == 0 && count > 0) {
                Dataset in = datasets.get(0);
                String xTitle = in.getXColumnName();
                Dataset local = this.dataTableManager.getDataset(colCount++);
                double[] x = in.getXPointsRaw();
                local.append(x, x, in.getIndex());
                local.setXYColumnNames(xTitle, xTitle);
                local.setYColumnVisible(false);
                ++colCount;
            }
            this.dataTable.refreshColumnModel();
            if (this.isRefreshEnabled()) {
                this.dataTable.refreshTable(mode);
            }
            this.refreshed = true;
        }
        catch (Exception e) {
            OSPLog.debug("TableTrackView exception " + e);
            e.printStackTrace();
        }
        this.highlightFrames(frameNumber);
        if (this.getTrack().getClass().getSimpleName().equals("LineProfile")) {
            this.dataTable.getTableHeader().repaint();
            LineProfile lp = (LineProfile)this.getTrack();
            if (lp.isMultipleFrames()) {
                this.highlightColumnForFrame(highlightCol);
                return;
            }
        }
        this.highlightRowForFrame(frameNumber);
    }

    private boolean setUnitsAndTooltip(String yTitle, String root, boolean degrees) {
        boolean yIsAngle = yTitle.startsWith(Tracker.THETA) || yTitle.startsWith(Tracker.OMEGA) || yTitle.startsWith(Tracker.ALPHA);
        String tooltip = String.valueOf(root) + " ";
        String units = "";
        if (yIsAngle) {
            String t = this.frame.getTrackerPanelForID(this.panelID).getTimeUnit();
            tooltip = degrees ? String.valueOf(tooltip) + TrackerRes.getString("TableTrackView.Degrees.Tooltip") : String.valueOf(tooltip) + TrackerRes.getString("TableTrackView.Radians.Tooltip");
            if (yTitle.startsWith(Tracker.THETA)) {
                if (degrees) {
                    units = "\u00b0";
                }
            } else if (yTitle.startsWith(Tracker.OMEGA)) {
                tooltip = String.valueOf(tooltip) + "/" + t;
            } else if (yTitle.startsWith(Tracker.ALPHA)) {
                tooltip = String.valueOf(tooltip) + "/" + t + "^2";
            }
            TableCellRenderer precisionRenderer = this.dataTable.getPrecisionRenderer(yTitle);
            if (degrees) {
                if (precisionRenderer == null) {
                    this.dataTable.setFormatPattern(yTitle, "0.0");
                    this.degreeRenderers.put(yTitle, this.dataTable.getPrecisionRenderer(yTitle));
                }
            } else if (precisionRenderer != null && precisionRenderer == this.degreeRenderers.get(yTitle)) {
                this.dataTable.setFormatPattern(yTitle, null);
                this.degreeRenderers.remove(yTitle);
            }
        }
        if ("".equals(tooltip.trim())) {
            tooltip = "";
        }
        this.dataTable.setUnits(yTitle, units, tooltip);
        return yIsAngle && degrees;
    }

    @Override
    void refreshGUI() {
        TTrack track = this.getTrack();
        this.columnsDialogButton.setText(TrackerRes.getString("TableTrackView.Button.SelectTableData"));
        this.columnsDialogButton.setToolTipText(TrackerRes.getString("TableTrackView.Button.SelectTableData.ToolTip"));
        this.gapsButton.setToolTipText(TrackerRes.getString("TableTrackView.Button.SkippedFrames.ToolTip"));
        this.multiframeCheckbox.setSelected(this.myDatasetIndex > -1);
        this.multiframeCheckbox.setText(TrackerRes.getString("TableTrackView.Checkbox.Multiframe"));
        this.multiframeCheckbox.setToolTipText(TrackerRes.getString("TableTrackView.Button.SwitchTo.Tooltip"));
        if (track.ttype == 3) {
            LineProfile lp = (LineProfile)track;
            this.multiframeCheckbox.setEnabled(lp.isFixed());
        }
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        this.trackDataManager = track.getData(trackerPanel, this.myDatasetIndex);
        this.refresh(trackerPanel.getFrameNumber(), 4352);
        if (this.columnsDialog == null || !this.columnsDialog.isVisible()) {
            return;
        }
        this.columnsDialog.refreshGUI();
    }

    private void refreshGapsButton() {
        TTrack track = this.getTrack();
        if (track.ttype == 5) {
            boolean hasSkips;
            PointMass p = (PointMass)track;
            boolean hasGaps = p.hasGaps();
            boolean bl = hasSkips = p.skippedSteps.size() > 0;
            this.gapsButton.setIcon(!hasGaps ? null : (this.gapsButton.isSelected() ? SKIPS_ON_ICON : SKIPS_OFF_ICON));
            this.gapsButton.setEnabled(hasGaps || hasSkips);
        }
    }

    public TrackDataTable getDataTable() {
        return this.dataTable;
    }

    @Override
    public ArrayList<Component> getToolBarComponents() {
        this.toolbarComponents.clear();
        switch (this.getTrack().ttype) {
            case 5: {
                this.toolbarComponents.add(this.gapsButton);
                this.refreshGapsButton();
                break;
            }
            case 3: {
                this.multiframeCheckbox.setSelected(this.myDatasetIndex > -1);
                this.toolbarComponents.add(this.multiframeCheckbox);
            }
        }
        return this.toolbarComponents;
    }

    @Override
    public JButton getViewButton() {
        return this.columnsDialogButton;
    }

    @Override
    public boolean isCustomState() {
        if (!this.refreshed) {
            this.forceRefresh = true;
            this.refresh(this.frame.getTrackerPanelForID(this.panelID).getFrameNumber(), 4352);
        }
        if (!this.bsCheckBoxes.get(0) || !this.bsCheckBoxes.get(1) || this.bsCheckBoxes.cardinality() > 2) {
            return true;
        }
        if (this.myDatasetIndex > -1) {
            return true;
        }
        DataTable.DataTableColumnModel model = (DataTable.DataTableColumnModel)this.dataTable.getColumnModel();
        int count = model.getColumnCount();
        if (count == 0) {
            return false;
        }
        int i = 0;
        int prev = -1;
        while (i < count) {
            int mi = model.getTableColumn(i).getModelIndex();
            if (mi < prev) {
                return true;
            }
            prev = mi;
            ++i;
        }
        return false;
    }

    public void setVisible(int index, boolean visible) {
        this.bsCheckBoxes.set(index, visible);
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        this.refresh(trackerPanel.getFrameNumber(), 5888);
    }

    public void setVisible(String name, boolean visible) {
        Integer i = this.htNames.get(name);
        if (i == null) {
            return;
        }
        int index = i;
        if (index >= this.trackDataManager.getDatasetsRaw().size()) {
            ArrayList<String> names = this.getTrack().getTextColumnNames();
            int j = 0;
            while (j < names.size()) {
                String next = names.get(j);
                if (next.equals(name)) {
                    this.bsTextColumnsVisible.set(j, visible);
                    break;
                }
                ++j;
            }
        }
        this.setVisible(index, visible);
    }

    @Override
    protected void dispose() {
        this.trackDataManager = null;
        this.getTrack().removePropertyChangeListener("text_column", this);
        this.setViewportView(null);
        if (this.columnsDialog != null) {
            this.columnsDialog.setVisible(false);
            this.columnsDialog.dispose();
            this.columnsDialog = null;
        }
        this.dataTableManager.clear();
        this.dataTableManager = null;
        this.dataTable.dispose();
        this.dataTable = null;
        this.viewParent = null;
        super.dispose();
    }

    private void highlightRowForFrame(int frameNumber) {
        this.highlightRows.clear();
        if (!this.highlightVisible || this.dataTable.getRowCount() == 0) {
            return;
        }
        Dataset frames = this.trackDataManager.getFrameDataset();
        if (frames != null) {
            double[] vals = frames.getYPoints();
            int j = vals.length;
            while (--j >= 0) {
                if (!this.highlightFrames.get((int)vals[j])) continue;
                this.highlightRows.set(this.dataTable.getSortedRow(j));
            }
        }
        this.dataTable.clearSelection();
        if (this.highlightRows.isEmpty() || !this.isRefreshEnabled()) {
            return;
        }
        try {
            this.dataTable.selectTableRowsBS(this.highlightRows, 0);
            if (this.highlightRows.cardinality() == 1) {
                this.dataTable.scrollRowToVisible(this.highlightRows.nextSetBit(0));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int cols = this.dataTable.getColumnCount();
        this.dataTable.setColumnSelectionInterval(0, cols - 1);
    }

    private void highlightColumnForFrame(int highlightCol) {
        this.highlightRows.clear();
        if (highlightCol < 0) {
            return;
        }
        this.highlightRows.set(highlightCol);
        this.dataTable.clearSelection();
        if (this.highlightRows.isEmpty() || !this.isRefreshEnabled()) {
            return;
        }
        try {
            this.dataTable.selectTableColsBS(this.highlightRows);
            if (this.highlightRows.cardinality() == 1) {
                this.dataTable.scrollColumnToVisible(this.highlightRows.nextSetBit(0));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int rows = this.dataTable.getRowCount();
        this.dataTable.setRowSelectionInterval(0, rows - 1);
    }

    String[] getVisibleColumns() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, Integer> e : this.htNames.entrySet()) {
            if (!this.bsCheckBoxes.get(e.getValue())) continue;
            list.add(e.getKey());
        }
        return list.toArray(new String[list.size()]);
    }

    String[] getOrderedVisibleColumns() {
        DataTable.DataTableColumnModel model = (DataTable.DataTableColumnModel)this.dataTable.getColumnModel();
        Integer[] modelIndexes = new Integer[model.getColumnCount()];
        int i = 0;
        while (i < modelIndexes.length) {
            modelIndexes[i] = model.getTableColumn(i).getModelIndex();
            ++i;
        }
        String[] dependentVars = this.getVisibleColumns();
        String[] columnNames = new String[dependentVars.length + 1];
        TTrack track = this.getTrack();
        columnNames[0] = track.getDataName(0);
        System.arraycopy(dependentVars, 0, columnNames, 1, dependentVars.length);
        String[] ordered = new String[columnNames.length];
        if (columnNames.length == 1) {
            ordered[0] = columnNames[0];
        } else {
            int i2 = 0;
            while (i2 < ordered.length) {
                if (i2 < modelIndexes.length && modelIndexes[i2] < columnNames.length) {
                    ordered[i2] = columnNames[modelIndexes[i2]];
                }
                ++i2;
            }
        }
        return ordered;
    }

    String[][] getColumnFormats() {
        String[] colNames = this.dataTable.getFormattedColumnNames();
        String[][] colFormats = new String[colNames.length][2];
        int i = 0;
        while (i < colNames.length) {
            colFormats[i][0] = colNames[i];
            colFormats[i][1] = this.dataTable.getFormatPattern(colNames[i]);
            ++i;
        }
        return colFormats;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        TTrack track = this.getTrack();
        boolean refreshGapButton = false;
        switch (e.getPropertyName()) {
            case "loaded": 
            case "track": {
                if (this.columnsDialog == null) break;
                this.setDialogAsLastVisible(e.getNewValue() == track);
                break;
            }
            case "text_column": {
                String added = null;
                for (String name : track.getTextColumnNames()) {
                    if (this.textColumnNames.contains(name)) continue;
                    added = name;
                }
                String removed = null;
                for (String name : this.textColumnNames) {
                    if (track.getTextColumnNames().contains(name)) continue;
                    removed = name;
                }
                if (added == null && removed == null) {
                    return;
                }
                this.textColumnNames.clear();
                this.textColumnNames.addAll(track.getTextColumnNames());
                if (removed != null && added == null) {
                    this.setVisible(removed, false);
                }
                this.refreshNameMaps();
                if ((added == null || removed == null) && added != null) {
                    this.setVisible(added, true);
                }
                this.dataTable.refreshTable(16640);
                if (this.viewParent.getViewType() == 1) {
                    TableTView view = (TableTView)this.getParent();
                    view.refreshColumnsDialog(track, true);
                }
                this.buildForNewFunction();
                return;
            }
            case "units": {
                this.dataTable.getTableHeader().repaint();
                return;
            }
            case "step": 
            case "steps": {
                if (TTrack.HINT_STEP_ADDED_OR_REMOVED != e.getOldValue()) break;
                refreshGapButton = true;
            }
        }
        super.propertyChange(e);
        if (refreshGapButton) {
            this.refreshGapsButton();
        }
        if (this.columnsDialog != null && this.columnsDialog.isVisible()) {
            this.columnsDialog.refreshCheckboxes();
        }
    }

    public void snapshot() {
        BufferedImage image = new TrackerIO.ComponentImage(TViewChooser.getChooserParent(this)).getImage();
        int w = image.getWidth();
        int h = image.getHeight();
        if (w == 0 || h == 0) {
            return;
        }
        MeasuredImage mi = new MeasuredImage(image, 0.0, w, h, 0.0);
        OSPFrame frame = null;
        try {
            Class<?> type = Class.forName("org.opensourcephysics.frames.ImageFrame");
            Constructor<?>[] constructors = type.getConstructors();
            int i = 0;
            while (i < constructors.length) {
                Class<?>[] parameters = constructors[i].getParameterTypes();
                if (parameters.length == 1 && parameters[0] == MeasuredImage.class) {
                    frame = (OSPFrame)constructors[i].newInstance(mi);
                    break;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (frame == null) {
            return;
        }
        frame.setTitle(DisplayRes.getString("Snapshot.Title"));
        frame.setDefaultCloseOperation(2);
        frame.setKeepHidden(false);
        FontSizer.setFonts(frame, FontSizer.getLevel());
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.dataTable != null) {
            this.dataTable.setRowHeight(font.getSize() + 4);
            this.dataTable.getTableHeader().setFont(font);
        }
    }

    protected void setHorizontalScrolling(boolean horzScroll) {
        this.dataTable.setAutoResizeMode(horzScroll ? 0 : 2);
    }

    @Override
    public void setDatasetIndex(int index) {
        boolean refresh;
        if (this.myDatasetIndex == index) {
            return;
        }
        boolean bl = refresh = index == -1 || this.myDatasetIndex == -1;
        if (index == -1) {
            this.prevDatasetIndex = this.myDatasetIndex;
        }
        this.myDatasetIndex = index;
        if (refresh && this.columnsDialog != null) {
            this.columnsDialog.checkBoxes = null;
            this.columnsDialog.refreshCheckboxes();
            if (this.columnsDialog.isVisible()) {
                this.columnsDialog.pack();
                this.columnsDialog.repaint();
            }
        }
        this.showAllColumns(this.myDatasetIndex > -1);
        this.setHorizontalScrolling(this.myDatasetIndex > -1);
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        this.refresh(trackerPanel.getFrameNumber(), 4608);
        this.getDataTable().getTableHeader().repaint();
    }

    protected void showAllColumns(boolean all) {
        this.showAllColumns = all;
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        this.refresh(trackerPanel.getFrameNumber(), 4608);
    }

    protected int getFrameAtRow(int row) {
        double val = this.getIndepVarValueAtRow(row);
        TTrack track = this.getTrack();
        String xVar = track.datasetManager.getDataset(0).getXColumnName();
        int frameNum = track.getFrameForData(xVar, null, new double[]{val});
        return frameNum;
    }

    protected double getIndepVarValueAtRow(int row) {
        int col = this.dataTable.convertColumnIndexToView(0);
        Double val = null;
        try {
            val = (Double)this.dataTable.getValueAt(row, col);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val == null ? Double.NaN : val;
    }

    protected int getRowFromIndepVarValue(double indepVarValue) {
        int col = this.dataTable.convertColumnIndexToView(0);
        int i = 0;
        while (i < this.dataTable.getRowCount()) {
            if (indepVarValue == (Double)this.dataTable.getValueAt(i, col)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected double[] getSelectedIndepVarValues() {
        Double[] d = this.selectedIndepVarValues.toArray(new Double[0]);
        double[] vals = new double[d.length];
        int i = 0;
        while (i < d.length) {
            vals[i] = d[i];
            ++i;
        }
        return vals;
    }

    protected void setSelectedIndepVarValues(double[] vals) {
        if (this.dataTable.getRowCount() < 1) {
            return;
        }
        this.dataTable.removeRowSelectionInterval(0, this.dataTable.getRowCount() - 1);
        int i = 0;
        while (i < vals.length) {
            int row = this.getRowFromIndepVarValue(vals[i]);
            if (row > -1) {
                this.dataTable.addRowSelectionInterval(row, row);
            }
            ++i;
        }
    }

    protected void createGUI() {
        this.columnsDialogButton = new TButton(){

            @Override
            public Dimension getMaximumSize() {
                return TViewChooser.getButtonMaxSize(this, super.getMaximumSize(), this.getMinimumSize().height);
            }
        };
        this.columnsDialogButton.setIcon(TViewChooser.DOWN_ARROW_ICON);
        this.columnsDialogButton.setHorizontalTextPosition(10);
        this.columnsDialogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableTrackView.this.getOrCreateColumnsDialog(TableTrackView.this.getTrack()).showOrHideDialog();
            }
        });
        this.gapsButton = new TButton(){

            @Override
            public Dimension getMaximumSize() {
                return TViewChooser.getButtonMaxSize(this, super.getMaximumSize(), this.getMinimumSize().height);
            }

            @Override
            protected JPopupMenu getPopup() {
                JPopupMenu popup = new JPopupMenu();
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(TrackerRes.getString("TableTrackView.MenuItem.Gaps.GapsVisible"));
                item.setSelected(TableTrackView.this.gapsButton.isSelected());
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        (this).TableTrackView.this.gapsButton.setSelected(!(this).TableTrackView.this.gapsButton.isSelected());
                        (this).TableTrackView.this.dataTable.skippedFramesRenderer.setVisible((this).TableTrackView.this.gapsButton.isSelected());
                        if ((this).TableTrackView.this.gapsButton.isSelected()) {
                            (this).TableTrackView.this.dataTable.resetSort();
                        }
                        TableTrackView.this.refreshGapsButton();
                        (this).TableTrackView.this.dataTable.repaint();
                        (this).TableTrackView.this.dataTable.getTableHeader().resizeAndRepaint();
                        PointMass p = (PointMass)TableTrackView.this.getTrack();
                        p.showfilledSteps = (this).TableTrackView.this.gapsButton.isSelected();
                        p.repaint();
                    }
                });
                popup.add(item);
                if (Tracker.enableAutofill) {
                    item = new JCheckBoxMenuItem(TrackerRes.getString("TableTrackView.MenuItem.Gaps.AutoFill"));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PointMass p = (PointMass)TableTrackView.this.getTrack();
                            p.setAutoFill(!p.isAutofill);
                            p.repaint();
                        }
                    });
                    PointMass p = (PointMass)TableTrackView.this.getTrack();
                    item.setSelected(p.isAutofill);
                    popup.addSeparator();
                    popup.add(item);
                }
                FontSizer.setFonts(popup, FontSizer.getLevel());
                return popup;
            }
        };
        this.gapsButton.setSelected(Tracker.showGaps);
        this.multipleFramesButton = new TButton();
        this.multipleFramesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean multipleFrames = !TableTrackView.this.multipleFramesButton.isSelected();
                TableTrackView.this.multipleFramesButton.setSelected(multipleFrames);
                TableTrackView.this.setDatasetIndex(multipleFrames ? TableTrackView.this.prevDatasetIndex : -1);
                TableTrackView.this.multipleFramesButton.setText(multipleFrames ? TrackerRes.getString("TableTrackView.Button.SwitchTo.MultipleFrames") : TrackerRes.getString("TableTrackView.Button.SwitchTo.SingleFrame"));
            }
        });
        this.multiframeCheckbox = new JCheckBox();
        this.multiframeCheckbox.setOpaque(false);
        this.multiframeCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean multiframe = TableTrackView.this.multiframeCheckbox.isSelected();
                TableTrackView.this.setDatasetIndex(multiframe ? TableTrackView.this.prevDatasetIndex : -1);
            }
        });
        this.popup = new JPopupMenu();
        this.dataTable.setSelectionMode(2);
        this.dataTable.getTableHeader().setToolTipText(TrackerRes.getString("TableTrackView.Header.Tooltip"));
        this.dataTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TableTrackView.this.tableHeaderMousePressed(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 || OSPRuntime.isPopupTrigger(e)) {
                    return;
                }
                double[] vals = TableTrackView.this.getSelectedIndepVarValues();
                TableTrackView.this.setSelectedIndepVarValues(vals);
            }
        });
        this.dataTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TableTrackView.this.tableMousePressed(e);
            }
        });
        InputMap im = this.dataTable.getInputMap(1);
        KeyStroke k = KeyStroke.getKeyStroke(67, 128);
        AbstractAction newAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TTrack track = TableTrackView.this.getTrack();
                TrackerIO.copyTable(TableTrackView.this.dataTable, false, "\t" + track.getName());
            }
        };
        ActionMap am = this.dataTable.getActionMap();
        OSPRuntime.setOSPAction(im, k, "copy", am, newAction);
        k = KeyStroke.getKeyStroke(33, 0);
        newAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerPanel trackerPanel = TableTrackView.this.frame.getTrackerPanelForID(TableTrackView.this.panelID);
                if (!trackerPanel.getPlayer().isEnabled()) {
                    return;
                }
                trackerPanel.getPlayer().back();
            }
        };
        OSPRuntime.setOSPAction(im, k, "scrollUpChangeSelection", am, newAction);
        am.put(im.get(k), newAction);
        k = KeyStroke.getKeyStroke(33, 64);
        newAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerPanel trackerPanel = TableTrackView.this.frame.getTrackerPanelForID(TableTrackView.this.panelID);
                if (!trackerPanel.getPlayer().isEnabled()) {
                    return;
                }
                int n = trackerPanel.getPlayer().getStepNumber() - 5;
                trackerPanel.getPlayer().setStepNumber(n);
            }
        };
        OSPRuntime.setOSPAction(im, k, "scrollUpExtendSelection", am, newAction);
        k = KeyStroke.getKeyStroke(34, 0);
        newAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerPanel trackerPanel = TableTrackView.this.frame.getTrackerPanelForID(TableTrackView.this.panelID);
                if (!trackerPanel.getPlayer().isEnabled()) {
                    return;
                }
                trackerPanel.getPlayer().step();
            }
        };
        OSPRuntime.setOSPAction(im, k, "scrollDownChangeSelection", am, newAction);
        k = KeyStroke.getKeyStroke(34, 64);
        newAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerPanel trackerPanel = TableTrackView.this.frame.getTrackerPanelForID(TableTrackView.this.panelID);
                if (!trackerPanel.getPlayer().isEnabled()) {
                    return;
                }
                int n = trackerPanel.getPlayer().getStepNumber() + 5;
                trackerPanel.getPlayer().setStepNumber(n);
            }
        };
        OSPRuntime.setOSPAction(im, k, "scrollDownExtendSelection", am, newAction);
        k = KeyStroke.getKeyStroke(36, 0);
        newAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerPanel trackerPanel = TableTrackView.this.frame.getTrackerPanelForID(TableTrackView.this.panelID);
                if (!trackerPanel.getPlayer().isEnabled()) {
                    return;
                }
                trackerPanel.getPlayer().setStepNumber(0);
            }
        };
        OSPRuntime.setOSPAction(im, k, "selectFirstColumn", am, newAction);
        k = KeyStroke.getKeyStroke(35, 0);
        newAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerPanel trackerPanel = TableTrackView.this.frame.getTrackerPanelForID(TableTrackView.this.panelID);
                if (!trackerPanel.getPlayer().isEnabled()) {
                    return;
                }
                VideoClip clip = trackerPanel.getPlayer().getVideoClip();
                trackerPanel.getPlayer().setStepNumber(clip.getStepCount() - 1);
            }
        };
        OSPRuntime.setOSPAction(im, k, "selectLastColumn", am, newAction);
        FontSizer.setFont(this.columnsDialogButton);
    }

    public void dataToolAction() {
        int i;
        LineProfile lp;
        TTrack track = this.getTrack();
        DatasetManager toSend = new DatasetManager();
        toSend.setID(this.trackDataManager.getID());
        toSend.setName(track.getName());
        toSend.setXPointsLinked(true);
        int colCount = 0;
        ArrayList<Dataset> datasets = this.trackDataManager.getDatasetsRaw();
        Dataset next = datasets.get(0);
        XMLControlElement control = new XMLControlElement(next);
        next = toSend.getDataset(colCount++);
        control.loadObject(next, true, true);
        next.setYColumnVisible(false);
        next.setConnected(false);
        next.setMarkerShape(0);
        BitSet bs = this.bsCheckBoxes;
        int max = this.datasetCount;
        LineProfile lineProfile = lp = track.ttype == 3 ? (LineProfile)track : null;
        if (lp != null && lp.isMultipleFrames()) {
            bs = new BitSet();
            max = datasets.size();
            i = 0;
            while (i < max) {
                bs.set(i);
                ++i;
            }
        }
        i = bs.nextSetBit(0);
        while (i >= 0) {
            block5: {
                block4: {
                    block3: {
                        if (i < max) break block3;
                        next = track.convertTextToDataColumn(this.aNames[i]);
                        if (next != null) break block4;
                        break block5;
                    }
                    next = datasets.get(i);
                }
                control = new XMLControlElement(next);
                next = toSend.getDataset(colCount++);
                control.loadObject(next, true, true);
                next.setMarkerColor(track.getColor());
                next.setConnected(true);
                next.setXColumnVisible(false);
            }
            i = bs.nextSetBit(i + 1);
        }
        DataTool tool = DataTool.getTool(true);
        tool.setUseChooser(false);
        tool.setSaveChangesOnClose(false);
        DataRefreshTool refresher = DataRefreshTool.getTool(this.trackDataManager);
        tool.send(new LocalJob(toSend), refresher);
        tool.setVisible(true);
    }

    protected void tableMousePressed(MouseEvent e) {
        int row;
        String s;
        Dataset dataset;
        if (e.getClickCount() == 2) {
            this.dataTable.selectAll();
        }
        if (!OSPRuntime.isPopupTrigger(e)) {
            return;
        }
        this.getMenuItems();
        Point mousePt = e.getPoint();
        int col = this.dataTable.columnAtPoint(mousePt);
        this.deleteDataFunctionItem.setActionCommand("");
        String colName = this.dataTable.getColumnName(col);
        int index = this.trackDataManager.getDatasetIndex(colName);
        if (index > -1 && (dataset = this.trackDataManager.getDataset(index)) instanceof DataFunction) {
            this.deleteDataFunctionItem.setActionCommand(String.valueOf(index));
            s = TrackerRes.getString("TableTrackView.MenuItem.DeleteDataFunction");
            this.deleteDataFunctionItem.setText(String.valueOf(s) + " \"" + colName + "\"");
        }
        this.goToFrameItem.setEnabled((row = this.dataTable.rowAtPoint(mousePt)) > -1);
        if (this.goToFrameItem.isEnabled()) {
            this.goToFrameItem.setActionCommand(String.valueOf(row));
            s = TrackerRes.getString("TableTrackView.Popup.Menuitem.GoToStep");
            int frameNum = this.getFrameAtRow(row);
            VideoClip clip = this.frame.getTrackerPanelForID(this.panelID).getPlayer().getVideoClip();
            int stepNum = clip.frameToStep(frameNum);
            s = String.valueOf(s) + " " + stepNum;
            this.goToFrameItem.setText(s);
        }
        this.getPopup().show(this.dataTable, e.getX() + 4, e.getY());
    }

    protected void tableHeaderMousePressed(MouseEvent e) {
        int col = this.dataTable.columnAtPoint(e.getPoint());
        if (OSPRuntime.isPopupTrigger(e)) {
            Dataset dataset;
            this.getMenuItems();
            if (this.dataTable.getRowCount() > 0 && this.dataTable.getSelectedRowCount() == 0) {
                this.dataTable.setColumnSelectionInterval(col, col);
                this.dataTable.setRowSelectionInterval(0, this.dataTable.getRowCount() - 1);
            }
            this.deleteDataFunctionItem.setActionCommand("");
            String colName = this.dataTable.getColumnName(col);
            int index = this.trackDataManager.getDatasetIndex(colName);
            if (index > -1 && (dataset = this.trackDataManager.getDataset(index)) instanceof DataFunction) {
                this.deleteDataFunctionItem.setActionCommand(String.valueOf(index));
                String s = TrackerRes.getString("TableTrackView.MenuItem.DeleteDataFunction");
                this.deleteDataFunctionItem.setText(String.valueOf(s) + " \"" + colName + "\"");
            }
            this.goToFrameItem.setEnabled(false);
            this.getPopup().show(this.dataTable.getTableHeader(), e.getX(), e.getY() + 8);
        } else if (e.getClickCount() == 2) {
            this.dataTable.setRowSelectionInterval(0, this.dataTable.getRowCount() - 1);
            this.dataTable.setColumnSelectionInterval(col, col);
            this.leadCol = col;
            this.dataTable.sort(0);
        } else if (e.isControlDown()) {
            if (this.dataTable.isColumnSelected(col)) {
                this.dataTable.removeColumnSelectionInterval(col, col);
            } else {
                this.dataTable.addColumnSelectionInterval(col, col);
                if (this.dataTable.getSelectedColumns().length == 1) {
                    this.leadCol = col;
                }
            }
        } else if (e.isShiftDown() && this.dataTable.getSelectedRows().length > 0 && this.leadCol < this.dataTable.getColumnCount()) {
            this.dataTable.setColumnSelectionInterval(col, this.leadCol);
        }
    }

    private void getMenuItems() {
        if (this.haveMenuItems) {
            return;
        }
        this.haveMenuItems = true;
        this.deleteDataFunctionItem = new JMenuItem();
        this.deleteDataFunctionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = Integer.parseInt(e.getActionCommand());
                TTrack track = TableTrackView.this.getTrack();
                TrackerPanel trackerPanel = TableTrackView.this.frame.getTrackerPanelForID(TableTrackView.this.panelID);
                FunctionTool tool = trackerPanel.getDataBuilder();
                FunctionPanel panel = tool.getPanel(track.getName());
                Dataset dataset = TableTrackView.this.trackDataManager.getDataset(index);
                if (dataset instanceof DataFunction) {
                    panel.getFunctionEditor().removeObject((DataFunction)dataset, true);
                }
            }
        });
        this.goToFrameItem = new JMenuItem();
        this.goToFrameItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int row = Integer.parseInt(e.getActionCommand());
                    int frameNum = TableTrackView.this.getFrameAtRow(row);
                    if (frameNum > -1) {
                        TrackerPanel trackerPanel = TableTrackView.this.frame.getTrackerPanelForID(TableTrackView.this.panelID);
                        VideoClip clip = trackerPanel.getPlayer().getVideoClip();
                        int stepNum = clip.frameToStep(frameNum);
                        trackerPanel.getPlayer().setStepNumber(stepNum);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.numberMenu = new JMenu();
        this.formatDialogItem = new JMenuItem();
        this.formatDialogItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = TableTrackView.this.dataTable.getSelectedColumns();
                String[] selectedNames = new String[selected.length];
                int i = 0;
                while (i < selectedNames.length) {
                    String name;
                    selectedNames[i] = name = TableTrackView.this.dataTable.getColumnName(selected[i]);
                    ++i;
                }
                TrackerPanel trackerPanel = TableTrackView.this.frame.getTrackerPanelForID(TableTrackView.this.panelID);
                NumberFormatDialog.getNumberFormatDialog(trackerPanel, TableTrackView.this.getTrack(), selectedNames).setVisible(true);
            }
        });
        this.showUnitsItem = new JMenuItem();
        this.showUnitsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerPanel trackerPanel;
                trackerPanel.setUnitsVisible(!(trackerPanel = TableTrackView.this.frame.getTrackerPanelForID(TableTrackView.this.panelID)).isUnitsVisible());
            }
        });
        this.setUnitsItem = new JMenuItem();
        this.setUnitsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerPanel trackerPanel = TableTrackView.this.frame.getTrackerPanelForID(TableTrackView.this.panelID);
                UnitsDialog dialog = trackerPanel.getUnitsDialog();
                dialog.setVisible(true);
            }
        });
        this.copyDataMenu = new JMenu();
        this.copyDataRawItem = new JMenuItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TTrack track = TableTrackView.this.getTrack();
                TrackerIO.copyTable(TableTrackView.this.dataTable, false, "\t" + track.getName());
            }
        });
        this.copyDataFormattedItem = new JMenuItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TTrack track = TableTrackView.this.getTrack();
                TrackerIO.copyTable(TableTrackView.this.dataTable, true, "\t" + track.getName());
            }
        });
        final AbstractAction setDelimiterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerIO.setDelimiter(e.getActionCommand());
                TableTrackView.this.refreshGUI();
            }
        };
        this.setDelimiterMenu = new JMenu(setDelimiterAction);
        TFrame.addMenuListener(this.setDelimiterMenu, new Runnable(){

            @Override
            public void run() {
                TableTrackView.this.setupDelimiterMenu(setDelimiterAction);
            }
        });
        this.includeHeadersItem = new JCheckBoxMenuItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableTrackView.this.dataTable.includeHeadersInCopiedData = TableTrackView.this.includeHeadersItem.isSelected();
            }
        });
        this.includeHeadersItem.setSelected(this.dataTable.includeHeadersInCopiedData);
        AbstractAction copyImageAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TViewChooser chooser = TableTrackView.this.getOwner();
                if (chooser != null) {
                    new TrackerIO.ComponentImage(chooser).copyToClipboard();
                }
            }
        };
        this.copyImageItem = new JMenuItem(copyImageAction);
        AbstractAction snapshotAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableTrackView.this.snapshot();
            }
        };
        this.snapshotItem = new JMenuItem(snapshotAction);
        this.createTextColumnItem = new JMenuItem();
        this.createTextColumnItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = TableTrackView.this.getUniqueColumnName(null, false);
                TTrack track = TableTrackView.this.getTrack();
                track.addTextColumn(name);
                TableTrackView.this.dataTable.refreshTable(16640);
                if (TableTrackView.this.viewParent.getViewType() == 1) {
                    ((TableTView)TableTrackView.this.viewParent).refreshColumnsDialog(track, true);
                }
            }
        });
        this.textColumnMenu = new JMenu();
        this.deleteTextColumnMenu = new JMenu();
        this.renameTextColumnMenu = new JMenu();
        this.dataBuilderItem = new JMenuItem();
        this.dataBuilderItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TTrack track = TableTrackView.this.getTrack();
                TrackerPanel trackerPanel = TableTrackView.this.frame.getTrackerPanelForID(TableTrackView.this.panelID);
                trackerPanel.getDataBuilder().setSelectedPanel(track.getName());
                trackerPanel.getDataBuilder().setVisible(true);
            }
        });
        this.dataToolItem = new JMenuItem();
        this.dataToolItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableTrackView.this.dataToolAction();
            }
        });
        this.printItem = new JMenuItem();
        this.printItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TViewChooser chooser = TableTrackView.this.getOwner();
                if (chooser != null) {
                    new TrackerIO.ComponentImage(chooser).print();
                }
            }
        });
        this.helpItem = new JMenuItem();
        this.helpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TableTrackView.this.frame != null) {
                    TableTrackView.this.frame.showHelp("datatable", 0);
                }
            }
        });
    }

    protected void setupDelimiterMenu(Action setDelimiterAction) {
        boolean hasCustom;
        JMenuItem item;
        ButtonGroup delimiterButtonGroup = new ButtonGroup();
        for (String key : TrackerIO.getDelimiters().keySet()) {
            String delimiter = TrackerIO.getDelimiters().get(key);
            JRadioButtonMenuItem item2 = new JRadioButtonMenuItem(key);
            item2.setActionCommand(delimiter);
            item2.addActionListener(setDelimiterAction);
            delimiterButtonGroup.add(item2);
        }
        AbstractAction addDelimiterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String delimiter = TrackerIO.getDelimiter();
                String response = GUIUtils.showInputDialog(TableTrackView.this, TrackerRes.getString("TableTrackView.Dialog.CustomDelimiter.Message"), TrackerRes.getString("TableTrackView.Dialog.CustomDelimiter.Title"), -1, delimiter);
                if (response != null) {
                    String s = response;
                    TrackerIO.setDelimiter(s);
                    TrackerIO.addCustomDelimiter(s);
                    TableTrackView.this.refreshGUI();
                }
            }
        };
        JMenuItem addDelimiterItem = new JMenuItem(addDelimiterAction);
        AbstractAction removeDelimiterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] choices = TrackerIO.customDelimiters.values().toArray(new String[1]);
                new AsyncDialog().showInputDialog(TableTrackView.this, TrackerRes.getString("TableTrackView.Dialog.RemoveDelimiter.Message"), TrackerRes.getString("TableTrackView.Dialog.RemoveDelimiter.Title"), -1, null, choices, null, ee -> {
                    String response = ee.getActionCommand();
                    if (response != null) {
                        String s = response.toString();
                        TrackerIO.removeCustomDelimiter(s);
                        TableTrackView.this.refreshGUI();
                    }
                });
            }
        };
        JMenuItem removeDelimiterItem = new JMenuItem(removeDelimiterAction);
        addDelimiterItem.setText(TrackerRes.getString("TableTrackView.MenuItem.AddDelimiter"));
        removeDelimiterItem.setText(TrackerRes.getString("TableTrackView.MenuItem.RemoveDelimiter"));
        this.setDelimiterMenu.removeAll();
        String delimiter = TrackerIO.getDelimiter();
        Enumeration<AbstractButton> en = delimiterButtonGroup.getElements();
        while (en.hasMoreElements()) {
            item = (JMenuItem)en.nextElement();
            String delim = item.getActionCommand();
            if (TrackerIO.getDelimiters().containsValue(delim)) continue;
            delimiterButtonGroup.remove(item);
        }
        en = delimiterButtonGroup.getElements();
        while (en.hasMoreElements()) {
            item = (JMenuItem)en.nextElement();
            this.setDelimiterMenu.add(item);
            if (!delimiter.equals(item.getActionCommand())) continue;
            item.setSelected(true);
        }
        boolean bl = hasCustom = !TrackerIO.customDelimiters.isEmpty();
        if (hasCustom) {
            this.setDelimiterMenu.addSeparator();
            for (String key : TrackerIO.customDelimiters.keySet()) {
                JRadioButtonMenuItem item3 = new JRadioButtonMenuItem(key);
                item3.setActionCommand((String)TrackerIO.customDelimiters.get(key));
                item3.addActionListener(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TrackerIO.setDelimiter(e.getActionCommand());
                    }
                });
                delimiterButtonGroup.add(item3);
                this.setDelimiterMenu.add(item3);
                if (!delimiter.equals(item3.getActionCommand())) continue;
                item3.setSelected(true);
            }
        }
        this.setDelimiterMenu.addSeparator();
        this.setDelimiterMenu.add(addDelimiterItem);
        if (hasCustom) {
            this.setDelimiterMenu.add(removeDelimiterItem);
        }
    }

    protected JPopupMenu getPopup() {
        this.getMenuItems();
        this.numberMenu.setText(TrackerRes.getString("Popup.Menu.Numbers"));
        this.formatDialogItem.setText(String.valueOf(TrackerRes.getString("Popup.MenuItem.Formats")) + "...");
        this.setUnitsItem.setText(String.valueOf(TrackerRes.getString("Popup.MenuItem.Units")) + "...");
        this.copyImageItem.setText(TrackerRes.getString("TMenuBar.Menu.CopyImage"));
        this.snapshotItem.setText(DisplayRes.getString("DisplayPanel.Snapshot_menu_item"));
        this.printItem.setText(TrackerRes.getString("TActions.Action.Print"));
        this.helpItem.setText(TrackerRes.getString("Tracker.Popup.MenuItem.Help"));
        this.createTextColumnItem.setText(TrackerRes.getString("TableTrackView.Action.CreateTextColumn.Text"));
        this.textColumnMenu.setText(TrackerRes.getString("TableTrackView.Menu.TextColumn.Text"));
        this.deleteTextColumnMenu.setText(TrackerRes.getString("TableTrackView.Action.DeleteTextColumn.Text"));
        this.renameTextColumnMenu.setText(TrackerRes.getString("TableTrackView.Action.RenameTextColumn.Text"));
        this.dataBuilderItem.setText(TrackerRes.getString("TView.Menuitem.Define"));
        this.dataToolItem.setText(TrackerRes.getString("TableTrackView.Popup.MenuItem.Analyze"));
        this.refreshCopyDataMenu(this.copyDataMenu);
        this.popup.removeAll();
        if (this.goToFrameItem.isEnabled()) {
            this.popup.add(this.goToFrameItem);
        }
        TTrack track = this.getTrack();
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        if (track == null) {
            if (trackerPanel.isEnabled("number.formats") || trackerPanel.isEnabled("number.units")) {
                if (this.popup.getComponentCount() > 0) {
                    this.popup.addSeparator();
                }
                this.popup.add(this.numberMenu);
                this.numberMenu.removeAll();
                if (trackerPanel.isEnabled("number.formats")) {
                    this.numberMenu.add(this.formatDialogItem);
                }
                if (trackerPanel.isEnabled("number.units")) {
                    this.numberMenu.add(this.setUnitsItem);
                }
            }
            return this.popup;
        }
        if (track.tp != null && track.tp.isEnabled("edit.copyData")) {
            if (this.popup.getComponentCount() > 0) {
                this.popup.addSeparator();
            }
            this.popup.add(this.copyDataMenu);
        }
        if (trackerPanel.isEnabled("number.formats") || trackerPanel.isEnabled("number.units") && track.tp != null) {
            if (this.popup.getComponentCount() > 0) {
                this.popup.addSeparator();
            }
            this.popup.add(this.numberMenu);
            this.numberMenu.removeAll();
            if (trackerPanel.isEnabled("number.formats")) {
                this.numberMenu.add(this.formatDialogItem);
            }
            if (trackerPanel.isEnabled("number.units")) {
                this.numberMenu.add(this.setUnitsItem);
            }
        }
        if (trackerPanel.isEnabled("text.columns")) {
            this.textColumnMenu.removeAll();
            this.deleteTextColumnMenu.removeAll();
            this.renameTextColumnMenu.removeAll();
            if (this.popup.getComponentCount() > 0) {
                this.popup.addSeparator();
            }
            this.popup.add(this.textColumnMenu);
            this.textColumnMenu.add(this.createTextColumnItem);
            if (track.getTextColumnNames().size() > 0) {
                JMenuItem item;
                this.textColumnMenu.add(this.deleteTextColumnMenu);
                for (String next : track.getTextColumnNames()) {
                    item = new JMenuItem(next);
                    this.deleteTextColumnMenu.add(item);
                    item.setActionCommand(next);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TTrack track = TableTrackView.this.getTrack();
                            track.removeTextColumn(e.getActionCommand());
                        }
                    });
                }
                this.textColumnMenu.add(this.renameTextColumnMenu);
                for (String next : track.getTextColumnNames()) {
                    item = new JMenuItem(next);
                    this.renameTextColumnMenu.add(item);
                    item.setActionCommand(next);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String prev = e.getActionCommand();
                            String name = TableTrackView.this.getUniqueColumnName(prev, false);
                            if (name != null && !name.equals("") && !name.equals(prev)) {
                                TTrack track = TableTrackView.this.getTrack();
                                track.renameTextColumn(prev, name);
                            }
                        }
                    });
                }
            }
        }
        this.textColumnMenu.setEnabled(!track.isLocked());
        if (!"".equals(this.deleteDataFunctionItem.getActionCommand())) {
            this.popup.addSeparator();
            this.popup.add(this.deleteDataFunctionItem);
        }
        if (track.tp != null && track.tp.isEnabled("edit.copyImage")) {
            this.popup.addSeparator();
            this.popup.add(this.copyImageItem);
            this.popup.add(this.snapshotItem);
        }
        if (track.tp != null && (track.tp.isEnabled("data.builder") || track.tp.isEnabled("data.tool"))) {
            this.popup.addSeparator();
            if (track.tp.isEnabled("data.builder")) {
                this.popup.add(this.dataBuilderItem);
            }
            if (track.tp.isEnabled("data.tool")) {
                this.popup.add(this.dataToolItem);
            }
        }
        if (track.tp != null && track.tp.isEnabled("file.print")) {
            this.popup.addSeparator();
            this.popup.add(this.printItem);
        }
        if (this.popup.getComponentCount() > 0) {
            this.popup.addSeparator();
        }
        this.popup.add(this.helpItem);
        FontSizer.setFonts(this.popup, FontSizer.getLevel());
        return this.popup;
    }

    protected String getUniqueColumnName(String previous, boolean tryAgain) {
        if (previous == null) {
            previous = "";
        }
        String input = null;
        TTrack track = this.getTrack();
        input = tryAgain ? GUIUtils.showInputDialog(this.frame, String.valueOf(TrackerRes.getString("TableTrackView.Dialog.NameColumn.TryAgain")) + "\n" + TrackerRes.getString("TableTrackView.Dialog.NameColumn.Message"), TrackerRes.getString("TableTrackView.Dialog.NameColumn.Title"), 2, previous) : GUIUtils.showInputDialog(this.frame, TrackerRes.getString("TableTrackView.Dialog.NameColumn.Message"), TrackerRes.getString("TableTrackView.Dialog.NameColumn.Title"), 3, previous);
        if (input == null) {
            return null;
        }
        String name = input.trim();
        if (name.equals(previous)) {
            return name;
        }
        boolean unique = true;
        String[] stringArray = this.getDataColumnNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            if (next.equals(name)) {
                unique = false;
                break;
            }
            ++n2;
        }
        if (unique) {
            for (String next : track.getTextColumnNames()) {
                if (!next.equals(name)) continue;
                unique = false;
                break;
            }
        }
        if (!unique) {
            return this.getUniqueColumnName(previous, true);
        }
        return name;
    }

    protected JMenu refreshCopyDataMenu(JMenu menu) {
        this.getMenuItems();
        menu.removeAll();
        menu.add(this.copyDataRawItem);
        menu.add(this.copyDataFormattedItem);
        menu.addSeparator();
        menu.add(this.setDelimiterMenu);
        menu.add(this.includeHeadersItem);
        if (this.dataTable.getSelectedRowCount() == 0) {
            menu.setText(TrackerRes.getString("TableTrackView.Action.CopyData"));
        } else {
            menu.setText(TrackerRes.getString("TableTrackView.MenuItem.CopySelectedData"));
        }
        this.copyDataRawItem.setText(TrackerRes.getString("TableTrackView.MenuItem.Unformatted"));
        this.copyDataFormattedItem.setText(TrackerRes.getString("TableTrackView.MenuItem.Formatted"));
        this.setDelimiterMenu.setText(TrackerRes.getString("TableTrackView.Menu.SetDelimiter"));
        this.includeHeadersItem.setText(TrackerRes.getString("TableTrackView.MenuItem.IncludeHeaders"));
        return menu;
    }

    protected void refreshToolbarPopup(JPopupMenu popup) {
    }

    protected String[] getDataColumnNames() {
        ArrayList<String> names = new ArrayList<String>();
        Dataset dataset = this.trackDataManager.getDataset(0);
        String name = dataset.getXColumnName();
        names.add(name);
        TTrack track = this.getTrack();
        ArrayList<Integer> dataOrder = track.getPreferredDataOrder();
        BitSet added = new BitSet();
        int i = 0;
        while (i < dataOrder.size()) {
            int oi = dataOrder.get(i);
            dataset = this.trackDataManager.getDataset(oi);
            name = dataset.getYColumnName();
            names.add(name);
            added.set(oi);
            ++i;
        }
        i = 0;
        while (i < this.trackDataManager.getDatasetsRaw().size()) {
            if (!added.get(i)) {
                dataset = this.trackDataManager.getDataset(i);
                name = dataset.getYColumnName();
                names.add(name);
            }
            ++i;
        }
        return names.toArray(new String[0]);
    }

    public void refreshToolbar() {
        TViewChooser owner;
        if (OSPRuntime.isJS) {
            return;
        }
        if (this.frame != null && (owner = this.getOwner()) != null) {
            owner.refreshToolbar();
        }
    }

    public void addColumnItems(JPopupMenu popup) {
        this.getPopup();
        popup.add(this.createTextColumnItem);
        if (this.deleteTextColumnMenu.getItemCount() > 0) {
            popup.add(this.deleteTextColumnMenu);
            popup.add(this.renameTextColumnMenu);
        }
    }

    private ColumnsDialog getOrCreateColumnsDialog(TTrack track) {
        if (this.frame != null) {
            if (this.columnsDialog == null) {
                this.columnsDialog = new ColumnsDialog(this.frame, track);
            } else if (this.columnsDialog.track != track) {
                this.columnsDialog.rebuild(track);
            } else {
                this.columnsDialog.refreshButtonPanel();
            }
        }
        return this.columnsDialog;
    }

    public void refreshColumnDialog(TTrack track, boolean onlyIfVisible) {
        if (track == null) {
            if (this.columnsDialog != null) {
                this.columnsDialog.getContentPane().removeAll();
                this.columnsDialog.setVisible(false);
            }
            return;
        }
        if (onlyIfVisible && this.columnsDialog == null || !this.columnsDialog.isVisible()) {
            return;
        }
        this.getOrCreateColumnsDialog(track);
    }

    public void setDialogAsLastVisible(boolean vis) {
        if (this.columnsDialog != null) {
            if (vis && this.dialogLastVisible) {
                this.columnsDialog.setVisible(true);
            } else {
                vis = this.columnsDialog.isVisible();
                if (vis) {
                    boolean b = this.dialogLastVisible;
                    this.columnsDialog.setVisible(false);
                    this.dialogLastVisible = b;
                }
            }
        }
    }

    public void buildForNewFunction() {
        if (this.columnsDialog != null) {
            this.columnsDialog.refreshCheckboxes();
            this.columnsDialog.setPortPosition();
            this.columnsDialog.revalidate();
            this.columnsDialog.repaint();
        }
    }

    @Override
    protected boolean isRefreshEnabled() {
        return super.isRefreshEnabled() && Tracker.allowTableRefresh;
    }

    @Override
    public void finalize() {
        OSPLog.finalized(this);
    }

    private class ColumnsDialog
    extends JDialog {
        private JScrollPane columnsScroller;
        private JToggleButton[] checkBoxes;
        private JPanel columnsPanel;
        private JLabel trackLabel;
        private JButton defineButton;
        private JButton closeButton;
        private JButton textColumnButton;
        private JPanel buttonPanel;
        private TTrack track;
        private boolean isPositioned;
        private ActionListener cbActionListener;
        private boolean haveGUI;
        private ComponentListener myFollower;

        @Override
        public void setVisible(boolean vis) {
            if (vis) {
                this.refreshCheckboxes();
                this.pack();
            } else {
                TableTrackView.this.dialogLastVisible = false;
            }
            super.setVisible(vis);
        }

        private ColumnsDialog(TFrame frame, TTrack track) {
            super((Frame)frame, false);
            this.cbActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColumnsDialog.this.doCheckBoxAction(Integer.parseInt(((JToggleButton)e.getSource()).getActionCommand()));
                }
            };
            this.track = track;
            this.rebuild(track);
        }

        private void doCheckBoxAction(int i) {
            if (this.checkBoxes[i] instanceof JRadioButton) {
                this.checkBoxes[i].setSelected(true);
                if (TableTrackView.this.myDatasetIndex > -1 && TableTrackView.this.myDatasetIndex != i) {
                    this.checkBoxes[TableTrackView.this.myDatasetIndex].setSelected(false);
                }
                TableTrackView.this.myDatasetIndex = i;
            } else {
                boolean add = this.checkBoxes[i].isSelected();
                String name = this.checkBoxes[i].getText();
                TableTrackView.this.bsCheckBoxes.set(i, add);
                ArrayList<String> names = TableTrackView.this.getTrack().getTextColumnNames();
                int j = 0;
                while (j < names.size()) {
                    String next = names.get(j);
                    if (next.equals(name)) {
                        TableTrackView.this.bsTextColumnsVisible.set(j, add);
                        break;
                    }
                    ++j;
                }
            }
            TrackerPanel trackerPanel = TableTrackView.this.frame.getTrackerPanelForID(TableTrackView.this.panelID);
            trackerPanel.changed = true;
            if (TableTrackView.this.refreshing) {
                TableTrackView.this.refresh(trackerPanel.getFrameNumber(), 4608);
            }
            if (TableTrackView.this.myDatasetIndex > -1) {
                TableTrackView.this.getDataTable().getTableHeader().repaint();
            }
        }

        private void createGUI() {
            this.myFollower = ((TFrame)this.getOwner()).addFollower(this, null);
            this.haveGUI = true;
            this.columnsPanel = new JPanel();
            this.columnsPanel.setBackground(Color.WHITE);
            this.columnsPanel.setLayout(new GridLayout(0, 4));
            this.columnsScroller = new JScrollPane(this.columnsPanel);
            Border empty = BorderFactory.createEmptyBorder(0, 3, 0, 2);
            Border etched = BorderFactory.createEtchedBorder();
            this.columnsScroller.setBorder(BorderFactory.createCompoundBorder(empty, etched));
            JPanel contentPane = new JPanel(new BorderLayout());
            this.setContentPane(contentPane);
            this.closeButton = new JButton(TrackerRes.getString("Dialog.Button.Close"));
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColumnsDialog.this.setVisible(false);
                }
            });
            this.defineButton = new JButton(TrackerRes.getString("TView.Menuitem.Define"));
            this.defineButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ColumnsDialog.this.track != null) {
                        TrackerPanel trackerPanel = ((ColumnsDialog)ColumnsDialog.this).TableTrackView.this.frame.getTrackerPanelForID(((ColumnsDialog)ColumnsDialog.this).TableTrackView.this.panelID);
                        trackerPanel.getDataBuilder().setSelectedPanel(ColumnsDialog.this.track.getName());
                        trackerPanel.getDataBuilder().setVisible(true);
                    }
                }
            });
            this.defineButton.setToolTipText(TrackerRes.getString("Button.Define.Tooltip"));
            this.textColumnButton = new JButton(TrackerRes.getString("TableTrackView.Menu.TextColumn.Text"));
            this.textColumnButton.setToolTipText(TrackerRes.getString("TableTrackView.Menu.TextColumn.Tooltip"));
            this.textColumnButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JPopupMenu popup = new JPopupMenu();
                    TableTrackView.this.addColumnItems(popup);
                    FontSizer.setFonts(popup, FontSizer.getLevel());
                    popup.show(ColumnsDialog.this.textColumnButton, 0, ColumnsDialog.this.textColumnButton.getHeight());
                }
            });
            this.buttonPanel = new JPanel();
            this.trackLabel = new JLabel();
            this.trackLabel.setBorder(BorderFactory.createEmptyBorder(7, 0, 7, 0));
            this.trackLabel.setHorizontalAlignment(0);
        }

        private void refreshButtonPanel() {
            this.buttonPanel.removeAll();
            TrackerPanel trackerPanel = TableTrackView.this.frame.getTrackerPanelForID(TableTrackView.this.panelID);
            if (TableTrackView.this.myDatasetIndex < 0 && trackerPanel.isEnabled("data.builder")) {
                this.buttonPanel.add(this.defineButton);
            }
            if (TableTrackView.this.myDatasetIndex < 0 && trackerPanel.isEnabled("text.columns")) {
                this.buttonPanel.add(this.textColumnButton);
            }
            this.buttonPanel.add(this.closeButton);
        }

        private void refreshGUI() {
            if (!this.haveGUI) {
                return;
            }
            FontSizer.setFonts(this.buttonPanel);
            FontSizer.setFonts(this.columnsPanel);
            FontSizer.setFonts(this.trackLabel);
            this.closeButton.setText(TrackerRes.getString("Dialog.Button.Close"));
            this.defineButton.setText(TrackerRes.getString("TView.Menuitem.Define"));
            this.defineButton.setToolTipText(TrackerRes.getString("Button.Define.Tooltip"));
            this.setTitle(TrackerRes.getString("TableTView.Dialog.TableColumns.Title"));
            this.textColumnButton.setText(TrackerRes.getString("TableTrackView.Menu.TextColumn.Text"));
            this.textColumnButton.setToolTipText(TrackerRes.getString("TableTrackView.Menu.TextColumn.Tooltip"));
        }

        private void refreshCheckboxes() {
            if (!this.haveGUI) {
                this.createGUI();
            }
            this.refreshButtonPanel();
            int boxCount = this.getCheckBoxCount();
            if (this.checkBoxes == null || boxCount > this.checkBoxes.length) {
                this.checkBoxes = new JToggleButton[boxCount];
            }
            int i = 0;
            while (i < boxCount) {
                String name;
                String string = i < TableTrackView.this.aNames.length ? TableTrackView.this.aNames[i] : (name = i < TableTrackView.this.datasetCount ? TableTrackView.this.trackDataManager.getDataset(i).getYColumnName() : TableTrackView.this.textColumnNames.get(i - TableTrackView.this.datasetCount));
                if (this.checkBoxes[i] == null) {
                    this.checkBoxes[i] = TableTrackView.this.myDatasetIndex > -1 ? new JRadioButton() : new JCheckBox();
                    this.checkBoxes[i].setBackground(Color.white);
                    this.checkBoxes[i].setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 0));
                    this.checkBoxes[i].setActionCommand("" + i);
                    this.checkBoxes[i].setToolTipText(this.track.getDataDescription(i + 1));
                    this.checkBoxes[i].addActionListener(this.cbActionListener);
                    this.checkBoxes[i].setOpaque(false);
                    this.checkBoxes[i].setFont(TableTrackView.this.font);
                }
                this.checkBoxes[i].setSelected(TableTrackView.this.myDatasetIndex > -1 ? i == TableTrackView.this.myDatasetIndex : TableTrackView.this.bsCheckBoxes.get(i));
                this.checkBoxes[i].setName(name);
                this.checkBoxes[i].setText(TeXParser.removeSubscripting(name));
                ++i;
            }
            this.columnsPanel.removeAll();
            ArrayList<Integer> dataOrder = this.track.getPreferredDataOrder();
            BitSet bsMissed = new BitSet();
            bsMissed.set(0, boxCount);
            int i2 = 0;
            int n = dataOrder.size();
            while (i2 < n) {
                int pt = dataOrder.get(i2);
                if (pt < this.checkBoxes.length) {
                    this.columnsPanel.add(this.checkBoxes[pt]);
                }
                bsMissed.clear(pt);
                ++i2;
            }
            i2 = bsMissed.nextSetBit(0);
            while (i2 >= 0) {
                if (i2 < this.checkBoxes.length) {
                    this.columnsPanel.add(this.checkBoxes[i2]);
                }
                i2 = bsMissed.nextSetBit(i2 + 1);
            }
            this.refreshGUI();
        }

        private void setPortPosition() {
            JViewport port = this.columnsScroller.getViewport();
            Dimension dim = port.getViewSize();
            int offset = port.getExtentSize().height;
            port.setViewPosition(new Point(0, dim.height - offset));
        }

        private void rebuild(TTrack track) {
            FontSizer.setFonts(this);
            this.track = track;
            this.setResizable(true);
            this.getContentPane().removeAll();
            this.refreshCheckboxes();
            this.trackLabel.setIcon(track.getFootprint().getIcon(21, 16));
            this.trackLabel.setText(track.getName());
            this.textColumnButton.setEnabled(!track.isLocked());
            this.add((Component)this.trackLabel, "North");
            this.add((Component)this.columnsScroller, "Center");
            this.add((Component)this.buttonPanel, "South");
            this.pack();
        }

        protected void showOrHideDialog() {
            boolean vis;
            boolean bl = vis = !this.isVisible();
            if (!this.isPositioned) {
                this.isPositioned = true;
                Point p = TableTrackView.this.columnsDialogButton.getLocationOnScreen();
                int w = this.getWidth();
                this.setLocation(p.x - w, p.y);
                if (vis) {
                    TableTrackView.this.refresh(TableTrackView.this.frame.getTrackerPanelForID(TableTrackView.this.panelID).getFrameNumber(), 4608);
                }
            }
            TableTrackView.this.dialogLastVisible = vis;
            this.setVisible(vis);
        }

        private int getCheckBoxCount() {
            return TableTrackView.this.myDatasetIndex > -1 ? TableTrackView.this.varCount : TableTrackView.this.colCount;
        }

        @Override
        public void dispose() {
            this.columnsPanel.removeAll();
            ((TFrame)this.getOwner()).removeComponentListener(this.myFollower);
            this.myFollower = null;
        }
    }

    public class HeaderUnitsRenderer
    extends DataTable.HeaderRenderer {
        public HeaderUnitsRenderer(DataTable table, TableCellRenderer renderer) {
            DataTable dataTable = table;
            dataTable.getClass();
            super(dataTable, renderer);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            TTrack track = TableTrackView.this.getTrack();
            if (track.tp != null && value instanceof String) {
                String units;
                String var = (String)value;
                String varName = var;
                int k = varName.indexOf("_{ ");
                if (k > 0) {
                    varName = varName.substring(0, k);
                }
                if ((units = track.tp.getUnits(track, varName)).length() > 0) {
                    value = String.valueOf(var) + " (" + units.trim() + ")";
                }
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        }
    }

    class NumberRenderer
    implements TableCellRenderer {
        DefaultTableCellRenderer defaultRenderer;
        NumberField.NumberFormatter nf = new NumberField.NumberFormatter(false);

        public NumberRenderer() {
            this.defaultRenderer = new DefaultTableCellRenderer();
            this.defaultRenderer.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Double && c instanceof JLabel) {
                ((JLabel)c).setText(this.nf.getText((Double)value));
            }
            return c;
        }
    }

    class SkippedFramesRenderer
    implements TableCellRenderer {
        TableCellRenderer baseRenderer;
        Border belowBorder;
        Border aboveBorder;
        boolean visible = Tracker.showGaps;

        public SkippedFramesRenderer() {
            this.belowBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, Color.red);
            Border space = BorderFactory.createEmptyBorder(0, 1, 0, 1);
            this.belowBorder = BorderFactory.createCompoundBorder(this.belowBorder, space);
            this.aboveBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, Color.red);
            space = BorderFactory.createEmptyBorder(0, 1, 1, 1);
            this.aboveBorder = BorderFactory.createCompoundBorder(this.aboveBorder, space);
        }

        public void setBaseRenderer(TableCellRenderer renderer) {
            this.baseRenderer = renderer;
        }

        public void setVisible(boolean vis) {
            this.visible = vis;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.baseRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (this.visible) {
                TTrack track = TableTrackView.this.getTrack();
                if (track.ttype == 5) {
                    PointMass p = (PointMass)track;
                    if (p.tp != null) {
                        VideoClip clip = p.tp.getPlayer().getVideoClip();
                        int frameNum = TableTrackView.this.getFrameAtRow(row);
                        int stepNum = clip.frameToStep(frameNum);
                        for (int i : p.skippedSteps) {
                            if (stepNum + 1 == i) {
                                ((JLabel)c).setBorder(this.belowBorder);
                                continue;
                            }
                            if (stepNum - 1 != i) continue;
                            ((JLabel)c).setBorder(this.aboveBorder);
                        }
                    }
                }
            }
            return c;
        }
    }

    class TextColumnEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        Color defaultEditingColor;
        JPanel panel = new JPanel(new BorderLayout());
        JTextField field = new JTextField();

        TextColumnEditor() {
            this.defaultEditingColor = this.field.getSelectionColor();
            this.panel.add((Component)this.field, "Center");
            this.panel.setOpaque(false);
            this.field.setBorder(BorderFactory.createEmptyBorder(0, 1, 1, 0));
            this.field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        TextColumnEditor.this.stopCellEditing();
                    } else if (TextColumnEditor.this.field.isEnabled()) {
                        TextColumnEditor.this.field.setBackground(Color.yellow);
                    }
                }
            });
            this.field.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    TextColumnEditor.this.field.requestFocusInWindow();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.field.setBackground(Color.white);
            this.field.setSelectionColor(this.defaultEditingColor);
            this.field.setEditable(true);
            if (value == null) {
                value = "";
            }
            this.field.setText(value.toString());
            return this.panel;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e == null || e instanceof MouseEvent) {
                TTrack track = TableTrackView.this.getTrack();
                return !track.isLocked();
            }
            return false;
        }

        @Override
        public Object getCellEditorValue() {
            TableTrackView.this.dataTable.requestFocusInWindow();
            if (this.field.getBackground() != Color.white) {
                this.field.setBackground(Color.white);
            }
            return this.field.getText();
        }
    }

    private class TextColumnTableModel
    extends DataTable.OSPTableModel {
        private TextColumnTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            String result = "unknown";
            int n = -1;
            int j = 0;
            while (j <= col) {
                if ((n = TableTrackView.this.bsTextColumnsVisible.nextSetBit(n + 1)) == Integer.MAX_VALUE) break;
                ++j;
            }
            ArrayList<String> names = TableTrackView.this.getTrack().getTextColumnNames();
            if (n >= 0 && names.size() > n) {
                result = names.get(n);
            }
            return result;
        }

        @Override
        public int getRowCount() {
            return TableTrackView.this.dataTableManager.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return TableTrackView.this.myDatasetIndex > -1 ? 0 : TableTrackView.this.bsTextColumnsVisible.cardinality();
        }

        @Override
        public Object getValueAt(int row, int col) {
            String columnName = this.getColumnName(col);
            TTrack track = TableTrackView.this.getTrack();
            Dataset frameSet = TableTrackView.this.trackDataManager.getFrameDataset();
            if (frameSet != null) {
                double frame = frameSet.getYPoints()[row];
                return track.getTextColumnEntry(columnName, (int)frame);
            }
            return track.getTextColumnEntry(columnName, row);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            String columnName = this.getColumnName(col);
            TTrack track = TableTrackView.this.getTrack();
            Dataset frameSet = TableTrackView.this.trackDataManager.getFrameDataset();
            TrackerPanel trackerPanel = TableTrackView.this.frame.getTrackerPanelForID(TableTrackView.this.panelID);
            if (frameSet != null) {
                double frame = frameSet.getYPoints()[row];
                if (track.setTextColumnEntry(columnName, (int)frame, (String)value)) {
                    trackerPanel.changed = true;
                }
                return;
            }
            if (track.setTextColumnEntry(columnName, row, (String)value)) {
                trackerPanel.changed = true;
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return !TableTrackView.this.getTrack().isLocked();
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return String.class;
        }

        public String toString() {
            return "TableTrackView.TextColumnTableModel n=" + TableTrackView.this.textColumnNames.size() + " vis=" + TableTrackView.this.bsTextColumnsVisible.cardinality();
        }
    }

    class TrackDataTable
    extends DataTable {
        NumberRenderer numberFieldRenderer;
        SkippedFramesRenderer skippedFramesRenderer;

        @Override
        public int findLastAddedModelIndex(StringBuffer names) {
            if (names == null) {
                return -1;
            }
            if (names.length() < 2) {
                names.append("t").append(",");
                return 0;
            }
            BitSet bs = TableTrackView.this.bsCheckBoxes;
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                String key = "," + TableTrackView.this.aNames[i] + ",";
                if (names.indexOf(key) < 0) {
                    names.append(key);
                    return this.dataTableModel.findColumn(TableTrackView.this.aNames[i]);
                }
                i = bs.nextSetBit(i + 1);
            }
            return -1;
        }

        TrackDataTable() {
            this.numberFieldRenderer = new NumberRenderer();
            this.skippedFramesRenderer = new SkippedFramesRenderer();
            TableCellRenderer renderer = this.getTableHeader().getDefaultRenderer();
            if (renderer instanceof DataTable.HeaderRenderer) {
                renderer = ((DataTable.HeaderRenderer)renderer).getBaseRenderer();
            }
            HeaderUnitsRenderer headerRenderer = new HeaderUnitsRenderer(this, renderer);
            this.getTableHeader().setDefaultRenderer(headerRenderer);
        }

        @Override
        public void refreshTable(int mode) {
            super.refreshTable(mode, true);
            if (mode == 5376) {
                TableTrackView.this.refreshToolbar();
            }
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            return TableTrackView.this.textColumnEditor;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return this.dataTableModel.getColumnClass(this.convertColumnIndexToModel(col)).equals(String.class);
        }

        @Override
        public TableCellRenderer getDefaultRenderer(Class<?> type) {
            return type == Double.class || type == Number.class || type == Object.class ? this.numberFieldRenderer : super.getDefaultRenderer(type);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            TableCellRenderer renderer = super.getCellRenderer(row, column);
            this.skippedFramesRenderer.setBaseRenderer(renderer);
            return this.skippedFramesRenderer;
        }

        @Override
        public void sort(int col) {
            if (col > 0 && TableTrackView.this.gapsButton.isSelected()) {
                TableTrackView.this.gapsButton.doClick(0);
            }
            super.sort(col);
        }
    }
}

