/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.opensourcephysics.cabrillo.tracker.AttachmentDialog;
import org.opensourcephysics.cabrillo.tracker.DoubleArrowFootprint;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.InputTrack;
import org.opensourcephysics.cabrillo.tracker.LineFootprint;
import org.opensourcephysics.cabrillo.tracker.MarkingRequired;
import org.opensourcephysics.cabrillo.tracker.NumberFormatDialog;
import org.opensourcephysics.cabrillo.tracker.Ruler;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TapeStep;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.cabrillo.tracker.UnitsDialog;
import org.opensourcephysics.cabrillo.tracker.WorldRuler;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.FontSizer;

public class TapeMeasure
extends InputTrack
implements MarkingRequired {
    protected static final double MIN_LENGTH = 1.0E-30;
    public static final float[] BROKEN_LINE = new float[]{10.0f, 1.0f};
    protected static final String[] dataVariables = new String[]{"t", "L", Tracker.THETA, "step", "frame"};
    protected static final String[] formatVariables = new String[]{"t", "L", Tracker.THETA, "Lpixel"};
    protected static final Map<String, String[]> formatMap = new HashMap<String, String[]>();
    protected static final Map<String, String> formatDescriptionMap;
    protected static final ArrayList<String> allVariables;
    protected boolean fixedLength = true;
    protected boolean readOnly;
    protected boolean stickMode;
    protected boolean isStepChangingScale;
    protected boolean notYetShown = true;
    protected boolean isIncomplete;
    protected boolean isCalibrator;
    protected JLabel end1Label;
    protected JLabel end2Label;
    protected JLabel lengthLabel;
    protected Footprint[] tapeFootprints;
    protected Footprint[] stickFootprints;
    protected TreeSet<Integer> lengthKeyFrames = new TreeSet();
    protected JMenuItem attachmentItem;
    protected NumberField pixelLengthField;
    protected TTrack.TextLineLabel pixelLengthLabel;
    protected Component pixelLengthSeparator;
    protected Double calibrationLength;
    private static final String[] panelEventsTapeMeasure;

    static {
        formatMap.put("t", new String[]{"t"});
        formatMap.put("L", new String[]{"L"});
        formatMap.put("pix", new String[]{"pixel length"});
        formatMap.put(Tracker.THETA, new String[]{Tracker.THETA});
        formatDescriptionMap = new HashMap<String, String>();
        formatDescriptionMap.put(formatVariables[0], TrackerRes.getString("PointMass.Data.Description.0"));
        formatDescriptionMap.put(formatVariables[1], TrackerRes.getString("TapeMeasure.Label.Length"));
        formatDescriptionMap.put(formatVariables[2], TrackerRes.getString("TapeMeasure.Label.TapeAngle"));
        formatDescriptionMap.put(formatVariables[3], TrackerRes.getString("TapeMeasure.Description.PixelLength"));
        allVariables = TapeMeasure.createAllVariables(dataVariables, formatVariables);
        panelEventsTapeMeasure = new String[]{"fixed_scale", "transform", "selectedpoint", "selectedtrack", "locked"};
    }

    @Override
    public String[] getFormatVariables() {
        return formatVariables;
    }

    @Override
    public Map<String, String[]> getFormatMap() {
        return formatMap;
    }

    @Override
    public Map<String, String> getFormatDescMap() {
        return formatDescriptionMap;
    }

    @Override
    public String getBaseType() {
        return "TapeMeasure";
    }

    @Override
    public String getVarDimsImpl(String variable) {
        String[] vars = dataVariables;
        String[] names = formatVariables;
        if (names[1].equals(variable) || names[3].equals(variable)) {
            return "L";
        }
        if (vars[3].equals(variable) || vars[4].equals(variable)) {
            return "I";
        }
        return null;
    }

    public TapeMeasure() {
        super(8);
        this.setName(TrackerRes.getString("TapeMeasure.New.Name"));
        this.defaultColors = new Color[]{new Color(204, 0, 0)};
        this.setProperty("xVarPlot0", dataVariables[0]);
        this.setProperty("yVarPlot0", dataVariables[1]);
        this.setProperty("xVarPlot1", dataVariables[0]);
        this.setProperty("yVarPlot1", dataVariables[2]);
        this.setProperty("tableVar0", "0");
        this.setProperty("tableVar1", "1");
        this.tapeFootprints = new Footprint[]{LineFootprint.getFootprint("Footprint.DoubleArrow"), LineFootprint.getFootprint("Footprint.BoldDoubleArrow"), LineFootprint.getFootprint("Footprint.Line"), LineFootprint.getFootprint("Footprint.BoldLine")};
        this.stickFootprints = new Footprint[]{LineFootprint.getFootprint("Footprint.BoldDoubleTarget"), LineFootprint.getFootprint("Footprint.DoubleTarget")};
        this.setViewable(false);
        this.setStickMode(false);
        this.setReadOnly(false);
        this.setColor(this.defaultColors[0]);
        this.partName = TrackerRes.getString("TTrack.Selected.Hint");
        this.hint = TrackerRes.getString("TapeMeasure.Hint");
        this.pixelLengthField = new TTrack.TrackNumberField();
        this.pixelLengthField.setMinValue(0.0);
        this.pixelLengthField.addMouseListener(this.formatMouseListener);
        this.pixelLengthField.setBorder(this.fieldBorder);
        this.pixelLengthField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double pixelLength = TapeMeasure.this.pixelLengthField.getValue();
                int n = TapeMeasure.this.tp.getFrameNumber();
                if (TapeMeasure.this.tp.getCoords().getScaleX(n) != 1.0 / pixelLength) {
                    XMLControlElement trackControl = new XMLControlElement(TapeMeasure.this);
                    XMLControlElement coordsControl = new XMLControlElement(TapeMeasure.this.tp.getCoords());
                    TapeMeasure.this.tp.getCoords().setScaleXY(n, 1.0 / pixelLength, 1.0 / pixelLength);
                    Undo.postTrackAndCoordsEdit(TapeMeasure.this, trackControl, coordsControl);
                }
                TapeMeasure.this.pixelLengthField.requestFocusInWindow();
            }
        });
        this.pixelLengthLabel = new TTrack.TextLineLabel();
        this.pixelLengthSeparator = Box.createRigidArea(new Dimension(6, 4));
        this.magField.setMinValue(Double.NaN);
        this.end1Label = new JLabel();
        this.end2Label = new JLabel();
        this.lengthLabel = new JLabel();
        this.end1Label.setBorder(this.xLabel.getBorder());
        this.end2Label.setBorder(this.xLabel.getBorder());
        this.lengthLabel.setBorder(this.xLabel.getBorder());
        this.keyFrames.add(0);
        this.lengthKeyFrames.add(0);
        final FocusAdapter magFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (TapeMeasure.this.magField.getBackground() == Color.yellow) {
                    int n = TapeMeasure.this.tp.getFrameNumber();
                    if (!TapeMeasure.this.isFixedPosition()) {
                        TapeMeasure.this.keyFrames.add(n);
                    }
                    TapeStep step = (TapeStep)TapeMeasure.this.getStep(n);
                    step = (TapeStep)TapeMeasure.this.getKeyStep(step);
                    String rawText = TapeMeasure.this.magField.getText();
                    if (!TapeMeasure.this.isReadOnly()) {
                        TapeMeasure.this.checkLengthUnits(rawText);
                    }
                    step.setTapeLength(TapeMeasure.this.magField.getValue());
                    TapeMeasure.this.invalidateData(null);
                    if (TapeMeasure.this.isFixedPosition()) {
                        TapeMeasure.this.fireStepsChanged();
                    } else {
                        TapeMeasure.this.firePropertyChange("step", null, new Integer(n));
                    }
                    if (TapeMeasure.this.tp.getSelectedPoint() instanceof TapeStep.Rotator) {
                        TapeMeasure.this.tp.setSelectedPoint(null);
                    }
                }
            }
        };
        this.magField.addFocusListener(magFocusListener);
        this.magField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                magFocusListener.focusLost(null);
                TapeMeasure.this.magField.requestFocusInWindow();
            }
        });
        final FocusAdapter angleFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (TapeMeasure.this.angleField.getBackground() == Color.yellow) {
                    int n = TapeMeasure.this.tp.getFrameNumber();
                    if (!TapeMeasure.this.isFixedPosition()) {
                        TapeMeasure.this.keyFrames.add(n);
                    }
                    TapeStep step = (TapeStep)TapeMeasure.this.getStep(n);
                    step = (TapeStep)TapeMeasure.this.getKeyStep(step);
                    step.setTapeAngle(TapeMeasure.this.angleField.getValue());
                    TapeMeasure.this.invalidateData(null);
                    if (TapeMeasure.this.isFixedPosition()) {
                        TapeMeasure.this.fireStepsChanged();
                    } else {
                        TapeMeasure.this.firePropertyChange("step", null, new Integer(n));
                    }
                    if (!TapeMeasure.this.isReadOnly()) {
                        TapeMeasure.this.tp.getAxes().setVisible(true);
                    }
                }
            }
        };
        this.angleField.addFocusListener(angleFocusListener);
        this.angleField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                angleFocusListener.focusLost(null);
                TapeMeasure.this.angleField.requestFocusInWindow();
            }
        });
    }

    public void setFixedLength(boolean fixed) {
        if (this.fixedLength == fixed) {
            return;
        }
        XMLControlElement control = new XMLControlElement(this);
        if (this.tp != null) {
            int n = this.tp.getFrameNumber();
            this.tp.changed = true;
            TapeStep keyStep = (TapeStep)this.getStep(n);
            int i = 0;
            while (i < this.steps.array.length) {
                TapeStep step = (TapeStep)this.steps.getStep(i);
                if (step != null && keyStep != null) {
                    step.worldLength = keyStep.worldLength;
                }
                ++i;
            }
            TFrame.repaintT(this.tp);
        }
        if (fixed) {
            this.lengthKeyFrames.clear();
            this.lengthKeyFrames.add(0);
        }
        this.fixedLength = fixed;
        Undo.postTrackEdit(this, control);
    }

    public boolean isFixedLength() {
        return this.fixedLength;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        Footprint[] footprintArray = this.getFootprints();
        int n = footprintArray.length;
        int n2 = 0;
        while (n2 < n) {
            Footprint footprint = footprintArray[n2];
            if (footprint instanceof DoubleArrowFootprint) {
                DoubleArrowFootprint line = (DoubleArrowFootprint)footprint;
                line.setSolidHead(!this.isReadOnly());
            }
            ++n2;
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setStickMode(boolean stick) {
        this.stickMode = stick;
        if (this.isStickMode()) {
            this.setFootprints(this.stickFootprints);
        } else {
            this.setFootprints(this.tapeFootprints);
        }
        this.defaultFootprint = this.getFootprint();
        if (this.ruler != null) {
            this.ruler.setStrokeWidth(this.defaultFootprint.getStroke().getLineWidth());
        }
        Step[] stepArray = this.getSteps();
        int n = stepArray.length;
        int n2 = 0;
        while (n2 < n) {
            Step step = stepArray[n2];
            if (step != null) {
                TapeStep tapeStep = (TapeStep)step;
                tapeStep.end1.setCoordsEditTrigger(this.isStickMode());
                tapeStep.end2.setCoordsEditTrigger(this.isStickMode());
            }
            ++n2;
        }
        this.repaint();
    }

    public boolean isStickMode() {
        return this.stickMode;
    }

    public void setCalibrator(Double worldLength) {
        this.isCalibrator = true;
        this.calibrationLength = worldLength;
    }

    @Override
    public boolean isMarkByDefault() {
        return this.requiresMarking() || super.isMarkByDefault();
    }

    @Override
    public boolean requiresMarking() {
        boolean incomplete;
        boolean bl = incomplete = this.getStep(0) == null || this.isIncomplete;
        return this.isCalibrator && incomplete;
    }

    @Override
    public void setLocked(boolean locked) {
        super.setLocked(locked);
        boolean enabled = this.isFieldsEnabled();
        this.magField.setEnabled(enabled);
        this.angleField.setEnabled(enabled);
        this.pixelLengthField.setEnabled(enabled);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "transform": {
                if (this.isStickMode() && !this.isStepChangingScale) {
                    int n = this.tp.getFrameNumber();
                    TapeStep step = (TapeStep)this.getStep(n);
                    if (step != null) {
                        step.adjustTipsToLength();
                    }
                    if (!this.isFixedPosition()) {
                        this.keyFrames.add(n);
                    }
                }
                this.repaint();
                break;
            }
            case "adjusting": {
                if (!(e.getSource() instanceof TrackerPanel)) break;
                this.refreshDataLater = (Boolean)e.getNewValue();
                if (this.refreshDataLater) break;
                this.firePropertyChange("data", null, null);
                break;
            }
            case "stepnumber": {
                if (this.tp.getSelectedTrack() != this) break;
                TapeStep step = (TapeStep)this.getStep(this.tp.getFrameNumber());
                if (step != null) {
                    step.getTapeLength(!this.isStickMode());
                }
                boolean enabled = this.isFieldsEnabled();
                this.magField.setEnabled(enabled);
                this.angleField.setEnabled(enabled);
                this.stepValueLabel.setText(e.getNewValue() + ":");
                break;
            }
            case "locked": {
                boolean enabled = this.isFieldsEnabled();
                this.magField.setEnabled(enabled);
                this.angleField.setEnabled(enabled);
                break;
            }
            case "fixed_scale": {
                if (!this.isStickMode() || e.getNewValue() != Boolean.FALSE) break;
                this.setFixedPosition(false);
                break;
            }
            case "step": 
            case "steps": {
                this.refreshAttachments();
                break;
            }
            case "selectedtrack": {
                this.repaint();
                break;
            }
            case "selectedpoint": {
                TapeStep step = (TapeStep)this.getStep(this.tp.getFrameNumber());
                step.rotatorDrawShapes[0] = null;
                step.rotatorDrawShapes[1] = null;
            }
            default: {
                super.propertyChange(e);
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.notYetShown = false;
        }
    }

    @Override
    public boolean isLocked() {
        boolean locked = super.isLocked();
        if (!this.readOnly && this.tp != null && !(this.tp.getSelectedPoint() instanceof TapeStep.Handle)) {
            locked = locked || this.tp.getCoords().isLocked();
        }
        return locked;
    }

    @Override
    public Step createStep(int n, double x, double y) {
        TapeStep step = (TapeStep)this.getStep(n);
        this.isIncomplete = false;
        if (step == null) {
            this.isIncomplete = true;
            step = new TapeStep(this, n, x, y, x, y);
            step.worldLength = 0.0;
            step.setFootprint(this.getFootprint());
            this.steps = new TTrack.StepArray(step);
            step = (TapeStep)this.getStep(n);
        } else if (step.worldLength == 0.0) {
            double worldLen;
            TapeStep step0 = (TapeStep)this.getStep(0);
            TapeStep targetStep = this.tp.getCoords().isFixedScale() ? step0 : (TapeStep)this.getStep(n);
            targetStep.getEnd2().setLocation(x, y);
            step0.getEnd2().setLocation(x, y);
            step0.worldLength = worldLen = targetStep.getTapeLength(true);
            if (this.calibrationLength != null) {
                targetStep.setTapeLength(this.calibrationLength);
                this.calibrationLength = null;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TapeMeasure.this.tp.setSelectedPoint(null);
                }
            });
        } else {
            TPoint p;
            TPoint[] pts = step.getPoints();
            TPoint tPoint = p = this.tp == null ? null : this.tp.getSelectedPoint();
            if (p == null) {
                p = pts[0];
            }
            if (p == pts[0] || p == pts[1]) {
                p.setXY(x, y);
                if (this.tp != null) {
                    this.tp.setSelectedPoint(p);
                }
            }
        }
        return step;
    }

    public Step createStep(int n, double x1, double y1, double x2, double y2) {
        TapeStep step = (TapeStep)this.steps.getStep(n);
        if (step == null) {
            step = new TapeStep(this, n, x1, y1, x2, y2);
            step.worldLength = step.getTapeLength(true);
            step.setFootprint(this.getFootprint());
            this.steps = new TTrack.StepArray(step);
            if (this.calibrationLength != null) {
                step.setTapeLength(this.calibrationLength);
                this.calibrationLength = null;
            }
        } else if (this.isIncomplete) {
            step.getEnd2().setLocation(x2, y2);
            this.repaint();
        } else {
            step.getEnd1().setLocation(x1, y1);
            step.getEnd2().setLocation(x2, y2);
        }
        this.keyFrames.add(n);
        return step;
    }

    @Override
    public TPoint autoMarkAt(int n, double x, double y) {
        TapeStep step = (TapeStep)this.getStep(n);
        if (step == null || step.worldLength == 0.0) {
            return null;
        }
        int index = this.getTargetIndex();
        TPoint p = step.getPoints()[index];
        if (p == null) {
            return null;
        }
        this.setFixedPosition(false);
        if (this.isStickMode()) {
            ImageCoordSystem coords = this.tp.getCoords();
            coords.setFixedScale(false);
        }
        p.setAdjusting(true, null);
        p.setXY(x, y);
        p.setAdjusting(false, null);
        return p;
    }

    @Override
    public boolean isStepComplete(int n) {
        if (this.isIncomplete) {
            return false;
        }
        return super.isStepComplete(n);
    }

    @Override
    public int getStepLength() {
        return TapeStep.getLength();
    }

    @Override
    public int getFootprintLength() {
        return 2;
    }

    public String getFormattedLength(double length) {
        this.inputField.setFormatFor(length);
        return this.inputField.format(length);
    }

    @Override
    public boolean isViewable() {
        return this.isReadOnly() && !this.isStickMode();
    }

    @Override
    protected boolean isAutoTrackable() {
        TapeStep step = (TapeStep)this.getStep(this.tp.getFrameNumber());
        return step != null && step.worldLength != 0.0;
    }

    @Override
    protected String getTargetDescription(int pointIndex) {
        String s = TrackerRes.getString("Calibration.Point.Name");
        return String.valueOf(s) + " " + (pointIndex + 1);
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel, JMenu menu0) {
        JMenu menu = super.getMenu(trackerPanel, menu0);
        if (menu0 == null) {
            return menu;
        }
        this.getMenuItems();
        this.lockedItem.setEnabled(!trackerPanel.getCoords().isLocked());
        this.removeDeleteTrackItem(menu);
        TapeStep step = (TapeStep)this.steps.getStep(0);
        boolean fixedScale = trackerPanel.getCoords().isFixedScale();
        boolean canBeFixed = !this.lockedItem.isSelected() && (fixedScale || !this.isStickMode());
        this.fixedItem.setEnabled(canBeFixed && step != null && step.worldLength > 0.0 && !this.isAttached());
        this.fixedItem.setText(TrackerRes.getString("TapeMeasure.MenuItem.Fixed"));
        this.fixedItem.setSelected(this.isFixedPosition() && (fixedScale || !this.isStickMode()));
        this.addFixedItem(menu);
        this.attachmentItem.setEnabled(step != null && step.worldLength > 0.0);
        this.attachmentItem.setText(TrackerRes.getString("TapeMeasure.MenuItem.Attach"));
        menu.insert(this.attachmentItem, 0);
        menu.insertSeparator(1);
        menu.addSeparator();
        menu.add(this.deleteTrackItem);
        return menu;
    }

    @Override
    protected void getMenuItems() {
        if (this.fixedItem != null) {
            return;
        }
        super.getMenuItems();
        this.fixedItem = new JCheckBoxMenuItem(TrackerRes.getString("TapeMeasure.MenuItem.Fixed"));
        this.fixedItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TapeMeasure.this.setFixedPosition(TapeMeasure.this.fixedItem.isSelected());
            }
        });
        this.attachmentItem = new JMenuItem(TrackerRes.getString("TapeMeasure.MenuItem.Attach"));
        this.attachmentItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageCoordSystem coords = TapeMeasure.this.tp.getCoords();
                if (TapeMeasure.this.isStickMode() && coords.isFixedScale()) {
                    int result = JOptionPane.showConfirmDialog(TapeMeasure.this.tframe, String.valueOf(TrackerRes.getString("TapeMeasure.Alert.UnfixScale.Message1")) + "\n" + TrackerRes.getString("TapeMeasure.Alert.UnfixScale.Message2"), TrackerRes.getString("TapeMeasure.Alert.UnfixScale.Title"), 0, 3);
                    if (result != 0) {
                        return;
                    }
                    coords.setFixedScale(false);
                }
                AttachmentDialog control = TapeMeasure.this.tp.getAttachmentDialog(TapeMeasure.this);
                control.setVisible(true);
            }
        });
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        String unmarked;
        ArrayList<Component> list = super.getToolbarTrackComponents(trackerPanel);
        this.magLabel.setText(TrackerRes.getString("TapeMeasure.Label.Length"));
        this.magField.setToolTipText(TrackerRes.getString("TapeMeasure.Field.Magnitude.Tooltip"));
        this.magField.setUnits(trackerPanel.getUnits(this, dataVariables[1]));
        this.stepLabel.setText(TrackerRes.getString("TTrack.Label.Step"));
        VideoClip clip = trackerPanel.getPlayer().getVideoClip();
        int n = clip.frameToStep(trackerPanel.getFrameNumber());
        this.stepValueLabel.setText(String.valueOf(n) + ":");
        list.add(this.stepSeparator);
        n = trackerPanel.getFrameNumber();
        TapeStep step = (TapeStep)this.getStep(n);
        boolean exists = step != null;
        boolean complete = step != null && step.worldLength > 0.0;
        String string = unmarked = this.isStickMode() ? TrackerRes.getString("TapeMeasure.Label.UnmarkedStick") : TrackerRes.getString("TapeMeasure.Label.UnmarkedTape");
        if (!exists) {
            this.end1Label.setText(unmarked);
            this.end1Label.setForeground(Color.red.darker());
            list.add(this.end1Label);
        } else if (!complete) {
            this.end1Label.setText(unmarked);
            this.end1Label.setForeground(Color.red.darker());
            list.add(this.end1Label);
        } else {
            this.rulerCheckbox.setText(TrackerRes.getString("InputTrack.Checkbox.Ruler"));
            this.rulerCheckbox.setToolTipText(TrackerRes.getString("InputTrack.Checkbox.Ruler.Tooltip"));
            this.rulerCheckbox.setSelected(this.ruler != null && this.ruler.isVisible());
            list.add(this.rulerCheckbox);
            list.add(this.stepLabel);
            list.add(this.stepValueLabel);
            list.add(this.tSeparator);
            list.add(this.magLabel);
            list.add(this.magField);
            this.angleLabel.setText(TrackerRes.getString("TapeMeasure.Label.TapeAngle"));
            this.angleField.setToolTipText(TrackerRes.getString("TapeMeasure.Field.TapeAngle.Tooltip"));
            list.add(this.magSeparator);
            list.add(this.angleLabel);
            list.add(this.angleField);
            if (this.isCalibrator) {
                this.pixelLengthField.setUnits(trackerPanel.getUnits(this, dataVariables[1]));
                this.pixelLengthLabel.setText(TrackerRes.getString("TapeMeasure.Label.PixelLength"));
                this.pixelLengthLabel.setToolTipText(TrackerRes.getString("TapeMeasure.Description.PixelLength"));
                this.pixelLengthField.setToolTipText(TrackerRes.getString("TapeMeasure.Field.PixelLength.Tooltip"));
                list.add(this.pixelLengthSeparator);
                list.add(this.pixelLengthLabel);
                list.add(this.pixelLengthField);
            }
            boolean enabled = this.isFieldsEnabled();
            this.magField.setEnabled(enabled);
            this.angleField.setEnabled(enabled);
        }
        return list;
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (!this.isVisible() || !(panel instanceof TrackerPanel)) {
            return null;
        }
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        int n = trackerPanel.getFrameNumber();
        TapeStep step = (TapeStep)this.getStep(n);
        if (step == null) {
            this.partName = null;
            this.hint = String.valueOf(TrackerRes.getString("TapeMeasure.MarkEnd.Hint")) + " 1";
            return null;
        }
        if (trackerPanel.getPlayer().getVideoClip().includesFrame(n)) {
            TPoint[] pts = step.points;
            TPoint p = trackerPanel.getSelectedPoint();
            Interactive ia = step.findInteractive(trackerPanel, xpix, ypix);
            if (this.ruler != null && this.ruler.isVisible()) {
                boolean b;
                boolean bl = b = ia == this.ruler.getHandle() || p == this.ruler.getHandle();
                if (this.ruler.hitShapeVisible != b) {
                    this.ruler.setHitShapeVisible(b);
                    if (OSPRuntime.isJS) {
                        TFrame.repaintT(trackerPanel);
                    }
                }
            }
            if (step.worldLength == 0.0) {
                if (ia instanceof TapeStep.Tip || ia instanceof TapeStep.Handle) {
                    ia = step.handle;
                    this.partName = String.valueOf(TrackerRes.getString("TapeMeasure.End.Name")) + " 1";
                    this.hint = TrackerRes.getString("TapeMeasure.Handle.Hint");
                } else {
                    this.partName = null;
                    this.hint = String.valueOf(TrackerRes.getString("TapeMeasure.MarkEnd.Hint")) + " 2";
                }
            } else {
                if (ia == null) {
                    if (p == pts[0] || p == pts[1]) {
                        this.partName = TrackerRes.getString("TapeMeasure.End.Name");
                        this.hint = this.isStickMode() && !this.isReadOnly() ? TrackerRes.getString("CalibrationStick.End.Hint") : TrackerRes.getString("TapeMeasure.End.Hint");
                    } else {
                        this.partName = TrackerRes.getString("TTrack.Selected.Hint");
                        this.hint = !this.isReadOnly() ? TrackerRes.getString("CalibrationTapeMeasure.Hint") : TrackerRes.getString("TapeMeasure.Hint");
                    }
                    return null;
                }
                if (ia instanceof TapeStep.Tip) {
                    this.partName = TrackerRes.getString("TapeMeasure.End.Name");
                    this.hint = this.isStickMode() && !this.isReadOnly() ? TrackerRes.getString("CalibrationStick.End.Hint") : TrackerRes.getString("TapeMeasure.End.Hint");
                } else if (ia instanceof TapeStep.Handle) {
                    this.partName = TrackerRes.getString("TapeMeasure.Handle.Name");
                    this.hint = TrackerRes.getString("TapeMeasure.Handle.Hint");
                } else if (ia instanceof TapeStep.Rotator) {
                    this.partName = TrackerRes.getString("TapeMeasure.Rotator.Name");
                    this.hint = TrackerRes.getString("TapeMeasure.Rotator.Hint");
                    if (OSPRuntime.isJS) {
                        TFrame.repaintT(trackerPanel);
                    }
                } else if (this.ruler != null && ia == this.ruler.getHandle()) {
                    this.partName = TrackerRes.getString("TapeMeasure.Ruler.Name");
                    this.hint = TrackerRes.getString("TapeMeasure.Ruler.Hint");
                } else if (ia == this) {
                    this.partName = TrackerRes.getString("TapeMeasure.Readout.Magnitude.Name");
                    this.hint = !this.isReadOnly() ? TrackerRes.getString("CalibrationTapeMeasure.Readout.Magnitude.Hint") : TrackerRes.getString("TapeMeasure.Readout.Magnitude.Hint");
                }
            }
            return this.isLocked() ? null : ia;
        }
        return null;
    }

    @Override
    public Step getStep(int n) {
        if (this.isStickMode() && this.tp != null) {
            int frameCount = this.tp.getPlayer().getVideoClip().getFrameCount();
            if (this.getSteps().length < frameCount) {
                this.steps.setLength(frameCount);
            }
        }
        return super.getStep(n);
    }

    @Override
    public DatasetManager getData(TrackerPanel panel) {
        int frameCount = panel.getPlayer().getVideoClip().getFrameCount();
        if (this.getSteps().length < frameCount) {
            this.steps.setLength(frameCount);
            this.dataValid = false;
        }
        return super.getData(panel);
    }

    @Override
    protected void refreshData(DatasetManager data, TrackerPanel trackerPanel) {
        if (this.refreshDataLater || trackerPanel == null || data == null) {
            return;
        }
        int count = 4;
        VideoPlayer player = trackerPanel.getPlayer();
        VideoClip clip = player.getVideoClip();
        int len = clip.getStepCount();
        double[][] validData = new double[count + 1][len];
        this.dataFrames.clear();
        int i = 0;
        while (i < len) {
            int frame = clip.stepToFrame(i);
            TapeStep step = (TapeStep)this.getStep(frame);
            if (step != null) {
                step.dataVisible = true;
                double t = player.getStepTime(i) / 1000.0;
                validData[0][i] = step.getTapeLength(true);
                validData[1][i] = step.getTapeAngle();
                validData[2][i] = i;
                validData[3][i] = frame;
                validData[4][i] = t;
                this.dataFrames.add(frame);
            }
            ++i;
        }
        this.clearColumns(data, count, dataVariables, "TapeMeasure.Data.Description.", validData, len);
    }

    @Override
    public void remark(Integer panelID) {
        super.remark(panelID);
        this.displayState();
    }

    @Override
    public String toString() {
        return TrackerRes.getString("TapeMeasure.Name");
    }

    @Override
    public Map<String, NumberField[]> getNumberFields() {
        if (this.numberFields.isEmpty()) {
            this.numberFields.put(dataVariables[0], new NumberField[]{this.tField});
            this.numberFields.put(dataVariables[1], new NumberField[]{this.magField, this.inputField});
            this.numberFields.put(dataVariables[2], new NumberField[]{this.angleField});
            this.numberFields.put(formatVariables[3], new NumberField[]{this.pixelLengthField});
        }
        return this.numberFields;
    }

    protected JPopupMenu getInputFieldPopup() {
        boolean hasMassUnit;
        JPopupMenu popup = new JPopupMenu();
        if (this.tp.isEnabled("number.formats") || this.tp.isEnabled("number.units")) {
            JMenuItem item;
            JMenu numberMenu = new JMenu(TrackerRes.getString("Popup.Menu.Numbers"));
            popup.add(numberMenu);
            if (this.tp.isEnabled("number.formats")) {
                item = new JMenuItem();
                final String[] selected = new String[]{dataVariables[1]};
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NumberFormatDialog.getNumberFormatDialog(TapeMeasure.this.tp, TapeMeasure.this, selected).setVisible(true);
                    }
                });
                item.setText(String.valueOf(TrackerRes.getString("Popup.MenuItem.Formats")) + "...");
                numberMenu.add(item);
            }
            if (this.tp.isEnabled("number.units")) {
                item = new JMenuItem();
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        UnitsDialog dialog = TapeMeasure.this.tp.getUnitsDialog();
                        dialog.setVisible(true);
                    }
                });
                item.setText(String.valueOf(TrackerRes.getString("Popup.MenuItem.Units")) + "...");
                numberMenu.add(item);
            }
            popup.addSeparator();
        }
        boolean hasLengthUnit = this.tp.lengthUnit != null;
        boolean bl = hasMassUnit = this.tp.massUnit != null;
        if (hasLengthUnit && hasMassUnit) {
            JMenuItem item = new JMenuItem();
            final boolean vis = this.tp.isUnitsVisible();
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TapeMeasure.this.tp.setUnitsVisible(!vis);
                    TapeMeasure.this.tp.refreshTrackBar();
                    Step step = TapeMeasure.this.getStep(TapeMeasure.this.tp.getFrameNumber());
                    step.repaint();
                }
            });
            item.setText(vis ? TrackerRes.getString("TTrack.MenuItem.HideUnits") : TrackerRes.getString("TTrack.MenuItem.ShowUnits"));
            popup.add(item);
        }
        return popup;
    }

    @Override
    public void setFontLevel(int level) {
        super.setFontLevel(level);
        Object[] objectsToSize = new Object[]{this.end1Label, this.end2Label, this.lengthLabel, this.pixelLengthLabel};
        FontSizer.setFonts(objectsToSize);
    }

    @Override
    public void setTrackerPanel(TrackerPanel panel) {
        if (this.tp != null) {
            this.removePanelEvents(panelEventsTapeMeasure);
        }
        super.setTrackerPanel(panel);
        if (this.tp != null) {
            this.addPanelEvents(panelEventsTapeMeasure);
            boolean canBeFixed = !this.isStickMode() || this.tp.getCoords().isFixedScale();
            this.setFixedPosition(this.isFixedPosition() && canBeFixed);
        }
    }

    protected void refreshWorldLengths() {
        int i = 0;
        while (i < this.getSteps().length) {
            TapeStep step = (TapeStep)this.getSteps()[i];
            if (step != null) {
                this.refreshStep(step);
                step.worldLength = step.getTapeLength(true);
            }
            ++i;
        }
    }

    private void checkLengthUnits(String rawText) {
        String[] split = rawText.split(" ");
        if (split.length > 1) {
            int i = 1;
            while (i < split.length) {
                if (!"".equals(split[i])) {
                    if (split[i].equals(this.tp.getLengthUnit())) {
                        this.tp.setUnitsVisible(true);
                        break;
                    }
                    int response = JOptionPane.showConfirmDialog(this.tframe, String.valueOf(TrackerRes.getString("TapeMeasure.Dialog.ChangeLengthUnit.Message")) + " \"" + split[i] + "\" ?", TrackerRes.getString("TapeMeasure.Dialog.ChangeLengthUnit.Title"), 0);
                    if (response != 0) break;
                    this.tp.setLengthUnit(split[i]);
                    this.tp.setUnitsVisible(true);
                    break;
                }
                ++i;
            }
        }
    }

    private void displayState() {
        int n = this.tp == null ? 0 : this.tp.getFrameNumber();
        TapeStep step = (TapeStep)this.getStep(n);
        if (step != null) {
            step.getTapeLength(!this.isStickMode());
        }
    }

    protected boolean isFieldsEnabled() {
        if (this.isLocked()) {
            return false;
        }
        if (!this.isReadOnly() && this.tp != null && this.tp.getCoords().isLocked()) {
            return false;
        }
        int n = this.tp == null ? 0 : this.tp.getFrameNumber();
        TapeStep step = (TapeStep)this.getStep(n);
        return step == null || !step.end1.isAttached() || !step.end2.isAttached();
    }

    @Override
    protected Ruler getRuler() {
        if (this.ruler == null) {
            this.ruler = new WorldRuler(this);
        }
        return this.ruler;
    }

    @Override
    protected void refreshStep(Step step) {
        int i;
        if (step == null || this.isIncomplete) {
            return;
        }
        int positionKey = 0;
        int lengthKey = 0;
        Iterator<Object> iterator = this.keyFrames.iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            if (i > step.n) continue;
            positionKey = i;
        }
        iterator = this.lengthKeyFrames.iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            if (i > step.n) continue;
            lengthKey = i;
        }
        boolean different = false;
        boolean changed = false;
        TapeStep t = (TapeStep)step;
        TapeStep k = (TapeStep)this.steps.getStep(this.isFixedPosition() ? 0 : positionKey);
        if (k != t) {
            boolean bl = different = (int)(1000000.0 * k.getEnd1().x) != (int)(1000000.0 * t.getEnd1().x) || (int)(1000000.0 * k.getEnd1().y) != (int)(1000000.0 * t.getEnd1().y) || (int)(1000000.0 * k.getEnd2().x) != (int)(1000000.0 * t.getEnd2().x) || (int)(1000000.0 * k.getEnd2().y) != (int)(1000000.0 * t.getEnd2().y);
            if (different) {
                t.getEnd1().setLocation(k.getEnd1());
                t.getEnd2().setLocation(k.getEnd2());
                changed = true;
            }
        }
        if (this.isStickMode() || t.worldLength == 0.0) {
            k = (TapeStep)this.steps.getStep(this.isFixedLength() ? 0 : lengthKey);
            boolean bl = different = k.worldLength != t.worldLength;
            if (different) {
                t.worldLength = k.worldLength;
                changed = true;
            }
        }
        if (changed) {
            t.erase();
        }
    }

    @Override
    protected NumberField createInputField() {
        return new TTrack.TrackNumberField(this){

            @Override
            public void setFixedPattern(String pattern) {
                super.setFixedPattern(pattern);
                TapeMeasure.this.setMagValue();
            }
        };
    }

    @Override
    protected Rectangle getLayoutBounds(Step step) {
        return ((TapeStep)step).panelLayoutBounds.get(this.tp.getID());
    }

    @Override
    protected boolean checkKeyFrame() {
        return !this.editing && (this.readOnly || this.isStickMode());
    }

    @Override
    protected void endEditing(Step step, String rawText) {
        TapeStep t = (TapeStep)step;
        t.drawLayoutBounds = false;
        if (!this.isReadOnly()) {
            this.checkLengthUnits(rawText);
        }
        if (t.worldLength > 0.0) {
            t.setTapeLength(this.inputField.getValue());
            t.repaint(this.tp.getID());
        }
        this.inputField.setSigFigs(4);
    }

    @Override
    protected void setInputValue(Step step) {
        this.inputField.setValue(((TapeStep)step).getTapeLength(!this.isStickMode()));
        this.inputField.setUnits(this.tp.getUnits(this, dataVariables[1]));
    }

    public static XML.ObjectLoader getLoader() {
        XML.setLoader(FrameData.class, new FrameDataLoader());
        return new Loader();
    }

    public static class FrameData {
        double[] data = new double[4];

        FrameData() {
        }

        FrameData(TapeStep step) {
            this.data[0] = step.getEnd1().x;
            this.data[1] = step.getEnd1().y;
            this.data[2] = step.getEnd2().x;
            this.data[3] = step.getEnd2().y;
        }
    }

    private static class FrameDataLoader
    implements XML.ObjectLoader {
        private FrameDataLoader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            FrameData data = (FrameData)obj;
            control.setValue("x1", data.data[0]);
            control.setValue("y1", data.data[1]);
            control.setValue("x2", data.data[2]);
            control.setValue("y2", data.data[3]);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new FrameData();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            FrameData data = (FrameData)obj;
            if (control.getPropertyNamesRaw().contains("x1")) {
                data.data[0] = control.getDouble("x1");
                data.data[1] = control.getDouble("y1");
                data.data[2] = control.getDouble("x2");
                data.data[3] = control.getDouble("y2");
            }
            return obj;
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            TapeMeasure tape = (TapeMeasure)obj;
            XML.getLoader(TTrack.class).saveObject(control, obj);
            control.setValue("fixedtape", tape.isFixedPosition());
            control.setValue("fixedlength", tape.isFixedLength());
            control.setValue("readonly", tape.isReadOnly());
            control.setValue("stickmode", tape.isStickMode());
            Step[] steps = tape.getSteps();
            int count = tape.isFixedPosition() ? 1 : steps.length;
            FrameData[] data = new FrameData[count];
            int n = 0;
            while (n < count) {
                if (steps[n] != null && tape.keyFrames.contains(n)) {
                    data[n] = new FrameData((TapeStep)steps[n]);
                }
                ++n;
            }
            control.setValue("framedata", data);
            count = tape.isFixedLength() ? 1 : steps.length;
            Double[] lengths = new Double[count];
            int n2 = 0;
            while (n2 < count) {
                if (steps[n2] != null && tape.lengthKeyFrames.contains(n2)) {
                    lengths[n2] = ((TapeStep)steps[n2]).worldLength;
                }
                ++n2;
            }
            control.setValue("worldlengths", lengths);
            if (tape.ruler != null && tape.ruler.isVisible()) {
                control.setValue("rulersize", tape.ruler.getRulerSize());
                control.setValue("rulerspacing", tape.ruler.getLineSpacing());
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return new TapeMeasure();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            TapeMeasure tape = (TapeMeasure)obj;
            tape.notYetShown = false;
            boolean locked = tape.isLocked();
            tape.setLocked(false);
            tape.setStickMode(control.getBoolean("stickmode"));
            XML.getLoader(TTrack.class).loadObject(control, obj);
            tape.keyFrames.clear();
            FrameData[] data = (FrameData[])control.getObject("framedata");
            if (data != null) {
                int n = 0;
                while (n < data.length) {
                    if (data[n] != null) {
                        tape.createStep(n, data[n].data[0], data[n].data[1], data[n].data[2], data[n].data[3]);
                    }
                    ++n;
                }
            }
            tape.lengthKeyFrames.clear();
            Double[] lengths = (Double[])control.getObject("worldlengths");
            if (lengths != null) {
                int n = 0;
                while (n < lengths.length) {
                    if (lengths[n] != null) {
                        TapeStep step = (TapeStep)tape.steps.getStep(n);
                        step.worldLength = lengths[n];
                        tape.lengthKeyFrames.add(n);
                    }
                    ++n;
                }
            }
            tape.fixedPosition = control.getBoolean("fixedtape");
            if (control.getPropertyNamesRaw().contains("fixedlength")) {
                tape.fixedLength = control.getBoolean("fixedlength");
            }
            if (control.getPropertyNamesRaw().contains("rulersize")) {
                tape.getRuler().setVisible(true);
                tape.ruler.setRulerSize(control.getDouble("rulersize"));
                tape.ruler.setLineSpacing(control.getDouble("rulerspacing"));
            }
            tape.setReadOnly(control.getBoolean("readonly"));
            tape.setLocked(locked);
            tape.displayState();
            return obj;
        }
    }
}

