/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.LineFootprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;

public class TapeStep
extends Step {
    protected static TPoint endPoint1 = new TPoint();
    protected static TPoint endPoint2 = new TPoint();
    protected TapeMeasure tape;
    protected TPoint end1;
    protected TPoint end2;
    protected TPoint middle;
    protected Handle handle;
    protected Rotator rotator1;
    protected Rotator rotator2;
    protected double worldLength;
    protected double xAxisToTapeAngle;
    protected double tapeAngle;
    protected boolean endsEnabled = true;
    protected boolean drawLayout;
    protected boolean drawLayoutBounds;
    protected boolean adjustingTips;
    protected Map<Integer, Shape> panelEnd1Shapes = new HashMap<Integer, Shape>();
    protected Map<Integer, Shape> panelEnd2Shapes = new HashMap<Integer, Shape>();
    protected Map<Integer, Shape> panelShaftShapes = new HashMap<Integer, Shape>();
    protected Map<Integer, Shape[]> panelRotatorShapes = new HashMap<Integer, Shape[]>();
    protected Map<Integer, OSPRuntime.TextLayout> panelTextLayouts = new HashMap<Integer, OSPRuntime.TextLayout>();
    protected Map<Integer, Rectangle> panelLayoutBounds = new HashMap<Integer, Rectangle>();
    protected MultiShape[] rotatorDrawShapes = new MultiShape[2];
    protected Shape selectedShape;

    public TapeStep(TapeMeasure track, int n, double x1, double y1, double x2, double y2) {
        super(track, n);
        this.tape = track;
        this.end1 = new Tip(x1, y1);
        this.end1.setTrackEditTrigger(true);
        this.end2 = new Tip(x2, y2);
        this.end2.setTrackEditTrigger(true);
        this.middle = new TPoint(x1, y1);
        this.rotator1 = new Rotator();
        this.rotator2 = new Rotator();
        this.handle = new Handle((x1 + x2) / 2.0, (y1 + y2) / 2.0);
        this.handle.setTrackEditTrigger(true);
        this.points = new TPoint[]{this.end1, this.end2, this.handle, this.middle, this.rotator1, this.rotator2};
        this.screenPoints = new Point[TapeStep.getLength()];
    }

    public TPoint getEnd1() {
        return this.end1;
    }

    public TPoint getEnd2() {
        return this.end2;
    }

    public TPoint getHandle() {
        return this.handle;
    }

    public void setEndsEnabled(boolean enabled) {
        this.endsEnabled = enabled;
    }

    public boolean isEndsEnabled() {
        return this.endsEnabled;
    }

    @Override
    public void setFootprint(Footprint footprint) {
        if (footprint.getLength() >= 2) {
            super.setFootprint(footprint);
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        Shape hitShape;
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        this.setHitRectCenter(xpix, ypix);
        boolean drawOutline = false;
        this.drawLayout = false;
        Interactive hit = null;
        if (this.endsEnabled) {
            hitShape = this.panelEnd1Shapes.get(trackerPanel.getID());
            if (hitShape != null && hitShape.intersects(hitRect)) {
                hit = this.end1;
            }
            hitShape = this.panelEnd2Shapes.get(trackerPanel.getID());
            if (hit == null && hitShape != null && hitShape.intersects(hitRect)) {
                hit = this.end2;
            }
        }
        hitShape = this.panelShaftShapes.get(trackerPanel.getID());
        if (hit == null && hitShape != null && hitShape.intersects(hitRect)) {
            hit = this.handle;
            this.drawLayout = true;
        }
        Shape[] rotatorHitShapes = this.panelRotatorShapes.get(trackerPanel.getID());
        if (hit == null && rotatorHitShapes != null) {
            if (rotatorHitShapes[0].intersects(hitRect) && !this.end1.isAttached()) {
                hit = this.rotator1;
            } else if (rotatorHitShapes[1].intersects(hitRect) && !this.end2.isAttached()) {
                hit = this.rotator2;
            }
        }
        if (hit == null && this.selectedShape != null && this.selectedShape.intersects(hitRect)) {
            if (trackerPanel.getSelectedPoint() == this.rotator1 && !this.end1.isAttached()) {
                hit = this.rotator1;
            } else if (trackerPanel.getSelectedPoint() == this.rotator2 && !this.end2.isAttached()) {
                hit = this.rotator2;
            }
        }
        if (hit == null) {
            Rectangle layoutRect;
            if (this.rotatorDrawShapes[0] != null && trackerPanel.getSelectedPoint() != this.rotator1) {
                this.rotatorDrawShapes[0] = null;
            }
            if (this.rotatorDrawShapes[1] != null && trackerPanel.getSelectedPoint() != this.rotator2) {
                this.rotatorDrawShapes[1] = null;
            }
            if ((layoutRect = this.panelLayoutBounds.get(trackerPanel.getID())) != null && layoutRect.intersects(hitRect)) {
                drawOutline = true;
                hit = this.tape;
                this.drawLayout = true;
            }
            if (hit == null && this.tape.ruler != null && this.tape.ruler.isVisible()) {
                hit = this.tape.ruler.findInteractive(trackerPanel, hitRect);
            }
        } else if ((hit == this.rotator1 || hit == this.rotator2) && trackerPanel.getSelectedPoint() != hit && this.footprint != null) {
            ((Rotator)hit).setScreenCoords(xpix, ypix);
            int index = hit == this.rotator1 ? 0 : 1;
            this.rotatorDrawShapes[index] = ((LineFootprint)this.footprint).getRotatorShape(this.middle.getScreenPosition(trackerPanel), this.getRotatorLocation(index, trackerPanel), null);
        }
        if (drawOutline != this.drawLayoutBounds) {
            this.drawLayoutBounds = drawOutline;
        }
        if (this.end1.isAttached() && (hit == this.end1 || hit == this.rotator1) || this.end2.isAttached() && (hit == this.end2 || hit == this.rotator2)) {
            return null;
        }
        return hit;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics _g) {
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        Graphics2D g = (Graphics2D)_g;
        this.getMark(trackerPanel).draw(g, false);
        Paint gpaint = g.getPaint();
        g.setPaint(this.footprint.getColor());
        if (!this.tape.editing && (this.drawLayout || trackerPanel.getSelectedTrack() == this.tape)) {
            OSPRuntime.TextLayout layout = this.panelTextLayouts.get(trackerPanel.getID());
            Rectangle bounds = this.panelLayoutBounds.get(trackerPanel.getID());
            Font gfont = g.getFont();
            g.setFont(TFrame.textLayoutFont);
            layout.draw(g, bounds.x, bounds.y + bounds.height);
            g.setFont(gfont);
            if (this.drawLayoutBounds && this.tape.isFieldsEnabled()) {
                g.drawRect(bounds.x - 2, bounds.y - 3, bounds.width + 6, bounds.height + 5);
            }
        }
        g.setPaint(gpaint);
    }

    @Override
    public TPoint getDefaultPoint() {
        if (this.tape.isIncomplete) {
            return this.points[1];
        }
        TPoint p = this.tape.tp.getSelectedPoint();
        if (p == this.points[0]) {
            return this.points[0];
        }
        if (p == this.points[1]) {
            return this.points[1];
        }
        return this.points[this.defaultIndex];
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = (Mark)this.panelMarks.get(trackerPanel.getID());
        if (mark == null) {
            boolean isWorldView = trackerPanel.isWorldPanel();
            if (this.tape.isStickMode() && !this.tape.isIncomplete) {
                this.adjustTipsToLength();
            }
            TPoint selection = trackerPanel.getSelectedPoint();
            final Mark rulerMark = this.tape.ruler != null && this.tape.ruler.isVisible() ? this.tape.ruler.getMark(trackerPanel, this.n) : null;
            Point p = null;
            int i = 0;
            while (i < this.points.length) {
                this.screenPoints[i] = this.points[i].getScreenPosition(trackerPanel);
                if (selection == this.points[i]) {
                    p = this.screenPoints[i];
                }
                ++i;
            }
            if (p == null && this.tape.ruler != null && selection == this.tape.ruler.getHandle()) {
                p = selection.getScreenPosition(trackerPanel);
            }
            if (selection == this.rotator1 || selection == this.rotator2) {
                int index = selection == this.rotator1 ? 0 : 1;
                this.rotatorDrawShapes[index] = ((LineFootprint)this.footprint).getRotatorShape(this.screenPoints[3], this.screenPoints[index], this.screenPoints[4 + index]);
            }
            final Mark tapeMark = this.footprint.getMark(this.screenPoints);
            if (!isWorldView) {
                if (p != null) {
                    transform.setToTranslation(p.x, p.y);
                    int scale = FontSizer.getIntegerFactor();
                    if (scale > 1) {
                        transform.scale(scale, scale);
                    }
                    this.selectedShape = transform.createTransformedShape(selectionShape);
                } else {
                    this.selectedShape = null;
                }
            }
            mark = new Mark(){

                @Override
                public void draw(Graphics2D g, boolean highlighted) {
                    Paint gpaint = g.getPaint();
                    Stroke gstroke = g.getStroke();
                    tapeMark.draw(g, false);
                    if (rulerMark != null) {
                        rulerMark.draw(g, false);
                    }
                    if (TapeStep.this.selectedShape != null) {
                        g.setPaint(TapeStep.this.footprint.getColor());
                        g.setStroke(selectionStroke);
                        g.draw(TapeStep.this.selectedShape);
                    }
                    int i = 0;
                    while (i < TapeStep.this.rotatorDrawShapes.length) {
                        if (TapeStep.this.rotatorDrawShapes[i] != null && !TapeStep.this.tape.isLocked()) {
                            g.setColor(TapeStep.this.tape.getColor());
                            TapeStep.this.rotatorDrawShapes[i].draw(g);
                        }
                        ++i;
                    }
                    g.setStroke(gstroke);
                    g.setPaint(gpaint);
                }
            };
            this.panelMarks.put(trackerPanel.getID(), mark);
            Shape[] shapes = this.footprint.getHitShapes();
            this.panelEnd1Shapes.put(trackerPanel.getID(), shapes[0]);
            this.panelEnd2Shapes.put(trackerPanel.getID(), shapes[1]);
            this.panelShaftShapes.put(trackerPanel.getID(), shapes[2]);
            if (shapes.length > 4 && shapes[3] != null && shapes[4] != null) {
                this.panelRotatorShapes.put(trackerPanel.getID(), new Shape[]{shapes[3], shapes[4]});
            }
            double tapeLength = this.getTapeLength(!this.tape.isStickMode() || this.tape.isIncomplete);
            if (this.tape.calibrationLength != null) {
                tapeLength = this.tape.calibrationLength;
            }
            String s = this.tape.getFormattedLength(tapeLength);
            s = String.valueOf(s) + trackerPanel.getUnits(this.tape, TapeMeasure.dataVariables[1]);
            OSPRuntime.TextLayout layout = new OSPRuntime.TextLayout(s, TFrame.textLayoutFont);
            this.panelTextLayouts.put(trackerPanel.getID(), layout);
            Rectangle2D rect = layout.getBounds();
            p = this.getLayoutPosition(trackerPanel, rect);
            Rectangle bounds = this.panelLayoutBounds.get(trackerPanel.getID());
            if (bounds == null) {
                bounds = new Rectangle();
                this.panelLayoutBounds.put(trackerPanel.getID(), bounds);
            }
            bounds.setRect(p.x, (double)p.y - rect.getHeight(), rect.getWidth(), rect.getHeight());
        }
        return mark;
    }

    public double getTapeLength(boolean fromEnds) {
        double scaleX = 1.0;
        double scaleY = 1.0;
        double axisTiltAngle = 0.0;
        if (this.tape.tp != null) {
            scaleX = this.tape.tp.getCoords().getScaleX(this.n);
            scaleY = this.tape.tp.getCoords().getScaleY(this.n);
            axisTiltAngle = this.tape.tp.getCoords().getAngle(this.n);
        }
        double dx = (this.end2.getX() - this.end1.getX()) / scaleX;
        double dy = (this.end1.getY() - this.end2.getY()) / scaleY;
        this.tapeAngle = Math.atan2(dy, dx);
        this.xAxisToTapeAngle = this.tapeAngle - axisTiltAngle;
        if (Double.isNaN(this.xAxisToTapeAngle)) {
            this.xAxisToTapeAngle = 0.0;
        }
        this.tape.angleField.setValue(this.xAxisToTapeAngle);
        double length = fromEnds ? Math.sqrt(dx * dx + dy * dy) : this.worldLength;
        this.tape.magField.setValue(length);
        this.tape.pixelLengthField.setValue(1.0 / scaleX);
        return length;
    }

    public double getTapeAngle() {
        return this.xAxisToTapeAngle;
    }

    public void setTapeLength(double length) {
        if (this.tape.isLocked() || this.tape.tp == null) {
            return;
        }
        length = Math.abs(length);
        length = Math.max(length, 1.0E-30);
        double factor = this.getTapeLength(!this.tape.isStickMode()) / length;
        if (factor == 1.0 || factor == 0.0 || Double.isInfinite(factor) || Double.isNaN(factor)) {
            return;
        }
        XMLControlElement trackControl = new XMLControlElement(this.tape);
        if (this.tape.isReadOnly()) {
            this.worldLength = length;
            this.adjustTipsToLength();
            this.tape.repaintStep(this);
            Undo.postTrackEdit(this.tape, trackControl);
            return;
        }
        if (this.tape.isStickMode()) {
            if (this.tape.isFixedLength()) {
                TapeStep step = (TapeStep)this.tape.steps.getStep(0);
                step.worldLength = length;
            } else {
                this.tape.lengthKeyFrames.add(this.n);
                this.worldLength = length;
            }
        }
        ImageCoordSystem coords = this.tape.tp.getCoords();
        double scaleX = factor * coords.getScaleX(this.n);
        double scaleY = factor * coords.getScaleY(this.n);
        XMLControlElement coordsControl = new XMLControlElement(this.tape.tp.getCoords());
        this.tape.isStepChangingScale = true;
        coords.setScaleXY(this.n, scaleX, scaleY);
        this.tape.isStepChangingScale = false;
        if (this.tape.isStickMode()) {
            Undo.postTrackAndCoordsEdit(this.tape, trackControl, coordsControl);
        } else {
            Undo.postCoordsEdit(this.tape.tp, coordsControl);
        }
        this.erase();
    }

    public void setTapeAngle(double theta) {
        if (this.tape.isLocked() || this.tape.tp == null) {
            return;
        }
        if (this.tape.isReadOnly()) {
            XMLControlElement trackControl = new XMLControlElement(this.tape);
            this.xAxisToTapeAngle = theta;
            this.adjustTipsToAngle(null);
            this.tape.repaintStep(this);
            Undo.postTrackEdit(this.tape, trackControl);
            return;
        }
        double dTheta = theta - this.xAxisToTapeAngle;
        ImageCoordSystem coords = this.tape.tp.getCoords();
        XMLControlElement state = new XMLControlElement(coords);
        double angle = coords.getAngle(this.n);
        coords.setAngle(this.n, angle - dTheta);
        Undo.postCoordsEdit(this.tape.tp, state);
        this.xAxisToTapeAngle = theta;
    }

    private void setTapeAngle(double theta, TPoint p) {
        if (this.tape.isLocked() || this.tape.tp == null) {
            return;
        }
        this.xAxisToTapeAngle = theta;
        this.adjustTipsToAngle(p);
        this.tape.repaintStep(this);
    }

    @Override
    public Object clone() {
        TapeStep step = (TapeStep)super.clone();
        if (step != null) {
            TPoint[] tPointArray = step.points;
            TapeStep tapeStep = step;
            tapeStep.getClass();
            tPointArray[0] = step.end1 = tapeStep.new Tip(this.end1.getX(), this.end1.getY());
            TPoint[] tPointArray2 = step.points;
            TapeStep tapeStep2 = step;
            tapeStep2.getClass();
            tPointArray2[1] = step.end2 = tapeStep2.new Tip(this.end2.getX(), this.end2.getY());
            TPoint[] tPointArray3 = step.points;
            TapeStep tapeStep3 = step;
            tapeStep3.getClass();
            step.handle = tapeStep3.new Handle(this.handle.getX(), this.handle.getY());
            tPointArray3[2] = step.handle;
            step.points[3] = step.middle = new TPoint(this.middle.getX(), this.middle.getY());
            step.rotator1 = step.new Rotator();
            step.points[4] = step.rotator1;
            step.rotator2 = step.new Rotator();
            step.points[5] = step.rotator2;
            step.end1.setTrackEditTrigger(true);
            step.end2.setTrackEditTrigger(true);
            step.handle.setTrackEditTrigger(true);
            step.panelEnd1Shapes = new HashMap<Integer, Shape>();
            step.panelEnd2Shapes = new HashMap<Integer, Shape>();
            step.panelShaftShapes = new HashMap<Integer, Shape>();
            step.panelRotatorShapes = new HashMap<Integer, Shape[]>();
            step.panelTextLayouts = new HashMap<Integer, OSPRuntime.TextLayout>();
            step.panelLayoutBounds = new HashMap<Integer, Rectangle>();
            step.worldLength = this.worldLength;
        }
        return step;
    }

    @Override
    public String toString() {
        return "TapeStep " + this.n + " [" + format.format(this.end1.x) + ", " + format.format(this.end1.y) + ", " + format.format(this.end2.x) + ", " + format.format(this.end2.y) + "]";
    }

    public static int getLength() {
        return 6;
    }

    protected void adjustTipsToLength() {
        if (this.adjustingTips) {
            return;
        }
        this.adjustingTips = true;
        double sin = this.end1.sin(this.end2);
        double cos = this.end1.cos(this.end2);
        double d = this.end1.distance(this.end2);
        double factor = this.worldLength / this.getTapeLength(true);
        if (d == 0.0) {
            sin = 0.0;
            cos = 1.0;
            d = 1.0;
            double scaleX = this.tape.tp.getCoords().getScaleX(this.n);
            factor = this.worldLength * scaleX;
        }
        TPoint p = this.tape.tp.getSelectedPoint();
        if (this.end1.isAttached()) {
            p = this.end1;
        } else if (this.end2.isAttached()) {
            p = this.end2;
        }
        if (p instanceof Tip) {
            if (p == this.end1) {
                double x = this.end1.getX() + cos * d * factor;
                double y = this.end1.getY() - sin * d * factor;
                this.end2.setLocation(x, y);
            } else {
                double x = this.end2.getX() - cos * d * factor;
                double y = this.end2.getY() + sin * d * factor;
                this.end1.setLocation(x, y);
            }
        } else if (p == this.handle) {
            Point screenPt = this.handle.getScreenPosition(this.tape.tp);
            this.handle.setPositionOnLine(screenPt.x, screenPt.y, this.tape.tp);
            d = this.handle.distance(this.end1);
            if (d == 0.0) {
                d = 0.5;
            }
            double x = this.handle.getX() - cos * d * factor;
            double y = this.handle.getY() + sin * d * factor;
            this.end1.setLocation(x, y);
            d = this.handle.distance(this.end2);
            if (d == 0.0) {
                d = 0.5;
            }
            x = this.handle.getX() + cos * d * factor;
            y = this.handle.getY() - sin * d * factor;
            this.end2.setLocation(x, y);
        } else {
            this.middle.center(this.end1, this.end2);
            double x1 = this.middle.getX() - cos * d * factor / 2.0;
            double y1 = this.middle.getY() + sin * d * factor / 2.0;
            double x2 = this.middle.getX() + cos * d * factor / 2.0;
            double y2 = this.middle.getY() - sin * d * factor / 2.0;
            this.end1.setLocation(x1, y1);
            this.end2.setLocation(x2, y2);
        }
        this.adjustingTips = false;
    }

    protected void adjustTipsToAngle(TPoint p) {
        if (this.adjustingTips) {
            return;
        }
        if (this.end1.isAttached() && this.end2.isAttached()) {
            return;
        }
        this.adjustingTips = true;
        if (this.end1.isAttached()) {
            p = this.end1;
        }
        if (this.end2.isAttached()) {
            p = this.end2;
        }
        if (p == null) {
            p = this.tape.tp.getSelectedPoint();
        }
        double axisTiltAngle = this.tape.tp.getCoords().getAngle(this.n);
        this.tapeAngle = this.xAxisToTapeAngle + axisTiltAngle;
        double sin = Math.sin(this.tapeAngle);
        double cos = Math.cos(this.tapeAngle);
        double d = this.end1.distance(this.end2);
        if (p == this.end1) {
            double x = this.end1.getX() + cos * d;
            double y = this.end1.getY() - sin * d;
            this.end2.setLocation(x, y);
            this.repaint();
        } else if (p == this.end2) {
            double x = this.end2.getX() - cos * d;
            double y = this.end2.getY() + sin * d;
            this.end1.setLocation(x, y);
        } else if (p == this.handle || p == this.rotator1 || p == this.rotator2) {
            double d1 = p.distance(this.end1);
            double d2 = p.distance(this.end2);
            if (d1 <= d && d2 <= d) {
                this.end1.setLocation(p.getX() - cos * d1, p.getY() + sin * d1);
                this.end2.setLocation(p.getX() + cos * d2, p.getY() - sin * d2);
            } else if (d1 > d) {
                this.end1.setLocation(p.getX() - cos * d1, p.getY() + sin * d1);
                this.end2.setLocation(p.getX() - cos * d2, p.getY() + sin * d2);
            } else {
                this.end1.setLocation(p.getX() + cos * d1, p.getY() - sin * d1);
                this.end2.setLocation(p.getX() + cos * d2, p.getY() - sin * d2);
            }
        } else {
            this.middle.center(this.end1, this.end2);
            double x1 = this.middle.getX() - cos * d / 2.0;
            double y1 = this.middle.getY() + sin * d / 2.0;
            double x2 = this.middle.getX() + cos * d / 2.0;
            double y2 = this.middle.getY() - sin * d / 2.0;
            this.end1.setLocation(x1, y1);
            this.end2.setLocation(x2, y2);
        }
        this.adjustingTips = false;
    }

    private Point getLayoutPosition(TrackerPanel trackerPanel, Rectangle2D bounds) {
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        endPoint1.setLocation(this.end1);
        endPoint2.setLocation(this.end2);
        if (!trackerPanel.isDrawingInImageSpace()) {
            AffineTransform at = trackerPanel.getCoords().getToWorldTransform(this.n);
            at.transform(endPoint1, endPoint1);
            TapeStep.endPoint1.y = -TapeStep.endPoint1.y;
            at.transform(endPoint2, endPoint2);
            TapeStep.endPoint2.y = -TapeStep.endPoint2.y;
        }
        double cos = endPoint1.cos(endPoint2);
        double sin = endPoint1.sin(endPoint2);
        double halfwsin = w * sin / 2.0;
        double halfhcos = h * cos / 2.0;
        double d = Math.sqrt(halfwsin * halfwsin + halfhcos * halfhcos) + 8.0;
        this.middle.center(this.end1, this.end2);
        Point p = this.middle.getScreenPosition(trackerPanel);
        if (this.tape.ruler != null && this.tape.ruler.isVisible() && this.tape.ruler.getRulerSize() > 0.0) {
            p.setLocation((int)((double)p.x + d * sin - w / 2.0), (int)((double)p.y + d * cos + h / 2.0));
        } else {
            p.setLocation((int)((double)p.x - d * sin - w / 2.0), (int)((double)p.y - d * cos + h / 2.0));
        }
        return p;
    }

    private Point getRotatorLocation(int i, TrackerPanel trackerPanel) {
        Shape[] rotatorHitShapes = this.panelRotatorShapes.get(trackerPanel.getID());
        Rectangle bounds = rotatorHitShapes[i].getBounds();
        return new Point((int)bounds.getCenterX(), (int)bounds.getCenterY());
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    class Handle
    extends Step.Handle {
        public Handle(double x, double y) {
            super(x, y);
        }

        @Override
        public void setXY(double x, double y) {
            if (TapeStep.this.getTrack().locked) {
                return;
            }
            if (TapeStep.this.end1.isAttached() || TapeStep.this.end2.isAttached()) {
                return;
            }
            double dx = x - this.getX();
            double dy = y - this.getY();
            this.setLocation(x, y);
            if (TapeStep.this.tape.isFixedPosition()) {
                TapeStep step = (TapeStep)TapeStep.this.tape.steps.getStep(0);
                step.end1.setLocation(TapeStep.this.end1.getX() + dx, TapeStep.this.end1.getY() + dy);
                step.end2.setLocation(TapeStep.this.end2.getX() + dx, TapeStep.this.end2.getY() + dy);
                step.erase();
                TapeStep.this.tape.refreshStep(TapeStep.this);
            } else {
                TapeStep.this.end1.setLocation(TapeStep.this.end1.getX() + dx, TapeStep.this.end1.getY() + dy);
                TapeStep.this.end2.setLocation(TapeStep.this.end2.getX() + dx, TapeStep.this.end2.getY() + dy);
                TapeStep.this.tape.keyFrames.add(TapeStep.this.n);
            }
            TapeStep.this.repaint();
        }

        @Override
        public int getFrameNumber(VideoPanel vidPanel) {
            return TapeStep.this.n;
        }

        @Override
        public void setPositionOnLine(int xScreen, int yScreen, TrackerPanel trackerPanel) {
            this.setPositionOnLine(xScreen, yScreen, trackerPanel, TapeStep.this.end1, TapeStep.this.end2);
            TapeStep.this.repaint();
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            TapeStep step = (TapeStep)obj;
            double[] data = new double[]{step.getEnd1().x, step.getEnd1().y, step.getEnd2().x, step.getEnd2().y};
            control.setValue("end_positions", data);
            control.setValue("worldlength", step.worldLength);
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            TapeStep step = (TapeStep)obj;
            double[] data = (double[])control.getObject("end_positions");
            step.getEnd1().setLocation(data[0], data[1]);
            step.getEnd2().setLocation(data[2], data[3]);
            step.worldLength = control.getDouble("worldlength");
            return obj;
        }
    }

    class Rotator
    extends TPoint {
        TPoint pt = new TPoint();

        public Rotator() {
            this.setTrackEditTrigger(true);
        }

        @Override
        public void setXY(double x, double y) {
            if (TapeStep.this.getTrack().locked) {
                return;
            }
            this.setLocation(x, y);
            if (TapeStep.this.tape.isFixedPosition()) {
                TapeStep step = (TapeStep)TapeStep.this.tape.steps.getStep(0);
                Rotator rotator = this == TapeStep.this.rotator1 ? step.rotator1 : step.rotator2;
                rotator.setLocation(x, y);
                double theta = this == TapeStep.this.rotator1 ? rotator.angle(step.end2) : step.end1.angle(rotator);
                step.setTapeAngle(-(theta += TapeStep.this.tape.tp.getCoords().getAngle(0)), this == TapeStep.this.rotator1 ? step.end2 : step.end1);
                step.erase();
            } else {
                double theta = this == TapeStep.this.rotator1 ? this.angle(TapeStep.this.end2) : TapeStep.this.end1.angle(this);
                TapeStep.this.setTapeAngle(-(theta += TapeStep.this.tape.tp.getCoords().getAngle(TapeStep.this.n)), this == TapeStep.this.rotator1 ? TapeStep.this.end2 : TapeStep.this.end1);
                TapeStep.this.tape.keyFrames.add(TapeStep.this.n);
            }
            TapeStep.this.erase();
            TapeStep.this.tape.invalidateData(TapeStep.this.tape);
        }

        @Override
        public int getFrameNumber(VideoPanel vidPanel) {
            return TapeStep.this.n;
        }

        @Override
        public void setAdjusting(boolean adjusting, MouseEvent e) {
            boolean wasAdjusting = this.isAdjusting();
            super.setAdjusting(adjusting, e);
            if (wasAdjusting && !adjusting) {
                if (TapeStep.this.tape.isFixedPosition()) {
                    TapeStep.this.tape.fireStepsChanged();
                } else {
                    TapeStep.this.tape.firePropertyChange("step", null, new Integer(TapeStep.this.n));
                }
            }
        }

        protected void setScreenCoords(int x, int y) {
            this.pt.setScreenPosition(x, y, TapeStep.this.tape.tp);
            this.setLocation(this.pt);
        }
    }

    class Tip
    extends TPoint {
        public Tip(double x, double y) {
            super(x, y);
        }

        @Override
        public void setXY(double x, double y) {
            if (TapeStep.this.getTrack().locked) {
                return;
            }
            if (x == this.prevX && y == this.prevY) {
                return;
            }
            if (TapeStep.this.tape.isStickMode() && this.isAdjusting()) {
                this.prevX = x;
                this.prevY = y;
            }
            if (TapeStep.this.tape.isFixedPosition()) {
                TapeStep step = (TapeStep)TapeStep.this.tape.steps.getStep(0);
                if (this == TapeStep.this.end1) {
                    step.end1.setLocation(x, y);
                    step.end2.setLocation(TapeStep.this.end2);
                } else {
                    step.end2.setLocation(x, y);
                    step.end1.setLocation(TapeStep.this.end1);
                }
                step.erase();
                TapeStep.this.tape.refreshStep(TapeStep.this);
            } else {
                this.setLocation(x, y);
                TapeStep.this.tape.keyFrames.add(TapeStep.this.n);
            }
            if (TapeStep.this.tape.isStickMode() && TapeStep.this.worldLength > 0.0) {
                ImageCoordSystem coords = TapeStep.this.tape.tp.getCoords();
                coords.setAdjusting(this.isAdjusting());
                double newLength = TapeStep.this.getTapeLength(true);
                double factor = newLength / TapeStep.this.getTapeLength(false);
                double scaleX = factor * coords.getScaleX(TapeStep.this.n);
                double scaleY = factor * coords.getScaleY(TapeStep.this.n);
                TapeStep.this.tape.isStepChangingScale = true;
                TapeStep.this.tape.tp.getCoords().setScaleXY(TapeStep.this.n, scaleX, scaleY);
                TapeStep.this.tape.isStepChangingScale = false;
            }
            TapeStep.this.tape.invalidateData(TapeStep.this.tape);
            TapeStep.this.repaint();
        }

        @Override
        public int getFrameNumber(VideoPanel vidPanel) {
            return TapeStep.this.n;
        }

        @Override
        public void setAdjusting(boolean adjusting, MouseEvent e) {
            boolean wasAdjusting = this.isAdjusting();
            if (TapeStep.this.tape.isStickMode()) {
                super.setAdjusting(adjusting, e);
                if (wasAdjusting && !adjusting && !Double.isNaN(this.prevX)) {
                    this.setXY(this.prevX, this.prevY);
                }
            } else {
                super.setAdjusting(adjusting, e);
            }
            if (wasAdjusting && !adjusting) {
                if (TapeStep.this.tape.isFixedPosition()) {
                    TapeStep.this.tape.fireStepsChanged();
                } else {
                    TapeStep.this.tape.firePropertyChange("step", null, new Integer(TapeStep.this.n));
                }
            }
        }

        @Override
        public boolean isCoordsEditTrigger() {
            return TapeStep.this.tape.isStickMode();
        }
    }
}

